/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class ChM {
    public static final int ANC_TOPLEFT = 20;
    public static final int ANC_TOP = 17;
    public static final int ANC_TOPRIGHT = 24;
    public static final int ANC_LEFT = 6;
    public static final int ANC_CENTER = 3;
    public static final int ANC_RIGHT = 10;
    public static final int ANC_BOTTOMLEFT = 36;
    public static final int ANC_BOTTOM = 33;
    public static final int ANC_BOTTOMRIGHT = 40;
    private static short[] mSubimageImg;
    private static byte[] mSubimageX;
    private static byte[] mSubimageY;
    private static short[] mSubimageW;
    private static short[] mSubimageH;
    public static short[] frame_start;
    public static short[] part_sub;
    public static short[] part_x;
    public static short[] part_y;
    public static short[] anim_start;
    public static short[] anim_entry;
    public static Image[] img;
    public static final int SHIFT_PART_TYPE = 13;
    public static final int MASK_PART_ID = 8191;
    public static int iAnimationIndex;
    public static final int ANIMATION_SPEED = 10;

    public static void loadChMData(String name) throws Exception {
        DataInputStream dis = Dev.getFile(name);
        short n = dis.readShort();
        System.out.println("Sub cnt " + n);
        mSubimageImg = Dev.readShortArray(dis, n);
        mSubimageX = Dev.readByteArray(dis, n);
        mSubimageY = Dev.readByteArray(dis, n);
        mSubimageW = Dev.readShortArray(dis, n);
        mSubimageH = Dev.readShortArray(dis, n);
        n = dis.readShort();
        System.out.println("Frame cnt " + n);
        frame_start = Dev.readShortArray(dis, n);
        n = dis.readShort();
        part_sub = Dev.readShortArray(dis, n);
        part_x = Dev.readShortArray(dis, n);
        part_y = Dev.readShortArray(dis, n);
        n = dis.readShort();
        System.out.println("Anim cnt " + n);
        anim_start = Dev.readShortArray(dis, n);
        n = dis.readShort();
        anim_entry = Dev.readShortArray(dis, n);
        dis.close();
        img = new Image[61];
        boolean isCreate = false;
    }

    public static void renderImage(Graphics a_g, int a_iImageId, int a_iX, int a_iY, int a_iAnchor, int[] a_rcClip) {
        Image image = img[a_iImageId];
        Dev.setClip(a_g, a_rcClip);
        a_g.clipRect(a_iX += Dev.getAnchorX(image.getWidth(), a_iAnchor), a_iY += Dev.getAnchorY(image.getHeight(), a_iAnchor), image.getWidth(), image.getHeight());
        if ((a_g.getClipWidth() | a_g.getClipWidth()) > 0) {
            a_g.drawImage(image, a_iX, a_iY, 0);
        }
    }

    public static void renderImage(Graphics a_g, Image a_imImageId, int a_iX, int a_iY, int a_iAnchor, int[] a_rcClip) {
        if (a_imImageId == null) {
            return;
        }
        Dev.setClip(a_g, a_rcClip);
        a_g.clipRect(a_iX += Dev.getAnchorX(a_imImageId.getWidth(), a_iAnchor), a_iY += Dev.getAnchorY(a_imImageId.getHeight(), a_iAnchor), a_imImageId.getWidth(), a_imImageId.getHeight());
        if ((a_g.getClipWidth() | a_g.getClipWidth()) > 0) {
            a_g.drawImage(a_imImageId, a_iX, a_iY, 0);
        }
    }

    public static boolean subCorrect(int a_iSubImageId) {
        return mSubimageImg.length < a_iSubImageId;
    }

    public static short getSubImageX(int a_iSubImageId) {
        return Dev.fromByte(mSubimageX[a_iSubImageId]);
    }

    public static short getSubImageY(int a_iSubImageId) {
        return Dev.fromByte(mSubimageY[a_iSubImageId]);
    }

    public static short getSubImageWidth(int a_iSubImageId) {
        return (short)(mSubimageW[a_iSubImageId] & 0xFFFF);
    }

    public static short getSubImageHeight(int a_iSubImageId) {
        return (short)(mSubimageH[a_iSubImageId] & 0xFFFF);
    }

    public static int getSubImage(int a_iSubImageId) {
        return mSubimageImg[a_iSubImageId] & 0x1FFF;
    }

    public static int getSubImageFlip(int a_iSubImageId) {
        return mSubimageImg[a_iSubImageId] >> 13;
    }

    public static void renderSubImage(Graphics aG, int aId, int aX, int aY, int a_iAnchor, int[] a_rcClip, boolean flipped) {
        if (aId == -1) {
            return;
        }
        short _subX = ChM.getSubImageX(aId);
        short _subY = ChM.getSubImageY(aId);
        short _subW = ChM.getSubImageWidth(aId);
        short _subH = ChM.getSubImageHeight(aId);
        aX += Dev.getAnchorX(_subW, a_iAnchor);
        aY += Dev.getAnchorY(_subH, a_iAnchor);
        if (a_rcClip == null) {
            aG.setClip(aX, aY, (int)_subW, (int)_subH);
        } else {
            Dev.setClip(aG, a_rcClip);
            aG.clipRect(aX, aY, (int)_subW, (int)_subH);
        }
        int _imgId = ChM.getSubImage(aId) + (flipped ? 0 : 0);
        int _flip = ChM.getSubImageFlip(aId);
        if ((aG.getClipWidth() | aG.getClipWidth()) > 0) {
            try {
                aG.drawRegion(img[_imgId], (int)_subX, (int)_subY, (int)_subW, (int)_subH, flipped ? _flip ^ 2 : _flip, aX, aY, 20);
            }
            catch (Exception e) {
                System.out.println("imid = " + _imgId);
                System.out.println("subid = " + aId);
                e.printStackTrace();
            }
        }
    }

    private static int getFlip(int subImageFlip) {
        return subImageFlip << 13;
    }

    public static void renderFrameImage(Graphics g, int aId, int aX, int aY, boolean flipped, int[] a_rcClip) {
        if (aId == -1) {
            return;
        }
        short frameEnd = frame_start[aId + 1];
        for (int part = frame_start[aId]; part < frameEnd; ++part) {
            g.setClip(a_rcClip[0], a_rcClip[1], a_rcClip[2] - a_rcClip[0], a_rcClip[3] - a_rcClip[1]);
            int partx = aX + part_x[part];
            int party = aY + part_y[part];
            int sub = part_sub[part] & 0x1FFF;
            int type = part_sub[part] >> 13;
            if (type == 0) {
                short _w = ChM.getSubImageWidth(sub);
                if (flipped) {
                    partx = aX - part_x[part] - _w;
                }
                ChM.renderSubImage(g, sub, partx, party, 20, a_rcClip, flipped);
                continue;
            }
            if (type == 1) {
                ChM.renderFrameImage(g, sub, partx, party, flipped, a_rcClip);
                continue;
            }
            if (type != 2) continue;
            ChM.renderAnimImage(g, sub, partx, party, 0, flipped, a_rcClip);
        }
    }

    public static void renderAnimFrame(Graphics g, int aId, int aX, int aY, boolean flipped, int[] a_rcClip) {
        if (aId == -1) {
            return;
        }
        short frameEnd = frame_start[aId + 1];
        for (int part = frame_start[aId]; part < frameEnd; ++part) {
            g.setClip(a_rcClip[0], a_rcClip[1], a_rcClip[2] - a_rcClip[0], a_rcClip[3] - a_rcClip[1]);
            int partx = aX + part_x[part];
            int party = aY + part_y[part];
            int sub = part_sub[part] & 0x1FFF;
            int type = part_sub[part] >> 13;
            if (type == 0) {
                short _w = ChM.getSubImageWidth(sub);
                if (flipped) {
                    partx = aX - part_x[part] - _w;
                }
                ChM.renderSubImage(g, sub, partx, party, 3, a_rcClip, flipped);
                continue;
            }
            if (type == 1) {
                ChM.renderAnimFrame(g, sub, partx, party, flipped, a_rcClip);
                continue;
            }
            if (type != 2) continue;
            ChM.renderAnimImage(g, sub, partx, party, 0, flipped, a_rcClip);
        }
    }

    public static int[] getFrameRect(int a_iFrameImageId) {
        if (a_iFrameImageId == -1) {
            return null;
        }
        int[] rect = new int[4];
        short frameEnd = frame_start[a_iFrameImageId + 1];
        for (int part = frame_start[a_iFrameImageId]; part < frameEnd; ++part) {
            int sub = part_sub[part] & 0x1FFF;
            int type = part_sub[part] >> 13;
            int subImageX = part_x[part];
            int subImageY = part_y[part];
            int subImageWidth = 0;
            int subImageHeight = 0;
            if (type == 0) {
                subImageWidth = ChM.getSubImageWidth(sub);
                subImageHeight = ChM.getSubImageHeight(sub);
            } else if (type == 1) {
                int[] __rect = ChM.getFrameRect(sub);
                subImageX += __rect[0];
                subImageY += __rect[1];
                subImageWidth = __rect[2] - __rect[0];
                subImageHeight = __rect[3] - __rect[1];
            }
            if (part == frame_start[a_iFrameImageId]) {
                rect[0] = subImageX;
                rect[1] = subImageY;
                rect[2] = subImageX + subImageWidth;
                rect[3] = subImageY + subImageHeight;
                continue;
            }
            if (rect[0] > subImageX) {
                rect[0] = subImageX;
            }
            if (rect[1] > subImageY) {
                rect[1] = subImageY;
            }
            if (rect[2] < subImageX + subImageWidth) {
                rect[2] = subImageX + subImageWidth;
            }
            if (rect[3] >= subImageY + subImageHeight) continue;
            rect[3] = subImageY + subImageHeight;
        }
        return rect;
    }

    public static void renderAnimImage(Graphics g, int id_anim_img, int x, int y, int anim_ind, boolean flipped, int[] RC_SCR) {
        ChM.renderAnimImage(g, id_anim_img, x, y, anim_ind, 10, flipped, RC_SCR);
    }

    public static void renderAnimImage(Graphics g, int id_anim_img, int x, int y, int anim_ind, int delay, boolean flipped, int[] RC_SCR) {
        int _animStart = ChM.getFirstInAnim(id_anim_img);
        int _animLength = ChM.getCntInAnim(id_anim_img);
        int _shift = (iAnimationIndex - anim_ind) / delay % _animLength;
        int _curPart = _animStart + _shift;
        short _part = anim_entry[_curPart];
        int _ind = _part & 0x1FFF;
        int _type = _part >> 13;
        if (_type == 1) {
            ChM.renderFrameImage(g, _ind, x, y, flipped, RC_SCR);
        } else if (_type == 2) {
            ChM.renderAnimImage(g, _ind, x, y, 0, flipped, RC_SCR);
        }
    }

    public static final int getCntInAnim(int animImgInd) {
        int _animStart = ChM.getFirstInAnim(animImgInd);
        return ChM.getFirstInAnim(animImgInd + 1) - _animStart;
    }

    private static final int getFirstInAnim(int animImgInd) {
        return anim_start[animImgInd];
    }

    public static final int getFirstAnimFrame(int animImgInd) {
        return anim_entry[ChM.getFirstInAnim(animImgInd)] & 0x1FFF;
    }

    public static final boolean isAnimationFinished(int animImg, int animInd) {
        int _cnt = ChM.getCntInAnim(animImg);
        return Dev.abs(iAnimationIndex - animInd) >= _cnt * 10;
    }

    public static boolean setClip(Graphics g, int x, int y, int w, int h) {
        if (x > Menu.W || y > Menu.H || x + w < 0 || y + h < 0) {
            return false;
        }
        g.setClip(x, y, w, h);
        return true;
    }

    static {
        iAnimationIndex = 0;
    }
}

