/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class BoxFont {
    private Image glyphs;
    private int glyphs_std;
    private int glyphs_extra;
    private int glyphs_all;
    private byte[] gwidth;
    private byte[] cwidth;
    private byte[] heights;
    private byte[] offsets;
    private byte[] xpos;
    private byte[] ypos;
    private char[] extend_map;
    private int line_spacing;
    private int char_spacing;
    private int chars_extend;
    private static long[] png_laCRC = new long[256];
    private Random random;
    private int typeOfFont;
    private int clipX;
    private int clipY;
    private int clipW;
    private int clipH;
    private int clipR;
    private int clipB;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BoxFont(String string) {
        block13: {
            this.extend_map = null;
            this.random = new Random();
            this.typeOfFont = -1;
            String string2 = string;
            BoxFont boxFont = this;
            InputStream inputStream = null;
            try {
                inputStream = "".getClass().getResourceAsStream(string2 + ".hf");
                boxFont.readBin(inputStream);
            }
            catch (Exception exception) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    break block13;
                }
                catch (IOException iOException) {}
                break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (this.typeOfFont != 2) return;
        try {
            this.glyphs = Image.createImage((String)(string + ".png"));
        }
        catch (Exception exception) {
            String cfr_ignored_0 = "createImage " + string + " Exception " + exception;
        }
        String cfr_ignored_1 = "Loading Font: " + string;
    }

    private void readBin(InputStream inputStream) throws Exception {
        inputStream.read();
        int n = 0;
        inputStream.read();
        n = inputStream.read() & 0xFF;
        this.typeOfFont = n >> 5;
        this.char_spacing = inputStream.read();
        this.line_spacing = inputStream.read();
        this.glyphs_std = inputStream.read();
        this.glyphs_extra = inputStream.read();
        this.glyphs_all = this.glyphs_std + this.glyphs_extra;
        this.chars_extend = inputStream.read();
        this.extend_map = new char[this.chars_extend << 1];
        byte[] byArray = new byte[this.chars_extend << 2];
        inputStream.read(byArray);
        this.xpos = new byte[this.glyphs_all];
        inputStream.read(this.xpos, 0, this.glyphs_all);
        this.ypos = new byte[this.glyphs_all];
        inputStream.read(this.ypos, 0, this.glyphs_all);
        this.heights = new byte[this.glyphs_all];
        inputStream.read(this.heights, 0, this.glyphs_all);
        this.gwidth = new byte[this.glyphs_all + this.chars_extend];
        inputStream.read(this.gwidth, 0, this.glyphs_all);
        this.offsets = new byte[this.glyphs_all];
        inputStream.read(this.offsets, 0, this.glyphs_all);
        int n2 = 0;
        n = this.glyphs_all;
        int n3 = 0;
        while (n2 < this.chars_extend << 1) {
            char c = (char)((byArray[n3++] & 0xFF) << 8 | byArray[n3++] & 0xFF);
            byte by = byArray[n3++];
            byte by2 = byArray[n3++];
            this.gwidth[n++] = (byte)(Math.max(this.getWidth(by), this.getWidth(by2)) - this.char_spacing);
            this.extend_map[n2++] = c;
            this.extend_map[n2++] = (char)((by & 0xFF) << 8 | by2 & 0xFF);
        }
        this.cwidth = new byte[255];
        for (n2 = 32; n2 < 128 + this.glyphs_extra + this.chars_extend; ++n2) {
            this.cwidth[n2] = (byte)this.getWidth((byte)n2);
        }
    }

    public final byte[] getFromString(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        byte[] byArray = new byte[n + 4];
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        block0: for (int i = 0; i < n; ++i) {
            if (cArray[i] < '\u0080') {
                if (cArray[i] >= 32 + this.glyphs_std) continue;
                byArray[i + 4] = (byte)(cArray[i] & 0x7F);
                continue;
            }
            cArray[i] = (char)(0xC080 | cArray[i] << 2 & 0x1F00 | cArray[i] & 0x3F);
            for (int j = 0; j < this.chars_extend << 1; j += 2) {
                if (cArray[i] != this.extend_map[j]) continue;
                byArray[i + 4] = (byte)(-128 + (j >> 1) + this.glyphs_extra);
                continue block0;
            }
        }
        return byArray;
    }

    private int getWidth(byte by) {
        if (0 <= by && by < 32) {
            return 0;
        }
        if ((by & 0xFFFFFF80) == 0) {
            if (by - 32 >= this.glyphs_std) {
                return 0;
            }
            return this.gwidth[by - 32] + this.char_spacing;
        }
        return this.gwidth[(by ^ 0xFFFFFF80) + this.glyphs_std] + this.char_spacing;
    }

    public final int stringWidth(String object) {
        if ((object = (Object)this.getFromString((String)object)) == null) {
            return 0;
        }
        int n = 0;
        int n2 = ((Object)object).length;
        if (4 >= n2) {
            return 0;
        }
        for (int i = 4; i < n2 && object[i] != 10 && object[i] != 13; ++i) {
            n += this.cwidth[object[i] & 0xFF];
        }
        return n - this.char_spacing;
    }

    public final int getHeight() {
        return this.line_spacing;
    }

    private int getHeight(byte[] byArray) {
        int n = this.line_spacing;
        int n2 = byArray.length;
        if (4 >= n2) {
            return 0;
        }
        for (int i = 4; i < n2; ++i) {
            if (byArray[i] != 10 && byArray[i] != 13) continue;
            n += this.line_spacing;
        }
        return n;
    }

    public final int doLinebreaks(byte[] byArray, int n) {
        if (byArray == null || byArray.length <= 4) {
            return 0;
        }
        int n2 = 0;
        int n3 = 4;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = byArray.length;
        n6 = ((byArray[0] & 0x7F) << 8) + (byArray[1] & 0xFF);
        if (n6 == n) {
            return byArray[2] & 0xFF;
        }
        if (n6 != 0) {
            do {
                if (byArray[n3] != 13) continue;
                byArray[n3] = 32;
            } while (++n3 < n7);
            n3 = 4;
        }
        while (n3 < n7) {
            n6 = 0;
            while (n6 < n && n3 < n7 && byArray[n3] != 10) {
                n6 += this.cwidth[byArray[n3] & 0xFF];
                if (byArray[n3] == 32) {
                    if (n6 < n) {
                        if (++n3 < n7) {
                            if ("!?;:@/-".indexOf(byArray[n3]) != -1) continue;
                            n5 = n3 - 1;
                            continue;
                        }
                    } else {
                        if (n3 + 1 < n7 && "!?;:@/-".indexOf(byArray[n3 + 1]) != -1) {
                            ++n3;
                            continue;
                        }
                        n5 = n3;
                        break;
                    }
                }
                ++n3;
            }
            if (n6 >= n) {
                if (n5 > n4) {
                    byArray[n5] = 13;
                    n3 = n5;
                } else {
                    while (n3 < n7 && byArray[n3] != 32) {
                        ++n3;
                    }
                    if (n3 < n7) {
                        byArray[n3] = 13;
                        n5 = n3;
                    }
                }
            }
            n4 = n3++;
            ++n2;
        }
        byArray[0] = (byte)(n >> 8);
        byArray[1] = (byte)n;
        byArray[2] = (byte)n2;
        return n2;
    }

    public final int drawString(Graphics graphics, String string, int n, int n2, int n3) {
        return this.drawString(graphics, string, n, n2, n3, false);
    }

    public final int drawString(Graphics graphics, String object, int n, int n2, int n3, boolean bl) {
        if (object == null || ((String)object).length() == 0) {
            return 0;
        }
        object = this.getFromString((String)object);
        return this.drawText(graphics, (byte[])object, n, n2, -1, -1, 0, n3, false) >> 10 & 0x3FF;
    }

    public final int drawStringWrapped(Graphics graphics, String object, int n, int n2, int n3, int n4) {
        boolean bl = false;
        BoxFont boxFont = this;
        if (object == null || ((String)object).length() == 0) {
            return 0;
        }
        object = boxFont.getFromString((String)object);
        boxFont.doLinebreaks((byte[])object, n3);
        return boxFont.drawText(graphics, (byte[])object, n, n2, n3, -1, 0, n4, false);
    }

    public final int drawStringWrapped(Graphics graphics, String object, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (object == null || ((String)object).length() == 0) {
            return 0;
        }
        object = this.getFromString((String)object);
        this.doLinebreaks((byte[])object, n3);
        return this.drawText(graphics, (byte[])object, n, n2, n3, n4, n5, n6, false);
    }

    private int drawText(Graphics graphics, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (byArray == null) {
            return 0;
        }
        int n7 = 4;
        int n8 = byArray.length;
        int n9 = 0;
        int n10 = n2;
        int n11 = 0;
        int n12 = this.line_spacing;
        int n13 = 0;
        if (4 >= n8) {
            return 0;
        }
        if (n6 == 0) {
            n6 = 20;
        }
        if ((n6 & 0x60) != 0) {
            n10 -= this.getHeight(byArray);
        } else if ((n6 & 2) != 0) {
            n10 -= this.getHeight(byArray) >> 1;
        }
        n2 = n10;
        n10 -= n5;
        this.saveClip(graphics);
        if (n3 > 0) {
            n9 = (n6 & 8) != 0 ? n - n3 : ((n6 & 1) != 0 ? n - (n3 >> 1) : n);
            if (n4 > 0) {
                this.mergeClip(graphics, n9, n2, n3, n4);
            } else {
                this.mergeClip(graphics, n9, n2, n3, this.clipH);
            }
        } else {
            n9 = (n6 & 8) != 0 ? n - this.clipW : ((n6 & 1) != 0 ? n - (this.clipW >> 1) : n);
            if (n4 > 0) {
                this.mergeClip(graphics, n9, n2, this.clipW, n4);
            }
        }
        this.saveClip(graphics);
        if (n4 > 0) {
            if (n10 >= n2 + n4) {
                return 0x200000;
            }
            while (n10 <= n2 - n12) {
                n11 |= 0x200000;
                do {
                    n5 = byArray[n7++] & 0xFF;
                } while (n7 < n8 && n5 != 13 && n5 != 10);
                if (n7 >= n8) {
                    return 0x200000;
                }
                n10 += n12;
            }
            if (n10 < n2) {
                n11 |= 0x200000;
            }
        }
        boolean bl2 = (n6 & 9) != 0;
        int n14 = 0;
        while (n7 < n8) {
            int n15;
            if (bl) {
                BoxFont boxFont = this;
                n5 = boxFont.random.nextInt();
                n5 = n5 >= 0 ? n5 : -n5;
                n14 = n5 % 3 - 1;
            }
            n5 = byArray[n7] & 0xFF;
            if (bl2 || n5 < 32) {
                if (bl2 || n5 == 10 || n5 == 13) {
                    if ((n6 & 4) == 0) {
                        n15 = n7;
                        n9 = n5 < 32 ? 0 : this.cwidth[byArray[n15] & 0xFF];
                        while (++n15 < n8 && byArray[n15] != 10 && byArray[n15] != 13) {
                            n9 += this.cwidth[byArray[n15] & 0xFF];
                        }
                        if ((n9 -= this.char_spacing) > n13) {
                            n13 = n9;
                        }
                        n9 = (n6 & 8) != 0 ? n - n9 : ((n6 & 1) != 0 ? n - (n9 >> 1) : n);
                    } else {
                        if ((n9 -= n) > n13) {
                            n13 = n9;
                        }
                        n9 = n;
                    }
                    if (bl2) {
                        bl2 = false;
                        continue;
                    }
                    if (n4 > 0 && (n10 += n12) >= n2 + n4) {
                        return n11 | 0x400000 | n4 | n3 << 10;
                    }
                }
            } else if (n5 == 32) {
                n9 += this.gwidth[0] + this.char_spacing;
            } else if (n5 < 128) {
                n9 += this.drawGlyph(graphics, n5 - 32, n9, n10 + n14) + this.char_spacing;
            } else if ((n5 -= 128) < this.glyphs_extra) {
                n9 += this.drawGlyph(graphics, n5 + this.glyphs_std, n9, n10 + n14) + this.char_spacing;
            } else {
                n5 -= this.glyphs_extra;
                for (int i = 8; i >= 0; i -= 8) {
                    n15 = this.extend_map[(n5 << 1) + 1] >> i & 0xFF;
                    if (n15 < 32) continue;
                    n15 = n15 < 128 ? (n15 -= 32) : (n15 -= 128 - this.glyphs_std);
                    if (n15 >= this.glyphs_all) continue;
                    this.drawGlyph(graphics, n15, n9 + (this.gwidth[this.glyphs_all + n5] - this.gwidth[n15] >> 1), n10);
                }
                n9 += this.gwidth[this.glyphs_all + n5] + this.char_spacing;
            }
            ++n7;
        }
        if ((n6 & 4) != 0 && (n9 -= n) > n13) {
            n13 = n9;
        }
        if (n4 > 0 && n10 + n12 > n2 + n4) {
            return n11 | 0x400000 | n4 | n13 << 10;
        }
        return n11 | n10 + n12 - n2 | n13 << 10;
    }

    private int drawGlyph(Graphics graphics, int n, int n2, int n3) {
        byte by = this.gwidth[n];
        if (this.typeOfFont == 2) {
            byte by2 = this.heights[n];
            n3 += this.offsets[n];
            int n4 = this.xpos[n] & 0xFF;
            n = this.ypos[n] & 0xFF;
            graphics.drawRegion(this.glyphs, n4, n, (int)by, (int)by2, 0, n2, n3, 20);
            graphics.setClip(this.clipX, this.clipY, this.clipW, this.clipH);
        }
        return by;
    }

    private void saveClip(Graphics graphics) {
        this.clipX = graphics.getClipX();
        this.clipY = graphics.getClipY();
        this.clipW = graphics.getClipWidth();
        this.clipH = graphics.getClipHeight();
        this.clipR = this.clipX + this.clipW;
        this.clipB = this.clipY + this.clipH;
    }

    private boolean mergeClip(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = n;
        n += n3;
        if (n5 < this.clipX) {
            n5 = this.clipX;
        }
        if (n > this.clipR) {
            n = this.clipR;
        }
        if (n <= n5) {
            return false;
        }
        n3 = n2;
        n2 += n4;
        if (n3 < this.clipY) {
            n3 = this.clipY;
        }
        if (n2 > this.clipB) {
            n2 = this.clipB;
        }
        if (n2 <= n3) {
            return false;
        }
        graphics.setClip(n5, n3, n - n5, n2 - n3);
        return true;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            long l = i;
            for (int j = 0; j < 8; ++j) {
                l = (l & 1L) != 0L ? 0xEDB88320L ^ l >> 1 : l >> 1;
            }
            BoxFont.png_laCRC[i] = l;
        }
    }
}

