/*
 * Decompiled with CFR 0.152.
 */
package game;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import lib.Fonts;
import lib.TextInputStream;
import main.FrameOfScenario;
import main.GameManager;
import main.Main;

public class Scenario {
    public static Vector scenario = null;
    public static int[] framesStates;

    public static FrameOfScenario elementAt(int n) {
        return (FrameOfScenario)scenario.elementAt(n);
    }

    public static FrameOfScenario firstElement() {
        return (FrameOfScenario)scenario.firstElement();
    }

    public static int getFramesStates(int n) {
        return framesStates[n];
    }

    public static void initFrameStates() {
        framesStates = new int[scenario.size()];
    }

    public static void loadScenario() {
        Scenario.loadScenario("/scenario.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadScenario(String string) {
        TextInputStream textInputStream;
        InputStream inputStream = ((Object)((Object)Main.currentMidlet)).getClass().getResourceAsStream(string);
        if (inputStream == null) {
            GameManager.showErrorScreen("Scenario file missing!");
            return;
        }
        try {
            textInputStream = new TextInputStream(inputStream);
        }
        catch (Throwable throwable) {
            GameManager.showErrorScreen("Scenario file missing!");
            return;
        }
        if (textInputStream == null) {
            GameManager.showErrorScreen("Scenario file missing!");
            return;
        }
        scenario = new Vector(100);
        String string2 = null;
        FrameOfScenario frameOfScenario = null;
        try {
            while (true) {
                int n;
                int n2;
                if ((string2 = textInputStream.readLine()).length() == 0) {
                    continue;
                }
                int n3 = Integer.parseInt(string2.substring(1, 4));
                if (scenario.size() > n3 && scenario.elementAt(n3) != null) {
                    GameManager.showErrorScreen("Frame " + n3 + " already exists!");
                    return;
                }
                char c = string2.charAt(5);
                char c2 = string2.charAt(6);
                int n4 = n2 = string2.charAt(8) - 48;
                if (c2 == 'A') {
                    n4 = 2 * (n2 += 2);
                } else if (c2 == 'C') {
                    n4 = n2 + 1;
                } else if (c2 == 'J') {
                    ++n4;
                    ++n4;
                    ++n2;
                }
                frameOfScenario = new FrameOfScenario(n3, c, c2, n2, n4);
                for (n = 0; n < n2 * 2; ++n) {
                    frameOfScenario.headIds[n] = string2.charAt(10 + n) - 65;
                }
                for (n = 0; n < n4; ++n) {
                    frameOfScenario.nextId[n] = Integer.parseInt(string2.substring(n2 * 2 + 11 + n * 4, n2 * 2 + 14 + n * 4));
                }
                for (n = 0; n < n2; ++n) {
                    int n5;
                    String string3 = null;
                    string3 = textInputStream.readLine();
                    if (c2 == 'I') {
                        n5 = 224;
                        frameOfScenario.textPlayer[n] = Fonts.fontDialog.wrapString(Fonts.fontMapper.mapString(string3), n5, Fonts.SPLIT_CHAR_INT, Fonts.BREAK_LINE_CHAR_INT);
                        continue;
                    }
                    int n6 = n5 = 224;
                    if (n2 > 1 && (c2 == 'D' || c2 == 'C' || c2 == 'J' || c2 == 'V') || n2 > 3 && c2 == 'A') {
                        n6 = 240 - GameManager.imgArrows.getWidth() - 12;
                    }
                    int[] nArray = Fonts.fontMapper.mapString(string3.substring(0, string3.indexOf(35)));
                    int[] nArray2 = Fonts.fontMapper.mapString(string3.substring(string3.indexOf(35) + 1));
                    frameOfScenario.textPlayer[n] = Fonts.fontDialog.wrapString(nArray, n6, Fonts.SPLIT_CHAR_INT, Fonts.BREAK_LINE_CHAR_INT);
                    frameOfScenario.textLady[n] = Fonts.fontDialog.wrapString(nArray2, n5, Fonts.SPLIT_CHAR_INT, Fonts.BREAK_LINE_CHAR_INT);
                }
                if (scenario.size() < n3 + 1) {
                    scenario.setSize(n3 + 1);
                }
                scenario.setElementAt(frameOfScenario, n3);
                continue;
                break;
            }
        }
        catch (EOFException eOFException) {
            return;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            GameManager.showErrorScreen("Can't parse some numbers at\\" + string2);
            return;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            stringIndexOutOfBoundsException.printStackTrace();
            GameManager.showErrorScreen("Can't parse header at\\" + string2);
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            GameManager.showErrorScreen("Can't read frame at\\" + string2);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            GameManager.showErrorScreen("Unknown error.\\" + exception.getMessage());
            return;
        }
        finally {
            try {
                textInputStream.close();
            }
            catch (IOException iOException) {}
            textInputStream = null;
            inputStream = null;
        }
    }

    public static void setFramesStates(int n, int n2) {
        if (framesStates == null) {
            framesStates = new int[scenario.size()];
        }
        Scenario.framesStates[n] = n2;
    }

    public static int size() {
        return scenario.size();
    }
}

