/*
 * Decompiled with CFR 0.152.
 */
package screens;

import game.Scenario;
import javax.microedition.lcdui.Graphics;
import lib.Fonts;
import lib.Lib;
import main.Configuration;
import main.GameManager;
import main.MusicManager;
import screens.DialogScreen;
import screens.GetMoreGamesScreen;
import screens.HelpScreen;
import screens.LogoScreen;
import screens.OptionsScreen;
import screens.elements.MassageSessionModus;
import screens.elements.MenuField;

public class MenuScreen {
    public static int MENU_FIELD_HEIGHT;
    public static int MENU_FIELD_BORDER_COLOR;
    public static int MENU_TEXT_MARGIN;
    public static int MENU_ICONS_POSITION;
    public static int MENU_ANIMATION_BASE_INTERVAL;
    public static int MENU_ANIMATION_OPENING_SPEED;
    public static int MENU_ANIMATION_CLOSING_SPEED;
    public static int MENU_ANIMATION_OPENING_MIN_SPEED;
    public static int MENU_ICONS_ON_SCREEN;
    public static int MENU_ICONS_WIDTH;
    public static int MENU_ICONS_SMALL_WIDTH;
    public static int MENU_ICONS_ANIMATION_SPEED;
    public static int MENU_ICONS_ANIMATION_MIN_SPEED;
    public static int MENU_ARROW_MOVEMENT_SIZE;
    public static int MENU_ARROW_MOVEMENT_STEP;
    public static int MENU_ARROW_SIDE_MARGIN;
    public static int[] TEXT_MENU_MAIN_START;
    public static int[] TEXT_MENU_INSTRUCTIONS;
    public static int[] TEXT_MENU_ABOUT;
    public static int[] TEXT_MENU_EXIT;
    public static int[] TEXT_MENU_CONTINUE;
    public static int[] TEXT_MENU_OPTIONS;
    public static int[] TEXT_MENU_GOTO_MAIN;
    public static int[] TEXT_MENU_ARCADE;
    public static int[] TEXT_MENU_FOTO_DEBUG_1;
    public static int[] TEXT_MENU_FOTO_DEBUG_2;
    public static int[] TEXT_MUSIC_ON;
    public static int[] TEXT_MUSIC_OFF;
    public static int[][] TEXT_LANG;
    public static int LANG_NUMBER;
    public static String[] SCENARIO_FILE_NAMES;
    public static String[] LANG_FILE_NAMES;
    public static String[] LANG_MENU_ICONS_NAMES;
    public static final int MENU_TYPE_MAIN = 1;
    public static final int MENU_TYPE_INGAME = 2;
    public static final int MENU_TYPE_ENABLE_SOUND = 3;
    public static final int MENU_TYPE_LANGUAGE_SELECT = 4;
    private static int menuTypeCurrent;
    private static int menuTypeRequested;
    public static int itemSelected;
    public static int itemDest;
    private static int itemSelectedRequested;
    private static int[][] items;
    private static int[][] itemsNonWrap;
    private static int[][] items2;
    private static int[] itemsIconIndexes;
    private static int[][] itemsRequested;
    private static int[] itemsIconIndexesRequested;
    public static boolean isAnimationIconsInProgress;
    public static boolean stopMenuAnimation;
    private static int interIcon;
    private static int itemOffset;
    public static int arrowOffset;
    public static int arrowMovementDirection;
    public static int FRAME_COLOR_DARK;
    public static int FRAME_COLOR_STEP;
    public static int frameColor;
    private static int frameColorChangeDirection;
    public boolean isFrameColorAnimating = false;
    public static boolean stopFrameColorAnimation;
    public static int[][] MENU_ITEMS_MAIN;
    public static int[] MENU_ITEMS_MAIN_ICONS_INDEXES;
    public static int[][] MENU_ITEMS_MAIN_WITH_ARCADE;
    public static int[] MENU_ITEMS_MAIN_ARCADE_ICONS_INDEXES;
    public static int[][] MENU_ITEMS_INGAME;
    public static int[] MENU_ITEMS_INGAME_ICONS_INDEXES;
    public static int[][] MENU_ITEMS_ENABLE_SOUND;
    public static int[] MENU_ITEMS_ENABLE_SOUND_ICONS_INDEXES;
    public static int[][] MENU_ITEMS_LANG_MENU;
    public static int[] MENU_ITEMS_LANG_MENU_ICONS_INDEXES;
    public static int[] TEXT_MENU_GET_MORE_GAMES;

    public static void showMainMenu(boolean bl) {
        GameManager.keysBlocked = true;
        if (LogoScreen.imgLogoGame != null) {
            GameManager.imgCurrentImage = LogoScreen.imgLogoGame;
            LogoScreen.imgLogoGame = null;
        } else {
            GameManager.imgCurrentImage = Lib.loadImage("/title.png");
        }
        menuTypeRequested = 1;
        if (GameManager.isContinueIconEnabled) {
            itemsRequested = MENU_ITEMS_MAIN_WITH_ARCADE;
            itemsIconIndexesRequested = MENU_ITEMS_MAIN_ARCADE_ICONS_INDEXES;
        } else {
            itemsRequested = MENU_ITEMS_MAIN;
            itemsIconIndexesRequested = MENU_ITEMS_MAIN_ICONS_INDEXES;
        }
        interIcon = (240 - MENU_ICONS_WIDTH * MENU_ICONS_ON_SCREEN) / MENU_ICONS_ON_SCREEN;
        DialogScreen.isImageBlured = false;
        if (bl) {
            itemSelectedRequested = 0;
        }
        GameManager.current.startOperation(4, 3);
        GameManager.keysBlocked = false;
    }

    public static void showInGameMain(boolean bl) {
        GameManager.previousScreenStack.addElement(new Integer(GameManager.currentScreen));
        if (bl) {
            itemSelectedRequested = 0;
        }
        menuTypeRequested = 2;
        itemsRequested = MENU_ITEMS_INGAME;
        itemsIconIndexesRequested = MENU_ITEMS_INGAME_ICONS_INDEXES;
        DialogScreen.stopAnimateGame = true;
        GameManager.current.startOperation(4, 3);
    }

    public static void showEnableSound() {
        itemSelectedRequested = MusicManager.isEnabledMusic ? 1 : 0;
        menuTypeRequested = 3;
        itemsRequested = MENU_ITEMS_ENABLE_SOUND;
        itemsIconIndexesRequested = MENU_ITEMS_ENABLE_SOUND_ICONS_INDEXES;
        interIcon = (240 - GameManager.imgIconsMain.getHeight() * MENU_ICONS_ON_SCREEN) / MENU_ICONS_ON_SCREEN;
        GameManager.current.startOperation(4, 3);
    }

    public static void showLangMenu() {
        menuTypeCurrent = 0;
        menuTypeRequested = 0;
        itemSelected = 0;
        itemDest = 0;
        itemSelectedRequested = -1;
        menuTypeRequested = 4;
        itemsRequested = MENU_ITEMS_LANG_MENU;
        itemsIconIndexesRequested = MENU_ITEMS_LANG_MENU_ICONS_INDEXES;
        interIcon = (240 - GameManager.imgIconsMain.getHeight() * MENU_ICONS_ON_SCREEN) / MENU_ICONS_ON_SCREEN;
        GameManager.current.startOperation(4, 3);
    }

    public static void paint_Menu(Graphics graphics) {
        int n;
        if (!MenuField.paint_MenuBackground(graphics)) {
            return;
        }
        int n2 = itemOffset;
        int n3 = itemSelected;
        int n4 = 120 - MENU_ICONS_WIDTH / 2;
        int n5 = 160 - MENU_FIELD_HEIGHT + MENU_ICONS_POSITION;
        if (menuTypeCurrent != 3) {
            for (n = -(MENU_ICONS_ON_SCREEN / 2 + 1); n <= MENU_ICONS_ON_SCREEN / 2 + 1; ++n) {
                int n6 = n4 + n * (MENU_ICONS_WIDTH + interIcon) - n2 + (MENU_ICONS_WIDTH - MENU_ICONS_SMALL_WIDTH) / 2;
                int n7 = n5 + (GameManager.imgIconsMain.getHeight() - GameManager.imgIconsSmall.getHeight()) / 2;
                Lib.drawSprite(graphics, GameManager.imgIconsSmall, n6, n7, MENU_ICONS_SMALL_WIDTH, GameManager.imgIconsSmall.getHeight(), itemsIconIndexes[Lib.mod(n + n3, items.length)] * MENU_ICONS_SMALL_WIDTH, 0);
            }
        }
        graphics.setClip(n4 - 2, Math.max(n5 - 2, 160 - MenuField.menuFieldHeightCurrentBlocked + 1), MENU_ICONS_WIDTH + 4, Math.min(GameManager.imgIconsMain.getHeight() + 4, 2 * MenuField.menuFieldHeightCurrentBlocked - 1));
        for (n = -(MENU_ICONS_ON_SCREEN / 2); n <= MENU_ICONS_ON_SCREEN / 2; ++n) {
            Lib.drawSprite(graphics, GameManager.imgIconsMain, n4 + n * (MENU_ICONS_WIDTH + interIcon) - n2, n5, MENU_ICONS_WIDTH, GameManager.imgIconsMain.getHeight(), itemsIconIndexes[Lib.mod(n + n3, items.length)] * MENU_ICONS_WIDTH, 0);
        }
        graphics.setClip(0, 160 - MenuField.menuFieldHeightCurrentBlocked + 1, 240, 2 * MenuField.menuFieldHeightCurrentBlocked - 1);
        graphics.drawRect(n4 - 4, n5 - 4, MENU_ICONS_WIDTH + 7, GameManager.imgIconsMain.getHeight() + 7);
        graphics.drawRect(n4 - 3, n5 - 3, MENU_ICONS_WIDTH + 5, GameManager.imgIconsMain.getHeight() + 5);
        n5 = 160 + MENU_FIELD_HEIGHT - MENU_TEXT_MARGIN;
        if (items2[Lib.mod(itemDest, items.length)] == null || items2[Lib.mod(itemDest, items.length)].length == 0) {
            Fonts.fontMenu.drawString(graphics, items[Lib.mod(itemDest, items.length)], 120, n5, 33);
        } else {
            Fonts.fontMenu.drawString(graphics, items[Lib.mod(itemDest, items.length)], 120, n5 - Fonts.fontMenu.getHeight() / 2, 33);
            Fonts.fontMenu.drawString(graphics, items2[Lib.mod(itemDest, items.length)], 120, n5 + Fonts.fontMenu.getHeight() / 2, 33);
        }
        Lib.drawSprite(graphics, GameManager.imgArrows, 0 + MENU_ARROW_SIDE_MARGIN + arrowOffset, n5 -= Fonts.fontMenu.getHeight() / 2 + GameManager.imgArrows.getHeight() / 4, GameManager.imgArrows.getWidth() / 2, GameManager.imgArrows.getHeight() / 2, 0, 0);
        Lib.drawSprite(graphics, GameManager.imgArrows, 240 - MENU_ARROW_SIDE_MARGIN - arrowOffset - GameManager.imgArrows.getWidth() / 2, n5, GameManager.imgArrows.getWidth() / 2, GameManager.imgArrows.getHeight() / 2, GameManager.imgArrows.getWidth() / 2, 0);
        MenuField.drawMenuBorders(graphics);
    }

    public static void keyPressed_Menu(int n) {
        if (MenuField.isAnimationFieldResizeInProgress) {
            return;
        }
        if (Math.abs(itemSelected - itemDest) >= items.length) {
            return;
        }
        switch (GameManager.current.getGameAction(n)) {
            case 2: {
                if (menuTypeCurrent == 3) {
                    itemDest = --itemSelected;
                    break;
                }
                --itemDest;
                break;
            }
            case 5: {
                if (menuTypeCurrent == 3) {
                    itemDest = ++itemSelected;
                    break;
                }
                ++itemDest;
                break;
            }
            case 8: {
                if (itemSelected != itemDest) break;
                itemDest = itemSelected = Lib.mod(itemSelected, items.length);
                if (itemsNonWrap[itemSelected] == TEXT_MENU_MAIN_START) {
                    DialogScreen.showGameScreen(true);
                } else if (itemsNonWrap[itemSelected] == TEXT_MENU_ARCADE) {
                    DialogScreen.currentClothes = DialogScreen.continueInitialClothes;
                    DialogScreen.showGameScreen(DialogScreen.continueFrameId);
                } else if (itemsNonWrap[itemSelected] == TEXT_MENU_FOTO_DEBUG_1) {
                    DialogScreen.showGameScreen(58);
                } else if (itemsNonWrap[itemSelected] == TEXT_MENU_FOTO_DEBUG_2) {
                    DialogScreen.showGameScreen(58);
                } else if (itemsNonWrap[itemSelected] == TEXT_MENU_CONTINUE) {
                    GameManager.current.startOperation(4, (Integer)GameManager.previousScreenStack.pop());
                    GameManager.current.startOperation(6);
                } else {
                    if (itemsNonWrap[itemSelected] == TEXT_MENU_ABOUT) {
                        HelpScreen.showHelpAbout(4);
                        return;
                    }
                    if (itemsNonWrap[itemSelected] == TEXT_MENU_INSTRUCTIONS) {
                        HelpScreen.showHelpAbout(5);
                        return;
                    }
                    if (itemsNonWrap[itemSelected] == TEXT_MENU_OPTIONS) {
                        OptionsScreen.showOptions();
                        return;
                    }
                    if (itemsNonWrap[itemSelected] == TEXT_MENU_GOTO_MAIN) {
                        DialogScreen.closeGame();
                        GameManager.isContinueIconEnabled = false;
                        MassageSessionModus.isBreastVisible = false;
                        MenuScreen.showMainMenu(true);
                    } else {
                        if (itemsNonWrap[itemSelected] == TEXT_MENU_EXIT) {
                            stopMenuAnimation = true;
                            GameManager.current.startOperation(99);
                            return;
                        }
                        if (itemsNonWrap[itemSelected] == TEXT_MUSIC_OFF) {
                            MusicManager.isEnabledMusic = false;
                            GameManager.gameStarted = true;
                            MenuScreen.showMainMenu(true);
                        } else if (itemsNonWrap[itemSelected] == TEXT_MUSIC_ON) {
                            MusicManager.isEnabledMusic = true;
                            GameManager.gameStarted = true;
                            GameManager.current.startOperation(10);
                            MenuScreen.showMainMenu(true);
                        } else if (itemsNonWrap[itemSelected] == TEXT_MENU_GET_MORE_GAMES) {
                            if (GetMoreGamesScreen.gmgMenuMode == 1) {
                                GetMoreGamesScreen.invokeGmgWapPage();
                                return;
                            }
                            if (GetMoreGamesScreen.gmgMenuMode == 2 || GetMoreGamesScreen.gmgMenuMode == 3) {
                                GetMoreGamesScreen.showGmgScreen();
                            }
                        }
                    }
                }
                for (int i = 0; i < LANG_NUMBER; ++i) {
                    if (itemsNonWrap[itemSelected] != MENU_ITEMS_LANG_MENU[i]) continue;
                    Scenario.loadScenario("/" + SCENARIO_FILE_NAMES[i]);
                    Configuration.loadConfFile("/" + LANG_FILE_NAMES[i]);
                    Configuration.initializeConstants();
                    Configuration.clear();
                    GetMoreGamesScreen.applyGMGIcon();
                    MenuScreen.showEnableSound();
                    TEXT_LANG = null;
                    SCENARIO_FILE_NAMES = null;
                    LANG_FILE_NAMES = null;
                    LANG_MENU_ICONS_NAMES = null;
                    System.gc();
                }
                break;
            }
        }
    }

    public static void opAnimateIconsAndArrows() throws InterruptedException {
        if (isAnimationIconsInProgress) {
            return;
        }
        isAnimationIconsInProgress = true;
        arrowMovementDirection = MENU_ARROW_MOVEMENT_STEP;
        arrowOffset = 0;
        stopMenuAnimation = false;
        while (!stopMenuAnimation) {
            if (GameManager.currentScreen == 3 && (itemDest != itemSelected || itemOffset != 0)) {
                int n = 1;
                if (itemDest != itemSelected) {
                    n = (itemDest - itemSelected) / Math.abs(itemDest - itemSelected);
                } else if (itemOffset != 0) {
                    n = -itemOffset / Math.abs(itemOffset);
                }
                int n2 = (itemDest - itemSelected) * (MENU_ICONS_WIDTH + interIcon) - itemOffset;
                int n3 = n * Math.max(Math.abs(n2 / MENU_ICONS_ANIMATION_SPEED), MENU_ICONS_ANIMATION_MIN_SPEED);
                if (Math.abs(itemOffset += n3) >= Math.abs(MENU_ICONS_WIDTH + interIcon)) {
                    itemSelected += itemOffset / (MENU_ICONS_WIDTH + interIcon);
                    itemOffset -= itemOffset / (MENU_ICONS_WIDTH + interIcon) * (MENU_ICONS_WIDTH + interIcon);
                    if (itemSelected == itemDest) {
                        itemDest = itemSelected = Lib.mod(itemSelected, items.length);
                        itemOffset = 0;
                    }
                } else if (itemSelected == itemDest && itemOffset * n > 0) {
                    itemOffset = 0;
                }
            }
            if ((GetMoreGamesScreen.gmgDescOffset += GetMoreGamesScreen.gmgMoveDirectionAndStep) > GetMoreGamesScreen.gmgDescOverHeight / 2 + GetMoreGamesScreen.gmgDescWaitTime * Fonts.fontGMG.getHeight()) {
                GetMoreGamesScreen.gmgDescOffset = -GetMoreGamesScreen.gmgDescOverHeight / 2 - Fonts.fontGMG.getHeight() * 4;
            }
            MenuScreen.opAnimateArrows();
            GameManager.current.repaint();
            Thread.sleep(MENU_ANIMATION_BASE_INTERVAL);
        }
        isAnimationIconsInProgress = false;
        stopMenuAnimation = false;
    }

    public static void opAnimateArrows() {
        frameColor += frameColorChangeDirection;
        if ((arrowOffset += arrowMovementDirection) <= 0 || arrowOffset >= MENU_ARROW_MOVEMENT_SIZE) {
            arrowMovementDirection = -arrowMovementDirection;
            frameColorChangeDirection = -frameColorChangeDirection;
        }
    }

    public static void changeItems() {
        if (itemSelectedRequested >= 0) {
            itemSelected = itemDest = itemSelectedRequested;
            itemSelectedRequested = -1;
        }
        items = new int[itemsRequested.length][];
        items2 = new int[itemsRequested.length][];
        for (int i = 0; i < itemsRequested.length; ++i) {
            int[][] nArray = Fonts.fontMenu.wrapString(itemsRequested[i], 240 - MENU_ARROW_MOVEMENT_SIZE * 2 - MENU_ARROW_SIDE_MARGIN * 2 - GameManager.imgArrows.getWidth() - 4, Fonts.SPLIT_CHAR_INT, Fonts.BREAK_LINE_CHAR_INT);
            if (nArray.length == 1) {
                MenuScreen.items[i] = nArray[0];
                MenuScreen.items2[i] = null;
                continue;
            }
            MenuScreen.items[i] = nArray[0];
            MenuScreen.items2[i] = nArray[1];
        }
        itemsNonWrap = itemsRequested;
        itemsIconIndexes = itemsIconIndexesRequested;
        menuTypeCurrent = menuTypeRequested;
    }

    static {
        MENU_ICONS_ON_SCREEN = 3;
        MENU_ICONS_ANIMATION_SPEED = 6;
        MENU_ICONS_ANIMATION_MIN_SPEED = 4;
        MENU_ARROW_SIDE_MARGIN = 3;
        menuTypeCurrent = 0;
        menuTypeRequested = 0;
        itemSelected = 0;
        itemDest = 0;
        itemSelectedRequested = -1;
        items = null;
        itemsNonWrap = null;
        items2 = null;
        itemsIconIndexes = null;
        itemsRequested = null;
        itemsIconIndexesRequested = null;
        isAnimationIconsInProgress = false;
        stopMenuAnimation = false;
        itemOffset = 0;
        arrowOffset = 0;
        FRAME_COLOR_DARK = 0x202020;
        FRAME_COLOR_STEP = 0x101010;
        frameColor = FRAME_COLOR_DARK;
        frameColorChangeDirection = FRAME_COLOR_STEP;
        stopFrameColorAnimation = false;
    }
}

