/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.ActData;
import game.DOGMIDlet;
import game.DoActionData;
import game.FrameData;
import game.Game;
import game.Rectangle;
import game.Tools;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Sprite {
    byte yWay = 1;
    int iID;
    int iRESID;
    int iHp;
    int iSteps = 2;
    boolean bShow = true;
    int iType;
    int iStepSize = 1;
    int iLife = 3;
    Image spriteImg;
    public int state = 0;
    public static final byte ACT_STAY = 0;
    public static final byte ACT_WALK = 1;
    public static final byte ACT_JUMP = 2;
    public static final byte ACT_ATTACKREADY = 3;
    public static final byte ACT_ATTACK = 4;
    public static final byte ACT_DEAD = 5;
    public static final byte BOSS_STAY = 6;
    public static final byte BOSS_JUMPREADY = 7;
    public static final byte BOSS_JUMP = 8;
    public static final byte BOSS_DROP = 9;
    public static final byte BOSS_STAND = 10;
    public static final byte BOSS_FAINT = 11;
    public static final byte BOSS_RUN = 12;
    int iFrameIndex;
    public static byte yWalkSpeed = (byte)6;
    public static byte yJumpSpeed = (byte)8;
    public static byte yAttackSpeed = (byte)15;
    int iOffx;
    int iOffy;
    byte yCurrentDir;
    long lDrawTime;
    int[] iFrameID;
    int iCurrentFrame;
    DoActionData crdData;
    int iTileImgMax;
    int[] iRectMax;
    Rectangle[][] tileRects;
    int iFrameMax;
    FrameData[] frameData;
    int iActMax;
    ActData[] actData;
    int iFootw;
    int iFooth;
    int iFootMapX;
    int iFootMapY;
    byte[] yWalkWay;
    int[] iWalkLength;
    int iWalkIndex;
    int iCurrentLength;
    int iTpye7Y;
    int iYU = 80;
    int iYM = 170;
    int iYD = 260;
    int iXL = 80;
    int iXR = 260;
    int iXM = 170;

    public Sprite(int resID, int type, int id) {
        this.iID = id;
        this.iRESID = resID;
        this.iType = type;
        if (type == 3) {
            this.bShow = false;
        }
        try {
            this.spriteImg = Game.loadSpriteImage("/spr/n" + resID + ".png");
            this.crdData = Game.loadSetActionData("/act/n" + resID + ".act");
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.crdData != null) {
            this.iTileImgMax = this.crdData.tileMax;
            this.iRectMax = this.crdData.rectMax;
            this.tileRects = this.crdData.tileRects;
            this.iFrameMax = this.crdData.frameMax;
            this.frameData = this.crdData.frameData;
            this.iActMax = this.crdData.actMax;
            this.actData = this.crdData.actData;
            this.iFootw = this.crdData.footw;
            this.iFooth = this.crdData.footh;
        }
        this.crdData = null;
        this.init();
    }

    public void startAct(byte actid) {
        if (!this.bShow || this.iType == 1) {
            return;
        }
        this.iFrameIndex = 0;
        this.lDrawTime = 0L;
        Game.iRoleVY = 0;
        this.state = actid;
        if (this.iType == 13) {
            this.iFrameID = this.actData[actid - 6 + (this.yWay - 1) * 7].frameID;
            return;
        }
        if (this.iType == 2) {
            actid = (byte)(actid > 0 ? 1 : 0);
            this.iFrameID = this.actData[actid].frameID;
            return;
        }
        if (this.iType == 3 || this.iType == 6 || this.iType == 10) {
            this.iFrameID = this.actData[this.yWay - 1].frameID;
            return;
        }
        if (this.iType == 4 || this.iType == 5 || this.iType == 8) {
            this.iFrameID = this.actData[0].frameID;
            return;
        }
        if (this.iType == 7) {
            this.iFrameID = this.actData[actid & 7].frameID;
            return;
        }
        if (this.iType == 11) {
            this.iFrameID = this.actData[actid & 1].frameID;
            return;
        }
        if (this.iType == 12) {
            this.iFrameID = this.actData[actid % 3].frameID;
            return;
        }
        if (this.state == 5 && this.iRESID == 0) {
            if (Game.bIsOpenVibra && Game.bIsCanVibra) {
                DOGMIDlet.display.vibrate(100);
            }
            this.iFrameID = this.actData[this.actData.length - 1].frameID;
        } else {
            this.iFrameID = this.actData[actid + (this.yWay - 1) * 5].frameID;
        }
    }

    public void init() {
        if (this.iType == 6 || this.iType == 10) {
            this.startAct((byte)1);
        } else if (this.iType == 13) {
            this.startAct((byte)6);
        } else {
            this.startAct((byte)0);
        }
    }

    public void draw(Graphics g, int mapX, int mapY) {
        if (Game.yState != 18) {
            ++this.lDrawTime;
        }
        if (this.iRESID == 11 && !Game.bIsWaterMission) {
            return;
        }
        this.iOffx = this.iFootMapX + mapX;
        this.iOffy = this.iFootMapY + mapY;
        if (this.iRESID == 0) {
            this.iOffy += Game.iRoleVY;
        }
        if (this.iType == 1) {
            this.iCurrentFrame = 0;
        } else {
            if (this.iFrameIndex < this.iFrameID.length) {
                this.iCurrentFrame = this.iFrameID[this.iFrameIndex];
            }
            if (this.iType == 2 && this.state == 0 || this.iType == 0 || this.iType == 6 && this.iRESID != 28 && this.iRESID != 29) {
                if (Game.iMission == 5) {
                    g.setColor(3431029);
                } else if (Game.iMission == 4) {
                    g.setColor(57788645);
                } else {
                    g.setColor(9599064);
                }
                int z = 0;
                int v = 0;
                if (this.iRESID == 0) {
                    z = 3;
                    if (this.yWay == 4) {
                        v = 3;
                    }
                    if (this.yWay == 2) {
                        v = -3;
                    }
                    if (this.state == 2 && this.iFrameIndex != 0) {
                        z = 1;
                        v = 0;
                    }
                }
                g.fillArc(this.iOffx - z * 2 + v, this.iOffy - z, this.iFootw + z * 4, this.iFooth + z * 2, 0, 360);
            } else if (this.iType == 13) {
                g.setColor(3431029);
                if (this.state == 9) {
                    int h = Game.iBossEndY - this.iFootMapY;
                    if (h <= 100) {
                        g.fillArc(this.iOffx + this.iFootw / 2 - 20 + 20 * h / 100, Game.iBossEndY + mapY + this.iFooth / 2 - 8 + 8 * h / 100, 40 - 40 * h / 100, 16 - 16 * h / 100, 0, 360);
                    }
                } else if (this.state != 8) {
                    g.fillArc(this.iOffx + this.iFootw / 2 - 20, this.iOffy + this.iFooth / 2 - 8, 40, 16, 0, 360);
                }
            }
        }
        FrameData fd = this.frameData[this.iCurrentFrame];
        if (fd != null) {
            int iId;
            int rId;
            for (int i = 0; i < fd.rectNum && (rId = fd.rectID[i]) < this.iRectMax[iId = fd.imgID[i]]; ++i) {
                Rectangle rct = this.tileRects[iId][rId];
                if (this.iOffx + fd.rectDX[i] + rct.width < 0 || this.iOffx + fd.rectDX[i] >= Tools.iGameWidth || this.iOffy + fd.rectDY[i] + rct.height < 0 || this.iOffy + fd.rectDY[i] >= Tools.iGameHeight) continue;
                if (iId == 0) {
                    Tools.drawRegion(g, this.spriteImg, rct.x, rct.y, rct.width, rct.height, fd.drawType[i], this.iOffx + fd.rectDX[i], this.iOffy + fd.rectDY[i], 0);
                    continue;
                }
                if (this.iType == 0 && iId == 1) {
                    Tools.drawRegion(g, Game.shadowImg, rct.x, rct.y, rct.width, rct.height, fd.drawType[i], this.iOffx + fd.rectDX[i], this.iOffy + fd.rectDY[i], 0);
                    continue;
                }
                if (this.iType != 13 || iId != 1) continue;
                Tools.drawRegion(g, Game.roleSmoke.spriteImg, rct.x, rct.y, rct.width, rct.height, fd.drawType[i], this.iOffx + fd.rectDX[i], this.iOffy + fd.rectDY[i], 0);
            }
        }
    }

    public void drawBigWoodEffect(Graphics g, int mapX, int mapY) {
        this.iOffx = this.iFootMapX + mapX;
        this.iOffy = this.iFootMapY + mapY;
        this.iCurrentFrame = this.iFrameID[this.iFrameIndex];
        FrameData fd = this.frameData[this.iCurrentFrame];
        if (fd != null) {
            int iId;
            int rId;
            for (int i = 0; i < fd.rectNum && (rId = fd.rectID[i]) < this.iRectMax[iId = fd.imgID[i]]; ++i) {
                Rectangle rct = this.tileRects[iId][rId];
                if (this.iOffx + fd.rectDX[i] + rct.width < 0 || this.iOffx + fd.rectDX[i] >= Tools.iGameWidth || this.iOffy + fd.rectDY[i] + rct.height < 0 || this.iOffy + fd.rectDY[i] >= Tools.iGameHeight || iId != 1) continue;
                Tools.drawRegion(g, this.spriteImg, rct.x, rct.y, rct.width, rct.height, fd.drawType[i], this.iOffx + fd.rectDX[i], this.iOffy + fd.rectDY[i], 0);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update() {
        if (this.iType == 1 || !this.bShow) {
            return;
        }
        if (this.iType == 13 && !Game.bIsBoss) {
            return;
        }
        if (this.iType == 7) {
            if ((this.lDrawTime & 1L) == 0L) {
                ++this.iFrameIndex;
            }
            if (this.iFrameIndex >= this.actData[this.state].frameNum) {
                this.iFrameIndex = 0;
            }
            this.iFootMapX -= (7 - (this.state & 1) * 2) * (this.state < 4 ? 1 : -1);
            this.iFootMapY += this.iTpye7Y;
            if (this.iOffx < -30 || this.iOffx > Tools.iGameWidth + 30 || this.iOffy < -20 || this.iOffy > Tools.iGameHeight + 20) {
                this.bShow = false;
                return;
            } else {
                if ((Game.rnd.nextInt() & 0xF) != 0) return;
                this.startAct((byte)(this.state & 6 ^ (this.state & 6) + 1 ^ this.state));
            }
            return;
        }
        if (this.iType == 12 && Game.bIslive) {
            Game.bIsShake = false;
            this.iFootMapY -= this.iCurrentLength;
            this.iCurrentLength = 0;
            this.startAct((byte)0);
        }
        if (this.iRESID == 0 && (this.state != 5 || this.lDrawTime <= 1L)) {
            int footX = this.iFootMapX;
            int footY = this.iFootMapY;
            int cellid = 0;
            footY -= this.iStepSize;
            switch (this.yCurrentDir) {
                case 1: 
                case 3: {
                    cellid = Game.getCellID(footX + (this.iFootw >> 1), footY);
                    break;
                }
                case 2: {
                    cellid = Game.getCellID((footX -= 2) + (this.iFootw >> 1), footY + (this.iFooth >> 1));
                    break;
                }
                case 4: {
                    cellid = Game.getCellID((footX += 2) + (this.iFootw >> 1), footY + (this.iFooth >> 1));
                }
            }
            if (Game.isCellWater(cellid) && !Game.checkType9() && this.state != 2) {
                Game.roleWater.bShow = true;
                Game.roleWater.yWay = 1;
                Game.roleWater.iFootMapX = this.iFootMapX;
                Game.roleWater.iFootMapY = this.iFootMapY;
                Game.roleWater.startAct((byte)0);
                this.startAct((byte)0);
                this.bShow = false;
                if (Game.bIsOpenVibra && Game.bIsCanVibra) {
                    DOGMIDlet.display.vibrate(100);
                }
            }
        }
        block5 : switch (this.state) {
            case 0: {
                if ((Game.iShowTimes & (this.iRESID == 10 ? 3 : 1)) == 0 || this.iType == 3 && this.iRESID != 16) {
                    ++this.iFrameIndex;
                }
                if (this.iFrameIndex >= this.actData[this.state].frameNum) {
                    if (this.iType == 3) {
                        this.bShow = false;
                        if (this.iRESID == 11 && !Game.role.bShow) {
                            Game.bIslive = true;
                            if (Game.iLife >= 0) {
                                --Game.iLife;
                            }
                        }
                    } else if (this.iType == 5) {
                        this.bShow = false;
                        Tools.kLOCK = false;
                    } else {
                        this.iFrameIndex = 0;
                    }
                }
                if (this.iRESID == 0) {
                    if (Game.bIsVic) {
                        Game.vic();
                        Game.iInterval = 70;
                        return;
                    }
                    if (!Tools.kLEFT && !Tools.kRIGHT && !Tools.kUP && !Tools.kDOWN) return;
                    if (Tools.kLEFT) {
                        this.yWay = (byte)2;
                    } else if (Tools.kRIGHT) {
                        this.yWay = (byte)4;
                    } else if (Tools.kUP) {
                        this.yWay = (byte)3;
                    } else if (Tools.kDOWN) {
                        this.yWay = 1;
                    }
                    this.startAct((byte)1);
                    return;
                }
                if (this.iType != 12 || !Game.bIsBallStartAction || Game.role.iFootMapY - this.iFootMapY >= Tools.iGameHeight || Game.role.iFootMapY <= this.iFootMapY || Math.abs(Game.role.iFootMapX - this.iFootMapX) >= Tools.iGameWidth >> 1) return;
                this.startAct((byte)1);
                Game.bIsShake = true;
                Game.bIsBallStartAction = false;
                return;
            }
            case 1: {
                ++this.iFrameIndex;
                if (this.iType != 9 && this.iFrameIndex >= this.actData[this.state].frameNum) {
                    if (this.iType == 10) {
                        ++this.iWalkIndex;
                        if (this.iWalkIndex >= this.iWalkLength.length) {
                            this.iWalkIndex = 0;
                        }
                        this.yWay = this.yWalkWay[this.iWalkIndex];
                        this.iFrameID = this.actData[this.yWay - 1].frameID;
                        if (Game.isSpriteAtScreen(this) && !Game.roleWater.bShow) {
                            Game.roleWater.bShow = true;
                            Game.roleWater.yWay = 1;
                            Game.roleWater.iFootMapX = this.iFootMapX;
                            Game.roleWater.iFootMapY = this.iFootMapY;
                            Game.roleWater.startAct((byte)0);
                        }
                    }
                    this.iFrameIndex = 0;
                }
                if (this.iRESID == 0) {
                    if (!(Tools.kLEFT || Tools.kRIGHT || Tools.kUP || Tools.kDOWN)) {
                        this.startAct((byte)0);
                        return;
                    }
                    DOGMIDlet.game.roleMoveV(yWalkSpeed);
                    return;
                }
                if (this.iType == 9) {
                    if (this.iFrameIndex < this.actData[this.state].frameNum) return;
                    this.startAct((byte)0);
                    return;
                }
                if (this.iType == 10) {
                    this.yCurrentDir = this.yWay;
                    block44: for (int i = 0; i < this.iSteps; ++i) {
                        switch (this.yWay) {
                            case 3: {
                                this.iFootMapY -= this.iStepSize;
                                continue block44;
                            }
                            case 1: {
                                this.iFootMapY += this.iStepSize;
                                continue block44;
                            }
                            case 2: {
                                this.iFootMapX -= this.iStepSize;
                                continue block44;
                            }
                            case 4: {
                                this.iFootMapX += this.iStepSize;
                            }
                        }
                    }
                    return;
                }
                if (this.iType == 11) {
                    if (!Game.bIslive) return;
                    this.startAct((byte)0);
                    return;
                }
                DOGMIDlet.game.npcMove(this, this.yWay, this.iSteps, this.iStepSize * (this.iType == 12 || this.iRESID == 29 ? 2 : 1));
                return;
            }
            case 2: {
                if (this.iRESID == 0) {
                    if ((Game.iShowTimes & 1) == 0) {
                        ++this.iFrameIndex;
                    }
                    if (this.iFrameIndex >= this.actData[this.state].frameNum) {
                        this.startAct((byte)0);
                        return;
                    }
                    DOGMIDlet.game.roleMove(this.getWay(this.yWay), yJumpSpeed);
                    return;
                }
                if (this.iType == 12) {
                    ++this.iFrameIndex;
                    if (this.iFrameIndex < this.actData[this.state].frameNum) return;
                    this.startAct((byte)0);
                    return;
                }
                if ((this.lDrawTime & 1L) == 0L) {
                    ++this.iFrameIndex;
                }
                if (this.iFrameIndex >= this.actData[this.state].frameNum) {
                    this.iFrameIndex = 0;
                }
                Game.iRoleVY = Game.role.state == 0 ? this.iFrameIndex : 0;
                if (Game.role.bShow) return;
                this.startAct((byte)1);
                return;
            }
            case 3: {
                if ((this.lDrawTime & 1L) == 0L || this.yWay == 1) {
                    ++this.iFrameIndex;
                }
                if (this.iFrameIndex < this.actData[this.state + (this.yWay - 1) * 5].frameNum) return;
                this.iFrameIndex = 0;
                return;
            }
            case 4: {
                ++this.iFrameIndex;
                DOGMIDlet.game.roleMove(this.getWay(this.yWay), yAttackSpeed);
                if (this.iFrameIndex < this.actData[this.state].frameNum) return;
                this.startAct((byte)0);
                return;
            }
            case 5: {
                if (this.iType == 6) {
                    switch (this.yWay) {
                        case 2: {
                            this.iFootMapX -= 18 + this.iFrameIndex * 2;
                            break;
                        }
                        case 3: {
                            this.iFootMapY -= 18 + this.iFrameIndex * 2;
                            break;
                        }
                        case 4: {
                            this.iFootMapX += 18 + this.iFrameIndex * 2;
                            break;
                        }
                        case 1: {
                            this.iFootMapY += 18 + this.iFrameIndex * 2;
                        }
                    }
                    if (Game.isSpriteAtScreen(this)) return;
                    this.bShow = false;
                    return;
                }
                if ((this.lDrawTime & 1L) == 0L) {
                    ++this.iFrameIndex;
                }
                if (this.iFrameIndex < this.actData[this.actData.length - 1].frameNum) return;
                if (this.iRESID == 0) {
                    Game.bIslive = true;
                    if (Game.iLife < 0) return;
                    --Game.iLife;
                    return;
                }
                if (this.iType != 2) return;
                this.bShow = false;
                return;
            }
            case 6: {
                if ((this.lDrawTime & 1L) == 0L) {
                    ++this.iFrameIndex;
                }
                if (this.iFrameIndex >= this.actData[this.state - 6].frameNum) {
                    this.iFrameIndex = 0;
                }
                if (this.iFootMapY != Game.iBossStartY || this.iFootMapX != Game.iBossStartX) {
                    if (Game.iBossHP == 1 && !Game.bIsHitBoss) {
                        if (this.iFootMapY >= this.iYD) {
                            this.yWay = (byte)(2 + (Game.rnd.nextInt() & 1));
                        }
                        if (this.iFootMapX >= this.iXR) {
                            this.yWay = (byte)(1 + (Game.rnd.nextInt() & 1));
                        }
                        if (this.iFootMapX <= this.iXL) {
                            this.yWay = (byte)(3 + (Game.rnd.nextInt() & 1));
                        }
                        if (this.iFootMapY <= this.iYU) {
                            this.yWay = (byte)(1 + (Game.rnd.nextInt() & 1) * 3);
                        }
                        this.startAct((byte)12);
                        return;
                    }
                    this.startAct((byte)7);
                    Game.iBossEndX = Game.iBossStartX;
                    Game.iBossEndY = Game.iBossStartY;
                    return;
                }
                if ((this.lDrawTime & 0x1FL) != 0L) return;
                Game.bIsHitBoss = false;
                if (Game.iBossHP == 2) {
                    this.yWay = 1;
                } else {
                    this.yWay = (byte)((Game.rnd.nextInt() & 3) + 1);
                    switch (this.yWay) {
                        case 2: {
                            Game.iBossEndX = this.iXL;
                            Game.iBossEndY = this.iYM;
                            break;
                        }
                        case 3: {
                            Game.iBossEndX = Game.iBossStartX;
                            Game.iBossEndY = this.iYU;
                            break;
                        }
                        case 4: {
                            Game.iBossEndX = this.iXR;
                            Game.iBossEndY = this.iYM;
                            break;
                        }
                        case 1: {
                            Game.iBossEndX = Game.iBossStartX;
                            Game.iBossEndY = this.iYD;
                        }
                    }
                }
                this.startAct((byte)7);
                return;
            }
            case 7: {
                if ((this.lDrawTime & 1L) == 0L) {
                    ++this.iFrameIndex;
                }
                if (this.iFrameIndex < this.actData[this.state - 6].frameNum) return;
                this.startAct((byte)8);
                if (Game.iBossHP != 2 || this.iFootMapY != Game.iBossStartY || this.iFootMapX != Game.iBossStartX) return;
                Game.bIsAim = false;
                Game.iBossEndX = Game.iAimX + Game.aimImg.getWidth() - this.iFootw / 2;
                Game.iBossEndY = Game.iAimY + Game.aimImg.getHeight() / 6 - this.iFooth / 2;
                return;
            }
            case 8: {
                if ((this.lDrawTime & 1L) == 0L) {
                    ++this.iFrameIndex;
                }
                if (this.iFrameIndex >= this.actData[this.state - 6].frameNum) {
                    this.iFrameIndex = 0;
                }
                this.iFootMapY -= 16;
                if (this.iFootMapY >= -16) return;
                this.iFootMapX = Game.iBossEndX;
                this.startAct((byte)9);
                return;
            }
            case 9: {
                if ((this.lDrawTime & 1L) == 0L) {
                    ++this.iFrameIndex;
                }
                if (this.iFrameIndex >= this.actData[this.state - 6].frameNum) {
                    this.iFrameIndex = 0;
                }
                this.iFootMapY += 16;
                if (this.iFootMapY <= Game.iBossEndY) return;
                this.iFootMapY = Game.iBossEndY;
                this.startAct((byte)10);
                if (Game.bIsOpenVibra && Game.bIsCanVibra) {
                    DOGMIDlet.display.vibrate(100);
                }
                Game.bIsShake = true;
                return;
            }
            case 10: {
                if ((this.lDrawTime & 1L) == 0L) {
                    ++this.iFrameIndex;
                }
                if (this.iFrameIndex >= this.actData[this.state - 6].frameNum) {
                    if (this.iFootMapY == Game.iBossStartY && this.iFootMapX == Game.iBossStartX || Game.iBossHP == 1) {
                        this.startAct((byte)6);
                    } else {
                        this.startAct((byte)11);
                    }
                }
                if (this.iFrameIndex < this.actData[this.state - 6].frameNum >> 1) return;
                Game.bIsShake = false;
                return;
            }
            case 11: {
                if ((this.lDrawTime & 1L) == 0L) {
                    ++this.iFrameIndex;
                }
                if (this.iFrameIndex < this.actData[this.state - 6].frameNum) return;
                this.startAct((byte)6);
                Game.bIsAim = true;
                return;
            }
            case 12: {
                ++this.iFrameIndex;
                if (this.iFrameIndex >= this.actData[this.state - 6].frameNum) {
                    this.iFrameIndex = 0;
                }
                switch (this.yWay) {
                    case 2: {
                        if (this.iFootMapY > this.iYM || this.iFootMapX <= this.iXM) {
                            this.iFootMapX -= 4;
                            this.iFootMapY -= 4;
                            if (this.iFootMapX > this.iXL || this.iFootMapY > this.iYM) return;
                            this.iFootMapX = this.iXL;
                            this.iFootMapY = this.iYM;
                            this.startAct((byte)6);
                            break block5;
                        } else {
                            this.iFootMapX -= 4;
                            this.iFootMapY -= 4;
                            if (this.iFootMapX > this.iXM || this.iFootMapY > this.iYU) return;
                            this.iFootMapX = this.iXM;
                            this.iFootMapY = this.iYU;
                            this.startAct((byte)6);
                            break block5;
                        }
                    }
                    case 3: {
                        if (this.iFootMapY < this.iYM || this.iFootMapX <= this.iXM) {
                            this.iFootMapX += 4;
                            this.iFootMapY -= 4;
                            if (this.iFootMapX < this.iXM || this.iFootMapY > this.iYU) return;
                            this.iFootMapX = this.iXM;
                            this.iFootMapY = this.iYU;
                            this.startAct((byte)6);
                            break block5;
                        } else {
                            this.iFootMapX += 4;
                            this.iFootMapY -= 4;
                            if (this.iFootMapX < this.iXR || this.iFootMapY > this.iYM) return;
                            this.iFootMapX = this.iXR;
                            this.iFootMapY = this.iYM;
                            this.startAct((byte)6);
                            break block5;
                        }
                    }
                    case 4: {
                        if (this.iFootMapY < this.iYM || this.iFootMapX >= this.iXM) {
                            this.iFootMapX += 4;
                            this.iFootMapY += 4;
                            if (this.iFootMapX < this.iXR || this.iFootMapY < this.iYM) return;
                            this.iFootMapX = this.iXR;
                            this.iFootMapY = this.iYM;
                            this.startAct((byte)6);
                            break block5;
                        } else {
                            this.iFootMapX += 4;
                            this.iFootMapY += 4;
                            if (this.iFootMapX < this.iXM || this.iFootMapY < this.iYD) return;
                            this.iFootMapX = this.iXM;
                            this.iFootMapY = this.iYD;
                            this.startAct((byte)6);
                            break block5;
                        }
                    }
                    case 1: {
                        if (this.iFootMapY > this.iYM || this.iFootMapX >= this.iXM) {
                            this.iFootMapX -= 4;
                            this.iFootMapY += 4;
                            if (this.iFootMapX > this.iXM || this.iFootMapY < this.iYD) return;
                            this.iFootMapX = this.iXM;
                            this.iFootMapY = this.iYD;
                            this.startAct((byte)6);
                        } else {
                            this.iFootMapX -= 4;
                            this.iFootMapY += 4;
                            if (this.iFootMapX > this.iXL || this.iFootMapY < this.iYM) return;
                            this.iFootMapX = this.iXL;
                            this.iFootMapY = this.iYM;
                            this.startAct((byte)6);
                        }
                    }
                }
            }
        }
    }

    public int getWay(int way) {
        switch (way) {
            case 1: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        return 1;
    }

    public void attackCheck() {
        FrameData fd;
        if (this.iType == 8) {
            if (Game.role.state != 5) {
                FrameData fd2 = this.frameData[this.iCurrentFrame];
                if (fd2.bAtkFrame && Game.checkHurt(fd2.atkRect.x + this.iFootMapX, fd2.atkRect.y + this.iFootMapY, fd2.atkRect.width, fd2.atkRect.height)) {
                    Game.role.startAct((byte)5);
                }
                return;
            }
        }
        if (this.iType == 11 && this.state == 0) {
            if (Game.role.state != 5) {
                fd = this.frameData[this.iCurrentFrame];
                if (Game.checkHurt(fd.bodyRect.x + this.iFootMapX, fd.bodyRect.y + this.iFootMapY, fd.bodyRect.width, fd.bodyRect.height)) {
                    this.startAct((byte)1);
                    Game.bIsBallStartAction = true;
                }
            }
        }
        if (this.iType != 0 && this.iType != 2 && this.iType != 6 && this.iType != 10 && this.iType != 12 && this.iType != 13) {
            return;
        }
        if (Game.role.state == 5) {
            return;
        }
        if (!Game.checkCanHit(this.iFootMapY, this.iFooth, Game.role.iFootMapY, Game.role.iFooth) && this.iRESID != 29 && this.iRESID != 30) {
            return;
        }
        if (this.iRESID == 0) {
            fd = this.frameData[this.iCurrentFrame];
            if (fd.bAtkFrame) {
                Game.checkHit(fd.atkRect.x + this.iFootMapX, fd.atkRect.y + this.iFootMapY, fd.atkRect.width, fd.atkRect.height);
            }
        } else if (this.iType == 2 && this.state == 0 && this.iRESID != 10) {
            fd = this.frameData[this.iCurrentFrame];
            boolean b = Game.checkHurt(fd.bodyRect.x + this.iFootMapX, fd.bodyRect.y + this.iFootMapY, fd.bodyRect.width, fd.bodyRect.height);
            if (b) {
                if (this.iRESID == 6) {
                    ++Game.iPt;
                } else if (this.iRESID == 7) {
                    ++Game.iLife;
                } else if (this.iRESID == 8) {
                    Game.iSaveMapX = this.iFootMapX;
                    Game.iSaveMapY = this.iFootMapY;
                    Game.iSaveX = Game.iX;
                    Game.iSaveY = Game.iY;
                    Game.bSaveWay = Game.role.yWay;
                }
                this.startAct((byte)5);
            }
        } else if (this.iType == 12 && this.state == 1) {
            fd = this.frameData[this.iCurrentFrame];
            if (Game.checkHurt(fd.bodyRect.x + this.iFootMapX, fd.bodyRect.y + this.iFootMapY, fd.bodyRect.width, fd.bodyRect.height)) {
                Game.role.startAct((byte)5);
            }
        } else {
            boolean b;
            fd = this.frameData[this.iCurrentFrame];
            if ((this.iType == 6 || this.iType == 10) && this.state != 5 && (b = Game.checkHurt(fd.bodyRect.x + this.iFootMapX, fd.bodyRect.y + this.iFootMapY, fd.bodyRect.width, fd.bodyRect.height))) {
                Game.role.startAct((byte)5);
            }
            if (this.iType == 13 && !Game.bIsHitBoss && (this.state == 7 || this.state == 10 || this.state == 12) && (b = Game.role.collision(this.iFootMapX - 10, this.iFootMapY - 8, this.iFootw + 20, this.iFooth + 16))) {
                Game.role.startAct((byte)5);
            }
        }
    }

    public void screenMove(int way, int mx, int my, int mw, int mh) {
        switch (way) {
            case 1: {
                if (this.iOffy <= my + 16 || this.iFootMapY <= this.iStepSize) break;
                this.move(way);
                break;
            }
            case 3: {
                if (this.iOffy + this.iFooth >= mh) break;
                this.move(way);
                break;
            }
            case 4: {
                if (this.iOffx <= mx || this.iFootMapX <= this.iStepSize) break;
                this.move(way);
                break;
            }
            case 2: {
                if (this.iOffx + this.iFootw >= mw) break;
                this.move(way);
            }
        }
    }

    public void move(int way) {
        switch (way) {
            case 1: {
                this.iFootMapY -= this.iStepSize;
                break;
            }
            case 3: {
                this.iFootMapY += this.iStepSize;
                break;
            }
            case 4: {
                this.iFootMapX -= this.iStepSize;
                break;
            }
            case 2: {
                this.iFootMapX += this.iStepSize;
            }
        }
    }

    public void setDir(int way) {
        switch (way) {
            case 3: {
                this.yCurrentDir = (byte)3;
                this.yWay = (byte)3;
                break;
            }
            case 1: {
                this.yCurrentDir = 1;
                this.yWay = 1;
                break;
            }
            case 2: {
                this.yCurrentDir = (byte)2;
                this.yWay = (byte)2;
                break;
            }
            case 4: {
                this.yCurrentDir = (byte)4;
                this.yWay = (byte)4;
            }
        }
    }

    public void setKeyDir(int way) {
        switch (way) {
            case 3: {
                this.setDir(1);
                break;
            }
            case 1: {
                this.setDir(3);
                break;
            }
            case 2: {
                this.setDir(4);
                break;
            }
            case 4: {
                this.setDir(2);
            }
        }
    }

    public boolean collision(int iX, int iY, int iW, int iH) {
        return iX + iW > this.iFootMapX && iX < this.iFootMapX + this.iFootw && iY + iH > this.iFootMapY && iY < this.iFootMapY + this.iFooth;
    }

    public boolean collision2(int iX, int iY, int iW, int iH, int x, int y, int w, int h) {
        return iX + iW > this.iFootMapX + x && iX < this.iFootMapX + x + w && iY + iH > this.iFootMapY + y && iY < this.iFootMapY + y + h;
    }
}

