/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class GameAnimation {
    private static final Random random = new Random();
    public static final int PLAY_ANIMATION_LOOP = 0;
    public static final int PLAY_ANIMATION_ONCE = 1;
    public static final int PLAY_ANIMATION_LOOP_POING = 3;
    public static final int CLIP_NONE = 0;
    public static final int CLIP_BOUNDING_BOX = 1;
    public static final int CLIP_ELEMENTS = 2;
    public static final int CLIP_ALL = 3;
    public short[][] animationFrameFileNumber;
    public short[][] animationFramePositionX;
    public short[][] animationFramePositionY;
    public short[] animationFrameLeft;
    public short[] animationFrameRight;
    public short[] animationFrameUp;
    public short[] animationFrameDown;
    public short[][] animationFrameNumber;
    public short[][] animationPositionX;
    public short[][] animationPositionY;
    public short screenWidth;
    public short screenHeight;
    private boolean isDoublePixel = false;
    public Image[] animationImage;
    public short[] animationImageWidth;
    public short[] animationImageHeight;

    GameAnimation(MIDlet midlet, String animationFileNumber, String imagesFileNumber, boolean[] isAnimation, boolean bgs, int _screenWidth, int _screenHeight) {
        this.screenWidth = (short)_screenWidth;
        this.screenHeight = (short)_screenHeight;
        boolean[] isImage = new boolean[512];
        this.loadAnimationFile(midlet, animationFileNumber, isAnimation, isImage);
        if (bgs) {
            this.animationImage = GameAnimation.loadImagesBGS(midlet, imagesFileNumber, 0, null);
        }
        if (this.animationImage != null) {
            this.animationImageWidth = new short[this.animationImage.length];
            this.animationImageHeight = new short[this.animationImage.length];
            for (int i = 0; i < this.animationImage.length; ++i) {
                if (this.animationImage[i] == null) continue;
                this.animationImageWidth[i] = (short)this.animationImage[i].getWidth();
                this.animationImageHeight[i] = (short)this.animationImage[i].getHeight();
            }
        }
        this.setFramesBoundingBox();
    }

    public void freeMemory() {
        int i;
        if (this.animationImage != null) {
            for (i = 0; i < this.animationImage.length; ++i) {
                this.animationImage[i] = null;
            }
            this.animationImage = null;
        }
        if (this.animationFrameFileNumber != null) {
            for (i = 0; i < this.animationFrameFileNumber.length; ++i) {
                this.animationFrameFileNumber[i] = null;
            }
            this.animationFrameFileNumber = null;
        }
        if (this.animationFramePositionX != null) {
            for (i = 0; i < this.animationFramePositionX.length; ++i) {
                this.animationFramePositionX[i] = null;
            }
            this.animationFramePositionX = null;
        }
        if (this.animationFramePositionY != null) {
            for (i = 0; i < this.animationFramePositionY.length; ++i) {
                this.animationFramePositionY[i] = null;
            }
            this.animationFramePositionY = null;
        }
        this.animationFrameLeft = null;
        this.animationFrameRight = null;
        this.animationFrameUp = null;
        this.animationFrameDown = null;
        if (this.animationFrameNumber != null) {
            for (i = 0; i < this.animationFrameNumber.length; ++i) {
                this.animationFrameNumber[i] = null;
            }
            this.animationFrameNumber = null;
        }
        if (this.animationPositionX != null) {
            for (i = 0; i < this.animationPositionX.length; ++i) {
                this.animationPositionX[i] = null;
            }
            this.animationPositionX = null;
        }
        if (this.animationPositionY != null) {
            for (i = 0; i < this.animationPositionY.length; ++i) {
                this.animationPositionY[i] = null;
            }
            this.animationPositionY = null;
        }
        this.animationImageWidth = null;
        this.animationImageHeight = null;
        System.gc();
    }

    public int getSetsNum() {
        return 1;
    }

    public int getAnimationNum() {
        return this.animationFrameNumber.length;
    }

    public final int getWidth(int n, int m) {
        return this.animationFrameRight[this.animationFrameNumber[n][m]] - this.animationFrameLeft[this.animationFrameNumber[n][m]];
    }

    public final int getHeight(int n, int m) {
        return this.animationFrameUp[this.animationFrameNumber[n][m]] - this.animationFrameDown[this.animationFrameNumber[n][m]];
    }

    public final int getWidth() {
        int width = 0;
        for (int i = 0; i < this.animationFrameRight.length; ++i) {
            int w = this.animationFrameRight[i] - this.animationFrameLeft[i];
            if (w <= width) continue;
            width = w;
        }
        return width;
    }

    public final int getHeight() {
        int height = 0;
        for (int i = 0; i < this.animationFrameUp.length; ++i) {
            int h = this.animationFrameUp[i] - this.animationFrameDown[i];
            if (h <= height) continue;
            height = h;
        }
        return height;
    }

    public final int getFrameNum(int anim) {
        return this.animationFrameNumber[anim].length;
    }

    private void setFramesBoundingBox() {
        if (this.animationFrameFileNumber == null) {
            return;
        }
        int _animationFrameNumber = this.animationFrameFileNumber.length;
        int _imageWidth = 0;
        int _imageHeight = 0;
        this.animationFrameLeft = new short[_animationFrameNumber];
        this.animationFrameRight = new short[_animationFrameNumber];
        this.animationFrameUp = new short[_animationFrameNumber];
        this.animationFrameDown = new short[_animationFrameNumber];
        for (int i = 0; i < _animationFrameNumber; ++i) {
            int _animationFrameParts;
            int n = _animationFrameParts = this.animationFrameFileNumber[i] == null ? 0 : this.animationFrameFileNumber[i].length;
            if (_animationFrameParts > 0) {
                _imageWidth = this.animationImage[this.animationFrameFileNumber[i][0]] != null ? this.animationImage[this.animationFrameFileNumber[i][0]].getWidth() : 0;
                _imageHeight = this.animationImage[this.animationFrameFileNumber[i][0]] != null ? this.animationImage[this.animationFrameFileNumber[i][0]].getHeight() : 0;
                this.animationFrameLeft[i] = this.animationFramePositionX[i][0];
                this.animationFrameRight[i] = (short)(this.animationFramePositionX[i][0] + _imageWidth);
                this.animationFrameUp[i] = (short)(this.animationFramePositionY[i][0] + _imageHeight);
                this.animationFrameDown[i] = this.animationFramePositionY[i][0];
            }
            for (int j = 1; j < _animationFrameParts; ++j) {
                _imageWidth = this.animationImage[this.animationFrameFileNumber[i][j]] != null ? this.animationImage[this.animationFrameFileNumber[i][j]].getWidth() : 0;
                int n2 = _imageHeight = this.animationImage[this.animationFrameFileNumber[i][j]] != null ? this.animationImage[this.animationFrameFileNumber[i][j]].getHeight() : 0;
                if (this.animationFramePositionX[i][j] < this.animationFrameLeft[i]) {
                    this.animationFrameLeft[i] = this.animationFramePositionX[i][j];
                }
                if (this.animationFramePositionX[i][j] + _imageWidth > this.animationFrameRight[i]) {
                    this.animationFrameRight[i] = (short)(this.animationFramePositionX[i][j] + _imageWidth);
                }
                if (this.animationFramePositionY[i][j] + _imageHeight > this.animationFrameUp[i]) {
                    this.animationFrameUp[i] = (short)(this.animationFramePositionY[i][j] + _imageHeight);
                }
                if (this.animationFramePositionY[i][j] >= this.animationFrameDown[i]) continue;
                this.animationFrameDown[i] = this.animationFramePositionY[i][j];
            }
        }
    }

    private void loadAnimationFile(MIDlet midlet, String name, boolean[] isAnimation, boolean[] isImage) {
        boolean[] isFrame;
        block25: {
            boolean _afpX = false;
            boolean _afpY = false;
            boolean _apX = false;
            boolean _apY = false;
            InputStream is = null;
            DataInputStream dis = null;
            isFrame = new boolean[256];
            try {
                byte _tempByte2;
                byte _tempByte1;
                byte _tempByte0;
                is = midlet.getClass().getResourceAsStream(name);
                dis = new DataInputStream(is);
                int _animationFrameNumber = dis.readShort();
                int _animationNumber = dis.readShort();
                byte _animationFileType = dis.readByte();
                if (_animationFileType == 3) {
                    byte _tempType3Setup = dis.readByte();
                    _afpX = (_tempType3Setup & 1) == 1;
                    _afpY = (_tempType3Setup >> 1 & 1) == 1;
                    _apX = (_tempType3Setup >> 2 & 1) == 1;
                    _apY = (_tempType3Setup >> 3 & 1) == 1;
                }
                this.animationFrameFileNumber = new short[_animationFrameNumber][];
                this.animationFramePositionX = new short[_animationFrameNumber][];
                this.animationFramePositionY = new short[_animationFrameNumber][];
                this.animationFrameNumber = new short[_animationNumber][];
                this.animationPositionX = new short[_animationNumber][];
                this.animationPositionY = new short[_animationNumber][];
                for (int i = 0; i < _animationFrameNumber; ++i) {
                    int _animationFrameParts = dis.readUnsignedByte();
                    this.animationFrameFileNumber[i] = new short[_animationFrameParts];
                    this.animationFramePositionX[i] = new short[_animationFrameParts];
                    this.animationFramePositionY[i] = new short[_animationFrameParts];
                    for (int j = 0; j < _animationFrameParts; ++j) {
                        this.animationFrameFileNumber[i][j] = (short)dis.readUnsignedByte();
                        if (_animationFileType == 1) {
                            this.animationFramePositionX[i][j] = dis.readByte();
                            this.animationFramePositionY[i][j] = dis.readByte();
                        } else if (_animationFileType == 2) {
                            this.animationFramePositionX[i][j] = dis.readShort();
                            this.animationFramePositionY[i][j] = dis.readShort();
                        } else if (_animationFileType == 3) {
                            this.animationFramePositionX[i][j] = _afpX ? dis.readShort() : (short)dis.readByte();
                            this.animationFramePositionY[i][j] = _afpY ? dis.readShort() : (short)dis.readByte();
                        } else if (_animationFileType == 4) {
                            _tempByte0 = dis.readByte();
                            _tempByte1 = dis.readByte();
                            _tempByte2 = dis.readByte();
                            this.animationFramePositionX[i][j] = (short)((_tempByte0 >> 4 & 0xF) << 8 | _tempByte1);
                            this.animationFramePositionX[i][j] = this.animationFramePositionX[i][j] > 2048 ? (short)(this.animationFramePositionX[i][j] - 4096) : this.animationFramePositionX[i][j];
                            this.animationFramePositionY[i][j] = (short)((_tempByte0 & 0xF) << 8 | _tempByte2);
                            short s = this.animationFramePositionY[i][j] = this.animationFramePositionY[i][j] > 2048 ? (short)(this.animationFramePositionY[i][j] - 4096) : this.animationFramePositionY[i][j];
                        }
                        if (!this.isDoublePixel) continue;
                        short[] sArray = this.animationFramePositionX[i];
                        int n = j;
                        sArray[n] = (short)(sArray[n] * 2);
                        short[] sArray2 = this.animationFramePositionY[i];
                        int n2 = j;
                        sArray2[n2] = (short)(sArray2[n2] * 2);
                    }
                }
                for (int i = 0; i < _animationNumber; ++i) {
                    int _animationLength = dis.readUnsignedByte();
                    this.animationFrameNumber[i] = new short[_animationLength];
                    this.animationPositionX[i] = new short[_animationLength];
                    this.animationPositionY[i] = new short[_animationLength];
                    for (int j = 0; j < _animationLength; ++j) {
                        this.animationFrameNumber[i][j] = dis.readShort();
                        if (isAnimation == null || isAnimation[i]) {
                            isFrame[this.animationFrameNumber[i][j]] = true;
                        }
                        if (_animationFileType == 1) {
                            this.animationPositionX[i][j] = dis.readByte();
                            this.animationPositionY[i][j] = dis.readByte();
                            continue;
                        }
                        if (_animationFileType == 2) {
                            this.animationPositionX[i][j] = dis.readShort();
                            this.animationPositionY[i][j] = dis.readShort();
                            continue;
                        }
                        if (_animationFileType == 3) {
                            this.animationPositionX[i][j] = _apX ? dis.readShort() : (short)dis.readByte();
                            this.animationPositionY[i][j] = _apY ? dis.readShort() : (short)dis.readByte();
                            continue;
                        }
                        if (_animationFileType != 4) continue;
                        _tempByte0 = dis.readByte();
                        _tempByte1 = dis.readByte();
                        _tempByte2 = dis.readByte();
                        this.animationPositionX[i][j] = (short)((_tempByte0 >> 4 & 0xF) << 8 | _tempByte1);
                        this.animationPositionX[i][j] = this.animationPositionX[i][j] > 2048 ? (short)(this.animationPositionX[i][j] - 4096) : this.animationPositionX[i][j];
                        this.animationPositionY[i][j] = (short)((_tempByte0 & 0xF) << 8 | _tempByte2);
                        this.animationPositionY[i][j] = this.animationPositionY[i][j] > 2048 ? (short)(this.animationPositionY[i][j] - 4096) : this.animationPositionY[i][j];
                    }
                }
                dis.close();
                dis = null;
                is = null;
            }
            catch (Exception e) {
                System.out.println("loadAnimationFile Exception: B\u0142\u0105d pliku o nazwie:  " + name);
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception ed) {
                        // empty catch block
                    }
                    is = null;
                }
                if (dis == null) break block25;
                try {
                    dis.close();
                }
                catch (Exception ed) {
                    // empty catch block
                }
                dis = null;
            }
        }
        for (int i = 0; i < this.animationFrameFileNumber.length; ++i) {
            if (!isFrame[i]) continue;
            for (int j = 0; j < this.animationFrameFileNumber[i].length; ++j) {
                isImage[this.animationFrameFileNumber[i][j]] = true;
            }
        }
    }

    public static Image[] loadImagesBGS(MIDlet midlet, String name, int palettesSetNumber, boolean[] isImage) {
        Image[] images;
        block28: {
            DataInputStream dis = null;
            int _tmp1 = 0;
            int alphaUsageBit = 1;
            alphaUsageBit = (short)(alphaUsageBit << palettesSetNumber);
            try {
                dis = new DataInputStream(midlet.getClass().getResourceAsStream(name));
                dis.readByte();
                dis.readByte();
                dis.readByte();
                byte BGSversion = dis.readByte();
                int _palSets = dis.readUnsignedByte();
                if (_palSets <= palettesSetNumber) {
                    throw new Exception("Plik nie zawiera podanego w parametrze zestawu palet");
                }
                int _palGroups = dis.readUnsignedByte();
                short[] _palettesIndices = new short[_palGroups];
                for (int z = 0; z < _palSets; ++z) {
                    if (z == palettesSetNumber) {
                        for (int i = 0; i < _palGroups; ++i) {
                            _palettesIndices[i] = (short)dis.readUnsignedByte();
                            if (_palettesIndices[i] <= _tmp1) continue;
                            _tmp1 = _palettesIndices[i];
                        }
                        continue;
                    }
                    dis.skipBytes(_palGroups);
                }
                int[][] _rgbEntries = new int[++_tmp1][];
                int _palettesInFile = dis.readUnsignedByte();
                for (int i = 0; i < _palettesInFile; ++i) {
                    boolean _isPaletteUsed = false;
                    for (int g = 0; g < _palGroups; ++g) {
                        int c;
                        if (_palettesIndices[g] != (short)i) continue;
                        _tmp1 = dis.readUnsignedByte() + 1;
                        _rgbEntries[i] = new int[_tmp1];
                        int _tempColor = 0;
                        for (c = 0; c < _tmp1; ++c) {
                            _tempColor = -16777216;
                            _tempColor |= dis.readByte() << 16 & 0xFF0000;
                            _tempColor |= dis.readByte() << 8 & 0xFF00;
                            _rgbEntries[i][c] = _tempColor |= dis.readByte() & 0xFF;
                        }
                        _tmp1 = dis.readUnsignedByte() + 1;
                        for (c = 0; c < _tmp1; ++c) {
                            int[] nArray = _rgbEntries[i];
                            int n = c;
                            nArray[n] = nArray[n] & (dis.readByte() == 0 ? 0xFFFFFF : -1);
                        }
                        _isPaletteUsed = true;
                        break;
                    }
                    if (_isPaletteUsed) continue;
                    dis.skipBytes((dis.readUnsignedByte() + 1) * 3);
                    dis.skipBytes(dis.readUnsignedByte() + 1);
                }
                int _imagesNumber = dis.readUnsignedByte();
                images = new Image[_imagesNumber];
                byte[] _imagesTransformations = new byte[_imagesNumber];
                short[] _imagesDataIndices = new short[_imagesNumber];
                short[] _imagesGroupIndices = new short[_imagesNumber];
                byte[] _imagesAlphaUsage = null;
                if (BGSversion >= 2) {
                    _imagesAlphaUsage = new byte[_imagesNumber];
                }
                for (int i = 0; i < _imagesNumber; ++i) {
                    _imagesTransformations[i] = dis.readByte();
                    _imagesGroupIndices[i] = (short)dis.readUnsignedByte();
                    _imagesDataIndices[i] = (short)dis.readUnsignedByte();
                    if (BGSversion < 2) continue;
                    _imagesAlphaUsage[i] = dis.readByte();
                }
                _tmp1 = dis.readUnsignedByte();
                short[] _rawDataSetsWidths = new short[_tmp1];
                short[] _rawDataSetsHeights = new short[_tmp1];
                byte[] _rawDataSetsFormats = new byte[_tmp1];
                for (int i = 0; i < _tmp1; ++i) {
                    _rawDataSetsWidths[i] = (short)dis.readUnsignedShort();
                    _rawDataSetsHeights[i] = (short)dis.readUnsignedShort();
                    _rawDataSetsFormats[i] = dis.readByte();
                }
                for (int i = 0; i < _tmp1; ++i) {
                    int _Bpp = (short)_rawDataSetsFormats[i] == 0 ? 1 : ((short)_rawDataSetsFormats[i] == 1 ? 3 : 4);
                    int rawSize = _rawDataSetsWidths[i] * _rawDataSetsHeights[i] * _Bpp;
                    boolean _isDataLoaded = false;
                    byte[] _rawData = null;
                    int[] _rawDataInt = null;
                    block21: for (int im = 0; im < _imagesNumber; ++im) {
                        if (isImage != null && !isImage[im] || _imagesDataIndices[im] != (short)i) continue;
                        if (!_isDataLoaded) {
                            switch (_Bpp) {
                                case 1: {
                                    _rawData = new byte[rawSize];
                                    dis.read(_rawData);
                                    break;
                                }
                                case 3: {
                                    _rawDataInt = new int[_rawDataSetsWidths[i] * _rawDataSetsHeights[i]];
                                    _rawData = new byte[rawSize];
                                    dis.read(_rawData);
                                    int offInt = 0;
                                    int offBytes = 0;
                                    while (offInt < _rawDataInt.length) {
                                        _rawDataInt[offInt] = -16777216;
                                        int n = offInt;
                                        _rawDataInt[n] = _rawDataInt[n] | (_rawData[offBytes++] & 0xFF) << 16 & 0xFF0000;
                                        int n2 = offInt;
                                        _rawDataInt[n2] = _rawDataInt[n2] | (_rawData[offBytes++] & 0xFF) << 8 & 0xFF00;
                                        int n3 = offInt++;
                                        _rawDataInt[n3] = _rawDataInt[n3] | _rawData[offBytes++] & 0xFF & 0xFF;
                                    }
                                    _rawData = null;
                                    break;
                                }
                                case 4: {
                                    int size = _rawDataSetsWidths[i] * _rawDataSetsHeights[i];
                                    _rawDataInt = new int[size];
                                    for (int offInt = 0; offInt < size; ++offInt) {
                                        _rawDataInt[offInt] = dis.readInt();
                                    }
                                    break;
                                }
                            }
                            _isDataLoaded = true;
                        }
                        switch (_Bpp) {
                            case 1: {
                                boolean isAlpha = BGSversion >= 2 ? (_imagesAlphaUsage[im] & 0xFF & alphaUsageBit) != 0 : true;
                                System.out.println(name);
                                images[im] = GameAnimation.createFromBGSCreateRGBImageVersion(_rawDataSetsWidths[i], _rawDataSetsHeights[i], _rawDataSetsFormats[i], _imagesTransformations[im], _rawData, _rgbEntries[_palettesIndices[_imagesGroupIndices[im]]], isAlpha);
                                continue block21;
                            }
                        }
                    }
                    if (_isDataLoaded) continue;
                    dis.skipBytes(rawSize);
                }
                dis.close();
                dis = null;
            }
            catch (Exception e) {
                System.out.println("loadImages Exception: B??d pliku o nazwie:  " + name);
                images = null;
                if (dis == null) break block28;
                try {
                    dis.close();
                }
                catch (Exception ed) {
                    // empty catch block
                }
                dis = null;
            }
        }
        return images;
    }

    static Image createFromBGSCreateRGBImageVersion(int width, int height, byte imageFormat, byte transform, byte[] rawData, int[] rgbEntries, boolean _isAlpha) {
        int[] _data = new int[width * height];
        int _srcPtr = 0;
        int _rawLength = rgbEntries.length;
        boolean _transform4 = (transform & 4) == 0;
        int x = 0;
        int y = 0;
        int k = 0;
        switch (transform & 3) {
            case 0: {
                if (_transform4) {
                    for (k = width * height - 1; k >= 0; --k) {
                        int _raw = rawData[k] & 0xFF;
                        _data[k] = _raw < _rawLength ? rgbEntries[_raw] : 0;
                    }
                } else {
                    for (y = 0; y < height; ++y) {
                        int _offset = (y + 1) * width - 1;
                        for (x = width - 1; x >= 0; --x) {
                            int _raw = rawData[_srcPtr++] & 0xFF;
                            _data[_offset--] = _raw < _rawLength ? rgbEntries[_raw] : 0;
                        }
                    }
                }
                break;
            }
            case 1: {
                if (_transform4) {
                    for (y = 0; y < height; ++y) {
                        int _offset = height - y - 1;
                        for (x = width - 1; x >= 0; --x) {
                            int _raw;
                            _data[_offset] = (_raw = rawData[_srcPtr++] & 0xFF) < _rawLength ? rgbEntries[_raw] : 0;
                            _offset += height;
                        }
                    }
                } else {
                    for (y = 0; y < height; ++y) {
                        int _offset = y;
                        for (x = width - 1; x >= 0; --x) {
                            int _raw;
                            _data[_offset] = (_raw = rawData[_srcPtr++] & 0xFF) < _rawLength ? rgbEntries[_raw] : 0;
                            _offset += height;
                        }
                    }
                }
                break;
            }
            case 2: {
                if (_transform4) {
                    for (y = height; y > 0; --y) {
                        int _offset = y * width - 1;
                        for (x = width - 1; x >= 0; --x) {
                            int _raw = rawData[_srcPtr++] & 0xFF;
                            _data[_offset--] = _raw < _rawLength ? rgbEntries[_raw] : 0;
                        }
                    }
                } else {
                    for (y = height; y > 0; --y) {
                        int _offset = (y - 1) * width;
                        for (x = width - 1; x >= 0; --x) {
                            int _raw = rawData[_srcPtr++] & 0xFF;
                            _data[_offset++] = _raw < _rawLength ? rgbEntries[_raw] : 0;
                        }
                    }
                }
                break;
            }
            case 3: {
                if (_transform4) {
                    for (y = height; y > 0; --y) {
                        int _offset = width * height - y;
                        for (x = width - 1; x >= 0; --x) {
                            int _raw;
                            _data[_offset] = (_raw = rawData[_srcPtr++] & 0xFF) < _rawLength ? rgbEntries[_raw] : 0;
                            _offset -= height;
                        }
                    }
                } else {
                    for (y = height; y > 0; --y) {
                        int _offset = width * height - (height - y) - 1;
                        for (x = width - 1; x >= 0; --x) {
                            int _raw;
                            _data[_offset] = (_raw = rawData[_srcPtr++] & 0xFF) < _rawLength ? rgbEntries[_raw] : 0;
                            _offset -= height;
                        }
                    }
                }
                break;
            }
        }
        if ((transform & 1) == 0) {
            return Image.createRGBImage((int[])_data, (int)width, (int)height, (boolean)true);
        }
        return Image.createRGBImage((int[])_data, (int)height, (int)width, (boolean)true);
    }

    public byte correctFrame(int _animationNumber, int _animationFrameNumber, int _animationPlayType) {
        if (_animationNumber >= this.animationFrameNumber.length) {
            _animationNumber = 0;
        }
        if (_animationPlayType == 0) {
            if (_animationFrameNumber >= this.animationFrameNumber[_animationNumber].length) {
                _animationFrameNumber %= this.animationFrameNumber[_animationNumber].length;
            }
        } else if (_animationPlayType == 1) {
            if (_animationFrameNumber >= this.animationFrameNumber[_animationNumber].length) {
                _animationFrameNumber = this.animationFrameNumber[_animationNumber].length - 1;
            }
        } else if (_animationPlayType == 3 && _animationFrameNumber >= this.animationFrameNumber[_animationNumber].length) {
            _animationFrameNumber %= this.animationFrameNumber[_animationNumber].length;
        }
        return (byte)_animationFrameNumber;
    }

    public byte moveAnimationX(int _animationNumber, int _animationFrameNumber, int _previousAnimationFrameNumber) {
        if (_animationNumber >= this.animationFrameNumber.length) {
            _animationNumber = 0;
        }
        int _animationLength = _animationFrameNumber >= this.animationPositionX[_animationNumber].length ? this.animationPositionX[_animationNumber].length - 1 : _animationFrameNumber;
        int _animationLength1 = _previousAnimationFrameNumber < 0 ? 0 : _previousAnimationFrameNumber;
        return (byte)(this.animationPositionX[_animationNumber][_animationLength] - this.animationPositionX[_animationNumber][_animationLength1]);
    }

    public byte moveAnimationY(int _animationNumber, int _animationFrameNumber, int _previousAnimationFrameNumber) {
        if (_animationNumber >= this.animationFrameNumber.length) {
            _animationNumber = 0;
        }
        int _animationLength = _animationFrameNumber >= this.animationPositionY[_animationNumber].length ? this.animationPositionY[_animationNumber].length - 1 : _animationFrameNumber;
        int _animationLength1 = _previousAnimationFrameNumber < 0 ? 0 : _previousAnimationFrameNumber;
        return (byte)(this.animationPositionY[_animationNumber][_animationLength] - this.animationPositionY[_animationNumber][_animationLength1]);
    }

    public void paintAnimation(int _set, int _animationNumber, int _animationFrameNumber, int _positionX, int _positionY, int _clippingType, Graphics _g) {
        if (_animationNumber >= this.animationFrameNumber.length) {
            _animationNumber = 0;
        }
        if (_animationFrameNumber >= this.animationFrameNumber[_animationNumber].length) {
            _animationFrameNumber %= this.animationFrameNumber[_animationNumber].length;
        } else if (_animationFrameNumber < 0) {
            _animationFrameNumber = this.animationFrameNumber[_animationNumber].length - 1;
        }
        short AnimationFrame = this.animationFrameNumber[_animationNumber][_animationFrameNumber];
        short AnimationPositionX = this.animationPositionX[_animationNumber][_animationFrameNumber];
        short AnimationPositionY = this.animationPositionY[_animationNumber][_animationFrameNumber];
        int _posX = _positionX + AnimationPositionX;
        int _posY = _positionY + AnimationPositionY;
        if (!(_clippingType != 1 && _clippingType != 3 || _posX + (this.animationFrameLeft[AnimationFrame] - this.screenWidth) <= 0 && _posX + this.animationFrameRight[AnimationFrame] >= 0 && _posY + (this.animationFrameDown[AnimationFrame] - this.screenHeight) <= 0 && _posY + this.animationFrameUp[AnimationFrame] >= 0)) {
            return;
        }
        int AnimationFrameParts = this.animationFrameFileNumber[AnimationFrame].length;
        for (int i = 0; i < AnimationFrameParts; ++i) {
            short AnimationFrameFileNumber = this.animationFrameFileNumber[AnimationFrame][i];
            _posX = _positionX + this.animationFramePositionX[AnimationFrame][i] + AnimationPositionX;
            _posY = _positionY + this.animationFramePositionY[AnimationFrame][i] + AnimationPositionY;
            if (this.animationImage[AnimationFrameFileNumber] == null || AnimationFrameFileNumber < 0 || _clippingType == 3 && (_posX - this.screenWidth > 0 || _posX + this.animationImageWidth[AnimationFrameFileNumber] < 0 || _posY - this.screenHeight > 0 || _posY + this.animationImageHeight[AnimationFrameFileNumber] < 0)) continue;
            _g.drawImage(this.animationImage[AnimationFrameFileNumber], _posX, _posY, 0);
        }
    }
}

