/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class TextMenu
extends Menu {
    public static final int SCROLLBAR_WIDTH = 8;
    public static final int COLOR_OVERLAP = 0;
    public static final int COLOR_BACKGROUND = 1328764;
    public static final int COLOR_RECT = 12706303;
    private int anchor;
    private int textId;
    private byte[][] splittedText;
    public int space;
    private int lineSpacing;
    public static final int BIT_MOVE = 10;
    private int fScrollPos;
    private int allPixels;
    private int scroll;
    private boolean finalMenu;

    public TextMenu(int _textId, Menu parent, int _lineSpacing, int _anchor, boolean _finalMenu) {
        super(_anchor, parent);
        this.textId = _textId;
        this.finalMenu = _finalMenu;
        this.anchor = _anchor;
        this.space = 9;
        this.lineSpacing = _lineSpacing;
        this.update();
    }

    public void update() {
        this.splittedText = BPFontReader.splitGraphicText(this.textId, 176 - 2 * this.space, false);
        this.allPixels = this.splittedText.length * (BPFontReader.getFontHeight(this.textId) + this.lineSpacing) - this.lineSpacing;
    }

    public void paint(Graphics g, int x, int y) {
        int i;
        int scrollPos = this.fScrollPos >> 10;
        int height = 208 - MainCanvas.UP_SPACE - MainCanvas.DOWN_SPACE;
        int pos1 = ((scrollPos << 10) + this.allPixels / 2) / this.allPixels;
        int pos2 = ((scrollPos + height << 10) + this.allPixels / 2) / this.allPixels;
        int anchor2 = this.anchor;
        if (scrollPos + height <= this.allPixels) {
            anchor2 = this.anchor & 0xD;
        }
        int alphabetId = BPFontReader.getAlphabetId(this.textId);
        int letterSpacing = BPFontReader.getLetterSpacing(this.textId);
        int _border = 5;
        g.setColor(14277598);
        g.fillRect(this.space + _border, MainCanvas.UP_SPACE + _border, 176 - 2 * this.space - 2 * _border, height - 2 * _border);
        g.drawImage(Game.gfx.animationImage[14], this.space - _border, MainCanvas.UP_SPACE - _border, 0);
        g.drawImage(Game.gfx.animationImage[15], this.space - _border, MainCanvas.UP_SPACE + height + _border, 36);
        g.drawImage(Game.gfx.animationImage[16], 176 - this.space + _border, MainCanvas.UP_SPACE - _border, 24);
        g.drawImage(Game.gfx.animationImage[13], 176 - this.space + _border, MainCanvas.UP_SPACE + height + _border, 40);
        short iW = Game.gfx.animationImageWidth[14];
        short iW2 = Game.gfx.animationImageWidth[10];
        int nW = (176 - 2 * this.space - 2 * iW + 2 * _border) / iW2 + 1;
        for (i = 0; i < nW; ++i) {
            g.drawImage(Game.gfx.animationImage[10], this.space + iW + i * iW2 - _border, MainCanvas.UP_SPACE - _border, 0);
            g.drawImage(Game.gfx.animationImage[9], this.space + iW + i * iW2 - _border, MainCanvas.UP_SPACE + height + _border, 36);
        }
        iW = Game.gfx.animationImageHeight[14];
        iW2 = Game.gfx.animationImageHeight[12];
        nW = (height - 2 * iW + 2 * _border) / iW2 + 1;
        for (i = 0; i < nW; ++i) {
            g.drawImage(Game.gfx.animationImage[12], this.space - _border, MainCanvas.UP_SPACE + iW + i * iW2 - _border, 0);
            g.drawImage(Game.gfx.animationImage[11], 176 - this.space + _border, MainCanvas.UP_SPACE + iW + i * iW2 - _border, 24);
        }
        if (MainCanvas.activeMenu != MainCanvas.sendingTxt) {
            BPFontReader.drawGraphicTextInWindow(this.splittedText, scrollPos, this.space, MainCanvas.UP_SPACE, 176 - 2 * this.space, height, g, anchor2, this.lineSpacing, alphabetId, letterSpacing);
        }
        g.setClip(0, 0, 176, 208);
        if (pos2 - pos1 < 1024) {
            g.setColor(1328764);
            g.fillRect(176 - this.space, MainCanvas.UP_SPACE, 8, height);
            g.setColor(12706303);
            int y1 = pos1 * (height - 2) >> 10;
            int y2 = pos2 * (height - 2) >> 10;
            g.fillRect(176 - this.space + 1, MainCanvas.UP_SPACE + y1 + 1, 6, y2 - y1);
            g.setColor(0);
            g.drawRect(176 - this.space, MainCanvas.UP_SPACE, 7, height - 1);
        }
        if (this.finalMenu) {
            Game.paintSofts(g, -1, -1, 13);
        } else {
            Game.paintSofts(g, 15, -1, 24);
        }
    }

    public void run(int delta) {
        int height = 208 - MainCanvas.UP_SPACE - MainCanvas.DOWN_SPACE;
        if (height > this.allPixels) {
            return;
        }
        int fontHeight = BPFontReader.getFontHeight(this.textId) + this.lineSpacing;
        int vel = 5120 * fontHeight;
        this.fScrollPos += this.scroll * vel * delta / 1000;
        if (this.fScrollPos < 0) {
            this.fScrollPos = 0;
        }
        if ((height << 10) + this.fScrollPos > this.allPixels << 10) {
            this.fScrollPos = this.allPixels - height << 10;
        }
    }

    public void run() {
        this.run(100);
    }

    public void show() {
    }

    public void keyPressed(int actionCode) {
        if (actionCode == 256 || actionCode == 1024 || actionCode == 2048) {
            this.scroll = 0;
            this.fScrollPos = 0;
            MainCanvas.activeMenu = this.parent;
            MainCanvas.activeMenu.show();
        }
        if (actionCode == 1) {
            this.scroll = -1;
        } else if (actionCode == 2) {
            this.scroll = 1;
        }
    }

    public void keyReleased(int actionCode) {
        this.scroll = 0;
    }
}

