/*
 * Decompiled with CFR 0.152.
 */
public class Sprites {
    public static final int NONESTATE = -1;
    public static final int RENDER_NORMAL = 0;
    public static final int RENDER_MIRROR = 1;
    public static final int RENDER_FLIP = 2;
    public static final byte CURRECT_ANI_START = 1;
    public static final byte CURRECT_ANI_RUN = 2;
    public static final byte CURRECT_ANI_END = 3;
    public static final byte CURRECT_ANI_STOP = 4;
    private byte currectAniState;
    private int _curState = -1;
    private int _defaultState = -1;
    private int _previousState = -1;
    private Animation[] _aniList;
    private Animation _curAni;
    private Container _m;
    private Layer _layer;
    private int worldX;
    private int worldY;
    private boolean _isDraw;
    private boolean _isVisiable;
    private int viewPortX;
    private int viewPortY;
    private int viewPortWidth;
    private int viewPortHeight;
    private int spritesType;
    private boolean _isDead = false;
    private int screenX;
    private int screenY;
    private int collisionNum;
    private int collisionTypeNum;
    private int beginCollsionId;
    private int collsionIdLength;
    private boolean registerKeyControl;
    private int screenViewPortX;
    private int screenViewPortY;
    public static final int UP = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int DOWN = 4;
    public static final int FIRE = 5;
    public static final int UP_RIGHT = 6;
    public static final int DOWN_RIGHT = 7;
    public static final int UP_LEFT = 8;
    public static final int DOWN_LEFT = 9;
    public static final int DEFAULT = 10;
    public int direction = -1;
    private boolean _timerUpdate = false;
    public int registertime = -1;
    public int timerGo = 0;
    private boolean controlAni = false;
    private boolean stopUpdateAni = false;
    private boolean useRect = false;
    private boolean fillRect = false;
    private int rectWidth;
    private int rectHeight;
    private int rectColor;
    public boolean _isControl;
    private String spritesName = "";
    public int collsionX;
    public int collsionY;
    public int collsionWidth;
    public int collsionHeight;
    private int collsionOffsetX = 0;
    private int collsionOffsetY = 0;
    private int collsionOffsetWidth = 0;
    private int collsionOffsetHeight = 0;
    private int mapViewPortX;
    private int mapViewPortY;
    private boolean needShow;
    private boolean needAllwayUpdateFrame;
    public boolean showCollsionRect = false;
    private int screenWidth;
    public SpritesRect[][] collsionRect;
    private int col_state = 0;
    private int col_frame = 0;
    private int col_rectid = 0;

    public boolean initSpritesStateToAni(Container m, String spritesName, int spritesType, int defaultState, int x, int y, boolean isVisiable) {
        if (m.ani_mgr == null || m.stateAniList == null) {
            return false;
        }
        this._m = m;
        if (m.stateAniList[spritesType].length <= 0) {
            return false;
        }
        if (spritesName == "" || spritesName.equals("")) {
            return false;
        }
        this.spritesName = spritesName;
        this._aniList = new Animation[m.stateAniList[spritesType].length];
        this.collsionRect = new SpritesRect[m.stateAniList[spritesType].length][];
        for (int i = 0; i < m.stateAniList[spritesType].length; ++i) {
            this._aniList[i] = m.stateAniList[spritesType][i] != -1 ? m.ani_mgr.loadAnimation(this, m.stateAniList[spritesType][i]) : null;
        }
        this._defaultState = defaultState;
        this.worldX = x;
        this.worldY = y;
        this._isVisiable = isVisiable;
        this.spritesType = spritesType;
        this._isDead = false;
        this.registerKeyControl = false;
        this._isDraw = true;
        return this.setState(this._defaultState);
    }

    public boolean initSpritesStateToAni(Container m, String spritesName, int spritesType, int numAni, short[] stateAniList, int x, int y, boolean isVisiable) {
        if (m.ani_mgr == null || m.stateAniList == null) {
            return false;
        }
        this._m = m;
        if (numAni <= 0) {
            return false;
        }
        if (spritesName == "" || spritesName.equals("")) {
            return false;
        }
        this.spritesName = spritesName;
        this._aniList = new Animation[numAni];
        this.collsionRect = new SpritesRect[numAni][];
        for (int i = 0; i < stateAniList.length; ++i) {
            this._aniList[i] = stateAniList[i] != -1 ? m.ani_mgr.loadAnimation(this, stateAniList[i]) : null;
        }
        this._defaultState = 0;
        this.worldX = x;
        this.worldY = y;
        this._isVisiable = isVisiable;
        this.spritesType = spritesType;
        this._isDead = false;
        this.registerKeyControl = false;
        this._isDraw = true;
        return this.setState(this._defaultState);
    }

    public boolean initSpritesStateToAni(Container m, String spritesName, int spritesType, int defaultState, int x, int y, boolean isVisiable, int rectW, int rectH, int rectColor, boolean useRect) {
        if (spritesName == "" || spritesName.equals("")) {
            return false;
        }
        this._m = m;
        this.spritesName = spritesName;
        this.useRect = true;
        this._defaultState = defaultState;
        this.collsionRect = new SpritesRect[1][1];
        this.worldX = x;
        this.worldY = y;
        this.rectWidth = rectW;
        this.rectHeight = rectH;
        this._isVisiable = isVisiable;
        this.spritesType = spritesType;
        this._isDead = false;
        this.registerKeyControl = false;
        this._isDraw = true;
        return this.setState(this._defaultState, true, rectColor);
    }

    public boolean initSpritesStateToAni(Container m, String spritesName, int spritesType) {
        if (spritesName == "" || spritesName.equals("")) {
            return false;
        }
        this._m = m;
        this.spritesName = spritesName;
        this._defaultState = 0;
        this.worldX = 0;
        this.worldY = 0;
        this.rectWidth = 0;
        this.rectHeight = 0;
        this._isVisiable = false;
        this.spritesType = spritesType;
        this._isDead = false;
        this.registerKeyControl = false;
        return true;
    }

    public void createCollsionRect() {
        for (int i = 0; i < this._aniList.length; ++i) {
            if (this._aniList[i] == null) continue;
            this.collsionRect[i] = new SpritesRect[this._aniList[i].getFramecount()];
        }
    }

    public void releaseSprites() {
        int i;
        this._curState = -1;
        this._defaultState = -1;
        if (this._aniList != null) {
            for (i = 0; i < this._aniList.length; ++i) {
                if (this._aniList[i] == null) continue;
                this._aniList[i] = null;
            }
        }
        if (this.collsionRect != null) {
            for (i = 0; i < this.collsionRect.length; ++i) {
                if (this.collsionRect[i] == null) continue;
                for (int j = 0; j < this.collsionRect[i].length; ++j) {
                    this.collsionRect[i][j] = null;
                }
            }
        }
        this.collsionRect = null;
        this._aniList = null;
        if (this._curAni != null) {
            this._curAni = null;
        }
        this._m = null;
    }

    public boolean setState(int state) {
        if (this._aniList == null) {
            return false;
        }
        if (this._aniList[state] == null) {
            return false;
        }
        this._previousState = this._curState;
        this._curAni = this._aniList[state];
        this._curState = state;
        this.startAniPlay();
        return true;
    }

    public boolean setState(int state, int frameId) {
        if (this._aniList == null) {
            return false;
        }
        if (this._aniList[state] == null) {
            return false;
        }
        this._previousState = this._curState;
        this._curAni = this._aniList[state];
        this._curState = state;
        this.startAniPlay(frameId);
        return true;
    }

    public void startAniPlay(int frameId) {
        this._curAni.setCurrentFrame(frameId);
        if (this.controlAni) {
            this.stopUpdateAni = false;
            this._curAni.stopFrameIndex = -1;
        }
    }

    public void setPreviousState(int state) {
        this._previousState = state;
    }

    public void startAniPlay() {
        if (this._curAni != null) {
            this._curAni.setCurrentFrame(0);
        }
        if (this.controlAni) {
            this.stopUpdateAni = false;
            this._curAni.stopFrameIndex = -1;
        }
    }

    public boolean setState(int state, boolean isFill, int color) {
        this.rectColor = color;
        this._previousState = this._curState;
        this._curState = state;
        this.fillRect = isFill;
        return true;
    }

    public void setCurrentStateFrame(int frameId) {
        if (this._curAni != null) {
            this._curAni.setCurrentFrame(frameId);
        }
    }

    public byte getCurrectAniState() {
        return this.currectAniState;
    }

    public void setCurrectAniState(byte currectAniState) {
        this.currectAniState = currectAniState;
    }

    public void setCurrectAniLoop(boolean loop) {
        if (this._curAni != null) {
            this._curAni.setLoop(loop);
        }
    }

    public int getCurrentStateFrameNum() {
        if (this._curAni == null) {
            return -1;
        }
        return this._curAni.getFramecount();
    }

    public int getCurrentFrameIndex() {
        if (this._curAni == null) {
            return -1;
        }
        return this._curAni.getCurrentFrameIndex();
    }

    public boolean getCurrectStateFrameEnd() {
        if (this._curAni == null) {
            return true;
        }
        return this._curAni.isLastFrame();
    }

    public boolean getControlAni() {
        return this.controlAni;
    }

    public void setControlAni(boolean controlAni) {
        this.controlAni = controlAni;
    }

    public void stopAniUpdate() {
        this.stopUpdateAni = true;
    }

    public void updateFrameUnDraw() {
        if (!this.isDraw() && this._curAni != null) {
            this._curAni.updateFrame();
        }
    }

    public boolean stopAniUpdate(int frameIndex) {
        if (this._curAni != null) {
            this._curAni.stopFrameIndex = frameIndex;
        }
        return false;
    }

    public boolean skipCurrectAniUpdate(int beginsFrameIndex, int skipNum) {
        if (beginsFrameIndex < 0 || skipNum < 0 || beginsFrameIndex + skipNum >= this._curAni.getFramecount() || beginsFrameIndex + skipNum < 0 || beginsFrameIndex >= this._curAni.getFramecount() || this._curAni == null) {
            return false;
        }
        this._curAni.skipFrameIndex = beginsFrameIndex;
        this._curAni.skipNum = skipNum;
        return true;
    }

    public boolean resetSkipCurrectAniUpdate() {
        if (this._curAni == null) {
            return false;
        }
        this._curAni.skipFrameIndex = -1;
        this._curAni.skipNum = -1;
        return true;
    }

    public boolean setSkipCurrectAniBlock(int id) {
        if (this._curAni == null) {
            return false;
        }
        this._curAni.skipBlockInfoId = id * 3 + 1;
        return true;
    }

    public boolean resetSkipCurrectAniBlock() {
        if (this._curAni == null) {
            return false;
        }
        this._curAni.skipBlockInfoId = -1;
        return true;
    }

    public void goOnAniUpdate() {
        this.stopUpdateAni = false;
    }

    public boolean getStopAniUpdate() {
        return this.stopUpdateAni;
    }

    public boolean reSetDefaultState() {
        return this.setState(this._defaultState);
    }

    public int getCurrectState() {
        return this._curState;
    }

    public int getPreviousState() {
        return this._previousState;
    }

    public int getDefaultState() {
        return this._defaultState;
    }

    public void setDefaultState(int state) {
        this._defaultState = state;
    }

    public void handleEvent(Event evt) {
    }

    public void render(PlatformGraphics g, int renderState) {
        int type = 0;
        switch (renderState) {
            case 0: {
                type = 0;
                break;
            }
            case 1: {
                type = 1;
                break;
            }
            case 2: {
                type = 2;
            }
        }
        if (!this.useRect) {
            if (this._curAni != null && this._isDraw && this._isVisiable && !this._isDead) {
                this._curAni.draw(g, this.screenX, this.screenY, type);
                this._curAni.updateFrame();
            } else if (this._curAni != null && this._isDraw && !this._isVisiable && !this._isDead) {
                this._curAni.updateFrame();
            }
        } else if (this._isDraw && this._isVisiable && !this._isDead && this.needShow) {
            g.setColor(this.rectColor);
            if (this.fillRect) {
                g.fillRect(this.screenX - this.rectWidth / 2, this.screenY - this.rectHeight, this.rectWidth, this.rectHeight);
            } else {
                g.drawRect(this.screenX - this.rectWidth / 2, this.screenY - this.rectHeight, this.rectWidth, this.rectHeight);
            }
        }
        if (this.showCollsionRect) {
            g.setColor(65535);
            g.drawRect(this.collsionX - this.mapViewPortX, this.collsionY - this.mapViewPortY, this.collsionWidth, this.collsionHeight);
        }
    }

    public boolean getSpritesInScreenMostBody() {
        return this.getWorldX() >= this.mapViewPortX && this.getWorldX() <= this.screenWidth + this.mapViewPortX;
    }

    public void render(PlatformGraphics g) {
        this.render(g, 0);
    }

    public void setDraw(int viewPortX, int viewPortY, int width, int height) {
        this.viewPortX = this.worldX - this.viewPortWidth / 2 - viewPortX;
        this.viewPortY = this.worldY - this.viewPortHeight - viewPortY;
        this.changeCollsion();
        this.screenX = this.worldX - viewPortX;
        this.screenY = this.worldY - viewPortY;
        this.mapViewPortX = viewPortX;
        this.mapViewPortY = viewPortY;
        this.screenWidth = width;
        this._isDraw = 0 + height >= this.viewPortY && 0 <= this.viewPortY + this.viewPortHeight && 0 + width >= this.viewPortX && 0 <= this.viewPortX + this.viewPortWidth;
    }

    public int getScreenX() {
        return this.screenX;
    }

    public void setScreenX(int screenX) {
        this.screenX = screenX;
    }

    public int getScreenY() {
        return this.screenY;
    }

    public void setScreenY(int screenY) {
        this.screenY = screenY;
    }

    public boolean isDead() {
        return this._isDead;
    }

    public void setDead(boolean isDead) {
        this._isDead = isDead;
        if (this._layer != null && this._isDead) {
            this._isDraw = false;
            this._layer.updateCurrectViewPort = true;
        }
    }

    protected int getWorldX() {
        return this.worldX;
    }

    protected void setWorldX(int x) {
        this.worldX = x;
    }

    protected int getWorldY() {
        return this.worldY;
    }

    protected void setWorldY(int y) {
        this.worldY = y;
    }

    protected boolean isDraw() {
        return this._isDraw;
    }

    protected boolean isVisiable() {
        return this._isVisiable;
    }

    protected void setVisiable(boolean isVisiable) {
        this._isVisiable = isVisiable;
    }

    protected int getViewPortWidth() {
        return this.viewPortWidth;
    }

    protected int getViewPortHeight() {
        return this.viewPortHeight;
    }

    public void setViewPortWidthHeight(int viewPortWidth, int viewPortHeight) {
        this.viewPortWidth = viewPortWidth;
        this.viewPortHeight = viewPortHeight;
    }

    protected int getViewPortX() {
        return this.viewPortX;
    }

    protected int getViewPortY() {
        return this.viewPortY;
    }

    protected int getSpritesType() {
        return this.spritesType;
    }

    protected int getCollisionNum() {
        return this.collisionNum;
    }

    protected void setCollisionNum(int collisionNum) {
        this.collisionNum = collisionNum;
    }

    protected int getCollisionTypeNum() {
        return this.collisionTypeNum;
    }

    protected void setCollisionTypeNum(int collisionTypeNum) {
        this.collisionTypeNum = collisionTypeNum;
    }

    protected int getBeginCollsionId() {
        return this.beginCollsionId;
    }

    protected void setBeginCollsionId(int beginCollsionId) {
        this.beginCollsionId = beginCollsionId;
    }

    protected int getCollsionIdLength() {
        return this.collsionIdLength;
    }

    protected void setCollsionIdLength(int collsionIdLength) {
        this.collsionIdLength = collsionIdLength;
    }

    protected boolean isRegisterKeyContrl() {
        return this.registerKeyControl;
    }

    protected void registerKeyContrl(boolean rkc) {
        this.registerKeyControl = rkc;
    }

    protected int getScreenViewPortX() {
        return this.screenViewPortX;
    }

    protected void setScreenViewPortX(int screenViewPortX) {
        this.screenViewPortX = screenViewPortX;
    }

    protected Container getContainer() {
        return this._m;
    }

    protected int getScreenViewPortY() {
        return this.screenViewPortY;
    }

    public void getControl() {
        this._isControl = true;
        if (this._layer != null) {
            this._layer.layerInControl = true;
        }
    }

    public void loseControl() {
        this._isControl = false;
        if (this._layer != null) {
            this._layer.layerInControl = false;
        }
    }

    public boolean isControl() {
        return this._isControl;
    }

    public void autoUpdateState() {
    }

    public void updateStates() {
    }

    public void go() {
    }

    public void updateState(int key, Sprites b) {
    }

    public void registerTimerOpen(int time) {
        this.registerTimerClose();
        this.registertime = time;
        this._timerUpdate = true;
    }

    public void registerTimerClose() {
        this._timerUpdate = false;
        this.timerGo = 0;
    }

    public boolean isTimerUpdate() {
        return this._timerUpdate;
    }

    public void timerUpdate() {
        if (this._timerUpdate) {
            ++this.timerGo;
            if (this.timerGo == this.registertime) {
                this.autoUpdateState();
                this.timerGo = 0;
            }
        } else {
            this.registertime = -1;
            this.timerGo = 0;
        }
    }

    public String getSpritesName() {
        return this.spritesName;
    }

    public int getCollsionX() {
        return this.collsionX;
    }

    public int getCollsionY() {
        return this.collsionY;
    }

    public void reSetCollsionByView() {
        this.reSetCollsionOffect();
        this.collsionX = this.worldX - this.viewPortWidth / 2;
        this.collsionY = this.worldY - this.viewPortHeight;
        this.collsionWidth = this.viewPortWidth;
        this.collsionHeight = this.viewPortHeight;
    }

    public int getCollsionWidth() {
        return this.collsionWidth;
    }

    public int getCollsionHeight() {
        return this.collsionHeight;
    }

    public void changeCollsion() {
        this.collsionX = this.worldX - this.viewPortWidth / 2 + this.collsionOffsetX;
        this.collsionY = this.worldY - this.viewPortHeight + this.collsionOffsetY;
        this.collsionWidth = this.viewPortWidth + this.collsionOffsetWidth;
        this.collsionHeight = this.viewPortHeight + this.collsionOffsetHeight;
    }

    public void setCollsionRight(int collsionOffsetRight) {
        this.collsionOffsetWidth = collsionOffsetRight;
    }

    public void setCollsionLeft(int collsionOffsetLeft) {
        this.collsionOffsetWidth = collsionOffsetLeft;
        this.collsionOffsetX = -collsionOffsetLeft;
    }

    public void setCollsionUp(int collsionOffsetUp) {
        this.collsionOffsetY = -collsionOffsetUp;
        this.collsionOffsetHeight = collsionOffsetUp;
    }

    public void setCollsionDown(int collsionOffsetDown) {
        this.collsionOffsetHeight = collsionOffsetDown;
    }

    public void setCollsionRightUp(int collsionOffsetRight, int collsionOffsetUp) {
        this.reSetCollsionOffect();
        this.setCollsionRight(collsionOffsetRight * 3);
        this.setCollsionUp(collsionOffsetUp * 3);
    }

    public void setCollsionRightDown(int collsionOffsetRight, int collsionOffsetDown) {
        this.reSetCollsionOffect();
        this.setCollsionRight(collsionOffsetRight * 3);
        this.setCollsionDown(collsionOffsetDown * 3);
    }

    public void setCollsionLeftUp(int collsionOffsetLeft, int collsionOffsetUp) {
        this.reSetCollsionOffect();
        this.setCollsionLeft(collsionOffsetLeft * 3);
        this.setCollsionUp(collsionOffsetUp * 3);
    }

    public void setCollsionLeftDown(int collsionOffsetLeft, int collsionOffsetDown) {
        this.reSetCollsionOffect();
        this.setCollsionLeft(collsionOffsetLeft * 3);
        this.setCollsionDown(collsionOffsetDown * 3);
    }

    public void reSetCollsionOffect() {
        this.collsionOffsetX = 0;
        this.collsionOffsetY = 0;
        this.collsionOffsetWidth = 0;
        this.collsionOffsetHeight = 0;
    }

    public int getMapViewPortX() {
        return this.mapViewPortX;
    }

    public int getMapViewPortY() {
        return this.mapViewPortY;
    }

    public void setRectColor(int rectColor) {
        this.rectColor = rectColor;
    }

    public Layer getLayer() {
        return this._layer;
    }

    public void setLayer(Layer layer) {
        this._layer = layer;
    }

    public void createSpritesRectByStateFrame(int state, int frame, int rectNum, byte[] collsiondata) {
        try {
            if (state < this.collsionRect.length && frame < this.collsionRect[state].length && collsiondata.length % 4 == 0) {
                this.collsionRect[state][frame] = new SpritesRect(rectNum, collsiondata);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createSpritesRectByStateSameRectNum(int state, int rectNum, byte[] collsiondata) {
        if (state < this.collsionRect.length) {
            for (int i = 0; i < this.collsionRect[state].length; ++i) {
                this.createSpritesRectByStateFrame(state, i, rectNum, collsiondata);
            }
        }
    }

    public void createSpritesRectBySameRectNum(int rectNum, byte[] collsiondata) {
        for (int j = 0; j < this.collsionRect.length; ++j) {
            this.createSpritesRectByStateSameRectNum(j, rectNum, collsiondata);
        }
    }

    public void setCollsionData(int state, int frame, int id) {
        this.col_state = state;
        this.col_frame = frame;
        this.col_rectid = id;
    }

    public int[] getCollsionData() {
        int[] a = new int[]{this.col_state, this.col_frame, this.col_rectid};
        return a;
    }

    public boolean isNeedShow() {
        return this.needShow;
    }

    public void setNeedShow(boolean needShow) {
        this.needShow = needShow;
    }

    public void setCurrectAniFrameDelay(int delayFrameIndex, int delayNum) {
        if (this._curAni != null) {
            this._curAni.setFrameDelay(delayFrameIndex, delayNum);
        }
    }

    public void reSetCurrectAniFrameDelay(int delayFrameIndex) {
        if (this._curAni != null) {
            this._curAni.setFrameDelay(delayFrameIndex, -1);
        }
    }

    public void reSetCurrectAniDelay() {
        if (this._curAni != null) {
            this._curAni.setFrameDelay(-1, -1);
        }
    }

    public boolean isNeedAllwayUpdateFrame() {
        return this.needAllwayUpdateFrame;
    }

    public void setNeedAllwayUpdateFrame(boolean needAllwayUpdateFrame) {
        this.needAllwayUpdateFrame = needAllwayUpdateFrame;
    }

    public void updateFrame() {
        if (this._curAni != null && this.needAllwayUpdateFrame && !this.isDraw()) {
            this._curAni.updateFrame();
        }
    }
}

