/*
 * Decompiled with CFR 0.152.
 */
public class Animation {
    private AnimationMgr aniMgr;
    private int curFrameIndex;
    private int curDurationCnt;
    private byte flag;
    private boolean end = false;
    public int aniIndex;
    public static final int FLAG_BACKWARD_MASK = 1;
    public static final int FLAG_DUAINIT_MASK = 2;
    public static final int FLAG_LOOP_MASK = 4;
    public static final int NORMAL = 0;
    public static final int MIRROR = 1;
    public static final int FLIP = 2;
    public Sprites sprites;
    public int skipFrameIndex = -1;
    public int skipNum = -1;
    public int stopFrameIndex = -1;
    public int skipBlockInfoId = -1;
    private int frameIndexAniDelayNum = -1;
    private int delayFrameIndex = -1;

    protected Animation(Sprites sprites, AnimationMgr aniMgr, int aniIndex, boolean isLoop) {
        this.sprites = sprites;
        this.aniMgr = aniMgr;
        this.aniIndex = aniIndex;
        if (isLoop) {
            this.flag = (byte)(this.flag | 4);
        }
    }

    public void release() {
        this.aniMgr.releaseAnimation(this.aniIndex);
    }

    public int getFramecount() {
        return this.aniMgr.sequences[this.aniIndex].length;
    }

    public boolean isFirstFrame() {
        return this.curFrameIndex == 0;
    }

    public boolean isLastFrame() {
        return this.curFrameIndex == this.aniMgr.sequences[this.aniIndex].length - 1 || this.aniMgr.sequences[this.aniIndex].length == 0;
    }

    public void setLoop(boolean loop) {
        this.flag = loop ? (byte)(this.flag | 4) : (byte)(this.flag & 0xFFFFFFFB);
    }

    public boolean isLoop() {
        return (this.flag & 4) != 0;
    }

    public boolean isEnd() {
        return this.end;
    }

    public void setFrameDelay(int delayFrameIndex, int delayNum) {
        if (this.sprites.getControlAni()) {
            this.delayFrameIndex = delayFrameIndex;
            this.frameIndexAniDelayNum = delayNum;
        }
    }

    public void updateFrame() {
        if (this.sprites.getControlAni()) {
            if (this.sprites.getStopAniUpdate()) {
                this.sprites.setCurrectAniState((byte)4);
                return;
            }
            if (this.stopFrameIndex >= 0 && this.stopFrameIndex < this.getFramecount() && this.stopFrameIndex == this.curFrameIndex && this.sprites.getCurrectAniState() != 4) {
                this.sprites.stopAniUpdate();
                this.sprites.setCurrectAniState((byte)4);
                return;
            }
        }
        if (this.aniMgr.sequences[this.aniIndex].length == 0) {
            this.end = true;
            return;
        }
        if ((this.flag & 2) == 0) {
            if (this.sprites.getControlAni()) {
                if (this.frameIndexAniDelayNum == -1 && this.delayFrameIndex == 0) {
                    this.curDurationCnt = this.aniMgr.sequences[this.aniIndex][0] >> 12 & 0xF;
                } else if (this.frameIndexAniDelayNum != -1 && this.delayFrameIndex == 0) {
                    this.curDurationCnt = this.frameIndexAniDelayNum;
                }
            } else {
                this.curDurationCnt = this.aniMgr.sequences[this.aniIndex][0] >> 12 & 0xF;
            }
            this.flag = (byte)(this.flag | 2);
        }
        if ((this.flag & 1) == 0) {
            if (this.sprites.getControlAni()) {
                if (this.curFrameIndex == 0) {
                    this.sprites.setCurrectAniState((byte)1);
                } else if (this.curFrameIndex == this.aniMgr.sequences[this.aniIndex].length - 1) {
                    this.sprites.setCurrectAniState((byte)3);
                } else {
                    this.sprites.setCurrectAniState((byte)2);
                }
            }
            if (this.curDurationCnt == 0) {
                if (this.curFrameIndex == this.aniMgr.sequences[this.aniIndex].length - 1) {
                    if ((this.flag & 4) != 0) {
                        this.curFrameIndex = 0;
                        if (this.sprites.getControlAni()) {
                            if (this.frameIndexAniDelayNum == -1 && this.delayFrameIndex == this.curFrameIndex) {
                                this.curDurationCnt = this.aniMgr.sequences[this.aniIndex][this.curFrameIndex] >> 12 & 0xF;
                            } else if (this.frameIndexAniDelayNum != -1 && this.delayFrameIndex == this.curFrameIndex) {
                                this.curDurationCnt = this.frameIndexAniDelayNum;
                            }
                        } else {
                            this.curDurationCnt = this.aniMgr.sequences[this.aniIndex][this.curFrameIndex] >> 12 & 0xF;
                        }
                    } else {
                        this.end = true;
                    }
                } else {
                    this.curFrameIndex = this.sprites.getControlAni() && this.skipFrameIndex != -1 && this.skipNum != -1 ? (this.curFrameIndex == this.skipFrameIndex ? (this.curFrameIndex += this.skipNum) : ++this.curFrameIndex) : ++this.curFrameIndex;
                    if (this.sprites.getControlAni()) {
                        if (this.frameIndexAniDelayNum == -1 && this.delayFrameIndex == this.curFrameIndex) {
                            this.curDurationCnt = this.aniMgr.sequences[this.aniIndex][this.curFrameIndex] >> 12 & 0xF;
                        } else if (this.frameIndexAniDelayNum != -1 && this.delayFrameIndex == this.curFrameIndex) {
                            this.curDurationCnt = this.frameIndexAniDelayNum;
                        }
                    } else {
                        this.curDurationCnt = this.aniMgr.sequences[this.aniIndex][this.curFrameIndex] >> 12 & 0xF;
                    }
                }
            } else {
                --this.curDurationCnt;
            }
        } else {
            if (this.sprites.getControlAni()) {
                if (this.curFrameIndex == 0) {
                    this.sprites.setCurrectAniState((byte)3);
                } else if (this.curFrameIndex == this.aniMgr.sequences[this.aniIndex].length - 1) {
                    this.sprites.setCurrectAniState((byte)1);
                } else {
                    this.sprites.setCurrectAniState((byte)2);
                }
            }
            if (this.curDurationCnt == 0) {
                if (this.curFrameIndex == 0) {
                    if ((this.flag & 4) != 0) {
                        this.curFrameIndex = this.aniMgr.sequences[this.aniIndex].length - 1;
                        if (this.sprites.getControlAni()) {
                            if (this.frameIndexAniDelayNum == -1 && this.delayFrameIndex == this.curFrameIndex) {
                                this.curDurationCnt = this.aniMgr.sequences[this.aniIndex][this.curFrameIndex] >> 12 & 0xF;
                            } else if (this.frameIndexAniDelayNum != -1 && this.delayFrameIndex == this.curFrameIndex) {
                                this.curDurationCnt = this.frameIndexAniDelayNum;
                            }
                        } else {
                            this.curDurationCnt = this.aniMgr.sequences[this.aniIndex][this.curFrameIndex] >> 12 & 0xF;
                        }
                    } else {
                        this.end = true;
                    }
                } else {
                    this.curFrameIndex = this.sprites.getControlAni() && this.skipFrameIndex != -1 && this.skipNum != -1 ? (this.curFrameIndex == this.skipFrameIndex ? (this.curFrameIndex -= this.skipNum) : --this.curFrameIndex) : --this.curFrameIndex;
                    if (this.sprites.getControlAni()) {
                        if (this.frameIndexAniDelayNum == -1 && this.delayFrameIndex == this.curFrameIndex) {
                            this.curDurationCnt = this.aniMgr.sequences[this.aniIndex][this.curFrameIndex] >> 12 & 0xF;
                        } else if (this.frameIndexAniDelayNum != -1 && this.delayFrameIndex == this.curFrameIndex) {
                            this.curDurationCnt = this.frameIndexAniDelayNum;
                        }
                    } else {
                        this.curDurationCnt = this.aniMgr.sequences[this.aniIndex][this.curFrameIndex] >> 12 & 0xF;
                    }
                }
            } else {
                --this.curDurationCnt;
            }
        }
    }

    public void setBackword() {
        this.flag = (byte)(this.flag | 1);
        this.end = false;
    }

    public void setForword() {
        this.flag = (byte)(this.flag & 0xFFFFFFFE);
        this.end = false;
    }

    public boolean isForword() {
        return (this.flag & 1) == 0;
    }

    public void setCurrentFrame(int frameIndex) {
        this.end = false;
        this.curFrameIndex = frameIndex;
        this.flag = (byte)(this.flag & 0xFFFFFFFD);
    }

    public int getCurrentFrameIndex() {
        return this.curFrameIndex;
    }

    public void draw(PlatformGraphics g, int xPos, int yPos, int aniFlag) {
        if (this.aniMgr.sequences[this.aniIndex].length == 0) {
            return;
        }
        PlatformImage img = null;
        short[] blockInfo = this.aniMgr.frames[this.aniMgr.sequences[this.aniIndex][this.curFrameIndex] & 0xFFF];
        int blockInfoLen = blockInfo.length;
        int i = 0;
        while (i < blockInfoLen) {
            short blkIdx;
            if ((img = this.aniMgr.imgMgr.imgs[blkIdx = blockInfo[i++]]) == null) {
                i += 2;
                continue;
            }
            if (this.sprites.getControlAni() && this.skipBlockInfoId != -1 && this.skipBlockInfoId < blockInfoLen && i == this.skipBlockInfoId) {
                i += 2;
                continue;
            }
            int blkFlag = blockInfo[i] & 3;
            int x = (aniFlag & 1) != 0 ? xPos - (blockInfo[i++] >> 2) - img.getWidth() : xPos + (blockInfo[i++] >> 2);
            int y = (aniFlag & 2) != 0 ? yPos - blockInfo[i++] - img.getHeight() : yPos + blockInfo[i++];
            switch (aniFlag ^ blkFlag) {
                case 0: {
                    g.drawImage(img, x, y, 0);
                    break;
                }
                case 1: {
                    g.drawRegion(img, 0, 0, this.aniMgr.imgMgr.width[blkIdx], this.aniMgr.imgMgr.height[blkIdx], 2, x, y, 0);
                    break;
                }
                case 2: {
                    g.drawRegion(img, 0, 0, this.aniMgr.imgMgr.width[blkIdx], this.aniMgr.imgMgr.height[blkIdx], 1, x, y, 0);
                    break;
                }
                case 3: {
                    g.drawRegion(img, 0, 0, this.aniMgr.imgMgr.width[blkIdx], this.aniMgr.imgMgr.height[blkIdx], 3, x, y, 0);
                }
            }
        }
    }

    public short[] getSeqBox() {
        return this.aniMgr.seqBox[this.aniIndex];
    }

    public short[] getBodyBox(int frmIndex) {
        if (this.aniMgr.sequences[this.aniIndex].length == 0) {
            return null;
        }
        return this.aniMgr.frmBodyBox[this.aniMgr.sequences[this.aniIndex][frmIndex] & 0xFFF];
    }

    public short[] getCollideBox(int frmIndex) {
        if (this.aniMgr.sequences[this.aniIndex].length == 0) {
            return null;
        }
        return this.aniMgr.frmCollideBox[this.aniMgr.sequences[this.aniIndex][frmIndex] & 0xFFF];
    }
}

