/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class Sound_MM_API
extends PlatformSound
implements PlayerListener {
    private static final String[] CONTENT_TYPES = new String[]{"midi", "x-wav", "amr", "x-ogg", "mpeg", "aac"};
    private static final int DELAY_TIME = 100;
    private static final int STATE_STOP = 0;
    private static final int STATE_PLAY = 1;
    private int format;
    private byte[] soundData;
    private String resourceName;
    private int state;
    private int volume;
    private int loopCount;
    private Player player;

    public Sound_MM_API(int format, byte[] data) {
        this.format = format;
        this.soundData = data;
        PlatformSound.registerSound(this);
    }

    public Sound_MM_API(int format, String resourceName) {
        this.format = format;
        this.resourceName = resourceName;
        PlatformSound.registerSound(this);
    }

    public void setLoopCount(int loopCount) {
        this.loopCount = loopCount;
    }

    public void setVolume(int newVolume) {
        if (this.volume != newVolume) {
            Platform.debuglog("[SOUND] volume=" + this.volume + "newVolume " + newVolume);
            this.volume = newVolume;
            if (this.player != null) {
                this.applyVolume();
            }
        }
    }

    public void play() {
        boolean failed;
        Platform.debuglog("[SOUND] play");
        int retry = 0;
        do {
            this.realize();
            if (this.player == null) {
                return;
            }
            failed = false;
            try {
                this.player.start();
            }
            catch (Exception e) {
                failed = true;
                e.printStackTrace();
                Platform.debuglog("[SOUND] player.state " + this.player.getState(), e);
                Platform.debuglog("[SOUND] start failed", e);
            }
            if (!failed) continue;
            ++retry;
            this.stop();
            Platform.sleep(2000);
        } while (failed && retry < 3);
        if (failed) {
            return;
        }
        this.state = 1;
    }

    public void prefetch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void realize() {
        block27: {
            if (this.player != null) {
                try {
                    this.player.prefetch();
                    try {
                        this.applyVolume();
                    }
                    catch (Exception e) {
                        Platform.debuglog("[SOUND] realize applyVolume", e);
                    }
                }
                catch (Exception e) {
                    Platform.debuglog("[SOUND] prefetch", e);
                }
                return;
            }
            InputStream in = this.soundData != null ? new ByteArrayInputStream(this.soundData, 0, this.soundData.length) : this.getClass().getResourceAsStream(this.resourceName);
            try {
                String t = "audio/" + CONTENT_TYPES[this.format];
                this.player = Manager.createPlayer((InputStream)in, (String)t);
                Platform.debuglog("[SOUND] Sound realize: type=" + t);
                try {
                    this.player.realize();
                }
                catch (Exception e) {
                    Platform.debuglog("[SOUND] realize() player.realize failed", e);
                }
                try {
                    this.player.prefetch();
                }
                catch (Exception e) {
                    Platform.debuglog("[SOUND] realize() player.prefetch failed", e);
                }
                try {
                    this.player.setLoopCount(this.loopCount);
                }
                catch (Exception e) {
                    Platform.debuglog("[SOUND] realize() player.setLoopCount failed", e);
                }
                try {
                    this.applyVolume();
                }
                catch (Exception e) {
                    Platform.debuglog("[SOUND] realize() applyVolume failed", e);
                }
            }
            catch (Exception e) {
                Platform.debuglog("[SOUND] realize failed", e);
                if (this.player == null) break block27;
                try {
                    this.player.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.player = null;
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                        in = null;
                    }
                }
                catch (Exception e) {
                    in = null;
                }
            }
        }
    }

    public boolean isPlaying() {
        if (this.player == null) {
            return false;
        }
        try {
            return this.player.getState() == 400;
        }
        catch (Exception e) {
            Platform.debuglog("[SOUND] isPlaying", e);
            return false;
        }
    }

    public void stop() {
        Platform.debuglog("[SOUND] stop state " + this.state);
        if (this.player == null) {
            return;
        }
        this.state = 0;
        try {
            if (this.player != null) {
                this.player.stop();
            }
        }
        catch (Exception e) {
            Platform.debuglog("[SOUND] stop failed", e);
        }
        try {
            if (this.player != null) {
                this.player.deallocate();
            }
        }
        catch (Exception e) {
            Platform.debuglog("[SOUND] deallocate failed", e);
        }
        try {
            if (this.player != null) {
                this.player.close();
            }
        }
        catch (Exception e) {
            Platform.debuglog("[SOUND] close failed", e);
        }
        this.player = null;
    }

    static void stopAllSounds() {
    }

    public void close() {
        this.state = 0;
        if (this.player == null) {
            return;
        }
        try {
            this.player.stop();
        }
        catch (Exception e) {
            Platform.debuglog("[SOUND] stop failed", e);
        }
        try {
            this.player.deallocate();
        }
        catch (Exception e) {
            Platform.debuglog("[SOUND] deallocate failed", e);
        }
        try {
            this.player.close();
        }
        catch (Exception e) {
            Platform.debuglog("[SOUND] close failed", e);
        }
        this.player = null;
    }

    private void applyVolume() {
        VolumeControl vc = (VolumeControl)this.player.getControl("VolumeControl");
        if (vc != null) {
            vc.setLevel(this.volume);
        }
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        Platform.debuglog("[SOUND] playerUpdate: event=" + event);
    }
}

