/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;

public class PlatformResource {
    private boolean eof;
    private DataInputStream din;

    protected PlatformResource(DataInputStream din) {
        this.din = din;
    }

    public void close() {
        try {
            this.din.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.din = null;
    }

    public boolean isEOF() {
        return this.eof;
    }

    public void skipBytes(int len) {
        try {
            this.din.skip(len);
        }
        catch (Exception e) {
            this.eof = true;
        }
    }

    public boolean readBoolean() {
        try {
            return this.din.readBoolean();
        }
        catch (Exception e) {
            this.eof = true;
            return false;
        }
    }

    public byte readByte() {
        try {
            return this.din.readByte();
        }
        catch (Exception e) {
            this.eof = true;
            return 0;
        }
    }

    public int readUnsignedByte() {
        try {
            return this.din.readUnsignedByte();
        }
        catch (Exception e) {
            this.eof = true;
            return 0;
        }
    }

    public short readShort() {
        try {
            return this.din.readShort();
        }
        catch (Exception e) {
            this.eof = true;
            return 0;
        }
    }

    public int readUnsignedShort() {
        try {
            return this.din.readUnsignedShort();
        }
        catch (Exception e) {
            this.eof = true;
            return 0;
        }
    }

    public int readInt() {
        try {
            return this.din.readInt();
        }
        catch (Exception e) {
            this.eof = true;
            return 0;
        }
    }

    public long readLong() {
        try {
            return this.din.readLong();
        }
        catch (Exception e) {
            this.eof = true;
            return 0L;
        }
    }

    public void readFully(byte[] buffer, int offset, int length) {
        try {
            this.din.readFully(buffer, offset, length);
        }
        catch (Exception e) {
            this.eof = true;
        }
    }

    public void readFully(byte[] buffer) {
        this.readFully(buffer, 0, buffer.length);
    }

    public String readUTF() {
        try {
            return this.din.readUTF();
        }
        catch (Exception e) {
            this.eof = true;
            return "";
        }
    }
}

