/*
 * Decompiled with CFR 0.152.
 */
public class Layer {
    public static int MAX_SPRITES_SCREEN = 25;
    public Sprites[] allLayerSprites;
    public Sprites[] currentLayerViewPortSprites = new Sprites[MAX_SPRITES_SCREEN];
    int allLayerSpritesLength = 0;
    int currectLayerViewPortSpritesLength = 0;
    int layerMapLength = 0;
    public Map[] layerMaps;
    public Container _st;
    public int layerId;
    public String layerName;
    public PlatformImage[] img;
    public int imgLength = 0;
    public boolean updateCurrectViewPort = false;
    public static final int USE_SPRITES_SINGLE = 0;
    public boolean layerInControl;
    public Sprites[] allControlSpritesInLayer;
    int allControlSpritesLength = 0;
    public boolean active;
    public int lastViewPortX = -1;
    public int lastViewPortY = -1;
    int lastCurrectSpritesNum = 0;
    public int viewPortWidth;
    public int viewPortHeight;
    private TriggerManager tm;

    public Layer(Container st, int id, String name, int alllayerSpritesNum, int layerMapNum, int imageNum) {
        this._st = st;
        this.layerId = id;
        this.layerName = name;
        if (alllayerSpritesNum > 0) {
            this.allLayerSprites = new Sprites[alllayerSpritesNum];
            this.allControlSpritesInLayer = new Sprites[this.allLayerSprites.length];
        }
        if (layerMapNum > 0) {
            this.layerMaps = new Map[layerMapNum];
        }
        if (imageNum > 0) {
            this.img = new PlatformImage[imageNum];
        }
        this.layerInControl = false;
        this.active = true;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void releaseLayer() {
        try {
            int i;
            if (this.allLayerSprites != null) {
                for (i = 0; i < this.allLayerSprites.length; ++i) {
                    if (this.allLayerSprites[i] != null) {
                        this.allLayerSprites[i].releaseSprites();
                    }
                    this.allLayerSprites[i] = null;
                }
                this.allLayerSprites = null;
            }
            if (this.layerMaps != null) {
                for (i = 0; i < this.layerMaps.length; ++i) {
                    if (this.layerMaps[i] != null) {
                        this.layerMaps[i].releasMapResource();
                    }
                    this.layerMaps[i] = null;
                }
                this.layerMaps = null;
            }
            if (this.img != null) {
                for (i = 0; i < this.img.length; ++i) {
                    if (this.img[i] == null) continue;
                    this.img[i] = null;
                }
                this.img = null;
                this.imgLength = 0;
            }
            for (i = 0; i < this.currentLayerViewPortSprites.length; ++i) {
                if (this.currentLayerViewPortSprites[i] == null) continue;
                this.currentLayerViewPortSprites[i] = null;
            }
            this.currentLayerViewPortSprites = null;
            this.currectLayerViewPortSpritesLength = 0;
            for (i = 0; i < this.allControlSpritesLength; ++i) {
                if (this.allControlSpritesInLayer[i] == null) continue;
                this.allControlSpritesInLayer[i] = null;
            }
            this.allControlSpritesInLayer = null;
            this.currectLayerViewPortSpritesLength = 0;
            this.lastViewPortX = -1;
            this.lastViewPortY = -1;
            this.lastCurrectSpritesNum = 0;
        }
        catch (Exception e) {
            System.out.println("ex = " + e.toString());
        }
    }

    public void update() {
        if (this.tm != null) {
            this.tm.triggerCollision();
        }
    }

    public TriggerManager getTriggerManager() {
        return this.tm;
    }

    public void creatTrigerManager(int num, int[][] rect, int[] id, String[] send) {
        this.tm = new TriggerManager(this);
        this.tm.initTrigger(num, rect, id, send);
    }

    public void changeViewPortSprites(int viewPortX, int viewPortY, int width, int height) {
        try {
            int i;
            for (i = 0; i < this.allLayerSpritesLength; ++i) {
                this.allLayerSprites[i].timerUpdate();
            }
            if (this.lastViewPortX != viewPortX || this.lastViewPortY != viewPortY || this.updateCurrectViewPort) {
                if (this.updateCurrectViewPort) {
                    this.updateCurrectViewPort = false;
                }
                for (int j = 0; j < this.currentLayerViewPortSprites.length; ++j) {
                    this.currentLayerViewPortSprites[j] = null;
                }
                this.currectLayerViewPortSpritesLength = 0;
                this.lastCurrectSpritesNum = 0;
                if (this.allLayerSprites != null) {
                    for (i = 0; i < this.allLayerSprites.length; ++i) {
                        if (this.allLayerSprites[i] == null) continue;
                        if (!this.allLayerSprites[i].isDead()) {
                            this.allLayerSprites[i].setDraw(viewPortX, viewPortY, width, height);
                        }
                        if (this.lastCurrectSpritesNum >= MAX_SPRITES_SCREEN || !this.allLayerSprites[i].isDraw()) continue;
                        this.currentLayerViewPortSprites[this.lastCurrectSpritesNum] = this.allLayerSprites[i];
                        ++this.lastCurrectSpritesNum;
                        ++this.currectLayerViewPortSpritesLength;
                    }
                }
                this.lastViewPortX = viewPortX;
                this.lastViewPortY = viewPortY;
            }
            this.viewPortWidth = width;
            this.viewPortHeight = height;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void render(PlatformGraphics g) {
        try {
            if (this.active) {
                for (int k = 0; k < this.layerMapLength; ++k) {
                    if (this.layerMaps[k] == null) continue;
                    this.layerMaps[k].render(g);
                }
                for (int i = 0; i < this.currentLayerViewPortSprites.length; ++i) {
                    if (this.currentLayerViewPortSprites[i] == null) continue;
                    this.currentLayerViewPortSprites[i].render(g);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean addSprites(Sprites s) {
        if (this.allLayerSprites == null) {
            return true;
        }
        boolean have = this.isHaveSprites(s.getSpritesName());
        if (this.allLayerSpritesLength < this.allLayerSprites.length && !have) {
            s.setLayer(this);
            this.allLayerSprites[this.allLayerSpritesLength] = s;
            if (this.allLayerSprites[this.allLayerSpritesLength].isRegisterKeyContrl()) {
                this.allControlSpritesInLayer[this.allControlSpritesLength] = this.allLayerSprites[this.allLayerSpritesLength];
                ++this.allControlSpritesLength;
            }
            if (this.allLayerSprites[this.allLayerSpritesLength].isDraw() && this.currectLayerViewPortSpritesLength < MAX_SPRITES_SCREEN) {
                this.currentLayerViewPortSprites[this.currectLayerViewPortSpritesLength] = this.allLayerSprites[this.allLayerSpritesLength];
                ++this.currectLayerViewPortSpritesLength;
            }
            ++this.allLayerSpritesLength;
        }
        return have;
    }

    public boolean isHaveSprites(String name) {
        for (int i = 0; i < this.allLayerSpritesLength; ++i) {
            if (!this.allLayerSprites[i].getSpritesName().equals(name) || this.allLayerSprites[i] == null) continue;
            return true;
        }
        return false;
    }

    public Sprites getSpritesInLayerByName(String name) {
        int i;
        for (i = 0; i < this.currectLayerViewPortSpritesLength; ++i) {
            if (!this.currentLayerViewPortSprites[i].getSpritesName().equals(name) && this.currentLayerViewPortSprites[i].getSpritesName() != name) continue;
            return this.currentLayerViewPortSprites[i];
        }
        for (i = 0; i < this.allLayerSpritesLength; ++i) {
            if (!this.allLayerSprites[i].getSpritesName().equals(name) && this.allLayerSprites[i].getSpritesName() != name) continue;
            return this.allLayerSprites[i];
        }
        return null;
    }

    public void addMap(Map map) {
        if (this.layerMaps != null && this.layerMapLength < this.layerMaps.length) {
            this.layerMaps[this.layerMapLength] = map;
            ++this.layerMapLength;
        }
    }

    public void removeMap(String name) {
        for (int i = 0; i < this.layerMapLength; ++i) {
            if (!this.layerMaps[i].mapName.equals(name)) continue;
            this.layerMaps[i] = null;
            --this.layerMapLength;
        }
    }

    public void addImage(PlatformImage _img) {
        if (this.img != null && this.imgLength < this.img.length) {
            this.img[this.imgLength] = _img;
            ++this.imgLength;
        }
    }

    public void removeImage(int i) {
        if (this.img != null && i < this.imgLength) {
            this.img[i] = null;
            if (i != this.imgLength - 1) {
                System.arraycopy(this.img, i + 1, this.img, 1, this.imgLength - 1 - i);
            }
            --this.imgLength;
        }
    }

    public void removeAllImage() {
        if (this.img != null) {
            for (int i = 0; i < this.img.length; ++i) {
                if (this.img[i] == null) continue;
                this.img[i] = null;
            }
            this.imgLength = 0;
        }
    }

    public void removeSprites(String name) {
        int delayIndex = 0;
        for (int i = 0; i < this.allLayerSpritesLength; ++i) {
            if (this.allLayerSprites[i].getSpritesName() != name && !this.allLayerSprites[i].getSpritesName().equals(name)) continue;
            if (this.allLayerSprites[i].isRegisterKeyContrl()) {
                for (int j = 0; j < this.allControlSpritesLength; ++j) {
                    if (!this.allControlSpritesInLayer[j].getSpritesName().equals(name)) continue;
                    if (this.allControlSpritesInLayer[j] != null) {
                        this.allControlSpritesInLayer[j].releaseSprites();
                        this.allControlSpritesInLayer[j] = null;
                    }
                    if (j != this.allLayerSpritesLength - 1) {
                        System.arraycopy(this.allControlSpritesInLayer, j + 1, this.allControlSpritesInLayer, j, this.allLayerSpritesLength - i);
                    }
                    --this.allControlSpritesLength;
                    break;
                }
            }
            if (this.allLayerSprites[i] != null) {
                this.allLayerSprites[i].releaseSprites();
                this.allLayerSprites[i] = null;
            }
            delayIndex = i;
            try {
                if (delayIndex != this.allLayerSpritesLength - 1) {
                    System.arraycopy(this.allLayerSprites, i + 1, this.allLayerSprites, i, this.allLayerSpritesLength - i);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            --this.allLayerSpritesLength;
            this.updateCurrectViewPort = true;
            break;
        }
    }

    public void checkCollision() {
        try {
            int pllen = this.allControlSpritesLength;
            int len = this.currectLayerViewPortSpritesLength;
            for (int i = 0; i < pllen; ++i) {
                for (int j = 0; j < len; ++j) {
                    if (this.currentLayerViewPortSprites[j].isControl() || this.allControlSpritesInLayer[i] == this.currentLayerViewPortSprites[j] || !Utils.rectCollision2(this.allControlSpritesInLayer[i].getCollsionX(), this.allControlSpritesInLayer[i].getCollsionY(), this.allControlSpritesInLayer[i].getCollsionWidth(), this.allControlSpritesInLayer[i].getCollsionHeight(), this.currentLayerViewPortSprites[j].getCollsionX(), this.currentLayerViewPortSprites[j].getCollsionY(), this.currentLayerViewPortSprites[j].getCollsionWidth(), this.currentLayerViewPortSprites[j].getCollsionHeight())) continue;
                    EventManager.sendEvent(0, 0x20000001, 0, this._st, this.allControlSpritesInLayer[i], this.currentLayerViewPortSprites[j]);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public void checkCollision2() {
        try {
            int pllen = this.allControlSpritesLength;
            int len = this.currectLayerViewPortSpritesLength;
            for (int i = 0; i < pllen; ++i) {
                for (int j = 0; j < len; ++j) {
                    if (this.currentLayerViewPortSprites[j].isControl() || this.allControlSpritesInLayer[i] == this.currentLayerViewPortSprites[j]) continue;
                    for (int x = 0; x < this.allControlSpritesInLayer[i].collsionRect[this.allControlSpritesInLayer[i].getCurrectState()][this.allControlSpritesInLayer[i].getCurrentFrameIndex()].rectCount; ++x) {
                        for (int y = 0; y < this.currentLayerViewPortSprites[i].collsionRect[this.currentLayerViewPortSprites[i].getCurrectState()][this.currentLayerViewPortSprites[i].getCurrentFrameIndex()].rectCount; ++y) {
                            if (!Utils.rectCollision2(this.allControlSpritesInLayer[i].collsionRect[this.allControlSpritesInLayer[i].getCurrectState()][this.allControlSpritesInLayer[i].getCurrentFrameIndex()].collsionOpposeRect[x * 4], this.allControlSpritesInLayer[i].collsionRect[this.allControlSpritesInLayer[i].getCurrectState()][this.allControlSpritesInLayer[i].getCurrentFrameIndex()].collsionOpposeRect[x * 4 + 1], this.allControlSpritesInLayer[i].collsionRect[this.allControlSpritesInLayer[i].getCurrectState()][this.allControlSpritesInLayer[i].getCurrentFrameIndex()].collsionOpposeRect[x * 4 + 2], this.allControlSpritesInLayer[i].collsionRect[this.allControlSpritesInLayer[i].getCurrectState()][this.allControlSpritesInLayer[i].getCurrentFrameIndex()].collsionOpposeRect[x * 4 + 3], this.currentLayerViewPortSprites[j].collsionRect[this.currentLayerViewPortSprites[j].getCurrectState()][this.currentLayerViewPortSprites[j].getCurrentFrameIndex()].collsionOpposeRect[y * 4], this.currentLayerViewPortSprites[j].collsionRect[this.currentLayerViewPortSprites[j].getCurrectState()][this.currentLayerViewPortSprites[j].getCurrentFrameIndex()].collsionOpposeRect[y * 4 + 1], this.currentLayerViewPortSprites[j].collsionRect[this.currentLayerViewPortSprites[j].getCurrectState()][this.currentLayerViewPortSprites[j].getCurrentFrameIndex()].collsionOpposeRect[y * 4 + 2], this.currentLayerViewPortSprites[j].collsionRect[this.currentLayerViewPortSprites[j].getCurrectState()][this.currentLayerViewPortSprites[j].getCurrentFrameIndex()].collsionOpposeRect[y * 4 + 3])) continue;
                            this.allControlSpritesInLayer[i].setCollsionData(this.allControlSpritesInLayer[i].getCurrectState(), this.allControlSpritesInLayer[i].getCurrentFrameIndex(), x);
                            this.currentLayerViewPortSprites[j].setCollsionData(this.currentLayerViewPortSprites[j].getCurrectState(), this.currentLayerViewPortSprites[j].getCurrentFrameIndex(), y);
                            EventManager.sendEvent(0, 0x20000002, 0, this._st, this.allControlSpritesInLayer[i], this.currentLayerViewPortSprites[j]);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

