/*
 * Decompiled with CFR 0.152.
 */
public class AnimationMgr {
    private static final int A_FLAG_BOX = 1;
    protected static final int SEQ_FRM_IDX_MASK = 4095;
    protected static final int FRM_BLK_FLAG_MASK = 3;
    protected static final int SEQ_FRM_DURATION_SHIFT_BIT = 12;
    protected static final int FRM_BLK_XOFF_SHIFT_BIT = 2;
    private String aniFile;
    protected ImageMgr imgMgr;
    protected short[][] sequences;
    protected short[][] frames;
    protected short[][] frmBodyBox;
    protected short[][] frmCollideBox;
    protected short[][] seqBox;

    public AnimationMgr(String aniPakFile) {
        this.aniFile = aniPakFile;
        this.imgMgr = new ImageMgr("i", "p", "d");
    }

    public AnimationMgr(String aniPakFile, ImageMgr imgMgr) {
        this.aniFile = aniPakFile;
        this.imgMgr = imgMgr;
    }

    public int getAnimationCount() {
        return this.sequences == null ? 0 : this.sequences.length;
    }

    public void loadAnimationInfo() {
        try {
            int j;
            int i;
            PlatformResource in = Platform.getResource("/" + this.aniFile);
            int flag = in.readInt();
            int seqCnt = in.readShort();
            short totalFrmCnt = in.readShort();
            if (this.frames == null) {
                this.frames = new short[totalFrmCnt][];
            }
            byte[] frmIsToLoad = new byte[totalFrmCnt + 7 >> 3];
            int frmCnt = 0;
            for (i = 0; i < seqCnt; ++i) {
                frmCnt = in.readByte() & 0xFF;
                if (this.seqBox[i] == null) {
                    in.skipBytes(frmCnt * 2);
                    continue;
                }
                this.sequences[i] = new short[frmCnt];
                for (j = 0; j < frmCnt; ++j) {
                    this.sequences[i][j] = in.readShort();
                    int tmpFrmIdx = this.sequences[i][j] & 0xFFF;
                    int n = tmpFrmIdx >> 3;
                    frmIsToLoad[n] = (byte)(frmIsToLoad[n] | 1 << (tmpFrmIdx & 7));
                }
            }
            int blkCnt = 0;
            if ((flag & 1) != 0) {
                if (this.frmBodyBox == null) {
                    this.frmBodyBox = new short[totalFrmCnt][];
                    this.frmCollideBox = new short[totalFrmCnt][];
                }
                int boxCnt = 0;
                for (i = 0; i < totalFrmCnt; ++i) {
                    if ((frmIsToLoad[i >> 3] >> (i & 7) & 1) == 0) {
                        in.skipBytes((in.readByte() & 0xFF) * 6);
                        in.skipBytes((in.readByte() & 0xFF) << 3);
                        in.skipBytes((in.readByte() & 0xFF) << 3);
                        continue;
                    }
                    blkCnt = in.readByte() & 0xFF;
                    this.frames[i] = new short[blkCnt * 3];
                    j = 0;
                    while (j < this.frames[i].length) {
                        this.frames[i][j] = in.readShort();
                        this.imgMgr.addLoadImgId(this.frames[i][j++]);
                        this.frames[i][j++] = in.readShort();
                        this.frames[i][j++] = in.readShort();
                    }
                    boxCnt = in.readByte() & 0xFF;
                    if (boxCnt > 0) {
                        this.frmBodyBox[i] = new short[boxCnt << 2];
                        for (j = 0; j < this.frmBodyBox[i].length; ++j) {
                            this.frmBodyBox[i][j] = in.readShort();
                        }
                    }
                    if ((boxCnt = in.readByte() & 0xFF) <= 0) continue;
                    this.frmCollideBox[i] = new short[boxCnt << 2];
                    for (j = 0; j < this.frmCollideBox[i].length; ++j) {
                        this.frmCollideBox[i][j] = in.readShort();
                    }
                }
            } else {
                for (i = 0; i < totalFrmCnt; ++i) {
                    if ((frmIsToLoad[i >> 3] >> (i & 7) & 1) == 0) {
                        in.skipBytes((in.readByte() & 0xFF) * 6);
                        continue;
                    }
                    blkCnt = in.readByte() & 0xFF;
                    this.frames[i] = new short[blkCnt * 3];
                    j = 0;
                    while (j < this.frames[i].length) {
                        this.frames[i][j] = in.readShort();
                        this.imgMgr.addLoadImgId(this.frames[i][j++]);
                        this.frames[i][j++] = in.readShort();
                        this.frames[i][j++] = in.readShort();
                    }
                }
            }
            frmIsToLoad = null;
            in.close();
            in = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.gc();
    }

    public void setRealizeCnt(int cnt) {
        this.imgMgr.setCallCnt(cnt);
    }

    public boolean realizeAnimations() {
        if (!this.imgMgr.loadImgs()) {
            return false;
        }
        for (int i = this.seqBox.length - 1; i >= 0; --i) {
            if (this.seqBox[i] == null || this.seqBox[i][0] != 0 || this.seqBox[i][1] != 0 || this.seqBox[i][2] != 0 || this.seqBox[i][3] != 0) continue;
            this.initAniBox(i);
        }
        return true;
    }

    public Animation loadAnimation(Sprites s, int aniIndex) {
        return this.loadAnimation(s, aniIndex, true);
    }

    public Animation loadAnimation(Sprites s, int aniIndex, boolean isLoop) {
        if (this.seqBox[aniIndex] == null) {
            this.seqBox[aniIndex] = new short[4];
        }
        return new Animation(s, this, aniIndex, isLoop);
    }

    public void releaseAnimation(int aniIndex) {
        for (int i = 0; i < this.sequences[aniIndex].length; ++i) {
            int frmIdx = this.sequences[aniIndex][i] & 0xFFF;
            for (int j = 0; j < this.frames[frmIdx].length; j += 3) {
                this.imgMgr.releaseImage(this.frames[frmIdx][j]);
            }
            this.frames[frmIdx] = new short[0];
            if (this.frmBodyBox != null) {
                this.frmBodyBox[frmIdx] = null;
            }
            if (this.frmCollideBox == null) continue;
            this.frmCollideBox[frmIdx] = null;
        }
        this.sequences[aniIndex] = new short[0];
        this.seqBox[aniIndex] = null;
    }

    public void releaseAllAnimation() {
        int i;
        if (this.seqBox == null) {
            return;
        }
        for (i = this.seqBox.length - 1; i >= 0; --i) {
            this.seqBox[i] = null;
            this.sequences[i] = null;
        }
        if (this.frames != null) {
            for (i = this.frames.length - 1; i >= 0; --i) {
                this.frames[i] = null;
            }
        }
        this.imgMgr.releaseAllImages();
    }

    protected void initAniBox(int aniIndex) {
        short s;
        int left = Integer.MAX_VALUE;
        int n = Integer.MAX_VALUE;
        int right = -2147483647;
        int bottom = -2147483647;
        for (int i = this.sequences[aniIndex].length - 1; i >= 0; --i) {
            int tmpFrmIdx = this.sequences[aniIndex][i] & 0xFFF;
            if (this.frames[tmpFrmIdx] == null) continue;
            short[] blkInfo = this.frames[tmpFrmIdx];
            int j = 0;
            while (j < blkInfo.length) {
                int tmpBoxValue;
                short tmpBlkYOff;
                int tmpBlkXOff;
                short tmpBlkIdx;
                if (this.imgMgr.imgs[tmpBlkIdx = blkInfo[j++]] == null) {
                    j += 2;
                    continue;
                }
                if ((tmpBlkXOff = blkInfo[j++] >> 2) < left) {
                    left = tmpBlkXOff;
                }
                if ((tmpBlkYOff = blkInfo[j++]) < s) {
                    s = tmpBlkYOff;
                }
                if ((tmpBoxValue = tmpBlkXOff + this.imgMgr.imgs[tmpBlkIdx].getWidth()) > right) {
                    right = tmpBoxValue;
                }
                if ((tmpBoxValue = tmpBlkYOff + this.imgMgr.imgs[tmpBlkIdx].getHeight()) <= bottom) continue;
                bottom = tmpBoxValue;
            }
        }
        this.seqBox[aniIndex][0] = (short)left;
        this.seqBox[aniIndex][1] = s;
        this.seqBox[aniIndex][2] = (short)right;
        this.seqBox[aniIndex][3] = (short)bottom;
    }

    public void init() {
        this.imgMgr.init();
        try {
            PlatformResource in = Platform.getResource("/" + this.aniFile);
            in.skipBytes(4);
            short seqCnt = in.readShort();
            this.sequences = new short[seqCnt][];
            this.seqBox = new short[seqCnt][];
            in.close();
            in = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.gc();
    }
}

