/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.ContentConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Platform {
    public static final boolean LOG = true;
    public static final boolean DEBUG = true;
    public static final boolean ASSERT = true;
    public static final int IMAGE_FORMAT_PNG = 0;
    public static final int IMAGE_FORMAT_JPG = 1;
    public static final int TRANSFORM_NONE = 0;
    public static final int TRANS_FLIP_X = 2;
    public static final int TRANS_FLIP_Y = 1;
    public static final int TRANS_ROTATE_90 = 5;
    public static final int TRANS_ROTATE_180 = 3;
    public static final int TRANS_ROTATE_270 = 6;
    public static final int SOUND_FORMAT_MIDI = 0;
    public static final int SOUND_FORMAT_WAV = 1;
    public static final int SOUND_FORMAT_AMR = 2;
    public static final int SOUND_FORMAT_OGG = 3;
    public static final int SOUND_FORMAT_MP3 = 4;
    public static final int SOUND_FORMAT_AAC = 5;
    private static final int BEEP_NOTE = 69;
    public static final int KEY_NUM0 = 1;
    public static final int KEY_NUM1 = 2;
    public static final int KEY_NUM2 = 3;
    public static final int KEY_NUM3 = 4;
    public static final int KEY_NUM4 = 5;
    public static final int KEY_NUM5 = 6;
    public static final int KEY_NUM6 = 7;
    public static final int KEY_NUM7 = 8;
    public static final int KEY_NUM8 = 9;
    public static final int KEY_NUM9 = 10;
    public static final int KEY_STAR = 11;
    public static final int KEY_POUND = 12;
    public static final int KEY_CLEAR = 13;
    public static final int KEY_LEFT_SOFT = 14;
    public static final int KEY_RIGHT_SOFT = 15;
    public static final int KEY_CENTER_SOFT = 16;
    public static final int KEY_UP_ARROW = 17;
    public static final int KEY_DOWN_ARROW = 18;
    public static final int KEY_LEFT_ARROW = 19;
    public static final int KEY_RIGHT_ARROW = 20;
    public static final int FONT_SMALL_PLAIN = 0;
    public static final int FONT_SMALL_BOLD = 1;
    public static final int FONT_MEDIUM_PLAIN = 2;
    public static final int FONT_MEDIUM_BOLD = 3;
    public static final int FONT_LARGE_PLAIN = 4;
    public static final int FONT_LARGE_BOLD = 5;
    static Graphics g;
    static final PlatformGraphics displayGraphics;
    static Font[] systemFonts;
    static final String RMS_NAME = "RMS";
    private static int debugLogCounter;

    static void init() {
        systemFonts = new Font[6];
        Platform.systemFonts[0] = Font.getFont((int)0, (int)0, (int)8);
        Platform.systemFonts[1] = Font.getFont((int)0, (int)1, (int)8);
        Platform.systemFonts[2] = Font.getFont((int)0, (int)0, (int)0);
        Platform.systemFonts[3] = Font.getFont((int)0, (int)1, (int)0);
        Platform.systemFonts[4] = Font.getFont((int)0, (int)0, (int)16);
        Platform.systemFonts[5] = Font.getFont((int)0, (int)1, (int)16);
    }

    public static void exit() {
        PlatformCanvas.instance.exit();
    }

    public static void gc() {
        System.gc();
    }

    public int freeMemory() {
        return (int)Runtime.getRuntime().freeMemory();
    }

    public static void beep() {
        try {
            Manager.playTone((int)69, (int)500, (int)100);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void alert(String message) {
        Alert alert = new Alert("License: ");
        alert.setString(message);
        alert.setType(AlertType.INFO);
        alert.setTimeout(-2);
        alert.setCommandListener(new CommandListener(){

            public void commandAction(Command command, Displayable displayable) {
                PlatformMIDlet.display.setCurrent((Displayable)PlatformMIDlet.canvas);
            }
        });
        Display display = PlatformMIDlet.display;
        display.setCurrent((Displayable)alert);
        try {
            do {
                Thread.sleep(1000L);
            } while (display.getCurrent() != PlatformMIDlet.canvas);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void vibrate(int duration) {
        PlatformMIDlet.display.vibrate(duration);
    }

    public static void sleep(int duration) {
        if (duration <= 0) {
            Thread.yield();
        } else {
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static long clock() {
        return System.currentTimeMillis();
    }

    public static void arraycopy(Object src, int src_position, Object dst, int dst_position, int length) {
        System.arraycopy(src, src_position, dst, dst_position, length);
    }

    public static String getLocale() {
        return System.getProperty("microedition.locale");
    }

    public static String getManifestProperty(String propertyName) {
        return PlatformMIDlet.instance.getAppProperty(propertyName);
    }

    public static String getAppVersion() {
        return Platform.getManifestProperty("MIDlet-Version");
    }

    public static boolean getAppDemoEnable() {
        return false;
    }

    public static int getAction(int keySymbol) {
        return keySymbol;
    }

    public static void setLabels(String left, String right) {
    }

    public static void openURL(String url) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlatformResource openConnection(String url) {
        ContentConnection c = null;
        DataInputStream is = null;
        try {
            c = (ContentConnection)Connector.open((String)url);
            is = c.openDataInputStream();
        }
        catch (Exception exception) {}
        return new PlatformResource(is);
    }

    public static PlatformResource getResource(String resourceName) {
        InputStream in = ((Object)((Object)PlatformMIDlet.instance)).getClass().getResourceAsStream(resourceName);
        if (in == null) {
            return null;
        }
        return new PlatformResource(new DataInputStream(in));
    }

    public static byte[] readRecord(int recordId) {
        byte[] data = Platform.readRecordStore(RMS_NAME + recordId, 0);
        return data;
    }

    public static void writeRecord(int recordId, byte[] data, int length) {
        try {
            Platform.writeRecordStore(RMS_NAME + recordId, 0, data, length);
        }
        catch (Exception e) {
            Platform.debuglog(RMS_NAME, e);
        }
    }

    public static void deleteRecordStore(int recordId) {
        Platform.deleteRecordStore(RMS_NAME + recordId);
    }

    private static void deleteRecordStore(String name) {
        try {
            RecordStore.deleteRecordStore((String)name);
        }
        catch (RecordStoreException e) {
            Platform.debuglog(RMS_NAME, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readRecordStore(String name, int recordId) {
        block17: {
            byte[] byArray;
            RecordStore store = null;
            try {
                byte[] data;
                store = RecordStore.openRecordStore((String)name, (boolean)false);
                int numRecords = store.getNumRecords();
                if (numRecords < recordId + 1) {
                    byte[] byArray2 = null;
                    return byArray2;
                }
                byArray = data = store.getRecord(1 + recordId);
            }
            catch (Exception e) {
                if (store != null) {
                    Platform.debuglog(RMS_NAME, e);
                }
                break block17;
            }
            finally {
                if (store != null) {
                    try {
                        store.closeRecordStore();
                    }
                    catch (RecordStoreException recordStoreException) {}
                }
            }
            return byArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRecordStore(String name, int recordId, byte[] data, int length) {
        RecordStore store = null;
        try {
            store = RecordStore.openRecordStore((String)name, (boolean)true);
            int numRecords = store.getNumRecords();
            int ensureRecords = recordId + 1;
            if (numRecords < ensureRecords) {
                int inbetween = ensureRecords - numRecords - 1;
                for (int i = 0; i < inbetween; ++i) {
                    store.addRecord(data, 0, 1);
                }
                store.addRecord(data, 0, length);
            } else {
                store.setRecord(1 + recordId, data, 0, length);
            }
        }
        catch (Exception e) {
            Platform.debuglog(RMS_NAME, e);
        }
        finally {
            try {
                if (store != null) {
                    store.closeRecordStore();
                }
            }
            catch (RecordStoreException e) {}
        }
    }

    public static PlatformSound createSound(int format, byte[] buffer) {
        Platform.assertTrue(format >= 0 && format <= 5);
        return new Sound_MM_API(format, buffer);
    }

    public static PlatformSound createSound(int format, String resourceName) {
        Platform.assertTrue(format >= 0 && format <= 5);
        return new Sound_MM_API(format, resourceName);
    }

    public static PlatformGraphics getDisplayGraphics() {
        return displayGraphics;
    }

    public static int getDisplayWidth() {
        return PlatformCanvas.canvasWidth;
    }

    public static int getDisplayHeight() {
        return PlatformCanvas.canvasHeight;
    }

    public static PlatformImage createImage(int format, byte[] buffer, int offset, int length) {
        Image image = Image.createImage((byte[])buffer, (int)offset, (int)length);
        return new PlatformImage(image);
    }

    public static PlatformImage createImage(int format, String resourceName) {
        Image image = Platform.loadSingleImage(resourceName);
        return image == null ? null : new PlatformImage(image);
    }

    private static Image loadSingleImage(String resourceName) {
        InputStream in = ((Object)((Object)PlatformMIDlet.instance)).getClass().getResourceAsStream(resourceName);
        if (in == null) {
            return null;
        }
        return Platform.loadSingleImage(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image loadSingleImage(InputStream in) {
        try {
            Image image = Image.createImage((InputStream)in);
            Platform.sleep(50);
            Image image2 = image;
            return image2;
        }
        catch (Exception e) {
            Platform.debuglog("IMAGE", e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static PlatformImage createTransformImage(PlatformImage source, int transform) {
        Image copy = Image.createImage((Image)source.image, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (int)2);
        return new PlatformImage(copy);
    }

    public static PlatformImage createOffscreenImage(int width, int height) {
        PlatformImage image = new PlatformImage(Image.createImage((int)width, (int)height));
        image.mutable = true;
        return image;
    }

    public static PlatformImage createRGBImage(int[] rgb, int width, int height, boolean processAlpha) {
        return new PlatformImage(Image.createRGBImage((int[])rgb, (int)width, (int)height, (boolean)processAlpha));
    }

    public static void redraw() {
        PlatformCanvas.repaintRequest = true;
    }

    public static int getFontHeight(int font) {
        Font f = systemFonts[font];
        return f.getHeight();
    }

    public static int getFontAscent(int font) {
        Font f = systemFonts[font];
        return f.getBaselinePosition();
    }

    public static int getFontDescent(int font) {
        Font f = systemFonts[font];
        return f.getHeight() - f.getBaselinePosition();
    }

    public static int getFontTextWidth(int font, String text) {
        Font f = systemFonts[font];
        return f.stringWidth(text);
    }

    public static int getFontTextWidth(int font, char[] text, int offset, int length) {
        Font f = systemFonts[font];
        return f.charsWidth(text, offset, length);
    }

    public static void debuglog(String message) {
    }

    static void debuglog(String message, Throwable e) {
        if (message != null) {
            Platform.debuglog(message + e);
        }
        if (e != null) {
            e.printStackTrace();
        }
    }

    public static void assertTrue(boolean expr, String message) {
        if (!expr) {
            Error e = new Error();
            String m = "assertion failed";
            if (message != null) {
                m = m + ": " + message;
            }
            Platform.debuglog(m);
            throw e;
        }
    }

    public static void assertTrue(boolean expr) {
        Platform.assertTrue(expr, null);
    }

    public static void assertFalse(boolean expr) {
        Platform.assertTrue(!expr, null);
    }

    public static void assertFalse(boolean expr, String message) {
        Platform.assertTrue(!expr, message);
    }

    public static boolean checkDiskSpace() {
        return true;
    }

    static {
        displayGraphics = new PlatformGraphics();
        debugLogCounter = 0;
    }
}

