/*
 * Decompiled with CFR 0.152.
 */
public class ImageMgr {
    protected PlatformImage[] imgs;
    static byte[][] info;
    public byte[] imgData;
    private int maxImgDataLen;
    private static final int PER_INFO_LEN = 11;
    private static final int HDRLEN = 13;
    private static final byte[] SIG;
    public static final int IHDR = 1229472850;
    public static final int IPLTE = 1347179589;
    public static final int TRNS = 1951551059;
    public static final int IDAT = 1229209940;
    public static final int IEND = 1229278788;
    public static final int ENDCRC = -1371381630;
    public static final int I_FLAG_RGB = 1;
    private int iFlag;
    private String iF;
    private String pF;
    private String dF;
    private byte[] isToLoad;
    private int toLoadImgCnt;
    private int hasLoadCnt;
    private int callCnt = 1;
    private int lastLoadIndex = -1;
    private int blockCnt;
    private int curDIdx = -1;
    private byte[][] plts;
    private byte[][] tRans;
    private int[] datTb;
    private PlatformResource infoIn;
    private PlatformResource datIn;
    protected short[] width;
    protected short[] height;
    public static final int PALETTE_TYPE_NORMAL = 0;
    public static final int PALETTE_TYPE_NIGHTVISION = 1;
    private int paletteType;

    public void setPaletteType(int type) {
        this.paletteType = type;
    }

    public ImageMgr(String infoFile, String plteFile, String idatFile) {
        this.iF = infoFile;
        this.pF = plteFile;
        this.dF = idatFile;
        this.paletteType = 0;
    }

    public void init() {
        try {
            this.infoIn = Platform.getResource("/" + this.iF);
            this.iFlag = this.infoIn.readInt();
            this.blockCnt = this.infoIn.readShort();
            this.imgs = new PlatformImage[this.blockCnt];
            this.isToLoad = new byte[this.blockCnt + 7 >> 3];
            this.width = new short[this.blockCnt];
            this.height = new short[this.blockCnt];
            if ((this.iFlag & 1) != 0) {
                this.datTb = new int[this.blockCnt + 1];
                for (int i = 0; i < this.datTb.length; ++i) {
                    this.datTb[i] = this.infoIn.readInt();
                }
            }
            this.infoIn.close();
            this.infoIn = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addLoadImgId(int id) {
        int arrayIdx = id >> 3;
        int bitIdx = id & 7;
        if ((this.isToLoad[arrayIdx] >> bitIdx & 1) == 0) {
            int n = arrayIdx;
            this.isToLoad[n] = (byte)(this.isToLoad[n] | 1 << bitIdx);
            ++this.toLoadImgCnt;
        }
    }

    public void releaseImage(int index) {
        this.imgs[index] = null;
    }

    public void releaseAllImages() {
        int i;
        for (i = 0; i < this.imgs.length; ++i) {
            this.imgs[i] = null;
        }
        for (i = 0; i < this.isToLoad.length; ++i) {
            this.isToLoad[i] = 0;
        }
        this.curDIdx = -1;
        this.lastLoadIndex = -1;
        this.hasLoadCnt = 0;
        this.toLoadImgCnt = 0;
    }

    public void setCallCnt(int cnt) {
        this.callCnt = cnt;
    }

    public boolean loadImgs() {
        if (this.hasLoadCnt >= this.toLoadImgCnt) {
            return true;
        }
        if ((this.iFlag & 1) == 0) {
            return this.loadPltImgs();
        }
        return this.loadRGBImgs();
    }

    private boolean loadPltImgs() {
        boolean finished = false;
        try {
            if (this.lastLoadIndex == -1) {
                int i;
                PlatformResource plteIn = Platform.getResource("/" + this.pF);
                int pltCnt = plteIn.readShort();
                this.plts = new byte[pltCnt][];
                this.tRans = new byte[pltCnt][];
                for (int p = 0; p < pltCnt; ++p) {
                    this.plts[p] = new byte[plteIn.readShort()];
                    plteIn.readFully(this.plts[p]);
                    short len = plteIn.readShort();
                    if (len <= 0) continue;
                    this.tRans[p] = new byte[len];
                    plteIn.readFully(this.tRans[p]);
                }
                plteIn.close();
                plteIn = null;
                System.gc();
                Thread.sleep(50L);
                this.infoIn = Platform.getResource("/" + this.iF);
                this.infoIn.skipBytes(4);
                int blockCnt = this.infoIn.readShort();
                info = new byte[blockCnt][11];
                for (i = 0; i < blockCnt; ++i) {
                    this.infoIn.readFully(info[i]);
                }
                this.infoIn.close();
                this.infoIn = null;
                System.gc();
                this.datIn = Platform.getResource("/" + this.dF);
                this.datTb = new int[this.datIn.readShort()];
                for (int d = 0; d < this.datTb.length; ++d) {
                    this.datTb[d] = this.datIn.readInt();
                }
                if (this.maxImgDataLen == 0) {
                    for (i = 0; i < blockCnt; ++i) {
                        short pltId = (short)((info[i][9] & 0xFF) << 8 | info[i][10] & 0xFF);
                        int datLen = this.datTb[i + 1] - this.datTb[i];
                        int imgLen = 61 + this.plts[pltId].length + datLen + (this.tRans[pltId] == null ? 0 : this.tRans[pltId].length + 8);
                        if (imgLen <= this.maxImgDataLen) continue;
                        this.maxImgDataLen = imgLen;
                    }
                }
                this.imgData = new byte[this.maxImgDataLen];
            }
            int curLoadCnt = 0;
            int perLoadCnt = (this.toLoadImgCnt + this.callCnt - 1) / this.callCnt;
            for (int i = this.lastLoadIndex + 1; i < this.blockCnt; ++i) {
                int flagArrayIdx = i >> 3;
                int flagBitIdx = i & 7;
                if ((this.isToLoad[flagArrayIdx] >> flagBitIdx & 1) == 0) continue;
                short widthTmp = (short)((info[i][0] & 0xFF) << 8 | info[i][1] & 0xFF);
                if (this.imgs[i] != null || widthTmp == 0) {
                    int n = flagArrayIdx;
                    this.isToLoad[n] = (byte)(this.isToLoad[n] & ~(1 << flagBitIdx));
                    ++curLoadCnt;
                    ++this.hasLoadCnt;
                    if (this.hasLoadCnt < this.toLoadImgCnt) continue;
                    finished = true;
                    break;
                }
                if (i > this.lastLoadIndex + 1) {
                    this.datIn.skipBytes(this.datTb[i] - this.datTb[this.lastLoadIndex + 1]);
                }
                this.lastLoadIndex = i;
                short heightTmp = (short)((info[i][2] & 0xFF) << 8 | info[i][3] & 0xFF);
                this.width[i] = widthTmp;
                this.height[i] = heightTmp;
                byte bitDep = info[i][4];
                int hdrCrc = (info[i][5] & 0xFF) << 24 | (info[i][6] & 0xFF) << 16 | (info[i][7] & 0xFF) << 8 | info[i][8] & 0xFF;
                short pltId = (short)((info[i][9] & 0xFF) << 8 | info[i][10] & 0xFF);
                int datLen = this.datTb[i + 1] - this.datTb[i];
                int idx = 0;
                System.arraycopy(SIG, 0, this.imgData, 0, 8);
                this.writeIntToArray(this.imgData, idx += 8, 13);
                this.writeIntToArray(this.imgData, idx += 4, 1229472850);
                this.writeIntToArray(this.imgData, idx += 4, widthTmp);
                this.writeIntToArray(this.imgData, idx += 4, heightTmp);
                this.imgData[idx += 4] = bitDep;
                this.imgData[++idx] = 3;
                this.imgData[++idx] = 0;
                this.imgData[++idx] = 0;
                this.imgData[++idx] = 0;
                this.writeIntToArray(this.imgData, ++idx, hdrCrc);
                this.writeIntToArray(this.imgData, idx += 4, this.plts[pltId].length - 4);
                this.writeIntToArray(this.imgData, idx += 4, 1347179589);
                System.arraycopy(this.plts[pltId], 0, this.imgData, idx += 4, this.plts[pltId].length);
                idx += this.plts[pltId].length;
                if (this.tRans[pltId] != null) {
                    this.writeIntToArray(this.imgData, idx, this.tRans[pltId].length - 4);
                    this.writeIntToArray(this.imgData, idx += 4, 1951551059);
                    System.arraycopy(this.tRans[pltId], 0, this.imgData, idx += 4, this.tRans[pltId].length);
                    idx += this.tRans[pltId].length;
                }
                this.writeIntToArray(this.imgData, idx, datLen - 4);
                this.writeIntToArray(this.imgData, idx += 4, 1229209940);
                this.datIn.readFully(this.imgData, idx += 4, datLen);
                this.writeIntToArray(this.imgData, idx += datLen, 0);
                this.writeIntToArray(this.imgData, idx += 4, 1229278788);
                this.writeIntToArray(this.imgData, idx += 4, -1371381630);
                this.imgs[i] = Platform.createImage(0, this.imgData, 0, idx += 4);
                int n = flagArrayIdx;
                this.isToLoad[n] = (byte)(this.isToLoad[n] & ~(1 << flagBitIdx));
                ++curLoadCnt;
                ++this.hasLoadCnt;
                if (this.hasLoadCnt >= this.toLoadImgCnt) {
                    finished = true;
                    break;
                }
                if (curLoadCnt >= perLoadCnt) break;
            }
            if (finished) {
                info = null;
                this.datIn.close();
                this.datIn = null;
                this.imgData = null;
                this.plts = null;
                this.tRans = null;
                this.datTb = null;
                this.lastLoadIndex = -1;
                this.hasLoadCnt = 0;
                this.toLoadImgCnt = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.gc();
        return finished;
    }

    private boolean loadRGBImgs() {
        boolean finished = false;
        try {
            if (this.lastLoadIndex == -1) {
                PlatformResource plteIn = Platform.getResource("/" + this.pF);
                int pltCnt = plteIn.readShort();
                this.plts = new byte[pltCnt][];
                for (int p = 0; p < pltCnt; ++p) {
                    this.plts[p] = new byte[plteIn.readShort()];
                    plteIn.readFully(this.plts[p]);
                }
                plteIn.close();
                plteIn = null;
            }
            int curLoadCnt = 0;
            int perLoadCnt = (this.toLoadImgCnt + this.callCnt - 1) / this.callCnt;
            for (int i = this.lastLoadIndex + 1; i < this.blockCnt; ++i) {
                int flagArrayIdx = i >> 3;
                int flagBitIdx = i & 7;
                if ((this.isToLoad[flagArrayIdx] >> flagBitIdx & 1) == 0) continue;
                if (this.imgs[i] != null) {
                    int n = flagArrayIdx;
                    this.isToLoad[n] = (byte)(this.isToLoad[n] & ~(1 << flagBitIdx));
                    ++curLoadCnt;
                    ++this.hasLoadCnt;
                    if (this.hasLoadCnt < this.toLoadImgCnt) continue;
                    finished = true;
                    break;
                }
                int tmpDIdx = this.datTb[i] >> 20;
                if (tmpDIdx != this.curDIdx) {
                    this.curDIdx = tmpDIdx;
                    if (this.datIn != null) {
                        this.datIn.close();
                    }
                    this.datIn = Platform.getResource("/" + this.dF + tmpDIdx);
                    this.datIn.skipBytes(this.datTb[i] & 0xFFFFF);
                } else if (i > this.lastLoadIndex + 1) {
                    this.datIn.skipBytes(this.datTb[i] - this.datTb[this.lastLoadIndex + 1]);
                }
                this.lastLoadIndex = i;
                short curWidth = this.datIn.readShort();
                if (curWidth == 0) continue;
                short curHeight = this.datIn.readShort();
                short pltIdx = this.datIn.readShort();
                byte[] curPlt = this.plts[pltIdx];
                this.width[i] = curWidth;
                this.height[i] = curHeight;
                int rgbLen = curWidth * curHeight;
                int[] rgbData = new int[rgbLen];
                for (int j = 0; j < rgbLen; ++j) {
                    int pixelIdx = (this.datIn.readByte() & 0xFF) << 2;
                    int n = j;
                    rgbData[n] = rgbData[n] | (curPlt[pixelIdx] & 0xFF) << 24;
                    int n2 = j;
                    rgbData[n2] = rgbData[n2] | (curPlt[pixelIdx + 1] & 0xFF) << 16;
                    int n3 = j;
                    rgbData[n3] = rgbData[n3] | (curPlt[pixelIdx + 2] & 0xFF) << 8;
                    int n4 = j;
                    rgbData[n4] = rgbData[n4] | curPlt[pixelIdx + 3] & 0xFF;
                    if (this.paletteType != 1) continue;
                    int rgb = rgbData[j];
                    int tmp = 299 * (rgb >> 16 & 0xFF) / 1000 + 587 * (rgb >> 8 & 0xFF) / 1000 + 114 * (rgb >> 0 & 0xFF) / 1000;
                    if ((tmp = tmp * 15 / 10) > 255) {
                        tmp = 255;
                    }
                    rgbData[j] = rgb & 0xFF000000 | tmp << 8;
                }
                this.imgs[i] = Platform.createRGBImage(rgbData, curWidth, curHeight, true);
                int n = flagArrayIdx;
                this.isToLoad[n] = (byte)(this.isToLoad[n] & ~(1 << flagBitIdx));
                ++curLoadCnt;
                ++this.hasLoadCnt;
                if (this.hasLoadCnt >= this.toLoadImgCnt) {
                    finished = true;
                    break;
                }
                if (curLoadCnt >= perLoadCnt) break;
            }
            if (finished) {
                if (this.datIn != null) {
                    this.datIn.close();
                    this.datIn = null;
                }
                this.curDIdx = -1;
                this.plts = null;
                this.tRans = null;
                this.lastLoadIndex = -1;
                this.hasLoadCnt = 0;
                this.toLoadImgCnt = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.gc();
        return finished;
    }

    private void writeIntToArray(byte[] array, int idx, int val) {
        array[idx++] = (byte)(val >> 24);
        array[idx++] = (byte)(val >> 16);
        array[idx++] = (byte)(val >> 8);
        array[idx++] = (byte)val;
    }

    static {
        SIG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    }
}

