/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class Utils {
    private static byte[] atanTable = new byte[]{0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 6, 6, 6, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 10, 10, 10, 11, 11, 11, 11, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 15, 15, 15, 15, 16, 16, 16, 17, 17, 17, 17, 18, 18, 18, 18, 19, 19, 19, 19, 20, 20, 20, 20, 21, 21, 21, 21, 22, 22, 22, 22, 23, 23, 23, 23, 23, 24, 24, 24, 24, 25, 25, 25, 25, 25, 26, 26, 26, 26, 26, 27, 27, 27, 27, 27, 28, 28, 28, 28, 28, 29, 29, 29, 29, 29, 29, 30, 30, 30, 30, 30, 31, 31, 31, 31, 31, 31, 32, 32, 32, 32, 32};
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    static final char[] charBuffer = new char[33];
    private static char[] timeString = new char[8];
    private static long seed = Platform.clock();
    private static final int MIN_RADIX = 1;
    private static final int MAX_RADIX = 32;
    public static final int IMG_TYPE_CREATE_DIFF = 2;
    public static final int IMG_COLOR_VARIANT_0_BIT = 8;
    public static final int IMG_TYPE_CREATE_HORIZONTAL_MIRROR = 4;
    public static final int IMG_HAS_HORIZONTAL_MIRROR = 128;
    public static final int IMG_HAS_HORIZONTAL_MIRROR_MASK = 127;
    public static final int IMG_TOTAL_COLOR_VARIANT_MASK = 127;
    public static final int IMG_HORIZONTAL_MIRROR_MUST_LOADED = -1;
    private static final int[] progressBackColors = new int[]{0x7F0000, 0x7F7F00, 32512};
    private static final int[] progressFrontColors = new int[]{0xFF0000, 0xFFFF00, 65280};
    public static final int IMAGE_RGB = 0;
    public static final int IMAGE_RGBA = 1;
    public static final int IMAGE_LUMINANCE = 2;
    private static final boolean IMAGE_DEBUG = false;
    private static final int PNG_SIGNATURE1 = -1991225785;
    private static final int PNG_SIGNATURE2 = 218765834;
    private static final int PNG_CHUNK_IHDR = 1229472850;
    private static final int PNG_CHUNK_tRNS = 1951551059;
    private static final int PNG_COLOR_GRAYSCALE = 0;
    private static final int PNG_COLOR_RGB = 2;
    private static final int PNG_COLOR_INDEXED = 3;
    private static final int PNG_COLOR_GRAYSCALE_ALPHA = 4;
    private static final int PNG_COLOR_RGBA = 6;
    private static Random r = new Random();

    public static boolean rectCollision1(int RectX, int RectY, int RectWidth, int RectHeight, int ObjX, int ObjY, int ObjWidth, int ObjHeight) {
        return RectX + RectWidth > ObjX && RectX < ObjX + ObjWidth && RectY + RectHeight > ObjY && RectY < ObjY + ObjHeight;
    }

    public static final boolean rectCollision2(int ax, int ay, int aw, int ah, int bx, int by, int bw, int bh) {
        return by + bh >= ay && by <= ay + ah && bx + bw >= ax && bx <= ax + aw;
    }

    public static int align(int value, int alignment) {
        return value + --alignment & ~alignment;
    }

    public static int wrap(int value, int first, int last) {
        if (value < first) {
            return last;
        }
        if (value > last) {
            return first;
        }
        return value;
    }

    public static int clamp(int x, int minValue, int maxValue) {
        return Math.max(minValue, Math.min(maxValue, x));
    }

    public static int lerp(int a, int b, int alpha) {
        return a + alpha * (b - a) / 256;
    }

    public static int lerp(int a, int b, int alphaNom, int alphaDenom) {
        return a + alphaNom * (b - a) / alphaDenom;
    }

    public static int atan2(int i, int j) {
        int l;
        if (i == 0) {
            return j < 0 ? 128 : 0;
        }
        if (j == 0) {
            return i <= 0 ? 192 : 64;
        }
        int k = i >= 0 ? i : -i;
        int n = l = j >= 0 ? j : -j;
        if (k <= l) {
            byte i1 = atanTable[((k << 7) + (l >> 1)) / l];
            if (j > 0) {
                if (i > 0) {
                    return i1;
                }
                return 256 - i1;
            }
            if (i > 0) {
                return 128 - i1;
            }
            return 128 + i1;
        }
        byte j1 = atanTable[((l << 7) + (k >> 1)) / k];
        if (j > 0) {
            if (i > 0) {
                return 64 - j1;
            }
            return 192 + j1;
        }
        if (i > 0) {
            return 64 + j1;
        }
        return 192 - j1;
    }

    public static int sqrt(int i) {
        int FIX_PREC = 1;
        int FIX_BITS = 32;
        if (i < 0) {
            return -1;
        }
        if (i == 0) {
            return 0;
        }
        int k = 0;
        for (int l = i <= 1 << FIX_PREC ? 1 << FIX_PREC : 1 << (FIX_BITS - 2 + FIX_PREC >> 1); l != 0; l >>= 1) {
            int j = (k + l) * (k + l);
            if (j <= i) {
                k += l;
            }
            if (j != i) continue;
            return k;
        }
        return k;
    }

    public static int length(int vx, int vy) {
        return Utils.sqrt(vx * vx + vy * vy);
    }

    public static int distance(int x1, int y1, int x2, int y2) {
        int dx = x1 - x2;
        int dy = y1 - y2;
        return Utils.sqrt(dx * dx + dy * dy);
    }

    public static int distanceSquared(int x1, int y1, int x2, int y2) {
        int dx = x1 - x2;
        int dy = y1 - y2;
        return dx * dx + dy * dy;
    }

    public static int lerpColor(int[] values, int u) {
        int spans = values.length - 1;
        int t = u * spans;
        int left = Math.min(spans, t / 256);
        int right = Math.min(spans, left + 1);
        int c1 = values[left];
        int c2 = values[right];
        int alpha = t - 256 * left;
        int b = Utils.lerp(c1 & 0xFF, c2 & 0xFF, alpha);
        int g = Utils.lerp(c1 >> 8 & 0xFF, c2 >> 8 & 0xFF, alpha);
        int r = Utils.lerp(c1 >> 16 & 0xFF, c2 >> 16 & 0xFF, alpha);
        return b | g << 8 | r << 16;
    }

    private static int next(int bits) {
        seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL;
        return (int)(seed >>> 48 - bits);
    }

    public static int randomBits(int bits) {
        return Utils.next(bits);
    }

    public static int randomInterval(int minValue, int maxValue) {
        int range = maxValue - minValue;
        int value = Utils.next(31) % (range + 1);
        return minValue + value;
    }

    public static int randomDeviation(int meanValue, int randomPercent) {
        int deviation = Math.abs(meanValue * randomPercent / 100);
        return Utils.randomInterval(meanValue - deviation, meanValue + deviation);
    }

    public static int randomSign() {
        int value = Utils.next(1) & 1;
        return 2 * value - 1;
    }

    public static boolean passProbability(int probability) {
        return Utils.randomInterval(0, 100) <= probability;
    }

    public static int bitCount(int x) {
        x = (x >> 1 & 0x55555555) + (x & 0x55555555);
        x = (x >> 2 & 0x33333333) + (x & 0x33333333);
        x = (x >> 4 & 0xF0F0F0F) + (x & 0xF0F0F0F);
        x = (x >> 8 & 0xFF00FF) + (x & 0xFF00FF);
        return (x >> 16 & 0xFFFF) + (x & 0xFFFF);
    }

    public static int highestOneBit(int value) {
        value |= value >>> 1;
        value |= value >>> 2;
        value |= value >>> 4;
        value |= value >>> 8;
        value |= value >>> 16;
        return value ^ value >>> 1;
    }

    public static int lowestOneBit(int value) {
        return value & -value;
    }

    public static int numberOfLeadingZeros(int value) {
        value |= value >>> 1;
        value |= value >>> 2;
        value |= value >>> 4;
        value |= value >>> 8;
        value |= value >>> 16;
        return Utils.bitCount(~value);
    }

    public static int numberOfTrailingZeros(int value) {
        return Utils.bitCount((value & -value) - 1);
    }

    public static boolean getFlag(int flags, int flag) {
        return (flags & 1 << flag) != 0;
    }

    public static int setFlag(int flags, int flag, boolean value) {
        int one = value ? 1 : 0;
        return flags & ~(1 << flag) | one << flag;
    }

    public static int itoa(int num, int radix, char[] dstBuffer, int dstOffset) {
        int i = Utils.itoa_backward(num, radix, charBuffer, charBuffer.length);
        int len = charBuffer.length - i;
        Platform.arraycopy(charBuffer, i, dstBuffer, dstOffset, len);
        return len;
    }

    public static String itoa(int num, int radix) {
        int i = Utils.itoa_backward(num, radix, charBuffer, charBuffer.length);
        int len = charBuffer.length - i;
        return new String(charBuffer, i, len);
    }

    public static int itoa_backward(int num, int radix, char[] dstBuffer, int dstLimit) {
        if (radix < 1 || radix > 32) {
            radix = 10;
        }
        int i = dstLimit;
        boolean isNeg = false;
        if (num < 0) {
            isNeg = true;
            if ((num = -num) < 0) {
                dstBuffer[--i] = digits[-(num + radix) % radix];
                num = -(num / radix);
            }
        }
        do {
            dstBuffer[--i] = digits[num % radix];
        } while ((num /= radix) > 0);
        if (isNeg) {
            dstBuffer[--i] = 45;
        }
        return i;
    }

    public static String formatTime(int sec, boolean hours) {
        int m = sec / 60 % 60;
        int s = sec % 60;
        int offset = 0;
        if (hours) {
            int h = sec / 3600 % 24;
            Utils.timeString[offset++] = (char)(48 + h / 10);
            Utils.timeString[offset++] = (char)(48 + h % 10);
            Utils.timeString[offset++] = 58;
        }
        Utils.timeString[offset++] = (char)(48 + m / 10);
        Utils.timeString[offset++] = (char)(48 + m % 10);
        Utils.timeString[offset++] = 58;
        Utils.timeString[offset++] = (char)(48 + s / 10);
        Utils.timeString[offset++] = (char)(48 + s % 10);
        return new String(timeString, 0, offset);
    }

    public static String formatDecimal(int value) {
        int len = Utils.itoa(value, 10, charBuffer, 0);
        if (len == 1) {
            Utils.charBuffer[2] = charBuffer[0];
            Utils.charBuffer[1] = 46;
            Utils.charBuffer[0] = 48;
            len = 2;
        } else {
            Utils.charBuffer[len] = charBuffer[len - 1];
            Utils.charBuffer[len - 1] = 46;
        }
        return new String(charBuffer, 0, len + 1);
    }

    public static String formatPercent(int value) {
        int len = Utils.itoa(value, 10, charBuffer, 0);
        return new String(charBuffer, 0, len);
    }

    public static void readImages(PlatformResource din, PlatformImage[] imageCache, byte[] imageColorVariantsCnt, int imageCount) {
        int i = 0;
        while (i < imageCount) {
            Utils.readDiffImage(din, imageCache, imageColorVariantsCnt, i, -1);
            int colorNumber = imageColorVariantsCnt[i];
            i += Math.max(1, colorNumber);
            while (colorNumber > 1) {
                Utils.readDiffImage(din, imageCache, imageColorVariantsCnt, 0, -1);
                --colorNumber;
            }
        }
    }

    public static void readDiffImage(PlatformResource dis, PlatformImage[] imgCache, byte[] imgColorVariantsCnt, int startCacheIndex, int diffVariant) {
        boolean sprite = true;
        int loadMask = 0;
        PlatformImage im = null;
        Platform.assertFalse(startCacheIndex < 0);
        byte imgType = dis.readByte();
        short pngSize = dis.readShort();
        boolean onlyOneImage = false;
        if ((imgType & 2) == 0) {
            onlyOneImage = true;
            diffVariant = 0;
        }
        if (pngSize == 0) {
            return;
        }
        byte[] buff = new byte[pngSize];
        dis.readFully(buff);
        int variantsNum = 1;
        if (!onlyOneImage) {
            variantsNum = dis.readShort();
        }
        if (diffVariant < 0) {
            Platform.assertFalse(startCacheIndex < 0);
            int cacheIndex = startCacheIndex;
            byte[] tempBuff = new byte[pngSize];
            for (int i = 0; i < variantsNum; ++i) {
                loadMask = (short)(loadMask | 1 << 8 + i);
                Platform.arraycopy(buff, 0, tempBuff, 0, buff.length);
                if (i > 0) {
                    int noDiffs = dis.readUnsignedByte();
                    if (noDiffs == 0) {
                        noDiffs = dis.readShort();
                    }
                    for (int j = 0; j < noDiffs; ++j) {
                        short offset = dis.readShort();
                        tempBuff[offset] = dis.readByte();
                    }
                }
                if (imgCache[cacheIndex] == null) {
                    imgCache[cacheIndex] = im = Platform.createImage(0, tempBuff, 0, tempBuff.length);
                }
                ++cacheIndex;
            }
        } else {
            int palNum;
            int i = 0;
            if (diffVariant > 0) {
                while (++i < diffVariant) {
                    palNum = dis.readUnsignedByte();
                    if (palNum == 0) {
                        palNum = dis.readShort();
                    }
                    dis.skipBytes(palNum * 3);
                }
                palNum = dis.readUnsignedByte();
                if (palNum == 0) {
                    palNum = dis.readShort();
                }
                for (int j = 0; j < palNum; ++j) {
                    short offset = dis.readShort();
                    buff[offset] = dis.readByte();
                }
            }
            loadMask = (short)(loadMask | 1 << 8 + diffVariant);
            if (sprite && imgCache[startCacheIndex + diffVariant] == null || !sprite && imgCache[startCacheIndex] == null) {
                im = Platform.createImage(0, buff, 0, buff.length);
                if (sprite) {
                    imgCache[startCacheIndex + diffVariant] = im;
                } else {
                    imgCache[startCacheIndex] = im;
                }
            }
            while (++i < variantsNum) {
                palNum = dis.readUnsignedByte();
                if (palNum == 0) {
                    palNum = dis.readShort();
                }
                dis.skipBytes(palNum * 3);
            }
        }
        imgColorVariantsCnt[startCacheIndex] = (byte)variantsNum;
        int n = startCacheIndex;
        imgColorVariantsCnt[n] = (byte)(imgColorVariantsCnt[n] | loadMask);
        if ((imgType & 4) != 0) {
            int n2 = startCacheIndex;
            imgColorVariantsCnt[n2] = (byte)(imgColorVariantsCnt[n2] | 0x80);
        }
    }

    public static int skipDiffImage(PlatformResource dis, int diffVariant) {
        int imgColorVariantsCnt = 0;
        int loadMask = 0;
        byte imgType = dis.readByte();
        short pngSize = dis.readShort();
        boolean onlyOneImage = false;
        if ((imgType & 2) == 0) {
            onlyOneImage = true;
            diffVariant = 0;
        }
        if (pngSize == 0) {
            return imgColorVariantsCnt;
        }
        dis.skipBytes(pngSize);
        int variantsNum = 1;
        if (!onlyOneImage) {
            variantsNum = dis.readShort();
        }
        if (diffVariant < 0) {
            byte[] tempBuff = new byte[pngSize];
            for (int i = 0; i < variantsNum; ++i) {
                loadMask = (short)(loadMask | 1 << 8 + i);
                if (i <= 0) continue;
                int noDiffs = dis.readUnsignedByte();
                if (noDiffs == 0) {
                    noDiffs = dis.readShort();
                }
                for (int j = 0; j < noDiffs; ++j) {
                    short offset = dis.readShort();
                    tempBuff[offset] = dis.readByte();
                }
            }
        } else {
            int palNum;
            int i = 0;
            if (diffVariant > 0) {
                while (++i < diffVariant) {
                    palNum = dis.readUnsignedByte();
                    if (palNum == 0) {
                        palNum = dis.readShort();
                    }
                    dis.skipBytes(palNum * 3);
                }
                palNum = dis.readUnsignedByte();
                if (palNum == 0) {
                    palNum = dis.readShort();
                }
                for (int j = 0; j < palNum; ++j) {
                    dis.readShort();
                    dis.readByte();
                }
            }
            loadMask = (short)(loadMask | 1 << 8 + diffVariant);
            while (++i < variantsNum) {
                palNum = dis.readUnsignedByte();
                if (palNum == 0) {
                    palNum = dis.readShort();
                }
                dis.skipBytes(palNum * 3);
            }
        }
        imgColorVariantsCnt = (byte)variantsNum;
        imgColorVariantsCnt |= loadMask;
        if ((imgType & 4) != 0) {
            imgColorVariantsCnt |= 0x80;
        }
        return imgColorVariantsCnt;
    }

    public static int randomWeight(byte[] weights, int weightsLength, int weightsSum, int defaultValue) {
        if (weightsSum <= 0) {
            return defaultValue;
        }
        int sum = 0;
        int dice = Utils.randomInterval(0, weightsSum - 1);
        for (int i = 0; i < weightsLength - 1; ++i) {
            if (dice >= (sum += weights[i])) continue;
            return i;
        }
        return weightsLength - 1;
    }

    public static int findSpan(int[] values, int u, int span) {
        int endKnot = values.length - 1;
        if (u >= values[endKnot]) {
            return endKnot - 1;
        }
        if (u <= values[0]) {
            return 0;
        }
        int low = 0;
        int high = endKnot;
        while (true) {
            if (u < values[span]) {
                high = span;
            } else if (u >= values[span + 1]) {
                low = span;
            } else {
                return span;
            }
            span = (low + high) / 2;
        }
    }

    public static int findSpanSequential(short[] values, int u, int span) {
        int endKnot = values.length - 1;
        if (u >= values[endKnot]) {
            return endKnot - 1;
        }
        if (u <= values[0]) {
            return 0;
        }
        if (u > values[span]) {
            while (u > values[span + 1]) {
                ++span;
            }
        } else {
            while (u < values[span]) {
                --span;
            }
        }
        return span;
    }

    public static int computeAlpha(int[] values, int span, int u) {
        int u0 = values[span + 0];
        int u1 = values[span + 1];
        int n = u - u0;
        int d = u1 - u0;
        return 256 * n / d;
    }

    public static int computeAlpha(short[] values, int span, int u) {
        short u0 = values[span + 0];
        short u1 = values[span + 1];
        int n = u - u0;
        int d = u1 - u0;
        return 256 * n / d;
    }

    public static Object[] add(Object[] elements, int count, Object element) {
        if (count == elements.length) {
            Object[] newElements = new Object[2 * count + 4];
            Platform.arraycopy(elements, 0, newElements, 0, count);
            elements = newElements;
        }
        elements[count++] = element;
        return elements;
    }

    public static Object[] remove(Object[] elements, int count, Object element) {
        for (int i = 0; i < count; ++i) {
            if (element != elements[i]) continue;
            Utils.remove(elements, count, i);
            return elements;
        }
        return elements;
    }

    public static void remove(Object[] elements, int count, int i) {
        if (i != --count) {
            Platform.arraycopy(elements, i + 1, elements, i, count - i);
        }
        elements[count] = null;
    }

    public static int readUnsignedByte(byte[] buffer, int pos) {
        return buffer[pos] & 0xFF;
    }

    public static short readShort(byte[] buffer, int pos) {
        Platform.assertFalse(pos + 2 > buffer.length);
        int ret = (buffer[pos++] & 0xFF) << 8;
        return (short)(ret |= (buffer[pos++] & 0xFF) << 0);
    }

    public static int readUnsignedShort(byte[] buffer, int pos) {
        return Utils.readShort(buffer, pos) & 0xFFFF;
    }

    public static int readInt(byte[] buffer, int pos) {
        Platform.assertFalse(pos + 4 > buffer.length);
        int ret = (buffer[pos++] & 0xFF) << 24;
        ret |= (buffer[pos++] & 0xFF) << 16;
        ret |= (buffer[pos++] & 0xFF) << 8;
        return ret |= (buffer[pos++] & 0xFF) << 0;
    }

    public static byte[] readByteArray(byte[] buffer, int pos) {
        int arrayLength = Utils.readUnsignedShort(buffer, pos);
        byte[] array = new byte[arrayLength];
        Platform.arraycopy(buffer, pos += 2, array, 0, arrayLength);
        return array;
    }

    public static short[] readShortArray(byte[] buffer, int pos) {
        int arrayLength = Utils.readUnsignedShort(buffer, pos);
        pos += 2;
        short[] array = new short[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            array[i] = Utils.readShort(buffer, pos);
            pos += 2;
        }
        return array;
    }

    public static int[] readIntArray(byte[] buffer, int pos) {
        int arrayLength = Utils.readUnsignedShort(buffer, pos);
        pos += 2;
        int[] array = new int[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            array[i] = Utils.readInt(buffer, pos);
            pos += 4;
        }
        return array;
    }

    public static byte[] readByteArray(PlatformResource din) {
        short arrayLength = din.readShort();
        byte[] array = new byte[arrayLength];
        if (arrayLength > 0) {
            din.readFully(array);
        }
        return array;
    }

    public static short[] readShortArray(PlatformResource din) {
        int arrayLength = din.readShort();
        short[] array = new short[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            array[i] = din.readShort();
        }
        return array;
    }

    public static int[] readIntArray(PlatformResource din) {
        int arrayLength = din.readShort();
        int[] array = new int[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            array[i] = din.readInt();
        }
        return array;
    }

    public static int readInt24(PlatformResource din) {
        int v0 = din.readByte() & 0xFF;
        int v1 = din.readByte() & 0xFF;
        int v2 = din.readByte() & 0xFF;
        return v0 << 16 | v1 << 8 | v2 << 0;
    }

    public static String[] readStrings(PlatformResource din) {
        int count = din.readShort();
        String[] array = new String[count];
        for (int i = 0; i < count; ++i) {
            array[i] = din.readUTF();
        }
        return array;
    }

    public static void writeShort(byte[] buffer, int pos, int v) {
        Platform.assertFalse(pos + 2 > buffer.length);
        buffer[pos++] = (byte)(v >>> 8 & 0xFF);
        buffer[pos++] = (byte)(v >>> 0 & 0xFF);
    }

    public static void writeInt(byte[] buffer, int pos, int v) {
        Platform.assertFalse(pos + 4 > buffer.length);
        buffer[pos++] = (byte)(v >>> 24 & 0xFF);
        buffer[pos++] = (byte)(v >>> 16 & 0xFF);
        buffer[pos++] = (byte)(v >>> 8 & 0xFF);
        buffer[pos++] = (byte)(v >>> 0 & 0xFF);
    }

    public static void drawBox(int x, int y, int width, int height, int margin, int fillColor, int borderColor) {
        PlatformGraphics g = Platform.getDisplayGraphics();
        g.setColor(fillColor);
        g.fillRect(x -= margin, y -= margin, width += 2 * margin, height += 2 * margin);
        g.setColor(borderColor);
        g.drawRect(x, y, width - 1, height - 1);
    }

    public static void drawRoundRect(int x, int y, int w, int h) {
        PlatformGraphics g = Platform.getDisplayGraphics();
        g.drawLine(x + 1, y, x + w - 2, y);
        g.drawLine(x + 1, y + h - 1, x + w - 2, y + h - 1);
        g.drawLine(x, y + 1, x, y + h - 2);
        g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 2);
    }

    public static void drawRegion(PlatformImage image, int sx, int sy, int sw, int sh, int x, int y, int anchor) {
        PlatformGraphics g = Platform.getDisplayGraphics();
        if ((anchor & 8) != 0) {
            x -= sw;
        } else if ((anchor & 1) != 0) {
            x -= sw / 2;
        }
        if ((anchor & 0x20) != 0) {
            y -= sh;
        } else if ((anchor & 2) != 0) {
            y -= sh / 2;
        }
        g.setClip(x, y, sw, sh);
        g.drawImage(image, x - sx, y - sy, 20);
    }

    public static void drawPattern(int viewX, int viewY, int viewWidth, int viewHeight, PlatformImage patternImage) {
        Utils.drawPattern(viewX, viewY, viewX, viewY, viewWidth, viewHeight, patternImage, 0, 0, patternImage.getWidth(), patternImage.getHeight());
    }

    public static void drawPattern(int viewX, int viewY, int viewWidth, int viewHeight, PlatformImage patternImage, int patternX, int patternY, int patternWidth, int patternHeight) {
        Utils.drawPattern(viewX, viewY, viewX, viewY, viewWidth, viewHeight, patternImage, patternX, patternY, patternWidth, patternHeight);
    }

    public static void drawPattern(int startX, int startY, int viewX, int viewY, int viewWidth, int viewHeight, PlatformImage patternImage, int patternX, int patternY, int patternWidth, int patternHeight) {
        PlatformGraphics g = Platform.getDisplayGraphics();
        g.setClip(viewX, viewY, viewWidth, viewHeight);
        int lastX = viewX + viewWidth;
        int lastY = viewY + viewHeight;
        for (int y = startY; y < lastY; y += patternHeight) {
            int height = Math.min(patternHeight, lastY - y);
            for (int x = startX; x < lastX; x += patternWidth) {
                int width = Math.min(patternWidth, lastX - x);
                Utils.drawRegion(patternImage, patternX, patternY, width, patternHeight, x, y, 0);
            }
        }
    }

    public static void drawAttributeBar(int x, int y, int width, int height, int bgColor, int fgColor, int value, int maxValue) {
        PlatformGraphics g = Platform.getDisplayGraphics();
        int w = Math.min(width, value * width / maxValue);
        g.setColor(bgColor);
        g.fillRect(x - 1, y - 1, width + 2, height + 2);
        g.setColor(fgColor);
        g.fillRect(x, y, w, height);
    }

    public static void drawHBar(int x, int y, int width, int height, PlatformImage bgPattern, PlatformImage fgPattern, int value, int maxValue) {
        int activeWidth = Math.min(width, value * width / maxValue);
        Utils.drawPattern(x, y, width, height, bgPattern);
        Utils.drawPattern(x, y, activeWidth, height, fgPattern);
    }

    public static void drawVBar(int x, int y, int width, int height, PlatformImage bgPattern, PlatformImage fgPattern, int value, int maxValue) {
        int activeHeight = Math.min(height, value * height / maxValue);
        Utils.drawVPattern(x, y, width, height, bgPattern);
        Utils.drawVPattern(x, y + height - activeHeight, width, activeHeight, fgPattern);
    }

    private static void drawVPattern(int viewX, int viewY, int viewWidth, int viewHeight, PlatformImage patternImage) {
        PlatformGraphics g = Platform.getDisplayGraphics();
        int patternHeight = patternImage.getHeight();
        int x = viewX;
        int y = viewY + viewHeight;
        g.setClip(viewX, viewY, viewWidth, viewHeight);
        while (y >= viewY) {
            g.drawImage(patternImage, x, y -= patternHeight, 20);
        }
    }

    public static void drawProgressBarColor(int x, int y, int width, int height, int fraction) {
        PlatformGraphics g = Platform.getDisplayGraphics();
        int color = Utils.lerpColor(progressFrontColors, fraction);
        g.setColor(color);
        int w = width * fraction / 256;
        g.fillRect(x, y, w, height);
        color = Utils.lerpColor(progressBackColors, fraction);
        g.setColor(color);
        g.drawRect(x - 1, y - 1, width + 1, height + 1);
    }

    public static int drawSymbols(PlatformImage symbolsImage, String symbolsChars, char[] text, int length, int x, int y, int anchor) {
        int symbolsCount = symbolsChars.length();
        int sw = symbolsImage.getWidth() / symbolsCount;
        int sh = symbolsImage.getHeight();
        int width = length * sw;
        switch (anchor) {
            case 4: {
                break;
            }
            case 8: {
                x -= width;
                break;
            }
            case 1: {
                x -= width / 2;
            }
        }
        for (int i = 0; i < length; ++i) {
            int n = symbolsChars.indexOf(text[i]);
            Utils.drawRegion(symbolsImage, n * sw, 0, sw, sh, x, y, 0);
            x += sw;
        }
        return x;
    }

    public static int drawSymbols(PlatformImage symbolsImage, int[] coords, int baseChar, char[] text, int length, int x, int y, int anchor, int space) {
        int sh = symbolsImage.getHeight();
        if ((anchor & 8) != 0) {
            x -= Utils.getSymbolsWidth(coords, baseChar, text, length, space);
        } else if ((anchor & 1) != 0) {
            x -= Utils.getSymbolsWidth(coords, baseChar, text, length, space) / 2;
        }
        if ((anchor & 0x20) != 0) {
            y -= sh;
        } else if ((anchor & 2) != 0) {
            y -= sh / 2;
        }
        for (int i = 0; i < length; ++i) {
            int n = text[i] - baseChar;
            int sw = coords[n + 1] - coords[n];
            Utils.drawRegion(symbolsImage, coords[n], 0, sw, sh, x, y, 0);
            x += sw + space;
        }
        return x;
    }

    public static int drawSymbol(PlatformImage symbolsImage, int[] coords, int n, int x, int y, int anchor) {
        int sw = coords[n + 1] - coords[n];
        return Utils.drawSymbol(symbolsImage, coords[n], sw, x, y, anchor);
    }

    public static int drawSymbol(PlatformImage symbolsImage, int sx, int sw, int x, int y, int anchor) {
        int sh = symbolsImage.getHeight();
        if ((anchor & 8) != 0) {
            x -= sw;
        } else if ((anchor & 1) != 0) {
            x -= sw / 2;
        }
        if ((anchor & 0x20) != 0) {
            y -= sh;
        } else if ((anchor & 2) != 0) {
            y -= sh / 2;
        }
        Utils.drawRegion(symbolsImage, sx, 0, sw, sh, x, y, 0);
        return x += sw;
    }

    public static int getSymbolsWidth(int[] coords, int baseChar, char[] text, int length, int space) {
        int width = 0;
        for (int i = 0; i < length; ++i) {
            int n = text[i] - baseChar;
            width += coords[n + 1] - coords[n] + space;
        }
        return width - space;
    }

    public static int[] generateSymbolsCoords(PlatformImage image, int digitWidth) {
        int imageWidth = image.getWidth();
        int specialWidth = imageWidth - 10 * digitWidth;
        int[] coords = new int[12];
        int x = 0;
        for (int i = 0; i < 10; ++i) {
            coords[i] = x;
            x += digitWidth;
        }
        coords[10] = x;
        coords[11] = x + specialWidth;
        return coords;
    }

    public static int getImageFormat(byte[] buffer, int offset, int length) {
        int v1 = Utils.readInt(buffer, 0);
        int v2 = Utils.readInt(buffer, 4);
        Platform.assertFalse(v1 != -1991225785 || v2 != 218765834);
        int chunkLength = Utils.readInt(buffer, offset += 8);
        int chunkType = Utils.readInt(buffer, offset += 4);
        Platform.assertFalse(chunkType != 1229472850);
        byte colorType = buffer[(offset += 4) + 9];
        offset += chunkLength + 4;
        switch (colorType) {
            case 2: {
                return 0;
            }
            case 6: {
                return 1;
            }
            case 3: {
                while (offset < length) {
                    chunkLength = Utils.readInt(buffer, offset);
                    chunkType = Utils.readInt(buffer, offset += 4);
                    offset += 4;
                    if (chunkType == 1951551059) {
                        return 1;
                    }
                    offset += chunkLength + 4;
                }
                return 0;
            }
            case 0: {
                return 0;
            }
            case 4: {
                return 1;
            }
        }
        return -1;
    }

    public static void drawTileImage(PlatformImage img, int x, int y, int m, int n, int i, int j) {
        PlatformGraphics g = Platform.getDisplayGraphics();
        int sx = img.getWidth() / m;
        int sy = img.getHeight() / n;
        g.setClip(x, y, sx, sy);
        g.drawImage(img, x - i * sx, y - j * sy, 20);
    }

    public static int drawNums(PlatformImage image, int num, int noDigits, int x, int y, int pad, boolean useZero) {
        PlatformGraphics g = Platform.getDisplayGraphics();
        int w = image.getWidth() / 11;
        int h = image.getHeight();
        x -= w;
        for (int index = 0; index < noDigits; ++index) {
            int i = 10;
            if (num > 0) {
                i = num % 10;
            } else if (num == 0 && (useZero || index == 0)) {
                i = 0;
            }
            g.setClip(x, y, w, h);
            g.drawImage(image, x - i * w, y, 20);
            x -= w + (index + 1 > 0 && (index + 1) % 3 == 0 ? 3 * pad : pad);
            num /= 10;
        }
        return x + w;
    }

    public static int drawNums10(PlatformImage image, int num, int noDigits, int x, int y, int pad, boolean useZero) {
        int w = image.getWidth() / 10;
        x -= w;
        for (int index = 0; index < noDigits; ++index) {
            int i = 10;
            if (num > 0) {
                i = num % 10;
            } else if (num == 0 && (useZero || index == 0)) {
                i = 0;
            }
            Utils.drawTileImage(image, x, y, 10, 1, i, 0);
            x -= w + pad;
            num /= 10;
        }
        return x + w;
    }

    public static boolean compareArray(char[] left, int leftOffset, char[] right, int rightOffset, int count) {
        for (int i = 0; i < count; ++i) {
            if (left[leftOffset + i] == right[rightOffset + i]) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(int ch, int[] array, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            if (array[offset + i] != ch) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(int ch, char[] array, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            if (array[offset + i] != ch) continue;
            return i;
        }
        return -1;
    }

    public static boolean containsAll(char[] left, char[] right, int count) {
        for (int i = 0; i < count; ++i) {
            char ch = left[i];
            if (Utils.indexOf((int)ch, right, 0, count) != -1) continue;
            return false;
        }
        return true;
    }

    public static void sort(int[] index, int[] keys, int count) {
        for (int i = 0; i < count; ++i) {
            int value = keys[index[i]];
            for (int j = i; j >= 1 && keys[index[j - 1]] >= value; --j) {
                int tmp = index[j];
                index[j] = index[j - 1];
                index[j - 1] = tmp;
            }
        }
    }

    public static void reverse(int[] array, int size) {
        int i = 0;
        int mid = size >> 1;
        int j = size - 1;
        while (i < mid) {
            int tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
            ++i;
            --j;
        }
    }

    public static boolean isInside(int px, int py, int x, int y, int w, int h) {
        return px >= x && px < x + w && py >= y && py < y + h;
    }

    public static boolean intersectsBoxBox(int minX1, int minY1, int maxX1, int maxY1, int minX2, int minY2, int maxX2, int maxY2) {
        return maxX1 >= minX2 && minX1 <= maxX2 && maxY1 >= minY2 && minY1 <= maxY2;
    }

    public static boolean intersectsRectRect(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        int minX1 = x1;
        int maxX1 = x1 + w1 - 1;
        int minY1 = y1;
        int maxY1 = y1 + h1 - 1;
        int minX2 = x2;
        int maxX2 = x2 + w2 - 1;
        int minY2 = y2;
        int maxY2 = y2 + h2 - 1;
        return maxX1 >= minX2 && minX1 <= maxX2 && maxY1 >= minY2 && minY1 <= maxY2;
    }

    public static int distanceX(int size, int x, int ref) {
        int backward;
        int forward = x - ref;
        if (forward < 0) {
            forward += size;
        }
        if ((backward = x - ref) > 0) {
            backward -= size;
        }
        return forward <= -backward ? forward : backward;
    }

    public static int getRandomInt() {
        return r.nextInt();
    }

    public static void p(String a) {
        System.out.println(a);
    }
}

