/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class PlatformGraphics {
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    Graphics g;
    private PlatformImage image;
    public static final int TRANS_FLIP_X = 2;
    public static final int TRANS_FLIP_Y = 1;

    protected PlatformGraphics() {
    }

    protected PlatformGraphics(Graphics g) {
        this.g = g;
    }

    protected PlatformGraphics(PlatformImage image) {
        this.image = image;
        this.g = image.image.getGraphics();
    }

    public PlatformImage getImage() {
        return this.image;
    }

    public int getClipX() {
        return this.g.getClipX();
    }

    public int getClipY() {
        return this.g.getClipY();
    }

    public int getClipWidth() {
        return this.g.getClipWidth();
    }

    public int getClipHeight() {
        return this.g.getClipHeight();
    }

    public int getTranslateX() {
        return this.g.getTranslateX();
    }

    public int getTranslateY() {
        return this.g.getTranslateY();
    }

    public void drawImage(PlatformImage img, int x, int y, int anchor) {
        this.g.drawImage(img.image, x, y, anchor);
    }

    public void drawRegion(PlatformImage src, int clip_x, int clip_y, int clip_w, int clip_h, int trans, int draw_x, int draw_y, int acr) {
        int ori_clip_x = this.g.getClipX();
        int ori_clip_y = this.g.getClipY();
        int ori_clip_w = this.g.getClipWidth();
        int ori_clip_h = this.g.getClipHeight();
        if ((trans = this.remapTransform(trans)) == 0) {
            if ((acr & 1) != 0) {
                draw_x -= clip_w / 2;
            } else if ((acr & 8) != 0) {
                draw_x -= clip_w;
            }
            if ((acr & 2) != 0) {
                draw_y -= clip_h / 2;
            } else if ((acr & 0x20) != 0) {
                draw_y -= clip_h;
            }
            this.g.setClip(draw_x, draw_y, clip_w, clip_h);
            this.g.drawImage(src.image, draw_x - clip_x, draw_y - clip_y, 20);
            this.g.setClip(ori_clip_x, ori_clip_y, ori_clip_w, ori_clip_h);
            return;
        }
        this.g.drawRegion(src.image, clip_x, clip_y, clip_w, clip_h, trans, draw_x, draw_y, acr);
    }

    private final int remapTransform(int ori) {
        switch (ori) {
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    public void drawRGB(int[] rgb, int offset, int scanlength, int x, int y, int width, int height, boolean processAlpha) {
        this.g.drawRGB(rgb, offset, scanlength, x, y, width, height, processAlpha);
    }

    public void setColor(int RGB) {
        this.g.setColor(RGB);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.g.drawArc(x, y, width, height, startAngle, arcAngle);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.g.drawLine(x1, y1, x2, y2);
    }

    public void drawRect(int x, int y, int width, int height) {
        this.g.drawRect(x, y, width, height);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.g.fillRect(x, y, width, height);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.g.fillArc(x, y, width, height, startAngle, arcAngle);
    }

    public void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.g.fillTriangle(x1, y1, x2, y2, x3, y3);
    }

    public void setClip(int x, int y, int width, int height) {
        this.g.setClip(x, y, width, height);
    }

    public void translate(int x, int y) {
        this.g.translate(x, y);
    }

    public void drawString(int font, String text, int x, int y, int anchor) {
        this.g.setFont(Platform.systemFonts[font]);
        this.g.drawString(text, x, y, anchor);
    }

    public void drawChars(int font, char[] data, int offset, int length, int x, int y, int anchor) {
        this.g.setFont(Platform.systemFonts[font]);
        this.g.drawChars(data, offset, length, x, y, anchor);
    }
}

