/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.rim.device.api.system.Application;
import net.rim.device.api.system.GlobalEventListener;
import net.rim.device.api.system.KeyListener;

class PlatformCanvas
extends Canvas
implements Runnable,
GlobalEventListener,
KeyListener {
    public static PlatformCanvas instance = null;
    private static final int STATE_RUN = 0;
    private static final int STATE_QUIT = 1;
    public static final int RESUME_SOUND_DELAY = 1500;
    private static int state;
    private static Thread thread;
    public static int canvasWidth;
    public static int canvasHeight;
    private boolean isShown;
    private volatile boolean showNotifySeen;
    private volatile boolean hideNotifySeen;
    static boolean repaintRequest;
    public static Main application;
    public int lastKeyCode = -1000;
    public int gameRunKeyReleayTime = 0;
    public static final int RUNKEYRELEATIMELIMIT = 5;
    public boolean isKeyRelease = false;
    private static final int device_keyCenterSoft = -8;
    private static final int device_keyUpArrow = 1;
    private static final int device_keyDownArrow = 6;
    private static final int device_keyLeftArrow = 2;
    private static final int device_keyRightArrow = 5;
    private static final int device_keyClear = 8;
    private static final int[] remapKeys;
    Image offscreenImage;
    Graphics offscreenGraphics;
    private static volatile boolean paintRequest;
    private static final long GUID_EVENT_CALL_POPUP = 5961289116197897667L;
    public boolean menuKey = false;
    public boolean backPressed = false;
    public boolean blackberryCode = false;
    public boolean sleep = false;
    public int timedelayLock = 0;
    boolean runReleaseBackKey = false;

    public PlatformCanvas() {
        instance = this;
        Application.getApplication().addGlobalEventListener((GlobalEventListener)this);
        Application.getApplication().addKeyListener((KeyListener)this);
    }

    public void start() {
        state = 0;
        thread = new Thread(this);
        thread.start();
    }

    public void exit() {
        state = 1;
        PlatformSound.stopAllSounds();
    }

    public void showNotify() {
        this.isShown = true;
        this.showNotifySeen = true;
        Platform.debuglog("showNotify");
    }

    public void hideNotify() {
        this.isShown = false;
        this.hideNotifySeen = true;
        this.showNotifySeen = false;
        Platform.debuglog("hideNotify");
        PlatformSound.stopAllSounds();
    }

    public void run() {
        try {
            this.runSafe();
        }
        catch (Exception e) {
            Platform.debuglog("run", e);
        }
        Platform.debuglog("exit");
        PlatformMIDlet.instance.notifyDestroyed();
    }

    private void runSafe() {
        if (PlatformMIDlet.display.getCurrent() != this) {
            PlatformMIDlet.display.setCurrent((Displayable)this);
        }
        canvasWidth = this.getWidth();
        canvasHeight = this.getHeight();
        Platform.init();
        application = new Main();
        application.start();
        while (state != 1) {
            this.checkPause();
            application.update();
            if (repaintRequest) {
                repaintRequest = false;
                PlatformCanvas.redraw();
            }
            if (this.sleep) {
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.lastKeyCode != -1000 && this.isKeyRelease) {
                ++this.gameRunKeyReleayTime;
                if (this.gameRunKeyReleayTime == 5) {
                    this.runKeyReleased(this.lastKeyCode);
                    this.gameRunKeyReleayTime = 0;
                }
            }
            if (!this.runReleaseBackKey) continue;
            if (this.timedelayLock == 5) {
                this.timedelayLock = 0;
                this.runReleaseBackKey = false;
                continue;
            }
            ++this.timedelayLock;
        }
        application.destroy();
    }

    private void checkPause() {
        if (this.hideNotifySeen) {
            Platform.debuglog("checkPause: hideNotifySeen");
            application.pause();
            this.hideNotifySeen = false;
            application.resume();
        }
    }

    public void keyPressed(int keyCode) {
        this.isKeyRelease = false;
        this.lastKeyCode = keyCode;
        int keySymbol = PlatformCanvas.mapKeySymbol(keyCode);
        if (application != null) {
            application.keyPressed(keySymbol);
        }
    }

    public void keyReleased(int keyCode) {
        if (keyCode == -8 || keyCode == 1 || keyCode == 6 || keyCode == 2 || keyCode == 5) {
            this.isKeyRelease = true;
        } else {
            this.runKeyReleased(keyCode);
        }
    }

    public void runKeyReleased(int keyCode) {
        int keySymbol = PlatformCanvas.mapKeySymbol(keyCode);
        if (application != null) {
            application.keyReleased(keySymbol);
        }
        this.lastKeyCode = -1000;
        this.isKeyRelease = false;
    }

    public static int mapKeySymbol(int keyCode) {
        for (int i = 0; i < remapKeys.length; i += 2) {
            if (keyCode != remapKeys[i]) continue;
            return remapKeys[i + 1];
        }
        switch (keyCode) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return 1 + (keyCode - 48);
            }
            case 42: {
                return 11;
            }
            case 35: {
                return 12;
            }
            case 8: {
                return 13;
            }
            case 113: {
                return 14;
            }
            case 112: {
                return 15;
            }
            case -8: {
                return 16;
            }
            case 1: {
                return 17;
            }
            case 6: {
                return 18;
            }
            case 2: {
                return 19;
            }
            case 5: {
                return 20;
            }
        }
        return -1;
    }

    public void paint(Graphics _g) {
        Platform.g = _g;
        Platform.displayGraphics.g = _g;
        if (this.offscreenImage == null) {
            this.offscreenImage = Image.createImage((int)this.getWidth(), (int)this.getHeight());
            this.offscreenGraphics = this.offscreenImage.getGraphics();
        }
        Platform.g = this.offscreenGraphics;
        Platform.displayGraphics.g = this.offscreenGraphics;
        canvasWidth = this.getWidth();
        canvasHeight = this.getHeight();
        try {
            Graphics g = Platform.g;
            if (g == null) {
                return;
            }
            g.translate(-g.getTranslateX(), -g.getTranslateY());
            application.paint();
            _g.drawImage(this.offscreenImage, 0, 0, 20);
        }
        catch (Exception e) {
            Platform.debuglog("paint", e);
        }
        paintRequest = false;
    }

    public static void redraw() {
        paintRequest = true;
        PlatformCanvas c = instance;
        c.repaint();
        c.serviceRepaints();
    }

    protected void sizeChanged(int newWidth, int newHeight) {
        if (application != null) {
            application.sizeChanged(newWidth, newHeight);
        }
    }

    public void eventOccurred(long guid, int arg1, int arg2, Object arg3, Object arg4) {
        if (guid == 5961289116197897667L && application != null) {
            if (arg1 == 1) {
                application.pause();
            } else {
                application.resume();
            }
        }
    }

    public boolean keyDown(int keycode, int time) {
        if (keycode == 0x1B0000) {
            if (!this.menuKey) {
                if (!this.backPressed && !this.runReleaseBackKey) {
                    this.lastKeyCode = -1000;
                    this.keyPressed(8);
                    this.backPressed = true;
                }
            } else {
                this.showNotify();
                this.sleep = false;
                this.menuKey = false;
            }
            this.blackberryCode = false;
        } else if (keycode == 0x10020000) {
            if (!this.menuKey) {
                this.sleep = true;
                this.hideNotify();
                this.showNotify();
                this.menuKey = true;
            } else {
                this.showNotify();
                this.menuKey = false;
                this.sleep = false;
            }
            this.blackberryCode = false;
        } else if (keycode == 0x120000) {
            this.sleep = true;
        }
        return this.blackberryCode;
    }

    public boolean keyRepeat(int keycode, int time) {
        return false;
    }

    public boolean keyStatus(int keycode, int time) {
        return false;
    }

    public boolean keyUp(int keycode, int time) {
        if (!this.menuKey && this.backPressed && keycode == 0x1B0000) {
            this.runKeyReleased(this.lastKeyCode);
            this.backPressed = false;
            this.blackberryCode = false;
            this.runReleaseBackKey = true;
        }
        return this.blackberryCode;
    }

    public boolean keyChar(char key, int status, int time) {
        return false;
    }

    static {
        repaintRequest = true;
        remapKeys = new int[]{119, 2, 101, 3, 114, 4, 115, 5, 100, 6, 102, 7, 122, 8, 120, 9, 99, 10, 103, 12, 97, 11};
    }
}

