/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public final class Fonts {
    public static int fontsCnt;
    private static PlatformImage[] imageCache;
    private static byte[] imageColorVariantsCnt;
    private static final int UPPER_START_LA = 65;
    private static final int UPPER_END_LA = 90;
    private static final int LOWER_START_LA = 97;
    private static final int LOWER_END_LA = 122;
    private static final int UPPER_START_RU = 1040;
    private static final int UPPER_END_RU = 1071;
    private static final int LOWER_START_RU = 1072;
    private static final int LOWER_END_RU = 1103;
    private static final int UPPER_START_GR = 913;
    private static final int UPPER_END_GR = 937;
    private static final int LOWER_START_GR = 945;
    private static final int LOWER_END_GR = 969;
    private static int UPPER_START;
    private static int UPPER_END;
    private static int LOWER_START;
    private static int LOWER_END;
    private static int N_UPPER;
    private static int N_LOWER;
    private static int N_BASE_LETTERS;
    private static final int SPACE = 32;
    private static final int NO_BREAK_SPACE = 160;
    private static final int FRG_OFFSET_X_INDEX = 0;
    private static final int FRG_OFFSET_Y_INDEX = 1;
    private static final int FRG_W_INDEX = 2;
    private static final int FRG_H_INDEX = 3;
    private static final int FRG_BASE_LINE_INDEX = 4;
    private static final int FRG_INFO_CNT = 5;
    private static String baseDiacritics;
    private static String baseLetters;
    private static byte[] baseDecodes;
    private static String[] fontChars;
    private static byte[] fontW;
    private static byte[] fontH;
    private static byte[] diacriticXShift;
    private static byte[] diacriticYShift;
    private static byte[] diacriticYUpShift;
    private static byte[][] lettersProp;
    private static boolean[] upperLetters;
    private static boolean[] inverseFont;
    private static byte[] spaceLetterW;
    public static byte[] spaceW;
    public static String fontName;
    private static char[] textBuffer;

    public static boolean initFont() {
        boolean fontDiffers;
        String name;
        String currentLangCode = Main.langCodes[Main.langIndex].toLowerCase();
        if (currentLangCode.equals("el")) {
            name = "/font__el";
            UPPER_START = 913;
            UPPER_END = 937;
            LOWER_START = 945;
            LOWER_END = 969;
        } else if (currentLangCode.equals("ru")) {
            name = "/font__ru";
            UPPER_START = 1040;
            UPPER_END = 1071;
            LOWER_START = 1072;
            LOWER_END = 1103;
        } else {
            name = "/font";
            UPPER_START = 65;
            UPPER_END = 90;
            LOWER_START = 97;
            LOWER_END = 122;
        }
        N_UPPER = UPPER_END - UPPER_START;
        N_LOWER = LOWER_END - LOWER_START;
        N_BASE_LETTERS = N_UPPER + N_LOWER;
        boolean bl = fontDiffers = !name.equals(fontName);
        if (fontDiffers && imageCache != null && imageCache.length > 0) {
            for (int i = imageCache.length - 1; i > -1; --i) {
                Fonts.imageCache[i] = null;
            }
        }
        fontName = name;
        return fontDiffers;
    }

    public static void readFontGraphics(PlatformResource dis) {
        int i;
        Fonts.initFont();
        fontsCnt = dis.readShort();
        imageCache = new PlatformImage[fontsCnt];
        imageColorVariantsCnt = new byte[fontsCnt];
        for (i = 0; i < fontsCnt; i += imageColorVariantsCnt[i]) {
            Utils.readDiffImage(dis, imageCache, imageColorVariantsCnt, i, -1);
        }
        baseDiacritics = dis.readUTF();
        baseLetters = dis.readUTF();
        baseDecodes = new byte[dis.readShort()];
        if (baseDecodes.length > 0) {
            dis.readFully(baseDecodes);
        }
        if (baseDiacritics.length() != baseLetters.length() || baseLetters.length() != baseDecodes.length) {
            Platform.debuglog("ASSERT: nesouhlasi pocty zakladu sady - baseDiacriticts:" + baseDiacritics.length() + " baseLetters:" + baseLetters.length() + " baseDecodes:" + baseDecodes.length);
        }
        dis.readShort();
        Platform.debuglog("Pocet fontu:" + fontsCnt);
        fontChars = new String[fontsCnt];
        fontH = new byte[fontsCnt];
        fontW = new byte[fontsCnt];
        diacriticXShift = new byte[fontsCnt];
        diacriticYShift = new byte[fontsCnt];
        diacriticYUpShift = new byte[fontsCnt];
        upperLetters = new boolean[fontsCnt];
        inverseFont = new boolean[fontsCnt];
        lettersProp = new byte[fontsCnt][];
        spaceW = new byte[fontsCnt];
        spaceLetterW = new byte[fontsCnt];
        dis.readShort();
        for (i = 0; i < fontsCnt; ++i) {
            int imgIndex = i;
            int variantsNum = imageColorVariantsCnt[imgIndex];
            Fonts.fontChars[i] = dis.readUTF();
            Fonts.upperLetters[i] = false;
            Fonts.lettersProp[i] = null;
            Fonts.spaceW[i] = 0;
            int cntO = dis.readShort();
            while (--cntO >= 0) {
                switch (dis.readByte()) {
                    case 0: {
                        Fonts.upperLetters[i] = dis.readBoolean();
                        break;
                    }
                    case 1: {
                        short cnt = dis.readShort();
                        Platform.debuglog("letters:" + cnt);
                        Fonts.lettersProp[i] = new byte[cnt];
                        if (cnt > 0) {
                            dis.readFully(lettersProp[i]);
                        }
                        Fonts.fontH[i] = (byte)(lettersProp[i][3] + lettersProp[i][4]);
                        break;
                    }
                    case 2: {
                        Fonts.spaceW[i] = dis.readByte();
                        break;
                    }
                    case 3: {
                        Fonts.diacriticYUpShift[i] = dis.readByte();
                        break;
                    }
                    case 4: {
                        Fonts.fontH[i] = dis.readByte();
                        break;
                    }
                    case 5: {
                        Fonts.diacriticXShift[i] = dis.readByte();
                        break;
                    }
                    case 6: {
                        Fonts.diacriticYShift[i] = dis.readByte();
                        break;
                    }
                    case 7: {
                        Fonts.inverseFont[i] = dis.readByte() != 0;
                        break;
                    }
                    case 8: {
                        Fonts.spaceLetterW[i] = dis.readByte();
                    }
                }
            }
            if (spaceLetterW[i] <= 0) {
                Fonts.spaceLetterW[i] = lettersProp[i][2];
            }
            Platform.debuglog("font:" + i + " extra znaky:" + fontChars[i] + " fontW:" + fontW[i] + " upperL:" + upperLetters[i]);
            while (variantsNum > 1) {
                Platform.debuglog("Vytvariam variantu fontu:" + variantsNum);
                Fonts.fontChars[++i] = fontChars[i - 1];
                Fonts.fontH[i] = fontH[i - 1];
                Fonts.fontW[i] = fontW[i - 1];
                Fonts.upperLetters[i] = upperLetters[i - 1];
                Fonts.lettersProp[i] = lettersProp[i - 1];
                Fonts.spaceW[i] = spaceW[i - 1];
                Fonts.spaceLetterW[i] = spaceLetterW[i - 1];
                Fonts.diacriticXShift[i] = diacriticXShift[i - 1];
                Fonts.diacriticYShift[i] = diacriticYShift[i - 1];
                Fonts.diacriticYUpShift[i] = diacriticYUpShift[i - 1];
                Fonts.inverseFont[i] = inverseFont[i - 1];
                --variantsNum;
            }
        }
    }

    public static void drawGraphicString(int fontN, char[] text, int textOffset, int textLength, int x, int y, int anchor) {
        byte letterSpaceW;
        int letterIndex;
        PlatformGraphics g = Platform.getDisplayGraphics();
        if (lettersProp == null || fontN >= lettersProp.length) {
            Platform.debuglog("Zvoleny font neni pristupny!:" + fontN);
            return;
        }
        PlatformImage fontImg = imageCache[fontN];
        byte diaX = diacriticXShift[fontN];
        byte diaYLo = diacriticYShift[fontN];
        byte diaYUp = diacriticYUpShift[fontN];
        boolean upperChars = upperLetters[fontN];
        int lettersLength = lettersProp[fontN].length / 5;
        if ((anchor & 8) != 0) {
            x -= Fonts.getStringWidth(fontN, text, 0, textLength);
        } else if ((anchor & 1) != 0) {
            x -= Fonts.getStringWidth(fontN, text, 0, textLength) >> 1;
        }
        if ((anchor & 0x20) != 0) {
            y -= fontH[fontN];
        } else if ((anchor & 2) != 0) {
            y -= fontH[fontN] >> 1;
            letterIndex = (lettersLength - 10 + 9) * 5;
            y += lettersProp[fontN][letterIndex + 3] + diaYUp;
        } else if ((anchor & 0x10) != 0) {
            letterIndex = (lettersLength - 10 + 9) * 5;
        }
        int cx = g.getClipX();
        int cy = g.getClipY();
        int cw = g.getClipWidth();
        int ch = g.getClipHeight();
        int ANCHOR = 20;
        int fImgY = 0;
        byte bFontW = letterSpaceW = spaceLetterW[fontN];
        byte bFontH = fontH[fontN];
        int shift = 0;
        byte lSpaceW = spaceW[fontN];
        int nBase = N_BASE_LETTERS + 2;
        if (upperChars) {
            nBase = N_LOWER + 1;
        }
        int textLimit = textOffset + textLength;
        for (int i = textOffset; i < textLimit; ++i) {
            boolean isLower;
            int diacriticDecode;
            block37: {
                int actChar;
                block38: {
                    block36: {
                        actChar = text[i];
                        if (upperChars && (actChar >= UPPER_START && actChar <= UPPER_END || actChar >= LOWER_START && actChar <= LOWER_END || LOWER_START != 97 && actChar >= 97 && actChar <= 122)) {
                            actChar = Fonts.toUpperCase((char)actChar);
                        } else if (LOWER_START != 97 && actChar >= 97 && actChar <= 122) {
                            actChar = Fonts.toUpperCase((char)actChar);
                        }
                        diacriticDecode = 0;
                        boolean isUpper = actChar >= UPPER_START && actChar <= UPPER_END;
                        isLower = false;
                        if (!isUpper && !upperChars) {
                            boolean bl = isLower = actChar >= LOWER_START && actChar <= LOWER_END;
                        }
                        if (!isUpper && !isLower) {
                            int nBaseLetters = baseDiacritics.length();
                            for (int j = 0; j < nBaseLetters; ++j) {
                                if (baseDiacritics.charAt(j) != actChar) continue;
                                actChar = baseLetters.charAt(j);
                                diacriticDecode = baseDecodes[j];
                                if (!upperChars) break;
                                actChar = Fonts.toUpperCase((char)actChar);
                                break;
                            }
                            isUpper = actChar >= UPPER_START && actChar <= UPPER_END;
                            isLower = false;
                            if (!isUpper && !upperChars) {
                                boolean bl = isLower = actChar >= LOWER_START && actChar <= LOWER_END;
                            }
                        }
                        if (!isUpper) break block36;
                        shift = actChar - UPPER_START;
                        break block37;
                    }
                    if (!isLower) break block38;
                    shift = actChar - LOWER_START + N_UPPER + 1;
                    if (actChar != 105 || diacriticDecode != 0) break block37;
                    diacriticDecode = 10;
                    break block37;
                }
                if (actChar == 32 || actChar == 160) {
                    x += letterSpaceW + lSpaceW;
                    continue;
                }
                int nChars = fontChars[fontN].length();
                int tmpUpperChar = actChar;
                if (upperChars) {
                    if (actChar == 231) {
                        tmpUpperChar = 199;
                    } else if (actChar == 261) {
                        tmpUpperChar = 260;
                    } else if (actChar == 281) {
                        tmpUpperChar = 280;
                    } else if (actChar == 322) {
                        tmpUpperChar = 321;
                    }
                }
                for (int j = 0; j < nChars; ++j) {
                    char tmpChar = fontChars[fontN].charAt(j);
                    if (tmpChar != actChar && (!upperChars || tmpChar != tmpUpperChar)) continue;
                    shift = j + nBase;
                    break;
                }
            }
            int letterIndex2 = shift * 5;
            int fImgX = lettersProp[fontN][letterIndex2++] & 0xFF;
            fImgY = lettersProp[fontN][letterIndex2++] & 0xFF;
            bFontW = lettersProp[fontN][letterIndex2++];
            bFontH = lettersProp[fontN][letterIndex2++];
            int baseLine = lettersProp[fontN][letterIndex2];
            if (fImgX + bFontW > fontImg.getWidth()) {
                Platform.debuglog("ASSERT Offset prez sirku obr! fontu:" + fontN + " x:" + (fImgX + bFontW));
            }
            if (fImgY + bFontH > fontImg.getHeight()) {
                Platform.debuglog("ASSERT Offset prez vysku obr! fontu:" + fontN + " x:" + (fImgY + bFontH));
            }
            g.setClip(x, y + baseLine, bFontW, bFontH);
            g.drawImage(fontImg, x - fImgX, y - fImgY + baseLine, ANCHOR);
            if (diacriticDecode > 0) {
                int xPosCorr = bFontW >> 1;
                int yPosCorr = baseLine;
                if (diacriticDecode == 2) {
                    xPosCorr += bFontW >> 1;
                }
                if (diacriticDecode > 1) {
                    diacriticDecode = (byte)(diacriticDecode - 1);
                }
                letterIndex2 = (lettersLength - 10 + diacriticDecode) * 5;
                fImgX = lettersProp[fontN][letterIndex2++] & 0xFF;
                fImgY = lettersProp[fontN][letterIndex2++] & 0xFF;
                byte diacW = lettersProp[fontN][letterIndex2++];
                byte diacH = lettersProp[fontN][letterIndex2++];
                xPosCorr += diaX;
                if (diacriticDecode == 1) {
                    xPosCorr += diacW >> 1;
                } else if (diacriticDecode == 2) {
                    xPosCorr -= diacW >> 1;
                }
                yPosCorr = isLower ? (yPosCorr += diaYLo) : (yPosCorr += diaYUp);
                g.setClip(x + (xPosCorr -= diacW >> 1), y + yPosCorr - diacH, diacW, diacH);
                g.drawImage(fontImg, x + xPosCorr - fImgX, y + yPosCorr - fImgY - diacH, 20);
                fImgY = 0;
            }
            x += bFontW + lSpaceW;
        }
        g.setClip(cx, cy, cw, ch);
    }

    public static void drawGraphicString(int fontN, String texts, int x, int y, int anchor) {
        int length = Fonts.toTextBuffer(texts);
        Fonts.drawGraphicString(fontN, textBuffer, 0, length, x, y, anchor);
    }

    public static int getStringWidth(int fontN, String text) {
        if (lettersProp == null || fontN >= lettersProp.length) {
            Platform.debuglog("Zvoleny font neni pristupny!:" + fontN);
            return -1;
        }
        int width = 0;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            width += Fonts.getCharWidth(fontN, text.charAt(i));
        }
        return width - spaceW[fontN];
    }

    public static int getStringWidth(int fontN, char[] text, int offset, int length) {
        if (offset > text.length) {
            return 0;
        }
        int width = 0;
        for (int i = offset; i < length; ++i) {
            width += Fonts.getCharWidth(fontN, text[i]);
        }
        return width;
    }

    public static int getCharWidth(int fontN, char actChar) {
        int shift;
        int actFontW;
        block9: {
            int j;
            boolean upperChars;
            block10: {
                block8: {
                    if (lettersProp == null || fontN >= lettersProp.length) {
                        Platform.debuglog("Zvoleny font neni pristupny!:" + fontN);
                        return -1;
                    }
                    upperChars = upperLetters[fontN];
                    actFontW = fontW[fontN];
                    shift = 0;
                    boolean isUpper = actChar >= UPPER_START && actChar <= UPPER_END;
                    boolean isLower = false;
                    if (!isUpper && !upperChars) {
                        boolean bl = isLower = actChar >= LOWER_START && actChar <= LOWER_END;
                    }
                    if (!isUpper && !isLower) {
                        int nBaseLetters = baseDiacritics.length();
                        for (j = 0; j < nBaseLetters; ++j) {
                            if (baseDiacritics.charAt(j) != actChar) continue;
                            actChar = baseLetters.charAt(j);
                            break;
                        }
                    }
                    if (upperChars && (actChar >= UPPER_START && actChar <= UPPER_END || actChar >= LOWER_START && actChar <= LOWER_END || LOWER_START != 97 && actChar >= 'a' && actChar <= 'z')) {
                        actChar = Fonts.toUpperCase(actChar);
                    }
                    if (actChar < UPPER_START || actChar > UPPER_END) break block8;
                    shift = actChar - UPPER_START;
                    break block9;
                }
                if (actChar < LOWER_START || actChar > LOWER_END) break block10;
                shift = actChar - LOWER_START + N_UPPER + 1;
                if (!upperChars) break block9;
                shift -= N_UPPER + 1;
                break block9;
            }
            if (actChar == ' ' || actChar == '\u00a0') {
                return spaceLetterW[fontN] + spaceW[fontN];
            }
            int nChars = fontChars[fontN].length();
            for (j = 0; j < nChars; ++j) {
                if (fontChars[fontN].charAt(j) != actChar) continue;
                if (upperChars) {
                    shift = j + N_BASE_LETTERS - N_LOWER + 1;
                    break;
                }
                shift = j + N_BASE_LETTERS + 2;
                break;
            }
        }
        actFontW = lettersProp[fontN][shift * 5 + 2] + spaceW[fontN];
        return actFontW;
    }

    public static char toUpperCase(char actChar) {
        if (actChar >= UPPER_START && actChar <= UPPER_END) {
            return actChar;
        }
        if (actChar == '\u03c2') {
            return '\u03a3';
        }
        return (char)(actChar + UPPER_START - LOWER_START);
    }

    public static int getFontHeight(int fontN) {
        Platform.assertFalse(fontH == null || fontN < 0 || fontN >= fontH.length, "Fonts.getFontHeight");
        try {
            return fontH[fontN];
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static void drawNumber(int fontN, int value, int x, int y, int anchor) {
        int length = Utils.itoa(value, 10, textBuffer, 0);
        Fonts.drawGraphicString(fontN, textBuffer, 0, length, x, y, anchor);
    }

    private static int toTextBuffer(String texts) {
        int length = texts.length();
        if (textBuffer.length < length) {
            textBuffer = new char[length];
        }
        texts.getChars(0, length, textBuffer, 0);
        return length;
    }

    public static String[] wrapSystemText(int font, String s, int width) {
        if (Platform.getFontTextWidth(font, s) > width) {
            Vector<String> v = new Vector<String>();
            int begin = 0;
            int end = 1;
            int pEnd = 1;
            while (begin < end) {
                if (Platform.getFontTextWidth(font, s.substring(begin, end)) >= width) {
                    while (Platform.getFontTextWidth(font, s.substring(begin, pEnd)) >= width) {
                        --pEnd;
                    }
                    if (s.charAt(pEnd) == ' ') {
                        v.addElement(s.substring(begin, pEnd));
                    } else {
                        v.addElement(s.substring(begin, pEnd + 1));
                    }
                    begin = pEnd + 1;
                } else if (end == s.length()) {
                    v.addElement(s.substring(begin, end));
                    break;
                }
                pEnd = end;
                if ((end = s.indexOf(32, end + 1)) != -1) continue;
                end = s.length();
            }
            Object[] sa = new String[v.size()];
            v.copyInto(sa);
            return sa;
        }
        String[] array = new String[]{s};
        return array;
    }

    static {
        UPPER_START = 65;
        UPPER_END = 90;
        LOWER_START = 97;
        LOWER_END = 122;
        N_UPPER = UPPER_END - UPPER_START;
        N_LOWER = LOWER_END - LOWER_START;
        N_BASE_LETTERS = N_UPPER + N_LOWER;
        textBuffer = new char[64];
    }
}

