/*
 * Decompiled with CFR 0.152.
 */
public abstract class Container {
    public String name = "";
    public Map[] mm1;
    public boolean isShow = true;
    public boolean focus = false;
    public int layerNum = 0;
    public int lastLayerNum = 0;
    public Layer[] layer;
    public short[][] stateAniList;
    public int collsionSpritesNameUseLength;
    AnimationMgr ani_mgr;
    public boolean tirggerLock = false;

    public Container(String name) {
        this.name = name;
        this.layerNum = 1;
        this.layer = new Layer[1];
        this.lastLayerNum = 0;
    }

    public Container(String name, int layerNum) {
        this.name = name;
        if (layerNum > 0) {
            this.layerNum = layerNum;
            this.layer = new Layer[layerNum];
            this.lastLayerNum = 0;
        }
    }

    public void createLayer(int id, String layerName, int spritesNum, int layermapNum, int imageNum) {
        if (this.lastLayerNum < this.layer.length) {
            this.layer[this.lastLayerNum] = new Layer(this, id, layerName, spritesNum, layermapNum, imageNum);
            this.layer[this.lastLayerNum].active = true;
            ++this.lastLayerNum;
        }
    }

    public boolean checkStageOk() {
        for (int i = 0; i < this.layer.length; ++i) {
            if (this.layer[i] != null) continue;
            return false;
        }
        return true;
    }

    public void setShow(boolean toshow) {
        this.isShow = toshow;
    }

    public void setFocus(boolean isfocus) {
        this.focus = isfocus;
    }

    public boolean getFocus() {
        return this.focus;
    }

    public boolean getShow() {
        return this.isShow;
    }

    public void stageRender(PlatformGraphics g) {
        if (this.isShow && this.layer != null) {
            for (int i = 0; i < this.layer.length; ++i) {
                this.layer[i].render(g);
            }
        }
    }

    public void updateStateByKey(int pressedKeySymbol) {
        for (int j = 0; j < this.layer.length; ++j) {
            for (int i = 0; i < this.layer[j].allControlSpritesLength; ++i) {
                this.layer[j].allControlSpritesInLayer[i].updateState(pressedKeySymbol, null);
            }
        }
        this.go();
    }

    public void updateByKeyPress(int pressedKeySymbol) {
    }

    public void updateByKeyRelease(int pressedKeySymbol) {
    }

    public void go() {
        for (int j = 0; j < this.layer.length; ++j) {
            for (int i = 0; i < this.layer[j].allControlSpritesLength; ++i) {
                this.layer[j].allControlSpritesInLayer[i].go();
            }
        }
    }

    public Layer getLayerByName(String name) {
        if (this.layer != null) {
            for (int i = 0; i < this.layer.length; ++i) {
                if (!this.layer[i].getLayerName().equals(name)) continue;
                return this.layer[i];
            }
        }
        return null;
    }

    public void stageUpdate() {
        if (this.focus) {
            this.sendKeyEvent();
        }
        this.update();
        for (int i = 0; i < this.layer.length; ++i) {
            this.layer[i].update();
        }
    }

    public abstract void update();

    public void sendKeyEvent() {
        EventManager.sendEvent(1, 0x10000003, 0, this, (Sprites)null, "");
    }

    public Sprites getSprite(String name) {
        Sprites s = null;
        for (int i = 0; i < this.layer.length && (s = this.layer[i].getSpritesInLayerByName(name)) == null; ++i) {
        }
        return s;
    }

    public void checkCollision() {
    }

    public void checkTirggerCollision() {
    }

    public void releaseContainer() {
        try {
            int i;
            this.isShow = false;
            this.focus = false;
            if (this.mm1 != null) {
                for (i = 0; i < this.mm1.length; ++i) {
                    if (this.mm1[i] == null) continue;
                    this.mm1[i].releasMapResource();
                }
            }
            if (this.layer != null) {
                for (i = 0; i < this.layer.length; ++i) {
                    if (this.layer[i] == null) continue;
                    this.layer[i].releaseLayer();
                    this.layer[i] = null;
                }
            }
            if (this.stateAniList != null) {
                this.stateAniList = null;
            }
            this.collsionSpritesNameUseLength = 0;
            if (this.ani_mgr != null) {
                this.ani_mgr.releaseAllAnimation();
                this.ani_mgr = null;
            }
        }
        catch (Exception e) {
            System.out.println("e= " + e.toString());
        }
    }
}

