/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;

public class PlatformResource {
    private boolean eof;
    private DataInputStream din;

    protected PlatformResource(DataInputStream dataInputStream) {
        this.din = dataInputStream;
    }

    public void close() {
        try {
            this.din.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.din = null;
    }

    public boolean isEOF() {
        return this.eof;
    }

    public void skipBytes(int n) {
        try {
            this.din.skip(n);
        }
        catch (Exception exception) {
            this.eof = true;
        }
    }

    public boolean readBoolean() {
        try {
            return this.din.readBoolean();
        }
        catch (Exception exception) {
            this.eof = true;
            return false;
        }
    }

    public byte readByte() {
        try {
            return this.din.readByte();
        }
        catch (Exception exception) {
            this.eof = true;
            return 0;
        }
    }

    public int readUnsignedByte() {
        try {
            return this.din.readUnsignedByte();
        }
        catch (Exception exception) {
            this.eof = true;
            return 0;
        }
    }

    public short readShort() {
        try {
            return this.din.readShort();
        }
        catch (Exception exception) {
            this.eof = true;
            return 0;
        }
    }

    public int readUnsignedShort() {
        try {
            return this.din.readUnsignedShort();
        }
        catch (Exception exception) {
            this.eof = true;
            return 0;
        }
    }

    public int readInt() {
        try {
            return this.din.readInt();
        }
        catch (Exception exception) {
            this.eof = true;
            return 0;
        }
    }

    public long readLong() {
        try {
            return this.din.readLong();
        }
        catch (Exception exception) {
            this.eof = true;
            return 0L;
        }
    }

    public void readFully(byte[] byArray, int n, int n2) {
        try {
            this.din.readFully(byArray, n, n2);
        }
        catch (Exception exception) {
            this.eof = true;
        }
    }

    public void readFully(byte[] byArray) {
        this.readFully(byArray, 0, byArray.length);
    }

    public String readUTF() {
        try {
            return this.din.readUTF();
        }
        catch (Exception exception) {
            this.eof = true;
            return "";
        }
    }
}

