/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

class PlatformCanvas
extends Canvas
implements Runnable {
    public static PlatformCanvas instance = null;
    private static final int STATE_RUN = 0;
    private static final int STATE_QUIT = 1;
    public static final int RESUME_SOUND_DELAY = 1500;
    private static int state;
    private static Thread thread;
    public static int canvasWidth;
    public static int canvasHeight;
    private boolean isShown;
    private volatile boolean showNotifySeen;
    private volatile boolean hideNotifySeen;
    static boolean repaintRequest;
    public static Main application;
    private static volatile boolean paintRequest;

    public PlatformCanvas() {
        instance = this;
    }

    public void start() {
        state = 0;
        thread = new Thread(this);
        thread.start();
    }

    public void exit() {
        state = 1;
        PlatformSound.stopAllSounds();
    }

    public void showNotify() {
        this.isShown = true;
        this.showNotifySeen = true;
    }

    public void hideNotify() {
        this.isShown = false;
        this.hideNotifySeen = true;
        this.showNotifySeen = false;
        PlatformSound.stopAllSounds();
    }

    public void run() {
        try {
            this.runSafe();
        }
        catch (Exception exception) {
            // empty catch block
        }
        PlatformMIDlet.instance.notifyDestroyed();
    }

    private void runSafe() {
        if (PlatformMIDlet.display.getCurrent() != this) {
            PlatformMIDlet.display.setCurrent((Displayable)this);
        }
        canvasWidth = this.getWidth();
        canvasHeight = this.getHeight();
        Platform.init();
        application = new Main();
        application.start();
        while (state != 1) {
            this.checkPause();
            application.update();
            if (!repaintRequest) continue;
            repaintRequest = false;
            PlatformCanvas.redraw();
        }
        application.destroy();
    }

    private void checkPause() {
        if (this.hideNotifySeen) {
            application.pause();
            while (this.hideNotifySeen) {
                this.hideNotifySeen = false;
                do {
                    Platform.sleep(100);
                } while (!this.showNotifySeen);
            }
            application.resume();
        }
    }

    public void keyPressed(int n) {
        int n2 = PlatformCanvas.mapKeySymbol(n);
        if (application != null) {
            application.keyPressed(n2);
        }
    }

    public void keyReleased(int n) {
        int n2 = PlatformCanvas.mapKeySymbol(n);
        if (application != null) {
            application.keyReleased(n2);
        }
    }

    public static int mapKeySymbol(int n) {
        switch (n) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return 1 + (n - 48);
            }
            case 42: {
                return 11;
            }
            case 35: {
                return 12;
            }
            case -16: {
                return 13;
            }
            case -6: {
                return 14;
            }
            case -7: {
                return 15;
            }
            case -5: {
                return 16;
            }
            case -1: {
                return 17;
            }
            case -2: {
                return 18;
            }
            case -3: {
                return 19;
            }
            case -4: {
                return 20;
            }
        }
        return -1;
    }

    public synchronized void paint(Graphics graphics) {
        if (!paintRequest) {
            return;
        }
        Platform.g = graphics;
        Platform.displayGraphics.g = graphics;
        canvasWidth = this.getWidth();
        canvasHeight = this.getHeight();
        try {
            Graphics graphics2 = Platform.g;
            if (graphics2 == null) {
                return;
            }
            graphics2.translate(-graphics2.getTranslateX(), -graphics2.getTranslateY());
            application.paint();
        }
        catch (Exception exception) {
            // empty catch block
        }
        paintRequest = false;
    }

    public static void redraw() {
        paintRequest = true;
        PlatformCanvas platformCanvas = instance;
        platformCanvas.repaint();
        platformCanvas.serviceRepaints();
        while (paintRequest) {
            Platform.sleep(10);
        }
    }

    protected void sizeChanged(int n, int n2) {
        if (application != null) {
            application.sizeChanged(n, n2);
        }
    }

    static {
        repaintRequest = true;
    }
}

