/*
 * Decompiled with CFR 0.152.
 */
public class ImageMgr {
    protected PlatformImage[] imgs;
    static byte[][] info;
    public byte[] imgData;
    private int maxImgDataLen;
    private static final int PER_INFO_LEN = 11;
    private static final int HDRLEN = 13;
    private static final byte[] SIG;
    public static final int IHDR = 1229472850;
    public static final int IPLTE = 1347179589;
    public static final int TRNS = 1951551059;
    public static final int IDAT = 1229209940;
    public static final int IEND = 1229278788;
    public static final int ENDCRC = -1371381630;
    public static final int I_FLAG_RGB = 1;
    private int iFlag;
    private String iF;
    private String pF;
    private String dF;
    private byte[] isToLoad;
    private int toLoadImgCnt;
    private int hasLoadCnt;
    private int callCnt = 1;
    private int lastLoadIndex = -1;
    private int blockCnt;
    private int curDIdx = -1;
    private byte[][] plts;
    private byte[][] tRans;
    private int[] datTb;
    private PlatformResource infoIn;
    private PlatformResource datIn;
    protected short[] width;
    protected short[] height;
    public static final int PALETTE_TYPE_NORMAL = 0;
    public static final int PALETTE_TYPE_NIGHTVISION = 1;
    private int paletteType;

    public void setPaletteType(int n) {
        this.paletteType = n;
    }

    public ImageMgr(String string, String string2, String string3) {
        this.iF = string;
        this.pF = string2;
        this.dF = string3;
        this.paletteType = 0;
    }

    public void init() {
        try {
            this.infoIn = Platform.getResource("/" + this.iF);
            this.iFlag = this.infoIn.readInt();
            this.blockCnt = this.infoIn.readShort();
            this.imgs = new PlatformImage[this.blockCnt];
            this.isToLoad = new byte[this.blockCnt + 7 >> 3];
            this.width = new short[this.blockCnt];
            this.height = new short[this.blockCnt];
            if ((this.iFlag & 1) != 0) {
                this.datTb = new int[this.blockCnt + 1];
                for (int i = 0; i < this.datTb.length; ++i) {
                    this.datTb[i] = this.infoIn.readInt();
                }
            }
            this.infoIn.close();
            this.infoIn = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addLoadImgId(int n) {
        int n2 = n >> 3;
        int n3 = n & 7;
        if ((this.isToLoad[n2] >> n3 & 1) == 0) {
            int n4 = n2;
            this.isToLoad[n4] = (byte)(this.isToLoad[n4] | 1 << n3);
            ++this.toLoadImgCnt;
        }
    }

    public void releaseImage(int n) {
        this.imgs[n] = null;
    }

    public void releaseAllImages() {
        int n;
        for (n = 0; n < this.imgs.length; ++n) {
            this.imgs[n] = null;
        }
        for (n = 0; n < this.isToLoad.length; ++n) {
            this.isToLoad[n] = 0;
        }
        this.curDIdx = -1;
        this.lastLoadIndex = -1;
        this.hasLoadCnt = 0;
        this.toLoadImgCnt = 0;
    }

    public void setCallCnt(int n) {
        this.callCnt = n;
    }

    public boolean loadImgs() {
        if (this.hasLoadCnt >= this.toLoadImgCnt) {
            return true;
        }
        if ((this.iFlag & 1) == 0) {
            return this.loadPltImgs();
        }
        return this.loadRGBImgs();
    }

    private boolean loadPltImgs() {
        boolean bl = false;
        try {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            if (this.lastLoadIndex == -1) {
                PlatformResource platformResource = Platform.getResource("/" + this.pF);
                n6 = platformResource.readShort();
                this.plts = new byte[n6][];
                this.tRans = new byte[n6][];
                for (n5 = 0; n5 < n6; ++n5) {
                    this.plts[n5] = new byte[platformResource.readShort()];
                    platformResource.readFully(this.plts[n5]);
                    n4 = platformResource.readShort();
                    if (n4 <= 0) continue;
                    this.tRans[n5] = new byte[n4];
                    platformResource.readFully(this.tRans[n5]);
                }
                platformResource.close();
                platformResource = null;
                System.gc();
                Thread.sleep(50L);
                this.infoIn = Platform.getResource("/" + this.iF);
                this.infoIn.skipBytes(4);
                n5 = this.infoIn.readShort();
                info = new byte[n5][11];
                for (n4 = 0; n4 < n5; ++n4) {
                    this.infoIn.readFully(info[n4]);
                }
                this.infoIn.close();
                this.infoIn = null;
                System.gc();
                this.datIn = Platform.getResource("/" + this.dF);
                this.datTb = new int[this.datIn.readShort()];
                for (n4 = 0; n4 < this.datTb.length; ++n4) {
                    this.datTb[n4] = this.datIn.readInt();
                }
                if (this.maxImgDataLen == 0) {
                    for (n4 = 0; n4 < n5; ++n4) {
                        n3 = (short)((info[n4][9] & 0xFF) << 8 | info[n4][10] & 0xFF);
                        n2 = this.datTb[n4 + 1] - this.datTb[n4];
                        n = 61 + this.plts[n3].length + n2 + (this.tRans[n3] == null ? 0 : this.tRans[n3].length + 8);
                        if (n <= this.maxImgDataLen) continue;
                        this.maxImgDataLen = n;
                    }
                }
                this.imgData = new byte[this.maxImgDataLen];
            }
            int n7 = 0;
            n6 = (this.toLoadImgCnt + this.callCnt - 1) / this.callCnt;
            for (n2 = this.lastLoadIndex + 1; n2 < this.blockCnt; ++n2) {
                n4 = n2 >> 3;
                n3 = n2 & 7;
                if ((this.isToLoad[n4] >> n3 & 1) == 0) continue;
                n5 = (short)((info[n2][0] & 0xFF) << 8 | info[n2][1] & 0xFF);
                if (this.imgs[n2] != null || n5 == 0) {
                    int n8 = n4;
                    this.isToLoad[n8] = (byte)(this.isToLoad[n8] & ~(1 << n3));
                    ++n7;
                    ++this.hasLoadCnt;
                    if (this.hasLoadCnt < this.toLoadImgCnt) continue;
                    bl = true;
                    break;
                }
                if (n2 > this.lastLoadIndex + 1) {
                    this.datIn.skipBytes(this.datTb[n2] - this.datTb[this.lastLoadIndex + 1]);
                }
                this.lastLoadIndex = n2;
                n = (info[n2][2] & 0xFF) << 8 | info[n2][3] & 0xFF;
                this.width[n2] = n5;
                this.height[n2] = n;
                byte by = info[n2][4];
                int n9 = (info[n2][5] & 0xFF) << 24 | (info[n2][6] & 0xFF) << 16 | (info[n2][7] & 0xFF) << 8 | info[n2][8] & 0xFF;
                short s = (short)((info[n2][9] & 0xFF) << 8 | info[n2][10] & 0xFF);
                int n10 = this.datTb[n2 + 1] - this.datTb[n2];
                int n11 = 0;
                System.arraycopy(SIG, 0, this.imgData, 0, 8);
                this.writeIntToArray(this.imgData, n11 += 8, 13);
                this.writeIntToArray(this.imgData, n11 += 4, 1229472850);
                this.writeIntToArray(this.imgData, n11 += 4, n5);
                this.writeIntToArray(this.imgData, n11 += 4, n);
                this.imgData[n11 += 4] = by;
                this.imgData[++n11] = 3;
                this.imgData[++n11] = 0;
                this.imgData[++n11] = 0;
                this.imgData[++n11] = 0;
                this.writeIntToArray(this.imgData, ++n11, n9);
                this.writeIntToArray(this.imgData, n11 += 4, this.plts[s].length - 4);
                this.writeIntToArray(this.imgData, n11 += 4, 1347179589);
                System.arraycopy(this.plts[s], 0, this.imgData, n11 += 4, this.plts[s].length);
                n11 += this.plts[s].length;
                if (this.tRans[s] != null) {
                    this.writeIntToArray(this.imgData, n11, this.tRans[s].length - 4);
                    this.writeIntToArray(this.imgData, n11 += 4, 1951551059);
                    System.arraycopy(this.tRans[s], 0, this.imgData, n11 += 4, this.tRans[s].length);
                    n11 += this.tRans[s].length;
                }
                this.writeIntToArray(this.imgData, n11, n10 - 4);
                this.writeIntToArray(this.imgData, n11 += 4, 1229209940);
                this.datIn.readFully(this.imgData, n11 += 4, n10);
                this.writeIntToArray(this.imgData, n11 += n10, 0);
                this.writeIntToArray(this.imgData, n11 += 4, 1229278788);
                this.writeIntToArray(this.imgData, n11 += 4, -1371381630);
                this.imgs[n2] = Platform.createImage(0, this.imgData, 0, n11 += 4);
                int n12 = n4;
                this.isToLoad[n12] = (byte)(this.isToLoad[n12] & ~(1 << n3));
                ++n7;
                ++this.hasLoadCnt;
                if (this.hasLoadCnt >= this.toLoadImgCnt) {
                    bl = true;
                    break;
                }
                if (n7 >= n6) break;
            }
            if (bl) {
                info = null;
                this.datIn.close();
                this.datIn = null;
                this.imgData = null;
                this.plts = null;
                this.tRans = null;
                this.datTb = null;
                this.lastLoadIndex = -1;
                this.hasLoadCnt = 0;
                this.toLoadImgCnt = 0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.gc();
        return bl;
    }

    private boolean loadRGBImgs() {
        boolean bl = false;
        try {
            int n;
            int n2;
            if (this.lastLoadIndex == -1) {
                PlatformResource platformResource = Platform.getResource("/" + this.pF);
                n2 = platformResource.readShort();
                this.plts = new byte[n2][];
                for (n = 0; n < n2; ++n) {
                    this.plts[n] = new byte[platformResource.readShort()];
                    platformResource.readFully(this.plts[n]);
                }
                platformResource.close();
                platformResource = null;
            }
            int n3 = 0;
            n2 = (this.toLoadImgCnt + this.callCnt - 1) / this.callCnt;
            for (int i = this.lastLoadIndex + 1; i < this.blockCnt; ++i) {
                n = i >> 3;
                int n4 = i & 7;
                if ((this.isToLoad[n] >> n4 & 1) == 0) continue;
                if (this.imgs[i] != null) {
                    int n5 = n;
                    this.isToLoad[n5] = (byte)(this.isToLoad[n5] & ~(1 << n4));
                    ++n3;
                    ++this.hasLoadCnt;
                    if (this.hasLoadCnt < this.toLoadImgCnt) continue;
                    bl = true;
                    break;
                }
                int n6 = this.datTb[i] >> 20;
                if (n6 != this.curDIdx) {
                    this.curDIdx = n6;
                    if (this.datIn != null) {
                        this.datIn.close();
                    }
                    this.datIn = Platform.getResource("/" + this.dF + n6);
                    this.datIn.skipBytes(this.datTb[i] & 0xFFFFF);
                } else if (i > this.lastLoadIndex + 1) {
                    this.datIn.skipBytes(this.datTb[i] - this.datTb[this.lastLoadIndex + 1]);
                }
                this.lastLoadIndex = i;
                short s = this.datIn.readShort();
                if (s == 0) continue;
                short s2 = this.datIn.readShort();
                short s3 = this.datIn.readShort();
                byte[] byArray = this.plts[s3];
                this.width[i] = s;
                this.height[i] = s2;
                int n7 = s * s2;
                int[] nArray = new int[n7];
                for (int j = 0; j < n7; ++j) {
                    int n8 = (this.datIn.readByte() & 0xFF) << 2;
                    int n9 = j;
                    nArray[n9] = nArray[n9] | (byArray[n8] & 0xFF) << 24;
                    int n10 = j;
                    nArray[n10] = nArray[n10] | (byArray[n8 + 1] & 0xFF) << 16;
                    int n11 = j;
                    nArray[n11] = nArray[n11] | (byArray[n8 + 2] & 0xFF) << 8;
                    int n12 = j;
                    nArray[n12] = nArray[n12] | byArray[n8 + 3] & 0xFF;
                    if (this.paletteType != 1) continue;
                    int n13 = nArray[j];
                    int n14 = 299 * (n13 >> 16 & 0xFF) / 1000 + 587 * (n13 >> 8 & 0xFF) / 1000 + 114 * (n13 >> 0 & 0xFF) / 1000;
                    if ((n14 = n14 * 15 / 10) > 255) {
                        n14 = 255;
                    }
                    nArray[j] = n13 & 0xFF000000 | n14 << 8;
                }
                this.imgs[i] = Platform.createRGBImage(nArray, s, s2, true);
                int n15 = n;
                this.isToLoad[n15] = (byte)(this.isToLoad[n15] & ~(1 << n4));
                ++n3;
                ++this.hasLoadCnt;
                if (this.hasLoadCnt >= this.toLoadImgCnt) {
                    bl = true;
                    break;
                }
                if (n3 >= n2) break;
            }
            if (bl) {
                if (this.datIn != null) {
                    this.datIn.close();
                    this.datIn = null;
                }
                this.curDIdx = -1;
                this.plts = null;
                this.tRans = null;
                this.lastLoadIndex = -1;
                this.hasLoadCnt = 0;
                this.toLoadImgCnt = 0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.gc();
        return bl;
    }

    private void writeIntToArray(byte[] byArray, int n, int n2) {
        byArray[n++] = (byte)(n2 >> 24);
        byArray[n++] = (byte)(n2 >> 16);
        byArray[n++] = (byte)(n2 >> 8);
        byArray[n++] = (byte)n2;
    }

    static {
        SIG = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    }
}

