/*
 * Decompiled with CFR 0.152.
 */
public abstract class Container {
    public String name = "";
    public Map[] mm1;
    public boolean isShow = true;
    public boolean focus = false;
    public int layerNum = 0;
    public int lastLayerNum = 0;
    public Layer[] layer;
    public short[][] stateAniList;
    public int collsionSpritesNameUseLength;
    AnimationMgr ani_mgr;
    public boolean tirggerLock = false;

    public Container(String string) {
        this.name = string;
        this.layerNum = 1;
        this.layer = new Layer[1];
        this.lastLayerNum = 0;
    }

    public Container(String string, int n) {
        this.name = string;
        if (n > 0) {
            this.layerNum = n;
            this.layer = new Layer[n];
            this.lastLayerNum = 0;
        }
    }

    public void createLayer(int n, String string, int n2, int n3, int n4) {
        if (this.lastLayerNum < this.layer.length) {
            this.layer[this.lastLayerNum] = new Layer(this, n, string, n2, n3, n4);
            this.layer[this.lastLayerNum].active = true;
            ++this.lastLayerNum;
        }
    }

    public boolean checkStageOk() {
        for (int i = 0; i < this.layer.length; ++i) {
            if (this.layer[i] != null) continue;
            return false;
        }
        return true;
    }

    public void setShow(boolean bl) {
        this.isShow = bl;
    }

    public void setFocus(boolean bl) {
        this.focus = bl;
    }

    public boolean getFocus() {
        return this.focus;
    }

    public boolean getShow() {
        return this.isShow;
    }

    public void stageRender(PlatformGraphics platformGraphics) {
        if (this.isShow && this.layer != null) {
            for (int i = 0; i < this.layer.length; ++i) {
                this.layer[i].render(platformGraphics);
            }
        }
    }

    public void updateStateByKey(int n) {
        for (int i = 0; i < this.layer.length; ++i) {
            for (int j = 0; j < this.layer[i].allControlSpritesLength; ++j) {
                this.layer[i].allControlSpritesInLayer[j].updateState(n, null);
            }
        }
        this.go();
    }

    public void updateByKeyPress(int n) {
    }

    public void updateByKeyRelease(int n) {
    }

    public void go() {
        for (int i = 0; i < this.layer.length; ++i) {
            for (int j = 0; j < this.layer[i].allControlSpritesLength; ++j) {
                this.layer[i].allControlSpritesInLayer[j].go();
            }
        }
    }

    public Layer getLayerByName(String string) {
        if (this.layer != null) {
            for (int i = 0; i < this.layer.length; ++i) {
                if (!this.layer[i].getLayerName().equals(string)) continue;
                return this.layer[i];
            }
        }
        return null;
    }

    public void stageUpdate() {
        if (this.focus) {
            this.sendKeyEvent();
        }
        this.update();
        for (int i = 0; i < this.layer.length; ++i) {
            this.layer[i].update();
        }
    }

    public abstract void update();

    public void sendKeyEvent() {
        EventManager.sendEvent(1, 0x10000003, 0, this, (Sprites)null, "");
    }

    public Sprites getSprite(String string) {
        Sprites sprites = null;
        for (int i = 0; i < this.layer.length && (sprites = this.layer[i].getSpritesInLayerByName(string)) == null; ++i) {
        }
        return sprites;
    }

    public void checkCollision() {
    }

    public void checkTirggerCollision() {
    }

    public void releaseContainer() {
        try {
            int n;
            this.isShow = false;
            this.focus = false;
            if (this.mm1 != null) {
                for (n = 0; n < this.mm1.length; ++n) {
                    if (this.mm1[n] == null) continue;
                    this.mm1[n].releasMapResource();
                }
            }
            if (this.layer != null) {
                for (n = 0; n < this.layer.length; ++n) {
                    if (this.layer[n] == null) continue;
                    this.layer[n].releaseLayer();
                    this.layer[n] = null;
                }
            }
            if (this.stateAniList != null) {
                this.stateAniList = null;
            }
            this.collsionSpritesNameUseLength = 0;
            if (this.ani_mgr != null) {
                this.ani_mgr.releaseAllAnimation();
                this.ani_mgr = null;
            }
        }
        catch (Exception exception) {
            System.out.println("e= " + exception.toString());
        }
    }
}

