/*
 * Decompiled with CFR 0.152.
 */
public class AnimationMgr {
    private static final int A_FLAG_BOX = 1;
    protected static final int SEQ_FRM_IDX_MASK = 4095;
    protected static final int FRM_BLK_FLAG_MASK = 3;
    protected static final int SEQ_FRM_DURATION_SHIFT_BIT = 12;
    protected static final int FRM_BLK_XOFF_SHIFT_BIT = 2;
    private String aniFile;
    protected ImageMgr imgMgr;
    protected short[][] sequences;
    protected short[][] frames;
    protected short[][] frmBodyBox;
    protected short[][] frmCollideBox;
    protected short[][] seqBox;

    public AnimationMgr(String string) {
        this.aniFile = string;
        this.imgMgr = new ImageMgr("i", "p", "d");
    }

    public AnimationMgr(String string, ImageMgr imageMgr) {
        this.aniFile = string;
        this.imgMgr = imageMgr;
    }

    public int getAnimationCount() {
        return this.sequences == null ? 0 : this.sequences.length;
    }

    public void loadAnimationInfo() {
        try {
            int n;
            int n2;
            int n3;
            PlatformResource platformResource = Platform.getResource("/" + this.aniFile);
            int n4 = platformResource.readInt();
            int n5 = platformResource.readShort();
            short s = platformResource.readShort();
            if (this.frames == null) {
                this.frames = new short[s][];
            }
            byte[] byArray = new byte[s + 7 >> 3];
            int n6 = 0;
            for (n3 = 0; n3 < n5; ++n3) {
                n6 = platformResource.readByte() & 0xFF;
                if (this.seqBox[n3] == null) {
                    platformResource.skipBytes(n6 * 2);
                    continue;
                }
                this.sequences[n3] = new short[n6];
                for (n2 = 0; n2 < n6; ++n2) {
                    this.sequences[n3][n2] = platformResource.readShort();
                    n = this.sequences[n3][n2] & 0xFFF;
                    int n7 = n >> 3;
                    byArray[n7] = (byte)(byArray[n7] | 1 << (n & 7));
                }
            }
            n = 0;
            if ((n4 & 1) != 0) {
                if (this.frmBodyBox == null) {
                    this.frmBodyBox = new short[s][];
                    this.frmCollideBox = new short[s][];
                }
                int n8 = 0;
                for (n3 = 0; n3 < s; ++n3) {
                    if ((byArray[n3 >> 3] >> (n3 & 7) & 1) == 0) {
                        platformResource.skipBytes((platformResource.readByte() & 0xFF) * 6);
                        platformResource.skipBytes((platformResource.readByte() & 0xFF) << 3);
                        platformResource.skipBytes((platformResource.readByte() & 0xFF) << 3);
                        continue;
                    }
                    n = platformResource.readByte() & 0xFF;
                    this.frames[n3] = new short[n * 3];
                    n2 = 0;
                    while (n2 < this.frames[n3].length) {
                        this.frames[n3][n2] = platformResource.readShort();
                        this.imgMgr.addLoadImgId(this.frames[n3][n2++]);
                        this.frames[n3][n2++] = platformResource.readShort();
                        this.frames[n3][n2++] = platformResource.readShort();
                    }
                    n8 = platformResource.readByte() & 0xFF;
                    if (n8 > 0) {
                        this.frmBodyBox[n3] = new short[n8 << 2];
                        for (n2 = 0; n2 < this.frmBodyBox[n3].length; ++n2) {
                            this.frmBodyBox[n3][n2] = platformResource.readShort();
                        }
                    }
                    if ((n8 = platformResource.readByte() & 0xFF) <= 0) continue;
                    this.frmCollideBox[n3] = new short[n8 << 2];
                    for (n2 = 0; n2 < this.frmCollideBox[n3].length; ++n2) {
                        this.frmCollideBox[n3][n2] = platformResource.readShort();
                    }
                }
            } else {
                for (n3 = 0; n3 < s; ++n3) {
                    if ((byArray[n3 >> 3] >> (n3 & 7) & 1) == 0) {
                        platformResource.skipBytes((platformResource.readByte() & 0xFF) * 6);
                        continue;
                    }
                    n = platformResource.readByte() & 0xFF;
                    this.frames[n3] = new short[n * 3];
                    n2 = 0;
                    while (n2 < this.frames[n3].length) {
                        this.frames[n3][n2] = platformResource.readShort();
                        this.imgMgr.addLoadImgId(this.frames[n3][n2++]);
                        this.frames[n3][n2++] = platformResource.readShort();
                        this.frames[n3][n2++] = platformResource.readShort();
                    }
                }
            }
            byArray = null;
            platformResource.close();
            platformResource = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.gc();
    }

    public void setRealizeCnt(int n) {
        this.imgMgr.setCallCnt(n);
    }

    public boolean realizeAnimations() {
        if (!this.imgMgr.loadImgs()) {
            return false;
        }
        for (int i = this.seqBox.length - 1; i >= 0; --i) {
            if (this.seqBox[i] == null || this.seqBox[i][0] != 0 || this.seqBox[i][1] != 0 || this.seqBox[i][2] != 0 || this.seqBox[i][3] != 0) continue;
            this.initAniBox(i);
        }
        return true;
    }

    public Animation loadAnimation(Sprites sprites, int n) {
        return this.loadAnimation(sprites, n, true);
    }

    public Animation loadAnimation(Sprites sprites, int n, boolean bl) {
        if (this.seqBox[n] == null) {
            this.seqBox[n] = new short[4];
        }
        return new Animation(sprites, this, n, bl);
    }

    public void releaseAnimation(int n) {
        for (int i = 0; i < this.sequences[n].length; ++i) {
            int n2 = this.sequences[n][i] & 0xFFF;
            for (int j = 0; j < this.frames[n2].length; j += 3) {
                this.imgMgr.releaseImage(this.frames[n2][j]);
            }
            this.frames[n2] = new short[0];
            if (this.frmBodyBox != null) {
                this.frmBodyBox[n2] = null;
            }
            if (this.frmCollideBox == null) continue;
            this.frmCollideBox[n2] = null;
        }
        this.sequences[n] = new short[0];
        this.seqBox[n] = null;
    }

    public void releaseAllAnimation() {
        int n;
        if (this.seqBox == null) {
            return;
        }
        for (n = this.seqBox.length - 1; n >= 0; --n) {
            this.seqBox[n] = null;
            this.sequences[n] = null;
        }
        if (this.frames != null) {
            for (n = this.frames.length - 1; n >= 0; --n) {
                this.frames[n] = null;
            }
        }
        this.imgMgr.releaseAllImages();
    }

    protected void initAniBox(int n) {
        short s;
        int n2 = Integer.MAX_VALUE;
        int s2 = Integer.MAX_VALUE;
        int n3 = -2147483647;
        int n4 = -2147483647;
        for (int i = this.sequences[n].length - 1; i >= 0; --i) {
            int n5 = this.sequences[n][i] & 0xFFF;
            if (this.frames[n5] == null) continue;
            short[] sArray = this.frames[n5];
            int n6 = 0;
            while (n6 < sArray.length) {
                int n7;
                short s3;
                int n8;
                short s4;
                if (this.imgMgr.imgs[s4 = sArray[n6++]] == null) {
                    n6 += 2;
                    continue;
                }
                if ((n8 = sArray[n6++] >> 2) < n2) {
                    n2 = n8;
                }
                if ((s3 = sArray[n6++]) < s) {
                    s = s3;
                }
                if ((n7 = n8 + this.imgMgr.imgs[s4].getWidth()) > n3) {
                    n3 = n7;
                }
                if ((n7 = s3 + this.imgMgr.imgs[s4].getHeight()) <= n4) continue;
                n4 = n7;
            }
        }
        this.seqBox[n][0] = (short)n2;
        this.seqBox[n][1] = s;
        this.seqBox[n][2] = (short)n3;
        this.seqBox[n][3] = (short)n4;
    }

    public void init() {
        this.imgMgr.init();
        try {
            PlatformResource platformResource = Platform.getResource("/" + this.aniFile);
            platformResource.skipBytes(4);
            short s = platformResource.readShort();
            this.sequences = new short[s][];
            this.seqBox = new short[s][];
            platformResource.close();
            platformResource = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.gc();
    }
}

