/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class PlatformGraphics {
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    Graphics g;
    private PlatformImage image;
    public static final int TRANS_FLIP_X = 2;
    public static final int TRANS_FLIP_Y = 1;

    protected PlatformGraphics() {
    }

    protected PlatformGraphics(Graphics graphics) {
        this.g = graphics;
    }

    protected PlatformGraphics(PlatformImage platformImage) {
        this.image = platformImage;
        this.g = platformImage.image.getGraphics();
    }

    public PlatformImage getImage() {
        return this.image;
    }

    public int getClipX() {
        return this.g.getClipX();
    }

    public int getClipY() {
        return this.g.getClipY();
    }

    public int getClipWidth() {
        return this.g.getClipWidth();
    }

    public int getClipHeight() {
        return this.g.getClipHeight();
    }

    public int getTranslateX() {
        return this.g.getTranslateX();
    }

    public int getTranslateY() {
        return this.g.getTranslateY();
    }

    public void drawImage(PlatformImage platformImage, int n, int n2, int n3) {
        this.g.drawImage(platformImage.image, n, n2, n3);
    }

    public void drawRegion(PlatformImage platformImage, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = this.g.getClipX();
        int n10 = this.g.getClipY();
        int n11 = this.g.getClipWidth();
        int n12 = this.g.getClipHeight();
        if ((n5 = this.remapTransform(n5)) == 0) {
            if ((n8 & 1) != 0) {
                n6 -= n3 / 2;
            } else if ((n8 & 8) != 0) {
                n6 -= n3;
            }
            if ((n8 & 2) != 0) {
                n7 -= n4 / 2;
            } else if ((n8 & 0x20) != 0) {
                n7 -= n4;
            }
            this.g.setClip(n6, n7, n3, n4);
            this.g.drawImage(platformImage.image, n6 - n, n7 - n2, 20);
            this.g.setClip(n9, n10, n11, n12);
            return;
        }
        this.g.drawRegion(platformImage.image, n, n2, n3, n4, n5, n6, n7, n8);
    }

    private final int remapTransform(int n) {
        switch (n) {
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 3;
            }
        }
        return 0;
    }

    public void drawRGB(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        this.g.drawRGB(nArray, n, n2, n3, n4, n5, n6, bl);
    }

    public void setColor(int n) {
        this.g.setColor(n);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.drawArc(n, n2, n3, n4, n5, n6);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.g.drawLine(n, n2, n3, n4);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.g.drawRect(n, n2, n3, n4);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.g.fillRect(n, n2, n3, n4);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.fillArc(n, n2, n3, n4, n5, n6);
    }

    public void fillTriangle(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.fillTriangle(n, n2, n3, n4, n5, n6);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.g.setClip(n, n2, n3, n4);
    }

    public void translate(int n, int n2) {
        this.g.translate(n, n2);
    }

    public void drawString(int n, String string, int n2, int n3, int n4) {
        this.g.setFont(Platform.systemFonts[n]);
        this.g.drawString(string, n2, n3, n4);
    }

    public void drawChars(int n, char[] cArray, int n2, int n3, int n4, int n5, int n6) {
        this.g.setFont(Platform.systemFonts[n]);
        this.g.drawChars(cArray, n2, n3, n4, n5, n6);
    }
}

