/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Platform {
    public static final boolean LOG = false;
    public static final boolean DEBUG = false;
    public static final boolean ASSERT = false;
    public static final int IMAGE_FORMAT_PNG = 0;
    public static final int IMAGE_FORMAT_JPG = 1;
    public static final int TRANSFORM_NONE = 0;
    public static final int TRANS_FLIP_X = 2;
    public static final int TRANS_FLIP_Y = 1;
    public static final int TRANS_ROTATE_90 = 5;
    public static final int TRANS_ROTATE_180 = 3;
    public static final int TRANS_ROTATE_270 = 6;
    public static final int SOUND_FORMAT_MIDI = 0;
    public static final int SOUND_FORMAT_WAV = 1;
    public static final int SOUND_FORMAT_AMR = 2;
    public static final int SOUND_FORMAT_OGG = 3;
    public static final int SOUND_FORMAT_MP3 = 4;
    public static final int SOUND_FORMAT_AAC = 5;
    private static final int BEEP_NOTE = 69;
    public static final int KEY_NUM0 = 1;
    public static final int KEY_NUM1 = 2;
    public static final int KEY_NUM2 = 3;
    public static final int KEY_NUM3 = 4;
    public static final int KEY_NUM4 = 5;
    public static final int KEY_NUM5 = 6;
    public static final int KEY_NUM6 = 7;
    public static final int KEY_NUM7 = 8;
    public static final int KEY_NUM8 = 9;
    public static final int KEY_NUM9 = 10;
    public static final int KEY_STAR = 11;
    public static final int KEY_POUND = 12;
    public static final int KEY_CLEAR = 13;
    public static final int KEY_LEFT_SOFT = 14;
    public static final int KEY_RIGHT_SOFT = 15;
    public static final int KEY_CENTER_SOFT = 16;
    public static final int KEY_UP_ARROW = 17;
    public static final int KEY_DOWN_ARROW = 18;
    public static final int KEY_LEFT_ARROW = 19;
    public static final int KEY_RIGHT_ARROW = 20;
    public static final int FONT_SMALL_PLAIN = 0;
    public static final int FONT_SMALL_BOLD = 1;
    public static final int FONT_MEDIUM_PLAIN = 2;
    public static final int FONT_MEDIUM_BOLD = 3;
    public static final int FONT_LARGE_PLAIN = 4;
    public static final int FONT_LARGE_BOLD = 5;
    static Graphics g;
    static final PlatformGraphics displayGraphics;
    static Font[] systemFonts;
    static final String RMS_NAME = "RMS";
    private static int debugLogCounter;

    static void init() {
        systemFonts = new Font[6];
        Platform.systemFonts[0] = Font.getFont((int)0, (int)0, (int)8);
        Platform.systemFonts[1] = Font.getFont((int)0, (int)1, (int)8);
        Platform.systemFonts[2] = Font.getFont((int)0, (int)0, (int)0);
        Platform.systemFonts[3] = Font.getFont((int)0, (int)1, (int)0);
        Platform.systemFonts[4] = Font.getFont((int)0, (int)0, (int)16);
        Platform.systemFonts[5] = Font.getFont((int)0, (int)1, (int)16);
    }

    public static void exit() {
        PlatformCanvas.instance.exit();
    }

    public static void gc() {
        System.gc();
    }

    public int freeMemory() {
        return (int)Runtime.getRuntime().freeMemory();
    }

    public static void beep() {
        try {
            Manager.playTone((int)69, (int)500, (int)100);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void alert(String string) {
        Alert alert = new Alert("License: ");
        alert.setString(string);
        alert.setType(AlertType.INFO);
        alert.setTimeout(-2);
        alert.setCommandListener(new CommandListener(){

            public void commandAction(Command command, Displayable displayable) {
                PlatformMIDlet.display.setCurrent((Displayable)PlatformMIDlet.canvas);
            }
        });
        Display display = PlatformMIDlet.display;
        display.setCurrent((Displayable)alert);
        try {
            do {
                Thread.sleep(1000L);
            } while (display.getCurrent() != PlatformMIDlet.canvas);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void vibrate(int n) {
        PlatformMIDlet.display.vibrate(n);
    }

    public static void sleep(int n) {
        if (n <= 0) {
            Thread.yield();
        } else {
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static long clock() {
        return System.currentTimeMillis();
    }

    public static void arraycopy(Object object, int n, Object object2, int n2, int n3) {
        System.arraycopy(object, n, object2, n2, n3);
    }

    public static String getLocale() {
        return System.getProperty("microedition.locale");
    }

    public static String getManifestProperty(String string) {
        return PlatformMIDlet.instance.getAppProperty(string);
    }

    public static String getAppVersion() {
        return Platform.getManifestProperty("MIDlet-Version");
    }

    public static boolean getAppDemoEnable() {
        return false;
    }

    public static int getAction(int n) {
        return n;
    }

    public static void setLabels(String string, String string2) {
    }

    public static void openURL(String string) {
        PlatformSound.stopAllSounds();
        try {
            PlatformMIDlet.instance.platformRequest(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Platform.sleep(300);
        PlatformMIDlet.instance.destroyApp(true);
    }

    public static PlatformResource openConnection(String string) {
        try {
            DataInputStream dataInputStream = Connector.openDataInputStream((String)string);
            return new PlatformResource(dataInputStream);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static PlatformResource getResource(String string) {
        InputStream inputStream = ((Object)((Object)PlatformMIDlet.instance)).getClass().getResourceAsStream(string);
        if (inputStream == null) {
            return null;
        }
        return new PlatformResource(new DataInputStream(inputStream));
    }

    public static byte[] readRecord(int n) {
        byte[] byArray = Platform.readRecordStore(RMS_NAME + n, 0);
        return byArray;
    }

    public static void writeRecord(int n, byte[] byArray, int n2) {
        try {
            Platform.writeRecordStore(RMS_NAME + n, 0, byArray, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void deleteRecordStore(int n) {
        Platform.deleteRecordStore(RMS_NAME + n);
    }

    private static void deleteRecordStore(String string) {
        try {
            RecordStore.deleteRecordStore((String)string);
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readRecordStore(String string, int n) {
        block17: {
            byte[] byArray;
            RecordStore recordStore = null;
            try {
                byte[] byArray2;
                recordStore = RecordStore.openRecordStore((String)string, (boolean)false);
                int n2 = recordStore.getNumRecords();
                if (n2 < n + 1) {
                    byte[] byArray3 = null;
                    return byArray3;
                }
                byArray = byArray2 = recordStore.getRecord(1 + n);
            }
            catch (Exception exception) {
                if (recordStore != null) {
                    // empty if block
                }
                break block17;
            }
            finally {
                if (recordStore != null) {
                    try {
                        recordStore.closeRecordStore();
                    }
                    catch (RecordStoreException recordStoreException) {}
                }
            }
            return byArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRecordStore(String string, int n, byte[] byArray, int n2) {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)string, (boolean)true);
            int n3 = recordStore.getNumRecords();
            int n4 = n + 1;
            if (n3 < n4) {
                int n5 = n4 - n3 - 1;
                for (int i = 0; i < n5; ++i) {
                    recordStore.addRecord(byArray, 0, 1);
                }
                recordStore.addRecord(byArray, 0, n2);
            } else {
                recordStore.setRecord(1 + n, byArray, 0, n2);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (recordStore != null) {
                    recordStore.closeRecordStore();
                }
            }
            catch (RecordStoreException recordStoreException) {}
        }
    }

    public static PlatformSound createSound(int n, byte[] byArray) {
        Platform.assertTrue(n >= 0 && n <= 5);
        return new Sound_MM_API(n, byArray);
    }

    public static PlatformSound createSound(int n, String string) {
        Platform.assertTrue(n >= 0 && n <= 5);
        return new Sound_MM_API(n, string);
    }

    public static PlatformGraphics getDisplayGraphics() {
        return displayGraphics;
    }

    public static int getDisplayWidth() {
        return PlatformCanvas.canvasWidth;
    }

    public static int getDisplayHeight() {
        return PlatformCanvas.canvasHeight;
    }

    public static PlatformImage createImage(int n, byte[] byArray, int n2, int n3) {
        Image image = Image.createImage((byte[])byArray, (int)n2, (int)n3);
        return new PlatformImage(image);
    }

    public static PlatformImage createImage(int n, String string) {
        Image image = Platform.loadSingleImage(string);
        return image == null ? null : new PlatformImage(image);
    }

    private static Image loadSingleImage(String string) {
        InputStream inputStream = ((Object)((Object)PlatformMIDlet.instance)).getClass().getResourceAsStream(string);
        if (inputStream == null) {
            return null;
        }
        return Platform.loadSingleImage(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image loadSingleImage(InputStream inputStream) {
        try {
            Image image = Image.createImage((InputStream)inputStream);
            Platform.sleep(50);
            Image image2 = image;
            return image2;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static PlatformImage createTransformImage(PlatformImage platformImage, int n) {
        Image image = Image.createImage((Image)platformImage.image, (int)0, (int)0, (int)platformImage.getWidth(), (int)platformImage.getHeight(), (int)2);
        return new PlatformImage(image);
    }

    public static PlatformImage createOffscreenImage(int n, int n2) {
        PlatformImage platformImage = new PlatformImage(Image.createImage((int)n, (int)n2));
        platformImage.mutable = true;
        return platformImage;
    }

    public static PlatformImage createRGBImage(int[] nArray, int n, int n2, boolean bl) {
        return new PlatformImage(Image.createRGBImage((int[])nArray, (int)n, (int)n2, (boolean)bl));
    }

    public static void redraw() {
        PlatformCanvas.repaintRequest = true;
    }

    public static int getFontHeight(int n) {
        Font font = systemFonts[n];
        return font.getHeight();
    }

    public static int getFontAscent(int n) {
        Font font = systemFonts[n];
        return font.getBaselinePosition();
    }

    public static int getFontDescent(int n) {
        Font font = systemFonts[n];
        return font.getHeight() - font.getBaselinePosition();
    }

    public static int getFontTextWidth(int n, String string) {
        Font font = systemFonts[n];
        return font.stringWidth(string);
    }

    public static int getFontTextWidth(int n, char[] cArray, int n2, int n3) {
        Font font = systemFonts[n];
        return font.charsWidth(cArray, n2, n3);
    }

    public static void debuglog(String string) {
    }

    static void debuglog(String string, Throwable throwable) {
    }

    public static void assertTrue(boolean bl, String string) {
    }

    public static void assertTrue(boolean bl) {
        Platform.assertTrue(bl, null);
    }

    public static void assertFalse(boolean bl) {
        Platform.assertTrue(!bl, null);
    }

    public static void assertFalse(boolean bl, String string) {
        Platform.assertTrue(!bl, string);
    }

    public static boolean checkDiskSpace() {
        return true;
    }

    static {
        displayGraphics = new PlatformGraphics();
        debugLogCounter = 0;
    }
}

