/*
 * Decompiled with CFR 0.152.
 */
public class Layer {
    public static int MAX_SPRITES_SCREEN = 25;
    public Sprites[] allLayerSprites;
    public Sprites[] currentLayerViewPortSprites = new Sprites[MAX_SPRITES_SCREEN];
    int allLayerSpritesLength = 0;
    int currectLayerViewPortSpritesLength = 0;
    int layerMapLength = 0;
    public Map[] layerMaps;
    public Container _st;
    public int layerId;
    public String layerName;
    public PlatformImage[] img;
    public int imgLength = 0;
    public boolean updateCurrectViewPort = false;
    public static final int USE_SPRITES_SINGLE = 0;
    public boolean layerInControl;
    public Sprites[] allControlSpritesInLayer;
    int allControlSpritesLength = 0;
    public boolean active;
    public int lastViewPortX = -1;
    public int lastViewPortY = -1;
    int lastCurrectSpritesNum = 0;
    public int viewPortWidth;
    public int viewPortHeight;
    private TriggerManager tm;

    public Layer(Container container, int n, String string, int n2, int n3, int n4) {
        this._st = container;
        this.layerId = n;
        this.layerName = string;
        if (n2 > 0) {
            this.allLayerSprites = new Sprites[n2];
            this.allControlSpritesInLayer = new Sprites[this.allLayerSprites.length];
        }
        if (n3 > 0) {
            this.layerMaps = new Map[n3];
        }
        if (n4 > 0) {
            this.img = new PlatformImage[n4];
        }
        this.layerInControl = false;
        this.active = true;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public void releaseLayer() {
        try {
            int n;
            if (this.allLayerSprites != null) {
                for (n = 0; n < this.allLayerSprites.length; ++n) {
                    if (this.allLayerSprites[n] != null) {
                        this.allLayerSprites[n].releaseSprites();
                    }
                    this.allLayerSprites[n] = null;
                }
                this.allLayerSprites = null;
            }
            if (this.layerMaps != null) {
                for (n = 0; n < this.layerMaps.length; ++n) {
                    if (this.layerMaps[n] != null) {
                        this.layerMaps[n].releasMapResource();
                    }
                    this.layerMaps[n] = null;
                }
                this.layerMaps = null;
            }
            if (this.img != null) {
                for (n = 0; n < this.img.length; ++n) {
                    if (this.img[n] == null) continue;
                    this.img[n] = null;
                }
                this.img = null;
                this.imgLength = 0;
            }
            for (n = 0; n < this.currentLayerViewPortSprites.length; ++n) {
                if (this.currentLayerViewPortSprites[n] == null) continue;
                this.currentLayerViewPortSprites[n] = null;
            }
            this.currentLayerViewPortSprites = null;
            this.currectLayerViewPortSpritesLength = 0;
            for (n = 0; n < this.allControlSpritesLength; ++n) {
                if (this.allControlSpritesInLayer[n] == null) continue;
                this.allControlSpritesInLayer[n] = null;
            }
            this.allControlSpritesInLayer = null;
            this.currectLayerViewPortSpritesLength = 0;
            this.lastViewPortX = -1;
            this.lastViewPortY = -1;
            this.lastCurrectSpritesNum = 0;
        }
        catch (Exception exception) {
            System.out.println("ex = " + exception.toString());
        }
    }

    public void update() {
        if (this.tm != null) {
            this.tm.triggerCollision();
        }
    }

    public TriggerManager getTriggerManager() {
        return this.tm;
    }

    public void creatTrigerManager(int n, int[][] nArray, int[] nArray2, String[] stringArray) {
        this.tm = new TriggerManager(this);
        this.tm.initTrigger(n, nArray, nArray2, stringArray);
    }

    public void changeViewPortSprites(int n, int n2, int n3, int n4) {
        try {
            int n5;
            for (n5 = 0; n5 < this.allLayerSpritesLength; ++n5) {
                this.allLayerSprites[n5].timerUpdate();
            }
            if (this.lastViewPortX != n || this.lastViewPortY != n2 || this.updateCurrectViewPort) {
                if (this.updateCurrectViewPort) {
                    this.updateCurrectViewPort = false;
                }
                for (n5 = 0; n5 < this.currentLayerViewPortSprites.length; ++n5) {
                    this.currentLayerViewPortSprites[n5] = null;
                }
                this.currectLayerViewPortSpritesLength = 0;
                this.lastCurrectSpritesNum = 0;
                if (this.allLayerSprites != null) {
                    for (n5 = 0; n5 < this.allLayerSprites.length; ++n5) {
                        if (this.allLayerSprites[n5] == null) continue;
                        if (!this.allLayerSprites[n5].isDead()) {
                            this.allLayerSprites[n5].setDraw(n, n2, n3, n4);
                        }
                        if (this.lastCurrectSpritesNum >= MAX_SPRITES_SCREEN || !this.allLayerSprites[n5].isDraw()) continue;
                        this.currentLayerViewPortSprites[this.lastCurrectSpritesNum] = this.allLayerSprites[n5];
                        ++this.lastCurrectSpritesNum;
                        ++this.currectLayerViewPortSpritesLength;
                    }
                }
                this.lastViewPortX = n;
                this.lastViewPortY = n2;
            }
            this.viewPortWidth = n3;
            this.viewPortHeight = n4;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void render(PlatformGraphics platformGraphics) {
        try {
            if (this.active) {
                int n;
                for (n = 0; n < this.layerMapLength; ++n) {
                    if (this.layerMaps[n] == null) continue;
                    this.layerMaps[n].render(platformGraphics);
                }
                for (n = 0; n < this.currentLayerViewPortSprites.length; ++n) {
                    if (this.currentLayerViewPortSprites[n] == null) continue;
                    this.currentLayerViewPortSprites[n].render(platformGraphics);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean addSprites(Sprites sprites) {
        if (this.allLayerSprites == null) {
            return true;
        }
        boolean bl = this.isHaveSprites(sprites.getSpritesName());
        if (this.allLayerSpritesLength < this.allLayerSprites.length && !bl) {
            sprites.setLayer(this);
            this.allLayerSprites[this.allLayerSpritesLength] = sprites;
            if (this.allLayerSprites[this.allLayerSpritesLength].isRegisterKeyContrl()) {
                this.allControlSpritesInLayer[this.allControlSpritesLength] = this.allLayerSprites[this.allLayerSpritesLength];
                ++this.allControlSpritesLength;
            }
            if (this.allLayerSprites[this.allLayerSpritesLength].isDraw() && this.currectLayerViewPortSpritesLength < MAX_SPRITES_SCREEN) {
                this.currentLayerViewPortSprites[this.currectLayerViewPortSpritesLength] = this.allLayerSprites[this.allLayerSpritesLength];
                ++this.currectLayerViewPortSpritesLength;
            }
            ++this.allLayerSpritesLength;
        }
        return bl;
    }

    public boolean isHaveSprites(String string) {
        for (int i = 0; i < this.allLayerSpritesLength; ++i) {
            if (!this.allLayerSprites[i].getSpritesName().equals(string) || this.allLayerSprites[i] == null) continue;
            return true;
        }
        return false;
    }

    public Sprites getSpritesInLayerByName(String string) {
        int n;
        for (n = 0; n < this.currectLayerViewPortSpritesLength; ++n) {
            if (!this.currentLayerViewPortSprites[n].getSpritesName().equals(string) && this.currentLayerViewPortSprites[n].getSpritesName() != string) continue;
            return this.currentLayerViewPortSprites[n];
        }
        for (n = 0; n < this.allLayerSpritesLength; ++n) {
            if (!this.allLayerSprites[n].getSpritesName().equals(string) && this.allLayerSprites[n].getSpritesName() != string) continue;
            return this.allLayerSprites[n];
        }
        return null;
    }

    public void addMap(Map map) {
        if (this.layerMaps != null && this.layerMapLength < this.layerMaps.length) {
            this.layerMaps[this.layerMapLength] = map;
            ++this.layerMapLength;
        }
    }

    public void removeMap(String string) {
        for (int i = 0; i < this.layerMapLength; ++i) {
            if (!this.layerMaps[i].mapName.equals(string)) continue;
            this.layerMaps[i] = null;
            --this.layerMapLength;
        }
    }

    public void addImage(PlatformImage platformImage) {
        if (this.img != null && this.imgLength < this.img.length) {
            this.img[this.imgLength] = platformImage;
            ++this.imgLength;
        }
    }

    public void removeImage(int n) {
        if (this.img != null && n < this.imgLength) {
            this.img[n] = null;
            if (n != this.imgLength - 1) {
                System.arraycopy(this.img, n + 1, this.img, 1, this.imgLength - 1 - n);
            }
            --this.imgLength;
        }
    }

    public void removeAllImage() {
        if (this.img != null) {
            for (int i = 0; i < this.img.length; ++i) {
                if (this.img[i] == null) continue;
                this.img[i] = null;
            }
            this.imgLength = 0;
        }
    }

    public void removeSprites(String string) {
        int n = 0;
        for (int i = 0; i < this.allLayerSpritesLength; ++i) {
            if (this.allLayerSprites[i].getSpritesName() != string && !this.allLayerSprites[i].getSpritesName().equals(string)) continue;
            if (this.allLayerSprites[i].isRegisterKeyContrl()) {
                for (int j = 0; j < this.allControlSpritesLength; ++j) {
                    if (!this.allControlSpritesInLayer[j].getSpritesName().equals(string)) continue;
                    if (this.allControlSpritesInLayer[j] != null) {
                        this.allControlSpritesInLayer[j].releaseSprites();
                        this.allControlSpritesInLayer[j] = null;
                    }
                    if (j != this.allLayerSpritesLength - 1) {
                        System.arraycopy(this.allControlSpritesInLayer, j + 1, this.allControlSpritesInLayer, j, this.allLayerSpritesLength - i);
                    }
                    --this.allControlSpritesLength;
                    break;
                }
            }
            if (this.allLayerSprites[i] != null) {
                this.allLayerSprites[i].releaseSprites();
                this.allLayerSprites[i] = null;
            }
            n = i;
            try {
                if (n != this.allLayerSpritesLength - 1) {
                    System.arraycopy(this.allLayerSprites, i + 1, this.allLayerSprites, i, this.allLayerSpritesLength - i);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            --this.allLayerSpritesLength;
            this.updateCurrectViewPort = true;
            break;
        }
    }

    public void checkCollision() {
        try {
            int n = this.allControlSpritesLength;
            int n2 = this.currectLayerViewPortSpritesLength;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (this.currentLayerViewPortSprites[j].isControl() || this.allControlSpritesInLayer[i] == this.currentLayerViewPortSprites[j] || !Utils.rectCollision2(this.allControlSpritesInLayer[i].getCollsionX(), this.allControlSpritesInLayer[i].getCollsionY(), this.allControlSpritesInLayer[i].getCollsionWidth(), this.allControlSpritesInLayer[i].getCollsionHeight(), this.currentLayerViewPortSprites[j].getCollsionX(), this.currentLayerViewPortSprites[j].getCollsionY(), this.currentLayerViewPortSprites[j].getCollsionWidth(), this.currentLayerViewPortSprites[j].getCollsionHeight())) continue;
                    EventManager.sendEvent(0, 0x20000001, 0, this._st, this.allControlSpritesInLayer[i], this.currentLayerViewPortSprites[j]);
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
    }

    public void checkCollision2() {
        try {
            int n = this.allControlSpritesLength;
            int n2 = this.currectLayerViewPortSpritesLength;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    if (this.currentLayerViewPortSprites[j].isControl() || this.allControlSpritesInLayer[i] == this.currentLayerViewPortSprites[j]) continue;
                    for (int k = 0; k < this.allControlSpritesInLayer[i].collsionRect[this.allControlSpritesInLayer[i].getCurrectState()][this.allControlSpritesInLayer[i].getCurrentFrameIndex()].rectCount; ++k) {
                        for (int i2 = 0; i2 < this.currentLayerViewPortSprites[i].collsionRect[this.currentLayerViewPortSprites[i].getCurrectState()][this.currentLayerViewPortSprites[i].getCurrentFrameIndex()].rectCount; ++i2) {
                            if (!Utils.rectCollision2(this.allControlSpritesInLayer[i].collsionRect[this.allControlSpritesInLayer[i].getCurrectState()][this.allControlSpritesInLayer[i].getCurrentFrameIndex()].collsionOpposeRect[k * 4], this.allControlSpritesInLayer[i].collsionRect[this.allControlSpritesInLayer[i].getCurrectState()][this.allControlSpritesInLayer[i].getCurrentFrameIndex()].collsionOpposeRect[k * 4 + 1], this.allControlSpritesInLayer[i].collsionRect[this.allControlSpritesInLayer[i].getCurrectState()][this.allControlSpritesInLayer[i].getCurrentFrameIndex()].collsionOpposeRect[k * 4 + 2], this.allControlSpritesInLayer[i].collsionRect[this.allControlSpritesInLayer[i].getCurrectState()][this.allControlSpritesInLayer[i].getCurrentFrameIndex()].collsionOpposeRect[k * 4 + 3], this.currentLayerViewPortSprites[j].collsionRect[this.currentLayerViewPortSprites[j].getCurrectState()][this.currentLayerViewPortSprites[j].getCurrentFrameIndex()].collsionOpposeRect[i2 * 4], this.currentLayerViewPortSprites[j].collsionRect[this.currentLayerViewPortSprites[j].getCurrectState()][this.currentLayerViewPortSprites[j].getCurrentFrameIndex()].collsionOpposeRect[i2 * 4 + 1], this.currentLayerViewPortSprites[j].collsionRect[this.currentLayerViewPortSprites[j].getCurrectState()][this.currentLayerViewPortSprites[j].getCurrentFrameIndex()].collsionOpposeRect[i2 * 4 + 2], this.currentLayerViewPortSprites[j].collsionRect[this.currentLayerViewPortSprites[j].getCurrectState()][this.currentLayerViewPortSprites[j].getCurrentFrameIndex()].collsionOpposeRect[i2 * 4 + 3])) continue;
                            this.allControlSpritesInLayer[i].setCollsionData(this.allControlSpritesInLayer[i].getCurrectState(), this.allControlSpritesInLayer[i].getCurrentFrameIndex(), k);
                            this.currentLayerViewPortSprites[j].setCollsionData(this.currentLayerViewPortSprites[j].getCurrectState(), this.currentLayerViewPortSprites[j].getCurrentFrameIndex(), i2);
                            EventManager.sendEvent(0, 0x20000002, 0, this._st, this.allControlSpritesInLayer[i], this.currentLayerViewPortSprites[j]);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

