/*
 * Decompiled with CFR 0.152.
 */
package com.hardwire.dymix;

import com.hardwire.dymix.DynamicObject;
import com.hardwire.dymix.PhysicalObject;
import com.hardwire.utils.Vector2;

public final class Spring {
    public PhysicalObject obj1;
    public PhysicalObject obj2;
    private Vector2 localAnchor1;
    private Vector2 localAnchor2;
    private int restLength;
    private int stiffness;
    private int damping;
    private static Vector2 tmpVector = new Vector2();
    private byte constraintType;
    private static int[] aabb = new int[4];
    private static Vector2 absoluteAnchor1 = new Vector2();
    private static Vector2 absoluteAnchor2 = new Vector2();
    private static Vector2 direction = new Vector2();
    private static Vector2 v1 = new Vector2();
    private static Vector2 v2 = new Vector2();

    public Spring(PhysicalObject physicalObject, PhysicalObject physicalObject2, Vector2 vector2, Vector2 vector22, int n, int n2, int n3) {
        this.obj1 = physicalObject;
        this.obj2 = physicalObject2;
        this.localAnchor1 = new Vector2(vector2);
        this.localAnchor2 = new Vector2(vector22);
        this.stiffness = n;
        this.damping = n2;
        this.restLength = n3;
        this.constraintType = 1;
    }

    public final Vector2 getAbsoluteAnchor1() {
        absoluteAnchor1.copy(this.localAnchor1);
        absoluteAnchor1.multiplyWithShift(this.obj1.getOrientation());
        PhysicalObject physicalObject = this.obj1;
        absoluteAnchor1.add(physicalObject.centerPos);
        return absoluteAnchor1;
    }

    public final Vector2 getAbsoluteAnchor2() {
        absoluteAnchor2.copy(this.localAnchor2);
        absoluteAnchor2.multiplyWithShift(this.obj2.getOrientation());
        PhysicalObject physicalObject = this.obj2;
        absoluteAnchor2.add(physicalObject.centerPos);
        return absoluteAnchor2;
    }

    public final void _applyForces() {
        direction.copy(this.getAbsoluteAnchor2());
        direction.subtract(this.getAbsoluteAnchor1());
        if (direction.isNull()) {
            return;
        }
        int n = direction.normaliseWithShift();
        if (this.constraintType == 1 && n < this.restLength || this.constraintType == 2 && n > this.restLength) {
            return;
        }
        v1.copy(this.localAnchor1);
        v1.multiplyWithShift(this.obj1.getOrientation());
        v1.makePerpendicular();
        v1.multiplyWithShift(this.obj1.getAngularVelocity_shifted(), 2);
        v1.add(this.obj1.getLinearVelocity());
        v2.copy(this.localAnchor2);
        v2.multiplyWithShift(this.obj2.getOrientation());
        v2.makePerpendicular();
        v2.multiplyWithShift(this.obj2.getAngularVelocity_shifted(), 2);
        v2.add(this.obj2.getLinearVelocity());
        tmpVector.copy(v2);
        tmpVector.subtract(v1);
        int n2 = tmpVector.dotProductWithShift(direction);
        n = (int)((long)(-this.stiffness) * (long)(n - this.restLength) >> 10);
        Vector2 vector2 = direction;
        vector2.multiplyWithShift(n += (int)((long)(-this.damping) * (long)n2 >> 10));
        if (this.obj2.isDynamic) {
            ((DynamicObject)this.obj2).wakeUp();
            ((DynamicObject)this.obj2).addForceAtPointInLocalCoords(vector2, this.localAnchor2);
        }
        vector2.set(-vector2.x, -vector2.y);
        if (this.obj1.isDynamic) {
            ((DynamicObject)this.obj1).wakeUp();
            ((DynamicObject)this.obj1).addForceAtPointInLocalCoords(vector2, this.localAnchor1);
        }
    }

    public final int[] getBoundingBox() {
        Vector2 vector2 = this.getAbsoluteAnchor1();
        Vector2 vector22 = this.getAbsoluteAnchor2();
        if (vector2.x < vector22.x) {
            Spring.aabb[0] = vector2.x;
            Spring.aabb[2] = vector22.x;
        } else {
            Spring.aabb[0] = vector22.x;
            Spring.aabb[2] = vector2.x;
        }
        if (vector2.y < vector22.y) {
            Spring.aabb[1] = vector2.y;
            Spring.aabb[3] = vector22.y;
        } else {
            Spring.aabb[1] = vector22.y;
            Spring.aabb[3] = vector2.y;
        }
        return aabb;
    }

    public final byte getConstraintType() {
        return this.constraintType;
    }

    public final void setConstraintType(byte by) {
        this.constraintType = by;
    }

    public final int getDamping() {
        return this.damping;
    }

    public final int getRestLength() {
        return this.restLength;
    }

    public final void setRestLength(int n) {
        this.restLength = n;
    }

    public final int getStiffness() {
        return this.stiffness;
    }

    public final Vector2 getLocalAnchor1() {
        return this.localAnchor1;
    }

    public final Vector2 getLocalAnchor2() {
        return this.localAnchor2;
    }
}

