/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Item {
    public int id;
    public byte type;
    private Object data;
    private Object label;
    public int font;
    public int height;
    public int width;
    private boolean visible = true;
    private boolean selectable = true;
    public byte selectedSubItemIndex = 0;
    public Form nextForm;

    public Item(byte by, int n) {
        if (n >= 0) {
            this.data = Controller.msgStrings[n];
        }
        this.type = 0;
        this.font = this.setFontByType();
        this.width = this.getWidth();
        this.height = this.getHeight();
    }

    public Item(byte by, Object object) {
        this.type = by;
        this.data = object;
        this.font = this.setFontByType();
        this.width = this.getWidth();
        this.height = this.getHeight();
    }

    public final void setLabel(Object object) {
        this.label = object;
        this.height = this.getHeight();
    }

    private int setFontByType() {
        switch (this.type) {
            case 0: 
            case 4: {
                return 32;
            }
            case 1: 
            case 2: {
                return 2;
            }
        }
        return 2;
    }

    private int getHeight() {
        int n = 0;
        if (this.visible) {
            if (this.type != 5 && this.label != null) {
                n = Fonts.getFontHeight(0);
            }
            switch (this.type) {
                case 0: {
                    if (this.data instanceof String) {
                        return Fonts.getLineHeight(this.font) + n;
                    }
                    if (!(this.data instanceof String[])) break;
                    return Fonts.getLineHeight(this.font) * ((String[])this.data).length + n;
                }
                case 1: {
                    return Fonts.getLineHeight(this.font) + n;
                }
                case 2: {
                    return Fonts.getLineHeight(this.font) * ((String[])this.data).length + n;
                }
                case 3: {
                    if ((Image)this.data == null) break;
                    return ((Image)this.data).getHeight() + n;
                }
                case 4: {
                    return Fonts.getLineHeight(this.font) + n;
                }
                case 5: {
                    if (this.data == null || this.label == null) break;
                    return Math.max(((Image)this.data).getHeight() + 2, Fonts.getLineHeight(this.font));
                }
                case 6: {
                    return 3;
                }
            }
        }
        return 0;
    }

    private int getWidth() {
        if (this.visible) {
            switch (this.type) {
                case 0: 
                case 4: {
                    if (!(this.data instanceof String)) break;
                    return Fonts.getStringWidth(this.font, (String)this.data);
                }
                case 1: {
                    return Fonts.getStringWidth(this.font, (String)this.data);
                }
                case 2: {
                    break;
                }
                case 3: {
                    if ((Image)this.data != null) {
                        return ((Image)this.data).getWidth();
                    }
                }
                case 5: {
                    if (this.data == null || this.label == null) break;
                    return ((Image)this.data).getWidth() + Fonts.getStringWidth(this.font, (String)this.label);
                }
                case 6: {
                    return this.width;
                }
            }
        }
        return 0;
    }

    public final void paint(Graphics graphics, int n, int n2, int n3) {
        this.paint(graphics, n, n2, n3, 0, 0, 240, 260);
    }

    public final void paint(Graphics stringArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.visible) {
            if (this.type != 5 && this.label != null && this.label instanceof String) {
                Fonts.drawString$6cf53995(this.font, (String)this.label, n, n2, n3);
                n2 += Fonts.getFontHeight(0);
            }
            switch (this.type) {
                case 0: {
                    Fonts.drawString$6cf53995(this.font, (String)this.data, n, n2, n3);
                    return;
                }
                case 1: {
                    Fonts.setFonts(2, 34);
                    Fonts.drawString$6cf53995(this.font, (String)this.data, n, n2, n3);
                    return;
                }
                case 2: {
                    stringArray = (String[])this.data;
                    n4 = Fonts.getLineHeight(this.font);
                    for (n5 = 0; n5 < stringArray.length; ++n5) {
                        Fonts.drawString$6cf53995(this.font, stringArray[n5], n, n2, n3);
                        n2 += n4;
                    }
                    break;
                }
                case 3: {
                    Image image = (Image)this.data;
                    if (image == null) break;
                    stringArray.drawImage(image, n, n2, n3);
                    return;
                }
                case 4: {
                    if (this.data instanceof String[]) {
                        Fonts.drawString$6cf53995(this.font, ((String[])this.data)[this.selectedSubItemIndex], n, n2, n3);
                        return;
                    }
                    if (!(this.data instanceof int[])) break;
                    Fonts.drawString$6cf53995(this.font, Controller.msgStrings[((int[])this.data)[this.selectedSubItemIndex]], n, n2, n3);
                    return;
                }
                case 5: {
                    if ((Image)this.data == null || (String)this.label == null) break;
                    Image image = (Image)this.data;
                    stringArray.drawImage(image, n - (this.width - image.getWidth() >> 1), n2 + (this.height - image.getHeight() >> 1), n3);
                    int n8 = Fonts.getStringWidth(this.font, (String)this.label);
                    Fonts.drawString$6cf53995(this.font, (String)this.label, n + (this.width - n8 >> 1), n2, n3);
                    return;
                }
                case 6: {
                    if (this.data == null) break;
                    stringArray.setColor(((Integer)this.data).intValue());
                    stringArray.drawLine(n - (this.width >> 1), n2, n + (this.width >> 1), n2);
                }
            }
        }
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final void setEnabled(boolean bl) {
        this.selectable = bl;
        if (bl) {
            this.font = 32;
            return;
        }
        this.font = 64;
    }

    public final boolean isEnabled() {
        return this.selectable;
    }

    public final void destroy() {
        this.data = null;
    }

    public final void multiItemChange(int n) {
        if (this.type == 4) {
            if (n == 14) {
                int[] nArray;
                if (this.data instanceof String[]) {
                    this.selectedSubItemIndex = (byte)(this.selectedSubItemIndex + 1);
                    String[] stringArray = (String[])this.data;
                    if (this.selectedSubItemIndex > stringArray.length - 1) {
                        this.selectedSubItemIndex = 0;
                        return;
                    }
                } else if (this.data instanceof int[] && (this.selectedSubItemIndex = (byte)(this.selectedSubItemIndex + 1)) > (nArray = (int[])this.data).length - 1) {
                    this.selectedSubItemIndex = 0;
                    return;
                }
            } else if (n == 12) {
                if (this.data instanceof String[]) {
                    String[] stringArray = (String[])this.data;
                    this.selectedSubItemIndex = (byte)(this.selectedSubItemIndex - 1);
                    if (this.selectedSubItemIndex < 0) {
                        this.selectedSubItemIndex = (byte)(stringArray.length - 1);
                        return;
                    }
                } else if (this.data instanceof int[]) {
                    int[] nArray = (int[])this.data;
                    this.selectedSubItemIndex = (byte)(this.selectedSubItemIndex - 1);
                    if (this.selectedSubItemIndex < 0) {
                        this.selectedSubItemIndex = (byte)(nArray.length - 1);
                    }
                }
            }
        }
    }

    public final boolean hasString(int n) {
        return Controller.getText(n) == this.data;
    }

    public final void setFont(int n) {
        this.font = n;
        this.height = this.getHeight();
    }

    static {
        String[] stringArray = new String[]{"", "II", "IIII", "IIIIII", "IIIIIIII"};
    }
}

