/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;

public final class Script {
    private static Game game;
    private static Script[] scripts;
    private static short[] playingScripts;
    private boolean playing = false;
    private short dataPos = 0;
    private byte[] data;
    private byte loops;
    private byte playedLoops;
    private int lastActionId = -1;
    private long stepDelay = -1L;

    private Script(byte[] byArray) {
        this.data = byArray;
    }

    private void stop() {
        this.playing = false;
        game.scriptStopped();
    }

    public final boolean hasNextAction() {
        return this.dataPos < this.data.length - 1;
    }

    public static void startScript(int n) {
        int n2 = playingScripts.length;
        while (--n2 >= 0) {
            if (playingScripts[n2] != -1) continue;
            Script script = scripts[n];
            scripts[n].playing = true;
            script.dataPos = 0;
            script.playedLoops = 0;
            script.lastActionId = -1;
            game.scriptStarted();
            Script.playingScripts[n2] = (short)n;
            break;
        }
    }

    public static void stopScripts() {
        int n = playingScripts.length;
        while (--n >= 0) {
            short s = playingScripts[n];
            if (s == -1 || !Script.scripts[s].playing) continue;
            scripts[s].stop();
        }
    }

    public static boolean someScriptPlaying() {
        int n = playingScripts.length;
        while (--n >= 0) {
            if (playingScripts[n] == -1 || !Script.scripts[Script.playingScripts[n]].playing) continue;
            return true;
        }
        return false;
    }

    public static Script getPlayingScript(int n) {
        n = playingScripts.length;
        while (--n >= 0) {
            if (playingScripts[n] == -1 || !Script.scripts[Script.playingScripts[n]].playing) continue;
            return scripts[playingScripts[n]];
        }
        return null;
    }

    public static void updateScripts() {
        int n = playingScripts.length;
        while (--n >= 0) {
            short s = playingScripts[n];
            if (s == -1) continue;
            if (Script.scripts[s].playing) {
                Script script = scripts[s];
                if ((script.lastActionId == 2 || script.lastActionId == 1) && !game.isCameraDestinationReached() || script.stepDelay != -1L && script.stepDelay > System.currentTimeMillis() || Script.game.state == 7 || Script.game.state == 8 && Script.game.newState == 7 || Script.game.state != 8 && Script.game.newState == 8) continue;
                if ((script.lastActionId == 2 || script.lastActionId == 1) && game.isCameraDestinationReached() && script.stepDelay < 100L) {
                    script.stepDelay = script.stepDelay * 100L + System.currentTimeMillis();
                    continue;
                }
                if (script.dataPos >= script.data.length - 1 && script.loops != 0 && (script.playedLoops = (byte)(script.playedLoops + 1)) >= script.loops) {
                    script.stop();
                    continue;
                }
                short s2 = script.dataPos;
                script.dataPos = (short)(s2 + 1);
                int n2 = script.data[s2];
                switch (n2) {
                    case 0: {
                        short s3 = script.dataPos;
                        script.dataPos = (short)(s3 + 1);
                        script.stepDelay = script.data[s3] & 0xFF;
                        short s4 = script.dataPos;
                        script.dataPos = (short)(s4 + 1);
                        int n3 = script.data[s4] & 0xFF;
                        short s5 = script.dataPos;
                        script.dataPos = (short)(s5 + 1);
                        int n4 = script.data[s5] & 0xFF;
                        game.showTextbox(n3, n4);
                        script.stepDelay = 0L;
                        break;
                    }
                    case 3: {
                        short s6 = script.dataPos;
                        script.dataPos = (short)(s6 + 1);
                        script.stepDelay = script.data[s6] & 0xFF;
                        short s7 = script.dataPos;
                        script.dataPos = (short)(s7 + 1);
                        int n3 = script.data[s7] & 0xFF;
                        game.showImagebox(n3 + 134);
                        script.stepDelay = 0L;
                        break;
                    }
                    case 1: {
                        short s8 = script.dataPos;
                        script.dataPos = (short)(s8 + 1);
                        script.stepDelay = script.data[s8] & 0xFF;
                        short s9 = script.dataPos;
                        script.dataPos = (short)(s9 + 1);
                        int n3 = script.data[s9] & 0xFF;
                        short s10 = script.dataPos;
                        script.dataPos = (short)(s10 + 1);
                        int n4 = script.data[s10] & 0xFF;
                        n3 = (n3 << 5) + 16;
                        n4 = (n4 << 5) + 16;
                        game.setCameraDestination(n3, n4);
                        break;
                    }
                    case 2: {
                        short s11 = script.dataPos;
                        script.dataPos = (short)(s11 + 1);
                        script.stepDelay = script.data[s11] & 0xFF;
                        short s12 = script.dataPos;
                        short s13 = script.dataPos = (short)(s12 + 1);
                        script.dataPos = (short)(s13 + 1);
                        int n3 = (script.data[s12] & 0xFF) << 16 + (script.data[s13] & 0xFF);
                        short s14 = script.dataPos;
                        short s15 = script.dataPos = (short)(s14 + 1);
                        script.dataPos = (short)(s15 + 1);
                        int n4 = (script.data[s14] & 0xFF) << 16 + (script.data[s15] & 0xFF);
                        game.setCameraDestination(n3, n4);
                        break;
                    }
                    case 4: {
                        short s16 = script.dataPos;
                        script.dataPos = (short)(s16 + 1);
                        script.stepDelay = script.data[s16] & 0xFF;
                        Script.game.cameraIsStatic = true;
                        game.requestStartAction();
                    }
                }
                if (script.stepDelay == 0L) {
                    script.stepDelay = -1L;
                }
                script.lastActionId = n2;
                continue;
            }
            Script.playingScripts[n] = -1;
        }
    }

    public static void init() {
        try {
            DataInputStream dataInputStream = new DataInputStream(((Object)((Object)Main.instance)).getClass().getResourceAsStream("/sc"));
            Script.readDef(dataInputStream);
            dataInputStream.close();
        }
        catch (Exception exception) {}
        int n = playingScripts.length;
        while (--n >= 0) {
            Script.playingScripts[n] = -1;
        }
    }

    public static void setGame(Game game) {
        Script.game = game;
    }

    private static void readDef(DataInputStream dataInputStream) {
        try {
            int n = dataInputStream.readShort();
            scripts = new Script[n];
            for (int i = 0; i < n; ++i) {
                byte by = dataInputStream.readByte();
                dataInputStream.skipBytes(1);
                Object object = new byte[dataInputStream.readUnsignedShort()];
                dataInputStream.readFully((byte[])object);
                object = new Script((byte[])object);
                v0.loops = by;
                Script.scripts[i] = object;
                Controller.updateLoadBar(1);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    static {
        playingScripts = new short[2];
    }
}

