/*
 * Decompiled with CFR 0.152.
 */
import com.hardwire.dymix.Joint;
import com.hardwire.dymix.PhysicalObject;
import com.hardwire.utils.MathUtils;
import com.hardwire.utils.Vector2;
import javax.microedition.lcdui.Graphics;

public final class DummyMan {
    private Game game;
    public byte state;
    public BodyPart[] bodyParts;
    private Joint[] bodyJoints;
    private int[] aabb;
    public int flightCounter;
    private Vector2 initialBodyPosition;
    public static final int[] SCORE_FROM_BONUS = new int[]{10000, 20000, 50000};
    private int scoremulti_oldBodyAngle;
    private int scoremulti_turnAccumulator;
    public boolean scoremulti_alreadyCollided;
    public int scoremulti_numSomersaults;
    public int scoremulti_numHeadOns;
    public int scoremulti_numHelmetFatalities;
    public int scoremulti_numEagles;
    public int scoremulti_numWings;
    public int scoreDamage;
    public int scoreBonus;
    public int scoreDistance;
    public boolean targetHit = false;
    private int animFrameCounter;
    private Vector2 animRefPosition;
    public byte animType;
    private int animNextPose;
    private int animPrevPose;
    private int animNextPosition;
    private static int[][][][] animPoses;
    private static boolean[] animLooping;
    private int[][] animPositions;
    private static Vector2 tmpVector;

    public DummyMan(Game game, Vector2 vector2) {
        int n;
        this.game = game;
        this.state = 0;
        this.bodyParts = new BodyPart[15];
        for (int i = 0; i < BodyPart.HIERARCHY_ORDER.length; ++i) {
            n = BodyPart.HIERARCHY_ORDER[i];
            this.bodyParts[n] = new BodyPart(this.game, this, (byte)n, vector2);
            this.bodyParts[n].forceSleep();
        }
        this.bodyJoints = new Joint[3];
        this.bodyJoints[0] = BodyPart.connectParts(this.bodyParts[6], this.bodyParts[12]);
        this.bodyJoints[1] = BodyPart.connectParts(this.bodyParts[6], this.bodyParts[7]);
        this.bodyJoints[2] = BodyPart.connectParts(this.bodyParts[6], this.bodyParts[9]);
        for (n = 0; n < this.bodyJoints.length; ++n) {
            this.game.world.addJoint(this.bodyJoints[n]);
        }
        this.aabb = new int[4];
        this.recomputeBoundingBox();
        this.flightCounter = 0;
        this.scoremulti_oldBodyAngle = this.bodyParts[6].getAngle_shifted();
        BodyPart bodyPart = this.bodyParts[6];
        this.initialBodyPosition = new Vector2(bodyPart.centerPos);
        this.scoremulti_numSomersaults = 0;
        this.scoremulti_numHeadOns = 0;
        this.scoremulti_numHelmetFatalities = 0;
        this.scoremulti_numEagles = 0;
        this.scoremulti_numWings = 0;
        this.scoremulti_alreadyCollided = false;
        this.scoreDamage = 0;
        this.scoreBonus = 0;
        this.scoreDistance = 0;
    }

    public final int getTotalScore() {
        int n = this.scoreDamage + this.scoreBonus;
        int n2 = this.scoremulti_numSomersaults * 25;
        n2 += this.scoremulti_numEagles * 25;
        n2 += this.scoremulti_numWings * 25;
        n2 += this.scoremulti_numHeadOns * 25;
        n = n * ((n2 += this.scoremulti_numHelmetFatalities * 25) + 100) / 100;
        return n;
    }

    public final void computeDistanceScore() {
        if (this.game.objective_targetObject == null) {
            Vector2 vector2 = this.initialBodyPosition;
            int n = vector2.minus(this.getCenterPosition()).length();
            this.scoreDistance = n * 100 >> 15;
            return;
        }
        Vector2 vector2 = this.game.objective_targetObject.getPosition();
        int n = vector2.minus(this.getCenterPosition()).length();
        this.scoreDistance = 5000 - (n * 1000 >> 15);
        this.scoreDistance = Math.max(0, this.scoreDistance);
    }

    public final void tick() throws Exception {
        Joint joint;
        for (int i = 0; i < this.bodyParts.length; ++i) {
            if (this.bodyParts[i] == null) continue;
            this.bodyParts[i].tick();
        }
        Object object = this;
        if (Game.brutalityOn && ((DummyMan)object).game.craneSpring == null && (joint = ((DummyMan)object).bodyJoints[3]) != null) {
            tmpVector.copy(joint.getAbsoluteAnchor1());
            tmpVector.subtract(joint.getAbsoluteAnchor2());
            long l = tmpVector.length_squared();
            if (l >= 0x19000000L) {
                ((DummyMan)object).game.world.removeJoint(joint);
                ((DummyMan)object).bodyJoints[3] = null;
                ((DummyMan)object).bodyParts[7].userType = 0;
                joint.getAbsoluteAnchor1();
            }
        }
        ++this.flightCounter;
        if (this.state == 4) {
            object = this.bodyParts[6];
            int n = this.initialBodyPosition.y - ((PhysicalObject)object).centerPos.y;
            if (this.scoremulti_numEagles == 0 && n > 98304) {
                this.game.showBonusText((byte)3);
                ++this.scoremulti_numEagles;
            }
            if (this.scoremulti_numWings == 0 && this.flightCounter > 60) {
                this.game.showBonusText((byte)4);
                ++this.scoremulti_numWings;
                return;
            }
        } else if (this.state == 1 && !this.game.actionRunning() && this.animType == 2 && Controller.frameCounter % (447 / Game.FRAME_NUM_PHYSICS_ITERATIONS) == 0) {
            this.resetPosition();
            int n = 3;
            object = this;
            ((DummyMan)object).startAnimation((byte)3, new int[][]{{0, 0, 0}, {Integer.MAX_VALUE, 0, 0}});
        }
    }

    public final boolean hasBodyJoint(Joint joint) {
        for (int i = 0; i < this.bodyJoints.length; ++i) {
            if (this.bodyJoints[i] != joint) continue;
            return true;
        }
        return false;
    }

    public final void postTick() {
        int n;
        int n2;
        for (n2 = 0; n2 < this.bodyParts.length; ++n2) {
            if (this.bodyParts[n2] == null) continue;
            this.bodyParts[n2].postTick();
        }
        if (this.state == 1) {
            DummyMan dummyMan = this;
            ++dummyMan.animFrameCounter;
            n = animPoses[2][animPoses[2].length - 1][0][0];
            int n3 = animLooping[2] ? dummyMan.animFrameCounter % n : dummyMan.animFrameCounter;
            if (n3 > animPoses[2][dummyMan.animNextPose][0][0]) {
                dummyMan.animPrevPose = dummyMan.animNextPose++;
            } else if (animLooping[2] && n3 == n - 1) {
                dummyMan.animNextPose = 0;
            }
            int n4 = dummyMan.animPrevPose;
            int n5 = dummyMan.animNextPose;
            if (animLooping[2] && n5 == animPoses[2].length - 1) {
                n5 = 0;
            }
            if (dummyMan.animFrameCounter >= dummyMan.animPositions[dummyMan.animNextPosition][0]) {
                ++dummyMan.animNextPosition;
            }
            if (dummyMan.animNextPosition >= dummyMan.animPositions.length || !animLooping[2] && dummyMan.animNextPose >= animPoses[2].length) {
                dummyMan.changeState((byte)4);
            } else {
                int[][] nArray = animPoses[2][n4];
                int[][] nArray2 = animPoses[2][n5];
                int n6 = nArray[0][0];
                int n7 = nArray2[0][0];
                if (n5 < n4) {
                    if (n3 < n6) {
                        n6 -= n;
                    } else {
                        n7 += n;
                    }
                }
                n = 0;
                if (n7 != n6) {
                    n = (n3 - n6 << 10) / (n7 - n6);
                }
                int[] nArray3 = dummyMan.animPositions[dummyMan.animNextPosition - 1];
                int[] nArray4 = dummyMan.animPositions[dummyMan.animNextPosition];
                n7 = 0;
                if (nArray4[0] != nArray3[0]) {
                    n7 = (dummyMan.animFrameCounter - nArray3[0] << 10) / (nArray4[0] - nArray3[0]);
                }
                int n8 = dummyMan.animRefPosition.x + (nArray3[1] * (1024 - n7) + nArray4[1] * n7 >> 10);
                int n9 = dummyMan.animRefPosition.y + (nArray3[2] * (1024 - n7) + nArray4[2] * n7 >> 10);
                int n10 = n4;
                int n11 = n5;
                int n12 = n;
                n = 1;
                n = 0;
                n7 = n9;
                int n13 = n8;
                n5 = n12;
                n4 = n11;
                n9 = n10;
                n = 2;
                DummyMan dummyMan2 = dummyMan;
                int[][] nArray5 = animPoses[2][n9];
                int[][] nArray6 = animPoses[2][n4];
                n13 += (int)((long)nArray5[7][1] * (long)(1024 - n5) + (long)nArray6[7][1] * (long)n5 >> 10);
                n7 += (int)((long)nArray5[7][2] * (long)(1024 - n5) + (long)nArray6[7][2] * (long)n5 >> 10);
                for (int i = 0; i < BodyPart.HIERARCHY_ORDER.length; ++i) {
                    n8 = BodyPart.HIERARCHY_ORDER[i];
                    BodyPart bodyPart = dummyMan2.bodyParts[n8];
                    byte by = BodyPart.PARENT[n8];
                    n8 = (int)((long)nArray5[n8 + 1][0] * (long)(1024 - n5) + (long)nArray6[n8 + 1][0] * (long)n5 >> 10);
                    if (!BodyPart.facingLeft()) {
                        n8 = -n8;
                    }
                    if (by != -1) {
                        n8 += dummyMan2.bodyParts[by].getAngle_shifted();
                    }
                    bodyPart._setAngle_shifted(n8);
                    Vector2 vector2 = tmpVector;
                    bodyPart.getOffsetPosition(vector2);
                    vector2.add(n13, n7);
                    bodyPart._setPosition(vector2);
                    bodyPart.getLinearVelocity().set(vector2.x - bodyPart.oldPosition.x, vector2.y - bodyPart.oldPosition.y);
                    bodyPart.setAngularVelocity_shifted(0);
                    bodyPart.oldPosition.copy(vector2);
                    bodyPart.recomputeBoundingBox();
                    bodyPart.resetDrawData();
                }
                for (n = 0; n < dummyMan.bodyParts.length; ++n) {
                    if (dummyMan.bodyParts[n] == null) continue;
                    dummyMan.bodyParts[n].wakeUp();
                }
            }
        }
        if (this.state == 4) {
            n2 = this.bodyParts[6].getAngle_shifted();
            n = MathUtils.angleDistance(this.scoremulti_oldBodyAngle, n2);
            this.scoremulti_turnAccumulator += n;
            if (this.scoremulti_turnAccumulator >= 6588397) {
                ++this.scoremulti_numSomersaults;
                this.scoremulti_turnAccumulator -= 6588397;
                this.game.showBonusText((byte)0);
            }
            if (this.scoremulti_turnAccumulator <= -6588397) {
                ++this.scoremulti_numSomersaults;
                this.scoremulti_turnAccumulator += 6588397;
                this.game.showBonusText((byte)0);
            }
            this.scoremulti_oldBodyAngle = n2;
        }
    }

    public final void resetPosition() {
        this.bodyParts[6]._setPosition(this.initialBodyPosition);
        this.bodyParts[6].recomputeBoundingBox();
    }

    public final void draw(Graphics graphics) {
        for (int i = 0; i < this.bodyParts.length; ++i) {
            if (this.bodyParts[i] == null) continue;
            BodyPart bodyPart = this.bodyParts[i];
            if (!MathUtils.boundingBoxesOverlap(Game.camAABB, bodyPart.boundingBox)) continue;
            this.bodyParts[i].draw(graphics);
        }
    }

    public final void changeState(byte by) {
        if (!(this.state != 0 && this.state != 1 || by != 4 && by != 5)) {
            for (int i = 0; i < this.bodyParts.length; ++i) {
                if (this.bodyParts[i] == null) continue;
                this.bodyParts[i].wakeUp();
                this.bodyParts[i].setCanSleep(false);
            }
        }
        if ((this.state == 0 || this.state == 1 || this.state == 5) && by == 4) {
            if (this.bodyParts[8] != null) {
                this.bodyParts[8].detach();
            }
            this.flightCounter = 0;
            this.game.requestStartAction();
        }
        this.state = by;
    }

    public final void startAnimation(byte by, int[][] object) {
        this.animType = by;
        this.animPositions = object;
        this.animFrameCounter = 0;
        BodyPart bodyPart = this.bodyParts[6];
        object = bodyPart;
        this.animRefPosition = new Vector2(bodyPart.centerPos);
        this.animNextPosition = 0;
        this.animNextPose = 0;
        this.animPrevPose = 0;
        for (by = 0; by < this.bodyParts.length; by = (byte)(by + 1)) {
            if (this.bodyParts[by] == null) continue;
            BodyPart bodyPart2 = this.bodyParts[by];
            object = bodyPart2;
            this.bodyParts[by].oldPosition.copy(bodyPart2.centerPos);
        }
        this.changeState((byte)1);
    }

    public static final int[] computeAnimationPosition(int n, int n2, int n3, int n4, int n5, int n6) {
        n3 = (MathUtils.vectorLength(n - n3, n2 - n4) << 10) / n5;
        return new int[]{n6 + n3, n, n2};
    }

    public final Vector2 getCenterPosition() {
        BodyPart bodyPart = this.bodyParts[6];
        return bodyPart.centerPos;
    }

    public final void recomputeBoundingBox() {
        Object object = Integer.MAX_VALUE;
        Object object2 = Integer.MAX_VALUE;
        Object object3 = Integer.MIN_VALUE;
        Object object4 = Integer.MIN_VALUE;
        for (int i = 0; i < this.bodyParts.length; ++i) {
            if (this.bodyParts[i] == null || i == 8) continue;
            BodyPart bodyPart = this.bodyParts[i];
            Object object5 = bodyPart;
            object5 = bodyPart.boundingBox;
            if (bodyPart.boundingBox[0] < object) {
                object = object5[0];
            }
            if (object5[1] < object2) {
                object2 = object5[1];
            }
            if (object5[2] > object3) {
                object3 = object5[2];
            }
            if (object5[3] <= object4) continue;
            object4 = object5[3];
        }
        this.aabb[0] = object;
        this.aabb[1] = object2;
        this.aabb[2] = object3;
        this.aabb[3] = object4;
    }

    public final int[] getBoundingBox() {
        return this.aabb;
    }

    public static void createAnimations() {
        animLooping = new boolean[4];
        animPoses = new int[4][][][];
        DummyMan.animLooping[2] = true;
        DummyMan.animPoses[2] = new int[][][]{new int[][]{{0}, {-223621}, {-236962}, {569719}, {-597494}, {152548}, {87190}, {345673, 410, 2624}, {-414214}, {281063}, {-354730}, {-97040}, {65164}, {-325998}, {75757}, {-14944}}, new int[][]{{10}, {-147836}, {-236962}, {396735}, {-568643}, {216512}, {70154}, {269894, 1135, 1924}, {-336118}, {228001}, {-388483}, {85188}, {-7532}, {-250213}, {75757}, {-14944}}, new int[][]{{20}, {-38121}, {-236962}, {354728}, {-566728}, {410388}, {-15940}, {160197, 1171, 1251}, {-226407}, {264652}, {-449312}, {391519}, {-143337}, {-140498}, {75757}, {-14944}}, new int[][]{{30}, {-147836}, {-236962}, {396735}, {-568643}, {216512}, {70154}, {269894, 1402, 1928}, {-336118}, {204874}, {-388483}, {85188}, {-7532}, {-250213}, {75757}, {-14944}}, new int[][]{{40}}};
    }

    static {
        tmpVector = new Vector2();
    }
}

