/*
 * Decompiled with CFR 0.152.
 */
import com.hardwire.dymix.CollisionProxy;
import com.hardwire.dymix.DynamicObject;
import com.hardwire.dymix.Joint;
import com.hardwire.dymix.PhysicalObject;
import com.hardwire.utils.Vector2;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public final class BodyPart
extends DynamicObject {
    private byte state;
    public static final byte[] PARENT = new byte[]{6, 0, 1, 6, 3, 4, -1, 6, 7, 6, 9, 10, 6, 12, 13};
    public static final byte[] HIERARCHY_ORDER = new byte[]{6, 7, 9, 12};
    private byte type;
    private static final int[] COEF_FRICTION;
    private static final int[] COEF_RESTITUTION;
    private static final int[] COEF_DENSITY;
    private static CollisionProxy[] shapes;
    private static Vector2[][] jointPositions;
    private static int[][] jointLimits;
    private static int[][][][] visuals;
    private static boolean facingLeft;
    private Game game;
    public DummyMan parentChar;
    private int damageDisplayCounter;
    private int damageCooldown;
    private static int[] hitScore;
    public Vector2 oldPosition = new Vector2();
    private static Vector2 tmpVector;
    private static int damageWoodBox;
    private static int damageBarel;
    private static int damageAnvil;
    private static int damageBumper;
    private static int damageTrampoline;
    private static int damageFist;

    public final void draw(Graphics graphics) {
        this.updateDrawData();
        this.game.drawVectorGfx_worldCoords(graphics, visuals[this.type], this.getDrawPosition(), this.getDrawAngle_shifted(), this.damageDisplayCounter > 0 ? -5232384 : -1);
        if (this.damageDisplayCounter > 0) {
            --this.damageDisplayCounter;
        }
    }

    public final void tick() {
        if (this.damageCooldown > 0) {
            --this.damageCooldown;
        }
    }

    public final void postTick() {
        if (this.state == 1) {
            this.setAngularVelocity_shifted(this.parentChar.bodyParts[7].getAngularVelocity_shifted());
            this.getLinearVelocity().copy(this.parentChar.bodyParts[7].getLinearVelocity());
            tmpVector.copyOpposite(jointPositions[this.type][0]);
            tmpVector.multiplyWithShift(this.parentChar.bodyParts[7].getOrientation());
            BodyPart bodyPart = this.parentChar.bodyParts[7];
            tmpVector.add(bodyPart.centerPos);
            this._setPosition(tmpVector);
            this._setAngle_shifted(this.parentChar.bodyParts[7].getAngle_shifted());
            this.recomputeBoundingBox();
        }
    }

    public final boolean canCollideWith(PhysicalObject physicalObject) {
        if (!(physicalObject.isDynamic || physicalObject.userType == 2 || this.parentChar.state != 0 && this.parentChar.state != 1)) {
            return false;
        }
        return this.userType != 1 || physicalObject.userType != 1;
    }

    protected final boolean notifyBeforeCollisionResponse$2b11b2a(PhysicalObject physicalObject, int n, int n2) {
        if (physicalObject.userType == 2 && this.game.actionRunning()) {
            this.parentChar.changeState((byte)4);
        }
        if (this.type != 8 && physicalObject.userType == 2 && ((AbstractGameObject)((Object)physicalObject)).getType() == 40 && ((StaticGameObject)physicalObject).state != 4) {
            ((StaticGameObject)physicalObject).state = (byte)4;
            this.parentChar.targetHit = true;
        }
        if (this.parentChar.state == 4 && this.type != 8 && this.userType == 1 && physicalObject.userType != 1) {
            if (physicalObject.userType == 2) {
                byte by = ((AbstractGameObject)((Object)physicalObject)).getType();
                n = by;
                if (by == 37 || n == 38 || n == 39) {
                    if (((StaticGameObject)physicalObject).state != 6) {
                        this.parentChar.scoreBonus += DummyMan.SCORE_FROM_BONUS[n - 37];
                        PhysicalObject physicalObject2 = physicalObject;
                        Vector2 vector2 = physicalObject2.centerPos;
                        physicalObject2 = physicalObject;
                        int[] nArray = physicalObject2.boundingBox;
                        this.game.addScoreAnim(Game.worldToScreen(vector2.x), Game.worldToScreen(nArray[1]), DummyMan.SCORE_FROM_BONUS[n - 37]);
                    }
                    return false;
                }
            }
            PhysicalObject physicalObject3 = physicalObject;
            tmpVector.copy(physicalObject3.centerPos);
            physicalObject3 = this;
            tmpVector.subtract(physicalObject3.centerPos);
            tmpVector.normaliseWithShift();
            n = this.getLinearVelocity().dotProductWithShift(tmpVector) - physicalObject.getLinearVelocity().dotProductWithShift(tmpVector);
            if (n > 500 && this.damageCooldown == 0 && hitScore[this.type] != 0) {
                int n3;
                this.damageDisplayCounter = 2;
                n2 = 100;
                if (physicalObject.userType == 2) {
                    int n4;
                    n3 = ((AbstractGameObject)((Object)physicalObject)).getType();
                    n2 = n3;
                    switch (n3) {
                        case 1: {
                            n4 = damageWoodBox;
                            break;
                        }
                        case 18: {
                            n4 = damageBarel;
                            break;
                        }
                        case 17: {
                            n4 = damageAnvil;
                            break;
                        }
                        case 10: {
                            n4 = damageBumper;
                            break;
                        }
                        case 11: {
                            n4 = damageTrampoline;
                            break;
                        }
                        case 12: 
                        case 13: {
                            n4 = damageFist;
                            break;
                        }
                        default: {
                            n4 = 0;
                        }
                    }
                    n2 = n4;
                }
                n3 = n * 1000 >> 10;
                n3 = n3 * n2 * hitScore[this.type] / 100;
                boolean bl = false;
                bl = n3 > 0 || physicalObject.userType == 2 && n2 == 0;
                if (bl && n > 7500) {
                    BodyPart bodyPart = this;
                    this.game.createKaboomEffect(bodyPart.centerPos);
                }
                if (n3 > 0) {
                    boolean bl2;
                    if (Controller.level != 0) {
                        Main.vibrate(50);
                    }
                    this.game.endSuccessCounter = 0;
                    BodyPart bodyPart = this;
                    Vector2 vector2 = bodyPart.centerPos;
                    this.game.addScoreAnim(Game.worldToScreen(vector2.x), Game.worldToScreen(vector2.y), n3);
                    this.parentChar.scoreDamage += n3;
                    boolean bl3 = this.game.mainObjIndex != -1 && this.game.gameObjects[this.game.mainObjIndex] == physicalObject;
                    boolean bl4 = bl2 = physicalObject.userType == 4;
                    if (!(this.type != 7 || this.parentChar.scoremulti_alreadyCollided || bl3 || bl2)) {
                        ++this.parentChar.scoremulti_numHeadOns;
                        this.game.showBonusText((byte)1);
                    }
                    if (!bl3 && !bl2) {
                        this.parentChar.scoremulti_alreadyCollided = true;
                    }
                    if (bl2 && this.game.actionCounter > 60) {
                        this.game.showBonusText((byte)2);
                        ++this.parentChar.scoremulti_numHelmetFatalities;
                    }
                }
            }
            this.damageCooldown = 30;
            this.parentChar.flightCounter = 0;
        }
        return true;
    }

    public final void detach() {
        if (this.state == 1) {
            this.state = 0;
            if (this.type == 8) {
                this.userType = 4;
                return;
            }
            this.userType = 0;
        }
    }

    public final void saveState(DataOutputStream dataOutputStream) throws IOException {
        Object object = this;
        object = ((PhysicalObject)object).centerPos;
        dataOutputStream.writeInt(((Vector2)object).x);
        dataOutputStream.writeInt(((Vector2)object).y);
        dataOutputStream.writeInt(this.getAngle_shifted());
        object = this.getLinearVelocity();
        dataOutputStream.writeInt(((Vector2)object).x);
        dataOutputStream.writeInt(((Vector2)object).y);
        dataOutputStream.writeInt(this.getAngularVelocity_shifted());
    }

    public final void loadState(DataInputStream dataInputStream) throws IOException {
        tmpVector.set(dataInputStream.readInt(), dataInputStream.readInt());
        this._setPosition(tmpVector);
        this._setAngle_shifted(dataInputStream.readInt());
        this.getLinearVelocity().set(dataInputStream.readInt(), dataInputStream.readInt());
        this.setAngularVelocity_shifted(dataInputStream.readInt());
        this.recomputeBoundingBox();
    }

    public BodyPart(Game object, DummyMan dummyMan, byte by, Vector2 vector2) {
        this.game = object;
        this.parentChar = dummyMan;
        this.type = by;
        this.initBody(this.game.world, shapes[this.type], COEF_FRICTION[this.type], COEF_RESTITUTION[this.type], COEF_DENSITY[this.type], true);
        this.userType = 1;
        this.damageDisplayCounter = 0;
        this.damageCooldown = 0;
        this.state = this.type == 8 ? (byte)1 : 0;
        object = new Vector2();
        this.getOffsetPosition((Vector2)object);
        ((Vector2)object).add(vector2);
        this.spawnBody((Vector2)object, 0);
    }

    public final void getOffsetPosition(Vector2 vector2) {
        if (PARENT[this.type] == -1) {
            vector2.set(0, 0);
            return;
        }
        BodyPart bodyPart = this.parentChar.bodyParts[PARENT[this.type]];
        bodyPart.getOffsetPosition(vector2);
        switch (this.type) {
            case 7: {
                tmpVector.copy(jointPositions[PARENT[this.type]][0]);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                tmpVector.copy(jointPositions[PARENT[this.type]][1]);
                break;
            }
            case 12: {
                tmpVector.copy(jointPositions[PARENT[this.type]][2]);
                break;
            }
            case 0: {
                tmpVector.copy(jointPositions[PARENT[this.type]][3]);
                break;
            }
            default: {
                tmpVector.set(0, 0);
            }
        }
        tmpVector.multiplyWithShift(bodyPart.getOrientation());
        vector2.add(tmpVector);
        switch (this.type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                tmpVector.copyOpposite(jointPositions[this.type][0]);
                break;
            }
            default: {
                tmpVector.set(0, 0);
            }
        }
        tmpVector.multiplyWithShift(this.getOrientation());
        vector2.add(tmpVector);
    }

    public static Joint connectParts(BodyPart bodyPart, BodyPart bodyPart2) {
        byte by = bodyPart.type;
        byte by2 = bodyPart2.type;
        if (by == 6 && by2 == 7) {
            return new Joint(bodyPart, bodyPart2, jointPositions[by][0], jointPositions[by2][0], jointLimits[by2][0], jointLimits[by2][1]);
        }
        if (by == 6 && (by2 == 9 || by2 == 3)) {
            return new Joint(bodyPart, bodyPart2, jointPositions[by][1], jointPositions[by2][0], jointLimits[by2][0], jointLimits[by2][1]);
        }
        if (!(by != 9 && by != 3 || by2 != 10 && by2 != 4)) {
            return new Joint(bodyPart, bodyPart2, jointPositions[by][1], jointPositions[by2][0], jointLimits[by2][0], jointLimits[by2][1]);
        }
        if (!(by != 10 && by != 4 || by2 != 11 && by2 != 5)) {
            return new Joint(bodyPart, bodyPart2, jointPositions[by][1], jointPositions[by2][0], jointLimits[by2][0], jointLimits[by2][1]);
        }
        if (by == 6 && by2 == 12) {
            return new Joint(bodyPart, bodyPart2, jointPositions[by][2], jointPositions[by2][0], jointLimits[by2][0], jointLimits[by2][1]);
        }
        if (by == 6 && by2 == 0) {
            return new Joint(bodyPart, bodyPart2, jointPositions[by][3], jointPositions[by2][0], jointLimits[by2][0], jointLimits[by2][1]);
        }
        if (!(by != 12 && by != 0 || by2 != 13 && by2 != 1)) {
            return new Joint(bodyPart, bodyPart2, jointPositions[by][1], jointPositions[by2][0], jointLimits[by2][0], jointLimits[by2][1]);
        }
        if (!(by != 13 && by != 1 || by2 != 14 && by2 != 2)) {
            return new Joint(bodyPart, bodyPart2, jointPositions[by][1], jointPositions[by2][0], jointLimits[by2][0], jointLimits[by2][1]);
        }
        return null;
    }

    public static boolean facingLeft() {
        return facingLeft;
    }

    public static void setFaceDirection(boolean n) {
        int n2;
        if (facingLeft == n) {
            return;
        }
        facingLeft = !facingLeft;
        for (n = 0; n < shapes.length; ++n) {
            if (shapes[n] == null) continue;
            Vector2[] vector2Array = shapes[n];
            vector2Array = vector2Array.data;
            for (n2 = 0; n2 < vector2Array.length; ++n2) {
                vector2Array[n2].x = -vector2Array[n2].x;
            }
            shapes[n].recomputeBoundingBox(true);
        }
        for (n = 0; n < jointPositions.length; ++n) {
            if (jointPositions[n] != null) {
                Vector2[] vector2Array = jointPositions[n];
                for (n2 = 0; n2 < vector2Array.length; ++n2) {
                    vector2Array[n2].x = -vector2Array[n2].x;
                }
            }
            if (jointLimits[n] == null) continue;
            int n3 = jointLimits[n][0];
            BodyPart.jointLimits[n][0] = -jointLimits[n][1];
            BodyPart.jointLimits[n][1] = -n3;
        }
        for (n = 0; n < visuals.length; ++n) {
            if (visuals[n] == null) continue;
            for (int i = 0; i < visuals[n].length; ++i) {
                int[][] nArray = visuals[n][i];
                int n4 = nArray[0][0];
                if (n4 == 1 || n4 == 3) {
                    nArray[1][0] = -nArray[1][0];
                    continue;
                }
                if (n4 != 4 && n4 != 0 && n4 != 2) continue;
                for (n4 = 1; n4 < nArray.length; ++n4) {
                    nArray[n4][0] = -nArray[n4][0];
                }
            }
        }
    }

    public static void loadStaticData(DataInputStream dataInputStream) {
        int n;
        visuals = new int[15][][][];
        shapes = new CollisionProxy[15];
        Vector2[][] vector2ArrayArray = new Vector2[15][];
        jointPositions = new Vector2[15][];
        jointLimits = new int[15][];
        hitScore = new int[15];
        BodyPart.jointLimits[7] = new int[]{-1098066, 1098066};
        BodyPart.jointLimits[9] = new int[]{-1098066, 1647099};
        BodyPart.jointLimits[3] = new int[]{-1098066, 1647099};
        BodyPart.jointLimits[10] = new int[]{-1098066, 0};
        BodyPart.jointLimits[4] = new int[]{-1098066, 0};
        BodyPart.jointLimits[11] = new int[]{-549033, 470599};
        BodyPart.jointLimits[5] = new int[]{-549033, 470599};
        BodyPart.jointLimits[12] = new int[]{-549033, 2964778};
        BodyPart.jointLimits[0] = new int[]{-549033, 2964778};
        BodyPart.jointLimits[13] = new int[]{0, 2470648};
        BodyPart.jointLimits[1] = new int[]{0, 2470648};
        BodyPart.jointLimits[14] = new int[]{-823549, 1281789};
        BodyPart.jointLimits[2] = new int[]{-823549, 1281789};
        BodyPart.hitScore[11] = 0;
        BodyPart.hitScore[5] = 0;
        BodyPart.hitScore[14] = 0;
        BodyPart.hitScore[2] = 0;
        BodyPart.hitScore[7] = 5;
        BodyPart.hitScore[6] = 3;
        BodyPart.hitScore[12] = 3;
        BodyPart.hitScore[0] = 3;
        BodyPart.hitScore[13] = 2;
        BodyPart.hitScore[1] = 2;
        BodyPart.hitScore[9] = 2;
        BodyPart.hitScore[3] = 2;
        BodyPart.hitScore[10] = 1;
        BodyPart.hitScore[4] = 1;
        for (n = 0; n < HIERARCHY_ORDER.length; ++n) {
            byte by = HIERARCHY_ORDER[n];
            BodyPart.visuals[by] = Game.loadVectorObject_model(dataInputStream);
            vector2ArrayArray[by] = Game.loadVectorObject_physics(dataInputStream);
            BodyPart.jointPositions[by] = Game.loadVectorObject_joints(dataInputStream);
            Controller.updateLoadBar(1);
        }
        for (n = 0; n < vector2ArrayArray.length; ++n) {
            if (vector2ArrayArray[n] == null) continue;
            BodyPart.shapes[n] = new CollisionProxy(vector2ArrayArray[n], true);
        }
        facingLeft = true;
        Controller.updateLoadBar(1);
    }

    static {
        int[] nArray = new int[]{85, 90, 90, 95, 85, 90, 270, 270, 270, 95, 85, 90, 85, 90, 90};
        COEF_FRICTION = new int[]{1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024};
        COEF_RESTITUTION = new int[]{512, 512, 512, 512, 512, 512, 512, 102, 512, 102, 512, 512, 512, 512, 512};
        COEF_DENSITY = new int[]{1024, 1024, 1024, 1024, 1024, 204, 1024, 204, 1024, 1024, 1024, 204, 1024, 1024, 1024};
        tmpVector = new Vector2();
        damageWoodBox = 200;
        damageBarel = 250;
        damageAnvil = 350;
        damageBumper = 100;
        damageTrampoline = 50;
        damageFist = 50;
    }
}

