/*
 * Decompiled with CFR 0.152.
 */
package com.hardwire.dymix;

public final class ImplicitGrid {
    int TILE_SIZE_SHIFT = -1;
    int width;
    int height;
    int numChunksPerCell;
    private int maxObjects;
    long[] cols;
    long[] rows;
    private int[] neighbours;
    int[] visibles;

    public ImplicitGrid(int n, int n2, int n3, int n4) {
        this.TILE_SIZE_SHIFT = n;
        this.width = n2 >> this.TILE_SIZE_SHIFT;
        this.height = n3 >> this.TILE_SIZE_SHIFT;
        if (n2 % (1 << this.TILE_SIZE_SHIFT) != 0) {
            ++this.width;
        }
        if (n3 % (1 << this.TILE_SIZE_SHIFT) != 0) {
            ++this.height;
        }
        this.numChunksPerCell = n4 >> 6;
        this.maxObjects = this.numChunksPerCell << 6;
        this.cols = new long[this.width * this.numChunksPerCell];
        this.rows = new long[this.height * this.numChunksPerCell];
        this.neighbours = new int[this.maxObjects + 1];
        this.visibles = new int[this.maxObjects + 1];
    }

    private void resize(int n) {
        n = (n >> 6) + 1;
        long[] lArray = new long[n * this.width];
        long[] lArray2 = new long[n * this.height];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n2 < this.width) {
            System.arraycopy(this.cols, n3, lArray, n4, this.numChunksPerCell);
            ++n2;
            n3 += this.numChunksPerCell;
            n4 += n;
        }
        n2 = 0;
        n3 = 0;
        n4 = 0;
        while (n2 < this.height) {
            System.arraycopy(this.rows, n3, lArray2, n4, this.numChunksPerCell);
            ++n2;
            n3 += this.numChunksPerCell;
            n4 += n;
        }
        this.cols = null;
        this.rows = null;
        this.neighbours = null;
        this.visibles = null;
        this.cols = lArray;
        this.rows = lArray2;
        this.numChunksPerCell = n;
        this.maxObjects = this.numChunksPerCell << 6;
        this.neighbours = new int[this.maxObjects + 1];
        this.visibles = new int[this.maxObjects + 1];
    }

    public final int[] queryArea(int n, int n2, int[] nArray) {
        int n3;
        if (n2 == 0 || this.numChunksPerCell == 0) {
            this.neighbours[0] = 0;
            return this.neighbours;
        }
        n2 = nArray[0] >> this.TILE_SIZE_SHIFT;
        int n4 = nArray[1] >> this.TILE_SIZE_SHIFT;
        int n5 = nArray[2] >> this.TILE_SIZE_SHIFT;
        int n6 = nArray[3] >> this.TILE_SIZE_SHIFT;
        n2 = n2 < 0 ? 0 : n2;
        n4 = n4 < 0 ? 0 : n4;
        n5 = n5 < 0 ? 0 : n5;
        n6 = n6 < 0 ? 0 : n6;
        n2 = n2 >= this.width ? this.width - 1 : n2;
        n4 = n4 >= this.height ? this.height - 1 : n4;
        n5 = n5 >= this.width ? this.width - 1 : n5;
        n6 = n6 >= this.height ? this.height - 1 : n6;
        n2 *= this.numChunksPerCell;
        n4 *= this.numChunksPerCell;
        n5 *= this.numChunksPerCell;
        n6 *= this.numChunksPerCell;
        int n7 = 0;
        int n8 = n >> 6;
        int n9 = n3 = n == -1 ? -1 : n - (n8 << 6);
        long l = n == -1 ? 0L : (n3 == 63 ? -1L : (1L << n3 + 1) - 1L);
        int n10 = n = n == -1 ? 0 : n8;
        while (n != this.numChunksPerCell) {
            int n11;
            long l2 = 0L;
            long l3 = 0L;
            for (n11 = n2; n11 <= n5; n11 += this.numChunksPerCell) {
                l2 |= this.cols[n11 + n];
            }
            for (n11 = n4; n11 <= n6; n11 += this.numChunksPerCell) {
                l3 |= this.rows[n11 + n];
            }
            l3 &= l2;
            while (l3 != 0L) {
                long l4 = l3 & -l3;
                if ((l4 & l) == 0L || n != n8) {
                    n3 = 0;
                    if ((l4 & 0xFFFFFFFFL) == 0L) {
                        n3 += 32;
                    }
                    if ((l4 & 65535L << n3) == 0L) {
                        n3 += 16;
                    }
                    if ((l4 & 255L << n3) == 0L) {
                        n3 += 8;
                    }
                    if ((l4 & 15L << n3) == 0L) {
                        n3 += 4;
                    }
                    if ((l4 & 3L << n3) == 0L) {
                        n3 += 2;
                    }
                    if ((l4 & 1L << n3) == 0L) {
                        ++n3;
                    }
                    this.neighbours[++n7] = n3 + (n << 6);
                }
                l3 ^= l4;
            }
            ++n;
        }
        this.neighbours[0] = n7;
        return this.neighbours;
    }

    public final void clear() {
        int n;
        for (n = 0; n < this.cols.length; ++n) {
            this.cols[n] = 0L;
        }
        for (n = 0; n < this.rows.length; ++n) {
            this.rows[n] = 0L;
        }
    }

    public final void updateObject(int n, int[] nArray, int[] nArray2) {
        int n2 = nArray[0] >> this.TILE_SIZE_SHIFT;
        int n3 = nArray[1] >> this.TILE_SIZE_SHIFT;
        int n4 = nArray[2] >> this.TILE_SIZE_SHIFT;
        int n5 = nArray[3] >> this.TILE_SIZE_SHIFT;
        int n6 = nArray2[0] >> this.TILE_SIZE_SHIFT;
        int n7 = nArray2[1] >> this.TILE_SIZE_SHIFT;
        int n8 = nArray2[2] >> this.TILE_SIZE_SHIFT;
        int n9 = nArray2[3] >> this.TILE_SIZE_SHIFT;
        if (n2 != n6 || n3 != n7 || n4 != n8 || n5 != n9) {
            this.unsetObject(n, n2, n3, n4, n5);
            this.setObject(n, n6, n7, n8, n9);
            return;
        }
        if (n >= this.maxObjects) {
            this.resize(n);
        }
    }

    public final void setObject(int n, int[] nArray) {
        this.setObject(n, nArray[0] >> this.TILE_SIZE_SHIFT, nArray[1] >> this.TILE_SIZE_SHIFT, nArray[2] >> this.TILE_SIZE_SHIFT, nArray[3] >> this.TILE_SIZE_SHIFT);
    }

    public final void unsetObject(int n, int[] nArray) {
        this.unsetObject(n, nArray[0] >> this.TILE_SIZE_SHIFT, nArray[1] >> this.TILE_SIZE_SHIFT, nArray[2] >> this.TILE_SIZE_SHIFT, nArray[3] >> this.TILE_SIZE_SHIFT);
    }

    private void setObject(int n, int n2, int n3, int n4, int n5) {
        if (n >= this.maxObjects) {
            this.resize(n);
        }
        n2 = n2 < 0 ? 0 : n2;
        n3 = n3 < 0 ? 0 : n3;
        n4 = n4 < 0 ? 0 : n4;
        n5 = n5 < 0 ? 0 : n5;
        n2 = n2 >= this.width ? this.width - 1 : n2;
        n3 = n3 >= this.height ? this.height - 1 : n3;
        n4 = n4 >= this.width ? this.width - 1 : n4;
        n5 = n5 >= this.height ? this.height - 1 : n5;
        int n6 = n2 * this.numChunksPerCell;
        int n7 = n3 * this.numChunksPerCell;
        int n8 = n >> 6;
        long l = 1L << (n -= n8 << 6);
        while (n2 <= n4) {
            int n9 = n6 + n8;
            this.cols[n9] = this.cols[n9] | l;
            ++n2;
            n6 += this.numChunksPerCell;
        }
        while (n3 <= n5) {
            int n10 = n7 + n8;
            this.rows[n10] = this.rows[n10] | l;
            ++n3;
            n7 += this.numChunksPerCell;
        }
    }

    private void unsetObject(int n, int n2, int n3, int n4, int n5) {
        if (n >= this.maxObjects) {
            this.resize(n);
        }
        n2 = n2 < 0 ? 0 : n2;
        n3 = n3 < 0 ? 0 : n3;
        n4 = n4 < 0 ? 0 : n4;
        n5 = n5 < 0 ? 0 : n5;
        n2 = n2 >= this.width ? this.width - 1 : n2;
        n3 = n3 >= this.height ? this.height - 1 : n3;
        n4 = n4 >= this.width ? this.width - 1 : n4;
        n5 = n5 >= this.height ? this.height - 1 : n5;
        int n6 = n2 * this.numChunksPerCell;
        int n7 = n3 * this.numChunksPerCell;
        int n8 = n >> 6;
        long l = 1L << (n -= n8 << 6) ^ 0xFFFFFFFFFFFFFFFFL;
        while (n2 <= n4) {
            int n9 = n6 + n8;
            this.cols[n9] = this.cols[n9] & l;
            ++n2;
            n6 += this.numChunksPerCell;
        }
        while (n3 <= n5) {
            int n10 = n7 + n8;
            this.rows[n10] = this.rows[n10] & l;
            ++n3;
            n7 += this.numChunksPerCell;
        }
    }
}

