/*
 * Decompiled with CFR 0.152.
 */
package com.hardwire.dymix;

import com.hardwire.dymix.CollisionProxy;
import com.hardwire.dymix.DynamicObject;
import com.hardwire.dymix.ImplicitGrid;
import com.hardwire.dymix.Joint;
import com.hardwire.dymix.PhysicalObject;
import com.hardwire.dymix.Spring;
import com.hardwire.dymix.StaticObject;
import com.hardwire.utils.MathUtils;
import com.hardwire.utils.Matrix2x2;
import com.hardwire.utils.Vector2;
import java.util.Vector;

public final class DynamicWorld {
    private byte type;
    private boolean initialised;
    private long sleepLinVelThreshold_squared;
    private int sleepAngVelThreshold_shifted;
    private int sleepMaxCounter;
    private byte[][] _staticTiles;
    private StaticObject[] _tileObjects;
    private boolean[][] tileObjects_validEdges;
    private boolean[] tileObjects_useAxis;
    private int tileSize;
    private int tileSize_shift;
    private int[] dummyVisibleObjects;
    private long[] visibleObjectsMask;
    private int[] activeArea;
    public ImplicitGrid _bp_grid_dynamic;
    public ImplicitGrid _bp_grid_static;
    private DynamicObject[] _dynamicObjects;
    private int _dynamicObjects_len;
    private StaticObject[] _staticObjects;
    private int _staticObjects_len;
    private Vector objectsToDel;
    public Joint[] _joints;
    public int _joints_len;
    private int jointUpdateIterations;
    public Spring[] _springs;
    public int _springs_len;
    private Vector2 gravity;
    private Vector2[] linVelChange;
    private int[] angVelChange;
    private Vector2 posChange;
    private int posChange_count;
    private static Vector2 n = new Vector2();
    private static int[] t = new int[1];
    private static int[][] supPoints1 = new int[2][2];
    private static int[][] supPoints2 = new int[2][2];
    private static int[] AB = new int[2];
    private static int[] d = new int[128];
    private static int[] s = new int[2];
    private static int[] contact = new int[2];
    private static int[] relOrient = new int[4];
    private static int[][] axes = new int[128][2];
    private static int[] taxes = new int[128];

    public final void init(byte by, int n, int n2, int n3) {
        DynamicWorld dynamicWorld = this;
        this._joints = null;
        dynamicWorld._springs = null;
        dynamicWorld._bp_grid_dynamic = null;
        dynamicWorld._bp_grid_static = null;
        dynamicWorld._dynamicObjects = null;
        dynamicWorld._staticObjects = null;
        if (dynamicWorld.objectsToDel != null) {
            dynamicWorld.objectsToDel.removeAllElements();
            dynamicWorld.objectsToDel = null;
        }
        dynamicWorld.dummyVisibleObjects = null;
        dynamicWorld._staticTiles = null;
        dynamicWorld._tileObjects = null;
        dynamicWorld.tileObjects_validEdges = null;
        dynamicWorld.tileObjects_useAxis = null;
        dynamicWorld.activeArea = null;
        System.gc();
        this.type = 0;
        if (this.type == 1) {
            DynamicWorld._error((byte)9);
            return;
        }
        if (this.type == 3) {
            DynamicWorld._error((byte)9);
            return;
        }
        this.sleepLinVelThreshold_squared = (long)204 * (long)204;
        this.sleepAngVelThreshold_shifted = n2;
        this.sleepMaxCounter = 40;
        this.linVelChange = new Vector2[]{new Vector2(), new Vector2()};
        this.posChange = new Vector2();
        this.angVelChange = new int[2];
        this.gravity = new Vector2();
        this.jointUpdateIterations = 1;
        this.initialised = false;
    }

    public final void initUniformGrid(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (this.type != 0) {
            DynamicWorld._error((byte)8);
        }
        this._bp_grid_dynamic = new ImplicitGrid(15, n2, n3, 64);
        this._bp_grid_static = new ImplicitGrid(15, n2, n3, 64);
        this._dynamicObjects = new DynamicObject[64];
        this._dynamicObjects_len = 0;
        this._staticObjects = new StaticObject[64];
        this._staticObjects_len = 0;
        this.dummyVisibleObjects = new int[65];
        for (n = 1; n <= 64; ++n) {
            this.dummyVisibleObjects[n] = n - 1;
        }
        this.visibleObjectsMask = new long[2];
        this.objectsToDel = new Vector();
        this._joints = new Joint[32];
        this._joints_len = 0;
        this._springs = new Spring[32];
        this._springs_len = 0;
        this.initialised = true;
    }

    public final void setTiles(int n, byte[][] object, StaticObject[] staticObjectArray, boolean[][] blArray, boolean[] blArray2) {
        this.tileSize = n;
        this._staticTiles = object;
        if (staticObjectArray == null || blArray == null || blArray2 == null) {
            DynamicWorld._error((byte)5);
        }
        this._tileObjects = staticObjectArray;
        for (n = 0; n < ((byte[][])object).length; ++n) {
            for (int i = 0; i < object[0].length; ++i) {
                if (this._staticTiles[n][i] < this._tileObjects.length) continue;
                DynamicWorld._error((byte)10);
            }
        }
        this.tileObjects_validEdges = blArray;
        if (this._tileObjects.length != this.tileObjects_validEdges.length) {
            DynamicWorld._error((byte)10);
        }
        for (n = 0; n < this._tileObjects.length; ++n) {
            if (this.tileObjects_validEdges[n] != null) {
                StaticObject staticObject = this._tileObjects[n];
                object = staticObject;
                CollisionProxy collisionProxy = staticObject.collisionProxy;
                object = collisionProxy;
                if (collisionProxy.data.length != this.tileObjects_validEdges[n].length) {
                    DynamicWorld._error((byte)10);
                }
            }
            if (this.tileObjects_validEdges[n] != null) continue;
            StaticObject staticObject = this._tileObjects[n];
            object = staticObject;
            CollisionProxy collisionProxy = staticObject.collisionProxy;
            object = collisionProxy;
            this.tileObjects_validEdges[n] = new boolean[collisionProxy.data.length];
            for (int i = 0; i < this.tileObjects_validEdges[n].length; ++i) {
                this.tileObjects_validEdges[n][i] = true;
            }
        }
        this.tileObjects_useAxis = blArray2;
        if (this.tileObjects_useAxis.length != this._tileObjects.length) {
            DynamicWorld._error((byte)10);
        }
        this.tileSize_shift = 0;
        n = this.tileSize;
        while ((n & 1) == 0) {
            n >>= 1;
            ++this.tileSize_shift;
        }
        if (n != 1) {
            this.tileSize_shift = 0;
        }
    }

    public final void setGravity(Vector2 vector2) {
        this.gravity.copy(vector2);
    }

    public final void addJoint(Joint joint) {
        if (!this.initialised) {
            DynamicWorld._error((byte)3);
        }
        if (this._joints_len == this._joints.length) {
            DynamicWorld._error((byte)12);
        }
        this._joints[this._joints_len++] = joint;
    }

    public final void removeJoint(Joint object) {
        for (int i = 0; i < this._joints_len; ++i) {
            if (this._joints[i] != object) continue;
            object = this;
            --((DynamicWorld)object)._joints_len;
            if (i != ((DynamicWorld)object)._joints_len) {
                ((DynamicWorld)object)._joints[i] = ((DynamicWorld)object)._joints[((DynamicWorld)object)._joints_len];
            }
            ((DynamicWorld)object)._joints[((DynamicWorld)object)._joints_len] = null;
            return;
        }
    }

    public final void removeAllJoints() {
        for (int i = 0; i < this._joints_len; ++i) {
            this._joints[i] = null;
        }
        this._joints_len = 0;
    }

    public final void addSpring(Spring spring) {
        if (!this.initialised) {
            DynamicWorld._error((byte)3);
        }
        if (this._springs_len == this._springs.length) {
            DynamicWorld._error((byte)12);
        }
        this._springs[this._springs_len++] = spring;
    }

    public final void removeSpring(Spring object) {
        for (int i = 0; i < this._springs_len; ++i) {
            if (this._springs[i] != object) continue;
            object = this;
            --((DynamicWorld)object)._springs_len;
            if (i != ((DynamicWorld)object)._springs_len) {
                ((DynamicWorld)object)._springs[i] = ((DynamicWorld)object)._springs[((DynamicWorld)object)._springs_len];
            }
            ((DynamicWorld)object)._springs[((DynamicWorld)object)._springs_len] = null;
            return;
        }
    }

    public final void removeAllSprings() {
        for (int i = 0; i < this._springs_len; ++i) {
            this._springs[i] = null;
        }
        this._springs_len = 0;
    }

    public final synchronized void _addObject(PhysicalObject physicalObject, boolean bl) {
        if (!this.initialised) {
            DynamicWorld._error((byte)3);
            return;
        }
        if (this.type == 0 || this.type == 1) {
            int n = this.objectsToDel.size();
            for (int i = 0; i < n; ++i) {
                if (physicalObject != this.objectsToDel.elementAt(i)) continue;
                DynamicWorld._error((byte)14);
                return;
            }
            if (bl && this._dynamicObjects != null) {
                this._dynamicObjects[this._dynamicObjects_len] = (DynamicObject)physicalObject;
                this._dynamicObjects[this._dynamicObjects_len]._id = this._dynamicObjects_len;
                if (this.type == 0) {
                    PhysicalObject physicalObject2 = physicalObject;
                    this._bp_grid_dynamic.setObject(this._dynamicObjects_len, physicalObject2.boundingBox);
                }
                ++this._dynamicObjects_len;
            }
            if (!bl && this._staticObjects != null) {
                this._staticObjects[this._staticObjects_len] = (StaticObject)physicalObject;
                this._staticObjects[this._staticObjects_len]._id = this._staticObjects_len;
                if (this.type == 0) {
                    PhysicalObject physicalObject3 = physicalObject;
                    this._bp_grid_static.setObject(this._staticObjects_len, physicalObject3.boundingBox);
                }
                ++this._staticObjects_len;
            }
        }
    }

    public final void _removeObject$18810be9(PhysicalObject physicalObject) {
        if (!this.initialised) {
            DynamicWorld._error((byte)3);
            return;
        }
        if (this.type == 0 || this.type == 1) {
            this.objectsToDel.addElement(physicalObject);
        }
    }

    public final void removeAllObjects() {
        int n;
        for (n = 0; n < this._dynamicObjects_len; ++n) {
            this._dynamicObjects[n] = null;
        }
        this._dynamicObjects_len = 0;
        this._bp_grid_dynamic.clear();
        for (n = 0; n < this._staticObjects_len; ++n) {
            this._staticObjects[n] = null;
        }
        this._staticObjects_len = 0;
        this._bp_grid_static.clear();
    }

    private boolean objectPairIsActive(PhysicalObject physicalObject, PhysicalObject physicalObject2) {
        int n;
        int n2;
        boolean bl = false;
        if (physicalObject.isDynamic) {
            physicalObject = (DynamicObject)physicalObject;
            n2 = ((DynamicObject)physicalObject)._id;
            n = n2 >> 6;
            if (!((DynamicObject)physicalObject).isAsleep() && (this.visibleObjectsMask[n] & 1L << n2 - (n << 6)) != 0L) {
                bl = true;
            }
        }
        if (!bl && physicalObject2.isDynamic) {
            physicalObject = (DynamicObject)physicalObject2;
            n2 = ((DynamicObject)physicalObject)._id;
            n = n2 >> 6;
            if (!((DynamicObject)physicalObject).isAsleep() && (this.visibleObjectsMask[n] & 1L << n2 - (n << 6)) != 0L) {
                bl = true;
            }
        }
        return bl;
    }

    public final void tick() {
        PhysicalObject physicalObject;
        Object object;
        Object object2;
        int n;
        int n2;
        if (!this.initialised) {
            DynamicWorld._error((byte)3);
            return;
        }
        Object object3 = this;
        if (((DynamicWorld)object3).type == 0 || ((DynamicWorld)object3).type == 1) {
            n2 = ((DynamicWorld)object3).objectsToDel.size();
            block0: for (n = 0; n < n2; ++n) {
                int n3;
                object2 = ((DynamicWorld)object3).objectsToDel.elementAt(n);
                object = 0;
                for (n3 = 0; n3 < ((DynamicWorld)object3)._dynamicObjects_len; ++n3) {
                    if (((DynamicWorld)object3)._dynamicObjects[n3] != object2) continue;
                    object = 1;
                    if (((DynamicWorld)object3).type == 0) {
                        physicalObject = ((DynamicWorld)object3)._dynamicObjects[n3];
                        ((DynamicWorld)object3)._bp_grid_dynamic.unsetObject(n3, physicalObject.boundingBox);
                    }
                    --((DynamicWorld)object3)._dynamicObjects_len;
                    if (n3 != ((DynamicWorld)object3)._dynamicObjects_len) {
                        if (((DynamicWorld)object3).type == 0) {
                            physicalObject = ((DynamicWorld)object3)._dynamicObjects[((DynamicWorld)object3)._dynamicObjects_len];
                            ((DynamicWorld)object3)._bp_grid_dynamic.unsetObject(((DynamicWorld)object3)._dynamicObjects_len, physicalObject.boundingBox);
                        }
                        ((DynamicWorld)object3)._dynamicObjects[n3] = ((DynamicWorld)object3)._dynamicObjects[((DynamicWorld)object3)._dynamicObjects_len];
                        if (((DynamicWorld)object3).type == 0) {
                            physicalObject = ((DynamicWorld)object3)._dynamicObjects[n3];
                            ((DynamicWorld)object3)._bp_grid_dynamic.setObject(n3, physicalObject.boundingBox);
                        }
                        ((DynamicWorld)object3)._dynamicObjects[n3]._id = n3;
                    }
                    ((DynamicWorld)object3)._dynamicObjects[((DynamicWorld)object3)._dynamicObjects_len] = null;
                    break;
                }
                if (object != 0) continue;
                for (n3 = 0; n3 < ((DynamicWorld)object3)._staticObjects_len; ++n3) {
                    if (((DynamicWorld)object3)._staticObjects[n3] != object2) continue;
                    if (((DynamicWorld)object3).type == 0) {
                        physicalObject = ((DynamicWorld)object3)._staticObjects[n3];
                        ((DynamicWorld)object3)._bp_grid_static.unsetObject(n3, physicalObject.boundingBox);
                    }
                    --((DynamicWorld)object3)._staticObjects_len;
                    if (n3 != ((DynamicWorld)object3)._staticObjects_len) {
                        if (((DynamicWorld)object3).type == 0) {
                            physicalObject = ((DynamicWorld)object3)._staticObjects[((DynamicWorld)object3)._staticObjects_len];
                            ((DynamicWorld)object3)._bp_grid_static.unsetObject(((DynamicWorld)object3)._staticObjects_len, physicalObject.boundingBox);
                        }
                        ((DynamicWorld)object3)._staticObjects[n3] = ((DynamicWorld)object3)._staticObjects[((DynamicWorld)object3)._staticObjects_len];
                        if (((DynamicWorld)object3).type == 0) {
                            physicalObject = ((DynamicWorld)object3)._staticObjects[n3];
                            ((DynamicWorld)object3)._bp_grid_static.setObject(n3, physicalObject.boundingBox);
                        }
                        ((DynamicWorld)object3)._staticObjects[n3]._id = n3;
                    }
                    ((DynamicWorld)object3)._staticObjects[((DynamicWorld)object3)._staticObjects_len] = null;
                    continue block0;
                }
            }
            ((DynamicWorld)object3).objectsToDel.removeAllElements();
        }
        if (this.type == 0) {
            int[] nArray;
            int n4;
            Object object4;
            if (this.activeArea != null) {
                int[] nArray2;
                object2 = new int[][]{this.activeArea};
                n = this._dynamicObjects_len;
                n2 = -1;
                object3 = this._bp_grid_dynamic;
                if (n == 0 || ((ImplicitGrid)object3).numChunksPerCell == 0) {
                    ((ImplicitGrid)object3).visibles[0] = 0;
                    nArray2 = ((ImplicitGrid)object3).visibles;
                } else {
                    object = ((E)object2).length;
                    int[] nArray3 = new int[object];
                    int[] nArray4 = new int[object];
                    int[] nArray5 = new int[object];
                    int[] nArray6 = new int[object];
                    object4 = 0;
                    while (object4 < object) {
                        int n5;
                        int n6;
                        int[] nArray7;
                        if (object2[object4] == null) {
                            nArray3[object4] = 0;
                            nArray4[object4] = 0;
                            nArray5[object4] = ((ImplicitGrid)object3).width - 1;
                            nArray7 = nArray6;
                            n6 = object4;
                            n5 = ((ImplicitGrid)object3).height - 1;
                        } else {
                            nArray3[object4] = (int)(object2[object4][0] >> ((ImplicitGrid)object3).TILE_SIZE_SHIFT);
                            nArray4[object4] = (int)(object2[object4][1] >> ((ImplicitGrid)object3).TILE_SIZE_SHIFT);
                            nArray5[object4] = (int)(object2[object4][2] >> ((ImplicitGrid)object3).TILE_SIZE_SHIFT);
                            nArray6[object4] = (int)(object2[object4][3] >> ((ImplicitGrid)object3).TILE_SIZE_SHIFT);
                            nArray3[object4] = nArray3[object4] < 0 ? 0 : nArray3[object4];
                            nArray4[object4] = nArray4[object4] < 0 ? 0 : nArray4[object4];
                            nArray5[object4] = nArray5[object4] < 0 ? 0 : nArray5[object4];
                            nArray6[object4] = nArray6[object4] < 0 ? 0 : nArray6[object4];
                            nArray3[object4] = nArray3[object4] >= ((ImplicitGrid)object3).width ? ((ImplicitGrid)object3).width - 1 : nArray3[object4];
                            nArray4[object4] = nArray4[object4] >= ((ImplicitGrid)object3).height ? ((ImplicitGrid)object3).height - 1 : nArray4[object4];
                            nArray5[object4] = nArray5[object4] >= ((ImplicitGrid)object3).width ? ((ImplicitGrid)object3).width - 1 : nArray5[object4];
                            nArray7 = nArray6;
                            n6 = object4;
                            n5 = nArray6[object4] >= ((ImplicitGrid)object3).height ? ((ImplicitGrid)object3).height - 1 : nArray6[object4];
                        }
                        nArray7[n6] = n5;
                        int n7 = object4;
                        nArray3[n7] = nArray3[n7] * ((ImplicitGrid)object3).numChunksPerCell;
                        int n8 = object4;
                        nArray4[n8] = nArray4[n8] * ((ImplicitGrid)object3).numChunksPerCell;
                        int n9 = object4;
                        nArray5[n9] = nArray5[n9] * ((ImplicitGrid)object3).numChunksPerCell;
                        int n10 = object4++;
                        nArray6[n10] = nArray6[n10] * ((ImplicitGrid)object3).numChunksPerCell;
                    }
                    object4 = 0;
                    for (int i = 0; i != ((ImplicitGrid)object3).numChunksPerCell; ++i) {
                        long l = 0L;
                        for (int j = 0; j < object; ++j) {
                            int n11;
                            long l2 = 0L;
                            long l3 = 0L;
                            for (n11 = nArray3[j]; n11 <= nArray5[j]; n11 += ((ImplicitGrid)object3).numChunksPerCell) {
                                l2 |= ((ImplicitGrid)object3).cols[n11 + i];
                            }
                            for (n11 = nArray4[j]; n11 <= nArray6[j]; n11 += ((ImplicitGrid)object3).numChunksPerCell) {
                                l3 |= ((ImplicitGrid)object3).rows[n11 + i];
                            }
                            l |= l3 & l2;
                        }
                        while (l != 0L) {
                            long l4;
                            long cfr_ignored_0 = l & -l;
                            if (0L == 0L || i != -1) {
                                n4 = 0;
                                if ((l4 & 0xFFFFFFFFL) == 0L) {
                                    n4 += 32;
                                }
                                if ((l4 & 65535L << n4) == 0L) {
                                    n4 += 16;
                                }
                                if ((l4 & 255L << n4) == 0L) {
                                    n4 += 8;
                                }
                                if ((l4 & 15L << n4) == 0L) {
                                    n4 += 4;
                                }
                                if ((l4 & 3L << n4) == 0L) {
                                    n4 += 2;
                                }
                                if ((l4 & 1L << n4) == 0L) {
                                    ++n4;
                                }
                                ((ImplicitGrid)object3).visibles[++object4] = n4 + (i << 6);
                            }
                            l ^= l4;
                        }
                    }
                    ((ImplicitGrid)object3).visibles[0] = object4;
                    nArray2 = ((ImplicitGrid)object3).visibles;
                }
                nArray = nArray2;
            } else {
                nArray = this.dummyVisibleObjects;
                this.dummyVisibleObjects[0] = this._dynamicObjects_len;
            }
            for (n4 = 0; n4 < this.visibleObjectsMask.length; ++n4) {
                this.visibleObjectsMask[n4] = 0L;
            }
            for (n4 = 1; n4 <= nArray[0]; ++n4) {
                int n12 = nArray[n4];
                int n13 = n2 = n12 >> 6;
                this.visibleObjectsMask[n13] = this.visibleObjectsMask[n13] | 1L << n12 - (n2 << 6);
            }
            for (n4 = 0; n4 < this._springs_len; ++n4) {
                if (!this.objectPairIsActive(this._springs[n4].obj1, this._springs[n4].obj2)) continue;
                this._springs[n4]._applyForces();
            }
            for (n4 = 1; n4 <= nArray[0]; ++n4) {
                object3 = this._dynamicObjects[nArray[n4]];
                if (((DynamicObject)object3).isAsleep()) continue;
                ((DynamicObject)object3).addForceTimesMass(this.gravity);
                ((DynamicObject)object3)._updateDynamics();
            }
            for (n4 = 1; n4 <= nArray[0]; ++n4) {
                Object object5;
                DynamicObject dynamicObject = this._dynamicObjects[nArray[n4]];
                object3 = this;
                n = 0;
                if (((DynamicWorld)object3).type == 0) {
                    physicalObject = dynamicObject;
                    object2 = ((DynamicWorld)object3)._bp_grid_dynamic.queryArea(dynamicObject._id, ((DynamicWorld)object3)._dynamicObjects_len, physicalObject.boundingBox);
                    for (object = 1; object <= object2[0]; ++object) {
                        DynamicObject dynamicObject2;
                        DynamicObject dynamicObject3 = ((DynamicWorld)object3)._dynamicObjects[object2[object]];
                        if (dynamicObject.isAsleep() && dynamicObject3.isAsleep()) continue;
                        physicalObject = dynamicObject;
                        physicalObject = dynamicObject3;
                        if (!MathUtils.boundingBoxesOverlap(dynamicObject2.boundingBox, physicalObject.boundingBox) || !dynamicObject.canCollideWith(dynamicObject3) || !dynamicObject3.canCollideWith(dynamicObject)) continue;
                        n = super._applyCollisionBetweenObjects(dynamicObject, dynamicObject3) ? 1 : n;
                    }
                    if (!dynamicObject.isAsleep()) {
                        physicalObject = dynamicObject;
                        object2 = ((DynamicWorld)object3)._bp_grid_static.queryArea(-1, ((DynamicWorld)object3)._staticObjects_len, physicalObject.boundingBox);
                        for (object = 1; object <= object2[0]; ++object) {
                            DynamicObject dynamicObject4;
                            StaticObject staticObject = ((DynamicWorld)object3)._staticObjects[object2[object]];
                            physicalObject = dynamicObject;
                            physicalObject = staticObject;
                            if (!MathUtils.boundingBoxesOverlap(dynamicObject4.boundingBox, physicalObject.boundingBox) || !dynamicObject.canCollideWith(staticObject) || !staticObject.canCollideWith(dynamicObject)) continue;
                            n = super._applyCollisionBetweenObjects(dynamicObject, staticObject) ? 1 : n;
                        }
                    }
                }
                if (((DynamicWorld)object3)._staticTiles == null || dynamicObject.isAsleep()) continue;
                ((DynamicWorld)object3).posChange.zero();
                ((DynamicWorld)object3).posChange_count = 0;
                physicalObject = dynamicObject;
                object2 = physicalObject.boundingBox;
                object = physicalObject.boundingBox[0] < object2[2] ? object2[0] : object2[2];
                Object object6 = object2[1] < object2[3] ? object2[1] : object2[3];
                Object object7 = object2[0] > object2[2] ? object2[0] : object2[2];
                Object e = object5 = object2[1] > object2[3] ? object2[1] : object2[3];
                if (((DynamicWorld)object3).tileSize_shift != 0) {
                    object >>= ((DynamicWorld)object3).tileSize_shift;
                    object6 = object6 >> ((DynamicWorld)object3).tileSize_shift;
                    object7 = object7 >> ((DynamicWorld)object3).tileSize_shift;
                    object5 = object5 >> ((DynamicWorld)object3).tileSize_shift;
                } else {
                    object /= ((DynamicWorld)object3).tileSize;
                    object6 = object6 / ((DynamicWorld)object3).tileSize;
                    object7 = object7 / ((DynamicWorld)object3).tileSize;
                    object5 = object5 / ((DynamicWorld)object3).tileSize;
                }
                Object object8 = object < 0 ? 0 : (object = object >= ((DynamicWorld)object3)._staticTiles.length ? ((DynamicWorld)object3)._staticTiles.length - 1 : object);
                object6 = object6 < 0 ? 0 : (int)(object6 >= ((DynamicWorld)object3)._staticTiles[0].length ? ((DynamicWorld)object3)._staticTiles[0].length - 1 : object6);
                object7 = object7 < 0 ? 0 : (int)(object7 >= ((DynamicWorld)object3)._staticTiles.length ? ((DynamicWorld)object3)._staticTiles.length - 1 : object7);
                object5 = object5 < 0 ? 0 : (int)(object5 >= ((DynamicWorld)object3)._staticTiles[0].length ? ((DynamicWorld)object3)._staticTiles[0].length - 1 : object5);
                for (Object object9 = object; object9 <= object7; ++object9) {
                    for (object4 = (Object)object6; object4 <= object5; ++object4) {
                        StaticObject staticObject;
                        if (((DynamicWorld)object3)._staticTiles[object9][object4] == -1 || !dynamicObject.canCollideWith(staticObject = ((DynamicWorld)object3)._tileObjects[((DynamicWorld)object3)._staticTiles[object9][object4]]) || !staticObject.canCollideWith(dynamicObject)) continue;
                        physicalObject = staticObject;
                        Vector2 vector2 = physicalObject.centerPos;
                        if (((DynamicWorld)object3).tileSize_shift != 0) {
                            vector2.x = (object9 << ((DynamicWorld)object3).tileSize_shift) + (((DynamicWorld)object3).tileSize >> 1);
                            vector2.y = (object4 << ((DynamicWorld)object3).tileSize_shift) + (((DynamicWorld)object3).tileSize >> 1);
                        } else {
                            vector2.x = object9 * ((DynamicWorld)object3).tileSize + (((DynamicWorld)object3).tileSize >> 1);
                            vector2.y = object4 * ((DynamicWorld)object3).tileSize + (((DynamicWorld)object3).tileSize >> 1);
                        }
                        n = super._applyCollisionBetweenObjects(dynamicObject, staticObject, ((DynamicWorld)object3).tileObjects_validEdges[((DynamicWorld)object3)._staticTiles[object9][object4]], ((DynamicWorld)object3).tileObjects_useAxis[((DynamicWorld)object3)._staticTiles[object9][object4]]) ? 1 : n;
                    }
                }
                if (((DynamicWorld)object3).posChange_count == 0) continue;
                ((DynamicWorld)object3).posChange.divide(((DynamicWorld)object3).posChange_count);
                dynamicObject.translatePosition(((DynamicWorld)object3).posChange);
            }
            for (n4 = 0; n4 < this.jointUpdateIterations; ++n4) {
                for (int i = 0; i < this._joints_len; ++i) {
                    if (!this.objectPairIsActive(this._joints[i].obj1, this._joints[i].obj2)) continue;
                    this._joints[i]._applyImpulse();
                }
            }
        }
    }

    private boolean _applyCollisionBetweenObjects(PhysicalObject physicalObject, PhysicalObject physicalObject2) {
        return this._applyCollisionBetweenObjects(physicalObject, physicalObject2, null, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean _applyCollisionBetweenObjects(PhysicalObject physicalObject, PhysicalObject physicalObject2, boolean[] blArray, boolean n) {
        int n2;
        int n3;
        int[][] nArrayArray;
        int n4;
        int n5;
        int[] nArray;
        DynamicWorld.n.zero();
        int[] nArray2 = t;
        Vector2 vector2 = DynamicWorld.n;
        int n6 = n;
        boolean[] blArray2 = blArray;
        PhysicalObject physicalObject3 = physicalObject2;
        PhysicalObject physicalObject4 = physicalObject;
        DynamicWorld dynamicWorld = this;
        Object object = physicalObject4;
        object = ((PhysicalObject)object).collisionProxy;
        Vector2[] vector2Array = ((CollisionProxy)object).data;
        object = physicalObject3;
        object = ((PhysicalObject)object).collisionProxy;
        Vector2[] vector2Array2 = ((CollisionProxy)object).data;
        if (vector2Array.length == 1 && vector2Array2.length == 1) {
            return false;
        }
        Matrix2x2 matrix2x2 = physicalObject3.getOrientation();
        Object object2 = physicalObject4.getOrientation();
        DynamicWorld.relOrient[0] = (int)((long)((Matrix2x2)object2).data[0][0] * (long)matrix2x2.data[0][0] + (long)((Matrix2x2)object2).data[0][1] * (long)matrix2x2.data[0][1] >> 10);
        DynamicWorld.relOrient[1] = (int)((long)((Matrix2x2)object2).data[0][0] * (long)matrix2x2.data[1][0] + (long)((Matrix2x2)object2).data[0][1] * (long)matrix2x2.data[1][1] >> 10);
        DynamicWorld.relOrient[2] = (int)((long)((Matrix2x2)object2).data[1][0] * (long)matrix2x2.data[0][0] + (long)((Matrix2x2)object2).data[1][1] * (long)matrix2x2.data[0][1] >> 10);
        DynamicWorld.relOrient[3] = (int)((long)((Matrix2x2)object2).data[1][0] * (long)matrix2x2.data[1][0] + (long)((Matrix2x2)object2).data[1][1] * (long)matrix2x2.data[1][1] >> 10);
        object = physicalObject4;
        Vector2 vector22 = ((PhysicalObject)object).centerPos;
        object = physicalObject3;
        Vector2 vector23 = ((PhysicalObject)object).centerPos;
        int n7 = (int)((long)(vector22.x - vector23.x) * (long)matrix2x2.data[0][0] + (long)(vector22.y - vector23.y) * (long)matrix2x2.data[1][0] >> 10);
        int n8 = (int)((long)(vector22.x - vector23.x) * (long)matrix2x2.data[0][1] + (long)(vector22.y - vector23.y) * (long)matrix2x2.data[1][1] >> 10);
        int n9 = 0;
        if (vector2Array.length > 1) {
            int n10;
            int n11;
            int n12 = vector2Array.length;
            if (n12 == 2) {
                n11 = 1;
                n10 = 0;
            } else {
                n11 = 0;
                n10 = n12 - 1;
            }
            while (n11 < n12) {
                int[] nArray3 = axes[n9];
                nArray = nArray3;
                nArray3[0] = vector2Array[n10].y - vector2Array[n11].y;
                nArray[1] = vector2Array[n11].x - vector2Array[n10].x;
                n5 = (int)((long)nArray[0] * (long)relOrient[0] + (long)nArray[1] * (long)relOrient[1] >> 10);
                n4 = (int)((long)nArray[0] * (long)relOrient[2] + (long)nArray[1] * (long)relOrient[3] >> 10);
                nArray[0] = n5;
                nArray[1] = n4;
                if (!DynamicWorld.intervalIntersect$61ce288c(vector2Array, vector2Array2, n7, n8, relOrient, nArray, taxes, n9)) {
                    return false;
                }
                if (n6 != 0) {
                    ++n9;
                }
                n10 = n11++;
            }
        }
        if (vector2Array2.length > 1) {
            int n13;
            int n14;
            int n15 = vector2Array2.length;
            if (n15 == 2) {
                n14 = 1;
                n13 = 0;
            } else {
                n14 = 0;
                n13 = n15 - 1;
            }
            while (n14 < n15) {
                if (blArray2 == null || blArray2[n13]) {
                    int[] nArray4 = axes[n9];
                    nArray = nArray4;
                    nArray4[0] = vector2Array2[n13].y - vector2Array2[n14].y;
                    nArray[1] = vector2Array2[n14].x - vector2Array2[n13].x;
                    if (!DynamicWorld.intervalIntersect$61ce288c(vector2Array, vector2Array2, n7, n8, relOrient, nArray, taxes, n9)) {
                        return false;
                    }
                    ++n9;
                }
                n13 = n14++;
            }
        }
        if (vector2Array.length == 2) {
            int[] nArray5 = axes[n9];
            object2 = nArray5;
            nArray5[0] = vector2Array[0].y - vector2Array[1].y;
            object2[1] = vector2Array[1].x - vector2Array[0].x;
            int n16 = (int)((long)object2[0] * (long)relOrient[0] + (long)object2[1] * (long)relOrient[1] >> 10);
            int n17 = (int)((long)object2[0] * (long)relOrient[2] + (long)object2[1] * (long)relOrient[3] >> 10);
            object2[0] = n16;
            object2[1] = n17;
            if (!DynamicWorld.intervalIntersect$61ce288c(vector2Array, vector2Array2, n7, n8, relOrient, (int[])object2, taxes, n9)) {
                return false;
            }
            ++n9;
        }
        if (vector2Array2.length == 2) {
            int[] nArray6 = axes[n9];
            object2 = nArray6;
            nArray6[0] = vector2Array2[0].y - vector2Array2[1].y;
            object2[1] = vector2Array2[1].x - vector2Array2[0].x;
            if (!DynamicWorld.intervalIntersect$61ce288c(vector2Array, vector2Array2, n7, n8, relOrient, (int[])object2, taxes, n9)) {
                return false;
            }
            ++n9;
        }
        int[] nArray7 = nArray2;
        vector2Array2 = vector2;
        int n18 = n9;
        int[] nArray8 = taxes;
        int[][] nArray9 = axes;
        int n19 = -1;
        int n20 = 0;
        for (int i = 0; i < n18; ++i) {
            int n21 = MathUtils.vectorLength(nArray9[i][0], nArray9[i][1]);
            nArray8[i] = (int)(((long)nArray8[i] << 10) / (long)n21);
            if (n19 != -1 && nArray8[i] <= nArray7[0]) continue;
            n19 = i;
            n20 = n21;
            nArray7[0] = nArray8[i];
            vector2Array2.x = nArray9[i][0];
            vector2Array2.y = nArray9[i][1];
        }
        int n22 = n20;
        vector2.divideWithShift(n22);
        vector2.multiplyWithShift(matrix2x2);
        boolean bl = true;
        if (!bl) return false;
        n = t[0];
        boolean bl2 = true;
        if (!physicalObject.notifyBeforeCollisionResponse$2b11b2a(physicalObject2, DynamicWorld.n.x, DynamicWorld.n.y)) {
            bl2 = false;
        }
        if (!physicalObject2.notifyBeforeCollisionResponse$2b11b2a(physicalObject, -DynamicWorld.n.x, -DynamicWorld.n.y)) {
            return false;
        }
        if (!bl2) {
            return false;
        }
        if (n < 0) {
            Vector2 vector24;
            boolean bl3 = blArray != null;
            long l = DynamicWorld.n.y * -n >> 10;
            long l2 = DynamicWorld.n.x * -n >> 10;
            physicalObject3 = physicalObject2;
            physicalObject4 = physicalObject;
            dynamicWorld = this;
            long l3 = physicalObject4.getInvMass_shifted2();
            long l4 = physicalObject3.getInvMass_shifted2();
            long l5 = l3 + l4;
            l2 = l2 * 1034L >> 10;
            l = l * 1034L >> 10;
            if (l3 > 0L) {
                n8 = (int)(l2 * l3 / l5);
                n9 = (int)(l * l3 / l5);
                if (bl3) {
                    dynamicWorld.posChange.x += n8;
                    dynamicWorld.posChange.y += n9;
                    ++dynamicWorld.posChange_count;
                } else {
                    DynamicObject dynamicObject = (DynamicObject)physicalObject4;
                    object = dynamicObject;
                    vector24 = dynamicObject.centerPos;
                    vector24.x += n8;
                    vector24.y += n9;
                    dynamicObject.recomputeBoundingBox();
                }
            }
            if (l4 > 0L) {
                n8 = (int)(l2 * -l4 / l5);
                n9 = (int)(l * -l4 / l5);
                DynamicObject dynamicObject = (DynamicObject)physicalObject3;
                object = dynamicObject;
                vector24 = dynamicObject.centerPos;
                vector24.x += n8;
                vector24.y += n9;
                dynamicObject.recomputeBoundingBox();
            }
        } else if (n != 0 && physicalObject2.getInvMass_shifted2() == 0) {
            ((DynamicObject)physicalObject).translatePosition(physicalObject.getLinearVelocity().timesWithShift(n - 10));
        }
        int[][] nArrayArray2 = new int[2][];
        int[][] nArrayArray3 = nArrayArray = new int[2][];
        int[][] nArrayArray4 = nArrayArray2;
        n6 = n;
        Vector2 vector25 = DynamicWorld.n;
        physicalObject3 = physicalObject2;
        physicalObject4 = physicalObject;
        dynamicWorld = this;
        int n23 = 0;
        int n24 = DynamicWorld.findSupportPoints(vector25.x, vector25.y, n6, physicalObject4, supPoints1);
        int n25 = DynamicWorld.findSupportPoints(-vector25.x, -vector25.y, n6, physicalObject3, supPoints2);
        if (n24 == 1 && n25 == 1) {
            nArrayArray4[0] = supPoints1[0];
            nArrayArray3[0] = supPoints2[0];
            n3 = 1;
        } else {
            int n26;
            int n27 = -vector25.y;
            int n28 = vector25.x;
            n7 = n26 = (int)((long)supPoints1[0][0] * (long)n27 + (long)supPoints1[0][1] * (long)n28 >> 10);
            n9 = n8 = (int)((long)supPoints2[0][0] * (long)n27 + (long)supPoints2[0][1] * (long)n28 >> 10);
            if (n24 == 2 && (n7 = (int)((long)supPoints1[1][0] * (long)n27 + (long)supPoints1[1][1] * (long)n28 >> 10)) < n26) {
                n7 ^= n26;
                n26 ^= n7;
                n7 ^= n26;
                int[] nArray10 = supPoints1[0];
                nArray10[0] = nArray10[0] ^ supPoints1[1][0];
                int[] nArray11 = supPoints1[1];
                nArray11[0] = nArray11[0] ^ supPoints1[0][0];
                int[] nArray12 = supPoints1[0];
                nArray12[0] = nArray12[0] ^ supPoints1[1][0];
                int[] nArray13 = supPoints1[0];
                nArray13[1] = nArray13[1] ^ supPoints1[1][1];
                int[] nArray14 = supPoints1[1];
                nArray14[1] = nArray14[1] ^ supPoints1[0][1];
                int[] nArray15 = supPoints1[0];
                nArray15[1] = nArray15[1] ^ supPoints1[1][1];
            }
            if (n25 == 2 && (n9 = (int)((long)supPoints2[1][0] * (long)n27 + (long)supPoints2[1][1] * (long)n28 >> 10)) < n8) {
                n9 ^= n8;
                n8 ^= n9;
                n9 ^= n8;
                int[] nArray16 = supPoints2[0];
                nArray16[0] = nArray16[0] ^ supPoints2[1][0];
                int[] nArray17 = supPoints2[1];
                nArray17[0] = nArray17[0] ^ supPoints2[0][0];
                int[] nArray18 = supPoints2[0];
                nArray18[0] = nArray18[0] ^ supPoints2[1][0];
                int[] nArray19 = supPoints2[0];
                nArray19[1] = nArray19[1] ^ supPoints2[1][1];
                int[] nArray20 = supPoints2[1];
                nArray20[1] = nArray20[1] ^ supPoints2[0][1];
                int[] nArray21 = supPoints2[0];
                nArray21[1] = nArray21[1] ^ supPoints2[1][1];
            }
            if (n26 > n9) return false;
            if (n8 > n7) {
                return false;
            }
            if (n26 == n8) {
                nArrayArray4[0] = supPoints1[0];
                nArrayArray3[0] = supPoints2[0];
                ++n23;
            } else if (n26 > n8) {
                nArrayArray4[0] = supPoints1[0];
                nArrayArray3[0] = DynamicWorld.projectPointToSegment(supPoints1[0], supPoints2[0], supPoints2[1]);
                ++n23;
            } else {
                nArrayArray4[0] = DynamicWorld.projectPointToSegment(supPoints2[0], supPoints1[0], supPoints1[1]);
                nArrayArray3[0] = supPoints2[0];
                ++n23;
            }
            if (n7 != n26 && n9 != n8) {
                if (n7 <= n9) {
                    nArrayArray4[1] = supPoints1[1];
                    nArrayArray3[1] = DynamicWorld.projectPointToSegment(supPoints1[1], supPoints2[0], supPoints2[1]);
                } else {
                    nArrayArray4[1] = DynamicWorld.projectPointToSegment(supPoints2[1], supPoints1[0], supPoints1[1]);
                    nArrayArray3[1] = supPoints2[1];
                    ++n23;
                }
            }
            n3 = n2 = ++n23;
        }
        if (n3 == 0) {
            return false;
        }
        if (blArray != null && n2 == 2) {
            n2 = 1;
            nArrayArray2[0][0] = nArrayArray2[0][0] + nArrayArray2[1][0] >> 1;
            nArrayArray2[0][1] = nArrayArray2[0][1] + nArrayArray2[1][1] >> 1;
            nArrayArray[0][0] = nArrayArray[0][0] + nArrayArray[1][0] >> 1;
            nArrayArray[0][1] = nArrayArray[0][1] + nArrayArray[1][1] >> 1;
        }
        this.linVelChange[0].zero();
        this.angVelChange[0] = 0;
        this.linVelChange[1].zero();
        this.angVelChange[1] = 0;
        for (int i = 0; i < n2; ++i) {
            int n29;
            int n30 = n;
            Vector2 vector26 = DynamicWorld.n;
            int[] nArray22 = nArrayArray[i];
            int[] nArray23 = nArrayArray2[i];
            physicalObject3 = physicalObject2;
            physicalObject4 = physicalObject;
            dynamicWorld = this;
            object = physicalObject4;
            Vector2 vector27 = ((PhysicalObject)object).centerPos;
            object = physicalObject3;
            Vector2 vector28 = ((PhysicalObject)object).centerPos;
            n25 = vector27.x;
            int n31 = vector27.y;
            int n32 = vector28.x;
            int n33 = vector28.y;
            Vector2 vector29 = physicalObject4.getLinearVelocity();
            Vector2 vector210 = physicalObject3.getLinearVelocity();
            if (n30 > 0) {
                n25 = (int)((long)n25 + ((long)vector29.x * (long)n30 >> 10));
                n31 = (int)((long)n31 + ((long)vector29.y * (long)n30 >> 10));
                if (vector210 != Vector2.ZERO) {
                    n32 = (int)((long)n32 + ((long)vector210.x * (long)n30 >> 10));
                    n33 = (int)((long)n33 + ((long)vector210.y * (long)n30 >> 10));
                }
            }
            n9 = nArray23[0] - n25;
            n23 = nArray23[1] - n31;
            int n34 = nArray22[0] - n32;
            int n35 = nArray22[1] - n33;
            n31 = physicalObject4.getAngularVelocity_shifted();
            n32 = vector29.x + (int)((long)(-n23) * (long)n31 >> 20);
            n33 = vector29.y + (int)((long)n9 * (long)n31 >> 20);
            if (vector210 != Vector2.ZERO) {
                int n36 = physicalObject3.getAngularVelocity_shifted();
                n32 -= vector210.x + (int)((long)(-n35) * (long)n36 >> 20);
                n33 -= vector210.y + (int)((long)n34 * (long)n36 >> 20);
            }
            if (n32 == 0 && n33 == 0 || (n29 = (int)((long)n32 * (long)vector26.x + (long)n33 * (long)vector26.y >> 10)) > 0) continue;
            n5 = physicalObject4.getInvMass_shifted2();
            n4 = physicalObject3.getInvMass_shifted2();
            int n37 = physicalObject4.getInvInertia_shifted2();
            int n38 = physicalObject3.getInvInertia_shifted2();
            long l = 0L;
            if (n37 > 0) {
                int n39 = (int)((long)n9 * (long)vector26.y - (long)n23 * (long)vector26.x >> 10);
                l = 0L + (((long)n39 * (long)n39 >> 10) * (long)n37 >> 20);
            }
            if (n38 > 0) {
                int n40 = (int)((long)n34 * (long)vector26.y - (long)n35 * (long)vector26.x >> 10);
                l += ((long)n40 * (long)n40 >> 10) * (long)n38 >> 20;
            }
            if ((l += (long)(n5 + n4 >> 10)) == 0L) {
                DynamicWorld._error((byte)7);
            }
            PhysicalObject physicalObject5 = physicalObject4;
            object = physicalObject5;
            object = physicalObject3;
            long l6 = -(((long)n29 * (long)(1024 + (physicalObject5.coefOfRestitution + ((PhysicalObject)object).coefOfRestitution >> 1)) << 10) / l);
            n31 = (int)(l6 * (long)vector26.x >> 10);
            n25 = (int)(l6 * (long)vector26.y >> 10);
            int n41 = 0;
            n29 = 0;
            int n42 = 0;
            object = physicalObject4;
            short s = ((PhysicalObject)object).coefOfFriction;
            object = physicalObject3;
            int n43 = ((PhysicalObject)object).coefOfFriction;
            object = physicalObject4;
            object = ((PhysicalObject)object).collisionProxy;
            if (((CollisionProxy)object).data.length != 1) {
                object = physicalObject3;
                object = ((PhysicalObject)object).collisionProxy;
                if (((CollisionProxy)object).data.length != 1 && s + n43 != 0) {
                    n41 = -vector26.y;
                    n29 = vector26.x;
                    n42 = (int)((long)n32 * (long)n41 + (long)n33 * (long)n29 >> 10);
                    if (n42 == 0) {
                        n29 = 0;
                        n41 = 0;
                    } else if (n42 > 0) {
                        n41 = -n41;
                        n29 = -n29;
                    }
                }
            }
            if (n41 != 0 || n29 != 0) {
                l = 0L;
                if (n37 > 0) {
                    int n44 = (int)((long)n9 * (long)n29 - (long)n23 * (long)n41 >> 10);
                    l = 0L + (((long)n44 * (long)n44 >> 10) * (long)n37 >> 20);
                }
                if (n38 > 0) {
                    n43 = (int)((long)n34 * (long)n29 - (long)n35 * (long)n41 >> 10);
                    l += ((long)n43 * (long)n43 >> 10) * (long)n38 >> 20;
                }
                if ((l += (long)(n5 + n4 >> 10)) == 0L) {
                    DynamicWorld._error((byte)7);
                }
                long l7 = ((long)(n42 < 0 ? -n42 : n42) << 20) / l;
                PhysicalObject physicalObject6 = physicalObject4;
                object = physicalObject6;
                object = physicalObject3;
                if ((l7 < 0L ? -l7 : l7) > (long)((n37 = (int)(l6 * (long)(physicalObject6.coefOfFriction + ((PhysicalObject)object).coefOfFriction >> 1) >> 10)) < 0 ? -n37 : n37)) {
                    l7 = n37;
                }
                n31 = (int)((long)n31 + (l7 * (long)n41 >> 10));
                n25 = (int)((long)n25 + (l7 * (long)n29 >> 10));
            }
            if (n5 > 0) {
                dynamicWorld.applyImpulse((DynamicObject)physicalObject4, n31, n25, n9, n23, 0);
            }
            if (n4 <= 0) continue;
            dynamicWorld.applyImpulse((DynamicObject)physicalObject3, -n31, -n25, n34, n35, 1);
        }
        if (physicalObject.getMass_shiftedRight() > 0) {
            DynamicObject dynamicObject = (DynamicObject)physicalObject;
            dynamicObject.getLinearVelocity().add(this.linVelChange[0]);
            dynamicObject.setAngularVelocity_shifted(dynamicObject.getAngularVelocity_shifted() + this.angVelChange[0]);
            if (dynamicObject.isAsleep()) {
                dynamicObject.wakeUp();
            }
        }
        if (physicalObject2.getMass_shiftedRight() > 0) {
            DynamicObject dynamicObject = (DynamicObject)physicalObject2;
            dynamicObject.getLinearVelocity().add(this.linVelChange[1]);
            dynamicObject.setAngularVelocity_shifted(dynamicObject.getAngularVelocity_shifted() + this.angVelChange[1]);
            if (dynamicObject.isAsleep()) {
                dynamicObject.wakeUp();
            }
        }
        physicalObject.notifyAfterCollisionResponse$7af36c03();
        physicalObject2.notifyAfterCollisionResponse$7af36c03();
        return true;
    }

    private void applyImpulse(DynamicObject dynamicObject, int n, int n2, int n3, int n4, int n5) {
        int n6 = dynamicObject.getInvMass_shifted2();
        this.linVelChange[n5].x = (int)((long)this.linVelChange[n5].x + ((long)n * (long)n6 >> 30));
        this.linVelChange[n5].y = (int)((long)this.linVelChange[n5].y + ((long)n2 * (long)n6 >> 30));
        int n7 = dynamicObject.getInvInertia_shifted2();
        int n8 = n5;
        this.angVelChange[n8] = this.angVelChange[n8] + (n7 == 0 ? 0 : (int)(((long)n3 * (long)n2 - (long)n4 * (long)n >> 10) * (long)n7 >> 20));
    }

    private static int[] projectPointToSegment(int[] nArray, int[] nArray2, int[] nArray3) {
        DynamicWorld.AB[0] = nArray3[0] - nArray2[0];
        DynamicWorld.AB[1] = nArray3[1] - nArray2[1];
        int n = (int)(((long)(nArray[0] - nArray2[0]) * (long)AB[0] + (long)(nArray[1] - nArray2[1]) * (long)AB[1]) / ((long)AB[0] * (long)AB[0] + (long)AB[1] * (long)AB[1] >> 10));
        if (n < 0) {
            n = 0;
        } else if (n > 1024) {
            n = 1024;
        }
        DynamicWorld.AB[0] = (int)((long)AB[0] * (long)n >> 10) + nArray2[0];
        DynamicWorld.AB[1] = (int)((long)AB[1] * (long)n >> 10) + nArray2[1];
        return AB;
    }

    private static int findSupportPoints(int n, int n2, int n3, PhysicalObject physicalObject, int[][] nArray) {
        int n4;
        int n5;
        Matrix2x2 matrix2x2 = physicalObject.getOrientation();
        int n6 = n * matrix2x2.data[0][0] + n2 * matrix2x2.data[1][0] >> 10;
        n = n * matrix2x2.data[0][1] + n2 * matrix2x2.data[1][1] >> 10;
        Object object = physicalObject;
        object = ((PhysicalObject)object).collisionProxy;
        Vector2[] vector2Array = ((CollisionProxy)object).data;
        DynamicWorld.d[0] = n5 = n6 * vector2Array[0].x + n * vector2Array[0].y >> 10;
        for (n4 = 1; n4 < vector2Array.length; ++n4) {
            DynamicWorld.d[n4] = n6 * vector2Array[n4].x + n * vector2Array[n4].y >> 10;
            if (d[n4] >= n5) continue;
            n5 = d[n4];
        }
        n4 = 0;
        boolean bl = false;
        for (int i = 0; i < vector2Array.length; ++i) {
            int n7;
            if (d[i] >= n5 + 1024) continue;
            object = physicalObject;
            object = ((PhysicalObject)object).centerPos;
            DynamicWorld.contact[0] = ((Vector2)object).x + (int)((long)vector2Array[i].x * (long)matrix2x2.data[0][0] + (long)vector2Array[i].y * (long)matrix2x2.data[0][1] >> 10);
            DynamicWorld.contact[1] = ((Vector2)object).y + (int)((long)vector2Array[i].x * (long)matrix2x2.data[1][0] + (long)vector2Array[i].y * (long)matrix2x2.data[1][1] >> 10);
            if (n3 > 0) {
                object = physicalObject.getLinearVelocity();
                contact[0] = (int)((long)contact[0] + ((long)((Vector2)object).x * (long)n3 >> 10));
                contact[1] = (int)((long)contact[1] + ((long)((Vector2)object).y * (long)n3 >> 10));
            }
            int n8 = -n * contact[0] + n6 * contact[1] >> 10;
            if (n4 < 2) {
                DynamicWorld.s[n4] = n8;
                nArray[n4][0] = contact[0];
                nArray[n4][1] = contact[1];
                if (++n4 <= 1) continue;
                bl = s[1] > s[0];
                continue;
            }
            int n9 = bl ? 0 : 1;
            int n10 = n7 = bl ? 1 : 0;
            if (n8 < s[n9]) {
                DynamicWorld.s[n9] = n8;
                nArray[n9] = contact;
                continue;
            }
            if (n8 <= s[n7]) continue;
            DynamicWorld.s[n7] = n8;
            nArray[n7] = contact;
        }
        return n4;
    }

    private static boolean intervalIntersect$61ce288c(Vector2[] vector2Array, Vector2[] vector2Array2, long l, long l2, int[] nArray, int[] nArray2, int[] nArray3, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < 2; ++i) {
            int n6;
            int n7;
            int n8;
            int n9;
            Vector2[] vector2Array3;
            if (i == 0) {
                vector2Array3 = vector2Array;
                n9 = (int)((long)nArray2[0] * (long)nArray[0] + (long)nArray2[1] * (long)nArray[2] >> 10);
                n8 = (int)((long)nArray2[0] * (long)nArray[1] + (long)nArray2[1] * (long)nArray[3] >> 10);
            } else {
                vector2Array3 = vector2Array2;
                n9 = nArray2[0];
                n8 = nArray2[1];
            }
            int n10 = n7 = (int)((long)vector2Array3[0].x * (long)n9 + (long)vector2Array3[0].y * (long)n8 >> 10);
            int n11 = vector2Array3.length;
            for (n6 = 1; n6 < n11; ++n6) {
                int n12 = (int)((long)vector2Array3[n6].x * (long)n9 + (long)vector2Array3[n6].y * (long)n8 >> 10);
                if (n12 < n10) {
                    n10 = n12;
                    continue;
                }
                if (n12 <= n7) continue;
                n7 = n12;
            }
            if (i == 0) {
                n6 = (int)(l * (long)nArray2[0] + l2 * (long)nArray2[1] >> 10);
                n2 = (n7 += n6) - (n10 += n6) >> 1;
                n3 = n7 + n10 >> 1;
                continue;
            }
            n4 = n10 - n2 - n3;
            n5 = n7 + n2 - n3;
        }
        if (n4 <= 0 && n5 >= 0) {
            if ((n4 < 0 ? -n4 : n4) < (n5 < 0 ? -n5 : n5)) {
                nArray2[0] = -nArray2[0];
                nArray2[1] = -nArray2[1];
                nArray3[n] = n4;
            } else {
                nArray3[n] = -n5;
            }
            return true;
        }
        return false;
    }

    public final int getSleepMaxCounter() {
        return this.sleepMaxCounter;
    }

    public final long getSleepLinVelThreshold_squared() {
        return this.sleepLinVelThreshold_squared;
    }

    public final int getSleepAngVelThreshold_shifted() {
        return this.sleepAngVelThreshold_shifted;
    }

    public final byte getType() {
        return this.type;
    }

    public final int[] getActiveArea() {
        return this.activeArea;
    }

    public final void setActiveArea(int[] nArray) {
        this.activeArea = nArray;
    }

    public static void _error(byte by) {
        System.out.println("Physics Error: " + by);
    }
}

