/*
 * Decompiled with CFR 0.152.
 */
package com.hardwire.dymix;

import com.hardwire.utils.Vector2;

public final class CollisionProxy {
    public int[] boundingBox;
    public Vector2[] data;
    long denom;
    long numer;
    static CollisionProxy dummyProxy;

    public CollisionProxy(Vector2[] vector2Array, boolean bl) {
        this.data = vector2Array;
        if (bl && this.data.length == 2 && this.data[0].x == -this.data[1].x && this.data[0].y == -this.data[1].y) {
            this.data[0].add(512, 512);
        }
        this.denom = 0L;
        this.numer = 0L;
        if (bl && this.data.length > 1) {
            int n = 0;
            int n2 = this.data.length - 1;
            while (n < this.data.length) {
                long l = this.data[n2].crossProductWithShift(this.data[n]);
                l = l < 0L ? -l : l;
                long l2 = this.data[n2].dotProductWithShift(this.data[n2]) + this.data[n2].dotProductWithShift(this.data[n]) + this.data[n].dotProductWithShift(this.data[n]);
                this.denom += l * l2 >> 10;
                this.numer += l;
                n2 = n++;
            }
        }
        this.boundingBox = new int[]{0, 0, 0, 0};
        this.recomputeBoundingBox(bl);
    }

    public final void recomputeBoundingBox(boolean n) {
        if (n != 0) {
            n = 0;
            for (int i = 0; i < this.data.length; ++i) {
                int n2 = this.data[i].length();
                if (n >= n2) continue;
                n = n2;
            }
            this.boundingBox[2] = this.boundingBox[3] = (n += 2048);
            this.boundingBox[0] = this.boundingBox[1] = -n;
            return;
        }
        this.boundingBox[3] = 0;
        this.boundingBox[2] = 0;
        this.boundingBox[1] = 0;
        this.boundingBox[0] = 0;
        for (n = 0; n < this.data.length; ++n) {
            this.boundingBox[0] = this.boundingBox[0] < this.data[n].x ? this.boundingBox[0] : this.data[n].x;
            this.boundingBox[1] = this.boundingBox[1] < this.data[n].y ? this.boundingBox[1] : this.data[n].y;
            this.boundingBox[2] = this.boundingBox[2] > this.data[n].x ? this.boundingBox[2] : this.data[n].x;
            this.boundingBox[3] = this.boundingBox[3] > this.data[n].y ? this.boundingBox[3] : this.data[n].y;
        }
    }

    CollisionProxy() {
        this.numer = 0L;
        this.denom = 0L;
        this.data = new Vector2[0];
        this.boundingBox = new int[]{0, 0, 0, 0};
    }
}

