/*
 * Decompiled with CFR 0.152.
 */
import com.hardwire.dymix.CollisionProxy;
import com.hardwire.dymix.DynamicObject;
import com.hardwire.dymix.PhysicalObject;
import com.hardwire.dymix.StaticObject;
import com.hardwire.utils.MathUtils;
import com.hardwire.utils.Vector2;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class StaticGameObject
extends StaticObject
implements AbstractGameObject {
    private byte[] BONUS_ANIM_MOVE = new byte[]{0, 1, 2, 3, 2, 1, 0, -1, -2, -3, -2, -1};
    public byte state;
    private byte type;
    public static CollisionProxy[] shapes;
    private Game game;
    private boolean collidedThisFrame;
    private boolean editable;
    private boolean triggerable;
    private int linkedGroupID;
    private Vector2 initialPosition = new Vector2();
    private short animPhase;
    private Image bitmapVisual;
    private static DynamicObject pingObject;
    private static Vector2 pingImpulse;
    private static Vector2 tmpVector;

    public StaticGameObject(Game game, byte by, int n) {
        this.game = game;
        this.type = by;
        this.state = 0;
        this.linkedGroupID = n;
        int n2 = -1;
        switch (this.type) {
            case 2: {
                n2 = 95;
                break;
            }
            case 6: {
                n2 = 97;
                break;
            }
            case 37: {
                n2 = 111;
                this.animPhase = (short)(2048 + this.game.gameObjectsLen % 12 * 10);
                break;
            }
            case 38: {
                n2 = 112;
                this.animPhase = (short)(2048 + this.game.gameObjectsLen % 12 * 10);
                break;
            }
            case 39: {
                n2 = 113;
                this.animPhase = (short)(2048 + this.game.gameObjectsLen % 12 * 10);
                break;
            }
            case 40: {
                n2 = 114;
            }
        }
        if (n2 != -1) {
            this.bitmapVisual = Controller.getImage(n2);
        }
    }

    public final void init(Vector2 vector2, int n) {
        if (AbstractGameObject.IS_COLLIDABLE[this.type]) {
            CollisionProxy collisionProxy = shapes[this.type];
            this.initBody(this.game.world, collisionProxy, AbstractGameObject.COEF_FRICTION[this.type], AbstractGameObject.COEF_RESTITUTION[this.type]);
            this.spawnBody(vector2, 0);
        } else {
            this.initBody(null, null);
            this._setPosition(vector2);
            this.recomputeBoundingBox();
        }
        this.state = (byte)2;
        this.userType = 2;
        this.initialPosition.copy(vector2);
        this.collidedThisFrame = true;
        this.editable = true;
        this.triggerable = false;
    }

    public final void init(DataInputStream dataInputStream) throws IOException {
        this.init(new Vector2(dataInputStream.readInt(), dataInputStream.readInt()), 0);
        this.editable = dataInputStream.readBoolean();
        this.triggerable = dataInputStream.readBoolean();
    }

    public final void saveState(DataOutputStream dataOutputStream) throws IOException {
        StaticGameObject staticGameObject = this;
        dataOutputStream.writeInt(staticGameObject.centerPos.x);
        staticGameObject = this;
        dataOutputStream.writeInt(staticGameObject.centerPos.y);
        dataOutputStream.writeBoolean(this.editable);
        dataOutputStream.writeBoolean(this.triggerable);
    }

    public final void draw(Graphics graphics) {
        Object object = this;
        object = ((PhysicalObject)object).centerPos;
        if (this.type == 11) {
            Image image = Controller.getImage(105);
            int n = Game.worldToScreen(((Vector2)object).x);
            int n2 = Game.worldToScreen(((Vector2)object).y + -16384);
            n2 += image.getHeight();
            int n3 = Game.worldToScreen(this.initialPosition.y + 16384);
            int n4 = (int)(((long)(this.initialPosition.y - ((Vector2)object).y) << 10) / 32768L);
            int n5 = n4 << 1 >> 10;
            if (n5 > 1) {
                n5 = 1;
            }
            Game.fillVerticalImageBar(graphics, Controller.getImage(n5 += 106), n, n2, n3, 1);
            graphics.drawImage(image, n, n2, 33);
            return;
        }
        if (this.type == 12 || this.type == 13) {
            Image image = Controller.getImage(this.type == 12 ? 102 : 103);
            int n = Game.worldToScreen(((Vector2)object).x);
            int n6 = Game.worldToScreen(((Vector2)object).y);
            int n7 = n;
            int n8 = Game.worldToScreen(this.initialPosition.x);
            if (this.type == 12) {
                n7 += image.getWidth() >> 1;
                n8 += image.getWidth() >> 1;
            } else {
                n7 -= image.getWidth() >> 1;
                n8 -= image.getWidth() >> 1;
            }
            int n9 = Game.worldToScreen(((Vector2)object).y);
            Game.fillHorizontalImageBar(graphics, Controller.getImage(104), n7, n8, n9, 2);
            graphics.drawImage(image, n, n6, 3);
            return;
        }
        if (this.type == 37 || this.type == 38 || this.type == 39) {
            int n = this.bitmapVisual.getHeight() / 3;
            int n10 = 0;
            int n11 = 0;
            byte by = 0;
            if ((this.animPhase & 0x800) > 0) {
                n11 = (this.animPhase & 0x7FF) / 10 % 3 - 1;
                by = this.BONUS_ANIM_MOVE[(this.animPhase & 0x7FF) / 10];
            } else {
                n10 = (3 - this.animPhase / 10 - 1) * n;
            }
            int n12 = Game.worldToScreen(((Vector2)object).x) + n11;
            int n13 = Game.worldToScreen(((Vector2)object).y) + by;
            graphics.drawRegion(this.bitmapVisual, 0, n10, this.bitmapVisual.getWidth(), n, 0, n12, n13, 3);
            return;
        }
        if (this.type == 10) {
            Image image = Controller.getImage(101);
            if (this.animPhase > 0) {
                this.animPhase = (short)(this.animPhase - Game.FRAME_NUM_PHYSICS_ITERATIONS);
                int n = (this.animPhase >> 1 & 1) == 0 ? 101 : 110;
                image = Controller.getImage(n);
            }
            graphics.drawImage(image, Game.worldToScreen(((Vector2)object).x), Game.worldToScreen(((Vector2)object).y), 3);
            return;
        }
        if (this.type == 40) {
            Image image;
            if (this.state != 4) {
                this.animPhase = (short)(this.animPhase + Game.FRAME_NUM_PHYSICS_ITERATIONS);
                image = Controller.getImage(114 + (this.animPhase >> 1) % 3);
            } else {
                image = Controller.getImage(117);
            }
            graphics.drawImage(image, Game.worldToScreen(((Vector2)object).x), Game.worldToScreen(((Vector2)object).y), 33);
            return;
        }
        if (this.bitmapVisual != null) {
            graphics.drawImage(this.bitmapVisual, Game.worldToScreen(((Vector2)object).x), Game.worldToScreen(((Vector2)object).y), 3);
        }
    }

    public final Vector2 getDrawPosition() {
        StaticGameObject staticGameObject = this;
        return staticGameObject.centerPos;
    }

    public final byte getState() {
        return this.state;
    }

    public final byte getType() {
        return this.type;
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public final int getLinkedGroupID() {
        return this.linkedGroupID;
    }

    public final void reactOnKeys() {
        StaticGameObject staticGameObject;
        Object object = this;
        object = this;
        object = ((PhysicalObject)object).collisionProxy;
        if (this.game.gameObjectKeyReaction(staticGameObject.centerPos, ((CollisionProxy)object).boundingBox, this)) {
            object = this;
            this.initialPosition.copy(((PhysicalObject)object).centerPos);
            this.recomputeBoundingBox();
        }
    }

    public final void release() {
        StaticGameObject staticGameObject = this;
        if (staticGameObject.triggerable) {
            this.state = (byte)5;
            return;
        }
        this.state = 1;
    }

    public final void trigger() {
        StaticGameObject staticGameObject = this;
        if (staticGameObject.triggerable && this.state == 5) {
            this.state = (byte)4;
        }
    }

    public final void removeFromWorld() {
        if (this.state == 0 || this.state == 6) {
            return;
        }
        this.state = (byte)6;
        if (!AbstractGameObject.IS_COLLIDABLE[this.type]) {
            return;
        }
        this.despawnBody();
    }

    public final void setEditable(boolean bl) {
        this.editable = bl;
    }

    public final void setState(byte by) {
        this.state = (byte)3;
    }

    public final void setTrigger(boolean bl) {
        this.triggerable = true;
    }

    public final void setInitialPosition(Vector2 vector2) {
        this.initialPosition = vector2;
    }

    public final void tick() {
        if (this.state == 3) {
            if (!this.collidedThisFrame) {
                this.state = (byte)2;
            } else {
                this.collidedThisFrame = false;
            }
        } else if (this.state == 4) {
            if (this.type == 11) {
                Object object = this;
                object = ((PhysicalObject)object).centerPos;
                int n = this.initialPosition.y - 32768;
                if (((Vector2)object).y > n) {
                    ((Vector2)object).y -= 5120;
                    if (((Vector2)object).y < n) {
                        ((Vector2)object).y = n;
                    }
                    this.recomputeBoundingBox();
                }
            } else if (this.type == 12) {
                Object object = this;
                object = ((PhysicalObject)object).centerPos;
                int n = this.initialPosition.x - 32768;
                if (((Vector2)object).x > n) {
                    ((Vector2)object).x -= 5120;
                    if (((Vector2)object).x < n) {
                        ((Vector2)object).x = n;
                    }
                    this.recomputeBoundingBox();
                }
            } else if (this.type == 13) {
                Object object = this;
                object = ((PhysicalObject)object).centerPos;
                int n = this.initialPosition.x + 32768;
                if (((Vector2)object).x < n) {
                    ((Vector2)object).x += 5120;
                    if (((Vector2)object).x > n) {
                        ((Vector2)object).x = n;
                    }
                    this.recomputeBoundingBox();
                }
            }
        } else if (this.state != 1 && this.state == 6 && (this.type == 37 || this.type == 38 || this.type == 39)) {
            if (this.animPhase == 0) {
                this.game.deleteGameObject(this);
                return;
            }
            this.animPhase = (short)(this.animPhase - 1);
            StaticGameObject staticGameObject = this;
            tmpVector.copy(staticGameObject.centerPos);
            StaticGameObject.tmpVector.y -= 2048;
            this._setPosition(tmpVector);
        }
        if ((this.type == 37 || this.type == 38 || this.type == 39) && (this.animPhase & 0x800) > 0) {
            this.animPhase = (short)(2048 + ((this.animPhase & 0x7FF) + 1));
            if ((this.animPhase & 0x7FF) == 120) {
                this.animPhase = (short)2048;
            }
        }
    }

    protected final boolean notifyBeforeCollisionResponse$2b11b2a(PhysicalObject object, int n, int n2) {
        this.collidedThisFrame = true;
        pingObject = null;
        if (this.state == 2) {
            this.state = (byte)3;
        }
        if (this.state == 3) {
            return false;
        }
        if (this.type == 10 && ((PhysicalObject)object).isDynamic) {
            pingObject = (DynamicObject)object;
            StaticGameObject.pingImpulse.x = -n * 10240;
            StaticGameObject.pingImpulse.y = -n2 * 10240;
            pingImpulse.shiftRight();
            this.animPhase = (short)15;
        }
        PhysicalObject physicalObject = this;
        n = physicalObject.centerPos.y > this.initialPosition.y - 32768 ? 1 : 0;
        int n3 = n = this.type == 11 && n != 0 ? 1 : 0;
        if (this.state == 4 && ((PhysicalObject)object).userType == 1 && n != 0) {
            DummyMan dummyMan = ((BodyPart)object).parentChar;
            pingObject = dummyMan.bodyParts[6];
            physicalObject = pingObject;
            pingImpulse.copy(physicalObject.centerPos);
            physicalObject = this;
            pingImpulse.subtract(physicalObject.centerPos);
            pingImpulse.normaliseWithShift();
            pingImpulse.multiplyWithShift(6144);
        }
        physicalObject = this;
        boolean bl = physicalObject.centerPos.x > this.initialPosition.x - 32768;
        physicalObject = this;
        boolean bl2 = physicalObject.centerPos.x < this.initialPosition.x + 32768;
        boolean bl3 = bl = this.type == 12 && bl || this.type == 13 && bl2;
        if (this.state == 4 && ((PhysicalObject)object).userType == 1 && bl) {
            object = ((BodyPart)object).parentChar;
            PhysicalObject physicalObject2 = pingObject = ((DummyMan)object).bodyParts[6];
            pingImpulse.copy(physicalObject2.centerPos);
            physicalObject2 = this;
            pingImpulse.subtract(physicalObject2.centerPos);
            pingImpulse.normaliseWithShift();
            pingImpulse.multiplyWithShift(5120);
        }
        if (this.type == 37 || this.type == 38 || this.type == 39) {
            this.removeFromWorld();
            this.animPhase = (short)29;
            return false;
        }
        return this.type != 40;
    }

    protected final void notifyAfterCollisionResponse$7af36c03() {
        if (pingObject != null) {
            pingObject.getLinearVelocity().add(pingImpulse);
        }
    }

    public final boolean canCollideWith(PhysicalObject physicalObject) {
        return (this.type != 11 || this.state != 5 || physicalObject.userType != 1 || this.game.dummyMen[0].state != 1) && (this.type != 37 && this.type != 38 && this.type != 39 || physicalObject.userType == 1);
    }

    public static void loadStaticData$414f9488() {
        shapes = new CollisionProxy[41];
        Vector2[][] vector2ArrayArray = new Vector2[41][];
        Controller.updateLoadBar(1);
        vector2ArrayArray[10] = MathUtils.createPoly(18, 6);
        vector2ArrayArray[12] = MathUtils.createBlock(33, 29);
        vector2ArrayArray[13] = vector2ArrayArray[12];
        vector2ArrayArray[11] = MathUtils.createBlock(32, 33);
        vector2ArrayArray[37] = MathUtils.createBlock(17, 17);
        vector2ArrayArray[38] = MathUtils.createBlock(21, 21);
        vector2ArrayArray[39] = MathUtils.createBlock(27, 27);
        vector2ArrayArray[40] = MathUtils.createPoly(18, 6);
        for (int i = 0; i < vector2ArrayArray.length; ++i) {
            if (vector2ArrayArray[i] == null) continue;
            StaticGameObject.shapes[i] = new CollisionProxy(vector2ArrayArray[i], false);
        }
        Controller.updateLoadBar(1);
    }

    static {
        pingImpulse = new Vector2();
        tmpVector = new Vector2();
    }
}

