/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Fonts {
    private static String charsetUpperChars;
    private static String charsetLowerChars;
    private static String charsetNumberChars;
    private static String charsetSpecialChars;
    private static String charsetSpecialCharsUpperCase;
    private static String charsetDiacriticChars;
    private static String baseDiacriticChars;
    private static byte[] diacriticSigns;
    public static Graphics g;
    private static byte fontsCount;
    private static Fonts[] fonts;
    private static Image[] fontImage;
    private byte height;
    private byte type;
    private byte letterHeight;
    private byte charSpacing;
    private byte lineSpacing;
    private byte spaceWidth;
    private byte diacriticsHeight;
    private byte diacriticShift;
    private byte imageIndex;
    private byte colorVariants;
    private int[] charDef;
    private byte[] charOffsetY;
    private String charset;
    private static int basicFont;
    private static int extendedFont;
    private static boolean fontSwitch;

    public static void init(int n) {
        String string = "/f";
        if (n == 10) {
            string = string + "0";
        } else if (n == 11) {
            string = string + "1";
        }
        try {
            int n2;
            int n3;
            DataInputStream dataInputStream = new DataInputStream(((Object)((Object)Main.instance)).getClass().getResourceAsStream(string));
            fontsCount = dataInputStream.readByte();
            charsetUpperChars = dataInputStream.readUTF();
            charsetLowerChars = dataInputStream.readUTF();
            charsetNumberChars = dataInputStream.readUTF();
            charsetSpecialChars = dataInputStream.readUTF();
            charsetSpecialCharsUpperCase = dataInputStream.readUTF();
            charsetDiacriticChars = dataInputStream.readUTF();
            baseDiacriticChars = dataInputStream.readUTF();
            diacriticSigns = new byte[dataInputStream.readUnsignedByte()];
            dataInputStream.readFully(diacriticSigns);
            int n4 = 0;
            fonts = new Fonts[fontsCount];
            for (n3 = 0; n3 < fontsCount; ++n3) {
                Fonts.fonts[n3] = new Fonts();
                Fonts fonts = Fonts.fonts[n3];
                Fonts.fonts[n3].type = dataInputStream.readByte();
                fonts.letterHeight = dataInputStream.readByte();
                fonts.charSpacing = dataInputStream.readByte();
                fonts.lineSpacing = dataInputStream.readByte();
                fonts.spaceWidth = dataInputStream.readByte();
                fonts.diacriticsHeight = dataInputStream.readByte();
                fonts.diacriticShift = dataInputStream.readByte();
                fonts.imageIndex = dataInputStream.readByte();
                fonts.colorVariants = (byte)(dataInputStream.readByte() + 1);
                n4 += fonts.colorVariants;
                fonts.height = (byte)(fonts.letterHeight + fonts.diacriticsHeight - fonts.diacriticShift);
                int n5 = fonts.type;
                fonts.charset = new String();
                if ((n5 & 1) != 0) {
                    fonts.charset = fonts.charset + charsetUpperChars;
                }
                if ((n5 & 2) != 0) {
                    fonts.charset = fonts.charset + charsetLowerChars;
                }
                if ((n5 & 4) != 0) {
                    fonts.charset = fonts.charset + charsetNumberChars;
                }
                if ((n5 & 8) != 0) {
                    if ((n5 & 1) != 0 && (n5 & 2) != 0) {
                        fonts.charset = fonts.charset + charsetSpecialChars;
                    } else if ((n5 & 1) != 0 && (n5 & 2) == 0) {
                        fonts.charset = fonts.charset + charsetSpecialCharsUpperCase;
                    }
                }
                n5 = dataInputStream.readUnsignedByte();
                fonts.charDef = new int[n5];
                fonts.charOffsetY = new byte[n5];
                for (n2 = 0; n2 < fonts.charDef.length; ++n2) {
                    fonts.charDef[n2] = dataInputStream.readInt();
                }
                dataInputStream.readFully(fonts.charOffsetY);
            }
            fontImage = new Image[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                int n6 = 0;
                byte by = dataInputStream.readByte();
                if ((by & 2) != 0) {
                    n6 = dataInputStream.readByte();
                }
                byte[] byArray = new byte[dataInputStream.readShort()];
                dataInputStream.readFully(byArray);
                Fonts.fontImage[n3] = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
                for (n2 = 0; n2 < n6; ++n2) {
                    dataInputStream.readFully(byArray, 41, dataInputStream.readUnsignedShort());
                    Fonts.fontImage[++n3] = Image.createImage((byte[])byArray, (int)0, (int)byArray.length);
                }
            }
            dataInputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static void drawString(int n, String string, int n2, int n3, int n4) {
        Fonts.drawString$6cf53995(n, string, n2, n3, n4);
    }

    public static void drawString$6cf53995(int n, String string, int n2, int n3, int n4) {
        int n5;
        int n6 = n & 0x1F;
        n = (n & 0xE0) >> 5;
        int n7 = string.length();
        Fonts fonts = Fonts.fonts[n6];
        Image image = fontImage[fonts.imageIndex + n];
        n3 = n3 + fonts.diacriticsHeight + fonts.diacriticShift;
        if ((n4 & 1) != 0) {
            n5 = Fonts.getStringWidth(fonts, string);
            n2 -= n5 >> 1;
        } else if ((n4 & 8) != 0) {
            n5 = Fonts.getStringWidth(fonts, string);
            n2 -= n5;
        }
        if ((n4 & 2) != 0) {
            n3 -= fonts.height >> 1;
        } else if ((n4 & 0x20) != 0) {
            n3 -= fonts.height;
        }
        for (n5 = 0; n5 < n7; ++n5) {
            int n8;
            int n9;
            char c = string.charAt(n5);
            n4 = c;
            if (c == '~') {
                fontSwitch = !fontSwitch;
                int n10 = fontSwitch ? extendedFont : basicFont;
                int n11 = n10 & 0x1F;
                n10 = (n10 & 0xE0) >> 5;
                fonts = Fonts.fonts[n11];
                image = fontImage[fonts.imageIndex + n10];
                continue;
            }
            if (n4 == 176) {
                n9 = string.charAt(++n5);
                n2 += n9;
                continue;
            }
            n9 = 0;
            if (n4 == 32 || n4 == 95) {
                n2 += fonts.spaceWidth;
                continue;
            }
            int n12 = fonts.charset.indexOf(n4);
            if (n12 < 0 && (n12 = charsetDiacriticChars.indexOf(n4)) >= 0) {
                n9 = diacriticSigns[n12];
                n8 = baseDiacriticChars.charAt(n12);
                n12 = fonts.charset.indexOf(n8);
            }
            if (n12 < 0) continue;
            n8 = fonts.charDef[n12];
            int n13 = (n8 & 0xFF000000) >>> 24;
            int n14 = n8 >> 16 & 0xFF;
            int n15 = n8 >> 8 & 0xFF;
            int n16 = fonts.charOffsetY[n12];
            g.drawRegion(image, n13, n14, n15, n8 &= 0xFF, 0, n2, n3 + n16, 20);
            int n17 = n15;
            if (n9 > 0) {
                if (n9 >= 2) {
                    --n9;
                }
                n12 = fonts.charset.length() + --n9;
                n8 = fonts.charDef[n12];
                n13 = (n8 & 0xFF000000) >>> 24;
                n14 = n8 >> 16 & 0xFF;
                n15 = n8 >> 8 & 0xFF;
                n8 &= 0xFF;
                n12 = n2 + (n17 - n15 >> 1);
                n16 = n3 + n16 + fonts.diacriticShift;
                if (n9 == 0 || n9 == 2) {
                    ++n12;
                    if (n4 == 237) {
                        ++n16;
                    }
                }
                g.drawRegion(image, n13, n14, n15, n8, 0, n12, n16 - n8, 20);
            }
            n2 += n17 + fonts.charSpacing;
        }
    }

    public static int getFontHeight(int n) {
        return Fonts.fonts[0].height;
    }

    public static int getSpaceWidth(int n) {
        return Fonts.fonts[n & 0x1F].spaceWidth;
    }

    public static int getStringWidth(int n, String string) {
        Fonts fonts = Fonts.fonts[n &= 0x1F];
        return Fonts.getStringWidth(fonts, string);
    }

    public static int getLineHeight(int n) {
        Fonts fonts = Fonts.fonts[n & 0x1F];
        return fonts.height + fonts.lineSpacing;
    }

    private static int getStringWidth(Fonts fonts, String string) {
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = string.charAt(i);
            if (n3 == 126) continue;
            if (n3 == 176) {
                n2 += string.charAt(++i);
                continue;
            }
            if (n3 == 32 || n3 == 95) {
                n2 += fonts.spaceWidth;
                continue;
            }
            int n4 = fonts.charset.indexOf(n3);
            if (n4 < 0 && (n4 = charsetDiacriticChars.indexOf(n3)) >= 0) {
                n3 = baseDiacriticChars.charAt(n4);
                n4 = fonts.charset.indexOf(n3);
            }
            if (n4 < 0) continue;
            n3 = fonts.charDef[n4];
            n3 = n3 >> 8 & 0xFF;
            n2 += n3 + fonts.charSpacing;
        }
        return n2;
    }

    public static void setFonts(int n, int n2) {
        basicFont = 2;
        extendedFont = 34;
        fontSwitch = false;
    }

    public static String[] breakText(String objectArray, int n, int n2) {
        if (Fonts.getStringWidth(n2, (String)objectArray) > n) {
            Vector<String> vector = new Vector<String>();
            int n3 = 0;
            int n4 = 0;
            int n5 = 1;
            int n6 = 0;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            while (n3 <= n4) {
                n6 = n4 < objectArray.length() ? (int)objectArray.charAt(n4) : 124;
                if (Fonts.getStringWidth(n2, objectArray.substring(n3, n4)) > n && n3 != n5) {
                    bl = bl3;
                    if (bl && bl2) {
                        vector.addElement('~' + objectArray.substring(n3, n5));
                        bl = false;
                        bl2 = false;
                    } else if (bl && !bl2) {
                        vector.addElement(objectArray.substring(n3, n5) + '~');
                        bl = false;
                        bl2 = true;
                    } else if (!bl && bl2) {
                        vector.addElement('~' + objectArray.substring(n3, n5) + '~');
                        bl = true;
                        bl2 = true;
                    } else {
                        vector.addElement(objectArray.substring(n3, n5));
                    }
                    n3 = ++n5;
                    n4 = n5;
                    continue;
                }
                if (n6 == 124) {
                    if (bl && bl2) {
                        vector.addElement('~' + objectArray.substring(n3, n4));
                        bl = false;
                        bl2 = false;
                    } else if (bl && !bl2) {
                        vector.addElement(objectArray.substring(n3, n4) + '~');
                        bl = false;
                        bl2 = true;
                    } else if (!bl && bl2) {
                        vector.addElement('~' + objectArray.substring(n3, n4) + '~');
                        bl = true;
                        bl2 = true;
                    } else {
                        vector.addElement(objectArray.substring(n3, n4));
                    }
                    if (n4 >= objectArray.length()) break;
                    n3 = ++n4;
                    n5 = n4;
                    continue;
                }
                if (n6 == 126) {
                    bl = !bl;
                    ++n4;
                    continue;
                }
                if (n6 == 32) {
                    n5 = n4++;
                    bl3 = bl;
                    continue;
                }
                ++n4;
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return new String[]{objectArray};
    }

    static {
        basicFont = 0;
        extendedFont = 0;
    }
}

