/*
 * Decompiled with CFR 0.152.
 */
package com.hardwire.dymix;

import com.hardwire.dymix.CollisionProxy;
import com.hardwire.dymix.DynamicWorld;
import com.hardwire.utils.Matrix2x2;
import com.hardwire.utils.Vector2;

public abstract class PhysicalObject {
    protected DynamicWorld world = null;
    public CollisionProxy collisionProxy;
    public int[] boundingBox = new int[4];
    public Vector2 centerPos;
    short coefOfFriction;
    short coefOfRestitution;
    public int userType;
    public boolean isDynamic;

    protected final void _initBody(DynamicWorld dynamicWorld, CollisionProxy collisionProxy, int n, int n2) {
        this.world = dynamicWorld;
        this.coefOfFriction = (short)n;
        this.coefOfRestitution = (short)n2;
        this.collisionProxy = collisionProxy;
        if (this.collisionProxy == null) {
            if (CollisionProxy.dummyProxy == null) {
                CollisionProxy.dummyProxy = new CollisionProxy();
            }
            this.collisionProxy = CollisionProxy.dummyProxy;
        }
    }

    public void spawnBody(Vector2 vector2, int n) {
        if (this.world == null) {
            DynamicWorld._error((byte)6);
        }
        this.centerPos = new Vector2(vector2);
        this._recomputeBoundingBox();
    }

    public final Vector2 getPosition() {
        return this.centerPos;
    }

    public final void _setPosition(Vector2 vector2) {
        if (this.centerPos == null) {
            this.centerPos = new Vector2();
        }
        this.centerPos.copy(vector2);
    }

    public final int[] getBoundingBox() {
        return this.boundingBox;
    }

    public final void _recomputeBoundingBox() {
        if (this.isDynamic) {
            this.boundingBox[1] = Integer.MAX_VALUE;
            this.boundingBox[0] = Integer.MAX_VALUE;
            this.boundingBox[3] = Integer.MIN_VALUE;
            this.boundingBox[2] = Integer.MIN_VALUE;
            Vector2[] vector2Array = this.collisionProxy;
            vector2Array = this.collisionProxy.data;
            Matrix2x2 matrix2x2 = this.getOrientation();
            for (int i = 0; i < vector2Array.length; ++i) {
                Vector2 vector2 = vector2Array[i];
                int n = (int)((long)vector2.x * (long)matrix2x2.data[0][0] + (long)vector2.y * (long)matrix2x2.data[0][1] >> 10) + this.centerPos.x;
                int n2 = (int)((long)vector2.x * (long)matrix2x2.data[1][0] + (long)vector2.y * (long)matrix2x2.data[1][1] >> 10) + this.centerPos.y;
                if (n < this.boundingBox[0]) {
                    this.boundingBox[0] = n;
                }
                if (n2 < this.boundingBox[1]) {
                    this.boundingBox[1] = n2;
                }
                if (n > this.boundingBox[2]) {
                    this.boundingBox[2] = n;
                }
                if (n2 <= this.boundingBox[3]) continue;
                this.boundingBox[3] = n2;
            }
        } else {
            Object object = this.collisionProxy;
            object = ((CollisionProxy)object).boundingBox;
            this.boundingBox[0] = this.centerPos.x + object[0];
            this.boundingBox[1] = this.centerPos.y + object[1];
            this.boundingBox[2] = this.centerPos.x + object[2];
            this.boundingBox[3] = this.centerPos.y + object[3];
        }
    }

    public abstract Vector2 getLinearVelocity();

    public abstract int getAngularVelocity_shifted();

    public abstract int getAngle_shifted();

    public abstract Matrix2x2 getOrientation();

    public abstract int getInvMass_shifted2();

    public abstract int getInvInertia_shifted2();

    public abstract int getMass_shiftedRight();

    public boolean canCollideWith(PhysicalObject physicalObject) {
        return true;
    }

    protected void notifyAfterCollisionResponse$7af36c03() {
    }

    protected boolean notifyBeforeCollisionResponse$2b11b2a(PhysicalObject physicalObject, int n, int n2) {
        return true;
    }
}

