/*
 * Decompiled with CFR 0.152.
 */
package com.hardwire.dymix;

import com.hardwire.dymix.CollisionProxy;
import com.hardwire.dymix.DynamicWorld;
import com.hardwire.dymix.PhysicalObject;
import com.hardwire.utils.MathUtils;
import com.hardwire.utils.Matrix2x2;
import com.hardwire.utils.Vector2;

public class DynamicObject
extends PhysicalObject {
    private Vector2 linVel;
    private Vector2 force_shiftedRight;
    private int angle_shifted;
    private int angVel_shifted;
    private long torque_shiftedRight;
    private Matrix2x2 orientation;
    private int mass_shiftedRight;
    private int inertia_shiftedRight;
    private int invMass_shifted2;
    private int invInertia_shifted2;
    private byte sleepCounter;
    private boolean spawned;
    private Vector2 draw_centerPos;
    private int draw_angle_shifted2;
    public int _id;
    private static int[] oldAABB = new int[4];
    private static Vector2 tmpVector = new Vector2();

    public final void initBody(DynamicWorld object, CollisionProxy collisionProxy, int n, int n2, int n3, boolean bl) {
        super._initBody((DynamicWorld)object, collisionProxy, n, n2);
        this.isDynamic = true;
        this.force_shiftedRight = new Vector2();
        this.torque_shiftedRight = 0L;
        this.linVel = new Vector2();
        this.angVel_shifted = 0;
        this.orientation = new Matrix2x2();
        if (n3 == 0) {
            this.mass_shiftedRight = 0;
            this.inertia_shiftedRight = 0;
            this.invMass_shifted2 = 0;
            this.invInertia_shifted2 = 0;
        } else {
            int n4 = n3;
            Object object2 = object = this;
            object2 = ((PhysicalObject)object).collisionProxy;
            if (((CollisionProxy)object2).data.length == 1) {
                super.setMass(n4 * 10);
            } else {
                object2 = object;
                object2 = ((PhysicalObject)object2).collisionProxy;
                if (((CollisionProxy)object2).data.length == 2) {
                    object2 = object;
                    object2 = ((PhysicalObject)object2).collisionProxy;
                    super.setMass(((CollisionProxy)object2).numer * (long)n4 >> 10);
                } else {
                    object2 = object;
                    object2 = ((PhysicalObject)object2).collisionProxy;
                    super.setMass(((CollisionProxy)object2).numer * (long)n4 >> 11);
                }
            }
            n4 = this.mass_shiftedRight;
            object2 = object = this;
            object2 = ((PhysicalObject)object).collisionProxy;
            if (((CollisionProxy)object2).data.length == 1) {
                super.setInertia(0L);
            } else {
                object2 = object;
                CollisionProxy collisionProxy2 = ((PhysicalObject)object2).collisionProxy;
                object2 = collisionProxy2;
                object2 = object;
                object2 = ((PhysicalObject)object2).collisionProxy;
                super.setInertia((collisionProxy2.denom * (long)n4 << 10) / ((CollisionProxy)object2).numer / 6L);
            }
        }
        this.sleepCounter = 0;
        this.spawned = false;
        this.draw_centerPos = new Vector2();
        this.draw_angle_shifted2 = Integer.MAX_VALUE;
    }

    public final void spawnBody(Vector2 vector2, int n) {
        super.spawnBody(vector2, n);
        this.angle_shifted = n;
        this.orientation.computeFromAngle(this.angle_shifted);
        this.world._addObject(this, true);
        this.spawned = true;
    }

    public final void despawnBody() {
        this.spawned = false;
        this.world._removeObject$18810be9(this);
    }

    public final Vector2 getDrawPosition() {
        if (this.draw_centerPos == null) {
            DynamicObject dynamicObject = this;
            return dynamicObject.centerPos;
        }
        return this.draw_centerPos;
    }

    public final int getDrawAngle_shifted() {
        if (this.draw_centerPos == null) {
            DynamicObject dynamicObject = this;
            return dynamicObject.angle_shifted;
        }
        return this.draw_angle_shifted2;
    }

    public final void updateDrawData() {
        if (this.draw_centerPos == null) {
            return;
        }
        Object object = this;
        object = ((PhysicalObject)object).centerPos;
        int n = this.draw_centerPos.x - ((Vector2)object).x;
        int n2 = this.draw_centerPos.y - ((Vector2)object).y;
        if (n < -512 || n > 512 || n2 < -512 || n2 > 512) {
            this.draw_centerPos.x = ((Vector2)object).x;
            this.draw_centerPos.y = ((Vector2)object).y;
        }
        object = this;
        int n3 = ((DynamicObject)object).angle_shifted;
        n = this.draw_angle_shifted2 - n3;
        if (n < -91505 || n > 91505) {
            this.draw_angle_shifted2 = n3;
        }
    }

    public final void resetDrawData() {
        if (this.draw_centerPos == null) {
            return;
        }
        Object object = this;
        object = ((PhysicalObject)object).centerPos;
        this.draw_centerPos.x = ((Vector2)object).x;
        this.draw_centerPos.y = ((Vector2)object).y;
        object = this;
        this.draw_angle_shifted2 = ((DynamicObject)object).angle_shifted;
    }

    public final void recomputeBoundingBox() {
        Object object;
        if (this.world.getType() == 0) {
            object = this;
            object = ((PhysicalObject)object).boundingBox;
            DynamicObject.oldAABB[0] = (int)object[0];
            DynamicObject.oldAABB[1] = (int)object[1];
            DynamicObject.oldAABB[2] = (int)object[2];
            DynamicObject.oldAABB[3] = (int)object[3];
        }
        this._recomputeBoundingBox();
        if (this.world.getType() == 0) {
            object = this;
            this.world._bp_grid_dynamic.updateObject(this._id, oldAABB, ((PhysicalObject)object).boundingBox);
        }
    }

    private void setMass(long l) {
        this.mass_shiftedRight = (int)(l >> 10);
        if (this.mass_shiftedRight <= 0) {
            DynamicWorld._error((byte)1);
        }
        this.invMass_shifted2 = (int)(0x10000000000L / l);
        if (this.invMass_shifted2 <= 0) {
            DynamicWorld._error((byte)1);
        }
    }

    private void setInertia(long l) {
        this.inertia_shiftedRight = (int)(l >> 10);
        if (this.inertia_shiftedRight < 0) {
            DynamicWorld._error((byte)2);
        }
        int n = this.invInertia_shifted2 = this.inertia_shiftedRight == 0 ? 0 : (int)(0x10000000000L / l);
        if (this.invInertia_shifted2 <= 0 && this.inertia_shiftedRight != 0) {
            DynamicWorld._error((byte)2);
        }
    }

    public final void addForceTimesMass(Vector2 vector2) {
        this.force_shiftedRight.x = (int)((long)this.force_shiftedRight.x + ((long)vector2.x * (long)this.mass_shiftedRight >> 10));
        this.force_shiftedRight.y = (int)((long)this.force_shiftedRight.y + ((long)vector2.y * (long)this.mass_shiftedRight >> 10));
    }

    public final void addForceAtPointInLocalCoords(Vector2 vector2, Vector2 object) {
        this.force_shiftedRight.add(vector2);
        tmpVector.copy((Vector2)object);
        object = this;
        tmpVector.multiplyTransposedWithShift(((DynamicObject)object).orientation);
        this.torque_shiftedRight -= (long)vector2.crossProduct(tmpVector);
    }

    public final void _updateDynamics() {
        if (this.world == null) {
            DynamicWorld._error((byte)6);
            return;
        }
        if (this.mass_shiftedRight == 0) {
            return;
        }
        long l = this.world.getSleepLinVelThreshold_squared();
        if (l != -1L && this.sleepCounter >= 0) {
            if (this.linVel.length_squared() < l && (this.angVel_shifted < 0 ? -this.angVel_shifted : this.angVel_shifted) < this.world.getSleepAngVelThreshold_shifted()) {
                this.sleepCounter = (byte)(this.sleepCounter + 1);
                if (this.sleepCounter > this.world.getSleepMaxCounter()) {
                    DynamicObject dynamicObject = this;
                    if (dynamicObject.sleepCounter != -2) {
                        dynamicObject.sleepCounter = (byte)-1;
                    }
                    return;
                }
            } else {
                this.sleepCounter = 0;
            }
        }
        int n = this.linVel.x;
        int n2 = this.linVel.y;
        this.angle_shifted = MathUtils.wrapAngle(this.angle_shifted + this.angVel_shifted);
        if (this.angVel_shifted != 0) {
            this.orientation.computeFromAngle(this.angle_shifted);
        }
        this.force_shiftedRight.multiplyWithShift(this.invMass_shifted2, 3);
        this.linVel.add(this.force_shiftedRight);
        if (this.inertia_shiftedRight > 0) {
            this.angVel_shifted = (int)((long)this.angVel_shifted + (this.torque_shiftedRight * (long)this.invInertia_shifted2 >> 30));
        }
        Object object = this;
        object = ((PhysicalObject)object).centerPos;
        ((Vector2)object).x += n;
        ((Vector2)object).y += n2;
        this.recomputeBoundingBox();
        this._zeroForces();
    }

    public final void translatePosition(Vector2 vector2) {
        if (!this.spawned) {
            DynamicWorld._error((byte)15);
            return;
        }
        DynamicObject dynamicObject = this;
        dynamicObject.centerPos.add(vector2);
        this.recomputeBoundingBox();
    }

    public final void changePosition(Vector2 vector2) {
        if (!this.spawned) {
            DynamicWorld._error((byte)15);
            return;
        }
        DynamicObject dynamicObject = this;
        dynamicObject.centerPos.copy(vector2);
        this.recomputeBoundingBox();
    }

    private void _zeroForces() {
        this.force_shiftedRight.zero();
        this.torque_shiftedRight = 0L;
    }

    public final int getAngle_shifted() {
        return this.angle_shifted;
    }

    public final void _setAngle_shifted(int n) {
        if (this.angle_shifted != n) {
            this.angle_shifted = MathUtils.wrapAngle(n);
            this.orientation.computeFromAngle(this.angle_shifted);
        }
    }

    public final int getAngularVelocity_shifted() {
        return this.angVel_shifted;
    }

    public final void setAngularVelocity_shifted(int n) {
        this.angVel_shifted = n;
    }

    public final int getInvInertia_shifted2() {
        return this.invInertia_shifted2;
    }

    public final int getInvMass_shifted2() {
        return this.invMass_shifted2;
    }

    public final Vector2 getLinearVelocity() {
        return this.linVel;
    }

    public final int getMass_shiftedRight() {
        return this.mass_shiftedRight;
    }

    public final Matrix2x2 getOrientation() {
        return this.orientation;
    }

    public final boolean isAsleep() {
        return this.sleepCounter == -1;
    }

    public final void setCanSleep(boolean bl) {
        this.sleepCounter = (byte)-2;
    }

    public final void forceSleep() {
        if (this.sleepCounter != -2) {
            this.sleepCounter = (byte)-1;
        }
    }

    public final void wakeUp() {
        if (this.sleepCounter != -2) {
            this.sleepCounter = 0;
            this._zeroForces();
        }
    }
}

