/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public final class Sound
implements PlayerListener {
    private static String[] SOUND_TYPE = new String[]{"midi", "x-wav", "mpeg", "amr", "x-tone-seq", "x-smaf", "x-mid"};
    private static byte[][] soundData;
    private static byte[] soundType;
    private static Player sound;
    private static int soundIndex;
    public static byte soundSettings;
    private static Sound instance;

    public static void init() {
        try {
            DataInputStream dataInputStream = new DataInputStream(((Object)((Object)Main.instance)).getClass().getResourceAsStream("/s"));
            int n = dataInputStream.readUnsignedByte();
            soundData = new byte[n][];
            soundType = new byte[n];
            for (int i = 0; i < n; ++i) {
                Sound.soundType[i] = dataInputStream.readByte();
                Sound.soundData[i] = new byte[dataInputStream.readUnsignedShort()];
                dataInputStream.readFully(soundData[i]);
                Controller.updateLoadBar(1);
            }
            dataInputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static void playSound(int n, int n2) {
        if (n == -1 && soundIndex == -1) {
            return;
        }
        if (n > soundType.length - 1) {
            return;
        }
        if (soundSettings == 0 && n >= 2 || soundSettings == 1 && n < 2) {
            return;
        }
        if ((n == soundIndex || n == -1) && sound != null) {
            try {
                sound.realize();
                sound.prefetch();
                sound.setLoopCount(n2);
                sound.start();
                return;
            }
            catch (Exception exception) {
                return;
            }
        }
        Sound.stopSound();
        Object object = soundData[n];
        String string = "audio/" + SOUND_TYPE[soundType[n]];
        object = new ByteArrayInputStream((byte[])object, 0, ((byte[])object).length);
        try {
            Player player = null;
            player = Manager.createPlayer((InputStream)object, (String)string);
            ((InputStream)object).close();
            player.realize();
            player.prefetch();
            player.addPlayerListener((PlayerListener)instance);
            while (player.getState() != 300) {
            }
            player.setLoopCount(n2);
            player.start();
            sound = player;
            soundIndex = n;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static void stopSound() {
        if (soundIndex >= 0 && sound != null) {
            try {
                sound.stop();
            }
            catch (Exception exception) {}
            try {
                sound.deallocate();
            }
            catch (Exception exception) {}
            try {
                sound.close();
            }
            catch (Exception exception) {}
            sound = null;
        }
        soundIndex = -1;
    }

    public static void pauseSound() {
        try {
            if (sound != null) {
                sound.stop();
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public final void playerUpdate(Player player, String string, Object object) {
    }

    static {
        soundIndex = -1;
        soundSettings = 0;
        instance = new Sound();
    }
}

