/*
 * Decompiled with CFR 0.152.
 */
import com.hardwire.dymix.CollisionProxy;
import com.hardwire.dymix.DynamicWorld;
import com.hardwire.dymix.Joint;
import com.hardwire.dymix.PhysicalObject;
import com.hardwire.dymix.Spring;
import com.hardwire.dymix.StaticObject;
import com.hardwire.utils.MathUtils;
import com.hardwire.utils.Matrix2x2;
import com.hardwire.utils.Vector2;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

final class Game {
    private Controller controller;
    public static int FRAME_NUM_PHYSICS_ITERATIONS = 2;
    private byte actQuestion = (byte)-1;
    boolean gameOver = false;
    byte state;
    byte newState;
    private byte nextState;
    private int endFailureCounter;
    public int endSuccessCounter;
    public int actionCounter;
    public byte startScript;
    public boolean replaying = false;
    private boolean forcedTimer = true;
    private boolean skipScript = false;
    private boolean k_leftPressed;
    private boolean k_rightPressed;
    private boolean k_upPressed;
    private boolean k_downPressed;
    private int trackballLeftCounter;
    private int trackballRightCounter;
    private int trackballUpCounter;
    private int trackballDownCounter;
    private static final int EXPLORE_MAP_CAM_SPEED = 40 * FRAME_NUM_PHYSICS_ITERATIONS;
    private static final int CAMERA_SPEED_COEF = 1024 * FRAME_NUM_PHYSICS_ITERATIONS / 4;
    private static final int CAMERA_MAX_SPEED = 30720 * FRAME_NUM_PHYSICS_ITERATIONS;
    private static final int CAMERA_SCRIPT_SPEED_COEF = 1024 * FRAME_NUM_PHYSICS_ITERATIONS / 2;
    private static final int CAMERA_SCRIPT_MAX_SPEED = 20480 * FRAME_NUM_PHYSICS_ITERATIONS;
    private int camX;
    private int camY;
    public boolean cameraIsStatic = false;
    public static int[] camAABB = new int[4];
    private int camDestX = -1;
    private int camDestY = -1;
    private int mapWidth;
    private int mapHeight;
    private static StaticObject[] tileObjects;
    private static CollisionProxy[] tileObjectProxies;
    private static boolean[][] validEdges;
    private static boolean[] useAxis;
    private Background background;
    public DynamicWorld world;
    private StaticObject staticWorldObject;
    private int GRAVITY = 100000;
    public DummyMan[] dummyMen;
    public AbstractGameObject[] gameObjects;
    public int gameObjectsLen;
    private int[][] availGameObjects;
    private int availGameObjectsLen;
    private int lastObjectGroupID;
    public int selObjIndex;
    public int mainObjIndex;
    private int selObjMovementSpeed;
    private int mainAnchorObjIndex;
    private int[] mainObjectAllowedBox;
    private int mainObjectAllowedBox_routerID1;
    private int mainObjectAllowedBox_routerID2;
    private int mainObjectAllowedBox_routerID3;
    private int mainObjectAllowedBox_routerID4;
    private int numEditableObjects;
    private int curTriggerIndex;
    private int imgTriggerAnimationPhase = 0;
    private int imgTriggerAnimationSubPhase = 0;
    private int objectArrows;
    private static int MAX_SCORE;
    public AbstractGameObject objective_targetObject;
    public int objective_damageScore;
    public int objective_bonusScore;
    public int objective_distanceScore;
    public int objective_numSomersaults;
    public int objective_numHeadOns;
    public int objective_numHelmetFatalities;
    public int objective_numEagles;
    public int objective_numWings;
    public int objective_totalScore;
    public boolean objective_hitTarget;
    private int[] animationPositions;
    private byte animationType = (byte)-1;
    public Spring craneSpring;
    private static final int[] TOOLBAR_ITEMIMAGES;
    private static byte[][] toolbarItems;
    private int toolbarItemsCount;
    private int toolbarSelectedIndex;
    private boolean toolbarButtonPressed;
    private int toolbarButtonPressCounter;
    private int maxToolbarIconCount;
    private int toolbarVisibleItemsCount;
    private int firstVisibleToolbarIconIndex;
    private boolean toolbarScrolled;
    private int textBoxOffsetY = 0;
    private int textBoxFormY = 0;
    private byte speakerId;
    private int textboxInnerHeight;
    private Form textboxForm;
    private static int[][] animScores;
    private int animScores_start;
    private int animScores_end;
    private static int[] BONUS_TEXT_IDS;
    private byte animBonusText_type;
    private int animBonusText_counter;
    private int kaboomFrame;
    private Vector2 kaboomPosition = new Vector2();
    private boolean saved = true;
    private byte[] savedGameState;
    public static byte[] savedReplay;
    private DataInputStream replayInputStream;
    private DataOutputStream replayOutputStream;
    private ByteArrayOutputStream replayByteOutputStream;
    private int replayTriggerCounter;
    private int replayTriggerIndex;
    public static boolean brutalityOn;
    private static int[] brutalityKeysCache;
    private boolean loadStoredGameState;
    private byte[][] loadingObjectsRouterCache;
    private int[][] loadingObjectsDefinitions;
    private static Vector2 tmpVector;
    private static Vector2[] tmpPoly;
    private static Matrix2x2 tmpMatrix;
    private static int[] VISUAL_IMAGE_REMAP;
    private static int[] activeArea;
    private int tmpCraneRestLength;
    private static Vector2 s_oldPos;

    public Game(Controller object) {
        this.controller = object;
        this.staticWorldObject = new StaticObject();
        this.staticWorldObject.initBody(null, null);
        object = this.staticWorldObject;
        CollisionProxy collisionProxy = ((PhysicalObject)object).collisionProxy;
        object = collisionProxy;
        object = collisionProxy.boundingBox;
        collisionProxy.boundingBox[0] = -10240;
        object[1] = -10240;
        object[2] = 10240;
        object[3] = 10240;
        for (int i = 0; i < tmpPoly.length; ++i) {
            Game.tmpPoly[i] = new Vector2();
        }
        savedReplay = null;
    }

    public final boolean init(boolean bl, boolean bl2) {
        Script.setGame(this);
        try {
            int n;
            this.replaying = bl2;
            if (this.replaying) {
                Game game = this;
                try {
                    game.replayInputStream = new DataInputStream(new ByteArrayInputStream(savedReplay));
                    n = game.replayInputStream.readShort();
                    game.savedGameState = null;
                    game.savedGameState = new byte[n];
                    game.replayInputStream.readFully(game.savedGameState, 0, n);
                    game.updateReplayData();
                }
                catch (Exception exception) {}
            }
            this.loadStoredGameState = this.savedGameState != null;
            this.state = 1;
            this.newState = 1;
            this.nextState = (byte)-1;
            this.craneSpring = null;
            this.objective_targetObject = null;
            DynamicGameObject.pingCooldown = 0;
            this.actionCounter = 0;
            this.curTriggerIndex = -1;
            this.mainObjIndex = -1;
            this.mainAnchorObjIndex = -1;
            Controller.cheatWinMission = false;
            this.cameraIsStatic = false;
            this.camDestX = -1;
            this.camDestY = -1;
            this.gameOver = false;
            this.forcedTimer = false;
            this.animScores_start = 0;
            this.animScores_end = 0;
            this.animBonusText_counter = -1;
            this.kaboomFrame = -1;
            if (!bl) {
                this.world = new DynamicWorld();
                this.world.init((byte)0, 204, 164709, 40);
                this.world.setGravity(new Vector2(0, this.GRAVITY));
            }
            if (!bl) {
                this.loadLevelData();
            }
            this.dummyMen = new DummyMan[1];
            this.background = new Background(this, Controller.level);
            n = 160;
            int n2 = 240;
            Background.viewW = 240;
            Background.viewH = 160;
            if (Background.cacheImage == null || 264 != Background.cacheW || 192 != Background.cacheH) {
                Background.cacheW = 264;
                Background.cacheH = 192;
                Background.cacheM = (byte)(Background.cacheW / 24);
                Background.cacheN = (byte)(Background.cacheH / 24);
                Background.cacheImage = Image.createImage((int)Background.cacheW, (int)Background.cacheH);
                Background.cache = Background.cacheImage.getGraphics();
            }
            Background.displayCenterX = 120;
            Background.displayCenterY = 80;
            if (!bl) {
                this.initCollisionTiles();
            }
            if (!bl) {
                this.initDataRequiringRouters();
            }
            if (!this.loadStoredGameState) {
                this.finishGameObjectsLoading();
            }
            if (this.loadStoredGameState) {
                this.restoreGameState();
            }
            Game game = this;
            if (game.mainObjIndex != -1 && game.gameObjects[game.mainObjIndex].getType() == 6) {
                StaticGameObject staticGameObject = (StaticGameObject)game.gameObjects[game.mainObjIndex];
                BodyPart bodyPart = game.dummyMen[0].bodyParts[6];
                Vector2 vector2 = new Vector2(0, 12288);
                Vector2 vector22 = new Vector2(-4096, 0);
                game.craneSpring = new Spring(staticGameObject, bodyPart, vector2, vector22, 10240, 40960, 40960);
                game.world.addSpring(game.craneSpring);
                if (game.loadStoredGameState) {
                    game.craneSpring.setRestLength(game.tmpCraneRestLength);
                }
                game.dummyMen[0].changeState((byte)5);
            }
            this.initObjectives();
            if (this.mainObjIndex != -1) {
                this.gameObjects[this.mainObjIndex].setEditable(false);
            }
            this.updateMainObjectAnchor();
            this.loadingObjectsDefinitions = null;
            this.loadingObjectsRouterCache = null;
            this.setSelectedObjectIndex(this.mainObjIndex);
            this.numEditableObjects = 0;
            for (int i = 0; i < this.gameObjectsLen; ++i) {
                if (!this.gameObjects[i].isEditable()) continue;
                ++this.numEditableObjects;
            }
            if (bl || this.skipScript || this.controller.gameType == 2) {
                this.skipScript = false;
                this.startScript = (byte)-1;
            }
            this.updateCamera(true);
            this.setActiveScreenArea();
            this.background.setCamera(this.camX + 120, this.camY + 80);
            Background background = this.background;
            Background.cacheI = (short)((background.cameraX - Background.displayCenterX) / 24);
            Background.cacheJ = (short)((background.cameraY - Background.displayCenterY) / 24);
            if (Background.cacheI < 0) {
                Background.cacheI = 0;
            }
            if (Background.cacheJ < 0) {
                Background.cacheJ = 0;
            }
            if (Background.cacheI + Background.cacheM > background.matrixM) {
                Background.cacheI = (byte)(background.matrixM - Background.cacheM);
            }
            if (Background.cacheJ + Background.cacheN > background.matrixN) {
                Background.cacheJ = (byte)(background.matrixN - Background.cacheN);
            }
            Background.cacheOriginX = (Background.cacheW >> 1) / 24 * 24;
            Background.cacheOriginY = (Background.cacheH >> 1) / 24 * 24;
            background.redrawCache(Background.cacheI, Background.cacheJ, Background.cacheM, Background.cacheN);
            this.background.update();
        }
        catch (Exception exception) {}
        System.gc();
        Controller.clearInputEvents();
        this.resetKeyStates();
        return true;
    }

    private void initObjectives() {
        this.objective_targetObject = null;
        for (int i = 0; i < this.gameObjectsLen; ++i) {
            if (this.gameObjects[i].getType() != 40) continue;
            this.objective_targetObject = this.gameObjects[i];
        }
    }

    public static void createProxies() {
        tileObjects = new StaticObject[22];
        tileObjectProxies = new CollisionProxy[tileObjects.length];
        validEdges = new boolean[tileObjects.length][];
        useAxis = new boolean[tileObjects.length];
        Vector2[] vector2Array = new Vector2[]{new Vector2(-16, -16), new Vector2(16, -16), new Vector2(16, 16), new Vector2(-16, 16)};
        MathUtils.shiftPoly(vector2Array);
        Vector2[] vector2Array2 = new Vector2[]{new Vector2(-16, -16), new Vector2(16, -16), new Vector2(-16, 16)};
        MathUtils.shiftPoly(vector2Array2);
        Vector2[] vector2Array3 = new Vector2[]{new Vector2(-16, 16), new Vector2(16, -16), new Vector2(16, 16)};
        MathUtils.shiftPoly(vector2Array3);
        Vector2[] vector2Array4 = new Vector2[]{new Vector2(-16, -16), new Vector2(16, -16), new Vector2(16, 16)};
        MathUtils.shiftPoly(vector2Array4);
        Vector2[] vector2Array5 = new Vector2[]{new Vector2(-16, -16), new Vector2(16, 16), new Vector2(-16, 16)};
        MathUtils.shiftPoly(vector2Array5);
        Vector2[] vector2Array6 = new Vector2[]{new Vector2(-16, 16), new Vector2(16, 0), new Vector2(16, 16)};
        MathUtils.shiftPoly(vector2Array6);
        Vector2[] vector2Array7 = new Vector2[]{new Vector2(-16, 0), new Vector2(16, -16), new Vector2(16, 16), new Vector2(-16, 16)};
        MathUtils.shiftPoly(vector2Array7);
        Vector2[] vector2Array8 = new Vector2[]{new Vector2(-16, -16), new Vector2(16, -16), new Vector2(16, 0), new Vector2(-16, 16)};
        MathUtils.shiftPoly(vector2Array8);
        Vector2[] vector2Array9 = new Vector2[]{new Vector2(-16, -16), new Vector2(16, -16), new Vector2(-16, 0)};
        MathUtils.shiftPoly(vector2Array9);
        Vector2[] vector2Array10 = new Vector2[]{new Vector2(-16, -16), new Vector2(16, -16), new Vector2(16, 0)};
        MathUtils.shiftPoly(vector2Array10);
        Vector2[] vector2Array11 = new Vector2[]{new Vector2(-16, -16), new Vector2(16, -16), new Vector2(16, 16), new Vector2(-16, 0)};
        MathUtils.shiftPoly(vector2Array11);
        Vector2[] vector2Array12 = new Vector2[]{new Vector2(-16, -16), new Vector2(16, 0), new Vector2(16, 16), new Vector2(-16, 16)};
        MathUtils.shiftPoly(vector2Array12);
        Vector2[] vector2Array13 = new Vector2[]{new Vector2(-16, 0), new Vector2(16, 16), new Vector2(-16, 16)};
        MathUtils.shiftPoly(vector2Array13);
        Game.tileObjectProxies[0] = new CollisionProxy(vector2Array, false);
        Game.validEdges[0] = new boolean[]{true, false, false, false};
        Game.useAxis[0] = false;
        Game.tileObjectProxies[1] = new CollisionProxy(vector2Array, false);
        Game.validEdges[1] = new boolean[]{true, false, false, true};
        Game.useAxis[1] = true;
        Game.tileObjectProxies[2] = new CollisionProxy(vector2Array, false);
        Game.validEdges[2] = new boolean[]{true, true, false, false};
        Game.useAxis[2] = true;
        Game.tileObjectProxies[3] = new CollisionProxy(vector2Array, false);
        Game.validEdges[3] = new boolean[]{false, true, false, false};
        Game.useAxis[3] = false;
        Game.tileObjectProxies[4] = new CollisionProxy(vector2Array, false);
        Game.validEdges[4] = new boolean[]{false, false, false, true};
        Game.useAxis[4] = false;
        Game.tileObjectProxies[5] = new CollisionProxy(vector2Array, false);
        Game.validEdges[5] = new boolean[]{false, false, true, false};
        Game.useAxis[5] = false;
        Game.tileObjectProxies[6] = new CollisionProxy(vector2Array, false);
        Game.validEdges[6] = new boolean[]{true, false, true, true};
        Game.useAxis[6] = true;
        Game.tileObjectProxies[7] = new CollisionProxy(vector2Array, false);
        Game.validEdges[7] = new boolean[]{true, false, true, false};
        Game.useAxis[7] = false;
        Game.tileObjectProxies[8] = new CollisionProxy(vector2Array, false);
        Game.validEdges[8] = new boolean[]{true, true, true, false};
        Game.useAxis[8] = true;
        Game.tileObjectProxies[9] = new CollisionProxy(vector2Array, false);
        Game.validEdges[9] = new boolean[]{true, true, true, true};
        Game.useAxis[9] = true;
        Game.tileObjectProxies[10] = new CollisionProxy(vector2Array3, false);
        Game.validEdges[10] = new boolean[]{true, false, false};
        Game.useAxis[10] = true;
        Game.tileObjectProxies[11] = new CollisionProxy(vector2Array2, false);
        Game.validEdges[11] = new boolean[]{false, true, false};
        Game.useAxis[11] = true;
        Game.tileObjectProxies[12] = new CollisionProxy(vector2Array4, false);
        Game.validEdges[12] = new boolean[]{false, false, true};
        Game.useAxis[12] = true;
        Game.tileObjectProxies[13] = new CollisionProxy(vector2Array5, false);
        Game.validEdges[13] = new boolean[]{true, false, false};
        Game.useAxis[13] = true;
        Game.tileObjectProxies[14] = new CollisionProxy(vector2Array6, false);
        Game.validEdges[14] = new boolean[]{true, false, false};
        Game.useAxis[14] = true;
        Game.tileObjectProxies[15] = new CollisionProxy(vector2Array7, false);
        Game.validEdges[15] = new boolean[]{true, false, false, false};
        Game.useAxis[15] = true;
        Game.tileObjectProxies[16] = new CollisionProxy(vector2Array8, false);
        Game.validEdges[16] = new boolean[]{false, false, true, false};
        Game.useAxis[16] = true;
        Game.tileObjectProxies[17] = new CollisionProxy(vector2Array9, false);
        Game.validEdges[17] = new boolean[]{false, true, false};
        Game.useAxis[17] = true;
        Game.tileObjectProxies[18] = new CollisionProxy(vector2Array10, false);
        Game.validEdges[18] = new boolean[]{false, false, true};
        Game.useAxis[18] = true;
        Game.tileObjectProxies[19] = new CollisionProxy(vector2Array11, false);
        Game.validEdges[19] = new boolean[]{false, false, true, false};
        Game.useAxis[19] = true;
        Game.tileObjectProxies[20] = new CollisionProxy(vector2Array12, false);
        Game.validEdges[20] = new boolean[]{true, false, false, false};
        Game.useAxis[20] = true;
        Game.tileObjectProxies[21] = new CollisionProxy(vector2Array13, false);
        Game.validEdges[21] = new boolean[]{true, false, false};
        Game.useAxis[21] = true;
        for (int i = 0; i < tileObjects.length; ++i) {
            Game.tileObjects[i] = new StaticObject();
            Game.tileObjects[i].userType = 3;
        }
    }

    public final void setCameraDestination(int n, int n2) {
        this.camDestX = n;
        this.camDestY = n2;
    }

    public final boolean isCameraDestinationReached() {
        if (this.camDestX == -1 || this.camDestY == -1) {
            return true;
        }
        int n = this.camDestX - 120;
        int n2 = this.camDestY - 80;
        int n3 = this.mapWidth * 24 - 240;
        int n4 = this.mapHeight * 24 - 160;
        int n5 = n > n3 ? n3 : (n = n < 0 ? 0 : n);
        int n6 = n2 > n4 ? n4 : (n2 = n2 < 0 ? 0 : n2);
        if (n < 0) {
            n = 0;
        }
        return this.camX >= n - 1 && this.camX <= n + 1 && this.camY >= n2 - 1 && this.camY <= n2 + 1;
    }

    private void updateCamera(boolean n) {
        if (this.cameraIsStatic) {
            return;
        }
        Vector2 vector2 = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = CAMERA_SPEED_COEF;
        int n5 = CAMERA_MAX_SPEED;
        switch (this.state) {
            case 2: {
                vector2 = this.dummyMen[0].getCenterPosition();
                break;
            }
            case 9: {
                if (this.dummyMen[0].state != 0 || this.mainObjIndex == -1) {
                    vector2 = this.dummyMen[0].getCenterPosition();
                    break;
                }
                vector2 = this.gameObjects[this.mainObjIndex].getPosition();
                break;
            }
            case 1: {
                if (this.mainObjIndex != -1) {
                    vector2 = this.gameObjects[this.mainObjIndex].getPosition();
                    break;
                }
                vector2 = this.dummyMen[0].getCenterPosition();
                break;
            }
            case 4: 
            case 5: {
                vector2 = this.gameObjects[this.selObjIndex].getPosition();
                break;
            }
            case 3: {
                return;
            }
            case 6: {
                n2 = this.camX;
                n3 = this.camY;
                if (this.k_leftPressed) {
                    n2 -= EXPLORE_MAP_CAM_SPEED;
                }
                if (this.k_rightPressed) {
                    n2 += EXPLORE_MAP_CAM_SPEED;
                }
                if (this.k_upPressed) {
                    n3 -= EXPLORE_MAP_CAM_SPEED;
                }
                if (this.k_downPressed) {
                    n3 += EXPLORE_MAP_CAM_SPEED;
                }
                n4 = 512;
                break;
            }
            case 7: 
            case 8: {
                if (this.startScript == 16) {
                    vector2 = this.dummyMen[0].getCenterPosition();
                    break;
                }
                if (Controller.level != 0 && this.state == 7 && !Script.someScriptPlaying() && this.controller.endTimerShownForFirstTime) {
                    vector2 = this.dummyMen[0].getCenterPosition();
                    break;
                }
                if (this.camDestX == -1 || this.camDestY == -1) {
                    if (this.mainObjIndex != -1) {
                        vector2 = this.gameObjects[this.mainObjIndex].getPosition();
                        break;
                    }
                    vector2 = this.dummyMen[0].getCenterPosition();
                    break;
                }
                n2 = this.camDestX - 120;
                n3 = this.camDestY - 80;
                n4 = CAMERA_SCRIPT_SPEED_COEF;
                n5 = CAMERA_SCRIPT_MAX_SPEED;
            }
        }
        if (vector2 != null) {
            n2 = Game.worldToScreen(vector2.x) - 120;
            n3 = Game.worldToScreen(vector2.y) - 80;
        }
        int n6 = this.mapWidth * 24 - 240;
        int n7 = this.mapHeight * 24 - 160;
        int n8 = n2 > n6 ? n6 : (n2 = n2 < 0 ? 0 : n2);
        int n9 = n3 > n7 ? n7 : (n3 = n3 < 0 ? 0 : n3);
        if (n != 0) {
            this.camX = n2;
            this.camY = n3;
        } else {
            n = n2 - this.camX;
            n6 = n3 - this.camY;
            n7 = n * n4;
            n4 = n6 * n4;
            int n10 = n7 > n5 ? n5 : (n7 = n7 < -n5 ? -n5 : n7);
            n4 = n4 > n5 ? n5 : (n4 < -n5 ? -n5 : n4);
            n4 >>= 10;
            if (((n7 >>= 10) > 0 ? n7 : -n7) > (n > 0 ? n : -n)) {
                n7 = n;
            }
            if ((n4 > 0 ? n4 : -n4) > (n6 > 0 ? n6 : -n6)) {
                n4 = n6;
            }
            this.camX += n7;
            this.camY += n4;
            if (n7 == 0 && n4 == 0) {
                this.camX = n2;
                this.camY = n3;
            }
        }
        n = this.camX;
        Game.camAABB[0] = n * 1365;
        n = this.camY;
        Game.camAABB[1] = n * 1365;
        n = this.camX + 240;
        Game.camAABB[2] = n * 1365;
        n = this.camY + 160;
        Game.camAABB[3] = n * 1365;
    }

    private void setActiveScreenArea() {
        int n = this.camX;
        Game.activeArea[0] = n * 1365;
        n = this.camY;
        Game.activeArea[1] = n * 1365;
        n = this.camX + 240;
        Game.activeArea[2] = n * 1365;
        n = this.camY + 160;
        Game.activeArea[3] = n * 1365;
        if (this.mainObjIndex != -1 && this.dummyMen[0].state != 4) {
            int[] nArray = this.gameObjects[this.mainObjIndex].getBoundingBox();
            if (nArray[0] < activeArea[0]) {
                Game.activeArea[0] = nArray[0];
            }
            if (nArray[1] < activeArea[1]) {
                Game.activeArea[1] = nArray[1];
            }
            if (nArray[2] > activeArea[2]) {
                Game.activeArea[2] = nArray[2];
            }
            if (nArray[3] > activeArea[3]) {
                Game.activeArea[3] = nArray[3];
            }
        }
        if (Controller.level == 0 || this.dummyMen[0].state == 5) {
            int[] nArray = this.dummyMen[0].getBoundingBox();
            if (nArray[0] < activeArea[0]) {
                Game.activeArea[0] = nArray[0];
            }
            if (nArray[1] < activeArea[1]) {
                Game.activeArea[1] = nArray[1];
            }
            if (nArray[2] > activeArea[2]) {
                Game.activeArea[2] = nArray[2];
            }
            if (nArray[3] > activeArea[3]) {
                Game.activeArea[3] = nArray[3];
            }
        }
        this.world.setActiveArea(activeArea);
    }

    public final void resetKeyStates() {
        this.k_downPressed = false;
        this.k_upPressed = false;
        this.k_rightPressed = false;
        this.k_leftPressed = false;
        this.trackballUpCounter = 0;
        this.trackballRightCounter = 0;
        this.trackballLeftCounter = 0;
        this.trackballDownCounter = 0;
    }

    public final void initGameObjects(DataInputStream dataInputStream, Background background) {
        try {
            Background background2 = background;
            this.mapWidth = background2.matrixM;
            background2 = background;
            this.mapHeight = background2.matrixN;
            this.world.initUniformGrid(15, this.mapWidth << 15, this.mapHeight << 15, 64, 64, 32, 32);
            int n = dataInputStream.readUnsignedByte();
            this.loadingObjectsDefinitions = null;
            if (!this.loadStoredGameState) {
                this.loadingObjectsDefinitions = new int[n][5];
            }
            for (int i = 0; i < n; ++i) {
                byte bl = dataInputStream.readByte();
                byte by = dataInputStream.readByte();
                short s = dataInputStream.readShort();
                short s2 = dataInputStream.readShort();
                byte by2 = dataInputStream.readByte();
                byte by3 = dataInputStream.readByte();
                if (!this.loadStoredGameState) {
                    this.loadingObjectsDefinitions[i][0] = bl;
                    this.loadingObjectsDefinitions[i][1] = s;
                    this.loadingObjectsDefinitions[i][2] = s2;
                    this.loadingObjectsDefinitions[i][3] = by3;
                    this.loadingObjectsDefinitions[i][4] = by;
                }
                if (bl != 0) continue;
                boolean vector2 = by2 != 3;
                BodyPart.setFaceDirection(vector2);
                Vector2 vector22 = new Vector2(Game.levelToWorld(s), Game.levelToWorld(s2));
                vector22.y -= 65536;
                this.dummyMen[0] = new DummyMan(this, vector22);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void initDataRequiringRouters() {
        this.mainObjectAllowedBox = new int[8];
        this.mainObjectAllowedBox[0] = Game.levelToWorld(Router.routers[this.mainObjectAllowedBox_routerID1].posX);
        this.mainObjectAllowedBox[1] = Game.levelToWorld(Router.routers[this.mainObjectAllowedBox_routerID1].posY);
        this.mainObjectAllowedBox[2] = Game.levelToWorld(Router.routers[this.mainObjectAllowedBox_routerID2].posX);
        this.mainObjectAllowedBox[3] = Game.levelToWorld(Router.routers[this.mainObjectAllowedBox_routerID2].posY);
        this.mainObjectAllowedBox[4] = Game.levelToWorld(Router.routers[this.mainObjectAllowedBox_routerID3].posX);
        this.mainObjectAllowedBox[5] = Game.levelToWorld(Router.routers[this.mainObjectAllowedBox_routerID3].posY);
        this.mainObjectAllowedBox[6] = Game.levelToWorld(Router.routers[this.mainObjectAllowedBox_routerID4].posX);
        this.mainObjectAllowedBox[7] = Game.levelToWorld(Router.routers[this.mainObjectAllowedBox_routerID4].posY);
        if (this.animationPositions != null) {
            for (int i = 0; i < this.animationPositions.length; i += 2) {
                int n = this.animationPositions[i];
                this.animationPositions[i] = Game.levelToWorld(Router.routers[n].posX);
                this.animationPositions[i + 1] = Game.levelToWorld(Router.routers[n].posY);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadLevelData() {
        FilterInputStream filterInputStream = null;
        try {
            int n;
            int n2;
            filterInputStream = new DataInputStream(((Object)((Object)Main.instance)).getClass().getResourceAsStream("/l"));
            for (n2 = 0; n2 < Controller.level; ++n2) {
                ((DataInputStream)filterInputStream).skipBytes(((DataInputStream)filterInputStream).readUnsignedShort());
            }
            ((DataInputStream)filterInputStream).skipBytes(2);
            this.mainObjectAllowedBox_routerID1 = ((DataInputStream)filterInputStream).readUnsignedByte();
            this.mainObjectAllowedBox_routerID2 = ((DataInputStream)filterInputStream).readUnsignedByte();
            this.mainObjectAllowedBox_routerID3 = ((DataInputStream)filterInputStream).readUnsignedByte();
            this.mainObjectAllowedBox_routerID4 = ((DataInputStream)filterInputStream).readUnsignedByte();
            ((DataInputStream)filterInputStream).skipBytes(2);
            ((DataInputStream)filterInputStream).readUnsignedByte();
            this.objective_damageScore = ((DataInputStream)filterInputStream).readInt();
            this.objective_bonusScore = ((DataInputStream)filterInputStream).readInt();
            this.objective_distanceScore = ((DataInputStream)filterInputStream).readInt();
            this.objective_numSomersaults = ((DataInputStream)filterInputStream).readUnsignedByte();
            this.objective_numHeadOns = ((DataInputStream)filterInputStream).readUnsignedByte();
            this.objective_numHelmetFatalities = ((DataInputStream)filterInputStream).readUnsignedByte();
            this.objective_numEagles = ((DataInputStream)filterInputStream).readUnsignedByte();
            this.objective_numWings = ((DataInputStream)filterInputStream).readUnsignedByte();
            this.objective_totalScore = ((DataInputStream)filterInputStream).readInt();
            this.objective_hitTarget = false;
            this.startScript = ((DataInputStream)filterInputStream).readByte();
            this.availGameObjectsLen = ((DataInputStream)filterInputStream).readUnsignedShort();
            this.availGameObjects = new int[this.availGameObjectsLen + 8][3];
            for (n2 = 0; n2 < this.availGameObjectsLen; ++n2) {
                this.availGameObjects[n2][0] = ((DataInputStream)filterInputStream).readUnsignedByte();
                this.availGameObjects[n2][1] = ((DataInputStream)filterInputStream).readUnsignedByte();
                this.availGameObjects[n2][2] = ((DataInputStream)filterInputStream).readUnsignedByte();
                if (this.availGameObjects[n2][0] != -1) continue;
                this.availGameObjects[n2][1] = 0;
            }
            this.availGameObjects[this.availGameObjectsLen++][0] = 1;
            this.availGameObjects[this.availGameObjectsLen++][0] = 22;
            this.availGameObjects[this.availGameObjectsLen++][0] = 11;
            this.availGameObjects[this.availGameObjectsLen++][0] = 12;
            this.availGameObjects[this.availGameObjectsLen++][0] = 13;
            this.availGameObjects[this.availGameObjectsLen++][0] = 10;
            this.availGameObjects[this.availGameObjectsLen++][0] = 17;
            this.availGameObjects[this.availGameObjectsLen++][0] = 18;
            for (n2 = this.availGameObjectsLen - 8; n2 < this.availGameObjectsLen; ++n2) {
                this.availGameObjects[n2][1] = 9;
                this.availGameObjects[n2][2] = 1;
            }
            this.updateAvailableObjects();
            this.lastObjectGroupID = 0;
            n2 = ((DataInputStream)filterInputStream).readUnsignedShort();
            this.loadingObjectsRouterCache = new byte[n2][6];
            for (n = 0; n < n2; ++n) {
                for (int i = 0; i < 6; ++i) {
                    this.loadingObjectsRouterCache[n][i] = ((DataInputStream)filterInputStream).readByte();
                }
            }
            n2 = ((DataInputStream)filterInputStream).readUnsignedShort();
            if (n2 == 1) {
                this.animationType = ((DataInputStream)filterInputStream).readByte();
                ((DataInputStream)filterInputStream).readShort();
                n2 = ((DataInputStream)filterInputStream).readUnsignedShort();
                this.animationPositions = new int[n2 * 2];
                for (n = 0; n < n2; ++n) {
                    this.animationPositions[n << 1] = ((DataInputStream)filterInputStream).readByte();
                }
            }
        }
        catch (Exception exception) {
            try {
                filterInputStream.close();
                return;
            }
            catch (Exception exception2) {
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                filterInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            filterInputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private int getNumNeededGameObjects(byte by) {
        byte by2 = by;
        if (!(by2 > 0)) {
            return 0;
        }
        if (by == 3) {
            return 2;
        }
        return 1;
    }

    private void finishGameObjectsLoading() {
        int n;
        byte by;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = 0;
        for (n8 = 0; n8 < this.availGameObjectsLen; ++n8) {
            n7 = this.availGameObjects[n8][0];
            n9 += this.getNumNeededGameObjects((byte)n7) * this.availGameObjects[n8][1];
        }
        for (n8 = 0; n8 < this.loadingObjectsDefinitions.length; ++n8) {
            n7 = (byte)this.loadingObjectsDefinitions[n8][0];
            n9 += this.getNumNeededGameObjects((byte)n7);
        }
        for (n8 = 0; n8 < this.loadingObjectsRouterCache.length; ++n8) {
            n7 = this.loadingObjectsRouterCache[n8][2];
            n9 += this.getNumNeededGameObjects((byte)n7);
        }
        this.gameObjects = new AbstractGameObject[n9];
        this.gameObjectsLen = 0;
        for (n8 = 0; n8 < this.loadingObjectsDefinitions.length; ++n8) {
            n7 = (byte)this.loadingObjectsDefinitions[n8][0];
            n9 = this.loadingObjectsDefinitions[n8][1];
            n6 = this.loadingObjectsDefinitions[n8][2];
            n5 = this.loadingObjectsDefinitions[n8][3];
            n4 = this.loadingObjectsDefinitions[n8][4];
            n3 = n4 == 0 ? 1 : 0;
            n2 = n5 == 1 ? 1 : 0;
            byte by2 = by = n5 == 2 ? (byte)1 : 0;
            if (n7 == 40) {
                this.objective_hitTarget = true;
                n3 = 0;
            }
            if (n7 == 37 || n7 == 38 || n7 == 39) {
                n3 = 0;
            }
            if (!((n = n7) > 0)) continue;
            Vector2 vector2 = tmpVector;
            vector2.set(Game.levelToWorld(n9), Game.levelToWorld(n6));
            Vector2 vector22 = vector2;
            n9 = n7;
            if (AbstractGameObject.IS_COLLIDABLE[n9]) {
                CollisionProxy collisionProxy = null;
                Vector2[] vector2Array = null;
                collisionProxy = AbstractGameObject.IS_DYNAMIC[n9] ? DynamicGameObject.shapes[n9] : StaticGameObject.shapes[n9];
                CollisionProxy collisionProxy2 = collisionProxy;
                vector2Array = collisionProxy2.data;
                n9 = Integer.MIN_VALUE;
                for (n5 = 0; n5 < vector2Array.length; ++n5) {
                    if (vector2Array[n5].y <= n9) continue;
                    n9 = vector2Array[n5].y;
                }
                if (n9 != Integer.MIN_VALUE) {
                    vector22.y -= n9;
                }
            }
            n9 = 0;
            Vector2 vector23 = vector2;
            n5 = n3;
            n6 = n7;
            Game game = this;
            n7 = game.addGameObject((byte)n6, n5 != 0, vector23, 0, null);
            if (n2 != 0) {
                this.mainObjIndex = n7;
            }
            if (by == 0) continue;
            this.gameObjects[n7].setTrigger(true);
        }
        for (n8 = 0; n8 < this.loadingObjectsRouterCache.length; ++n8) {
            n7 = this.loadingObjectsRouterCache[n8][1] & 0xFF;
            n9 = this.loadingObjectsRouterCache[n8][2];
            n6 = this.loadingObjectsRouterCache[n8][3] & 0xFF;
            n5 = Game.levelToWorld(Router.routers[n7].posX);
            n4 = Game.levelToWorld(Router.routers[n7].posY);
            n3 = Game.levelToWorld(Router.routers[n6].posX);
            n2 = Game.levelToWorld(Router.routers[n6].posY);
            by = this.loadingObjectsRouterCache[n8][4];
            byte by3 = this.loadingObjectsRouterCache[n8][5];
            n7 = by3 == 0 ? 1 : 0;
            n6 = by == 1 ? 1 : 0;
            by = by == 2 ? (byte)1 : 0;
            n = n9;
            if (!(n > 0)) continue;
            if (n9 == 3) {
                n4 -= 1024;
                n2 -= 1024;
            }
            n9 = this.addGameObject((byte)n9, n7 != 0, new Vector2(n3, n2), 0, new Vector2(n5, n4));
            if (n6 != 0) {
                this.mainObjIndex = n9;
            }
            if (by == 0) continue;
            this.gameObjects[n9].setTrigger(true);
        }
    }

    private void initCollisionTiles() {
        int n;
        byte[][] byArray = new byte[this.mapWidth][this.mapHeight];
        for (n = 0; n < this.mapWidth; ++n) {
            for (int i = 0; i < this.mapHeight; ++i) {
                byte[] byArray2 = byArray[n];
                Background background = this.background;
                int n2 = i;
                int n3 = n;
                Background background2 = background;
                n3 = n2 * background2.matrixM + n3;
                background2 = background;
                n2 = background.matrix[n3] & 0xFF;
                if (background2.matrixType != 0) {
                    int n4 = n3 >> background2.matrixExtensionShift;
                    n3 -= n4 << background2.matrixExtensionShift;
                    n3 = (background2.matrixExtension[n4] & 0xFF & background2.bitsPerTile << n3) >> n3;
                    n2 += n3 << 8;
                }
                byArray2[i] = (byte)((n2 == 255 ? 0 : background2.tileCollision[n2]) - 1);
            }
        }
        for (n = 0; n < tileObjects.length; ++n) {
            tileObjects[n].initBody(this.world, tileObjectProxies[n]);
        }
        this.world.setTiles(32768, byArray, tileObjects, validEdges, useAxis);
    }

    private int addGameObject(byte by, boolean bl, Vector2 object, int n, Vector2 vector2) {
        int n2;
        byte by2;
        Game game = this;
        do {
            ++game.lastObjectGroupID;
            by2 = 0;
            for (n2 = 0; n2 < game.gameObjectsLen && by2 == 0; ++n2) {
                if (game.gameObjects[n2].getLinkedGroupID() != game.lastObjectGroupID) continue;
                by2 = 1;
            }
        } while (by2 != 0);
        int n3 = game.lastObjectGroupID;
        by2 = by;
        n2 = this.gameObjectsLen;
        PhysicalObject physicalObject = AbstractGameObject.IS_DYNAMIC[by2] ? new DynamicGameObject(this, by2, n3) : new StaticGameObject(this, by2, n3);
        physicalObject.init((Vector2)object, n);
        physicalObject.setEditable(bl);
        switch (by) {
            case 11: 
            case 12: 
            case 13: 
            case 17: {
                physicalObject.setTrigger(true);
            }
        }
        if (bl) {
            ++this.numEditableObjects;
        }
        this.gameObjects[this.gameObjectsLen++] = physicalObject;
        if (by2 == 3) {
            DynamicGameObject dynamicGameObject = (DynamicGameObject)physicalObject;
            object = new StaticGameObject(this, 2, n3);
            ((StaticGameObject)object).init(vector2, 0);
            ((StaticGameObject)object).setEditable(bl);
            if (bl) {
                ++this.numEditableObjects;
            }
            this.gameObjects[this.gameObjectsLen++] = object;
            Object object2 = new Vector2(0, 0);
            Vector2 vector22 = new Vector2(0, 0);
            dynamicGameObject.attachedSpring = object2 = new Spring(dynamicGameObject, (PhysicalObject)object, (Vector2)object2, vector22, 33792, 71680, 0);
            this.world.addSpring((Spring)object2);
        }
        return n2;
    }

    private void updateCurrentTrigger() {
        if (this.curTriggerIndex != -1 && this.gameObjects[this.curTriggerIndex].getState() != 5) {
            this.curTriggerIndex = -1;
        }
        long l = Long.MAX_VALUE;
        if (this.curTriggerIndex != -1) {
            tmpVector.copy(this.dummyMen[0].getCenterPosition());
            tmpVector.subtract(this.gameObjects[this.curTriggerIndex].getPosition());
            l = tmpVector.length_squared();
        }
        for (int i = 0; i < this.gameObjectsLen; ++i) {
            if (this.gameObjects[i].getState() != 5 || !MathUtils.boundingBoxesOverlap(camAABB, this.gameObjects[i].getBoundingBox())) continue;
            tmpVector.copy(this.dummyMen[0].getCenterPosition());
            tmpVector.subtract(this.gameObjects[i].getPosition());
            long l2 = tmpVector.length_squared();
            if (l2 >= l) continue;
            l = l2;
            this.curTriggerIndex = i;
        }
    }

    private void updateReplayData() {
        this.replayTriggerCounter = -1;
        try {
            this.replayTriggerCounter = this.replayInputStream.readShort();
            this.replayTriggerIndex = this.replayInputStream.readByte() & 0xFF;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public final void levelCompleted() {
        int n;
        if (!this.replaying && this.replayOutputStream != null) {
            Game game = this;
            try {
                savedReplay = game.replayByteOutputStream.toByteArray();
                game.replayByteOutputStream.close();
            }
            catch (Exception exception) {}
        }
        if (Controller.level == 0) {
            this.controller.initGameLoading();
            Controller.introPlayed = true;
            this.controller.saveGameData(1);
            this.clean(false);
            this.controller.loadStoryGame(false);
            return;
        }
        for (n = 0; n < this.dummyMen.length; ++n) {
            this.dummyMen[n].computeDistanceScore();
        }
        boolean bl = this.controller.testLevelFullfillObjectives();
        n = bl ? 1 : 0;
        if (bl && this.controller.currentShiftLevelIndex == 2 && this.startScript != 16 && this.controller.gameType != 2) {
            Script.startScript(16);
            this.startScript = (byte)16;
            return;
        }
        if (!this.replaying && n != 0 && this.controller.currentShiftLevelIndex > 2 && this.startScript != 16) {
            for (int i = 0; i < this.gameObjectsLen; ++i) {
                byte by = this.gameObjects[i].getType();
                if (AbstractGameObject.FREEPLAY_UNLOCKED[by]) continue;
                int n2 = -1;
                switch (by) {
                    case 11: {
                        n2 = 70;
                        break;
                    }
                    case 12: 
                    case 13: {
                        n2 = 71;
                        break;
                    }
                    case 17: {
                        n2 = 73;
                        break;
                    }
                    case 10: {
                        n2 = 74;
                    }
                }
                if (n2 == -1) continue;
                String string = Controller.getText(n2);
                this.showTextbox(string, 1);
                this.newState = (byte)9;
                this.actQuestion = (byte)5;
                this.startScript = (byte)16;
                return;
            }
        }
        if (this.dummyMen[0].getTotalScore() >= MAX_SCORE) {
            this.showQuestionbox((byte)4);
        } else if (n != 0) {
            this.showQuestionbox((byte)3);
        } else if (Controller.maxCurrentGameLevelScore[this.controller.currentShiftLevelIndex] > 0) {
            this.showQuestionbox((byte)2);
        } else {
            this.showQuestionbox((byte)1);
        }
        if (this.replaying) {
            this.state = this.newState;
            this.keyPressed(0, 3);
        }
    }

    public final boolean updateGameStatus() {
        boolean bl = false;
        boolean bl2 = this.controller.testLevelFullfillObjectives();
        boolean bl3 = false;
        if (bl2 && this.dummyMen[0].getTotalScore() > Controller.maxLevelScore[this.controller.currentShiftLevelIndex]) {
            Controller.maxLevelScore[this.controller.currentShiftLevelIndex] = this.dummyMen[0].getTotalScore();
            bl3 = true;
            bl = true;
        }
        if (this.controller.gameType != 1) {
            Controller.showLoading = true;
            Controller.callRepaint_blocking();
            this.controller.saveGameData(1);
            Controller.showLoading = false;
            return bl;
        }
        boolean bl4 = false;
        if (bl2 && this.controller.currentShiftLevelIndex == 2 && !Controller.toolbarUnlocked) {
            Controller.toolbarUnlocked = true;
            bl3 = true;
        }
        if (bl2 && this.controller.currentShiftLevelIndex == 2) {
            this.controller.updateFreeplayEnable();
        }
        if (bl2) {
            for (int i = 0; i < this.gameObjectsLen; ++i) {
                byte by = this.gameObjects[i].getType();
                if (AbstractGameObject.FREEPLAY_UNLOCKED[by]) continue;
                AbstractGameObject.FREEPLAY_UNLOCKED[by] = true;
                bl4 = true;
            }
        }
        if (bl2 && (Controller.currentGameShiftSystem[this.controller.currentShiftLevelIndex] != 1 || Controller.maxReachedShiftSystem[this.controller.currentShiftLevelIndex] != 1)) {
            Controller.currentGameShiftSystem[this.controller.currentShiftLevelIndex] = 1;
            Controller.maxReachedShiftSystem[this.controller.currentShiftLevelIndex] = 1;
            bl3 = true;
        }
        if (bl2 && this.dummyMen[0].getTotalScore() > Controller.maxCurrentGameLevelScore[this.controller.currentShiftLevelIndex]) {
            Controller.maxCurrentGameLevelScore[this.controller.currentShiftLevelIndex] = this.dummyMen[0].getTotalScore();
            bl3 = true;
        }
        if (bl4 || bl3) {
            Controller.showLoading = true;
            Controller.callRepaint_blocking();
        }
        if (bl4) {
            this.controller.saveGameData(3);
        }
        if (bl3) {
            this.controller.saveGameData(1);
        }
        Controller.showLoading = false;
        return bl;
    }

    public final void update() {
        try {
            if (this.trackballDownCounter > 0) {
                this.trackballDownCounter -= FRAME_NUM_PHYSICS_ITERATIONS;
                if (this.trackballDownCounter <= 0) {
                    this.keyReleased(0, 5, 0);
                }
            }
            if (this.trackballLeftCounter > 0) {
                this.trackballLeftCounter -= FRAME_NUM_PHYSICS_ITERATIONS;
                if (this.trackballLeftCounter <= 0) {
                    this.keyReleased(0, 6, 0);
                }
            }
            if (this.trackballRightCounter > 0) {
                this.trackballRightCounter -= FRAME_NUM_PHYSICS_ITERATIONS;
                if (this.trackballRightCounter <= 0) {
                    this.keyReleased(0, 7, 0);
                }
            }
            if (this.trackballUpCounter > 0) {
                this.trackballUpCounter -= FRAME_NUM_PHYSICS_ITERATIONS;
                if (this.trackballUpCounter <= 0) {
                    this.keyReleased(0, 4, 0);
                }
            }
            block2 : switch (this.state) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 8: {
                    Game game = this;
                    try {
                        if (Controller.level == 0 && game.actionRunning() && game.actionCounter > 66) {
                            game.levelCompleted();
                            break;
                        }
                        for (int i = 0; i < FRAME_NUM_PHYSICS_ITERATIONS; ++i) {
                            int n;
                            if (game.replaying && game.actionRunning() && game.replayTriggerCounter == game.actionCounter) {
                                game.gameObjects[game.replayTriggerIndex].trigger();
                                game.updateReplayData();
                            }
                            if (game.state == 2) {
                                game.updateCurrentTrigger();
                            }
                            if (game.selObjIndex != -1 && (game.state == 1 || game.state == 4)) {
                                game.gameObjects[game.selObjIndex].reactOnKeys();
                            }
                            for (n = 0; n < game.gameObjectsLen; ++n) {
                                if (!MathUtils.boundingBoxesOverlap(game.world.getActiveArea(), game.gameObjects[n].getBoundingBox())) continue;
                                game.gameObjects[n].tick();
                            }
                            for (n = 0; n < game.dummyMen.length; ++n) {
                                if (!MathUtils.boundingBoxesOverlap(game.world.getActiveArea(), game.dummyMen[n].getBoundingBox())) continue;
                                game.dummyMen[n].tick();
                            }
                            game.world.tick();
                            for (n = 0; n < game.dummyMen.length; ++n) {
                                if (MathUtils.boundingBoxesOverlap(game.world.getActiveArea(), game.dummyMen[n].getBoundingBox())) {
                                    game.dummyMen[n].postTick();
                                }
                                game.dummyMen[n].recomputeBoundingBox();
                            }
                            if (game.actionRunning()) {
                                ++game.actionCounter;
                                n = game.dummyMen[0].state == 0 || game.dummyMen[0].state == 1 && game.dummyMen[0].animType == 2 ? 1 : 0;
                                if (n != 0 && ++game.endFailureCounter == 60) {
                                    v0.forcedTimer = true;
                                    break block2;
                                }
                                ++game.endSuccessCounter;
                                if (game.endSuccessCounter == 66 || game.dummyMen[0].getTotalScore() >= MAX_SCORE) {
                                    game.levelCompleted();
                                    break block2;
                                }
                                if (!(game.forcedTimer || game.dummyMen[0].flightCounter <= 2 || Controller.level == 0 && game.dummyMen[0].state == 4)) {
                                    game.endSuccessCounter = 0;
                                }
                                if (DynamicGameObject.pingCooldown > 0) {
                                    --DynamicGameObject.pingCooldown;
                                }
                            }
                            Script.updateScripts();
                        }
                        if (game.startScript < 0 || game.startScript == 16 || game.controller.gameType == 2) break;
                        Script.startScript(game.startScript);
                        game.startScript = (byte)-1;
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 7: 
                case 9: {
                    this.textboxForm.update();
                }
            }
            if (this.newState != this.state) {
                byte by = this.nextState;
                this.changeState();
                if (by != -1) {
                    this.newState = by;
                    this.changeState();
                }
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void changeState() {
        Game game;
        if (this.state == 7 || this.state == 9) {
            game = this;
            this.textboxForm = null;
        }
        switch (this.newState) {
            case 0: {
                this.restart(this.replaying);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.setToolbar(this.newState, this.state, -1);
                break;
            }
            case 1: {
                this.setSelectedObjectIndex(this.mainObjIndex);
                break;
            }
            case 2: {
                game = this;
                for (int i = 0; i < game.gameObjectsLen; ++i) {
                    game.gameObjects[i].release();
                }
                if (game.craneSpring != null) {
                    game.world.removeSpring(game.craneSpring);
                    game.craneSpring = null;
                    game.dummyMen[0].changeState((byte)4);
                } else {
                    game.dummyMen[0].resetPosition();
                    if (game.animationType != -1) {
                        Vector2 vector2 = game.dummyMen[0].getCenterPosition();
                        int n = 0;
                        int n2 = 0;
                        int[][] nArrayArray = new int[game.animationPositions.length / 2 + 1][];
                        for (int i = 0; i < nArrayArray.length; ++i) {
                            if (i == 0) {
                                n = 0;
                                n2 = 0;
                                nArrayArray[i] = new int[]{0, 0, 0};
                                continue;
                            }
                            nArrayArray[i] = DummyMan.computeAnimationPosition(game.animationPositions[i - 1 << 1] - vector2.x, game.animationPositions[(i - 1 << 1) + 1] - 65536 - vector2.y, n, n2, 1600 << 10, nArrayArray[i - 1][0]);
                            n = game.animationPositions[i - 1 << 1] - vector2.x;
                            n2 = game.animationPositions[(i - 1 << 1) + 1] - 65536 - vector2.y;
                        }
                        game.dummyMen[0].startAnimation(game.animationType, nArrayArray);
                    }
                }
                game.actionCounter = 0;
                game.setSelectedObjectIndex(-1);
                game.endFailureCounter = 0;
                game.endSuccessCounter = 0;
                game.saved = false;
                if (game.replaying) {
                    game.saved = true;
                }
                if (game.replaying || game.savedGameState == null) break;
                game.initReplayRecording();
            }
        }
        if (this.state == 7 && this.newState != 7) {
            this.state = this.newState;
            this.newState = (byte)8;
            return;
        }
        this.state = this.newState;
    }

    private int getGameObjectID(PhysicalObject physicalObject) {
        int n = Short.MAX_VALUE;
        for (int i = 0; i < this.gameObjectsLen && n == Short.MAX_VALUE; ++i) {
            if (physicalObject != this.gameObjects[i]) continue;
            n = i;
        }
        return n;
    }

    private PhysicalObject getGameObjectFromID(int n) {
        PhysicalObject physicalObject = this.staticWorldObject;
        if (n != Short.MAX_VALUE && n >= 0) {
            physicalObject = (PhysicalObject)((Object)this.gameObjects[n]);
        }
        return physicalObject;
    }

    public final void ensureSavedToRMS() {
        if (!this.saved && this.controller.gameType == 1) {
            Controller.showLoading = true;
            Controller.callRepaint_blocking();
            this.controller.saveGameData(2);
            Controller.showLoading = false;
            this.saved = true;
        }
    }

    private void restoreGameState() {
        if (this.savedGameState == null) {
            return;
        }
        try {
            Object object;
            Vector2 vector2;
            int n;
            int n2;
            int n3;
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(this.savedGameState));
            for (n3 = 0; n3 < this.gameObjectsLen; ++n3) {
                this.gameObjects[n3].removeFromWorld();
                this.gameObjects[n3] = null;
            }
            this.availGameObjects = null;
            this.availGameObjectsLen = 0;
            this.lastObjectGroupID = 0;
            this.mainObjIndex = dataInputStream.readByte();
            this.tmpCraneRestLength = dataInputStream.readInt();
            for (n3 = 0; n3 < this.dummyMen[0].bodyParts.length; ++n3) {
                if (this.dummyMen[0].bodyParts[n3] == null) continue;
                this.dummyMen[0].bodyParts[n3].loadState(dataInputStream);
            }
            this.gameObjects = new AbstractGameObject[dataInputStream.readUnsignedByte()];
            this.gameObjectsLen = dataInputStream.readUnsignedByte();
            for (n3 = 0; n3 < this.gameObjectsLen; ++n3) {
                n2 = dataInputStream.readByte();
                if (n2 == 40) {
                    this.objective_hitTarget = true;
                }
                n = dataInputStream.readByte();
                PhysicalObject physicalObject = AbstractGameObject.IS_DYNAMIC[n2] ? new DynamicGameObject(this, (byte)n2, n) : new StaticGameObject(this, (byte)n2, n);
                physicalObject.init(dataInputStream);
                this.gameObjects[n3] = physicalObject;
            }
            n3 = dataInputStream.readUnsignedByte();
            for (n2 = 0; n2 < n3; ++n2) {
                n = dataInputStream.readByte();
                byte by = dataInputStream.readByte();
                Vector2 vector22 = new Vector2(dataInputStream.readInt(), dataInputStream.readInt());
                vector2 = new Vector2(dataInputStream.readInt(), dataInputStream.readInt());
                ((DynamicGameObject)new Joint(this.getGameObjectFromID(n), this.getGameObjectFromID(by), vector22, vector2).obj1).attachedJoint = object = new Joint(this.getGameObjectFromID(n), this.getGameObjectFromID(by), vector22, vector2);
                this.world.addJoint((Joint)object);
            }
            n2 = dataInputStream.readUnsignedByte();
            for (n = 0; n < n2; ++n) {
                byte by = dataInputStream.readByte();
                byte by2 = dataInputStream.readByte();
                vector2 = new Vector2(dataInputStream.readInt(), dataInputStream.readInt());
                object = new Vector2(dataInputStream.readInt(), dataInputStream.readInt());
                Spring spring = new Spring(this.getGameObjectFromID(by), this.getGameObjectFromID(by2), vector2, (Vector2)object, dataInputStream.readInt(), dataInputStream.readInt(), dataInputStream.readInt());
                spring.setConstraintType(dataInputStream.readByte());
                ((DynamicGameObject)spring.obj1).attachedSpring = spring;
                this.world.addSpring(spring);
            }
            for (n = 0; n < this.availGameObjectsLen; ++n) {
                this.availGameObjects[n] = null;
            }
            this.availGameObjectsLen = dataInputStream.readUnsignedByte();
            this.availGameObjects = new int[this.availGameObjectsLen][];
            for (n = 0; n < this.availGameObjectsLen; ++n) {
                this.availGameObjects[n] = new int[]{dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readByte()};
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public final void clearSavedGameState() {
        this.savedGameState = null;
    }

    public final boolean actionRunning() {
        return this.newState == 2 || this.state == 2;
    }

    public final void requestStartAction() {
        if (!this.actionRunning()) {
            this.newState = (byte)2;
        }
    }

    public final void scriptStarted() {
        if (this.state != 8) {
            this.newState = (byte)8;
        }
    }

    public final void scriptStopped() {
        if (this.newState != 2) {
            this.newState = 1;
        }
    }

    private void initReplayRecording() {
        try {
            this.replayByteOutputStream = new ByteArrayOutputStream();
            this.replayOutputStream = new DataOutputStream(this.replayByteOutputStream);
            this.replayOutputStream.writeShort(this.savedGameState.length);
            ((OutputStream)this.replayOutputStream).write(this.savedGameState);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public final void clean(boolean n) {
        Game game = this;
        this.textboxForm = null;
        if (n == 0) {
            Sound.pauseSound();
            this.animationPositions = null;
            this.availGameObjects = null;
            this.mainObjectAllowedBox = null;
            this.world = null;
            this.gameObjects = null;
        } else {
            this.world.removeAllJoints();
            this.world.removeAllSprings();
            this.world.removeAllObjects();
            for (n = 0; n < this.gameObjectsLen; ++n) {
                this.gameObjects[n] = null;
            }
        }
        this.gameObjectsLen = 0;
        this.objective_targetObject = null;
        this.background = null;
        this.dummyMen = null;
        this.craneSpring = null;
        this.objective_targetObject = null;
        this.selObjMovementSpeed = 1024;
        this.replayInputStream = null;
        this.replayOutputStream = null;
        this.replayByteOutputStream = null;
    }

    public final void restart(boolean bl) {
        boolean bl2 = true;
        if (this.savedGameState == null) {
            bl2 = false;
            this.skipScript = bl;
        }
        this.clean(bl2);
        this.init(bl2, bl);
    }

    public final void draw(Graphics object) {
        block27: {
            block24: {
                block25: {
                    Graphics graphics;
                    block26: {
                        if (this.state != 7 && this.state != 9) break block24;
                        this.drawGame((Graphics)object);
                        this.drawHUD((Graphics)object);
                        graphics = object;
                        object = this;
                        if (object.textboxForm == null) break block25;
                        if (object.textBoxOffsetY > 0) {
                            object.textBoxOffsetY -= 32;
                            if (object.textBoxOffsetY < 0) {
                                object.textBoxOffsetY = 0;
                            }
                        }
                        object.textboxForm.y = object.textBoxFormY + object.textBoxOffsetY;
                        int n = object.textboxForm.y - 7;
                        graphics.drawImage(Controller.getImage(17), 3, n, 20);
                        int n2 = 3 + Controller.getImage(17).getWidth();
                        int n3 = 237 - Controller.getImage(18).getWidth();
                        int n4 = Controller.getImage(18).getHeight();
                        graphics.setColor(0xFFFFFF);
                        graphics.fillRect(n2, n, n3 - n2, n4);
                        graphics.setColor(0);
                        graphics.drawLine(n2, n, n3, n);
                        graphics.drawLine(n2, n + n4 - 1, n3, n + n4 - 1);
                        graphics.drawImage(Controller.getImage(18), 237 - Controller.getImage(18).getWidth(), n, 20);
                        object.textboxForm.paint(graphics);
                        if (object.speakerId == 0) {
                            graphics.drawImage(Controller.imageBuffer[140], 230, n + 2, 40);
                        } else {
                            graphics.drawImage(Controller.imageBuffer[139], 14, n + 2, 36);
                        }
                        if (object.state != 7) break block26;
                        Game.drawSoftkey(graphics, 12, true);
                        if (!Script.someScriptPlaying()) break block25;
                        Game.drawSoftkey(graphics, 13, false);
                        break block27;
                    }
                    if (object.state == 9) {
                        Game.drawSoftkey(graphics, 12, true);
                    }
                }
                return;
            }
            this.drawGame((Graphics)object);
            this.drawHUD((Graphics)object);
            if (this.state == 3 || this.state == 5 || this.state == 4) {
                Object object2 = object;
                object = this;
                try {
                    Object object3 = object2;
                    Object object4 = object;
                    Image image = Controller.getImage(19);
                    Image image2 = Controller.getImage(20);
                    Image image3 = Controller.getImage(21);
                    object3.drawImage(image, 0, 126, 20);
                    int n = image.getWidth();
                    int n5 = 240 - image3.getWidth();
                    Game.fillHorizontalImageBar(object3, image2, n, n5, 126, 16);
                    object3.drawImage(image3, 240 - image3.getWidth(), 126, 20);
                    object4 = object;
                    int n6 = n = object4.toolbarScrolled ? (240 - object4.toolbarVisibleItemsCount * 24 + 2) / 2 + 11 : 21;
                    if (object.toolbarScrolled) {
                        if (object.firstVisibleToolbarIconIndex > 0) {
                            object2.drawImage(Controller.getImage(35), 5, 143, 6);
                        }
                        if (object.firstVisibleToolbarIconIndex + object.toolbarVisibleItemsCount < object.toolbarItemsCount) {
                            object2.drawImage(Controller.getImage(36), 235, 143, 10);
                        }
                    }
                    int n7 = object.toolbarScrolled ? object.firstVisibleToolbarIconIndex + object.toolbarVisibleItemsCount : object.toolbarItemsCount;
                    for (int i = object.firstVisibleToolbarIconIndex; i < n7; ++i) {
                        int n8;
                        byte[] byArray = toolbarItems[i];
                        if (byArray[0] == -1) {
                            if (object.toolbarScrolled) continue;
                            int n9 = i;
                            object4 = object;
                            n = 219 - (object4.toolbarItemsCount - n9 - 2) * 24;
                            continue;
                        }
                        n5 = object.toolbarSelectedIndex == i ? 1 : 0;
                        int n10 = n8 = byArray[2] == 1 ? 1 : 0;
                        if (object.toolbarButtonPressed && object.toolbarButtonPressCounter > 0 && --object.toolbarButtonPressCounter <= 0) {
                            object.toolbarButtonPressed = false;
                        }
                        if (byArray[1] == 0) {
                            object2.drawImage(Controller.getImage(n8 != 0 ? 24 : (n5 != 0 && object.toolbarButtonPressed ? 23 : 22)), n, 143, 3);
                        } else if (byArray[1] == 1) {
                            object2.drawImage(Controller.getImage(25), n, 143, 3);
                        }
                        if (byArray[0] == -2) {
                            n8 = object.availGameObjects[byArray[3]][0];
                            object2.drawImage(Controller.getImage(n8 + 38 - 1), n, 143, 3);
                        } else {
                            object2.drawImage(Controller.getImage(TOOLBAR_ITEMIMAGES[byArray[0]]), n, 143, 3);
                        }
                        if (byArray[0] == -2) {
                            Fonts.drawString(2, String.valueOf(object.availGameObjects[byArray[3]][1]), n + 11 - 1, 154, 40);
                        }
                        if (n5 != 0) {
                            if (byArray[1] == 0 || byArray[1] == 1) {
                                object2.drawImage(Controller.getImage(27), n, 143, 3);
                            } else if (byArray[1] == 2) {
                                object2.drawImage(Controller.getImage(28), n, 143, 3);
                            }
                        }
                        n += 24;
                    }
                    return;
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void fillHorizontalImageBar(Graphics graphics, Image image, int n, int n2, int n3, int n4) {
        if (n > n2) {
            n ^= n2;
            n2 ^= n;
            n ^= n2;
        }
        int n5 = image.getWidth();
        graphics.getTranslateX();
        int n6 = graphics.getTranslateY();
        int n7 = graphics.getClipX();
        int n8 = graphics.getClipY();
        int n9 = graphics.getClipWidth();
        int n10 = graphics.getClipHeight();
        graphics.setClip(n, -n6, n2 - n, 160);
        while (n < n2) {
            graphics.drawImage(image, n, n3, 4 | n4);
            n += n5;
        }
        graphics.setClip(n7, n8, n9, n10);
    }

    public static void fillVerticalImageBar(Graphics graphics, Image image, int n, int n2, int n3, int n4) {
        n4 = image.getHeight();
        int n5 = graphics.getTranslateX();
        graphics.getTranslateY();
        int n6 = graphics.getClipX();
        int n7 = graphics.getClipY();
        int n8 = graphics.getClipWidth();
        int n9 = graphics.getClipHeight();
        graphics.setClip(-n5, n2, 240, n3 - n2);
        while (n2 < n3) {
            graphics.drawImage(image, n, n2, 17);
            n2 += n4;
        }
        graphics.setClip(n6, n7, n8, n9);
    }

    private void fillTriangle(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        int n10;
        int n11;
        if (n2 < n4) {
            if (n4 < n6) {
                n11 = n;
                n10 = n2;
                n9 = n3;
                n8 = n4;
                n = n5;
                n2 = n6;
            } else if (n2 < n6) {
                n11 = n;
                n10 = n2;
                n9 = n5;
                n8 = n6;
                n = n3;
                n2 = n4;
            } else {
                n11 = n5;
                n10 = n6;
                n9 = n;
                n8 = n2;
                n = n3;
                n2 = n4;
            }
        } else if (n2 < n6) {
            n11 = n3;
            n10 = n4;
            n9 = n;
            n8 = n2;
            n = n5;
            n2 = n6;
        } else if (n4 < n6) {
            n11 = n3;
            n10 = n4;
            n9 = n5;
            n8 = n6;
        } else {
            n11 = n5;
            n10 = n6;
            n9 = n3;
            n8 = n4;
        }
        n3 = 0;
        n4 = 0;
        n5 = 0;
        if (n8 - n10 != 0) {
            n3 = (n9 - n11 << 10) / (n8 - n10);
        }
        if (n2 - n10 != 0) {
            n4 = (n - n11 << 10) / (n2 - n10);
        }
        if (n2 - n8 != 0) {
            n5 = (n - n9 << 10) / (n2 - n8);
        }
        n = n11 << 10;
        n6 = n11 << 10;
        n11 = n10;
        graphics.setColor(n7);
        if (n3 > n4) {
            while (n11 <= n8) {
                graphics.drawLine(n >> 10, n11, n6 >> 10, n11);
                ++n11;
                n += n4;
                n6 += n3;
            }
            n6 = n9 << 10;
            while (n11 < n2) {
                graphics.drawLine(n >> 10, n11, n6 >> 10, n11);
                ++n11;
                n += n4;
                n6 += n5;
            }
        } else {
            while (n11 <= n8) {
                graphics.drawLine(n >> 10, n11, n6 >> 10, n11);
                ++n11;
                n += n3;
                n6 += n4;
            }
            n = n9 << 10;
            while (n11 < n2) {
                graphics.drawLine(n >> 10, n11, n6 >> 10, n11);
                ++n11;
                n += n5;
                n6 += n4;
            }
        }
    }

    private void drawGame(Graphics graphics) {
        try {
            int n;
            if (this.newState != this.state) {
                return;
            }
            this.updateCamera(false);
            this.setActiveScreenArea();
            Graphics graphics2 = graphics;
            Object object = this;
            Background background = ((Game)object).background;
            int n2 = background.cameraX;
            background = ((Game)object).background;
            int n3 = background.cameraY;
            int n4 = ((Game)object).camX + 120;
            int n5 = ((Game)object).camY + 80;
            while (n2 < n4) {
                if ((n2 += 24) > n4) {
                    n2 = n4;
                }
                ((Game)object).background.setCamera(n2, n3);
                ((Game)object).background.update();
            }
            while (n2 > n4) {
                if ((n2 -= 24) < n4) {
                    n2 = n4;
                }
                ((Game)object).background.setCamera(n2, n3);
                ((Game)object).background.update();
            }
            while (n3 < n5) {
                if ((n3 += 24) > n5) {
                    n3 = n5;
                }
                ((Game)object).background.setCamera(n2, n3);
                ((Game)object).background.update();
            }
            while (n3 > n5) {
                if ((n3 -= 24) < n5) {
                    n3 = n5;
                }
                ((Game)object).background.setCamera(n2, n3);
                ((Game)object).background.update();
            }
            Graphics graphics3 = graphics2;
            background = ((Game)object).background;
            n5 = -background.displayX + Background.cacheI * 24;
            int n6 = -background.displayY + Background.cacheJ * 24;
            graphics3.drawImage(Background.cacheImage, n5 - Background.cacheOriginX, n6 - Background.cacheOriginY, 20);
            graphics3.drawImage(Background.cacheImage, n5 + (Background.cacheW - Background.cacheOriginX), n6 - Background.cacheOriginY, 20);
            graphics3.drawImage(Background.cacheImage, n5 - Background.cacheOriginX, n6 + (Background.cacheH - Background.cacheOriginY), 20);
            graphics3.drawImage(Background.cacheImage, n5 + (Background.cacheW - Background.cacheOriginX), n6 + (Background.cacheH - Background.cacheOriginY), 20);
            graphics.translate(-this.camX, -this.camY);
            for (n = 0; n < this.world._springs_len; ++n) {
                object = this.world._springs[n];
                if (!MathUtils.boundingBoxesOverlap(camAABB, ((Spring)object).getBoundingBox())) continue;
                Object object2 = object;
                graphics2 = graphics;
                object = this;
                Vector2 vector2 = ((Spring)object2).getAbsoluteAnchor1();
                Vector2 vector22 = ((Spring)object2).getAbsoluteAnchor2();
                n5 = MathUtils.vectorLength(vector22.x - vector2.x, vector22.y - vector2.y);
                if (n5 < 102) continue;
                n6 = (int)(314572800L / (long)n5);
                if (n6 < 341) {
                    n6 = 341;
                }
                if (n6 > 4096) {
                    n6 = 4096;
                }
                int n7 = (int)((long)(vector22.y - vector2.y) * (long)n6 / (long)n5);
                n5 = (int)((long)(vector2.x - vector22.x) * (long)n6 / (long)n5);
                n6 = Game.worldToScreen(vector2.x - n7);
                int n8 = Game.worldToScreen(vector2.y - n5);
                int n9 = Game.worldToScreen(vector2.x + n7);
                int n10 = Game.worldToScreen(vector2.y + n5);
                int n11 = Game.worldToScreen(vector22.x - n7);
                int n12 = Game.worldToScreen(vector22.y - n5);
                int n13 = Game.worldToScreen(vector22.x + n7);
                int n14 = Game.worldToScreen(vector22.y + n5);
                super.fillTriangle(graphics2, n6, n8, n11, n12, n13, n14, -16777216);
                super.fillTriangle(graphics2, n9, n10, n6, n8, n13, n14, -16777216);
                int n15 = Game.worldToScreen(vector2.x - (n7 >> 1));
                int n16 = Game.worldToScreen(vector2.y - (n5 >> 1));
                n7 = Game.worldToScreen(vector22.x - (n7 >> 1));
                int n17 = Game.worldToScreen(vector22.y - (n5 >> 1));
                graphics2.setColor(-6776680);
                graphics2.drawLine(n15, n16, n7, n17);
            }
            for (n = 0; n < this.gameObjectsLen; ++n) {
                if (!MathUtils.boundingBoxesOverlap(camAABB, this.gameObjects[n].getBoundingBox())) continue;
                this.gameObjects[n].draw(graphics);
            }
            object = this;
            int n18 = ((Game)object).animScores_start;
            while (n18 != ((Game)object).animScores_end) {
                int[] nArray = animScores[n18];
                Fonts.drawString$6cf53995(2, String.valueOf(nArray[2]), nArray[0], nArray[1], 3);
                nArray[3] = nArray[3] - FRAME_NUM_PHYSICS_ITERATIONS;
                if (nArray[3] <= 0) {
                    ++((Game)object).animScores_start;
                    if (((Game)object).animScores_start == 2) {
                        ((Game)object).animScores_start = 0;
                    }
                } else {
                    nArray[1] = nArray[1] - 2 * FRAME_NUM_PHYSICS_ITERATIONS;
                }
                n18 = ++n18 == 2 ? 0 : n18;
            }
            for (n = 0; n < this.dummyMen.length; ++n) {
                if (Controller.level != 0 && !MathUtils.boundingBoxesOverlap(camAABB, this.dummyMen[n].getBoundingBox())) continue;
                this.dummyMen[n].draw(graphics);
            }
            if (this.craneSpring != null) {
                Vector2 vector2 = this.craneSpring.getAbsoluteAnchor2();
                graphics.drawImage(Controller.getImage(94), Game.worldToScreen(vector2.x), Game.worldToScreen(vector2.y), 3);
            }
            if (this.kaboomFrame != -1) {
                Graphics graphics4 = graphics;
                object = this;
                int n19 = Game.worldToScreen(((Game)object).kaboomPosition.x);
                n3 = Game.worldToScreen(((Game)object).kaboomPosition.y);
                graphics4.drawImage(Controller.getImage(156 + ((Game)object).kaboomFrame), n19, n3, 3);
                if (++((Game)object).kaboomFrame >= 4) {
                    ((Game)object).kaboomFrame = -1;
                }
            }
            if (!this.replaying && this.curTriggerIndex != -1 || this.state == 1 && this.animationType != -1) {
                Vector2 vector2;
                Graphics graphics5 = graphics;
                object = this;
                if (((Game)object).state == 1 && ((Game)object).animationType != -1) {
                    vector2 = tmpVector;
                    vector2.copy(((Game)object).dummyMen[0].getCenterPosition());
                    vector2.y -= 30720;
                } else {
                    vector2 = ((Game)object).gameObjects[((Game)object).curTriggerIndex].getPosition();
                }
                ((Game)object).imgTriggerAnimationSubPhase += FRAME_NUM_PHYSICS_ITERATIONS;
                if (((Game)object).imgTriggerAnimationSubPhase > 3) {
                    ++((Game)object).imgTriggerAnimationPhase;
                    if (((Game)object).imgTriggerAnimationPhase >= 4) {
                        ((Game)object).imgTriggerAnimationPhase = 0;
                    }
                    ((Game)object).imgTriggerAnimationSubPhase = 0;
                }
                n3 = ((Game)object).imgTriggerAnimationPhase == 3 ? 1 : ((Game)object).imgTriggerAnimationPhase;
                graphics5.drawImage(Controller.getImage(n3 + 83), Game.worldToScreen(vector2.x), Game.worldToScreen(vector2.y) - 18, 33);
            }
            if (this.selObjIndex != -1) {
                AbstractGameObject abstractGameObject = this.gameObjects[this.selObjIndex];
                if (this.state == 4 && abstractGameObject.getState() == 3) {
                    object = abstractGameObject.getDrawPosition();
                    graphics.drawImage(Controller.getImage(88), Game.worldToScreen(((Vector2)object).x), Game.worldToScreen(((Vector2)object).y), 3);
                }
                if (this.state == 4 || this.state == 1) {
                    AbstractGameObject abstractGameObject2 = abstractGameObject;
                    Graphics graphics6 = graphics;
                    object = this;
                    Vector2 vector2 = abstractGameObject2.getDrawPosition();
                    n4 = Game.worldToScreen(vector2.x);
                    n5 = Game.worldToScreen(vector2.y);
                    n6 = 20;
                    if ((((Game)object).objectArrows & 1) > 0) {
                        graphics6.drawImage(Controller.getImage(78), n4 - 20, n5, 10);
                    }
                    if ((((Game)object).objectArrows & 2) > 0) {
                        graphics6.drawImage(Controller.getImage(80), n4 + 20, n5, 6);
                    }
                    if (abstractGameObject2.getType() == 6) {
                        vector2 = ((Game)object).craneSpring.getAbsoluteAnchor2();
                        n4 = Game.worldToScreen(vector2.x);
                        n5 = Game.worldToScreen(vector2.y);
                        n6 = 5;
                    }
                    if ((((Game)object).objectArrows & 4) > 0) {
                        graphics6.drawImage(Controller.getImage(79), n4, n5 - n6, 33);
                    }
                    if ((((Game)object).objectArrows & 8) > 0) {
                        graphics6.drawImage(Controller.getImage(81), n4, n5 + n6, 17);
                    }
                } else if (this.state == 5 || this.state == 4) {
                    object = abstractGameObject.getDrawPosition();
                    graphics.drawImage(Controller.getImage(82), Game.worldToScreen(((Vector2)object).x), Game.worldToScreen(((Vector2)object).y), 3);
                }
            }
            graphics.translate(this.camX, this.camY);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public final void createKaboomEffect(Vector2 vector2) {
        if (this.kaboomFrame == -1) {
            this.kaboomFrame = 0;
            this.kaboomPosition.copy(vector2);
        }
    }

    private void drawHUD(Graphics graphics) {
        try {
            int n;
            int n2;
            String string;
            if (Controller.level == 0) {
                if (this.state != 7) {
                    Game.drawSoftkey(graphics, 13, false);
                }
                return;
            }
            if (this.animBonusText_counter != -1) {
                Game game = this;
                string = null;
                string = game.animBonusText_type == 5 ? "BRUTALITY MODE" : Controller.getText(BONUS_TEXT_IDS[game.animBonusText_type]);
                n2 = -Fonts.getStringWidth(0, string) >> 1;
                n = game.animBonusText_counter <= 8 ? game.animBonusText_counter : (game.animBonusText_counter <= 36 ? 8 : game.animBonusText_counter - 28);
                n = n2 + (120 - n2) * n / 8;
                Fonts.drawString(0, string, n, 80, 3);
                game.animBonusText_counter += FRAME_NUM_PHYSICS_ITERATIONS;
                if (game.animBonusText_counter >= 44) {
                    game.animBonusText_counter = -1;
                }
            }
            int n3 = this.dummyMen[0].getTotalScore();
            Fonts.drawString(0, String.valueOf(n3), 1, -4, 20);
            if (Controller.level != 0 && this.actionRunning() && this.endSuccessCounter > 0 && (n3 > 0 || this.forcedTimer)) {
                if (Controller.level == 1 && !this.forcedTimer && this.controller.endTimerShownForFirstTime && this.actionCounter > 10 && this.endSuccessCounter > 11) {
                    this.showTextbox(5, 1);
                }
                string = graphics;
                Game game = this;
                n2 = 240 - (Controller.getImage(15).getWidth() + 5 << 1);
                n = n2 - 2;
                n3 = (66 - game.endSuccessCounter << 10) / 66;
                n3 = n3 * n >> 10;
                n = 120 - (n2 >> 1);
                string.drawImage(Controller.getImage(89), n, 146, 20);
                string.drawImage(Controller.getImage(90), n + n2 - Controller.getImage(90).getWidth(), 146, 20);
                int n4 = n + Controller.getImage(89).getWidth();
                n3 = n + 1 + n3 - Controller.getImage(92).getWidth();
                if (n3 < n + 3) {
                    n3 = n + 3;
                }
                Game.fillHorizontalImageBar((Graphics)string, Controller.getImage(91), n4, n3, 146, 16);
                string.drawImage(Controller.getImage(92), n3, 146, 20);
                n2 = n + n2 - Controller.getImage(90).getWidth();
                if (n2 < (n3 += Controller.getImage(92).getWidth())) {
                    n2 = n3;
                }
                Game.fillHorizontalImageBar((Graphics)string, Controller.getImage(93), n3, n2, 146, 16);
            }
            if (this.state == 6) {
                Graphics graphics2 = graphics;
                graphics2.drawImage(Controller.getImage(78), 1, 80, 6);
                graphics2.drawImage(Controller.getImage(79), 120, 1, 17);
                graphics2.drawImage(Controller.getImage(80), 239, 80, 10);
                graphics2.drawImage(Controller.getImage(81), 120, 159, 33);
            }
            if (this.state == 1 || this.state == 2 || this.state == 8) {
                Game.drawSoftkey(graphics, 15, true);
                if (this.state == 8) {
                    Game.drawSoftkey(graphics, 13, false);
                } else if (Controller.toolbarUnlocked && !this.replaying) {
                    Game.drawSoftkey(graphics, 16, false);
                } else if (this.actionRunning() && this.replaying) {
                    Game.drawSoftkey(graphics, 13, false);
                } else if (this.actionRunning()) {
                    Game.drawSoftkey(graphics, 87, false);
                }
            } else if (this.state == 6) {
                Game.drawSoftkey(graphics, 13, false);
            }
            if (this.replaying) {
                graphics.drawImage(Controller.getImage(153 + Controller.frameCounter % 2), 240, 0, 24);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private static void drawSoftkey(Graphics graphics, int n, boolean bl) {
        if (bl) {
            graphics.drawImage(Controller.getImage(n), 0, 160, 36);
            return;
        }
        graphics.drawImage(Controller.getImage(n), 240, 160, 40);
    }

    private void showQuestionbox(byte by) {
        String string = "";
        switch (by) {
            case 1: {
                string = Controller.getText(61);
                break;
            }
            case 2: {
                string = Controller.getText(36);
                break;
            }
            case 4: {
                string = Controller.getText(62);
                break;
            }
            case 3: {
                string = Controller.getText(63);
                if (this.dummyMen[0].getTotalScore() <= Controller.maxLevelScore[this.controller.currentShiftLevelIndex]) break;
                string = string + "|" + Controller.msgStrings[68];
            }
        }
        this.showTextbox(string, 1);
        this.actQuestion = by;
        this.newState = (byte)9;
    }

    public final void showTextbox(int n, int n2) {
        String string = "";
        this.showTextbox(string + Controller.getLevelText(Controller.level, n), n2);
        this.newState = (byte)7;
    }

    private void showTextbox(String stringArray, int n) {
        this.textboxInnerHeight = 44;
        int n2 = 9 + this.textboxInnerHeight;
        this.textboxForm = new Form(19, 160 - n2, 202, this.textboxInnerHeight, -1);
        stringArray = Fonts.breakText((String)stringArray, 202, 1);
        for (int i = 0; i < stringArray.length; ++i) {
            Item item = new Item(1, stringArray[i]);
            item.setFont(n == 0 ? 1 : 33);
            this.textboxForm.addItem(item);
        }
        this.textboxForm.type = (byte)2;
        this.textboxForm.cyclicScroll = false;
        this.textboxForm.id = (byte)22;
        this.textboxForm.controller = this.controller;
        this.textboxForm.reset();
        this.textBoxOffsetY = 58 + Controller.imageBuffer[139].getHeight();
        this.textBoxFormY = this.textboxForm.y;
        this.speakerId = (byte)n;
    }

    public final void showImagebox(int n) {
        this.textboxInnerHeight = 44;
        int n2 = 9 + this.textboxInnerHeight;
        this.textboxForm = new Form(19, 160 - n2, 202, this.textboxInnerHeight, -1);
        Item item = new Item(3, Controller.imageBuffer[n]);
        this.textboxForm.addItem(item);
        this.textboxForm.cyclicScroll = false;
        this.textboxForm.id = (byte)22;
        this.textboxForm.reset();
        this.newState = (byte)7;
        this.textBoxOffsetY = 58 + Controller.imageBuffer[139].getHeight();
        this.textBoxFormY = this.textboxForm.y;
        this.speakerId = 1;
    }

    private void decreaseToolbarIndex() {
        if (this.toolbarItemsCount <= 1) {
            return;
        }
        if (--this.toolbarSelectedIndex < 0) {
            this.toolbarSelectedIndex = this.toolbarItemsCount - 1;
            this.firstVisibleToolbarIconIndex = this.toolbarScrolled ? this.toolbarSelectedIndex - this.toolbarVisibleItemsCount + 1 : 0;
        } else if (this.toolbarScrolled && this.toolbarSelectedIndex < this.firstVisibleToolbarIconIndex) {
            this.firstVisibleToolbarIconIndex = this.toolbarSelectedIndex;
        }
        if (toolbarItems[this.toolbarSelectedIndex][0] == -1) {
            this.decreaseToolbarIndex();
        }
    }

    private void increaseToolbarIndex() {
        if (this.toolbarItemsCount <= 1) {
            return;
        }
        if (++this.toolbarSelectedIndex >= this.toolbarItemsCount) {
            this.toolbarSelectedIndex = 0;
            this.firstVisibleToolbarIconIndex = 0;
        } else if (this.toolbarScrolled && this.firstVisibleToolbarIconIndex + this.toolbarVisibleItemsCount <= this.toolbarSelectedIndex) {
            ++this.firstVisibleToolbarIconIndex;
        }
        if (toolbarItems[this.toolbarSelectedIndex][0] == -1) {
            this.increaseToolbarIndex();
        }
    }

    private void setToolbar(int n, int n2, int n3) {
        int n4;
        int n5;
        if (n != n2) {
            this.toolbarButtonPressed = false;
            this.toolbarButtonPressCounter = -1;
        }
        this.toolbarItemsCount = 0;
        Image image = Controller.getImage(35);
        this.maxToolbarIconCount = 9;
        this.toolbarVisibleItemsCount = (230 - (image.getWidth() + 1 << 1)) / 24;
        for (n5 = 0; n5 < toolbarItems.length; ++n5) {
            Game.toolbarItems[n5][2] = 0;
        }
        if (n == 3) {
            for (n5 = 0; n5 < this.availGameObjectsLen; ++n5) {
                Game.toolbarItems[this.toolbarItemsCount][0] = -2;
                Game.toolbarItems[this.toolbarItemsCount][1] = 2;
                Game.toolbarItems[this.toolbarItemsCount][3] = (byte)n5;
                ++this.toolbarItemsCount;
            }
            Game.toolbarItems[this.toolbarItemsCount++][0] = -1;
            Game.toolbarItems[this.toolbarItemsCount][0] = 3;
            Game.toolbarItems[this.toolbarItemsCount][1] = 0;
            if (this.numEditableObjects == 0) {
                Game.toolbarItems[this.toolbarItemsCount][2] = 1;
            }
            ++this.toolbarItemsCount;
            Game.toolbarItems[this.toolbarItemsCount][0] = 6;
            Game.toolbarItems[this.toolbarItemsCount++][1] = 0;
            Game.toolbarItems[this.toolbarItemsCount][0] = 5;
            Game.toolbarItems[this.toolbarItemsCount++][1] = 1;
            this.toolbarSelectedIndex = this.toolbarItemsCount - 1;
        } else if (n == 5 || n == 4) {
            boolean bl;
            Game.toolbarItems[this.toolbarItemsCount][0] = 2;
            Game.toolbarItems[this.toolbarItemsCount++][1] = 0;
            Game.toolbarItems[this.toolbarItemsCount][0] = 1;
            Game.toolbarItems[this.toolbarItemsCount][1] = 0;
            if (this.numEditableObjects <= 1) {
                Game.toolbarItems[this.toolbarItemsCount][2] = 1;
            }
            ++this.toolbarItemsCount;
            Game.toolbarItems[this.toolbarItemsCount][0] = 0;
            Game.toolbarItems[this.toolbarItemsCount][1] = 0;
            Game game = this;
            if (game.selObjIndex == -1) {
                bl = false;
            } else {
                n4 = game.gameObjects[game.selObjIndex].getLinkedGroupID();
                bl = game.mainObjIndex == -1 || n4 != game.gameObjects[game.mainObjIndex].getLinkedGroupID();
            }
            if (!bl) {
                Game.toolbarItems[this.toolbarItemsCount][2] = 1;
            }
            ++this.toolbarItemsCount;
            Game.toolbarItems[this.toolbarItemsCount++][0] = -1;
            Game.toolbarItems[this.toolbarItemsCount][0] = 4;
            Game.toolbarItems[this.toolbarItemsCount++][1] = 0;
            if (n == 4) {
                this.toolbarSelectedIndex = 0;
                this.toolbarButtonPressed = true;
            } else if (n2 == 3) {
                this.toolbarSelectedIndex = this.toolbarItemsCount - 2;
            }
        } else {
            this.toolbarItemsCount = 0;
        }
        this.firstVisibleToolbarIconIndex = 0;
        boolean bl = this.toolbarScrolled = this.toolbarItemsCount > this.maxToolbarIconCount;
        if (this.toolbarScrolled) {
            int n6 = 0;
            byte[][] byArray = new byte[20][4];
            for (n2 = 0; n2 < this.toolbarItemsCount; ++n2) {
                if (toolbarItems[n2][0] == -1) continue;
                for (n4 = 0; n4 < 4; ++n4) {
                    byArray[n6][n4] = toolbarItems[n2][n4];
                }
                ++n6;
            }
            this.toolbarItemsCount = n6;
            toolbarItems = byArray;
        }
        if (n3 != -1 && toolbarItems[n3][0] != -1) {
            this.toolbarSelectedIndex = n3;
        }
        Game game = this;
        if (game.toolbarSelectedIndex < 0) {
            game.toolbarSelectedIndex = 0;
            game.firstVisibleToolbarIconIndex = 0;
        } else if (game.toolbarSelectedIndex >= game.toolbarItemsCount) {
            game.toolbarSelectedIndex = game.toolbarItemsCount - 1;
            game.firstVisibleToolbarIconIndex = game.toolbarScrolled ? game.toolbarSelectedIndex - game.toolbarVisibleItemsCount + 1 : 0;
        } else if (game.toolbarScrolled && game.toolbarSelectedIndex > game.toolbarVisibleItemsCount + game.firstVisibleToolbarIconIndex) {
            game.firstVisibleToolbarIconIndex = game.toolbarSelectedIndex - (game.toolbarVisibleItemsCount - 1);
        }
        if (toolbarItems[game.toolbarSelectedIndex][0] == -1) {
            game.increaseToolbarIndex();
        }
    }

    private void toolbarConfirmed() {
        block21: {
            Object object = toolbarItems[this.toolbarSelectedIndex];
            if (object[2] == 1) {
                return;
            }
            this.toolbarButtonPressed = true;
            this.toolbarButtonPressCounter = 10;
            block0 : switch (this.state) {
                case 3: {
                    switch (object[0]) {
                        case -2: {
                            Vector2 vector2 = new Vector2(camAABB[2] + camAABB[0] >> 1, camAABB[3] + camAABB[1] >> 1);
                            byte by = (byte)this.availGameObjects[object[3]][0];
                            this.setSelectedObjectIndex(this.addGameObject(by, true, vector2, 0, vector2));
                            int[] nArray = this.availGameObjects[object[3]];
                            nArray[1] = nArray[1] - 1;
                            this.updateAvailableObjects();
                            this.gameObjects[this.selObjIndex].setState((byte)3);
                            this.newState = (byte)4;
                            break block0;
                        }
                        case 5: {
                            this.newState = 1;
                            break block0;
                        }
                        case 6: {
                            this.newState = (byte)6;
                            break block0;
                        }
                        case 3: {
                            if (this.numEditableObjects <= 0) break;
                            if (this.selObjIndex == -1 || this.selObjIndex == this.mainObjIndex) {
                                this.setSelectedObjectIndex(-1);
                                for (int i = 0; i < this.gameObjectsLen && this.selObjIndex == -1; ++i) {
                                    if (!this.gameObjects[i].isEditable()) continue;
                                    this.setSelectedObjectIndex(i);
                                }
                            }
                            this.newState = (byte)5;
                        }
                    }
                    return;
                }
                case 5: {
                    switch (object[0]) {
                        case 2: {
                            this.newState = (byte)4;
                            return;
                        }
                        case 1: {
                            if (this.numEditableObjects > 1) {
                                this.selectNextObject();
                                this.setToolbar(this.state, this.state, this.toolbarSelectedIndex);
                                return;
                            }
                            break block21;
                        }
                        case 0: {
                            Game game = this;
                            object = game;
                            game.deleteGameObject(object.selObjIndex);
                            this.setToolbar(this.state, this.state, this.toolbarSelectedIndex);
                            return;
                        }
                        case 4: {
                            this.newState = (byte)3;
                            return;
                        }
                        case 5: {
                            this.newState = 1;
                        }
                    }
                }
            }
        }
    }

    public final void saveToOutputStream(DataOutputStream dataOutputStream) {
        try {
            if (this.savedGameState == null) {
                return;
            }
            dataOutputStream.writeByte(Controller.level);
            dataOutputStream.writeShort(this.savedGameState.length);
            ((OutputStream)dataOutputStream).write(this.savedGameState);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public final void loadFromInputStream(DataInputStream dataInputStream) {
        try {
            Game game = this;
            this.savedGameState = null;
            short s = dataInputStream.readByte();
            if (Controller.level != s) {
                return;
            }
            s = dataInputStream.readShort();
            this.savedGameState = new byte[s];
            dataInputStream.readFully(this.savedGameState);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static int[][][] loadVectorObject_model(DataInputStream dataInputStream) {
        try {
            dataInputStream.readByte();
            int n = 0;
            n = dataInputStream.readByte();
            int[][][] nArrayArray = new int[n][][];
            for (int i = 0; i < n; ++i) {
                int n2 = dataInputStream.readByte();
                if (n2 == 1) {
                    nArrayArray[i] = new int[][]{{n2, dataInputStream.readInt()}, {dataInputStream.readByte(), dataInputStream.readByte()}, {dataInputStream.readByte()}, {dataInputStream.readShort(), dataInputStream.readShort()}};
                    continue;
                }
                if (n2 == 3) {
                    nArrayArray[i] = new int[][]{{n2, VISUAL_IMAGE_REMAP[dataInputStream.readByte()]}, {dataInputStream.readByte(), dataInputStream.readByte()}};
                    continue;
                }
                if (n2 == 4) {
                    nArrayArray[i] = new int[][]{{n2, dataInputStream.readInt()}, {dataInputStream.readByte(), dataInputStream.readByte()}, {dataInputStream.readByte(), dataInputStream.readByte()}};
                    continue;
                }
                if (n2 != 0 && n2 != 2) continue;
                byte by = dataInputStream.readByte();
                int n3 = n2 == 0 ? 1 : 0;
                n3 = n3 != 0 ? 1 : 2;
                nArrayArray[i] = new int[by + 1 + n3][];
                nArrayArray[i][0] = new int[]{n2};
                for (n2 = 0; n2 < n3; ++n2) {
                    nArrayArray[i][n2 + 1] = new int[]{dataInputStream.readByte(), dataInputStream.readByte()};
                }
                for (n2 = 0; n2 < by; ++n2) {
                    nArrayArray[i][n2 + 1 + n3] = new int[]{dataInputStream.readByte(), dataInputStream.readByte(), dataInputStream.readInt()};
                }
            }
            return nArrayArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Vector2[] loadVectorObject_physics(DataInputStream dataInputStream) {
        try {
            dataInputStream.readByte();
            boolean bl = false;
            return Game.loadVectorObject_vectorArray(dataInputStream);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Vector2[] loadVectorObject_joints(DataInputStream dataInputStream) {
        try {
            dataInputStream.readByte();
            boolean bl = false;
            return Game.loadVectorObject_vectorArray(dataInputStream);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Vector2[] loadVectorObject_vectorArray(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readByte();
        Vector2[] vector2Array = new Vector2[n];
        for (int i = 0; i < n; ++i) {
            byte by = dataInputStream.readByte();
            byte by2 = dataInputStream.readByte();
            vector2Array[i] = new Vector2(by << 10, by2 << 10);
        }
        return vector2Array;
    }

    public final void drawVectorGfx_worldCoords(Graphics graphics, int[][][] object, Vector2 object2, int n, int n2) {
        int n3 = 1024;
        n3 = 1024;
        int n4 = n2;
        n2 = n;
        Object vector2 = object2;
        object2 = object;
        object = graphics;
        Game game = this;
        tmpMatrix.computeFromAngle(n2);
        Matrix2x2 matrix2x2 = tmpMatrix;
        n2 = MathUtils.radToDeg(n2) >> 10;
        for (int i = 0; i < ((Object)object2).length; ++i) {
            int n5;
            Object object3 = object2[i];
            Object object4 = object3[0][0];
            int n6 = 0;
            if (object4 == false || object4 == 2 || object4 == 3 || object4 == 4) {
                n6 = ((Object)object3).length - 1;
            } else if (object4 == true) {
                n6 = 1;
            }
            ++n6;
            for (n5 = 1; n5 < n6; ++n5) {
                Vector2 vector22 = tmpPoly[n5 - 1];
                vector22.set((int)object3[n5][0], (int)object3[n5][1]);
                vector22.multiply(matrix2x2);
                vector22.add((Vector2)vector2);
                vector22.x = Game.worldToScreen(vector22.x);
                vector22.y = Game.worldToScreen(vector22.y);
            }
            if (object4 == false) {
                n5 = 1;
                int n7 = ((Object)object3).length - 2;
                while (n5 < ((Object)object3).length - 1) {
                    int n8;
                    game.fillTriangle((Graphics)object, Game.tmpPoly[0].x, Game.tmpPoly[0].y, Game.tmpPoly[n8].x, Game.tmpPoly[n8].y, Game.tmpPoly[n5].x, Game.tmpPoly[n5].y, Game.modulateColor((int)object3[n5 + 1][2], n4));
                    n8 = n5++;
                }
                continue;
            }
            if (object4 == 2) {
                n5 = 2;
                boolean bl = true;
                while (n5 < ((Object)object3).length - 1) {
                    int n7;
                    game.fillTriangle((Graphics)object, Game.tmpPoly[0].x, Game.tmpPoly[0].y, Game.tmpPoly[n7].x, Game.tmpPoly[n7].y, Game.tmpPoly[n5].x, Game.tmpPoly[n5].y, Game.modulateColor((int)object3[n5 + 1][2], n4));
                    n7 = n5++;
                }
                continue;
            }
            if (object4 == true) {
                object.setColor(Game.modulateColor((int)object3[0][1], n4));
                Vector2 vector23 = tmpPoly[0];
                reference var13_22 = object3[2][0] * 768 >> 10;
                object.fillArc(vector23.x - var13_22, vector23.y - var13_22, (int)(var13_22 << 1), (int)(var13_22 << 1), 180 + object3[3][0] - n2, (int)(object3[3][1] - object3[3][0]));
                continue;
            }
            if (object4 == 3) {
                object.drawImage(Controller.getImage((int)object3[0][1]), Game.tmpPoly[0].x, Game.tmpPoly[0].y, 3);
                continue;
            }
            if (object4 != 4) continue;
            object.setColor(Game.modulateColor((int)object3[0][1], n4));
            object.drawLine(Game.tmpPoly[0].x, Game.tmpPoly[0].y, Game.tmpPoly[1].x, Game.tmpPoly[1].y);
        }
    }

    private static int modulateColor(int n, int n2) {
        if ((n2 & 0xFFFFFF) == 0xFFFFFF) {
            return n;
        }
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n2 >> 16 & 0xFF;
        int n6 = n2 >> 8 & 0xFF;
        return -16777216 + (n3 * n5 / 255 << 16) + (n4 * n6 / 255 << 8) + (n &= 0xFF) * (n2 &= 0xFF) / 255;
    }

    public final void addScoreAnim(int n, int n2, int n3) {
        Game.animScores[this.animScores_end][0] = n;
        Game.animScores[this.animScores_end][1] = n2 - 5;
        Game.animScores[this.animScores_end][2] = n3;
        Game.animScores[this.animScores_end][3] = 20;
        ++this.animScores_end;
        if (this.animScores_end == 2) {
            this.animScores_end = 0;
        }
        if (this.animScores_end == this.animScores_start) {
            ++this.animScores_start;
            if (this.animScores_start == 2) {
                this.animScores_start = 0;
            }
        }
    }

    public final void showBonusText(byte by) {
        this.animBonusText_type = by;
        this.animBonusText_counter = 0;
    }

    public final void keyPressed(int n, int n2) {
        try {
            int n3 = n;
            Game game = this;
            for (int i = brutalityKeysCache.length - 1; i > 0; --i) {
                Game.brutalityKeysCache[i] = brutalityKeysCache[i - 1];
            }
            Game.brutalityKeysCache[0] = n3;
            if (brutalityKeysCache[0] == 9 && brutalityKeysCache[1] == 11 && brutalityKeysCache[2] == 17 && brutalityKeysCache[3] == 15 && brutalityKeysCache[4] == 17 && brutalityKeysCache[5] == 11 && brutalityKeysCache[6] == 9) {
                brutalityOn = !brutalityOn;
                game.showBonusText((byte)5);
            }
            switch (this.state) {
                case 1: {
                    if (Controller.level == 0) {
                        if (n == 2) {
                            this.levelCompleted();
                        }
                        return;
                    }
                    if (n == 1) {
                        this.controller.enterIngameMenu();
                        return;
                    }
                    if (Controller.toolbarUnlocked && n == 2) {
                        this.newState = (byte)3;
                        return;
                    }
                    if (Controller.toolbarUnlocked && n == 18) {
                        if (this.numEditableObjects > 0) {
                            if (this.selObjIndex == -1 || !this.gameObjects[this.selObjIndex].isEditable()) {
                                this.selectNextObject();
                            }
                            this.newState = (byte)4;
                        }
                        return;
                    }
                    if (Controller.toolbarUnlocked && n == 19) {
                        this.newState = (byte)3;
                        this.state = (byte)3;
                        this.setToolbar(this.state, this.state, 0);
                        return;
                    }
                    if (n2 != 3) break;
                    game = this;
                    Object object = game;
                    game.savedGameState = null;
                    try {
                        int n4;
                        Vector2 vector2;
                        Object object2;
                        int n5;
                        object = new ByteArrayOutputStream();
                        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object);
                        dataOutputStream.writeByte(game.mainObjIndex);
                        if (game.craneSpring != null) {
                            dataOutputStream.writeInt(game.craneSpring.getRestLength());
                        } else {
                            dataOutputStream.writeInt(-1);
                        }
                        for (n = 0; n < game.dummyMen[0].bodyParts.length; ++n) {
                            if (game.dummyMen[0].bodyParts[n] == null) continue;
                            game.dummyMen[0].bodyParts[n].saveState(dataOutputStream);
                        }
                        dataOutputStream.writeByte(game.gameObjects.length);
                        dataOutputStream.writeByte(game.gameObjectsLen);
                        for (n = 0; n < game.gameObjectsLen; ++n) {
                            dataOutputStream.writeByte(game.gameObjects[n].getType());
                            dataOutputStream.writeByte(game.gameObjects[n].getLinkedGroupID());
                            game.gameObjects[n].saveState(dataOutputStream);
                        }
                        n = 0;
                        for (n5 = 0; n5 < game.world._joints_len; ++n5) {
                            if (game.dummyMen[0].hasBodyJoint(game.world._joints[n5])) continue;
                            ++n;
                        }
                        dataOutputStream.writeByte(n);
                        for (n5 = 0; n5 < game.world._joints_len; ++n5) {
                            Joint joint = game.world._joints[n5];
                            if (game.dummyMen[0].hasBodyJoint(joint)) continue;
                            dataOutputStream.writeByte(game.getGameObjectID(joint.obj1));
                            dataOutputStream.writeByte(game.getGameObjectID(joint.obj2));
                            object2 = joint.getLocalAnchor1();
                            dataOutputStream.writeInt(((Vector2)object2).x);
                            dataOutputStream.writeInt(((Vector2)object2).y);
                            vector2 = joint.getLocalAnchor2();
                            dataOutputStream.writeInt(vector2.x);
                            dataOutputStream.writeInt(vector2.y);
                        }
                        n5 = 0;
                        for (n4 = 0; n4 < game.world._springs_len; ++n4) {
                            if (game.world._springs[n4] == game.craneSpring) continue;
                            ++n5;
                        }
                        dataOutputStream.writeByte(n5);
                        for (n4 = 0; n4 < game.world._springs_len; ++n4) {
                            object2 = game.world._springs[n4];
                            if (object2 == game.craneSpring) continue;
                            dataOutputStream.writeByte(game.getGameObjectID(((Spring)object2).obj1));
                            dataOutputStream.writeByte(game.getGameObjectID(((Spring)object2).obj2));
                            vector2 = ((Spring)object2).getLocalAnchor1();
                            dataOutputStream.writeInt(vector2.x);
                            dataOutputStream.writeInt(vector2.y);
                            Vector2 vector22 = ((Spring)object2).getLocalAnchor2();
                            dataOutputStream.writeInt(vector22.x);
                            dataOutputStream.writeInt(vector22.y);
                            dataOutputStream.writeInt(((Spring)object2).getStiffness());
                            dataOutputStream.writeInt(((Spring)object2).getDamping());
                            dataOutputStream.writeInt(((Spring)object2).getRestLength());
                            dataOutputStream.writeByte(((Spring)object2).getConstraintType());
                        }
                        dataOutputStream.writeByte(game.availGameObjectsLen);
                        for (n4 = 0; n4 < game.availGameObjectsLen; ++n4) {
                            dataOutputStream.writeByte(game.availGameObjects[n4][0]);
                            dataOutputStream.writeByte(game.availGameObjects[n4][1]);
                            dataOutputStream.writeByte(game.availGameObjects[n4][2]);
                        }
                        dataOutputStream.flush();
                        game.savedGameState = ((ByteArrayOutputStream)object).toByteArray();
                    }
                    catch (Exception exception) {}
                    this.requestStartAction();
                    break;
                }
                case 2: {
                    if (Controller.level == 0) {
                        if (n == 2) {
                            this.levelCompleted();
                        }
                        return;
                    }
                    if (n == 1) {
                        this.controller.enterIngameMenu();
                        return;
                    }
                    if (n == 2 && this.replaying) {
                        this.controller.enterReplayMenu(this.controller.gameType == 1 && this.controller.nextReplayAllowed);
                        return;
                    }
                    if (n == 2) {
                        this.newState = 0;
                        this.endSuccessCounter = 0;
                        if (Controller.toolbarUnlocked) {
                            this.nextState = (byte)3;
                        }
                        return;
                    }
                    if (n2 != 3 || this.curTriggerIndex == -1 || this.replaying) break;
                    this.gameObjects[this.curTriggerIndex].trigger();
                    if (this.replayOutputStream != null) {
                        this.replayOutputStream.writeShort(this.actionCounter);
                        this.replayOutputStream.writeByte(this.curTriggerIndex);
                    }
                    this.updateCurrentTrigger();
                    break;
                }
                case 8: {
                    if (Controller.level != 0 && n == 1) {
                        this.controller.enterIngameMenu();
                        return;
                    }
                    if (n != 2) break;
                    Script.stopScripts();
                    this.scriptStopped();
                    if (this.startScript == 16 || Controller.level == 0) {
                        this.levelCompleted();
                        this.startScript = (byte)-1;
                    }
                    return;
                }
                case 7: {
                    if (n == 1 || n2 == 3) {
                        if (Controller.level != 0 && !Script.someScriptPlaying() && this.controller.endTimerShownForFirstTime) {
                            this.controller.endTimerShownForFirstTime = false;
                            this.state = (byte)2;
                            this.newState = (byte)2;
                            return;
                        }
                        if (this.startScript == 16 && !Script.getPlayingScript(0).hasNextAction()) {
                            Script.stopScripts();
                            this.levelCompleted();
                            this.startScript = (byte)-1;
                            this.state = (byte)8;
                            return;
                        }
                        this.newState = (byte)8;
                        return;
                    }
                    if (Script.someScriptPlaying() && n == 2) {
                        Script.stopScripts();
                        this.scriptStopped();
                        if (this.startScript == 16 || Controller.level == 0) {
                            this.levelCompleted();
                            this.startScript = (byte)-1;
                        }
                        this.state = (byte)8;
                        return;
                    }
                    switch (n2) {
                        case 4: 
                        case 5: {
                            this.textboxForm.keyPressed(n, n2);
                        }
                    }
                    break;
                }
                case 9: {
                    if (n == 1 || n2 == 3) {
                        if (this.actQuestion == 5) {
                            this.levelCompleted();
                        } else {
                            Game game2 = this;
                            this.textboxForm = null;
                            if (this.actQuestion == 1) {
                                this.gameOver = true;
                            }
                            this.controller.enterLevelScoreMenu();
                            this.actQuestion = (byte)-1;
                        }
                    }
                    switch (n2) {
                        case 4: 
                        case 5: {
                            this.textboxForm.keyPressed(n, n2);
                        }
                    }
                    break;
                }
                case 6: {
                    if (n2 == 3) {
                        this.newState = (byte)3;
                        return;
                    }
                    if (n != 2) break;
                    this.newState = 1;
                    return;
                }
                case 3: 
                case 5: {
                    if (this.state == 5 && n == 19) {
                        this.newState = (byte)3;
                        this.state = (byte)3;
                        this.setToolbar(this.state, this.state, 0);
                        return;
                    }
                    if (n == 2) {
                        this.newState = 1;
                        return;
                    }
                    if (n == 18) {
                        if (this.numEditableObjects > 0) {
                            this.selectNextObject();
                            this.newState = (byte)4;
                        }
                        return;
                    }
                    switch (n2) {
                        case 4: 
                        case 6: {
                            this.decreaseToolbarIndex();
                            break;
                        }
                        case 5: 
                        case 7: {
                            this.increaseToolbarIndex();
                            break;
                        }
                        case 3: {
                            this.toolbarConfirmed();
                        }
                    }
                    break;
                }
                case 4: {
                    if (this.gameObjects[this.selObjIndex].getState() == 3) break;
                    if (n == 18) {
                        if (this.numEditableObjects > 1) {
                            this.selectNextObject();
                        }
                        return;
                    }
                    if (n == 19) {
                        this.newState = (byte)3;
                        this.state = (byte)3;
                        this.setToolbar(this.state, this.state, 0);
                        return;
                    }
                    if (n == 2) {
                        this.newState = 1;
                        return;
                    }
                    if (n2 != 3) break;
                    this.newState = (byte)5;
                    return;
                }
            }
            switch (n2) {
                case 6: {
                    this.k_leftPressed = true;
                    break;
                }
                case 7: {
                    this.k_rightPressed = true;
                    break;
                }
                case 4: {
                    this.k_upPressed = true;
                    break;
                }
                case 5: {
                    this.k_downPressed = true;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {}
    }

    private void updateAvailableObjects() {
        boolean bl = true;
        block0: while (bl) {
            bl = false;
            for (int i = 0; i < this.availGameObjectsLen; ++i) {
                int n;
                boolean bl2 = false;
                if (this.availGameObjects[i][1] <= 0) {
                    bl2 = true;
                } else if (this.availGameObjects[i][2] == 1) {
                    if (this.controller.gameType != 2 || !AbstractGameObject.FREEPLAY_UNLOCKED[n = this.availGameObjects[i][0]]) {
                        bl2 = true;
                    } else {
                        n = this.availGameObjects[i][0];
                        for (int j = 0; j < i; ++j) {
                            if (this.availGameObjects[j][0] != n) continue;
                            this.availGameObjects[j][1] = this.availGameObjects[i][1];
                            bl2 = true;
                            break;
                        }
                    }
                }
                if (!bl2) continue;
                for (n = i + 1; n < this.availGameObjectsLen; ++n) {
                    this.availGameObjects[n - 1] = this.availGameObjects[n];
                }
                this.availGameObjects[--this.availGameObjectsLen] = null;
                bl = true;
                continue block0;
            }
        }
    }

    public final void deleteGameObject(PhysicalObject physicalObject) {
        int n = this.getGameObjectID(physicalObject);
        if (n == Short.MAX_VALUE) {
            return;
        }
        this.deleteGameObject(n);
    }

    private void deleteGameObject(int n) {
        int n2;
        int n3;
        int n4 = this.gameObjects[n].getType();
        n = this.gameObjects[n].getLinkedGroupID();
        if (n4 == 2) {
            n4 = 3;
        }
        for (n3 = 0; n3 < this.gameObjectsLen; ++n3) {
            if (this.gameObjects[n3].getLinkedGroupID() != n) continue;
            if (this.gameObjects[n3].isEditable()) {
                --this.numEditableObjects;
            }
            --this.gameObjectsLen;
            this.gameObjects[n3].removeFromWorld();
            for (n2 = n3; n2 < this.gameObjectsLen; ++n2) {
                this.gameObjects[n2] = this.gameObjects[n2 + 1];
            }
            this.gameObjects[this.gameObjectsLen] = null;
            if (n3 == this.mainObjIndex) {
                this.mainObjIndex = -1;
            } else if (n3 < this.mainObjIndex) {
                --this.mainObjIndex;
            }
            this.updateMainObjectAnchor();
            --n3;
        }
        n3 = 0;
        for (n2 = 0; n2 < this.availGameObjectsLen && n3 == 0; ++n2) {
            if (this.availGameObjects[n2][0] != n4) continue;
            int[] nArray = this.availGameObjects[n2];
            nArray[1] = nArray[1] + 1;
            n3 = 1;
        }
        if (n3 == 0) {
            if (this.availGameObjectsLen == this.availGameObjects.length) {
                int[][] nArrayArray = new int[this.availGameObjectsLen + 1][];
                System.arraycopy(this.availGameObjects, 0, nArrayArray, 0, this.availGameObjectsLen);
                this.availGameObjects = nArrayArray;
            }
            this.availGameObjects[this.availGameObjectsLen++] = new int[]{n4, 1, 0};
        }
        if (this.curTriggerIndex >= this.gameObjectsLen) {
            this.curTriggerIndex = -1;
        }
        if (this.selObjIndex >= this.gameObjectsLen) {
            this.setSelectedObjectIndex(this.gameObjectsLen - 1);
        }
        if (this.numEditableObjects > 0) {
            this.setSelectedObjectIndex(this.selObjIndex - 1);
            this.selectNextObject();
        }
        if (this.numEditableObjects == 0 && this.state == 5) {
            this.newState = (byte)3;
        }
    }

    private void setSelectedObjectIndex(int n) {
        this.selObjIndex = n;
        if (this.selObjIndex > -1) {
            this.objectArrows = 15;
            this.gameObjects[this.selObjIndex].reactOnKeys();
        }
    }

    private void removeObjectArrow(byte by) {
        if ((this.objectArrows & by) > 0) {
            this.objectArrows ^= by;
        }
    }

    private void updateMainObjectAnchor() {
        if (this.mainObjIndex == -1) {
            return;
        }
        int n = this.gameObjects[this.mainObjIndex].getLinkedGroupID();
        for (int i = 0; i < this.gameObjectsLen; ++i) {
            int n2 = this.gameObjects[i].getLinkedGroupID();
            byte by = this.gameObjects[i].getType();
            byte by2 = by = by == 2 ? (byte)1 : 0;
            if (n2 != n || by == 0) continue;
            this.mainAnchorObjIndex = i;
            return;
        }
    }

    private void selectNextObject() {
        if (this.selObjIndex < 0) {
            this.setSelectedObjectIndex(0);
        }
        do {
            if (++this.selObjIndex != this.gameObjectsLen) continue;
            this.setSelectedObjectIndex(0);
        } while (!this.gameObjects[this.selObjIndex].isEditable());
        this.selObjMovementSpeed = 1024;
    }

    public final boolean gameObjectKeyReaction(Vector2 vector2, int[] nArray, AbstractGameObject abstractGameObject) {
        boolean bl;
        s_oldPos.copy(vector2);
        byte by = abstractGameObject.getType();
        if (this.selObjMovementSpeed < 15360 && (this.k_leftPressed || this.k_rightPressed || this.k_upPressed || this.k_downPressed)) {
            this.selObjMovementSpeed += 1024;
            if (this.selObjMovementSpeed > 15360) {
                this.selObjMovementSpeed = 15360;
            }
        }
        if (this.k_leftPressed) {
            vector2.x -= this.selObjMovementSpeed;
        }
        if (this.k_rightPressed) {
            vector2.x += this.selObjMovementSpeed;
        }
        if (this.k_upPressed) {
            vector2.y -= this.selObjMovementSpeed;
        }
        if (this.k_downPressed) {
            vector2.y += this.selObjMovementSpeed;
        }
        if (vector2.x + nArray[0] < 0) {
            vector2.x = -nArray[0];
        }
        if (vector2.y + nArray[1] < 0) {
            vector2.y = -nArray[1];
        }
        Game game = this;
        int n = game.mapWidth << 15;
        if (vector2.x + nArray[2] > n) {
            vector2.x = n - nArray[2];
        }
        Game game2 = this;
        int n2 = game2.mapHeight << 15;
        if (vector2.y + nArray[3] > n2) {
            vector2.y = n2 - nArray[3];
        }
        int n3 = -1;
        if (this.mainObjIndex != -1 && this.gameObjects[this.mainObjIndex] == abstractGameObject) {
            n3 = 0;
        } else if (this.mainAnchorObjIndex != -1 && this.gameObjects[this.mainAnchorObjIndex] == abstractGameObject) {
            n3 = 4;
        }
        if (abstractGameObject.getType() == 11 && this.state != 2) {
            Vector2 vector22 = new Vector2();
            vector22.copy(vector2);
            ((StaticGameObject)abstractGameObject).setInitialPosition(vector22);
        }
        this.objectArrows = 15;
        if (n3 != -1) {
            if (vector2.x <= this.mainObjectAllowedBox[n3]) {
                this.removeObjectArrow((byte)1);
            }
            if (vector2.x >= this.mainObjectAllowedBox[n3 + 2]) {
                this.removeObjectArrow((byte)2);
            }
            if (by == 6) {
                if (this.craneSpring != null) {
                    int n4 = this.craneSpring.getRestLength();
                    if (n4 <= 10240) {
                        this.removeObjectArrow((byte)4);
                    }
                    if (n4 >= 122880) {
                        this.removeObjectArrow((byte)8);
                    }
                } else {
                    this.removeObjectArrow((byte)4);
                    this.removeObjectArrow((byte)8);
                }
            } else {
                if (vector2.y <= this.mainObjectAllowedBox[n3 + 1]) {
                    this.removeObjectArrow((byte)4);
                }
                if (vector2.y >= this.mainObjectAllowedBox[n3 + 3]) {
                    this.removeObjectArrow((byte)8);
                }
            }
        }
        if (Game.s_oldPos.x == vector2.x && Game.s_oldPos.y == vector2.y) {
            return false;
        }
        if (n3 != -1) {
            if (vector2.x < this.mainObjectAllowedBox[n3]) {
                vector2.x = this.mainObjectAllowedBox[n3];
            }
            if (vector2.y < this.mainObjectAllowedBox[n3 + 1]) {
                vector2.y = this.mainObjectAllowedBox[n3 + 1];
            }
            if (vector2.x > this.mainObjectAllowedBox[n3 + 2]) {
                vector2.x = this.mainObjectAllowedBox[n3 + 2];
            }
            if (vector2.y > this.mainObjectAllowedBox[n3 + 3]) {
                vector2.y = this.mainObjectAllowedBox[n3 + 3];
            }
        }
        if (bl = by == 2 || by == 3) {
            int n5;
            PhysicalObject physicalObject;
            AbstractGameObject abstractGameObject2;
            block38: {
                abstractGameObject2 = abstractGameObject;
                Game game3 = this;
                int n6 = abstractGameObject2.getLinkedGroupID();
                for (int i = 0; i < game3.gameObjectsLen; ++i) {
                    if (game3.gameObjects[i].getLinkedGroupID() != n6 || game3.gameObjects[i] == abstractGameObject2) continue;
                    physicalObject = (PhysicalObject)((Object)game3.gameObjects[i]);
                    break block38;
                }
                physicalObject = null;
            }
            abstractGameObject2 = physicalObject;
            tmpVector.copy(((PhysicalObject)((Object)abstractGameObject2)).centerPos);
            tmpVector.subtract(vector2);
            if (!tmpVector.isNull() && (long)(n5 = tmpVector.normaliseWithShift()) >= 307200L) {
                tmpVector.multiplyWithShift(1448);
                tmpVector.multiplyWithShift(this.selObjMovementSpeed);
                vector2.add(tmpVector);
            }
        }
        if (by == 6) {
            vector2.y = Game.s_oldPos.y;
            if (this.craneSpring != null) {
                int n7 = this.k_upPressed ? -1 : (this.k_downPressed ? 1 : 0);
                n7 = n7 << 12;
                this.craneSpring.setRestLength(this.craneSpring.getRestLength() + n7);
                if (this.craneSpring.getRestLength() < 10240) {
                    this.craneSpring.setRestLength(10240);
                }
                if (this.craneSpring.getRestLength() > 122880) {
                    this.craneSpring.setRestLength(122880);
                }
            }
        }
        return true;
    }

    public final void keyReleased(int n, int n2, int n3) {
        try {
            if (this.state == 7 || this.state == 9) {
                switch (n2) {
                    case 4: 
                    case 5: {
                        Form form = this.textboxForm;
                        this.textboxForm.scrollingDirection = 0;
                    }
                }
                this.resetKeyStates();
                return;
            }
            if (n3 == 6) {
                this.trackballDownCounter = 4;
                return;
            }
            if (n3 == 2) {
                this.trackballLeftCounter = 4;
                return;
            }
            if (n3 == 5) {
                this.trackballRightCounter = 4;
                return;
            }
            if (n3 == 1) {
                this.trackballUpCounter = 4;
                return;
            }
            switch (n2) {
                case 6: {
                    this.k_leftPressed = false;
                    break;
                }
                case 7: {
                    this.k_rightPressed = false;
                    break;
                }
                case 4: {
                    this.k_upPressed = false;
                    break;
                }
                case 5: {
                    this.k_downPressed = false;
                }
            }
            if (!(this.k_leftPressed || this.k_rightPressed || this.k_upPressed || this.k_downPressed)) {
                this.selObjMovementSpeed = 1024;
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static final int worldToScreen(int n) {
        return n * 768 >> 20;
    }

    private static int levelToWorld(int n) {
        return n * 1365 + 512;
    }

    static {
        MAX_SCORE = 10000000;
        TOOLBAR_ITEMIMAGES = new int[]{30, 34, 33, 32, 29, 31, 37};
        toolbarItems = new byte[30][4];
        animScores = new int[2][4];
        BONUS_TEXT_IDS = new int[]{39, 40, 41, 42, 43, -1};
        brutalityOn = false;
        brutalityKeysCache = new int[10];
        tmpVector = new Vector2();
        new Vector2();
        new Vector2();
        tmpPoly = new Vector2[32];
        tmpMatrix = new Matrix2x2();
        VISUAL_IMAGE_REMAP = new int[]{86};
        activeArea = new int[4];
        s_oldPos = new Vector2();
    }
}

