/*
 * Decompiled with CFR 0.152.
 */
import com.hardwire.dymix.CollisionProxy;
import com.hardwire.dymix.DynamicObject;
import com.hardwire.dymix.Joint;
import com.hardwire.dymix.PhysicalObject;
import com.hardwire.dymix.Spring;
import com.hardwire.utils.Vector2;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public final class DynamicGameObject
extends DynamicObject
implements AbstractGameObject {
    private byte state;
    private byte type;
    public static CollisionProxy[] shapes;
    private Game game;
    private boolean collidedThisFrame;
    private boolean editable;
    private boolean triggerable;
    private int linkedGroupID;
    private static int[][][][] visuals;
    private Vector2 dragPos;
    private int dragAngle;
    public Joint attachedJoint;
    public Spring attachedSpring;
    private static DynamicObject pingObject;
    private static Vector2 pingImpulse;
    public static int pingCooldown;

    public DynamicGameObject(Game game, byte by, int n) {
        this.game = game;
        this.type = by;
        this.state = 0;
        this.linkedGroupID = n;
    }

    public final void init(Vector2 vector2, int n) {
        this.state = (byte)2;
        this.initBody(this.game.world, shapes[this.type], AbstractGameObject.COEF_FRICTION[this.type], AbstractGameObject.COEF_RESTITUTION[this.type], AbstractGameObject.COEF_DENSITY[this.type], true);
        this.userType = 2;
        this.spawnBody(vector2, n);
        this.dragPos = new Vector2(vector2);
        this.dragAngle = n;
        this.collidedThisFrame = true;
        this.editable = true;
    }

    public final void init(DataInputStream dataInputStream) throws IOException {
        this.init(new Vector2(dataInputStream.readInt(), dataInputStream.readInt()), dataInputStream.readInt());
        this.editable = dataInputStream.readBoolean();
        this.triggerable = dataInputStream.readBoolean();
    }

    public final void saveState(DataOutputStream dataOutputStream) throws IOException {
        Vector2 vector2 = this.dragPos;
        dataOutputStream.writeInt(vector2.x);
        dataOutputStream.writeInt(vector2.y);
        dataOutputStream.writeInt(this.getAngle_shifted());
        dataOutputStream.writeBoolean(this.editable);
        dataOutputStream.writeBoolean(this.triggerable);
    }

    public final void removeFromWorld() {
        if (this.state == 0) {
            return;
        }
        this.despawnBody();
        if (this.attachedJoint != null) {
            this.game.world.removeJoint(this.attachedJoint);
            this.attachedJoint = null;
        }
        if (this.attachedSpring != null) {
            this.game.world.removeSpring(this.attachedSpring);
            this.attachedSpring = null;
        }
    }

    public final void draw(Graphics graphics) {
        this.updateDrawData();
        this.game.drawVectorGfx_worldCoords(graphics, visuals[this.type], this.getDrawPosition(), this.getDrawAngle_shifted(), -1);
    }

    public final void tick() {
        if (this.state == 3) {
            if (!this.collidedThisFrame) {
                this.state = (byte)2;
            } else {
                this.collidedThisFrame = false;
            }
        }
        if (this.state == 2 || this.state == 3 || this.state == 5) {
            this.getLinearVelocity().set(0, 0);
            this._setPosition(this.dragPos);
            if (this.attachedJoint == null && this.attachedSpring == null) {
                this._setAngle_shifted(this.dragAngle);
            }
            this.resetDrawData();
            this.recomputeBoundingBox();
            if (this.game.selObjIndex != -1 && this.game.gameObjects[this.game.selObjIndex] == this) {
                this.wakeUp();
                return;
            }
            this.forceSleep();
        }
    }

    public final void release() {
        this.changePosition(this.dragPos);
        this.setAngularVelocity_shifted(0);
        this.getLinearVelocity().set(0, 0);
        DynamicGameObject dynamicGameObject = this;
        if (dynamicGameObject.triggerable) {
            this.state = (byte)5;
            return;
        }
        this.state = 1;
        this.wakeUp();
    }

    public final void trigger() {
        this.state = 1;
        this.getLinearVelocity().y = 1024;
        this.wakeUp();
    }

    public final void reactOnKeys() {
        Object object = this;
        object = ((PhysicalObject)object).collisionProxy;
        this.game.gameObjectKeyReaction(this.dragPos, ((CollisionProxy)object).boundingBox, this);
    }

    public final boolean canCollideWith(PhysicalObject physicalObject) {
        return true;
    }

    protected final boolean notifyBeforeCollisionResponse$2b11b2a(PhysicalObject physicalObject, int n, int n2) {
        this.collidedThisFrame = true;
        pingObject = null;
        if (this.state == 2) {
            this.state = (byte)3;
        }
        if (this.state == 3) {
            return false;
        }
        int n3 = n = this.type == 3 ? 1 : 0;
        if (pingCooldown == 0 && n != 0 && this.state == 1 && physicalObject.isDynamic && physicalObject.userType == 1) {
            pingCooldown = 100;
            pingObject = (DynamicObject)physicalObject;
            pingImpulse.copy(this.getLinearVelocity());
            pingImpulse.multiplyWithShift(682);
        }
        return true;
    }

    protected final void notifyAfterCollisionResponse$7af36c03() {
        if (pingObject != null) {
            pingObject.getLinearVelocity().add(pingImpulse);
        }
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public final void setEditable(boolean bl) {
        this.editable = bl;
    }

    public final byte getType() {
        return this.type;
    }

    public final byte getState() {
        return this.state;
    }

    public final void setState(byte by) {
        this.state = (byte)3;
    }

    public final int getLinkedGroupID() {
        return this.linkedGroupID;
    }

    public final void setTrigger(boolean bl) {
        this.triggerable = true;
    }

    public static void loadStaticData(DataInputStream dataInputStream) {
        visuals = new int[41][][][];
        shapes = new CollisionProxy[41];
        Vector2[][] vector2ArrayArray = new Vector2[41][];
        DynamicGameObject.visuals[17] = Game.loadVectorObject_model(dataInputStream);
        vector2ArrayArray[17] = Game.loadVectorObject_physics(dataInputStream);
        Controller.updateLoadBar(1);
        DynamicGameObject.visuals[3] = Game.loadVectorObject_model(dataInputStream);
        vector2ArrayArray[3] = Game.loadVectorObject_physics(dataInputStream);
        Controller.updateLoadBar(1);
        DynamicGameObject.visuals[18] = Game.loadVectorObject_model(dataInputStream);
        vector2ArrayArray[18] = Game.loadVectorObject_physics(dataInputStream);
        Controller.updateLoadBar(1);
        Controller.updateLoadBar(1);
        DynamicGameObject.visuals[22] = Game.loadVectorObject_model(dataInputStream);
        vector2ArrayArray[22] = Game.loadVectorObject_physics(dataInputStream);
        Controller.updateLoadBar(1);
        Controller.updateLoadBar(1);
        DynamicGameObject.visuals[1] = Game.loadVectorObject_model(dataInputStream);
        vector2ArrayArray[1] = Game.loadVectorObject_physics(dataInputStream);
        Controller.updateLoadBar(1);
        Controller.updateLoadBar(1);
        for (int i = 0; i < vector2ArrayArray.length; ++i) {
            if (vector2ArrayArray[i] == null) continue;
            DynamicGameObject.shapes[i] = new CollisionProxy(vector2ArrayArray[i], true);
        }
        Controller.updateLoadBar(1);
    }

    static {
        pingImpulse = new Vector2();
        new Vector2();
        new Vector2();
    }
}

