/*
 * Decompiled with CFR 0.152.
 */
class GLLibPathFinding {
    public static final int kDirUp = 0;
    public static final int kDirDown = 1;
    public static final int kDirLeft = 2;
    public static final int kDirRight = 3;
    public static final int kDirUpLeft = 4;
    public static final int kDirUpRight = 5;
    public static final int kDirDownLeft = 6;
    public static final int kDirDownRight = 7;
    private static int[] kDirPrecalc = new int[]{0, -1, 0, 1, -1, 0, 1, 0, -1, -1, 1, -1, -1, 1, 1, 1};
    private short[] m_nodeParent;
    private short[] m_nodePrev;
    private short[] m_nodeNext;
    private short[] m_nodeG;
    private short[] m_nodeH;
    private int m_nCostMove;
    private int m_nCostMoveDiag;
    private int m_nCostChangeDir;
    private int m_nUseDirectionCount;
    private int m_nMapW;
    private int m_nMapH;
    private byte[] m_pPhysMap;
    private int m_nPhysMapMask;
    private short[] m_path;
    private int m_pathIdx;
    private int m_openedSortedList;
    private boolean m_init = false;

    private int PACK_POS(int n, int n2) {
        return n2 * this.m_nMapW + n;
    }

    private int UNPACK_X(int n) {
        return n % this.m_nMapW;
    }

    private int UNPACK_Y(int n) {
        return n / this.m_nMapW;
    }

    public void PathFinding_Init(int n, int n2, byte[] byArray, int n3, int n4, int n5, int n6) {
        this.PathFinding_Init(n, n2, byArray, n3, n4, n5, n6, -1);
    }

    public void PathFinding_Init(int n, int n2, byte[] byArray, int n3, int n4, int n5, int n6, int n7) {
        GLLib.Assert(n6 == 4 || n6 == 8, "PathFinding_Init nDirCount should be 4 or 8.");
        this.m_nMapW = n;
        this.m_nMapH = n2;
        this.m_pPhysMap = byArray;
        this.m_nPhysMapMask = n7;
        this.m_nCostMove = n3;
        this.m_nCostMoveDiag = n4;
        this.m_nCostChangeDir = n5;
        this.m_nUseDirectionCount = n6;
        this.m_nodeParent = new short[GLLibConfig.pathfinding_MaxNode];
        this.m_nodePrev = new short[GLLibConfig.pathfinding_MaxNode];
        this.m_nodeNext = new short[GLLibConfig.pathfinding_MaxNode];
        this.m_nodeG = new short[GLLibConfig.pathfinding_MaxNode];
        this.m_nodeH = new short[GLLibConfig.pathfinding_MaxNode];
        this.m_openedSortedList = -1;
        this.m_path = new short[GLLibConfig.pathfinding_MaxNode];
        this.m_pathIdx = -1;
        this.m_init = true;
    }

    public void PathFinding_Exec(int n, int n2, int n3, int n4, int n5) {
        this.PathFinding_Exec(n, n2, n3, n4, n5, 0, 0, this.m_nMapW, this.m_nMapH);
    }

    public void PathFinding_Exec(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10;
        int n11;
        int n12;
        int n13;
        GLLib.Assert(this.m_init, "GLLibPathFinding not initialized");
        int n14 = n3;
        if (GLLibConfig.pathfinding_Debug) {
            GLLib.Dbg("------------- execPathFinding -------------");
            GLLib.Dbg("execPathFinding from (" + n + ", " + n2 + ") to (" + n4 + ", " + n5 + ")");
            GLLib.Dbg("  searching sub-area (" + n6 + ", " + n7 + ") to (" + (n6 + n8) + ", " + (n7 + n9) + ")");
        }
        for (n13 = 0; n13 < GLLibConfig.pathfinding_MaxNode; ++n13) {
            this.m_nodeParent[n13] = -1;
            this.m_nodePrev[n13] = -1;
            this.m_nodeNext[n13] = -1;
            this.m_nodeG[n13] = 0;
            this.m_nodeH[n13] = 0;
            this.m_path[n13] = 0;
        }
        this.m_openedSortedList = -1;
        int n15 = (n2 - n7) * n8 + (n - n6);
        int n16 = n4 - n6;
        int n17 = n5 - n7;
        while (n15 != -1) {
            this.listRem(n15);
            this.m_nodeG[n15] = -1;
            this.m_nodeH[n15] = -1;
            int n18 = n15 % n8;
            int n19 = n15 / n8;
            if (n18 == n16 && n19 == n17) {
                if (!GLLibConfig.pathfinding_Debug) break;
                GLLib.Dbg("a path has been found");
                break;
            }
            if (GLLibConfig.pathfinding_Debug) {
                GLLib.Dbg("current node[" + n15 + "] is {" + (n18 + n6) + " (" + n18 + " + " + n6 + "), " + (n19 + n7) + " (" + n19 + " + " + n7 + ")}");
            }
            for (n12 = 0; n12 < this.m_nUseDirectionCount; ++n12) {
                int n20 = kDirPrecalc[(n12 << 1) + 0];
                int n21 = kDirPrecalc[(n12 << 1) + 1];
                int n22 = n20 != 0 && n21 != 0 ? this.m_nCostMoveDiag : this.m_nCostMove;
                n20 += n18;
                n21 += n19;
                if (GLLibConfig.pathfinding_Debug) {
                    GLLib.Dbg("position is {" + (n20 + n6) + " (" + n20 + " + " + n6 + "), " + (n21 + n7) + " (" + n21 + " + " + n7 + ")}");
                }
                if (n20 < 0 || n20 >= n8) {
                    if (!GLLibConfig.pathfinding_Debug) continue;
                    GLLib.Dbg("x position is not in the map");
                    continue;
                }
                if (n21 < 0 || n21 >= n9) {
                    if (!GLLibConfig.pathfinding_Debug) continue;
                    GLLib.Dbg("y position is not in the map");
                    continue;
                }
                if (n12 >= 4) {
                    n11 = n15 % n8;
                    n10 = n15 / n8;
                    if (n12 == 4 ? (this.m_pPhysMap[this.PACK_POS(n11 - 1 + n6, n10 + n7)] & this.m_nPhysMapMask) != 0 || (this.m_pPhysMap[this.PACK_POS(n11 + n6, n10 - 1 + n7)] & this.m_nPhysMapMask) != 0 : (n12 == 5 ? (this.m_pPhysMap[this.PACK_POS(n11 + 1 + n6, n10 + n7)] & this.m_nPhysMapMask) != 0 || (this.m_pPhysMap[this.PACK_POS(n11 + n6, n10 - 1 + n7)] & this.m_nPhysMapMask) != 0 : (n12 == 6 ? (this.m_pPhysMap[this.PACK_POS(n11 - 1 + n6, n10 + n7)] & this.m_nPhysMapMask) != 0 || (this.m_pPhysMap[this.PACK_POS(n11 + n6, n10 + 1 + n7)] & this.m_nPhysMapMask) != 0 : n12 == 7 && ((this.m_pPhysMap[this.PACK_POS(n11 + 1 + n6, n10 + n7)] & this.m_nPhysMapMask) != 0 || (this.m_pPhysMap[this.PACK_POS(n11 + n6, n10 + 1 + n7)] & this.m_nPhysMapMask) != 0)))) continue;
                }
                n13 = n21 * n8 + n20;
                if (GLLibConfig.pathfinding_Debug) {
                    GLLib.Dbg("\tadjacent node[" + n13 + "] is {" + (n20 + n6) + " (" + n20 + " + " + n6 + "), " + (n21 + n7) + " (" + n21 + " + " + n7 + ")}");
                }
                if ((this.m_pPhysMap[this.PACK_POS(n20 + n6, n21 + n7)] & this.m_nPhysMapMask) != 0) {
                    if (!GLLibConfig.pathfinding_Debug) continue;
                    GLLib.Dbg("\tnode is a wall");
                    continue;
                }
                if (this.m_nodeG[n13] == -1) {
                    if (!GLLibConfig.pathfinding_Debug) continue;
                    GLLib.Dbg("\tnode has been already checked");
                    continue;
                }
                int n23 = n14 == n12 ? 0 : this.m_nCostChangeDir;
                int n24 = this.m_nodeG[n15] + n22 + n23;
                int n25 = Math.abs(n20 - n16);
                int n26 = Math.abs(n21 - n17);
                int n27 = n25 > n26 ? this.m_nCostMoveDiag * n26 + this.m_nCostMove * (n25 - n26) : this.m_nCostMoveDiag * n25 + this.m_nCostMove * (n26 - n25);
                if (this.m_nodePrev[n13] == -1 && this.m_nodeNext[n13] == -1 && this.m_openedSortedList != n13) {
                    this.m_nodeParent[n13] = (short)n15;
                    this.m_nodeG[n13] = (short)n24;
                    this.m_nodeH[n13] = (short)n27;
                    if (GLLibConfig.pathfinding_Debug) {
                        GLLib.Dbg("\tadd adjacent node to open list (score : " + (n24 + n27) + ")");
                    }
                    this.listAdd(n13);
                    continue;
                }
                if (this.m_nodeG[n13] <= n24) continue;
                this.m_nodeParent[n13] = (short)n15;
                this.m_nodeG[n13] = (short)n24;
                if (GLLibConfig.pathfinding_Debug) {
                    GLLib.Dbg("\trelink adjacent node to current node");
                }
                this.listRem(n13);
                this.listAdd(n13);
            }
            n15 = this.m_openedSortedList;
            if (GLLibConfig.pathfinding_Debug) {
                GLLib.Dbg("change current node to : " + n15 + " {" + (n15 % n8 + n6) + "(" + n15 % n8 + " + " + n6 + ")," + (n15 / n8 + n7) + "(" + n15 / n8 + " + " + n7 + ")}");
            }
            if (n15 == -1) continue;
            short s = this.m_nodeParent[n15];
            n14 = n15 % n8 != s % n8 ? (n15 % n8 > s % n8 ? 3 : 2) : (n15 / n8 != s / n8 ? 1 : 0);
            if (!GLLibConfig.pathfinding_Debug) continue;
            GLLib.Dbg("new node[" + n15 + "] (score : " + (this.m_nodeG[n15] + this.m_nodeH[n15]) + ") is {" + (n15 % n8 + n6) + " (" + n15 % n8 + " + " + n6 + "), " + (n15 / n8 + n7) + " (" + n15 / n8 + " + " + n7 + ")}");
        }
        if (n15 == -1) {
            if (GLLibConfig.pathfinding_Debug) {
                GLLib.Dbg("opened list is empty... there is no path");
                GLLib.Dbg("-------------------------------------------");
            }
            this.m_pathIdx = -1;
            return;
        }
        this.m_pathIdx = 0;
        while (n15 != -1) {
            n12 = n15 % n8 + n6;
            n11 = n15 / n8 + n7;
            this.m_path[this.m_pathIdx++] = (short)this.PACK_POS(n12, n11);
            n15 = this.m_nodeParent[n15];
        }
        --this.m_pathIdx;
        if (GLLibConfig.pathfinding_Debug) {
            GLLib.Dbg("-------------------------------------------");
            for (n12 = this.m_pathIdx; n12 >= 0; --n12) {
                n11 = this.m_path[n12];
                n10 = this.UNPACK_X(n11);
                int n28 = this.UNPACK_Y(n11);
                GLLib.Dbg("node [" + n12 + "]\t= (" + n10 + ", " + n28 + ")");
            }
            GLLib.Dbg("-------------------------------------------");
        }
    }

    public int PathFinding_GetPathLength() {
        GLLib.Assert(this.m_init, "GLLibPathFinding not initialized");
        return this.m_pathIdx + 1;
    }

    public int PathFinding_GetPathPosition(int n) {
        GLLib.Assert(this.m_init, "GLLibPathFinding not initialized");
        return this.m_path[n];
    }

    public int PathFinding_GetPathPositionX(int n) {
        GLLib.Assert(this.m_init, "GLLibPathFinding not initialized");
        return this.UNPACK_X(this.m_path[n]);
    }

    public int PathFinding_GetPathPositionY(int n) {
        GLLib.Assert(this.m_init, "GLLibPathFinding not initialized");
        return this.UNPACK_Y(this.m_path[n]);
    }

    public void PathFinding_Free(boolean bl) {
        this.m_init = false;
        this.m_nodeParent = null;
        this.m_nodePrev = null;
        this.m_nodeNext = null;
        this.m_nodeG = null;
        this.m_nodeH = null;
        this.m_pPhysMap = null;
        if (!bl) {
            this.m_pathIdx = -1;
            this.m_path = null;
        }
        if (GLLibConfig.useSystemGc) {
            System.gc();
        }
    }

    private void listAdd(int n) {
        if (this.m_openedSortedList == -1) {
            this.m_openedSortedList = n;
            return;
        }
        int n2 = this.m_nodeG[n] + this.m_nodeH[n];
        int n3 = this.m_openedSortedList;
        while (n3 != -1) {
            int n4 = this.m_nodeG[n3] + this.m_nodeH[n3];
            if (n2 < n4) {
                if (this.m_nodePrev[n3] == -1) {
                    this.m_openedSortedList = n;
                } else {
                    short s = this.m_nodePrev[n3];
                    this.m_nodeNext[s] = (short)n;
                }
                this.m_nodePrev[n] = this.m_nodePrev[n3];
                this.m_nodeNext[n] = (short)n3;
                this.m_nodePrev[n3] = (short)n;
                return;
            }
            if (this.m_nodeNext[n3] == -1) {
                this.m_nodeNext[n3] = (short)n;
                this.m_nodePrev[n] = (short)n3;
                return;
            }
            n3 = this.m_nodeNext[n3];
        }
    }

    private void listRem(int n) {
        short s;
        if (this.m_nodeNext[n] != -1) {
            s = this.m_nodeNext[n];
            this.m_nodePrev[s] = this.m_nodePrev[n];
        }
        if (this.m_openedSortedList == n) {
            this.m_openedSortedList = this.m_nodeNext[n];
        } else if (this.m_nodePrev[n] != -1) {
            s = this.m_nodePrev[n];
            this.m_nodeNext[s] = this.m_nodeNext[n];
        }
        this.m_nodePrev[n] = -1;
        this.m_nodeNext[n] = -1;
    }

    private void listDisplay() {
        int n = this.m_openedSortedList;
        GLLib.Dbg("************* listDisplay *************");
        while (n != -1) {
            GLLib.Dbg("elm index[" + n + "] (" + this.UNPACK_X(n) + ", " + this.UNPACK_Y(n) + ") with value = " + (this.m_nodeG[n] + this.m_nodeH[n]));
            n = this.m_nodeNext[n];
        }
        GLLib.Dbg("***************************************");
    }
}

