/*
 * Decompiled with CFR 0.152.
 */
public class GLLibMidiSpectrumAnalyzer {
    private static final byte[] HEADER_CHUNK = "MThd".getBytes();
    private static final byte[] TRACK_CHUNK = "MTrk".getBytes();
    public static final int NO_ERRORS = 0;
    public static final int ERROR_INVALID_HEADER_CHUNK = 1;
    public static final int ERROR_INVALID_TRACK_CHUNK = 2;
    public static final int ERROR_INVALID_FILE_LENGTH = 3;
    public static final int ERROR_INVALID_META_EVENT = 4;
    private static final int EVENT_NOTE_OFF = 128;
    private static final int EVENT_NOTE_ON = 144;
    private static final int EVENT_POLYPHONIC_KEY_PRESSURE = 160;
    private static final int EVENT_CONTROL_CHANGE = 176;
    private static final int EVENT_PROGRAM_CHANGE = 192;
    private static final int EVENT_CHANNEL_KEY_PRESSURE = 208;
    private static final int EVENT_PITCH_BEND = 224;
    private static final int EVENT_META = 240;
    private static final int META_EVENT_SET_SEQUENCE_NUMBRE = 0;
    private static final int META_EVENT_TEXT = 1;
    private static final int META_EVENT_COPYRIGHT = 2;
    private static final int META_EVENT_TRACK_NAME = 3;
    private static final int META_EVENT_INSTRUMENT_NAME = 4;
    private static final int META_EVENT_LYRIC = 5;
    private static final int META_EVENT_MARKER = 6;
    private static final int META_EVENT_CUE_POINT = 7;
    private static final int META_EVENT_TRACK_END = 47;
    private static final int META_EVENT_SET_TEMPO = 81;
    private static final int META_EVENT_SET_TIME_SIGNATURE = 88;
    private static final int META_EVENT_KEY_SIGNATURE = 89;
    private byte[][] m_tracks;
    private byte[] m_data;
    private int m_offset;
    public int m_channelFilter = 15;
    public int m_bars;
    public int[] m_barLevels;
    private int m_maxValue;
    private int m_velocityShift;
    private int m_millisShift;
    private int m_releaseDamping;
    private int m_fileFormat;
    private int m_numberOfTracks;
    private int m_deltaTimeTickPerQuarterNote;
    private int m_tempo = 500000;
    public long m_currentTime = 0L;
    private long m_lastNoteTime = 0L;
    private int m_event = 0;
    private int m_metaEvent = 0;

    public GLLibMidiSpectrumAnalyzer(int n, int n2, int n3, int n4, int n5) {
        this.m_barLevels = new int[n];
        this.m_bars = n;
        this.m_maxValue = n2;
        this.m_velocityShift = n3;
        this.m_millisShift = n4;
        this.m_releaseDamping = n5;
    }

    private int MidiSpectrumAnalyzer_PeakByte() {
        return this.m_data[this.m_offset] & 0xFF;
    }

    private int MidiSpectrumAnalyzer_ReadByte() {
        return this.m_data[this.m_offset++] & 0xFF;
    }

    private int MidiSpectrumAnalyzer_ReadShort() {
        int n = (this.m_data[this.m_offset + 0] & 0xFF) << 8 | (this.m_data[this.m_offset + 1] & 0xFF) << 0;
        this.m_offset += 2;
        return n;
    }

    private int MidiSpectrumAnalyzer_ReadInt() {
        int n = (this.m_data[this.m_offset + 0] & 0xFF) << 24 | (this.m_data[this.m_offset + 1] & 0xFF) << 16 | (this.m_data[this.m_offset + 2] & 0xFF) << 8 | (this.m_data[this.m_offset + 3] & 0xFF) << 0;
        this.m_offset += 4;
        return n;
    }

    private int MidiSpectrumAnalyzer_ReadThreeBytes() {
        int n = (this.m_data[this.m_offset + 0] & 0xFF) << 16 | (this.m_data[this.m_offset + 1] & 0xFF) << 8 | (this.m_data[this.m_offset + 2] & 0xFF) << 0;
        this.m_offset += 3;
        return n;
    }

    private int MidiSpectrumAnalyzer_ReadVariableLength() {
        byte by;
        int n = 0;
        do {
            by = this.m_data[this.m_offset++];
            n = (n << 7) + (by & 0x7F);
        } while ((by & 0x80) == 128);
        return n;
    }

    public int MidiSpectrumAnalyzer_Parse(byte[] byArray) {
        int n;
        this.m_offset = 0;
        this.m_data = byArray;
        if (this.m_offset + 16 > byArray.length) {
            return 1;
        }
        for (n = 0; n < HEADER_CHUNK.length; ++n) {
            if (HEADER_CHUNK[n] == this.MidiSpectrumAnalyzer_ReadByte()) continue;
            return 1;
        }
        n = this.MidiSpectrumAnalyzer_ReadInt();
        if (n != 6) {
            return 1;
        }
        this.m_fileFormat = this.MidiSpectrumAnalyzer_ReadShort();
        this.m_numberOfTracks = this.MidiSpectrumAnalyzer_ReadShort();
        this.m_deltaTimeTickPerQuarterNote = this.MidiSpectrumAnalyzer_ReadShort();
        this.m_tracks = new byte[this.m_numberOfTracks][];
        for (int i = 0; i < this.m_numberOfTracks; ++i) {
            int n2;
            if (this.m_offset + 8 > byArray.length) {
                return 2;
            }
            for (n2 = 0; n2 < TRACK_CHUNK.length; ++n2) {
                if (TRACK_CHUNK[n2] == this.MidiSpectrumAnalyzer_ReadByte()) continue;
                return 2;
            }
            n2 = this.MidiSpectrumAnalyzer_ReadInt();
            if (this.m_offset + n2 > byArray.length) {
                return 2;
            }
            this.m_tracks[i] = new byte[n2];
            System.arraycopy(byArray, this.m_offset, this.m_tracks[i], 0, n2);
            this.m_offset += n2;
        }
        if (this.m_offset < byArray.length) {
            return 3;
        }
        this.m_data = null;
        this.MidiSpectrumAnalyzer_Reset();
        return 0;
    }

    public void MidiSpectrumAnalyzer_Reset() {
        this.m_offset = 0;
        this.m_data = this.m_tracks[0];
        this.m_currentTime = 0L;
        this.m_lastNoteTime = 0L;
    }

    public int MidiSpectrumAnalyzer_Update(long l) {
        int n;
        long l2 = l - this.m_currentTime;
        this.m_currentTime = l;
        for (n = 0; n < this.m_barLevels.length; ++n) {
            int n2 = n;
            this.m_barLevels[n2] = (int)((long)this.m_barLevels[n2] - (l2 << this.m_millisShift));
            if (this.m_barLevels[n] >= 0) continue;
            this.m_barLevels[n] = 0;
        }
        if (this.m_offset >= this.m_data.length) {
            return 0;
        }
        block17: do {
            n = this.m_offset;
            int n3 = this.MidiSpectrumAnalyzer_ReadVariableLength();
            long l3 = this.MidiSpectrumAnalyzer_GetTicksInMillis(n3);
            if (this.m_currentTime < this.m_lastNoteTime + l3) {
                this.m_offset = n;
                break;
            }
            this.m_lastNoteTime += l3;
            if ((this.MidiSpectrumAnalyzer_PeakByte() & 0x80) == 128) {
                this.m_event = this.MidiSpectrumAnalyzer_ReadByte() & 0xFF;
            }
            int n4 = this.m_event & 0xF;
            switch (this.m_event & 0xF0) {
                case 128: {
                    int n5;
                    int n6 = this.MidiSpectrumAnalyzer_ReadByte();
                    int n7 = this.MidiSpectrumAnalyzer_ReadByte();
                    if ((n4 & this.m_channelFilter) == 0) continue block17;
                    int n8 = n5 = this.m_bars * n6 / 128;
                    this.m_barLevels[n8] = this.m_barLevels[n8] - this.m_releaseDamping;
                    if (this.m_barLevels[n5] >= 0) continue block17;
                    this.m_barLevels[n5] = 0;
                    break;
                }
                case 144: {
                    int n5;
                    int n6 = this.MidiSpectrumAnalyzer_ReadByte();
                    int n7 = this.MidiSpectrumAnalyzer_ReadByte();
                    if (n7 == 0 && (n4 & this.m_channelFilter) != 0) {
                        int n9 = n5 = this.m_bars * n6 / 128;
                        this.m_barLevels[n9] = this.m_barLevels[n9] - this.m_releaseDamping;
                        if (this.m_barLevels[n5] < 0) {
                            this.m_barLevels[n5] = 0;
                        }
                    }
                    if ((n4 & this.m_channelFilter) == 0) continue block17;
                    int n10 = n5 = this.m_bars * n6 / 128;
                    this.m_barLevels[n10] = this.m_barLevels[n10] + (n7 << this.m_velocityShift);
                    if (this.m_barLevels[n5] <= this.m_maxValue) continue block17;
                    this.m_barLevels[n5] = this.m_maxValue;
                    break;
                }
                case 160: {
                    int n6 = this.MidiSpectrumAnalyzer_ReadByte();
                    int n7 = this.MidiSpectrumAnalyzer_ReadByte();
                    break;
                }
                case 176: {
                    int n6 = this.MidiSpectrumAnalyzer_ReadByte();
                    int n7 = this.MidiSpectrumAnalyzer_ReadByte();
                    break;
                }
                case 192: {
                    int n6 = this.MidiSpectrumAnalyzer_ReadByte();
                    break;
                }
                case 208: {
                    int n6 = this.MidiSpectrumAnalyzer_ReadByte();
                    break;
                }
                case 224: {
                    int n6 = this.MidiSpectrumAnalyzer_ReadByte();
                    int n7 = this.MidiSpectrumAnalyzer_ReadByte();
                    break;
                }
                case 240: {
                    int n6;
                    block10 : switch (this.m_event) {
                        case 255: {
                            this.m_metaEvent = this.MidiSpectrumAnalyzer_ReadByte();
                            n6 = this.MidiSpectrumAnalyzer_ReadByte();
                            switch (this.m_metaEvent) {
                                case 81: {
                                    this.m_tempo = this.MidiSpectrumAnalyzer_ReadThreeBytes();
                                    break block10;
                                }
                            }
                            this.m_offset += n6;
                        }
                    }
                    continue block17;
                }
                default: {
                    System.out.println("\t!!! ERROR - Unsupported m_event");
                }
            }
        } while (this.m_offset < this.m_data.length);
        return 0;
    }

    private long MidiSpectrumAnalyzer_GetTicksInMillis(long l) {
        return l * 1000L * 60L / (60000000L / (long)this.m_tempo * (long)this.m_deltaTimeTickPerQuarterNote);
    }
}

