/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import java.util.Vector;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class XPlayer {
    public static final byte SCORE_TYPE_POINTS = 1;
    public static final byte SCORE_TYPE_TIME = 2;
    protected static final byte FUNCTION_LOGIN_REGISTER = 11;
    protected static final byte FUNCTION_UPLOAD_SCORE = 0;
    protected static final byte FUNCTION_GET_RANKINGS = 12;
    protected static final byte FUNCTION_GET_RANKINGS_AROUND_PLAYER = 13;
    protected static final byte FUNCTION_CHANGE_USERNAME = 14;
    protected static final byte FUNCTION_RATE_GAME = 8;
    protected static final byte FUNCTION_RECOMMEND_GAME_TO_BUDDIES = 9;
    protected static final byte FUNCTION_GET_STATS = 10;
    protected static String GGI;
    public static final int NOT_A_NUMBER = -666666;
    protected HTTP whttp;
    protected int leaderboardSize = -666666;
    protected String[] leaderboardPlayerNames = null;
    protected int[] leaderboardPlayerPositions = null;
    protected int[] leaderboardPlayerScores = null;
    protected int[][] leaderboardPlayerScoreDatas = null;
    protected int leaderboardSupplementalDataFieldsNumber = 0;
    protected int currentPlayerLeaderboardPosition = -666666;
    protected int currentPlayerLeaderboardScore = -666666;
    protected int[] currentPlayerLeaderboardScoreData = null;
    protected String multipleScoresRequestBuffer = null;
    protected String url;
    protected String username;
    protected String uid;
    protected boolean is_logged_in = false;
    protected int newRankAfterScoreSending;
    public static long callstarttime;
    protected int lastErrorCode;
    protected String phoneNumber;
    protected int bestRank = -666666;
    protected int highScore = -666666;
    protected int[] highScoreData = null;
    protected int lowScore = -666666;
    protected int[] lowScoreData = null;
    protected int avgScore = -666666;
    protected int numberOfGamesPlayed = -666666;
    protected String lastTimePlayed = null;
    protected int crtPosWrite;
    protected int crtPosRead;
    protected byte[] msgData;
    protected TCP wtcp;
    protected String url_tcp;
    protected byte m_MPConnectLevel = 0;
    protected boolean m_MPHasOpponentFinished = false;
    protected String[] m_lNameList;
    protected String[] m_lBinaryDataList;
    protected byte[] m_lByteDataList;
    protected byte noitems = 0;
    protected int nosessionsbase = 0;
    protected String found_player_name;
    protected byte found_player_status;
    protected String found_player_session_name;
    protected byte found_player_session_number_of_players;
    protected String requested_player_data;
    protected String requested_player_nickname;
    protected byte m_type;
    protected byte m_subtype;
    protected byte[] m_data;
    protected Vector incomingGameData;
    protected String currentsessionname = null;
    protected String currentsessiondata = null;
    public boolean isGameMessageInQueue = false;

    public XPlayer(MIDlet mIDlet) {
        this.url = mIDlet.getAppProperty("XPlayerURL");
        GGI = mIDlet.getAppProperty("GGI");
        if (this.url == null || GGI == null) {
            if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                GLLib.Dbg("Please check that you have fields XPlayerURL, XPlayMPURL, GGI in .jad file");
            }
            return;
        }
        this.whttp = new HTTP();
        if (GLLibConfig.xplayer_CARRIER_USSPRINT || GLLibConfig.xplayer_CARRIER_MXTELCEL) {
            HTTP.clientId = mIDlet.getAppProperty("ClientId");
            if (HTTP.clientId != null && GLLibConfig.xplayer_ENABLE_DEBUG) {
                GLLib.Dbg("WARNING ClientId=" + HTTP.clientId + ", ERASE IN PRODUCTION jad");
            }
        }
        if (GLLibConfig.xplayer_CARRIER_USNEXTEL) {
            HTTP.upsubid = mIDlet.getAppProperty("UPSUBID");
            if (HTTP.upsubid != null && GLLibConfig.xplayer_ENABLE_DEBUG) {
                GLLib.Dbg("WARNING UPSUBID=" + HTTP.upsubid + ", ERASE IN PRODUCTION jad");
            }
        }
        if (GLLibConfig.xplayer_CARRIER_USVIRGIN) {
            HTTP.x_up_calling_line_id = mIDlet.getAppProperty("x-up-calling-line-id");
            if (HTTP.x_up_calling_line_id != null && GLLibConfig.xplayer_ENABLE_DEBUG) {
                GLLib.Dbg("WARNING x-up-calling-line-id=" + HTTP.x_up_calling_line_id + ", ERASE IN PRODUCTION jad");
            }
        }
        if (GLLibConfig.xplayer_CARRIER_USCINGULAR_BLUE || GLLibConfig.xplayer_CARRIER_USVIRGIN) {
            HTTP.x_up_subno = mIDlet.getAppProperty("x-up-subno");
            if (HTTP.x_up_subno != null && GLLibConfig.xplayer_ENABLE_DEBUG) {
                GLLib.Dbg("WARNING x-up-subno=" + HTTP.x_up_subno + ", ERASE IN PRODUCTION jad");
            }
        }
        if (GLLibConfig.xplayer_CARRIER_USCINGULAR_ORANGE) {
            HTTP.CarrierDeviceId = mIDlet.getAppProperty("CarrierDeviceId");
            if (HTTP.CarrierDeviceId != null && GLLibConfig.xplayer_ENABLE_DEBUG) {
                GLLib.Dbg("WARNING CarrierDeviceId=" + HTTP.CarrierDeviceId + ", ERASE IN PRODUCTION jad");
            }
        }
        if (GLLibConfig.xplayer_CARRIER_USSPRINT | GLLibConfig.xplayer_CARRIER_USCINGULAR_ORANGE | GLLibConfig.xplayer_CARRIER_USCINGULAR_BLUE | GLLibConfig.xplayer_CARRIER_USNEXTEL | GLLibConfig.xplayer_CARRIER_USVIRGIN) {
            this.phoneNumber = new String("");
        }
        if (GLLibConfig.xplayer_ENABLE_MULTIPLAYER) {
            this.url_tcp = mIDlet.getAppProperty("XPlayMPURL");
            if (this.url_tcp != null) {
                this.wtcp = new TCP(this.url_tcp);
                this.crtPosWrite = 0;
                this.crtPosRead = 0;
                this.msgData = new byte[255];
            } else {
                if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                    GLLib.Dbg("Please check that you have fields XPlayerURL, XPlayMPURL, GGI in .jad file");
                }
                return;
            }
        }
        this.username = new String("");
        this.newRankAfterScoreSending = -666666;
        this.is_logged_in = false;
        this.init();
    }

    protected void init() {
        this.clearLeaderboard();
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"UUID", (boolean)true);
            if (recordStore.getNumRecords() >= 1) {
                byte[] byArray = recordStore.getRecord(1);
                this.uid = new String(byArray);
            } else {
                this.uid = this.GenerateUID();
                byte[] byArray = this.uid.getBytes();
                if (recordStore.getNumRecords() >= 1) {
                    recordStore.setRecord(1, byArray, 0, byArray.length);
                } else {
                    recordStore.addRecord(byArray, 0, byArray.length);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String GenerateUID() {
        byte[] byArray = new byte[20];
        Random random = new Random();
        random.setSeed(System.currentTimeMillis());
        for (int i = 0; i < 20; ++i) {
            int n = random.nextInt() % 35;
            if (n < 0) {
                n = -n;
            }
            byArray[i] = (byte)n;
            if (byArray[i] < 10) {
                int n2 = i;
                byArray[n2] = (byte)(byArray[n2] + 48);
                continue;
            }
            int n3 = i;
            byArray[n3] = (byte)(byArray[n3] + 87);
        }
        String string = new String(byArray);
        if (GLLibConfig.useSystemGc) {
            System.gc();
        }
        return string + Integer.toString((int)System.currentTimeMillis() / 1000);
    }

    public boolean isLoggedIn() {
        return this.is_logged_in;
    }

    public void setUsername(String string) {
        this.username = new String(string);
    }

    public String getUsername() {
        return this.username;
    }

    public int getNewRankAfterScoreSending() {
        return this.newRankAfterScoreSending;
    }

    public int getLastError() {
        if (this.whttp.isInProgress()) {
            return -1;
        }
        if (this.whttp.m_bError) {
            return -2;
        }
        return this.lastErrorCode;
    }

    public void cancel() {
        if (GLLibConfig.xplayer_ENABLE_TIMEOUT) {
            callstarttime = 0L;
        }
        this.whttp.cancel();
    }

    public void cleanup() {
        if (GLLibConfig.xplayer_ENABLE_TIMEOUT) {
            callstarttime = 0L;
        }
        this.whttp.cleanup();
    }

    protected String String2Blob(String string) {
        byte[] byArray = string.getBytes();
        int n = 0;
        int n2 = 0;
        int n3 = 8;
        int n4 = string.length() * 8 / 6;
        n4 = string.length() * 8 % 6 != 0 ? (n4 += 2) : ++n4;
        byte[] byArray2 = new byte[n4];
        for (int i = 0; i < n4; ++i) {
            byArray2[i] = 0;
        }
        while (n2 < string.length()) {
            byte by = (byte)(byArray[n2] & 0x7F);
            by = (byte)(by >> 8 - n3);
            if (n3 < 6) {
                if (++n2 < string.length()) {
                    by = (byte)(by | byArray[n2] << n3);
                    n3 += 2;
                }
            } else if ((n3 -= 6) == 0) {
                n3 = 8;
                ++n2;
            }
            by = (byte)(by & 0x3F);
            byArray2[n] = this.SSEncDec_GetCharFromKeyByIndex(by);
            ++n;
        }
        String string2 = new String(byArray2, 0, n);
        return string2;
    }

    protected byte SSEncDec_GetCharFromKeyByIndex(byte by) {
        if (by < 26) {
            return (byte)(by + 97);
        }
        if (by < 52) {
            return (byte)(by + 39);
        }
        if (by < 62) {
            return (byte)(by - 4);
        }
        if (by == 62) {
            return 95;
        }
        return 45;
    }

    protected String getValue(String string, int n) {
        int n2 = 0;
        int n3 = n;
        int n4 = string.indexOf(124, n2 + 1);
        while (n > 0) {
            if (n2 == -1) {
                return null;
            }
            n2 = n4;
            n4 = string.indexOf(124, n2 + 1);
            --n;
        }
        if (n2 == -1) {
            return null;
        }
        if (n4 == -1) {
            n4 = string.length();
        }
        if (n3 > 0) {
            ++n2;
        }
        if (n2 == n4) {
            return "";
        }
        if (n2 > n4) {
            return null;
        }
        try {
            char[] cArray = new char[n4 - n2];
            string.getChars(n2, n4, cArray, 0);
            String string2 = new String(cArray);
            return string2;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void sendChangeUsername() {
        String string = "";
        string = GLLibConfig.xplayer_CARRIER_USSPRINT | GLLibConfig.xplayer_CARRIER_USCINGULAR_ORANGE | GLLibConfig.xplayer_CARRIER_USCINGULAR_BLUE | GLLibConfig.xplayer_CARRIER_USNEXTEL | GLLibConfig.xplayer_CARRIER_USVIRGIN ? "f|14|i|" + GGI + "|n|" + this.username + "|p|" + this.phoneNumber + "|u|" + this.uid + "|" : "f|14|i|" + GGI + "|n|" + this.username + "|u|" + this.uid + "|";
        String string2 = this.String2Blob(string);
        this.lastErrorCode = -100;
        if (GLLibConfig.xplayer_ENABLE_TIMEOUT) {
            callstarttime = System.currentTimeMillis();
        }
        this.whttp.sendByGet(this.url, string2);
    }

    public void sendLogin(String string) {
        String string2 = "";
        string2 = GLLibConfig.xplayer_CARRIER_USSPRINT | GLLibConfig.xplayer_CARRIER_USCINGULAR_ORANGE | GLLibConfig.xplayer_CARRIER_USCINGULAR_BLUE | GLLibConfig.xplayer_CARRIER_USNEXTEL | GLLibConfig.xplayer_CARRIER_USVIRGIN ? "f|11|i|" + GGI + "|n|" + this.username + "|p|" + this.phoneNumber + "|u|" + this.uid + "|" : "f|11|i|" + GGI + "|n|" + this.username + "|u|" + this.uid + "|";
        if (string != null) {
            string2 = string2 + "b|" + string + "|";
        }
        String string3 = this.String2Blob(string2);
        this.lastErrorCode = -100;
        if (GLLibConfig.xplayer_ENABLE_TIMEOUT) {
            callstarttime = System.currentTimeMillis();
        }
        this.whttp.sendByGet(this.url, string3);
    }

    public void handleLogin() {
        this.handleLoginChangeUsername(11);
    }

    public void handleChangeUsername() {
        this.handleLoginChangeUsername(14);
    }

    protected void handleLoginChangeUsername(int n) {
        if (n != 11 && n != 14) {
            return;
        }
        if (this.whttp.isInProgress()) {
            if (GLLibConfig.xplayer_ENABLE_TIMEOUT && System.currentTimeMillis() - callstarttime > (long)GLLibConfig.xplayer_CONN_TIMEOUT) {
                this.cancel();
                this.lastErrorCode = -2;
            }
            return;
        }
        if (this.whttp.m_bError) {
            return;
        }
        if (this.whttp.m_response != null) {
            String string = this.getValue(this.whttp.m_response, 0);
            if (string.compareTo("f") != 0) {
                return;
            }
            string = this.getValue(this.whttp.m_response, 1);
            if (string == null) {
                return;
            }
            if (Integer.parseInt(string) != n) {
                return;
            }
            string = this.getValue(this.whttp.m_response, 3);
            if (string == null) {
                return;
            }
            if (string.compareTo("e") == 0) {
                string = this.getValue(this.whttp.m_response, 4);
                this.lastErrorCode = Integer.parseInt(string);
                if (this.lastErrorCode == 3) {
                    string = this.getValue(this.whttp.m_response, 5);
                    if (string != null && string.compareTo("d") == 0 && (string = this.getValue(this.whttp.m_response, 6)).compareTo("5 M7 error, contact Online Team") == 0) {
                        this.lastErrorCode = -2;
                    }
                } else if (this.lastErrorCode == 5) {
                    this.username = this.getValue(this.whttp.m_response, 6);
                }
                return;
            }
            if (string.compareTo("s") == 0) {
                this.lastErrorCode = 0;
                this.username = this.getValue(this.whttp.m_response, 5);
                this.is_logged_in = true;
            }
        }
    }

    public void sendHighscore(int n, int n2, int n3) {
        String string;
        this.whttp.cancel();
        String string2 = "f|0|i|" + GGI + "|u|" + this.uid;
        if (n2 >= 0) {
            string2 = string2 + "|l|" + n2;
        }
        string2 = string2 + "|t|" + n3 + "|s|" + n + '|';
        string2 = string = this.String2Blob(string2);
        this.lastErrorCode = -100;
        this.newRankAfterScoreSending = -666666;
        if (GLLibConfig.xplayer_ENABLE_TIMEOUT) {
            callstarttime = System.currentTimeMillis();
        }
        this.whttp.sendByGet(this.url, string2);
    }

    public void sendHighscoreWithSupplementalData(int n, int n2, int n3, int[] nArray) {
        String string;
        this.whttp.cancel();
        String string2 = "f|0|i|" + GGI + "|u|" + this.uid;
        if (n2 < 0) {
            n2 = 0;
        }
        string2 = string2 + "|l|" + n2 + "|t|" + n3 + "|sl|0|s|" + n;
        for (int i = 0; i < nArray.length; ++i) {
            string2 = string2 + "|l|" + n2 + "|t|" + n3 + "|sl|" + (i + 1) + "|s|" + nArray[i];
        }
        string2 = string2 + "|";
        string2 = string = this.String2Blob(string2);
        this.lastErrorCode = -100;
        this.newRankAfterScoreSending = -666666;
        if (GLLibConfig.xplayer_ENABLE_TIMEOUT) {
            callstarttime = System.currentTimeMillis();
        }
        this.whttp.sendByGet(this.url, string2);
    }

    public void handleHighscore() {
        if (this.whttp.isInProgress()) {
            if (GLLibConfig.xplayer_ENABLE_TIMEOUT && System.currentTimeMillis() - callstarttime > (long)GLLibConfig.xplayer_CONN_TIMEOUT) {
                this.cancel();
                this.lastErrorCode = -2;
                return;
            }
            return;
        }
        if (this.whttp.m_bError) {
            return;
        }
        if (this.whttp.m_response != null) {
            String string = this.getValue(this.whttp.m_response, 0);
            if (string.compareTo("f") != 0) {
                return;
            }
            string = this.getValue(this.whttp.m_response, 1);
            if (Integer.parseInt(string) != 0) {
                return;
            }
            string = this.getValue(this.whttp.m_response, 3);
            if (string.compareTo("e") == 0) {
                string = this.getValue(this.whttp.m_response, 4);
                this.lastErrorCode = Integer.parseInt(string);
                return;
            }
            if (string.compareTo("s") == 0) {
                this.lastErrorCode = 0;
                int n = 4;
                if ((string = this.getValue(this.whttp.m_response, n++)).compareTo("l") == 0) {
                    int n2 = ++n;
                    ++n;
                    string = this.getValue(this.whttp.m_response, n2);
                }
                if (string.compareTo("r") == 0) {
                    string = this.getValue(this.whttp.m_response, n);
                    this.newRankAfterScoreSending = Integer.parseInt(string);
                }
            }
        }
    }

    public void initMultipleScores() {
        this.multipleScoresRequestBuffer = "f|0|i|" + GGI + "|u|" + this.uid;
    }

    public void addMultipleScoreEntry(int n, int n2, int n3) {
        if (this.multipleScoresRequestBuffer == null) {
            return;
        }
        this.multipleScoresRequestBuffer = this.multipleScoresRequestBuffer + "|l|" + n2 + "|t|" + n3 + "|s|" + n;
    }

    public void addMultipleScoreEntryWithSupplementalData(int n, int n2, int n3, int[] nArray) {
        if (this.multipleScoresRequestBuffer == null) {
            return;
        }
        this.multipleScoresRequestBuffer = this.multipleScoresRequestBuffer + "|l|" + n2 + "|t|" + n3 + "|sl|0|s|" + n;
        for (int i = 0; i < nArray.length; ++i) {
            this.multipleScoresRequestBuffer = this.multipleScoresRequestBuffer + "|l|" + n2 + "|t|" + n3 + "|sl|" + (i + 1) + "|s|" + nArray[i];
        }
    }

    public void sendMultipleHighscores() {
        if (this.multipleScoresRequestBuffer == null) {
            return;
        }
        this.whttp.cancel();
        this.multipleScoresRequestBuffer = this.multipleScoresRequestBuffer + "|";
        String string = this.String2Blob(this.multipleScoresRequestBuffer);
        this.lastErrorCode = -100;
        this.newRankAfterScoreSending = -666666;
        if (GLLibConfig.xplayer_ENABLE_TIMEOUT) {
            callstarttime = System.currentTimeMillis();
        }
        this.whttp.sendByGet(this.url, string);
    }

    public void sendRankGet(int n, int n2, int n3, int n4) {
        String string;
        this.whttp.cancel();
        String string2 = "f|12|i|" + GGI + "|u|" + this.uid + "|p|" + n2 + "|" + "t|" + n3 + "|";
        if (n >= 0) {
            string2 = string2 + "l|" + n + "|";
        }
        string2 = string = this.String2Blob(string2);
        this.clearLeaderboard();
        this.lastErrorCode = -100;
        if (GLLibConfig.xplayer_ENABLE_TIMEOUT) {
            callstarttime = System.currentTimeMillis();
        }
        this.leaderboardSupplementalDataFieldsNumber = n4;
        this.whttp.sendByGet(this.url, string2);
    }

    public void handleRankGet() {
        block10: {
            if (this.whttp.isInProgress()) {
                if (GLLibConfig.xplayer_ENABLE_TIMEOUT && System.currentTimeMillis() - callstarttime > (long)GLLibConfig.xplayer_CONN_TIMEOUT) {
                    this.cancel();
                    this.lastErrorCode = -2;
                }
                return;
            }
            if (this.whttp.m_bError) {
                return;
            }
            if (this.whttp.m_response != null) {
                String string = this.getValue(this.whttp.m_response, 0);
                if (string.compareTo("f") != 0) {
                    return;
                }
                string = this.getValue(this.whttp.m_response, 1);
                if (Integer.parseInt(string) != 12) {
                    return;
                }
                string = this.getValue(this.whttp.m_response, 3);
                if (string.compareTo("e") == 0) {
                    string = this.getValue(this.whttp.m_response, 4);
                    this.lastErrorCode = Integer.parseInt(string);
                    return;
                }
                if (string.compareTo("s") == 0) {
                    this.lastErrorCode = 0;
                    this.clearLeaderboard();
                    try {
                        this.processLeaderboardData(this.whttp.m_response);
                    }
                    catch (Exception exception) {
                        this.lastErrorCode = 40;
                        if (!GLLibConfig.xplayer_ENABLE_DEBUG) break block10;
                        GLLib.Dbg("Error processing leaderboard data: " + exception.getMessage());
                    }
                }
            }
        }
    }

    public void sendRankGetAroundPlayer(int n, int n2, int n3, int n4) {
        String string;
        this.whttp.cancel();
        String string2 = "f|13|i|" + GGI + "|u|" + this.uid + "|p|" + n2 + "|" + "t|" + n3 + "|";
        if (n >= 0) {
            string2 = string2 + "l|" + n + "|";
        }
        string2 = string = this.String2Blob(string2);
        this.clearLeaderboard();
        this.lastErrorCode = -100;
        if (GLLibConfig.xplayer_ENABLE_TIMEOUT) {
            callstarttime = System.currentTimeMillis();
        }
        this.leaderboardSupplementalDataFieldsNumber = n4;
        this.whttp.sendByGet(this.url, string2);
    }

    public void handleRankGetAroundPlayer() {
        block10: {
            if (this.whttp.isInProgress()) {
                if (GLLibConfig.xplayer_ENABLE_TIMEOUT && System.currentTimeMillis() - callstarttime > (long)GLLibConfig.xplayer_CONN_TIMEOUT) {
                    this.cancel();
                    this.lastErrorCode = -2;
                }
                return;
            }
            if (this.whttp.m_bError) {
                return;
            }
            if (this.whttp.m_response != null) {
                String string = this.getValue(this.whttp.m_response, 0);
                if (string.compareTo("f") != 0) {
                    return;
                }
                string = this.getValue(this.whttp.m_response, 1);
                if (Integer.parseInt(string) != 13) {
                    return;
                }
                string = this.getValue(this.whttp.m_response, 3);
                if (string.compareTo("e") == 0) {
                    string = this.getValue(this.whttp.m_response, 4);
                    this.lastErrorCode = Integer.parseInt(string);
                    return;
                }
                if (string.compareTo("s") == 0) {
                    this.lastErrorCode = 0;
                    this.clearLeaderboard();
                    try {
                        this.processRankingAroundPlayerData(this.whttp.m_response);
                    }
                    catch (Exception exception) {
                        this.lastErrorCode = 40;
                        if (!GLLibConfig.xplayer_ENABLE_DEBUG) break block10;
                        GLLib.Dbg("Error processing rank around player data: " + exception.getMessage());
                    }
                }
            }
        }
    }

    public int getCurrentPlayerLeaderboardPosition() {
        return this.currentPlayerLeaderboardPosition;
    }

    public int getCurrentPlayerLeaderboardScore() {
        return this.currentPlayerLeaderboardScore;
    }

    public int[] getCurrentPlayerLeaderboardScoreData() {
        return this.currentPlayerLeaderboardScoreData;
    }

    public boolean getLeaderboardData(String[] stringArray, int[] nArray, int[] nArray2, int[][] nArray3) {
        if (this.leaderboardSize <= 0 || this.leaderboardPlayerNames == null) {
            return false;
        }
        if (stringArray == null || stringArray.length < this.leaderboardSize || nArray == null || nArray.length < this.leaderboardSize || nArray2 == null || nArray2.length < this.leaderboardSize) {
            return false;
        }
        System.arraycopy(this.leaderboardPlayerNames, 0, stringArray, 0, this.leaderboardSize);
        System.arraycopy(this.leaderboardPlayerPositions, 0, nArray, 0, this.leaderboardSize);
        System.arraycopy(this.leaderboardPlayerScores, 0, nArray2, 0, this.leaderboardSize);
        if (this.leaderboardPlayerScoreDatas != null && this.leaderboardSupplementalDataFieldsNumber > 0) {
            if (nArray3 == null || nArray3.length < this.leaderboardSize || nArray3[0].length < this.leaderboardSupplementalDataFieldsNumber) {
                return false;
            }
            System.arraycopy(this.leaderboardPlayerScoreDatas, 0, nArray3, 0, this.leaderboardSize);
        }
        return true;
    }

    public int getLeaderboardSize() {
        if (this.leaderboardPlayerNames == null) {
            return -1;
        }
        return this.leaderboardSize;
    }

    public String getLeaderboardEntryPlayerName(int n) {
        if (n >= this.leaderboardSize || this.leaderboardPlayerNames == null) {
            return null;
        }
        return this.leaderboardPlayerNames[n];
    }

    public int getLeaderboardEntryPlayerPosition(int n) {
        if (n >= this.leaderboardSize || this.leaderboardPlayerPositions == null) {
            return -1;
        }
        return this.leaderboardPlayerPositions[n];
    }

    public int getLeaderboardEntryPlayerScore(int n) {
        if (n >= this.leaderboardSize || this.leaderboardPlayerScores == null) {
            return -666666;
        }
        return this.leaderboardPlayerScores[n];
    }

    public int[] getLeaderboardEntryPlayerScoreData(int n) {
        if (n >= this.leaderboardSize || this.leaderboardPlayerScoreDatas == null) {
            return null;
        }
        return this.leaderboardPlayerScoreDatas[n];
    }

    protected void processLeaderboardData(String string) {
        int n;
        int n2 = 4;
        String string2 = this.getValue(string, n2++);
        int n3 = 0;
        if (string2.compareTo("y") == 0) {
            string2 = this.getValue(string, n2++);
            this.currentPlayerLeaderboardPosition = Integer.parseInt(string2);
            if (this.currentPlayerLeaderboardPosition < 0) {
                this.currentPlayerLeaderboardPosition = -666666;
                this.currentPlayerLeaderboardPosition = -666666;
                this.currentPlayerLeaderboardScore = -666666;
                this.currentPlayerLeaderboardScoreData = null;
                n2 += 2 + this.leaderboardSupplementalDataFieldsNumber;
                n3 -= 3 + this.leaderboardSupplementalDataFieldsNumber;
            } else {
                int n4 = ++n2;
                ++n2;
                string2 = this.getValue(string, n4);
                this.currentPlayerLeaderboardScore = Integer.parseInt(string2);
                if (this.leaderboardSupplementalDataFieldsNumber > 0) {
                    this.currentPlayerLeaderboardScoreData = new int[this.leaderboardSupplementalDataFieldsNumber];
                }
                for (n = 0; n < this.leaderboardSupplementalDataFieldsNumber; ++n) {
                    string2 = this.getValue(string, n2++);
                    this.currentPlayerLeaderboardScoreData[n] = Integer.parseInt(string2);
                }
            }
        } else if (string2.compareTo("n") != 0) {
            return;
        }
        n = 0;
        n = string.indexOf(124, n + 1);
        while (n != -1) {
            ++n3;
            n = string.indexOf(124, n + 1);
        }
        n3 -= 4;
        if (this.currentPlayerLeaderboardPosition >= 0) {
            n3 -= 3 + this.leaderboardSupplementalDataFieldsNumber;
        }
        this.leaderboardSize = n3 / (3 + this.leaderboardSupplementalDataFieldsNumber);
        if (this.leaderboardSize <= 0) {
            return;
        }
        this.leaderboardPlayerNames = new String[this.leaderboardSize];
        this.leaderboardPlayerPositions = new int[this.leaderboardSize];
        this.leaderboardPlayerScores = new int[this.leaderboardSize];
        if (this.leaderboardSupplementalDataFieldsNumber > 0) {
            this.leaderboardPlayerScoreDatas = new int[this.leaderboardSize][this.leaderboardSupplementalDataFieldsNumber];
        }
        for (int i = 0; i < this.leaderboardSize; ++i) {
            string2 = this.getValue(string, n2++);
            this.leaderboardPlayerPositions[i] = Integer.parseInt(string2);
            string2 = this.getValue(string, n2++);
            this.leaderboardPlayerNames[i] = new String(string2);
            string2 = this.getValue(string, n2++);
            this.leaderboardPlayerScores[i] = Integer.parseInt(string2);
            for (int j = 0; j < this.leaderboardSupplementalDataFieldsNumber; ++j) {
                string2 = this.getValue(string, n2++);
                this.leaderboardPlayerScoreDatas[i][j] = Integer.parseInt(string2);
            }
        }
    }

    protected void processRankingAroundPlayerData(String string) {
        int n = 0;
        int n2 = 0;
        n = string.indexOf(124, n + 1);
        while (n != -1) {
            ++n2;
            n = string.indexOf(124, n + 1);
        }
        this.leaderboardSize = (n2 -= 3) / (3 + this.leaderboardSupplementalDataFieldsNumber);
        if (this.leaderboardSize <= 0) {
            return;
        }
        this.leaderboardPlayerNames = new String[this.leaderboardSize];
        this.leaderboardPlayerPositions = new int[this.leaderboardSize];
        this.leaderboardPlayerScores = new int[this.leaderboardSize];
        if (this.leaderboardSupplementalDataFieldsNumber > 0) {
            this.leaderboardPlayerScoreDatas = new int[this.leaderboardSize][this.leaderboardSupplementalDataFieldsNumber];
        }
        int n3 = 4;
        for (int i = 0; i < this.leaderboardSize; ++i) {
            String string2 = this.getValue(string, n3++);
            this.leaderboardPlayerPositions[i] = Integer.parseInt(string2);
            string2 = this.getValue(string, n3++);
            this.leaderboardPlayerNames[i] = new String(string2);
            string2 = this.getValue(string, n3++);
            this.leaderboardPlayerScores[i] = Integer.parseInt(string2);
            for (int j = 0; j < this.leaderboardSupplementalDataFieldsNumber; ++j) {
                string2 = this.getValue(string, n3++);
                this.leaderboardPlayerScoreDatas[i][j] = Integer.parseInt(string2);
            }
        }
    }

    protected void clearLeaderboard() {
        this.leaderboardPlayerNames = null;
        this.leaderboardPlayerPositions = null;
        this.leaderboardPlayerScores = null;
        this.leaderboardPlayerScoreDatas = null;
        this.currentPlayerLeaderboardPosition = -666666;
        this.currentPlayerLeaderboardScore = -666666;
        this.currentPlayerLeaderboardScoreData = null;
        this.leaderboardSize = -666666;
        if (GLLibConfig.useSystemGc) {
            System.gc();
        }
    }

    public void setPhoneNumber(String string) {
        this.phoneNumber = new String(string);
    }

    public void sendStatsGet(int n, int n2) {
        String string;
        this.whttp.cancel();
        if (!(GLLibConfig.xplayer_CARRIER_USSPRINT | GLLibConfig.xplayer_CARRIER_USCINGULAR_ORANGE | GLLibConfig.xplayer_CARRIER_USCINGULAR_BLUE | GLLibConfig.xplayer_CARRIER_USNEXTEL | GLLibConfig.xplayer_CARRIER_USVIRGIN)) {
            GLLib.Dbg("sendStatsGet is only supported for M7 Networks hosted games.");
            this.lastErrorCode = -3;
            return;
        }
        String string2 = "f|10|i|" + GGI + "|u|" + this.uid + "|l|" + n + "|";
        string2 = string = this.String2Blob(string2);
        this.lastErrorCode = 0;
        if (GLLibConfig.xplayer_ENABLE_TIMEOUT) {
            callstarttime = System.currentTimeMillis();
        }
        this.leaderboardSupplementalDataFieldsNumber = n2;
        this.whttp.sendByGet(this.url, string2);
    }

    public void handleStatsGet() {
        block15: {
            if (!(GLLibConfig.xplayer_CARRIER_USSPRINT | GLLibConfig.xplayer_CARRIER_USCINGULAR_ORANGE | GLLibConfig.xplayer_CARRIER_USCINGULAR_BLUE | GLLibConfig.xplayer_CARRIER_USNEXTEL | GLLibConfig.xplayer_CARRIER_USVIRGIN)) {
                GLLib.Dbg("sendStatsGet is only supported for M7 Networks hosted games.");
                this.lastErrorCode = -3;
                return;
            }
            if (this.whttp.isInProgress()) {
                if (GLLibConfig.xplayer_ENABLE_TIMEOUT && System.currentTimeMillis() - callstarttime > (long)GLLibConfig.xplayer_CONN_TIMEOUT) {
                    this.cancel();
                    this.lastErrorCode = -2;
                }
                return;
            }
            if (this.whttp.m_bError) {
                return;
            }
            if (this.whttp.m_response != null) {
                String string;
                int n = 0;
                if ((string = this.getValue(this.whttp.m_response, n++)).compareTo("f") != 0) {
                    return;
                }
                string = this.getValue(this.whttp.m_response, n++);
                try {
                    if (Integer.parseInt(string) != 10) {
                        return;
                    }
                    int n2 = ++n;
                    ++n;
                    string = this.getValue(this.whttp.m_response, n2);
                    if (string.compareTo("e") == 0) {
                        string = this.getValue(this.whttp.m_response, n++);
                        this.lastErrorCode = Integer.parseInt(string);
                        return;
                    }
                    if (string.compareTo("s") == 0) {
                        int n3;
                        this.lastErrorCode = 0;
                        string = this.getValue(this.whttp.m_response, n++);
                        this.bestRank = Integer.parseInt(string);
                        string = this.getValue(this.whttp.m_response, n++);
                        this.highScore = Integer.parseInt(string);
                        if (this.leaderboardSupplementalDataFieldsNumber > 0) {
                            this.highScoreData = new int[this.leaderboardSupplementalDataFieldsNumber];
                        }
                        for (n3 = 0; n3 < this.leaderboardSupplementalDataFieldsNumber; ++n3) {
                            string = this.getValue(this.whttp.m_response, n++);
                            this.highScoreData[n3] = Integer.parseInt(string);
                        }
                        string = this.getValue(this.whttp.m_response, n++);
                        this.lowScore = Integer.parseInt(string);
                        if (this.leaderboardSupplementalDataFieldsNumber > 0) {
                            this.lowScoreData = new int[this.leaderboardSupplementalDataFieldsNumber];
                        }
                        for (n3 = 0; n3 < this.leaderboardSupplementalDataFieldsNumber; ++n3) {
                            string = this.getValue(this.whttp.m_response, n++);
                            this.lowScoreData[n3] = Integer.parseInt(string);
                        }
                        string = this.getValue(this.whttp.m_response, n++);
                        this.avgScore = Integer.parseInt(string);
                        string = this.getValue(this.whttp.m_response, n++);
                        this.numberOfGamesPlayed = Integer.parseInt(string);
                        this.lastTimePlayed = this.getValue(this.whttp.m_response, n++);
                    }
                }
                catch (Exception exception) {
                    if (!GLLibConfig.xplayer_ENABLE_DEBUG) break block15;
                    GLLib.Dbg("EERRRR");
                }
            }
        }
    }

    public void getPlayerStats(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, String[] stringArray, int[] nArray6, int[] nArray7) {
        int n;
        nArray[0] = this.bestRank;
        nArray2[0] = this.highScore;
        for (n = 0; n < this.leaderboardSupplementalDataFieldsNumber; ++n) {
            nArray7[n] = this.highScoreData[n];
        }
        nArray3[0] = this.lowScore;
        for (n = 0; n < this.leaderboardSupplementalDataFieldsNumber; ++n) {
            nArray6[n] = this.lowScoreData[n];
        }
        nArray4[0] = this.avgScore;
        nArray5[0] = this.numberOfGamesPlayed;
        stringArray[0] = this.lastTimePlayed;
    }

    public int getMyBestRank() {
        return this.bestRank;
    }

    public int getMyHighScore() {
        return this.highScore;
    }

    public int getMyLowScore() {
        return this.lowScore;
    }

    public int[] getMyLowScoreData() {
        return this.lowScoreData;
    }

    public int[] getMyHighScoreData() {
        return this.highScoreData;
    }

    public int getMyAvgScore() {
        return this.avgScore;
    }

    public int getMyNumberOfGamesPlayed() {
        return this.numberOfGamesPlayed;
    }

    public String getMyLastTimePlayed() {
        return this.lastTimePlayed;
    }

    public void sendRateGame(int n) {
        String string;
        this.whttp.cancel();
        if (!(GLLibConfig.xplayer_CARRIER_USSPRINT | GLLibConfig.xplayer_CARRIER_USCINGULAR_ORANGE | GLLibConfig.xplayer_CARRIER_USCINGULAR_BLUE | GLLibConfig.xplayer_CARRIER_USNEXTEL | GLLibConfig.xplayer_CARRIER_USVIRGIN)) {
            GLLib.Dbg("sendStatsGet is only supported for M7 Networks hosted games.");
            this.lastErrorCode = -3;
            return;
        }
        String string2 = "f|8|i|" + GGI + "|u|" + this.uid + "|s|" + n + "|";
        string2 = string = this.String2Blob(string2);
        this.lastErrorCode = -100;
        if (GLLibConfig.xplayer_ENABLE_TIMEOUT) {
            callstarttime = System.currentTimeMillis();
        }
        this.whttp.sendByGet(this.url, string2);
    }

    public void handleRateGame() {
        if (!(GLLibConfig.xplayer_CARRIER_USSPRINT | GLLibConfig.xplayer_CARRIER_USCINGULAR_ORANGE | GLLibConfig.xplayer_CARRIER_USCINGULAR_BLUE | GLLibConfig.xplayer_CARRIER_USNEXTEL | GLLibConfig.xplayer_CARRIER_USVIRGIN)) {
            GLLib.Dbg("sendStatsGet is only supported for M7 Networks hosted games.");
            this.lastErrorCode = -3;
            return;
        }
        if (this.whttp.isInProgress()) {
            if (GLLibConfig.xplayer_ENABLE_TIMEOUT && System.currentTimeMillis() - callstarttime > (long)GLLibConfig.xplayer_CONN_TIMEOUT) {
                this.cancel();
                this.lastErrorCode = -2;
            }
            return;
        }
        if (this.whttp.m_bError) {
            return;
        }
        if (this.whttp.m_response != null) {
            String string = this.getValue(this.whttp.m_response, 0);
            if (string.compareTo("f") != 0) {
                return;
            }
            string = this.getValue(this.whttp.m_response, 1);
            if (Integer.parseInt(string) != 8) {
                return;
            }
            string = this.getValue(this.whttp.m_response, 3);
            if (string.compareTo("e") == 0) {
                string = this.getValue(this.whttp.m_response, 4);
                this.lastErrorCode = Integer.parseInt(string);
                return;
            }
            if (string.compareTo("s") == 0) {
                this.lastErrorCode = 0;
            }
        }
    }

    public void sendRecommendGame() {
        String string;
        this.whttp.cancel();
        if (!(GLLibConfig.xplayer_CARRIER_USSPRINT | GLLibConfig.xplayer_CARRIER_USCINGULAR_ORANGE | GLLibConfig.xplayer_CARRIER_USCINGULAR_BLUE | GLLibConfig.xplayer_CARRIER_USNEXTEL | GLLibConfig.xplayer_CARRIER_USVIRGIN)) {
            GLLib.Dbg("sendStatsGet is only supported for M7 Networks hosted games.");
            this.lastErrorCode = -3;
            return;
        }
        String string2 = "f|9|i|" + GGI + "|u|" + this.uid + "|";
        string2 = string = this.String2Blob(string2);
        this.lastErrorCode = -100;
        if (GLLibConfig.xplayer_ENABLE_TIMEOUT) {
            callstarttime = System.currentTimeMillis();
        }
        this.whttp.sendByGet(this.url, string2);
    }

    public void handleRecommendGame() {
        if (!(GLLibConfig.xplayer_CARRIER_USSPRINT | GLLibConfig.xplayer_CARRIER_USCINGULAR_ORANGE | GLLibConfig.xplayer_CARRIER_USCINGULAR_BLUE | GLLibConfig.xplayer_CARRIER_USNEXTEL | GLLibConfig.xplayer_CARRIER_USVIRGIN)) {
            GLLib.Dbg("sendStatsGet is only supported for M7 Networks hosted games.");
            this.lastErrorCode = -3;
            return;
        }
        if (this.whttp.isInProgress()) {
            if (GLLibConfig.xplayer_ENABLE_TIMEOUT && System.currentTimeMillis() - callstarttime > (long)GLLibConfig.xplayer_CONN_TIMEOUT) {
                this.cancel();
                this.lastErrorCode = -2;
            }
            return;
        }
        if (this.whttp.m_bError) {
            return;
        }
        if (this.whttp.m_response != null) {
            String string = this.getValue(this.whttp.m_response, 1);
            if (Integer.parseInt(string) != 9) {
                return;
            }
            string = this.getValue(this.whttp.m_response, 3);
            if (string.compareTo("e") == 0) {
                string = this.getValue(this.whttp.m_response, 4);
                this.lastErrorCode = Integer.parseInt(string);
                return;
            }
            if (string.compareTo("s") == 0) {
                this.lastErrorCode = 0;
            }
        }
    }

    public void setData(byte[] byArray) {
        System.arraycopy(byArray, 0, this.msgData, 0, byArray.length);
        this.crtPosWrite = byArray.length;
        this.crtPosRead = 0;
    }

    public byte[] getData() {
        byte[] byArray = new byte[this.crtPosWrite];
        System.arraycopy(this.msgData, 0, byArray, 0, this.crtPosWrite);
        this.crtPosWrite = 0;
        this.crtPosRead = 0;
        return byArray;
    }

    public void clearData() {
        this.m_type = 0;
        this.m_subtype = 0;
        this.crtPosWrite = 0;
        this.crtPosRead = 0;
    }

    public int getLength() {
        return this.crtPosWrite;
    }

    public void addByte(byte by) throws Exception {
        if (this.msgData == null || this.crtPosWrite >= this.msgData.length) {
            throw new Exception("Xplayer.addByte.Error adding byte to current data");
        }
        this.msgData[this.crtPosWrite++] = by;
    }

    public byte getByte() throws Exception {
        if (this.msgData != null && this.crtPosRead < this.crtPosWrite) {
            return this.msgData[this.crtPosRead++];
        }
        throw new Exception("Xplayer.getByte.Error retrieving byte from current data");
    }

    public void addShort(short s) throws Exception {
        if (this.msgData == null || this.crtPosWrite >= this.msgData.length - 1) {
            throw new Exception("Xplayer.addShort.Error add short to current data");
        }
        this.msgData[this.crtPosWrite++] = (byte)((s & 0xFF00) >> 8);
        this.msgData[this.crtPosWrite++] = (byte)(s & 0xFF);
    }

    public short getShort() throws Exception {
        if (this.msgData != null && this.crtPosRead < this.crtPosWrite - 1) {
            short s = (short)(this.msgData[this.crtPosRead] << 8 & 0xFF00 | this.msgData[this.crtPosRead + 1] & 0xFF);
            this.crtPosRead += 2;
            return s;
        }
        throw new Exception("Xplayer.getShort.Error retrieve short from current data");
    }

    public void addInt(int n) throws Exception {
        if (this.msgData == null || this.crtPosWrite >= this.msgData.length - 3) {
            throw new Exception("Xplayer.addInt.Error add int to current data");
        }
        this.msgData[this.crtPosWrite++] = (byte)(n >>> 24);
        this.msgData[this.crtPosWrite++] = (byte)(n >>> 16);
        this.msgData[this.crtPosWrite++] = (byte)(n >>> 8);
        this.msgData[this.crtPosWrite++] = (byte)(n >>> 0);
    }

    public int getInt() throws Exception {
        if (this.msgData != null && this.crtPosRead < this.crtPosWrite - 3) {
            int n = 0;
            n |= this.msgData[this.crtPosRead] << 24 & 0xFF000000;
            n |= this.msgData[this.crtPosRead + 1] << 16 & 0xFF0000;
            n |= this.msgData[this.crtPosRead + 2] << 8 & 0xFF00;
            this.crtPosRead += 4;
            return n |= this.msgData[this.crtPosRead + 3] << 0 & 0xFF;
        }
        throw new Exception("Xplayer.getInt.Error retrieve int from current data");
    }

    public void addByteArray(byte by, int n, byte[] byArray) throws Exception {
        if (this.msgData != null && this.crtPosWrite < this.msgData.length - by) {
            this.msgData[this.crtPosWrite++] = by;
            System.arraycopy(byArray, n, this.msgData, this.crtPosWrite, by);
            this.crtPosWrite += by;
        } else {
            throw new Exception("Xplayer.addByteArray.Error adding byte array to current data");
        }
    }

    public byte[] getByteArray() throws Exception {
        byte by = 0;
        if (this.msgData == null || this.crtPosRead >= this.crtPosWrite) {
            throw new Exception("Xplayer.getByteArray.Error getting byte array size from current data");
        }
        by = this.msgData[this.crtPosRead++];
        if (this.crtPosRead < this.crtPosWrite - by + 1) {
            byte[] byArray = new byte[by];
            System.arraycopy(this.msgData, this.crtPosRead, byArray, 0, by);
            this.crtPosRead += by;
            return byArray;
        }
        throw new Exception("Xplayer.getByteArray.Error adding byte array to current data");
    }

    public byte[] getByteArray(int n, byte[] byArray) throws Exception {
        byte by = 0;
        if (this.msgData == null || this.crtPosRead >= this.crtPosWrite) {
            throw new Exception("Error getting byte array size from current data");
        }
        by = this.msgData[this.crtPosRead++];
        if (this.crtPosRead < this.crtPosWrite - by + 1) {
            System.arraycopy(this.msgData, this.crtPosRead, byArray, n, by);
            this.crtPosRead += by;
            return byArray;
        }
        throw new Exception("Error adding byte array to current data");
    }

    public void addString(String string) throws Exception {
        byte[] byArray = string.getBytes();
        if (byArray.length > 255) {
            throw new Exception("Error adding string to current data");
        }
        this.addByteArray((byte)byArray.length, 0, byArray);
    }

    public String getString() throws Exception {
        return new String(this.getByteArray());
    }

    public final boolean mpIsConnected() {
        return this.m_MPConnectLevel >= 1;
    }

    public final boolean mpIsLoggedIn() {
        return this.m_MPConnectLevel >= 2;
    }

    public final boolean mpIsInSession() {
        return this.m_MPConnectLevel >= 3;
    }

    public final boolean mpIsInGame() {
        return this.m_MPConnectLevel >= 5;
    }

    public final boolean mpIsMaster() {
        return this.m_MPConnectLevel == 4 || this.m_MPConnectLevel == 6;
    }

    protected boolean mpProcessIncomingMessages() {
        if (System.currentTimeMillis() - callstarttime > (long)GLLibConfig.xplayer_KEEP_ALIVE_TIME) {
            this.mpSendKeepAlive();
        }
        if (!this.wtcp.m_connected) {
            this.m_MPConnectLevel = 0;
            if (this.wtcp.m_bError) {
                this.lastErrorCode = -2;
                if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                    GLLib.Dbg("XPLAYER: TCP says " + this.wtcp.m_bErrorString);
                }
            }
            return true;
        }
        this.m_data = this.wtcp.recvPacket();
        if (this.m_data == null) {
            if (!this.wtcp.m_connected) {
                this.m_MPConnectLevel = 0;
                if (this.wtcp.m_bError) {
                    this.lastErrorCode = -2;
                    if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                        GLLib.Dbg("XPLAYER: TCP says " + this.wtcp.m_bErrorString);
                    }
                }
            }
            return false;
        }
        this.setData(this.m_data);
        try {
            this.m_type = this.getByte();
            this.m_subtype = 0;
            switch (this.m_type) {
                case 115: {
                    this.m_subtype = this.getByte();
                    switch (this.m_subtype) {
                        case 101: 
                        case 115: 
                        case 120: {
                            return true;
                        }
                    }
                    throw new Exception("Unknown message type");
                }
                case 103: {
                    this.m_subtype = this.getByte();
                    switch (this.m_subtype) {
                        case 114: {
                            return true;
                        }
                        case 112: {
                            this.mpProcessPushMessages();
                            return false;
                        }
                        case 103: 
                        case 104: {
                            this.incomingGameData.addElement(this.m_data);
                            return false;
                        }
                        case 97: {
                            return false;
                        }
                    }
                    throw new Exception("Unknown message type");
                }
            }
            throw new Exception("Unknown message type");
        }
        catch (Exception exception) {
            if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                GLLib.Dbg("Error: " + exception.getMessage());
            }
            return false;
        }
    }

    protected void mpProcessPushMessages() throws Exception {
        if (!this.mpIsInSession()) {
            if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                GLLib.Dbg("Push message outside session !");
            }
            return;
        }
        int n = 0;
        byte by = this.getByte();
        switch (by) {
            case 107: {
                this.m_MPConnectLevel = (byte)2;
                break;
            }
            case 108: {
                int n2;
                String string = this.getString();
                for (n2 = 0; n2 < this.m_lNameList.length && !string.toLowerCase().equals(this.m_lNameList[n2].toLowerCase()); ++n2) {
                }
                if (n2 == this.m_lNameList.length) {
                    return;
                }
                String[] stringArray = new String[this.m_lNameList.length - 1];
                byte[] byArray = new byte[this.m_lNameList.length - 1];
                int n3 = 0;
                int n4 = 0;
                while (n3 < this.m_lNameList.length) {
                    if (n3 == n2) {
                        ++n3;
                        continue;
                    }
                    stringArray[n4] = this.m_lNameList[n3];
                    byArray[n4] = this.m_lByteDataList[n3];
                    ++n3;
                    ++n4;
                }
                this.m_lNameList = stringArray;
                this.m_lByteDataList = byArray;
                this.noitems = (byte)this.m_lNameList.length;
                break;
            }
            case 106: {
                byte by2 = this.getByte();
                String string = this.getString();
                n = this.m_lNameList != null ? this.m_lNameList.length + 1 : 1;
                String[] stringArray = new String[n];
                byte[] byArray = new byte[n];
                for (int i = 0; i < n - 1; ++i) {
                    stringArray[i] = this.m_lNameList[i];
                    byArray[i] = this.m_lByteDataList[i];
                }
                stringArray[i] = string;
                byArray[i] = by2;
                this.m_lNameList = stringArray;
                this.m_lByteDataList = byArray;
                this.noitems = (byte)this.m_lNameList.length;
                break;
            }
            case 115: {
                if (this.m_MPConnectLevel == 4) break;
                int n5 = this.getByte();
                this.m_lNameList = new String[n5];
                this.m_lByteDataList = new byte[n5];
                for (int i = 0; i < n5; ++i) {
                    this.m_lNameList[i] = this.getString();
                    this.m_lByteDataList[i] = (byte)(i + 1);
                }
                this.noitems = (byte)this.m_lNameList.length;
                if (this.m_MPConnectLevel == 3) {
                    this.m_MPConnectLevel = (byte)5;
                    this.m_MPHasOpponentFinished = false;
                } else {
                    this.lastErrorCode = 51;
                }
                this.incomingGameData = new Vector();
                break;
            }
            case 102: {
                this.m_MPHasOpponentFinished = true;
            }
        }
    }

    protected void mpPrepareGameRequest(byte by) throws Exception {
        this.clearData();
        this.addByte((byte)103);
        this.addByte((byte)114);
        this.addByte(by);
    }

    public void mpPrepareGameData() throws Exception {
        if (!this.mpIsInGame()) {
            this.lastErrorCode = 50;
            return;
        }
        this.lastErrorCode = -1;
        this.clearData();
        this.addByte((byte)103);
        this.addByte((byte)103);
    }

    public void mpSendGameData() {
        if (!this.mpIsInGame() || this.lastErrorCode != -1) {
            this.lastErrorCode = 50;
            return;
        }
        this.lastErrorCode = 0;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleGameData() throws Exception {
        this.isGameMessageInQueue = false;
        if (!this.mpIsInGame()) {
            this.lastErrorCode = 50;
            return;
        }
        if (this.mpProcessIncomingMessages()) {
            return;
        }
        if (this.incomingGameData.size() > 0) {
            this.m_data = (byte[])this.incomingGameData.firstElement();
            this.incomingGameData.removeElementAt(0);
            this.isGameMessageInQueue = true;
        } else {
            this.m_data = null;
        }
    }

    public void mpSendDisconnect() {
        if (GLLibConfig.xplayer_ENABLE_DEBUG) {
            GLLib.Dbg("XPLAYER: send disconnect");
        }
        this.clearData();
        try {
            this.addByte((byte)115);
            this.addByte((byte)120);
        }
        catch (Exception exception) {
            GLLib.Dbg(exception.getMessage());
            return;
        }
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleDisconnect() {
        if (!this.mpProcessIncomingMessages()) {
            return;
        }
        if (GLLibConfig.xplayer_ENABLE_DEBUG) {
            GLLib.Dbg("XPLAYER: receive disconnect");
        }
        if (this.m_type == 115 && this.m_subtype == 120) {
            this.mpDisconnect();
        }
        this.lastErrorCode = 0;
    }

    public void mpDisconnect() {
        this.wtcp.disconnect();
        this.m_MPConnectLevel = 0;
    }

    public void mpHandleUpdates() {
        this.mpProcessIncomingMessages();
    }

    public void mpSendEstablishConnection() {
        if (GLLibConfig.xplayer_ENABLE_DEBUG) {
            GLLib.Dbg("XPLAYER: Establish connection");
        }
        if (this.mpIsConnected()) {
            this.lastErrorCode = 50;
            return;
        }
        int n = new Random().nextInt();
        this.wtcp.connect();
        this.clearData();
        try {
            this.addByte((byte)115);
            this.addByte((byte)114);
            this.addInt(n);
        }
        catch (Exception exception) {
            GLLib.Dbg(exception.getMessage());
            return;
        }
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        this.clearData();
        try {
            this.addByte((byte)115);
            this.addByte((byte)119);
            this.addInt(n);
        }
        catch (Exception exception) {
            GLLib.Dbg(exception.getMessage());
            return;
        }
        this.wtcp.sendEstablishConnectionPackageOnReceive(this.getData());
    }

    public void mpHandleEstablishConnection() {
        if (this.mpIsConnected()) {
            this.lastErrorCode = 50;
            return;
        }
        if (!this.mpProcessIncomingMessages()) {
            return;
        }
        if (this.m_type == 115) {
            switch (this.m_subtype) {
                case 115: {
                    this.m_MPConnectLevel = 1;
                    this.lastErrorCode = 0;
                    break;
                }
                case 101: {
                    this.m_MPConnectLevel = 0;
                    this.lastErrorCode = -2;
                    if (!GLLibConfig.xplayer_ENABLE_DEBUG) break;
                    GLLib.Dbg("XPLAYER: TCP says " + this.wtcp.m_bErrorString);
                }
            }
        }
    }

    public void mpSendLogin() {
        if (GLLibConfig.xplayer_ENABLE_DEBUG) {
            GLLib.Dbg("XPLAYER: Logging in");
        }
        if (!this.mpIsConnected() || this.mpIsLoggedIn()) {
            this.lastErrorCode = 50;
            return;
        }
        try {
            this.mpPrepareGameRequest((byte)105);
            this.addString("" + GGI + "-" + this.uid);
        }
        catch (Exception exception) {
            if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                GLLib.Dbg("Error: " + exception.getMessage());
            }
            return;
        }
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpSendLogin(String string) {
        if (GLLibConfig.xplayer_ENABLE_DEBUG) {
            GLLib.Dbg("XPLAYER: Logging in");
        }
        if (!this.mpIsConnected() || this.mpIsLoggedIn()) {
            this.lastErrorCode = 50;
            return;
        }
        try {
            this.mpPrepareGameRequest((byte)105);
            this.addString("" + GGI + "-" + this.uid);
            this.addString(string);
        }
        catch (Exception exception) {
            if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                GLLib.Dbg("Error: " + exception.getMessage());
            }
            return;
        }
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleLogin() {
        block9: {
            if (!this.mpIsConnected() || this.mpIsLoggedIn()) {
                this.lastErrorCode = 50;
                return;
            }
            if (!this.mpProcessIncomingMessages()) {
                return;
            }
            if (this.m_type != 103 || this.m_subtype != 114) {
                return;
            }
            try {
                byte by = this.getByte();
                if (by != 105) {
                    if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                        GLLib.Dbg("Bad response LOGIN" + new String(this.m_data));
                    }
                    this.lastErrorCode = 51;
                    return;
                }
                by = this.getByte();
                if (by == 115) {
                    this.m_MPConnectLevel = (byte)2;
                    this.lastErrorCode = 0;
                } else {
                    this.lastErrorCode = 3;
                }
            }
            catch (Exception exception) {
                this.lastErrorCode = 40;
                if (!GLLibConfig.xplayer_ENABLE_DEBUG) break block9;
                GLLib.Dbg("Error: " + exception.getMessage());
            }
        }
    }

    public void mpSendQuickGame() {
        if (GLLibConfig.xplayer_ENABLE_DEBUG) {
            GLLib.Dbg("XPLAYER: Quick game");
        }
        if (!this.mpIsLoggedIn()) {
            this.lastErrorCode = 50;
            return;
        }
        try {
            this.mpPrepareGameRequest((byte)117);
        }
        catch (Exception exception) {
            if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                GLLib.Dbg("Error: " + exception.getMessage());
            }
            return;
        }
        this.m_lBinaryDataList = null;
        this.m_lNameList = null;
        this.noitems = 0;
        this.nosessionsbase = 0;
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpSendListSession(byte by, byte by2) {
        if (GLLibConfig.xplayer_ENABLE_DEBUG) {
            GLLib.Dbg("XPLAYER: List session");
        }
        if (!this.mpIsLoggedIn()) {
            this.lastErrorCode = 50;
            return;
        }
        try {
            this.noitems = by;
            this.nosessionsbase = by2;
            if (this.noitems <= 0) {
                this.noitems = 1;
            }
            if (this.nosessionsbase < 0) {
                this.nosessionsbase = 0;
            }
            this.mpPrepareGameRequest((byte)108);
            this.addByte(this.noitems);
            this.addInt(this.nosessionsbase);
        }
        catch (Exception exception) {
            this.lastErrorCode = 40;
            if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                System.out.println("Error: " + exception.getMessage());
            }
            return;
        }
        this.m_lBinaryDataList = null;
        this.m_lNameList = null;
        this.noitems = 0;
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleListSession() {
        block12: {
            if (!this.mpProcessIncomingMessages()) {
                return;
            }
            if (!this.mpIsLoggedIn()) {
                this.lastErrorCode = 50;
                return;
            }
            if (this.m_type != 103 || this.m_subtype != 114) {
                return;
            }
            try {
                byte by = this.getByte();
                if (by != 117 && by != 108) {
                    if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                        GLLib.Dbg("Bad response LIST" + new String(this.m_data));
                    }
                    this.lastErrorCode = 51;
                    return;
                }
                by = this.getByte();
                if (by == 115) {
                    this.noitems = this.getByte();
                    this.nosessionsbase = this.getInt();
                    if (this.noitems > 0) {
                        int n;
                        this.m_lNameList = new String[this.noitems];
                        this.m_lByteDataList = new byte[this.noitems];
                        this.m_lBinaryDataList = new String[this.noitems];
                        for (n = 0; n < this.noitems; ++n) {
                            this.m_lNameList[n] = this.getString();
                            this.m_lByteDataList[n] = this.getByte();
                        }
                        for (n = 0; n < this.noitems; ++n) {
                            this.m_lBinaryDataList[n] = this.getString();
                        }
                    }
                    this.lastErrorCode = 0;
                } else {
                    this.lastErrorCode = 3;
                }
            }
            catch (Exception exception) {
                this.lastErrorCode = 40;
                if (!GLLibConfig.xplayer_ENABLE_DEBUG) break block12;
                GLLib.Dbg("Error: " + exception.getMessage());
            }
        }
    }

    public void mpSendCreateSession(String string, String string2) {
        if (!this.mpIsLoggedIn() || this.mpIsInSession()) {
            this.lastErrorCode = 50;
            return;
        }
        try {
            this.mpPrepareGameRequest((byte)99);
            this.addString(string);
            if (string2 != null) {
                this.addString(string2);
            }
        }
        catch (Exception exception) {
            if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                System.out.println("Error: " + exception.getMessage());
            }
            return;
        }
        this.currentsessionname = string;
        this.currentsessiondata = string2;
        this.m_lBinaryDataList = null;
        this.m_lNameList = null;
        this.noitems = 0;
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleCreateSession() {
        block10: {
            if (!this.mpProcessIncomingMessages()) {
                return;
            }
            if (!this.mpIsLoggedIn() || this.mpIsInSession()) {
                this.lastErrorCode = 50;
                return;
            }
            if (this.m_type != 103 || this.m_subtype != 114) {
                return;
            }
            try {
                byte by = this.getByte();
                if (by != 99) {
                    if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                        GLLib.Dbg("Bad response CREATE" + new String(this.m_data));
                    }
                    this.lastErrorCode = 51;
                    return;
                }
                by = this.getByte();
                if (by == 115) {
                    this.m_MPConnectLevel = (byte)4;
                    this.noitems = 1;
                    this.m_lNameList = new String[this.noitems];
                    this.m_lByteDataList = new byte[this.noitems];
                    for (int i = 0; i < this.noitems; ++i) {
                        this.m_lNameList[i] = this.username;
                        this.m_lByteDataList[i] = 1;
                    }
                    this.lastErrorCode = 0;
                } else {
                    this.lastErrorCode = 54;
                }
            }
            catch (Exception exception) {
                this.lastErrorCode = 40;
                if (!GLLibConfig.xplayer_ENABLE_DEBUG) break block10;
                GLLib.Dbg("Error: " + exception.getMessage());
            }
        }
    }

    public void mpSendJoinSession(String string) {
        if (!this.mpIsLoggedIn() || this.mpIsInSession()) {
            this.lastErrorCode = 50;
            return;
        }
        try {
            this.mpPrepareGameRequest((byte)106);
            this.addString(string);
        }
        catch (Exception exception) {
            if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                GLLib.Dbg("Error: " + exception.getMessage());
            }
            return;
        }
        this.currentsessionname = string;
        this.m_lBinaryDataList = null;
        this.m_lNameList = null;
        this.noitems = 0;
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleJoinSession() {
        block11: {
            if (!this.mpIsLoggedIn() || this.mpIsInSession()) {
                this.lastErrorCode = 50;
                return;
            }
            if (!this.mpProcessIncomingMessages()) {
                return;
            }
            if (this.m_type != 103 || this.m_subtype != 114) {
                return;
            }
            try {
                byte by = this.getByte();
                if (by != 106) {
                    if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                        GLLib.Dbg("Bad response JOIN" + new String(this.m_data));
                    }
                    this.lastErrorCode = 51;
                    return;
                }
                by = this.getByte();
                if (by == 115) {
                    this.m_MPConnectLevel = (byte)3;
                    this.lastErrorCode = 0;
                    this.noitems = this.getByte();
                    this.m_lNameList = new String[this.noitems];
                    this.m_lByteDataList = new byte[this.noitems];
                    for (int i = 0; i < this.noitems; ++i) {
                        this.m_lNameList[i] = this.getString();
                        this.m_lByteDataList[i] = (byte)(i + 1);
                    }
                    this.currentsessiondata = this.getString();
                    if (this.currentsessiondata.length() == 0) {
                        this.currentsessiondata = null;
                    }
                } else {
                    this.lastErrorCode = 54;
                }
            }
            catch (Exception exception) {
                this.lastErrorCode = 40;
                if (!GLLibConfig.xplayer_ENABLE_DEBUG) break block11;
                GLLib.Dbg("Error: " + exception.getMessage());
            }
        }
    }

    public void mpSendLeaveSession() {
        if (!this.mpIsInSession()) {
            this.lastErrorCode = 50;
            return;
        }
        try {
            this.mpPrepareGameRequest((byte)113);
        }
        catch (Exception exception) {
            if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                GLLib.Dbg("Error: " + exception.getMessage());
            }
            return;
        }
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleLeaveSession() {
        block9: {
            if (!this.mpIsInSession()) {
                this.lastErrorCode = 50;
                return;
            }
            if (!this.mpProcessIncomingMessages()) {
                return;
            }
            if (this.m_type != 103 || this.m_subtype != 114) {
                return;
            }
            try {
                byte by = this.getByte();
                if (by != 113) {
                    if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                        GLLib.Dbg("Bad response LEAVE" + new String(this.m_data));
                    }
                    this.lastErrorCode = 51;
                    return;
                }
                by = this.getByte();
                if (by == 115) {
                    this.m_MPConnectLevel = (byte)2;
                    this.lastErrorCode = 0;
                } else {
                    this.lastErrorCode = 3;
                }
            }
            catch (Exception exception) {
                this.lastErrorCode = 40;
                if (!GLLibConfig.xplayer_ENABLE_DEBUG) break block9;
                GLLib.Dbg("Error: " + exception.getMessage());
            }
        }
    }

    public void mpSendKickOutPlayer(String string) {
        if (!this.mpIsInSession()) {
            this.lastErrorCode = 50;
            return;
        }
        try {
            this.mpPrepareGameRequest((byte)107);
            this.addString(string);
        }
        catch (Exception exception) {
            if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                GLLib.Dbg("Error: " + exception.getMessage());
            }
            return;
        }
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleKickOutPlayer(String string) {
        block13: {
            if (!this.mpIsInSession()) {
                this.lastErrorCode = 50;
                return;
            }
            if (!this.mpProcessIncomingMessages()) {
                return;
            }
            if (this.m_type != 103 || this.m_subtype != 114) {
                return;
            }
            try {
                byte by = this.getByte();
                if (by != 107) {
                    if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                        GLLib.Dbg("Bad response KICK OUT" + new String(this.m_data));
                    }
                    this.lastErrorCode = 51;
                    return;
                }
                by = this.getByte();
                if (by == 115) {
                    int n;
                    boolean bl = false;
                    for (n = 0; n < this.m_lNameList.length && !string.toLowerCase().equals(this.m_lNameList[n].toLowerCase()); ++n) {
                    }
                    if (n == this.m_lNameList.length) {
                        this.lastErrorCode = 0;
                        return;
                    }
                    String[] stringArray = new String[this.m_lNameList.length - 1];
                    byte[] byArray = new byte[this.m_lNameList.length - 1];
                    int n2 = 0;
                    int n3 = 0;
                    while (n2 < this.m_lNameList.length) {
                        if (n2 == n) {
                            ++n2;
                            continue;
                        }
                        stringArray[n3] = this.m_lNameList[n2];
                        byArray[n3] = this.m_lByteDataList[n2];
                        ++n2;
                        ++n3;
                    }
                    this.m_lNameList = stringArray;
                    this.m_lByteDataList = byArray;
                    this.noitems = (byte)this.m_lNameList.length;
                    this.lastErrorCode = 0;
                } else {
                    this.lastErrorCode = 3;
                }
            }
            catch (Exception exception) {
                this.lastErrorCode = 40;
                if (!GLLibConfig.xplayer_ENABLE_DEBUG) break block13;
                GLLib.Dbg("Error: " + exception.getMessage());
            }
        }
    }

    public void mpSendStartGame() {
        if (!this.mpIsInSession()) {
            this.lastErrorCode = 50;
            return;
        }
        try {
            this.mpPrepareGameRequest((byte)115);
        }
        catch (Exception exception) {
            if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                GLLib.Dbg("Error: " + exception.getMessage());
            }
            return;
        }
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleStartGame() {
        block21: {
            byte by;
            if (this.mpIsInGame()) {
                if (!this.mpProcessIncomingMessages()) {
                    return;
                }
                if (this.m_type != 103 || this.m_subtype != 114) {
                    return;
                }
                try {
                    by = this.getByte();
                    if (by != 115) {
                        if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                            GLLib.Dbg("Bad response START while in game" + new String(this.m_data));
                        }
                        this.lastErrorCode = 51;
                        return;
                    }
                }
                catch (Exception exception) {
                    if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                        GLLib.Dbg("Error: " + exception.getMessage());
                    }
                    return;
                }
                this.lastErrorCode = 0;
                this.incomingGameData = new Vector();
            }
            if (!this.mpIsInSession()) {
                this.lastErrorCode = 50;
                return;
            }
            if (!this.mpProcessIncomingMessages()) {
                return;
            }
            if (this.m_type != 103 || this.m_subtype != 114) {
                return;
            }
            try {
                by = this.getByte();
                if (by != 115) {
                    if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                        GLLib.Dbg("Bad response START" + new String(this.m_data));
                    }
                    this.lastErrorCode = 51;
                    return;
                }
                by = this.getByte();
                if (by == 115) {
                    if (this.m_MPConnectLevel == 3) {
                        this.m_MPConnectLevel = (byte)5;
                    } else if (this.m_MPConnectLevel == 4) {
                        this.m_MPConnectLevel = (byte)6;
                    }
                    this.m_MPHasOpponentFinished = false;
                    this.noitems = this.getByte();
                    this.m_lNameList = new String[this.noitems];
                    this.m_lByteDataList = new byte[this.noitems];
                    for (int i = 0; i < this.noitems; ++i) {
                        this.m_lNameList[i] = this.getString();
                        this.m_lByteDataList[i] = (byte)(i + 1);
                    }
                    this.incomingGameData = new Vector();
                    this.lastErrorCode = 0;
                } else {
                    this.lastErrorCode = 54;
                }
            }
            catch (Exception exception) {
                this.lastErrorCode = 40;
                if (!GLLibConfig.xplayer_ENABLE_DEBUG) break block21;
                GLLib.Dbg("Error: " + exception.getMessage());
            }
        }
    }

    public void mpSendFinishGame() {
        if (!this.mpIsInGame()) {
            return;
        }
        try {
            this.mpPrepareGameRequest((byte)102);
        }
        catch (Exception exception) {
            if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                GLLib.Dbg("Error: " + exception.getMessage());
            }
            return;
        }
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleFinishGame() {
        block8: {
            if (!this.mpProcessIncomingMessages()) {
                return;
            }
            if (this.m_type != 103 || this.m_subtype != 114) {
                return;
            }
            try {
                byte by = this.getByte();
                if (by != 102) {
                    if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                        GLLib.Dbg("Bad response FINISH" + new String(this.m_data));
                    }
                    this.lastErrorCode = 51;
                }
                if ((by = this.getByte()) == 115) {
                    this.m_MPConnectLevel = (byte)2;
                    this.lastErrorCode = 0;
                } else {
                    this.lastErrorCode = 54;
                }
            }
            catch (Exception exception) {
                this.lastErrorCode = 40;
                if (!GLLibConfig.xplayer_ENABLE_DEBUG) break block8;
                GLLib.Dbg("Error: " + exception.getMessage());
            }
        }
    }

    public void mpSendFindPlayer(String string) {
        if (!this.mpIsConnected()) {
            this.lastErrorCode = 50;
            return;
        }
        try {
            this.mpPrepareGameRequest((byte)119);
            this.addString(string);
        }
        catch (Exception exception) {
            if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                GLLib.Dbg("Error: " + exception.getMessage());
            }
            return;
        }
        this.found_player_session_name = null;
        this.found_player_session_number_of_players = (byte)-1;
        this.found_player_status = (byte)-1;
        this.found_player_name = string;
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleFindPlayer() {
        block9: {
            if (!this.mpProcessIncomingMessages()) {
                return;
            }
            if (this.m_type != 103 || this.m_subtype != 114) {
                return;
            }
            try {
                byte by = this.getByte();
                if (by != 119) {
                    if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                        GLLib.Dbg("Bad response find player" + new String(this.m_data));
                    }
                    this.lastErrorCode = 40;
                    return;
                }
                by = this.getByte();
                if (by == 115) {
                    this.found_player_status = this.getByte();
                    if (this.found_player_status == 115 || this.found_player_status == 112) {
                        this.found_player_session_name = this.getString();
                        this.found_player_session_number_of_players = this.getByte();
                    }
                    this.lastErrorCode = 0;
                } else {
                    this.lastErrorCode = 54;
                }
            }
            catch (Exception exception) {
                this.lastErrorCode = 40;
                if (!GLLibConfig.xplayer_ENABLE_DEBUG) break block9;
                GLLib.Dbg("Error: " + exception.getMessage());
            }
        }
    }

    public void mpSendGetPlayerData(String string) {
        if (!this.mpIsConnected()) {
            this.lastErrorCode = 50;
            return;
        }
        try {
            this.mpPrepareGameRequest((byte)121);
            this.addString(string);
        }
        catch (Exception exception) {
            if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                GLLib.Dbg("Error: " + exception.getMessage());
            }
            return;
        }
        this.requested_player_data = null;
        this.requested_player_nickname = string;
        this.lastErrorCode = -1;
        this.whttp.m_bError = false;
        this.wtcp.sendPacket(this.getData());
        callstarttime = System.currentTimeMillis();
    }

    public void mpHandleGetPlayerData() {
        block10: {
            if (!this.mpProcessIncomingMessages()) {
                return;
            }
            if (this.m_type != 103 || this.m_subtype != 114) {
                return;
            }
            try {
                byte by = this.getByte();
                if (by != 121) {
                    if (GLLibConfig.xplayer_ENABLE_DEBUG) {
                        GLLib.Dbg("Bad response find player" + new String(this.m_data));
                    }
                    this.lastErrorCode = 40;
                    return;
                }
                by = this.getByte();
                if (by == 115) {
                    by = this.getByte();
                    if (by == 104) {
                        this.requested_player_data = this.getString();
                        this.lastErrorCode = 0;
                    } else {
                        this.lastErrorCode = by == 100 ? 0 : 40;
                    }
                } else {
                    this.lastErrorCode = 54;
                }
            }
            catch (Exception exception) {
                this.lastErrorCode = 40;
                if (!GLLibConfig.xplayer_ENABLE_DEBUG) break block10;
                GLLib.Dbg("Error: " + exception.getMessage());
            }
        }
    }

    protected boolean mpSendKeepAlive() {
        try {
            this.clearData();
            this.addByte((byte)103);
            this.addByte((byte)97);
            this.wtcp.sendPacket(this.getData());
            callstarttime = System.currentTimeMillis();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public String[] getNameList() {
        return this.m_lNameList;
    }

    public String[] getDataList() {
        return this.m_lBinaryDataList;
    }

    public byte[] getByteDataList() {
        return this.m_lByteDataList;
    }

    public String getSessionName() {
        return this.currentsessionname;
    }

    public String getSessionData() {
        return this.currentsessiondata;
    }

    public int getNumberOfItems() {
        return this.noitems;
    }

    public int getFirstSessionIndex() {
        return this.nosessionsbase;
    }

    public String getFoundPlayerName() {
        return this.found_player_name;
    }

    public byte getFoundPlayerStatus() {
        return this.found_player_status;
    }

    public String getFoundPlayerSessionName() {
        return this.found_player_session_name;
    }

    public byte getFoundPlayerSessionNumberOfPlayers() {
        return this.found_player_session_number_of_players;
    }

    public String getRequestedPlayerData() {
        return this.requested_player_data;
    }

    public String getRequestedPlayerNickname() {
        return this.requested_player_nickname;
    }

    static interface ConnectLevel {
        public static final byte NOT_CONNECTED = 0;
        public static final byte NOT_LOGGED_IN = 1;
        public static final byte IN_CONNECTED = 2;
        public static final byte IN_SESSION = 3;
        public static final byte IN_SESSION_MASTER = 4;
        public static final byte IN_GAME = 5;
        public static final byte IN_GAME_MASTER = 6;
    }

    public static interface MessageType {
        public static final byte BASIC_MESSAGE_TYPE_UNKNOWN = 0;
        public static final byte BASIC_MESSAGE_TYPE_GAME = 103;
        public static final byte BASIC_MESSAGE_TYPE_CONNECT = 115;
        public static final byte CONNECT_MESSAGE_INIT_WRITE = 119;
        public static final byte CONNECT_MESSAGE_INIT_READ = 114;
        public static final byte CONNECT_MESSAGE_SUCCESS = 115;
        public static final byte CONNECT_MESSAGE_ERROR = 101;
        public static final byte CONNECT_MESSAGE_DISCONNECT = 120;
        public static final byte GAME_MESSAGE_REQUEST = 114;
        public static final byte GAME_MESSAGE_PUSH = 112;
        public static final byte GAME_MESSAGE_IN_GAME = 103;
        public static final byte GAME_MESSAGE_IN_GAME_TOALL = 104;
        public static final byte GAME_MESSAGE_ERROR = 101;
        public static final byte GAME_MESSAGE_KEEP_ALIVE = 97;
        public static final byte REQUEST_MESSAGE_LOGIN = 105;
        public static final byte REQUEST_MESSAGE_CREATE_SESSION = 99;
        public static final byte REQUEST_MESSAGE_LIST_SESSIONS = 108;
        public static final byte REQUEST_MESSAGE_GET_QUICK_SESSION = 117;
        public static final byte REQUEST_MESSAGE_JOIN_SESSION = 106;
        public static final byte REQUEST_MESSAGE_LEAVE_SESSION = 113;
        public static final byte REQUEST_MESSAGE_KICK_OUT_PLAYER = 107;
        public static final byte REQUEST_MESSAGE_START_GAME = 115;
        public static final byte REQUEST_MESSAGE_FINISH_GAME = 102;
        public static final byte REQUEST_MESSAGE_GET_PLAYER_INFO = 119;
        public static final byte REQUEST_MESSAGE_GET_PLAYER_DATA = 121;
        public static final byte RESPONSE_MESSAGE_SUCCESS = 115;
        public static final byte RESPONSE_MESSAGE_ERROR = 101;
        public static final byte ERROR_INVALID_INPUT = 105;
        public static final byte ERROR_NO_SESSION = 115;
        public static final byte ERROR_SESSION_CLOSED = 99;
        public static final byte ERROR_NOT_MASTER = 109;
        public static final byte ERROR_LOGIN_NICKNAME_USED = 110;
        public static final byte ERROR_LOGIN_INVALID_NICKNAME = 113;
        public static final byte ERROR_LOGIN_AUTHENTICATION_FAILED = 97;
        public static final byte ERROR_CREATE_SESSION_INVALID_NAME = 118;
        public static final byte ERROR_CREATE_SESSION_NAME_USED = 117;
        public static final byte ERROR_BLOCKED_SESSION = 98;
        public static final byte ERROR_LIST_SESSION_INVALID_INDEX = 108;
        public static final byte ERROR_JOIN_SESSION_TOO_MANY_PLAYERS = 106;
        public static final byte ERROR_NO_PLAYER = 107;
        public static final byte ERROR_KICK_OUT_PLAYER_IS_MASTER = 100;
        public static final byte ERROR_START_GAME_NOT_ENOUGH_PLAYERS = 103;
        public static final byte PUSH_MESSAGE_JOIN_SESSION = 106;
        public static final byte PUSH_MESSAGE_LEAVE_SESSION = 108;
        public static final byte PUSH_MESSAGE_KICK_OUT = 107;
        public static final byte PUSH_MESSAGE_START_GAME = 115;
        public static final byte PUSH_MESSAGE_FINISH_GAME = 102;
        public static final byte PLAYER_STATUS_NOT_REGISTERED = 110;
        public static final byte PLAYER_STATUS_OFFLINE = 102;
        public static final byte PLAYER_STATUS_ONLINE = 111;
        public static final byte PLAYER_STATUS_ONLINE_IN_SESSION = 115;
        public static final byte PLAYER_STATUS_ONLINE_PLAYING = 112;
        public static final byte PLAYER_STATUS_HAS_PSD = 104;
        public static final byte PLAYER_STATUS_HAS_NO_PSD = 100;
    }

    public static interface Error {
        public static final int ERROR_INIT = -100;
        public static final byte ERROR_NOT_M7_ENABLED = -3;
        public static final byte ERROR_CONNECTION = -2;
        public static final byte ERROR_PENDING = -1;
        public static final byte ERROR_NONE = 0;
        public static final byte ERROR_NO_UUID = 1;
        public static final byte ERROR_NO_NICKNAME = 2;
        public static final byte ERROR_REGISTER_FAILED = 3;
        public static final byte ERROR_NOT_REGISTERED = 4;
        public static final byte ERROR_NICK_TAKEN = 5;
        public static final byte ERROR_SCORE_UPLOAD_FAILED = 21;
        public static final byte ERROR_GET_RANKINGS_FAILED = 22;
        public static final byte ERROR_RATE_GAME_FAILED = 23;
        public static final byte ERROR_RECOMMEND_GAME_FAILED = 24;
        public static final byte ERROR_NO_PHONE_NUMBER = 25;
        public static final byte ERROR_NO_CLIENT_ID = 26;
        public static final byte ERROR_INVALID_GGI = 27;
        public static final byte ERROR_GET_STATS_FAILED = 29;
        public static final byte ERROR_SUPPLEMENTAL_DATA_NEEDED = 31;
        public static final byte ERROR_VALIDATE_LICENSE_FAILED = 32;
        public static final byte ERROR_CHANGE_USERNAME_FAILED = 33;
        public static final byte ERROR_BAD_RESPONSE = 40;
        public static final byte ERROR_WRONGFULL_QSTATE = 50;
        public static final byte ERROR_WRONGFULL_RSTATE = 51;
        public static final byte ERROR_START_GAME = 52;
        public static final byte ERROR_JOIN_GAME = 53;
        public static final byte ERROR_REQUEST_FAILED = 54;
        public static final byte ERROR_DOWNLOAD_FILE_NOT_FOUND = 60;
        public static final byte ERROR_DOWNLOAD_LIST_NO_FILES = 61;
        public static final byte ERROR_DOWNLOAD_FAILED = 62;
        public static final byte ERROR_DOWNLOAD_NO_SPACE = 63;
        public static final byte ERROR_AUCTION_UNKNOWN = 64;
        public static final byte ERROR_AUCTION_MORE_COINS = 65;
        public static final byte ERROR_AUCTION_NOT_AVAILABLE = 66;
        public static final byte ERROR_AUCTION_CANNOT_CANCEL = 67;
    }
}

