/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.MIDIControl;
import javax.microedition.media.control.RateControl;
import javax.microedition.media.control.TempoControl;
import javax.microedition.media.control.VolumeControl;

class GLLibPlayer
implements Runnable {
    int posX;
    int posY;
    int curFlags;
    ASprite sprite;
    private int curAnim;
    private int curFrame;
    public int curTime;
    private int nbLoop;
    private boolean animIsOver;
    private int curBlend;
    private int curScale;
    private static int k_animBaseFrameTime = 1000 / GLLibConfig.sprite_animFPS;
    private static final int k_snd_nbChannel = GLLibConfig.sound_numberOfChannels;
    private static final int k_snd_max_volume = 100;
    private static final int k_snd_command_dummy = 0;
    private static final int k_snd_command_prepare = 1;
    private static final int k_snd_command_free = 2;
    private static final int k_snd_command_play = 3;
    private static final int k_snd_command_stop = 4;
    private static final int k_snd_command_pause = 5;
    private static final int k_snd_command_resume = 6;
    private static final int k_snd_command_amount = 7;
    private static final int k_snd_state_unprepared = 0;
    private static final int k_snd_state_ready = 1;
    private static final int k_snd_state_playing = 2;
    private static final int k_snd_state_paused = 3;
    private static final int k_snd_queue_command = 0;
    private static final int k_snd_queue_index = 1;
    private static final int k_snd_queue_priority = 2;
    private static final int k_snd_queue_volume = 3;
    private static final int k_snd_queue_loop = 4;
    private static final int k_snd_queue_size = 5;
    private static final int k_snd_max_queue_length = 7;
    static final int k_snd_priority_highest = 0;
    static final int k_snd_priority_normal = 7;
    static final int k_snd_priority_lowest = 15;
    static int s_snd_masterVolume;
    static int s_snd_maxNbSoundSlot;
    private static boolean s_snd_isSoundEngineInitialized;
    private static byte[][] s_snd_sndSlot;
    private static int[] s_snd_sndType;
    private static int[] s_snd_sndDuration;
    private static String[] s_snd_sndResourceURL;
    private static boolean s_snd_IgnoreSoundsOnInterrupt;
    private static Player[] s_snd_Player;
    private static Player[] s_snd_PlayerSlot;
    private static long[] s_snd_playTime;
    private static int[] s_snd_index;
    private static int[] s_snd_priority;
    private static int[] s_snd_state;
    private static int[] s_snd_volume;
    private static int[] s_snd_loop;
    private static Thread s_pThread;
    private static GLLibPlayer s_pSoundPlayerIns;
    private static int[] s_snd_queue;
    private static int[] s_snd_queue_pointer;
    private static int[] s_snd_queue_size;
    static String[] s_data_mimeType;
    public static final int WRAP_CLAMP = 0;
    public static final int WRAP_REPEAT = 1;
    public static final int WRAP_NONE = 2;
    public static final int TILESET_EFFECT_NONE = 0;
    public static final int TILESET_EFFECT_NORMAL = 1;
    public static final int TILESET_EFFECT_ADDITIVE = 2;
    public static final int TILESET_EFFECT_MULTIPLICATIVE = 3;
    private static boolean s_bTilesetPlayerInitialized;
    private static int s_TilesetMaxLayerCount;
    private static int s_TilesetEffectLayer;
    private static int s_TilesetAlphaLayer;
    private static int s_TilesetEffectType;
    private static final int k_TilesetInfoDestWidth = 0;
    private static final int k_TilesetInfoDestHeight = 1;
    private static final int k_TilesetInfoTileWidth = 2;
    private static final int k_TilesetInfoTileWidthShift = 3;
    private static final int k_TilesetInfoTileWidthMask = 4;
    private static final int k_TilesetInfoTileHeight = 5;
    private static final int k_TilesetInfoTileHeightShift = 6;
    private static final int k_TilesetInfoTileHeightMask = 7;
    private static final int k_TilesetInfoCOUNT = 8;
    private static final int k_TilesetLayerInitialized = 0;
    private static final int k_TilesetLayerEnabled = 1;
    private static final int k_TilesetLayerTileCountWidth = 2;
    private static final int k_TilesetLayerTileCountHeight = 3;
    private static final int k_TilesetLayerWidth = 4;
    private static final int k_TilesetLayerHeight = 5;
    private static final int k_TilesetLayerCBWidth = 6;
    private static final int k_TilesetLayerCBHeight = 7;
    private static final int k_TilesetLayerFirstTileX = 8;
    private static final int k_TilesetLayerFirstTileY = 9;
    private static final int k_TilesetLayerLastTileX = 10;
    private static final int k_TilesetLayerLastTileY = 11;
    private static final int k_TilesetLayerCamX = 12;
    private static final int k_TilesetLayerCamY = 13;
    private static final int k_TilesetLayerFlag = 14;
    private static final int k_TilesetLayerCOUNT = 15;
    private static final int k_TilesetLayerImageCB = 0;
    private static final int k_TilesetLayerImageCOUNT = 1;
    private static final int k_TilesetLayerGraphicsCB = 0;
    private static final int k_TilesetLayerGraphicsCOUNT = 1;
    private static final int k_TilesetLayerDataMap = 0;
    private static final int k_TilesetLayerDataFlip = 1;
    private static final int k_TilesetLayerDataCOUNT = 2;
    private static int[] s_TilesetInfo;
    private static int[][] s_TilesetLayerInfo;
    private static byte[][][] s_TilesetLayerData;
    private static Image[][] s_TilesetLayerImage;
    private static Graphics[][] s_TilesetLayerGraphics;
    private static ASprite[] s_TilesetSprite;
    private static final int k_Flag_WrappingX = 1;
    private static final int k_Flag_WrappingY = 2;
    private static final int k_Flag_UseCB = 4;
    private static final int k_Flag_Origin = 8;
    private static final int k_Flag_LimitCamX = 16;
    private static final int k_Flag_LimitCamY = 32;

    GLLibPlayer() {
        this.Reset();
    }

    GLLibPlayer(ASprite aSprite, int n, int n2) {
        if (GLLibConfig.sprite_animFPS > 1000) {
            GLLib.Assert(false, "GLLibPlayer : Invalid value of GLLibConfig.sprite_animFPS > 1000");
        }
        this.Reset();
        this.posX = n;
        this.posY = n2;
        this.SetSprite(aSprite);
    }

    void Reset() {
        this.posX = 0;
        this.posY = 0;
        this.curAnim = -1;
        this.curFrame = 0;
        this.sprite = null;
        this.curFlags = 0;
        this.curTime = 0;
        this.nbLoop = 1;
        this.animIsOver = true;
        if (GLLibConfig.pfx_useSpriteEffectScale) {
            this.curScale = -1;
        }
        if (GLLibConfig.pfx_useSpriteEffectBlend) {
            this.curBlend = -1;
        }
    }

    void SetPos(int n, int n2) {
        this.posX = n;
        this.posY = n2;
    }

    ASprite GetSprite() {
        return this.sprite;
    }

    void SetSprite(ASprite aSprite) {
        this.sprite = aSprite;
        this.SetAnim(-1, -1);
    }

    void SetAnim(int n) {
        GLLib.Warning("GLLibPlayer.SetAnim(int anim) . this function is deprecated, use GLLibPlayer.SetAnim(int anim, int nbLoop) instead");
        this.SetAnim(n, -1);
    }

    void SetAnim(int n, int n2, boolean bl) {
        if (bl) {
            this.SetAnim(-1, 1);
        }
        this.SetAnim(n, n2);
    }

    void SetAnim(int n, int n2) {
        if (this.sprite == null) {
            GLLib.Assert(false, "GLLibPlayer.SetAnim().sprite is not set");
        }
        if (n >= this.GetNbanim()) {
            GLLib.Assert(false, "GLLibPlayer.SetAnim().anim out of range");
        }
        if (n2 == 0) {
            GLLib.Assert(false, "GLLibPlayer.SetAnim().nbLoop is invalid");
        }
        if (this.animIsOver || n != this.curAnim) {
            this.curAnim = n;
            this.SetFrame(0);
            this.nbLoop = n2 - 1;
            this.animIsOver = false;
        }
    }

    int GetAnim() {
        return this.curAnim;
    }

    int SetFrame(int n) {
        if (this.sprite == null) {
            GLLib.Assert(false, "GLLibPlayer.SetFrame().sprite is not set");
        }
        if (n < 0) {
            GLLib.Assert(false, "GLLibPlayer.SetFrame().frame is negative");
        }
        if (this.curAnim < 0) {
            return -1;
        }
        int n2 = this.GetNbFrame();
        while (n > n2) {
            n -= n2;
        }
        this.curFrame = n;
        this.curTime = 0;
        return n;
    }

    void RandomizeAnim() {
        this.curFrame = GLLib.Math_Rand(0, this.GetNbFrame());
        this.curTime = 0;
    }

    int GetFrame() {
        return this.curFrame;
    }

    int GetAnimFrame() {
        if (this.sprite == null || this.curAnim == -1) {
            return -1;
        }
        return this.sprite.GetAnimFrame(this.curAnim, this.curFrame);
    }

    void SetTransform(int n) {
        switch (n) {
            case 0: {
                this.curFlags = 0;
                break;
            }
            case 2: {
                this.curFlags = 1;
                break;
            }
            case 1: {
                this.curFlags = 2;
                break;
            }
            case 3: {
                this.curFlags = 3;
                break;
            }
            case 5: {
                this.curFlags = 4;
                break;
            }
            case 6: {
                this.curFlags = 7;
                break;
            }
            case 7: {
                this.curFlags = 6;
                break;
            }
            case 4: {
                this.curFlags = 5;
            }
        }
    }

    int GetTransform() {
        switch (this.curFlags) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 5;
            }
            case 7: {
                return 6;
            }
            case 6: {
                return 7;
            }
            case 5: {
                return 4;
            }
        }
        return -1;
    }

    int GetNbanim() {
        if (this.sprite == null) {
            GLLib.Assert(false, "GLLibPlayer.GetNbanim().sprite is not set");
        }
        return this.sprite._anims_naf.length;
    }

    int GetNbFrame() {
        if (this.sprite == null) {
            GLLib.Assert(false, "GLLibPlayer.GetNbFrame().sprite is not set");
        }
        if (this.curAnim >= 0) {
            return this.sprite.GetAFrames(this.curAnim);
        }
        return -1;
    }

    int GetDuration() {
        if (this.sprite == null) {
            GLLib.Assert(false, "GLLibPlayer.GetDuration().sprite is not set");
        }
        if (this.curAnim >= 0) {
            return this.sprite.GetAFrameTime(this.curAnim, this.curFrame) * k_animBaseFrameTime;
        }
        return 0;
    }

    boolean IsAnimOver() {
        if (this.sprite == null) {
            GLLib.Assert(false, "GLLibPlayer.isAnimOver().sprite is not set");
        }
        if (this.curAnim < 0) {
            return true;
        }
        if (this.nbLoop < 0) {
            return false;
        }
        return this.animIsOver;
    }

    void Render() {
        if (this.sprite == null) {
            GLLib.Assert(false, "GLLibPlayer.render().sprite is not set");
        }
        if (this.curAnim < 0) {
            return;
        }
        if (GLLibConfig.pfx_useSpriteEffectScale || GLLibConfig.pfx_useSpriteEffectBlend) {
            if (GLLibConfig.pfx_useSpriteEffectScale && this.curScale != -1) {
                int n = 11;
                GLLib.PFX_EnableEffect(n, false);
                GLLib.PFX_SetParam(11, 1, this.curScale);
                if (GLLibConfig.pfx_useSpriteEffectBlend && this.curBlend != -1) {
                    GLLib.PFX_SetParam(11, 2, this.curBlend);
                }
            } else if (GLLibConfig.pfx_useSpriteEffectBlend && this.curBlend != -1) {
                int n = 10;
                GLLib.PFX_EnableEffect(n, false);
                GLLib.PFX_SetParam(10, 1, this.curBlend);
            }
        }
        this.sprite.PaintAFrame(GLLib.g, this.curAnim, this.curFrame, this.posX, this.posY, this.curFlags, 0, 0);
        if (GLLibConfig.pfx_useSpriteEffectScale || GLLibConfig.pfx_useSpriteEffectBlend) {
            GLLib.s_PFX_type &= 0xFFFFF21F;
        }
    }

    void Update() {
        GLLib.Warning("GLLibPlayer.Update() . this function is deprecated, use GLLibPlayer.Update(int DT) instead");
        if (GLLibConfig.sprite_animFPS == 1000) {
            this.Update(1);
        } else {
            this.Update(GLLib.s_game_frameDT);
        }
    }

    void Update(int n) {
        block18: {
            int n2;
            block17: {
                if (n < 0) {
                    GLLib.Assert(false, "GLLibPlayer.Update.DT is negative");
                }
                if (GLLibConfig.sprite_animFPS == 1000) {
                    if (n > 1) {
                        GLLib.Warning("GLLibPlayer.Update was called with DT larger than 1, the player is currently working as Frame Based Player");
                    }
                } else if (n == 1) {
                    GLLib.Warning("GLLibPlayer.Update was called with DT equal 1, the player is currently working as a Time Based Player, it should be more than 1 ms ?");
                }
                if (this.animIsOver || this.curAnim < 0) {
                    return;
                }
                n2 = this.GetDuration();
                if (n2 == 0) {
                    GLLib.Assert(false, "GLLibPlayer.Update.frame " + this.curFrame + " of animation " + this.curAnim + " has a duration of 0");
                }
                if (!GLLibConfig.sprite_noFrameSkip) break block17;
                if (this.curTime < n2) break block18;
                this.curTime -= n2;
                if (this.curFrame < this.sprite.GetAFrames(this.curAnim) - 1) {
                    ++this.curFrame;
                } else if (this.nbLoop == 0) {
                    this.animIsOver = true;
                } else {
                    if (this.nbLoop > 0) {
                        --this.nbLoop;
                    }
                    this.curFrame = 0;
                }
                n2 = this.GetDuration();
                if (n2 != 0) break block18;
                GLLib.Assert(false, "GLLibPlayer.Update.frame " + this.curFrame + " of animation " + this.curAnim + " has a duration of 0");
                break block18;
            }
            while (this.curTime >= n2) {
                this.curTime -= n2;
                if (this.curFrame < this.sprite.GetAFrames(this.curAnim) - 1) {
                    ++this.curFrame;
                } else {
                    if (this.nbLoop == 0) {
                        this.animIsOver = true;
                        break;
                    }
                    if (this.nbLoop > 0) {
                        --this.nbLoop;
                    }
                    this.curFrame = 0;
                }
                if ((n2 = this.GetDuration()) != 0) continue;
                GLLib.Assert(false, "GLLibPlayer.Update.frame " + this.curFrame + " of animation " + this.curAnim + " has a duration of 0");
            }
        }
        this.curTime += n;
    }

    int GetScale() {
        if (GLLibConfig.pfx_useSpriteEffectScale) {
            return this.curScale;
        }
        GLLib.Dbg("GetScale: Scaling is not enabled, you must set pfx_useSpriteEffectScale to TRUE!");
        return 0;
    }

    void SetScale(int n) {
        if (GLLibConfig.pfx_useSpriteEffectScale) {
            this.curScale = n;
        } else {
            GLLib.Dbg("SetScale: Scaling is not enabled, you must set pfx_useSpriteEffectScale to TRUE!");
        }
    }

    int GetBlend() {
        if (GLLibConfig.pfx_useSpriteEffectBlend) {
            return this.curBlend;
        }
        GLLib.Dbg("GetBlend: Scaling is not enabled, you must set pfx_useSpriteEffectBlend to TRUE!");
        return 0;
    }

    void SetBlend(int n) {
        if (GLLibConfig.pfx_useSpriteEffectBlend) {
            this.curBlend = n;
        } else {
            GLLib.Dbg("SetBlend: Scaling is not enabled, you must pfx_useSpriteEffectBlend to TRUE!");
        }
    }

    static final Player Snd_GetPlayer(int n) {
        if (GLLibConfig.sound_enable) {
            if (s_snd_PlayerSlot == null) {
                GLLib.Assert(false, "Snd_GetPlayer: Player array is null! Must call Snd_Init");
            }
            if (n < 0) {
                GLLib.Assert(false, "Snd_GetPlayer: Index is negative [" + n + "]");
            }
            if (n >= s_snd_maxNbSoundSlot) {
                GLLib.Assert(false, "Snd_GetPlayer: Index [" + n + "] is out of range. Max slots is " + s_snd_maxNbSoundSlot);
            }
            return s_snd_PlayerSlot[n];
        }
        return null;
    }

    static final Player Snd_GetChannelPlayer(int n) {
        if (GLLibConfig.sound_enable) {
            if (s_snd_Player == null) {
                GLLib.Assert(false, "Snd_GetChannelPlayer: Player array is null! Must call Snd_Init");
            }
            if (n < 0) {
                GLLib.Assert(false, "Snd_GetChannelPlayer: Index is negative [" + n + "]");
            }
            if (n >= k_snd_nbChannel) {
                GLLib.Assert(false, "Snd_GetChannelPlayer: Index [" + n + "] is out of range. Max channels is " + k_snd_nbChannel);
            }
            return s_snd_Player[n];
        }
        return null;
    }

    private static int SndQueue_NormalizeIndex(int n) {
        while (n >= 7) {
            n -= 7;
        }
        while (n < 0) {
            n += 7;
        }
        return n;
    }

    private static final int SndQueue_GetIndex(int n, int n2) {
        return n * 7 * 5 + n2 * 5;
    }

    private static final int SndQueue_GetData(int n, int n2) {
        return s_snd_queue[GLLibPlayer.SndQueue_GetIndex(n, s_snd_queue_pointer[n]) + n2];
    }

    private static void SndQueue_Push(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        if (s_snd_queue_size[n] >= 7) {
            GLLib.Assert(false, "SndQueue_Push: Too many sound requests given before Snd_Update!");
        }
        int n8 = s_snd_queue_pointer[n];
        int n9 = s_snd_queue_size[n];
        int n10 = GLLibPlayer.SndQueue_NormalizeIndex(n8 + n9);
        for (int i = 0; i < n9; ++i) {
            n7 = GLLibPlayer.SndQueue_NormalizeIndex(n10 - i - 1);
            if (s_snd_queue[(n7 = GLLibPlayer.SndQueue_GetIndex(n, n7)) + 0] != n2 || (n2 == 3 || n2 == 1) && s_snd_queue[n7 + 2] < n4) continue;
            GLLibPlayer.s_snd_queue[n7 + 0] = 0;
        }
        n7 = GLLibPlayer.SndQueue_GetIndex(n, n10);
        GLLibPlayer.s_snd_queue[n7 + 0] = n2;
        GLLibPlayer.s_snd_queue[n7 + 1] = n3;
        GLLibPlayer.s_snd_queue[n7 + 2] = n4;
        GLLibPlayer.s_snd_queue[n7 + 3] = n5;
        GLLibPlayer.s_snd_queue[n7 + 4] = n6;
        int n11 = n;
        s_snd_queue_size[n11] = s_snd_queue_size[n11] + 1;
    }

    private static final void SndQueue_Push(int n, int n2) {
        GLLibPlayer.SndQueue_Push(n, n2, -1, -1, -1, -1);
    }

    private static void SndQueue_Pop(int n) {
        GLLibPlayer.s_snd_queue_pointer[n] = GLLibPlayer.SndQueue_NormalizeIndex(s_snd_queue_pointer[n] + 1);
        int n2 = n;
        s_snd_queue_size[n2] = s_snd_queue_size[n2] - 1;
    }

    static void Snd_Init(int n) throws Exception {
        if (!GLLibConfig.sound_enable) {
            return;
        }
        if (GLLibConfig.sound_debugVerbose) {
            GLLib.Dbg("Snd_Init");
        }
        if (k_snd_nbChannel > 1) {
            if (GLLibConfig.sound_debugVerbose) {
                GLLib.Dbg("    WARNING nb of sound channel is set to more than one");
            }
            if (GLLibConfig.sound_debugVerbose) {
                GLLib.Dbg("    - this is your responsability to make sure that phone with lower");
            }
            if (GLLibConfig.sound_debugVerbose) {
                GLLib.Dbg("     nb of sound channel will play the important sound (BGM, SFX...)");
            }
        }
        GLLib.Dbg("Snd_Init : JSR135");
        if (GLLibConfig.sound_debugVerbose) {
            GLLib.Dbg("microedition.media.version is :" + System.getProperty("microedition.media.version"));
        }
        if (GLLibConfig.sound_debugVerbose) {
            GLLib.Dbg("phone support mixing : " + System.getProperty("supports.mixing"));
        }
        if (System.getProperty("supports.mixing").equals("true")) {
            if (GLLibConfig.sound_debugVerbose) {
                GLLib.Dbg("    WARNING this phone support mixing, that ONLY means: ");
            }
            if (GLLibConfig.sound_debugVerbose) {
                GLLib.Dbg("    - Manager.playTone can play 2 tones simultaneously");
            }
            if (GLLibConfig.sound_debugVerbose) {
                GLLib.Dbg("    - Manager.playTone and one Player can be used at the same time");
            }
            if (GLLibConfig.sound_debugVerbose) {
                GLLib.Dbg("    - At least 2 Players can playback audio simultaneously");
            }
        }
        s_snd_Player = new Player[k_snd_nbChannel];
        if (GLLibConfig.sound_useCachedPlayers) {
            s_snd_PlayerSlot = new Player[n];
        }
        s_snd_index = new int[k_snd_nbChannel];
        s_snd_priority = new int[k_snd_nbChannel];
        s_snd_state = new int[k_snd_nbChannel];
        s_snd_volume = new int[k_snd_nbChannel];
        s_snd_loop = new int[k_snd_nbChannel];
        s_snd_queue = new int[k_snd_nbChannel * 7 * 5];
        s_snd_queue_pointer = new int[k_snd_nbChannel];
        s_snd_queue_size = new int[k_snd_nbChannel];
        for (int i = 0; i < k_snd_nbChannel; ++i) {
            GLLibPlayer.s_snd_index[i] = -1;
            GLLibPlayer.s_snd_queue_pointer[i] = 0;
            GLLibPlayer.s_snd_queue_size[i] = 0;
        }
        s_snd_maxNbSoundSlot = n;
        s_snd_sndSlot = new byte[s_snd_maxNbSoundSlot][];
        s_snd_sndType = new int[s_snd_maxNbSoundSlot];
        if (GLLibConfig.sound_allowURLCreation) {
            s_snd_sndResourceURL = new String[s_snd_maxNbSoundSlot];
        }
        if (GLLibConfig.sound_useFakeMediaDuration) {
            s_snd_sndDuration = new int[s_snd_maxNbSoundSlot];
            s_snd_playTime = new long[k_snd_nbChannel];
        }
        s_snd_masterVolume = 100;
        s_snd_isSoundEngineInitialized = true;
        if (GLLibConfig.sound_enableThread) {
            s_pSoundPlayerIns = new GLLibPlayer();
            s_pThread = new Thread(s_pSoundPlayerIns);
            s_pThread.start();
        }
    }

    static void Snd_Quit() throws Exception {
        int n;
        if (!GLLibConfig.sound_enable) {
            return;
        }
        if (GLLibConfig.sound_debugVerbose) {
            GLLib.Dbg("Snd_quit");
        }
        GLLibPlayer.Snd_StopAllSounds();
        for (n = 0; n < k_snd_nbChannel; ++n) {
            GLLibPlayer.Snd_FreeChannelExec(n);
        }
        s_snd_Player = null;
        s_snd_isSoundEngineInitialized = false;
        for (n = 0; n < s_snd_maxNbSoundSlot; ++n) {
            GLLibPlayer.s_snd_sndSlot[n] = null;
        }
        s_snd_sndSlot = null;
        s_snd_sndType = null;
        if (GLLibConfig.sound_allowURLCreation) {
            s_snd_sndResourceURL = null;
        }
        if (GLLibConfig.sound_useFakeMediaDuration) {
            s_snd_sndDuration = null;
            s_snd_playTime = null;
        }
        if (GLLibConfig.sound_useCachedPlayers) {
            for (n = 0; n < s_snd_maxNbSoundSlot; ++n) {
                GLLibPlayer.s_snd_PlayerSlot[n] = null;
            }
        }
        s_snd_index = null;
        s_snd_priority = null;
        s_snd_state = null;
        s_snd_volume = null;
        s_snd_loop = null;
        s_pThread = null;
        s_snd_queue = null;
        s_snd_queue_pointer = null;
        s_snd_queue_size = null;
        if (GLLibConfig.useSystemGc) {
            System.gc();
        }
    }

    static void Snd_LoadSound(String string, int n, boolean bl) throws Exception {
        if (!GLLibConfig.sound_enable) {
            return;
        }
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        if (n >= s_snd_sndSlot.length) {
            GLLib.Assert(false, "resourceIndex is larger that slot count. Read the Warning in the doc.");
        }
        if (GLLibConfig.sound_debugVerbose) {
            GLLib.Dbg("Snd_LoadSound : " + n);
        }
        if (n < 0) {
            return;
        }
        if (s_snd_sndSlot == null) {
            GLLib.Assert(false, "Snd_LoadSound.snd not correctly initialized");
        }
        GLLib.Pack_Open(string);
        byte[] byArray = GLLib.Pack_ReadData(n);
        GLLibPlayer.Snd_LoadSound(byArray, GLLib.s_pack_lastDataReadMimeType, n, bl);
    }

    static void Snd_LoadSound(byte[] byArray, int n, int n2, boolean bl) throws Exception {
        if (!GLLibConfig.sound_enable || !s_snd_isSoundEngineInitialized) {
            return;
        }
        if (!GLLibConfig.sound_useCachedPlayers && bl) {
            GLLib.Assert(false, "Snd_LoadSound: Trying to cache sound but sound_useCachedPlayers is FALSE!");
        }
        if (n2 >= s_snd_sndSlot.length) {
            GLLib.Assert(false, "index is larger that slot count. Read the Warning in the doc.");
        }
        if (GLLibConfig.sound_debugVerbose) {
            GLLib.Dbg("Snd_LoadSound for slot : " + n2);
        }
        GLLibPlayer.s_snd_sndSlot[n2] = byArray;
        GLLibPlayer.s_snd_sndType[n2] = n;
        if (GLLibConfig.sound_debugVerbose) {
            GLLib.Dbg("Snd_LoadSound has mime : " + GLLib.GetMIME(s_snd_sndType[n2]));
        }
        if (GLLibConfig.sound_useCachedPlayers && bl) {
            if (GLLibConfig.sound_debugVerbose) {
                GLLib.Dbg("    create player (" + GLLib.GetMIME(s_snd_sndType[n2]) + ")");
            }
            GLLibPlayer.s_snd_PlayerSlot[n2] = Manager.createPlayer((InputStream)new ByteArrayInputStream(s_snd_sndSlot[n2]), (String)GLLib.GetMIME(s_snd_sndType[n2]));
            if (GLLibConfig.sound_useRealizedPlayers) {
                if (GLLibConfig.sound_debugVerbose) {
                    GLLib.Dbg("    realize player");
                }
                s_snd_PlayerSlot[n2].realize();
                if (GLLibConfig.sound_usePrefetchedPlayers) {
                    if (GLLibConfig.sound_debugVerbose) {
                        GLLib.Dbg("    prefetch player");
                    }
                    s_snd_PlayerSlot[n2].prefetch();
                }
            }
            GLLibPlayer.s_snd_sndSlot[n2] = null;
        }
    }

    static void Snd_LoadSound(String string, int n, int n2, boolean bl) throws Exception {
        if (!GLLibConfig.sound_allowURLCreation) {
            GLLib.Dbg("Snd_LoadSound(by URL) is not enabled, please set sound_allowURLCreation to TRUE!");
        } else if (GLLibConfig.sound_enable && s_snd_isSoundEngineInitialized) {
            if (n2 >= s_snd_sndSlot.length) {
                GLLib.Assert(false, "index is larger that slot count. Read the Warning in the doc.");
            }
            if (GLLibConfig.sound_debugVerbose) {
                GLLib.Dbg("Snd_LoadSound(by URL) for slot : " + n2);
            }
            GLLibPlayer.s_snd_sndSlot[n2] = null;
            GLLibPlayer.s_snd_sndResourceURL[n2] = string;
            GLLibPlayer.s_snd_sndType[n2] = n;
            if (GLLibConfig.sound_debugVerbose) {
                GLLib.Dbg("Snd_LoadSound(by URL) has mime : " + GLLib.GetMIME(s_snd_sndType[n2]));
            }
            if (GLLibConfig.sound_useCachedPlayers && bl) {
                if (GLLibConfig.sound_debugVerbose) {
                    GLLib.Dbg("Snd_LoadSound(by URL) creating player (" + GLLib.GetMIME(s_snd_sndType[n2]) + ")");
                }
                GLLib.Dbg("Snd_LoadSound(by URL) creating player from URL:" + s_snd_sndResourceURL[n2]);
                s_snd_IgnoreSoundsOnInterrupt = true;
                GLLibPlayer.s_snd_PlayerSlot[n2] = Manager.createPlayer((String)s_snd_sndResourceURL[n2]);
                s_snd_IgnoreSoundsOnInterrupt = false;
                if (GLLibConfig.sound_useRealizedPlayers) {
                    if (GLLibConfig.sound_debugVerbose) {
                        GLLib.Dbg("Snd_LoadSound(by URL): realize player");
                    }
                    s_snd_PlayerSlot[n2].realize();
                    if (GLLibConfig.sound_usePrefetchedPlayers) {
                        if (GLLibConfig.sound_debugVerbose) {
                            GLLib.Dbg("Snd_LoadSound(by URL): prefetch player");
                        }
                        s_snd_PlayerSlot[n2].prefetch();
                    }
                }
            }
        }
    }

    static boolean Snd_IsLoaded(int n) {
        if (s_snd_sndSlot != null && n < s_snd_sndSlot.length && s_snd_sndSlot[n] != null) {
            return true;
        }
        return s_snd_PlayerSlot != null && n < s_snd_PlayerSlot.length && s_snd_PlayerSlot[n] != null;
    }

    static void Snd_UnLoadSound(int n) throws Exception {
        if (!GLLibConfig.sound_enable || !s_snd_isSoundEngineInitialized) {
            return;
        }
        if (GLLibConfig.sound_debugVerbose) {
            GLLib.Dbg("Snd_UnLoadSound : unloading sound at slot " + n);
        }
        if (s_snd_sndSlot == null) {
            GLLib.Assert(false, "Snd_UnLoadSound : array is not initialised");
        }
        if (n < 0) {
            return;
        }
        GLLibPlayer.s_snd_sndSlot[n] = null;
        if (GLLibConfig.sound_allowURLCreation) {
            GLLibPlayer.s_snd_sndResourceURL[n] = null;
        }
        if (GLLibConfig.sound_useCachedPlayers) {
            if (s_snd_PlayerSlot != null && s_snd_PlayerSlot[n] != null) {
                s_snd_PlayerSlot[n].close();
            }
            GLLibPlayer.s_snd_PlayerSlot[n] = null;
            for (int i = 0; i < k_snd_nbChannel; ++i) {
                if (n != GLLibPlayer.Snd_GetCurrentSoundIndex(i)) continue;
                GLLibPlayer.s_snd_state[i] = 0;
                GLLibPlayer.s_snd_Player[i] = null;
            }
        }
        if (GLLibConfig.useSystemGc) {
            System.gc();
        }
    }

    static final void Snd_FreeChannel(int n) {
        if (!GLLibConfig.sound_enable) {
            return;
        }
        if (GLLibConfig.sound_debugVerbose) {
            GLLib.Dbg("Snd_FreeChannel " + n);
        }
        GLLibPlayer.SndQueue_Push(n, 2, -1, -1, -1, -1);
    }

    static void Snd_PrepareSound(int n, int n2, int n3) {
        if (!GLLibConfig.sound_enable) {
            return;
        }
        if (GLLibConfig.sound_debugVerbose) {
            GLLib.Dbg("Snd_PrepareSound " + n2);
        }
        if (n2 < 0) {
            if (GLLibConfig.sound_debugVerbose) {
                GLLib.Dbg("    dummy sound skiping");
            }
            return;
        }
        GLLibPlayer.SndQueue_Push(n, 1, n2, n3, -1, -1);
    }

    static void Snd_Play(int n, int n2, int n3, int n4, int n5) {
        if (GLLibConfig.sound_enable) {
            if (GLLibConfig.sound_debugVerbose) {
                GLLib.Dbg("Snd_Play: Channel[" + n + "], ID[" + n2 + "], Loop[" + n3 + "], Volume[" + n4 + "] and Priority[" + n5 + "]");
            }
            if (n3 < 0) {
                GLLib.Assert(false, "Snd_Play: Invalid loop number of " + n3);
            }
            if (n >= k_snd_nbChannel) {
                GLLib.Assert(false, "Snd_Play: Attempting to play on channel " + n + " while only have max " + k_snd_nbChannel);
            }
            if (n2 < 0 || n4 == 0) {
                if (GLLibConfig.sound_debugVerbose) {
                    GLLib.Dbg("    dummy sound skiping");
                }
                return;
            }
            GLLibPlayer.SndQueue_Push(n, 3, n2, n5, n4, n3);
        }
    }

    static final void Snd_Stop(int n) {
        if (!GLLibConfig.sound_enable) {
            return;
        }
        if (GLLibConfig.sound_debugVerbose) {
            GLLib.Dbg("Snd_stop");
        }
        GLLibPlayer.SndQueue_Push(n, 4);
    }

    static final void Snd_Pause(int n) {
        if (!GLLibConfig.sound_enable) {
            return;
        }
        if (GLLibConfig.sound_debugVerbose) {
            GLLib.Dbg("Snd_Pause");
        }
        GLLibPlayer.SndQueue_Push(n, 5);
    }

    static final void Snd_Resume(int n) {
        if (!GLLibConfig.sound_enable) {
            return;
        }
        if (GLLibConfig.sound_debugVerbose) {
            GLLib.Dbg("Snd_resume");
        }
        GLLibPlayer.SndQueue_Push(n, 6);
    }

    private static void Snd_PrepareExec(int n) throws Exception {
        if (!GLLibConfig.sound_enable) {
            return;
        }
        if (GLLibConfig.sound_debugVerbose) {
            GLLib.Dbg("Snd_PrepareExec");
        }
        int n2 = GLLibPlayer.SndQueue_GetData(n, 1);
        int n3 = GLLibPlayer.SndQueue_GetData(n, 2);
        if (s_snd_state[n] == 2 && s_snd_priority[n] < n3) {
            return;
        }
        if (s_snd_index[n] == n2 && s_snd_state[n] != 0) {
            return;
        }
        GLLibPlayer.Snd_FreeChannelExec(n);
        if (GLLibConfig.sound_debugVerbose) {
            GLLib.Dbg("prepareexec : channel : " + n);
        }
        if (GLLibConfig.sound_debugVerbose) {
            GLLib.Dbg("prepareexec : index   : " + n2);
        }
        if (GLLibConfig.sound_useCachedPlayers) {
            GLLibPlayer.s_snd_Player[n] = s_snd_PlayerSlot[n2];
        }
        if (GLLibConfig.sound_allowURLCreation && s_snd_Player[n] == null && s_snd_sndResourceURL[n2] != null) {
            GLLib.Dbg("    create player from URL:" + s_snd_sndResourceURL[n2]);
            s_snd_IgnoreSoundsOnInterrupt = true;
            GLLibPlayer.s_snd_Player[n] = Manager.createPlayer((String)s_snd_sndResourceURL[n2]);
            s_snd_IgnoreSoundsOnInterrupt = false;
        }
        if (s_snd_Player[n] == null) {
            if (GLLibConfig.sound_debugVerbose) {
                GLLib.Dbg("    create player (" + GLLib.GetMIME(s_snd_sndType[n2]) + ")");
            }
            if (s_snd_sndSlot[n2] == null) {
                GLLib.Dbg("    create player: player is null and raw data is null too... reload!!");
                return;
            }
            GLLibPlayer.s_snd_Player[n] = Manager.createPlayer((InputStream)new ByteArrayInputStream(s_snd_sndSlot[n2]), (String)GLLib.GetMIME(s_snd_sndType[n2]));
        }
        if (s_snd_Player[n] == null) {
            GLLib.Dbg("    ERROR.player is null 1338");
            return;
        }
        if (!GLLibConfig.sound_useRealizedPlayers) {
            if (GLLibConfig.sound_debugVerbose) {
                GLLib.Dbg("    realize player");
            }
            s_snd_Player[n].realize();
        }
        if (!GLLibConfig.sound_usePrefetchedPlayers) {
            if (GLLibConfig.sound_debugVerbose) {
                GLLib.Dbg("    prefetch player");
            }
            s_snd_Player[n].prefetch();
        }
        GLLibPlayer.s_snd_state[n] = 1;
        GLLibPlayer.s_snd_index[n] = n2;
    }

    private static void Snd_PlayExec(int n) throws Exception {
        if (!GLLibConfig.sound_enable || GLLib.s_game_isPaused) {
            return;
        }
        if (GLLibConfig.sound_debugVerbose) {
            GLLib.Dbg("Snd_PlayExec for channel : " + n);
        }
        GLLibPlayer.Snd_PrepareExec(n);
        if (GLLib.s_game_isPaused) {
            return;
        }
        if (s_snd_state[n] != 1 || s_snd_Player[n] == null) {
            if (GLLibConfig.sound_debugVerbose) {
                GLLib.Dbg("Snd_playExec : Cant play, state not ready or player is null");
            }
            return;
        }
        int n2 = GLLibPlayer.SndQueue_GetData(n, 1);
        int n3 = GLLibPlayer.SndQueue_GetData(n, 2);
        int n4 = GLLibPlayer.SndQueue_GetData(n, 4);
        int n5 = GLLibPlayer.SndQueue_GetData(n, 3);
        if (GLLibConfig.sound_debugVerbose) {
            GLLib.Dbg("    set loop count");
        }
        if (n4 == 0) {
            s_snd_Player[n].setLoopCount(-1);
        } else {
            s_snd_Player[n].setLoopCount(n4);
        }
        if (GLLibConfig.sound_useSetLevel) {
            if (GLLibConfig.sound_debugVerbose) {
                GLLib.Dbg("    set volume");
            }
            ((VolumeControl)s_snd_Player[n].getControl("VolumeControl")).setLevel(n5 * s_snd_masterVolume * 100 / 10000);
        }
        if (GLLibConfig.sound_debugVerbose) {
            GLLib.Dbg("    start player");
        }
        if (GLLibConfig.sound_useSetMediaTimeBeforePlay) {
            s_snd_Player[n].setMediaTime(0L);
        }
        s_snd_Player[n].start();
        GLLibPlayer.s_snd_state[n] = 2;
        GLLibPlayer.s_snd_volume[n] = n5;
        GLLibPlayer.s_snd_loop[n] = n4;
        GLLibPlayer.s_snd_priority[n] = n3;
        GLLibPlayer.s_snd_index[n] = n2;
        if (GLLibConfig.sound_useFakeMediaDuration) {
            GLLibPlayer.s_snd_playTime[n] = System.currentTimeMillis();
        }
    }

    static void Snd_SetMasterVolume(int n) throws Exception {
        if (!GLLibConfig.sound_enable) {
            return;
        }
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        s_snd_masterVolume = n;
        try {
            for (int i = 0; i < k_snd_nbChannel; ++i) {
                if (s_snd_Player[i] == null || s_snd_Player[i] == null || !GLLibConfig.sound_useSetLevel) continue;
                ((VolumeControl)s_snd_Player[i].getControl("VolumeControl")).setLevel(s_snd_volume[i] * s_snd_masterVolume * 100 / 10000);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static int Snd_GetChannelVolume(int n) throws Exception {
        if (!GLLibConfig.sound_enable) {
            return 0;
        }
        if (!s_snd_isSoundEngineInitialized) {
            return 0;
        }
        try {
            if (s_snd_Player[n] == null) {
                return 0;
            }
            return ((VolumeControl)s_snd_Player[n].getControl("VolumeControl")).getLevel() * 100 * 100 / (s_snd_masterVolume * 100);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private static void Snd_StopExec(int n) throws Exception {
        if (GLLibConfig.sound_debugVerbose) {
            GLLib.Dbg("Snd_stopExec");
        }
        if (s_snd_Player[n] == null) {
            return;
        }
        s_snd_Player[n].stop();
        GLLibPlayer.s_snd_state[n] = 1;
        if (GLLibConfig.sound_useFreeChannelOnStop) {
            GLLibPlayer.Snd_FreeChannelExec(n);
        }
        if (GLLibConfig.sound_useFakeMediaDuration) {
            GLLibPlayer.s_snd_playTime[n] = 0L;
        }
    }

    private static void Snd_PauseExec(int n) throws Exception {
        if (GLLibConfig.sound_debugVerbose) {
            GLLib.Dbg("Snd_PauseExec");
        }
        if (s_snd_state[n] != 2) {
            return;
        }
        if (s_snd_Player[n] == null) {
            GLLib.Assert(false, "Snd_pauseExec.player is null 1723");
        }
        if (s_snd_Player[n] == null) {
            return;
        }
        if (s_snd_Player[n].getState() != 400) {
            GLLib.Assert(false, "Snd_pauseExec.player wasn't playing");
        }
        s_snd_Player[n].stop();
        GLLibPlayer.s_snd_state[n] = 3;
    }

    private static void Snd_ResumeExec(int n) throws Exception {
        if (GLLibConfig.sound_debugVerbose) {
            GLLib.Dbg("Snd_ResumeExec");
        }
        if (s_snd_state[n] != 3) {
            return;
        }
        if (s_snd_Player[n] == null) {
            GLLib.Assert(false, "Snd_resumeExec.player is null 1766");
        }
        if (s_snd_Player[n] == null) {
            return;
        }
        s_snd_Player[n].start();
        GLLibPlayer.s_snd_state[n] = 2;
    }

    static void Snd_Update() {
        if (GLLibConfig.sound_enableThread) {
            if (s_pThread != null && !s_pThread.isAlive()) {
                s_pThread.start();
            }
        } else {
            GLLibPlayer.Snd_Update_Exec();
        }
    }

    private static void Snd_Update_Exec() {
        if (!GLLibConfig.sound_enable || !s_snd_isSoundEngineInitialized) {
            return;
        }
        for (int i = 0; i < k_snd_nbChannel; ++i) {
            int n;
            if (s_snd_queue_size[i] > 0 && s_snd_state[i] == 2) {
                try {
                    n = GLLibPlayer.Snd_IsPlaying(i);
                }
                catch (Exception exception) {
                    GLLib.Dbg("Snd_update.error on channel (" + i + ")." + exception);
                    n = 0;
                }
                if (n == 0) {
                    GLLibPlayer.s_snd_state[i] = 1;
                }
            }
            while (s_snd_queue_size[i] > 0) {
                try {
                    if (GLLibConfig.sound_debugVerbose) {
                        GLLib.Dbg("Snd_update");
                    }
                    n = GLLibPlayer.SndQueue_GetData(i, 0);
                    switch (n) {
                        case 1: {
                            GLLibPlayer.Snd_PrepareExec(i);
                            break;
                        }
                        case 2: {
                            GLLibPlayer.Snd_FreeChannelExec(i);
                            break;
                        }
                        case 3: {
                            GLLibPlayer.Snd_PlayExec(i);
                            break;
                        }
                        case 4: {
                            GLLibPlayer.Snd_StopExec(i);
                            break;
                        }
                        case 5: {
                            GLLibPlayer.Snd_PauseExec(i);
                            break;
                        }
                        case 6: {
                            GLLibPlayer.Snd_ResumeExec(i);
                        }
                    }
                }
                catch (Exception exception) {
                    GLLib.Dbg("Snd_update.error on channel (" + i + ")." + exception);
                    exception.printStackTrace();
                }
                GLLibPlayer.SndQueue_Pop(i);
            }
        }
    }

    public void run() {
        while (s_pThread != null) {
            GLLibPlayer.Snd_Update_Exec();
            try {
                Thread.sleep(1000 / GLLibConfig.FPSLimiter);
            }
            catch (Exception exception) {}
        }
    }

    protected static boolean Snd_IsPlaying(int n) throws Exception {
        if (!GLLibConfig.sound_enable || !s_snd_isSoundEngineInitialized) {
            return false;
        }
        if (n >= k_snd_nbChannel || s_snd_Player[n] == null) {
            return false;
        }
        if (GLLibConfig.sound_useFakeMediaDuration) {
            int n2 = GLLibPlayer.Snd_GetCurrentSoundIndex(n);
            if (n2 < 0) {
                return false;
            }
            if (s_snd_loop[n] != 0 && System.currentTimeMillis() - s_snd_playTime[n] > (long)(s_snd_sndDuration[n2] * s_snd_loop[n])) {
                return false;
            }
        } else if (s_snd_Player[n].getState() != 400) {
            return false;
        }
        return true;
    }

    static int Snd_GetState(int n) {
        if (!GLLibConfig.sound_enable || !s_snd_isSoundEngineInitialized) {
            return -1;
        }
        if (n < 0 || n >= k_snd_nbChannel || s_snd_Player[n] == null) {
            return -1;
        }
        return s_snd_Player[n].getState();
    }

    static void Snd_SetMediaDuration(int n, int n2) throws Exception {
        if (!GLLibConfig.sound_enable) {
            return;
        }
        if (!GLLibConfig.sound_useFakeMediaDuration) {
            return;
        }
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        if (n < 0) {
            if (GLLibConfig.sound_debugVerbose) {
                GLLib.Dbg("    dummy sound skiping");
            }
            return;
        }
        GLLibPlayer.s_snd_sndDuration[n] = n2;
    }

    private static void Snd_FreeChannelExec(int n) throws Exception {
        if (!GLLibConfig.sound_enable || !s_snd_isSoundEngineInitialized) {
            return;
        }
        if (GLLibConfig.sound_debugVerbose) {
            GLLib.Dbg("Snd_FreeChannelExec = " + n);
        }
        if (s_snd_Player[n] != null) {
            s_snd_Player[n].stop();
            if (!GLLibConfig.sound_usePrefetchedPlayers) {
                s_snd_Player[n].deallocate();
            }
            if (!GLLibConfig.sound_useCachedPlayers) {
                s_snd_Player[n].close();
            } else {
                int n2 = GLLibPlayer.SndQueue_GetData(n, 1);
                if (n2 < 0 || s_snd_PlayerSlot[n2] == null) {
                    s_snd_Player[n].close();
                }
            }
            GLLibPlayer.s_snd_Player[n] = null;
            if (GLLibConfig.useSystemGc) {
                System.gc();
            }
        }
        GLLibPlayer.s_snd_state[n] = 0;
    }

    static void Snd_StopAllSounds() {
        for (int i = 0; i < k_snd_nbChannel; ++i) {
            GLLibPlayer.Snd_Stop(i);
        }
        if (!GLLibConfig.sound_enableThread) {
            GLLibPlayer.Snd_Update();
        } else if (GLLib.s_game_isPaused) {
            GLLibPlayer.Snd_Update_Exec();
        }
    }

    static int Snd_GetCurrentSoundIndex(int n) {
        if (!s_snd_isSoundEngineInitialized) {
            return -1;
        }
        if (s_snd_index != null) {
            return s_snd_index[n];
        }
        return -1;
    }

    static long Snd_MediaTimeGet(int n) {
        if (!s_snd_isSoundEngineInitialized) {
            return -1L;
        }
        try {
            long l = s_snd_Player[n].getMediaTime();
            return l;
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    static long Snd_MediaTimeSet(int n, long l) {
        if (!s_snd_isSoundEngineInitialized) {
            return -1L;
        }
        try {
            long l2 = s_snd_Player[n].setMediaTime(l);
            return l2;
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    static boolean Snd_MidiSetChannelVolume(int n, int n2, int n3) throws Exception {
        MIDIControl mIDIControl;
        if (!s_snd_isSoundEngineInitialized) {
            return false;
        }
        if (GLLibConfig.sound_useJSR135 && (mIDIControl = (MIDIControl)s_snd_Player[n].getControl("MIDIControl")) != null) {
            mIDIControl.shortMidiEvent(0xB0 | n2, 7, n3);
            return true;
        }
        return false;
    }

    static void Snd_MidiPlayNote(int n, int n2, int n3, int n4) throws Exception {
        if (!s_snd_isSoundEngineInitialized) {
            return;
        }
        if (GLLibConfig.sound_useJSR135) {
            MIDIControl mIDIControl = (MIDIControl)s_snd_Player[n].getControl("MIDIControl");
            if (mIDIControl == null) {
                return;
            }
            mIDIControl.shortMidiEvent(0x90 | n2, n3, n4);
        }
    }

    static int Snd_TempoGet(int n) throws Exception {
        if (!s_snd_isSoundEngineInitialized) {
            return -1;
        }
        if (GLLibConfig.sound_useJSR135) {
            try {
                TempoControl tempoControl = (TempoControl)s_snd_Player[n].getControl("TempoControl");
                if (tempoControl != null) {
                    return tempoControl.getTempo();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    static boolean Snd_TempoSet(int n, int n2) throws Exception {
        TempoControl tempoControl;
        if (!s_snd_isSoundEngineInitialized) {
            return false;
        }
        if (GLLibConfig.sound_useJSR135 && (tempoControl = (TempoControl)s_snd_Player[n].getControl("TempoControl")) != null) {
            tempoControl.setTempo(n2);
            return true;
        }
        return false;
    }

    static int Snd_RateGet(int n) {
        if (!s_snd_isSoundEngineInitialized) {
            return -1;
        }
        if (GLLibConfig.sound_useJSR135) {
            try {
                RateControl rateControl = (RateControl)s_snd_Player[n].getControl("RateControl");
                if (rateControl != null) {
                    return rateControl.getRate();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    static boolean Snd_RateSet(int n, int n2) throws Exception {
        RateControl rateControl;
        if (!s_snd_isSoundEngineInitialized) {
            return false;
        }
        if (GLLibConfig.sound_useJSR135 && (rateControl = (RateControl)s_snd_Player[n].getControl("RateControl")) != null) {
            rateControl.setRate(n2);
            return true;
        }
        return false;
    }

    static int Snd_RateGetMax(int n) throws Exception {
        RateControl rateControl;
        if (!s_snd_isSoundEngineInitialized) {
            return 100000;
        }
        if (GLLibConfig.sound_useJSR135 && (rateControl = (RateControl)s_snd_Player[n].getControl("RateControl")) != null) {
            return rateControl.getMaxRate();
        }
        return 100000;
    }

    static int Snd_RateGetMin(int n) throws Exception {
        RateControl rateControl;
        if (!s_snd_isSoundEngineInitialized) {
            return 100000;
        }
        if (GLLibConfig.sound_useJSR135 && (rateControl = (RateControl)s_snd_Player[n].getControl("RateControl")) != null) {
            return rateControl.getMinRate();
        }
        return 100000;
    }

    static long Snd_DurationGet(int n) throws Exception {
        if (!s_snd_isSoundEngineInitialized) {
            return 0L;
        }
        if (GLLibConfig.sound_useJSR135) {
            return s_snd_Player[n].getDuration();
        }
        return 0L;
    }

    static void Snd_PauseNotify() {
        if (!(!GLLibConfig.sound_useStopSoundsOnInterrupt || s_snd_IgnoreSoundsOnInterrupt && GLLibConfig.sound_allowURLCreation)) {
            try {
                GLLibPlayer.Snd_StopAllSounds();
                if (GLLibConfig.sound_enableThread && GLLib.s_game_isPaused) {
                    GLLibPlayer.Snd_Update_Exec();
                }
            }
            catch (Exception exception) {
                GLLib.Dbg("Snd_PauseNotify: exception!");
            }
        }
    }

    static void Snd_AddPlayerListener() {
        GLLib.Dbg("Snd_AddPlayerListener: Not implemented for this platform!");
    }

    static void Tileset_Init(int n, int n2, int n3, int n4) {
        s_TilesetInfo = new int[8];
        s_TilesetLayerInfo = new int[s_TilesetMaxLayerCount][15];
        s_TilesetLayerData = new byte[s_TilesetMaxLayerCount][2][];
        s_TilesetLayerImage = new Image[s_TilesetMaxLayerCount][1];
        s_TilesetLayerGraphics = new Graphics[s_TilesetMaxLayerCount][1];
        s_TilesetSprite = new ASprite[s_TilesetMaxLayerCount];
        GLLibPlayer.s_TilesetInfo[0] = n;
        GLLibPlayer.s_TilesetInfo[1] = n2;
        if (GLLibConfig.tileset_useTileShift) {
            int n5 = n3;
            int n6 = n4;
            n3 = GLLib.Math_Log2(n3);
            n4 = GLLib.Math_Log2(n4);
            if (1 << n3 != n5) {
                GLLib.Assert(false, "Tileset_Init. using GLLibConfig.tileset_UseTileShift with non power of 2 tile width" + n3);
            }
            if (1 << n4 != n6) {
                GLLib.Assert(false, "Tileset_Init. using GLLibConfig.tileset_UseTileShift with non power of 2 tile height" + n4);
            }
            GLLibPlayer.s_TilesetInfo[3] = n3;
            GLLibPlayer.s_TilesetInfo[2] = 1 << n3;
            GLLibPlayer.s_TilesetInfo[4] = s_TilesetInfo[2] - 1;
            GLLibPlayer.s_TilesetInfo[6] = n4;
            GLLibPlayer.s_TilesetInfo[5] = 1 << n4;
            GLLibPlayer.s_TilesetInfo[7] = s_TilesetInfo[5] - 1;
        } else {
            GLLibPlayer.s_TilesetInfo[2] = n3;
            GLLibPlayer.s_TilesetInfo[4] = 0;
            GLLibPlayer.s_TilesetInfo[5] = n4;
            GLLibPlayer.s_TilesetInfo[7] = 0;
        }
        s_bTilesetPlayerInitialized = true;
    }

    private static final boolean isFlag(int n, int n2) {
        return (s_TilesetLayerInfo[n][14] & n2) != 0;
    }

    private static final void setFlag(int n, int n2, boolean bl) {
        if (bl) {
            int[] nArray = s_TilesetLayerInfo[n];
            nArray[14] = nArray[14] | n2;
        } else {
            int[] nArray = s_TilesetLayerInfo[n];
            nArray[14] = nArray[14] & ~n2;
        }
    }

    static void Tileset_LoadLayer(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, ASprite aSprite, boolean bl, int n2, int n3, int n4) {
        if (bl) {
            GLLibPlayer.Tileset_LoadLayer(n, byArray, byArray2, byArray3, aSprite, n, n2, n3, n4);
        } else {
            GLLibPlayer.Tileset_LoadLayer(n, byArray, byArray2, byArray3, aSprite, -1, n2, n3, n4);
        }
    }

    static void Tileset_LoadLayer(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, ASprite aSprite, int n2, int n3, int n4, int n5) {
        if (byArray == null) {
            GLLib.Assert(false, "GLLibPlayer.Tileset_LoadLayer.MapSizes is null");
        }
        if (byArray2 == null) {
            GLLib.Assert(false, "GLLibPlayer.Tileset_LoadLayer.MapData is null");
        }
        if (aSprite == null) {
            GLLib.Assert(false, "GLLibPlayer.Tileset_LoadLayer.MapSprite is null");
        }
        if (n4 != 0 && n4 != 1 && n4 != 2) {
            GLLib.Assert(false, "GLLibPlayer.Tileset_LoadLayer. X wrapping is not valid");
        }
        if (n5 != 0 && n5 != 1 && n5 != 2) {
            GLLib.Assert(false, "GLLibPlayer.Tileset_LoadLayer. Y wrapping is not valid");
        }
        if (n3 != 16 && n3 != 32) {
            GLLib.Assert(false, "GLLibPlayer.Tileset_LoadLayer. origin is not valid");
        }
        if (byArray3 == null) {
            GLLib.Dbg("WARNING GLLibPlayer.Tileset_LoadLayer.MapFlip is null, no flip will occur");
        }
        if (!s_bTilesetPlayerInitialized) {
            return;
        }
        GLLibPlayer.Tileset_Destroy(n, false);
        GLLibPlayer.s_TilesetLayerData[n][0] = byArray2;
        GLLibPlayer.s_TilesetLayerData[n][1] = byArray3;
        GLLibPlayer.s_TilesetLayerInfo[n][2] = GLLib.Mem_GetShort(byArray, 0);
        GLLibPlayer.s_TilesetLayerInfo[n][3] = GLLib.Mem_GetShort(byArray, 2);
        GLLibPlayer.s_TilesetLayerInfo[n][4] = s_TilesetLayerInfo[n][2] * s_TilesetInfo[2];
        GLLibPlayer.s_TilesetLayerInfo[n][5] = s_TilesetLayerInfo[n][3] * s_TilesetInfo[5];
        GLLibPlayer.s_TilesetSprite[n] = aSprite;
        if (n2 > -1) {
            try {
                if (GLLibConfig.tileset_useTileShift) {
                    GLLibPlayer.s_TilesetLayerInfo[n][6] = (s_TilesetInfo[0] & ~s_TilesetInfo[4]) + 1 * s_TilesetInfo[2];
                    GLLibPlayer.s_TilesetLayerInfo[n][7] = (s_TilesetInfo[1] & ~s_TilesetInfo[7]) + 1 * s_TilesetInfo[5];
                    if (s_TilesetLayerInfo[n][6] - s_TilesetInfo[0] < s_TilesetInfo[2]) {
                        int[] nArray = s_TilesetLayerInfo[n];
                        nArray[6] = nArray[6] + s_TilesetInfo[2];
                    }
                    if (s_TilesetLayerInfo[n][7] - s_TilesetInfo[1] < s_TilesetInfo[5]) {
                        int[] nArray = s_TilesetLayerInfo[n];
                        nArray[7] = nArray[7] + s_TilesetInfo[5];
                    }
                } else {
                    int n6 = s_TilesetInfo[0] % s_TilesetInfo[2];
                    int n7 = 1 + (n6 != 0 ? 1 : 0);
                    GLLibPlayer.s_TilesetLayerInfo[n][6] = s_TilesetInfo[0] - n6 + n7 * s_TilesetInfo[2];
                    int n8 = s_TilesetInfo[1] % s_TilesetInfo[5];
                    int n9 = 1 + (n8 != 0 ? 1 : 0);
                    GLLibPlayer.s_TilesetLayerInfo[n][7] = s_TilesetInfo[1] - n8 + n9 * s_TilesetInfo[5];
                }
                if (n2 == n) {
                    if (s_TilesetLayerImage[n][0] == null || s_TilesetLayerImage[n][0].getWidth() != s_TilesetLayerInfo[n][6] || s_TilesetLayerImage[n][0].getHeight() != s_TilesetLayerInfo[n][7]) {
                        GLLibPlayer.s_TilesetLayerImage[n][0] = GLLibConfig.sprite_useResize && ASprite.s_resizeOn ? Image.createImage((int)ASprite.scaleX(s_TilesetLayerInfo[n][6]), (int)ASprite.scaleY(s_TilesetLayerInfo[n][7])) : Image.createImage((int)s_TilesetLayerInfo[n][6], (int)s_TilesetLayerInfo[n][7]);
                        GLLibPlayer.s_TilesetLayerGraphics[n][0] = s_TilesetLayerImage[n][0].getGraphics();
                    }
                } else {
                    if (s_TilesetLayerImage[n2][0] == null) {
                        GLLib.Assert(false, "GLLibPlayer.Tileset_LoadLayer. layer " + n2 + " has no circular buffer allocated");
                    }
                    GLLibPlayer.s_TilesetLayerImage[n][0] = s_TilesetLayerImage[n2][0];
                    GLLibPlayer.s_TilesetLayerGraphics[n][0] = s_TilesetLayerGraphics[n2][0];
                }
                GLLibPlayer.setFlag(n, 4, true);
            }
            catch (Exception exception) {
                GLLib.Assert(false, "GLLibPlayer.Tileset_LoadLayer.pb while ceating circular buffer : " + exception.toString());
            }
        }
        GLLibPlayer.s_TilesetLayerInfo[n][8] = -1;
        GLLibPlayer.s_TilesetLayerInfo[n][9] = -1;
        GLLibPlayer.s_TilesetLayerInfo[n][10] = -1;
        GLLibPlayer.s_TilesetLayerInfo[n][11] = -1;
        GLLibPlayer.s_TilesetLayerInfo[n][0] = 1;
        GLLibPlayer.s_TilesetLayerInfo[n][1] = 1;
        GLLibPlayer.s_TilesetLayerInfo[n][12] = 0;
        GLLibPlayer.s_TilesetLayerInfo[n][13] = 0;
        GLLibPlayer.setFlag(n, 1, n4 == 1);
        GLLibPlayer.setFlag(n, 16, n4 == 0);
        GLLibPlayer.setFlag(n, 2, n5 == 1);
        GLLibPlayer.setFlag(n, 32, n5 == 0);
        GLLibPlayer.setFlag(n, 8, n3 == 32);
    }

    static void Tileset_Destroy(int n) {
        GLLibPlayer.Tileset_Destroy(n, true);
    }

    static void Tileset_Destroy(int n, boolean bl) {
        if (!s_bTilesetPlayerInitialized) {
            return;
        }
        GLLibPlayer.s_TilesetLayerInfo[n] = new int[15];
        if (bl) {
            GLLibPlayer.s_TilesetLayerImage[n] = new Image[1];
            GLLibPlayer.s_TilesetLayerGraphics[n] = new Graphics[1];
        }
        GLLibPlayer.s_TilesetLayerData[n] = new byte[2][];
        GLLibPlayer.s_TilesetSprite[n] = null;
    }

    static void Tileset_Draw(Graphics graphics, int n) {
        GLLibPlayer.Tileset_Draw(graphics, 0, 0, n);
    }

    static void Tileset_Draw(Graphics graphics, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        block42: {
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            int n15;
            int n16;
            int n17;
            block41: {
                boolean bl;
                block48: {
                    block46: {
                        block47: {
                            block45: {
                                block43: {
                                    block44: {
                                        int n18;
                                        int n19;
                                        int n20;
                                        int n21;
                                        int n22;
                                        int n23;
                                        if (!s_bTilesetPlayerInitialized) {
                                            return;
                                        }
                                        n7 = 0;
                                        n6 = 0;
                                        n5 = 0;
                                        n4 = 0;
                                        if (graphics != null) {
                                            n7 = graphics.getClipX();
                                            n6 = graphics.getClipY();
                                            n5 = graphics.getClipWidth();
                                            n4 = graphics.getClipHeight();
                                        }
                                        n17 = s_TilesetInfo[0];
                                        n16 = s_TilesetInfo[1];
                                        if (n3 == -1) {
                                            for (int i = 0; i < s_TilesetMaxLayerCount; ++i) {
                                                if (GLLibConfig.tileset_usePixelEffects) {
                                                    if (i == s_TilesetAlphaLayer) continue;
                                                    GLLibPlayer.Tileset_Draw(graphics, n, n2, i);
                                                    continue;
                                                }
                                                GLLibPlayer.Tileset_Draw(graphics, n, n2, i);
                                            }
                                            return;
                                        }
                                        if (s_TilesetLayerInfo[n3][0] != 1 || s_TilesetLayerInfo[n3][1] != 1) {
                                            return;
                                        }
                                        GLLib.Profiler_BeginNamedEvent("Tileset_Draw");
                                        n15 = s_TilesetLayerInfo[n3][12];
                                        n14 = s_TilesetLayerInfo[n3][13];
                                        if (!GLLibPlayer.isFlag(n3, 4)) break block41;
                                        if (GLLibConfig.tileset_useTileShift) {
                                            n23 = n15 >> s_TilesetInfo[3];
                                            n22 = n14 >> s_TilesetInfo[6];
                                            n21 = n15 + s_TilesetInfo[0] >> s_TilesetInfo[3];
                                            n20 = n14 + s_TilesetInfo[1] >> s_TilesetInfo[6];
                                        } else {
                                            n19 = n15;
                                            n18 = n14;
                                            if (n19 < 0) {
                                                n19 -= s_TilesetInfo[2];
                                            }
                                            if (n18 < 0) {
                                                n18 -= s_TilesetInfo[5];
                                            }
                                            n23 = n19 / s_TilesetInfo[2];
                                            n22 = n18 / s_TilesetInfo[5];
                                            n21 = n23 + s_TilesetLayerInfo[n3][6] / s_TilesetInfo[2] - 1;
                                            n20 = n22 + s_TilesetLayerInfo[n3][7] / s_TilesetInfo[5] - 1;
                                        }
                                        if (s_TilesetLayerInfo[n3][8] != n23 || s_TilesetLayerInfo[n3][10] != n21) {
                                            if (s_TilesetLayerInfo[n3][8] < n23 || s_TilesetLayerInfo[n3][10] < n21) {
                                                if (s_TilesetLayerInfo[n3][10] < n23) {
                                                    n19 = n23;
                                                    n18 = n21;
                                                } else {
                                                    n19 = s_TilesetLayerInfo[n3][10] + 1;
                                                    n18 = n21;
                                                }
                                            } else if (s_TilesetLayerInfo[n3][8] > n21) {
                                                n19 = n23;
                                                n18 = n21;
                                            } else {
                                                n19 = n23;
                                                n18 = s_TilesetLayerInfo[n3][8] - 1;
                                            }
                                            GLLibPlayer.Tileset_UpdateBuffer(s_TilesetLayerGraphics[n3][0], n3, n19, n22, n18 - n19, n20 - n22, 0, 0);
                                            GLLibPlayer.s_TilesetLayerInfo[n3][8] = n23;
                                            GLLibPlayer.s_TilesetLayerInfo[n3][10] = n21;
                                        }
                                        if (s_TilesetLayerInfo[n3][9] != n22 || s_TilesetLayerInfo[n3][11] != n20) {
                                            if (s_TilesetLayerInfo[n3][9] < n22 || s_TilesetLayerInfo[n3][11] < n20) {
                                                if (s_TilesetLayerInfo[n3][11] < n22) {
                                                    n19 = n22;
                                                    n18 = n20;
                                                } else {
                                                    n19 = s_TilesetLayerInfo[n3][11] + 1;
                                                    n18 = n20;
                                                }
                                            } else if (s_TilesetLayerInfo[n3][9] > n20) {
                                                n19 = n22;
                                                n18 = n20;
                                            } else {
                                                n19 = n22;
                                                n18 = s_TilesetLayerInfo[n3][9] - 1;
                                            }
                                            GLLibPlayer.Tileset_UpdateBuffer(s_TilesetLayerGraphics[n3][0], n3, n23, n19, n21 - n23, n18 - n19, 0, 0);
                                            GLLibPlayer.s_TilesetLayerInfo[n3][9] = n22;
                                            GLLibPlayer.s_TilesetLayerInfo[n3][11] = n20;
                                        }
                                        if (graphics == null) break block42;
                                        bl = false;
                                        if (GLLibPlayer.isFlag(n3, 17)) break block43;
                                        if (n15 >= 0) break block44;
                                        n -= n15;
                                        n15 = 0;
                                        bl = true;
                                        break block45;
                                    }
                                    if (n15 <= s_TilesetLayerInfo[n3][4] - n17) break block45;
                                    n -= n15 - (s_TilesetLayerInfo[n3][4] - n17);
                                    n15 = s_TilesetLayerInfo[n3][4] - n17;
                                    bl = true;
                                    break block45;
                                }
                                while (n15 < 0) {
                                    n15 += s_TilesetLayerInfo[n3][6];
                                }
                            }
                            if (GLLibPlayer.isFlag(n3, 34)) break block46;
                            if (n14 >= 0) break block47;
                            n2 -= n14;
                            n14 = 0;
                            bl = true;
                            break block48;
                        }
                        if (n14 <= s_TilesetLayerInfo[n3][5] - n16) break block48;
                        n2 -= n14 - (s_TilesetLayerInfo[n3][5] - n16);
                        n14 = s_TilesetLayerInfo[n3][5] - n16;
                        bl = true;
                        break block48;
                    }
                    while (n14 < 0) {
                        n14 += s_TilesetLayerInfo[n3][7];
                    }
                }
                int n24 = n15 % s_TilesetLayerInfo[n3][6];
                int n25 = n14 % s_TilesetLayerInfo[n3][7];
                int n26 = (n15 + n17) % s_TilesetLayerInfo[n3][6];
                int n27 = (n14 + n16) % s_TilesetLayerInfo[n3][7];
                if (n26 > n24) {
                    if (n27 > n25) {
                        GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n24, n25, n17, n16, 0 + n, 0 + n2, bl);
                    } else {
                        GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n24, n25, n17, n16 - n27, 0 + n, 0 + n2, bl);
                        GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n24, 0, n17, n27, 0 + n, n16 - n27 + n2, bl);
                    }
                } else if (n27 > n25) {
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n24, n25, n17 - n26, n16, 0 + n, 0 + n2, bl);
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, 0, n25, n26, n16, n17 - n26 + n, 0 + n2, bl);
                } else {
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n24, n25, n17 - n26, n16 - n27, 0 + n, 0 + n2, bl);
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, n24, 0, n17 - n26, n27, 0 + n, n16 - n27 + n2, bl);
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, 0, n25, n26, n16 - n27, n17 - n26 + n, 0 + n2, bl);
                    GLLibPlayer.Tileset_Draw2Screen(graphics, n3, 0, 0, n26, n27, n17 - n26 + n, n16 - n27 + n2, bl);
                }
                break block42;
            }
            if (GLLibConfig.tileset_useTileShift) {
                n13 = n15 >> s_TilesetInfo[3];
                n12 = n14 >> s_TilesetInfo[6];
                n11 = n17 >> s_TilesetInfo[3];
                if (n11 << s_TilesetInfo[3] < n17) {
                    ++n11;
                }
                if ((n10 = n16 >> s_TilesetInfo[6]) << s_TilesetInfo[6] < n16) {
                    ++n10;
                }
                n9 = (n13 << s_TilesetInfo[3]) - n15;
                n8 = (n12 << s_TilesetInfo[6]) - n14;
            } else {
                int n28 = n15;
                int n29 = n14;
                if (n28 < 0) {
                    n28 -= s_TilesetInfo[2];
                }
                if (n29 < 0) {
                    n29 -= s_TilesetInfo[5];
                }
                n13 = n28 / s_TilesetInfo[2];
                n12 = n29 / s_TilesetInfo[5];
                n11 = n17 / s_TilesetInfo[2];
                if (n11 * s_TilesetInfo[2] < n17) {
                    ++n11;
                }
                if ((n10 = n16 / s_TilesetInfo[5]) * s_TilesetInfo[5] < n16) {
                    ++n10;
                }
                n9 = n13 * s_TilesetInfo[2] - n15;
                n8 = n12 * s_TilesetInfo[5] - n14;
            }
            GLLibPlayer.Tileset_UpdateBuffer(graphics, n3, n13, n12, n11, n10, n9 + n, n8 + n2);
        }
        if (graphics != null) {
            graphics.setClip(n7, n6, n5, n4);
        }
        GLLib.Profiler_EndNamedEvent();
    }

    private static void Tileset_Draw2Screen(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        if (GLLibConfig.sprite_useResize && ASprite.s_resizeOn) {
            n2 = ASprite.scaleX(n2);
            n3 = ASprite.scaleY(n3);
            n4 = ASprite.scaleX(n4);
            n5 = ASprite.scaleY(n5);
            n6 = ASprite.scaleX(n6);
            n7 = ASprite.scaleY(n7);
        }
        if (bl) {
            if (n6 > GLLib.s_screenWidth || n7 > GLLib.s_screenHeight || n6 + n4 < 0 || n7 + n5 < 0) {
                return;
            }
            graphics.setClip(n6, n7, n4, n5);
            graphics.clipRect(0, 0, GLLib.s_screenWidth, GLLib.s_screenHeight);
            graphics.drawImage(s_TilesetLayerImage[n][0], n6 - n2, n7 - n3, 0);
        } else {
            graphics.setClip(n6, n7, n4, n5);
            graphics.drawImage(s_TilesetLayerImage[n][0], n6 - n2, n7 - n3, 0);
        }
    }

    static void Tileset_Update(int n) {
        GLLib.Warning("GLLibPlayer.Tileset_Update(int nLayer) . this function is deprecated, you can stop using it");
    }

    private static void Tileset_UpdateBuffer(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8;
        int n9;
        boolean bl = GLLibPlayer.isFlag(n, 4);
        boolean bl2 = GLLibPlayer.isFlag(n, 1);
        boolean bl3 = GLLibPlayer.isFlag(n, 2);
        int n10 = s_TilesetLayerInfo[n][2];
        int n11 = s_TilesetLayerInfo[n][3];
        byte[] byArray = s_TilesetLayerData[n][0];
        byte[] byArray2 = s_TilesetLayerData[n][1];
        int n12 = s_TilesetInfo[2];
        int n13 = s_TilesetInfo[5];
        if (bl) {
            if (GLLibConfig.tileset_useTileShift) {
                n9 = (n2 << s_TilesetInfo[3]) % s_TilesetLayerInfo[n][6] + n6;
                n8 = (n3 << s_TilesetInfo[6]) % s_TilesetLayerInfo[n][7] + n7;
            } else {
                n9 = n2 * s_TilesetInfo[2] % s_TilesetLayerInfo[n][6] + n6;
                n8 = n3 * s_TilesetInfo[5] % s_TilesetLayerInfo[n][7] + n7;
            }
            if (n9 < 0) {
                n9 += s_TilesetLayerInfo[n][6];
            }
            if (n8 < 0) {
                n8 += s_TilesetLayerInfo[n][7];
            }
        } else {
            n9 = n6;
            n8 = n7;
        }
        if (bl2) {
            while (n2 < 0) {
                n2 += n10;
            }
            while (n2 >= n10) {
                n2 -= n10;
            }
        } else if (!GLLibPlayer.isFlag(n, 16)) {
            if (n2 < 0) {
                n9 -= n2 * n12;
                n4 += n2;
                n2 = 0;
                if (bl && n9 >= s_TilesetLayerInfo[n][6]) {
                    n9 = 0;
                }
            }
            if (n2 + n4 >= n10) {
                n4 = n10 - n2 - 1;
            }
            if (n4 < 0) {
                return;
            }
        }
        if (bl3) {
            while (n3 < 0) {
                n3 += n11;
            }
            while (n3 >= n11) {
                n3 -= n11;
            }
        } else if (!GLLibPlayer.isFlag(n, 32)) {
            if (n3 < 0) {
                n8 -= n3 * n13;
                n5 += n3;
                n3 = 0;
                if (bl && n8 >= s_TilesetLayerInfo[n][7]) {
                    n8 = 0;
                }
            }
            if (n3 + n5 >= n11) {
                n5 = n11 - n3 - 1;
            }
            if (n5 < 0) {
                return;
            }
        }
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        if (GLLibConfig.tileset_usePixelEffects && n == s_TilesetEffectLayer && s_TilesetAlphaLayer > 0) {
            byArray3 = s_TilesetLayerData[s_TilesetAlphaLayer][0];
            byArray4 = s_TilesetLayerData[s_TilesetAlphaLayer][1];
        }
        while (n5-- >= 0) {
            int n14 = n9;
            int n15 = n4;
            int n16 = n2;
            while (n15-- >= 0) {
                int n17 = n16 + n3 * n10;
                if (!GLLibConfig.tileset_useIndexAsShort && n17 < byArray.length || GLLibConfig.tileset_useIndexAsShort && n17 << 1 < byArray.length) {
                    boolean bl4;
                    int n18;
                    if (GLLibConfig.tileset_useIndexAsShort) {
                        n18 = GLLib.Mem_GetShort(byArray, n17 << 1) & 0xFFFF;
                        bl4 = n18 == 65535;
                    } else {
                        n18 = byArray[n17] & 0xFF;
                        boolean bl5 = bl4 = n18 == 255;
                    }
                    if (!bl4) {
                        int n19;
                        int n20 = byArray2 == null ? 0 : byArray2[n17] & 0xFF;
                        if (GLLib.pfx_useSpriteEffects) {
                            if (GLLib.PFX_IsEffectEnabled(11)) {
                                GLLib.Assert(false, "Tileset_UpdateBuffer: Warning PFX Scaling is enabled on the tileset!");
                            }
                            if (GLLib.PFX_IsEffectEnabled(10)) {
                                GLLib.Assert(false, "Tileset_UpdateBuffer: Warning PFX Blend is enabled on the tileset!");
                            }
                            if (GLLib.PFX_IsEffectEnabled(5)) {
                                GLLib.Assert(false, "Tileset_UpdateBuffer: Warning PFX Additive is enabled on the tileset, please see Tileset_SetAlphaEffects!");
                            }
                            if (GLLib.PFX_IsEffectEnabled(6)) {
                                GLLib.Assert(false, "Tileset_UpdateBuffer: Warning PFX Multiplicatie is enabled on the tileset, please see Tileset_SetAlphaEffects!");
                            }
                        }
                        if (s_TilesetSprite[n].GetFrameCount() == 0) {
                            s_TilesetSprite[n].PaintModule(graphics, n18, n14, n8, n20);
                        } else {
                            n19 = n14;
                            int n21 = n8;
                            if (GLLibConfig.sprite_useTransfFlip) {
                                if ((n20 & 1) != 0) {
                                    n19 += s_TilesetInfo[2];
                                }
                                if ((n20 & 2) != 0) {
                                    n21 += s_TilesetInfo[5];
                                }
                            }
                            int n22 = n20;
                            int n23 = n21;
                            int n24 = n19;
                            int n25 = n18;
                            Graphics graphics2 = graphics;
                            ASprite aSprite = s_TilesetSprite[n];
                            aSprite.PaintFrame(graphics2, n25, n24, n23, n22, 0, 0);
                        }
                        if (GLLibConfig.tileset_usePixelEffects && n == s_TilesetEffectLayer && s_TilesetAlphaLayer > 0) {
                            boolean bl6;
                            int n26;
                            if (GLLibConfig.tileset_useIndexAsShort) {
                                n26 = GLLib.Mem_GetShort(byArray3, n17 << 1) & 0xFFFF;
                                bl6 = n26 == 65535;
                            } else {
                                n26 = byArray3[n17] & 0xFF;
                                boolean bl7 = bl6 = n26 == 255;
                            }
                            if (!bl6) {
                                n19 = 0;
                                if (byArray4 != null) {
                                    n19 = byArray4[n17] & 0xFF;
                                }
                                if (s_TilesetSprite[s_TilesetAlphaLayer].GetFrameCount() != 0) {
                                    n26 = s_TilesetSprite[s_TilesetAlphaLayer].GetFrameModule(n26, 0);
                                }
                                if (s_TilesetEffectType == 2 || s_TilesetEffectType == 3) {
                                    s_TilesetSprite[s_TilesetAlphaLayer].RenderTilesetEffect(graphics, n26, s_TilesetLayerImage[n][0], s_TilesetEffectType, n14, n8, n12, n13, n19);
                                } else if (s_TilesetEffectType == 1) {
                                    s_TilesetSprite[s_TilesetAlphaLayer].PaintModule(graphics, n26, n14, n8, n19);
                                }
                            }
                        }
                    }
                }
                if (++n16 >= n10) {
                    if (!bl2) break;
                    n16 = 0;
                }
                if (!bl || (n14 += n12) < s_TilesetLayerInfo[n][6]) continue;
                n14 = 0;
            }
            if (++n3 >= n11) {
                if (!bl3) break;
                n3 = 0;
            }
            if (!bl || (n8 += n13) < s_TilesetLayerInfo[n][7]) continue;
            n8 = 0;
        }
    }

    private static final int Tileset_GetTranslatedOriginY(int n, int n2) {
        if (GLLibPlayer.isFlag(n, 8)) {
            return s_TilesetLayerInfo[n][5] - s_TilesetInfo[1] - n2;
        }
        return n2;
    }

    static final void Tileset_SetCamera(int n, int n2, int n3) {
        if (!s_bTilesetPlayerInitialized) {
            GLLib.Assert(false, "Tileset_SetCamera: Tileset player is not initialized");
            return;
        }
        if (n < 0 || n >= s_TilesetMaxLayerCount) {
            GLLib.Assert(false, "Tileset_SetCamera: nLayer invalid : " + n);
            return;
        }
        if (s_TilesetLayerInfo[n][0] != 1 || s_TilesetLayerInfo[n][1] != 1) {
            GLLib.Assert(false, "Tileset_SetCamera: nLayer in not initialized or not enabled.");
            return;
        }
        GLLibPlayer.s_TilesetLayerInfo[n][12] = n2;
        GLLibPlayer.s_TilesetLayerInfo[n][13] = GLLibPlayer.Tileset_GetTranslatedOriginY(n, n3);
        if (GLLibPlayer.isFlag(n, 16)) {
            if (s_TilesetLayerInfo[n][12] < 0) {
                GLLibPlayer.s_TilesetLayerInfo[n][12] = 0;
            } else if (s_TilesetLayerInfo[n][12] + s_TilesetInfo[0] > s_TilesetLayerInfo[n][4]) {
                GLLibPlayer.s_TilesetLayerInfo[n][12] = s_TilesetLayerInfo[n][4] - s_TilesetInfo[0];
            }
        }
        if (GLLibPlayer.isFlag(n, 32)) {
            if (s_TilesetLayerInfo[n][13] < 0) {
                GLLibPlayer.s_TilesetLayerInfo[n][13] = 0;
            } else if (s_TilesetLayerInfo[n][13] + s_TilesetInfo[1] > s_TilesetLayerInfo[n][5]) {
                GLLibPlayer.s_TilesetLayerInfo[n][13] = s_TilesetLayerInfo[n][5] - s_TilesetInfo[1];
            }
        }
    }

    static final int[] Tileset_GetCamera(int n) {
        GLLib.Warning("GLLibPlayer.Tileset_GetCamera(int nLayer) . this function is deprecated, use GLLibPlayer.Tileset_GetCameraX(int nLayer) and GLLibPlayer.Tileset_GetCameraY(int nLayer) instead");
        int[] nArray = new int[]{GLLibPlayer.Tileset_GetCameraX(n), GLLibPlayer.Tileset_GetCameraY(n)};
        return nArray;
    }

    static final int Tileset_GetCameraX(int n) {
        if (!s_bTilesetPlayerInitialized) {
            GLLib.Assert(false, "Tileset_GetCamera: Tileset player is not initialized");
            return -1;
        }
        if (n < 0 || n >= s_TilesetMaxLayerCount) {
            GLLib.Assert(false, "Tileset_GetCamera: nLayer invalid : " + n);
            return -1;
        }
        if (s_TilesetLayerInfo[n][0] != 1 || s_TilesetLayerInfo[n][1] != 1) {
            GLLib.Assert(false, "Tileset_GetCamera: nLayer in not initialized or not enabled.");
            return -1;
        }
        return s_TilesetLayerInfo[n][12];
    }

    static final int Tileset_GetCameraY(int n) {
        if (!s_bTilesetPlayerInitialized) {
            GLLib.Assert(false, "Tileset_GetCamera: Tileset player is not initialized");
            return -1;
        }
        if (n < 0 || n >= s_TilesetMaxLayerCount) {
            GLLib.Assert(false, "Tileset_GetCamera: nLayer invalid : " + n);
            return -1;
        }
        if (s_TilesetLayerInfo[n][0] != 1 || s_TilesetLayerInfo[n][1] != 1) {
            GLLib.Assert(false, "Tileset_GetCamera: nLayer in not initialized or not enabled.");
            return -1;
        }
        if (GLLibPlayer.isFlag(n, 8)) {
            return s_TilesetLayerInfo[n][5] - s_TilesetInfo[1] - s_TilesetLayerInfo[n][13];
        }
        return s_TilesetLayerInfo[n][13];
    }

    static final int Tileset_GetLayerWidth(int n) {
        if (!s_bTilesetPlayerInitialized) {
            GLLib.Assert(false, "Tileset_GetLayerWidth: Tileset player is not initialized");
            return -1;
        }
        if (n < 0 || n >= s_TilesetMaxLayerCount) {
            GLLib.Assert(false, "Tileset_GetLayerWidth: nLayer invalid : " + n);
            return -1;
        }
        if (s_TilesetLayerInfo[n][0] != 1 || s_TilesetLayerInfo[n][1] != 1) {
            GLLib.Assert(false, "Tileset_GetLayerWidth: nLayer in not initialized or not enabled.");
            return -1;
        }
        return s_TilesetLayerInfo[n][4];
    }

    static final int Tileset_GetLayerHeight(int n) {
        if (!s_bTilesetPlayerInitialized) {
            GLLib.Assert(false, "Tileset_GetLayerHeight: Tileset player is not initialized");
            return -1;
        }
        if (n < 0 || n >= s_TilesetMaxLayerCount) {
            GLLib.Assert(false, "Tileset_GetLayerHeight: nLayer invalid : " + n);
            return -1;
        }
        if (s_TilesetLayerInfo[n][0] != 1 || s_TilesetLayerInfo[n][1] != 1) {
            GLLib.Assert(false, "Tileset_GetLayerHeight: nLayer in not initialized or not enabled.");
            return -1;
        }
        return s_TilesetLayerInfo[n][5];
    }

    static final int Tileset_GetLayerTileCountWidth(int n) {
        if (!s_bTilesetPlayerInitialized) {
            GLLib.Assert(false, "Tileset_GetLayerTileCountWidth: Tileset player is not initialized");
            return -1;
        }
        if (n < 0 || n >= s_TilesetMaxLayerCount) {
            GLLib.Assert(false, "Tileset_GetLayerTileCountWidth: nLayer invalid : " + n);
            return -1;
        }
        if (s_TilesetLayerInfo[n][0] != 1 || s_TilesetLayerInfo[n][1] != 1) {
            GLLib.Assert(false, "Tileset_GetLayerTileCountWidth: nLayer in not initialized or not enabled.");
            return -1;
        }
        return s_TilesetLayerInfo[n][2];
    }

    static final int Tileset_GetLayerTileCountHeight(int n) {
        if (!s_bTilesetPlayerInitialized) {
            GLLib.Assert(false, "Tileset_GetLayerTileCountHeight: Tileset player is not initialized");
            return -1;
        }
        if (n < 0 || n >= s_TilesetMaxLayerCount) {
            GLLib.Assert(false, "Tileset_GetLayerTileCountHeight: nLayer invalid : " + n);
            return -1;
        }
        if (s_TilesetLayerInfo[n][0] != 1 || s_TilesetLayerInfo[n][1] != 1) {
            GLLib.Assert(false, "Tileset_GetLayerTileCountHeight: nLayer in not initialized or not enabled.");
            return -1;
        }
        return s_TilesetLayerInfo[n][3];
    }

    static final int Tileset_GetTile(int n, int n2, int n3) {
        n3 = GLLibPlayer.Tileset_GetTranslatedOriginY(n, n3);
        if (!s_bTilesetPlayerInitialized) {
            GLLib.Assert(false, "Tileset_GetTile: Tileset player is not initialized");
            return -1;
        }
        if (n < 0 || n >= s_TilesetMaxLayerCount) {
            GLLib.Assert(false, "Tileset_GetTile: nLayer invalid : " + n);
            return -1;
        }
        if (s_TilesetLayerInfo[n][0] != 1 || s_TilesetLayerInfo[n][1] != 1) {
            GLLib.Assert(false, "Tileset_GetTile: nLayer in not initialized or not enabled.");
            return -1;
        }
        if (n2 < 0 || n2 > s_TilesetLayerInfo[n][2]) {
            GLLib.Assert(false, "Tileset_GetTile: x value out of bound [" + n2 + "]  0 <= x < " + s_TilesetLayerInfo[n][2]);
            return -1;
        }
        if (n3 < 0 || n3 > s_TilesetLayerInfo[n][3]) {
            GLLib.Assert(false, "Tileset_GetTile: y value out of bound [" + n3 + "]  0 <= y < " + s_TilesetLayerInfo[n][3]);
            return -1;
        }
        if (GLLibConfig.tileset_useIndexAsShort) {
            return GLLib.Mem_GetShort(s_TilesetLayerData[n][0], n3 * s_TilesetLayerInfo[n][2] + n2 << 1) & 0xFFFF;
        }
        return s_TilesetLayerData[n][0][n3 * s_TilesetLayerInfo[n][2] + n2] & 0xFF;
    }

    static final int Tileset_GetTileFlags(int n, int n2, int n3) {
        n3 = GLLibPlayer.Tileset_GetTranslatedOriginY(n, n3);
        if (!s_bTilesetPlayerInitialized) {
            GLLib.Assert(false, "Tileset_GetTileFlags: Tileset player is not initialized");
            return -1;
        }
        if (n < 0 || n >= s_TilesetMaxLayerCount) {
            GLLib.Assert(false, "Tileset_GetTileFlags: nLayer invalid : " + n);
            return -1;
        }
        if (s_TilesetLayerInfo[n][0] != 1 || s_TilesetLayerInfo[n][1] != 1) {
            GLLib.Assert(false, "Tileset_GetTileFlags: nLayer in not initialized or not enabled.");
            return -1;
        }
        if (n2 < 0 || n2 > s_TilesetLayerInfo[n][2]) {
            GLLib.Assert(false, "Tileset_GetTileFlags: x value out of bound [" + n2 + "]  0 <= x < " + s_TilesetLayerInfo[n][2]);
            return -1;
        }
        if (n3 < 0 || n3 > s_TilesetLayerInfo[n][3]) {
            GLLib.Assert(false, "Tileset_GetTileFlags: y value out of bound [" + n3 + "]  0 <= y < " + s_TilesetLayerInfo[n][3]);
            return -1;
        }
        if (s_TilesetLayerData[n][1] == null) {
            return 0;
        }
        return s_TilesetLayerData[n][1][n3 * s_TilesetLayerInfo[n][2] + n2] & 0xFF;
    }

    static final Image Tileset_GetBufferImage(int n, int n2) {
        if (!s_bTilesetPlayerInitialized) {
            GLLib.Assert(false, "Tileset_GetBufferImage: Tileset player is not initialized");
            return null;
        }
        if (n < 0 || n >= s_TilesetMaxLayerCount) {
            GLLib.Assert(false, "Tileset_GetBufferImage: p_iLayer invalid : " + n);
            return null;
        }
        if (n2 < 0 || n2 >= 1) {
            GLLib.Assert(false, "Tileset_GetBufferImage: p_iImage invalid : " + n2);
            return null;
        }
        return s_TilesetLayerImage[n][n2];
    }

    static final Graphics Tileset_GetBufferGraphics(int n, int n2) {
        if (!s_bTilesetPlayerInitialized) {
            GLLib.Assert(false, "Tileset_GetBufferGraphics: Tileset player is not initialized");
            return null;
        }
        if (n < 0 || n >= s_TilesetMaxLayerCount) {
            GLLib.Assert(false, "Tileset_GetBufferGraphics: p_iLayer invalid : " + n);
            return null;
        }
        if (n2 < 0 || n2 >= 1) {
            GLLib.Assert(false, "Tileset_GetBufferGraphics: p_iImage invalid : " + n2);
            return null;
        }
        return s_TilesetLayerGraphics[n][n2];
    }

    static void Tileset_Refresh(int n) {
        if (!s_bTilesetPlayerInitialized) {
            return;
        }
        GLLibPlayer.s_TilesetLayerInfo[n][8] = -1;
        GLLibPlayer.s_TilesetLayerInfo[n][9] = -1;
        GLLibPlayer.s_TilesetLayerInfo[n][10] = -1;
        GLLibPlayer.s_TilesetLayerInfo[n][11] = -1;
    }

    static void Tileset_SetAlphaEffects(int n, int n2, int n3) {
        if (GLLibConfig.tileset_usePixelEffects) {
            s_TilesetEffectLayer = n;
            s_TilesetAlphaLayer = n2;
            s_TilesetEffectType = n3;
        } else {
            GLLib.Dbg("Tileset_SetAlphaEffects: Effects are not enabled, you must set tileset_usePixelEffects to TRUE!");
        }
    }

    static void Tileset_SetTile(int n, int n2, int n3, int n4, int n5) {
        n3 = GLLibPlayer.Tileset_GetTranslatedOriginY(n, n3);
        if (GLLibConfig.tileset_useTileShift) {
            n2 >>= s_TilesetInfo[3];
            n3 >>= s_TilesetInfo[6];
        } else {
            n2 /= s_TilesetInfo[2];
            n3 /= s_TilesetInfo[5];
        }
        if (!s_bTilesetPlayerInitialized) {
            GLLib.Assert(false, "Tileset_SetTile: Tileset player is not initialized");
            return;
        }
        if (n < 0 || n >= s_TilesetMaxLayerCount) {
            GLLib.Assert(false, "Tileset_SetTile: layer invalid : " + n);
            return;
        }
        if (s_TilesetLayerInfo[n][0] != 1 || s_TilesetLayerInfo[n][1] != 1) {
            GLLib.Assert(false, "Tileset_SetTile: layer is not initialized or not enabled.");
            return;
        }
        if (n2 < 0 || n2 > s_TilesetLayerInfo[n][2]) {
            GLLib.Assert(false, "Tileset_SetTile: x value out of bound [" + n2 + "]  0 <= x < " + s_TilesetLayerInfo[n][2]);
            return;
        }
        if (n3 < 0 || n3 > s_TilesetLayerInfo[n][3]) {
            GLLib.Assert(false, "Tileset_SetTile: y value out of bound [" + n3 + "]  0 <= y < " + s_TilesetLayerInfo[n][3]);
            return;
        }
        n2 += n3 * s_TilesetLayerInfo[n][2];
        if (n4 != -1) {
            if (GLLibConfig.tileset_useIndexAsShort) {
                GLLib.Mem_SetShort(s_TilesetLayerData[n][0], n2 << 1, (short)n4);
            } else {
                GLLibPlayer.s_TilesetLayerData[n][0][n2] = (byte)n4;
            }
        }
        if (n5 != -1) {
            GLLibPlayer.s_TilesetLayerData[n][1][n2] = (byte)n5;
        }
    }

    static {
        s_snd_IgnoreSoundsOnInterrupt = false;
        s_bTilesetPlayerInitialized = false;
        s_TilesetMaxLayerCount = GLLibConfig.tileset_maxLayerCount;
        s_TilesetEffectLayer = -1;
        s_TilesetAlphaLayer = -1;
        s_TilesetEffectType = 0;
    }
}

