/*
 * Decompiled with CFR 0.152.
 */
package vscroller;

import de.tuttas.GameAPI.Menu;
import de.tuttas.GameAPI.MenuItem;
import de.tuttas.GameAPI.MenuListener;
import de.tuttas.GameAPI.Score.GlobalListListener;
import de.tuttas.GameAPI.Score.ScoreList;
import de.tuttas.GameAPI.Scroll;
import de.tuttas.GameAPI.ScrollListener;
import de.tuttas.GameAPI.ScrollText;
import de.tuttas.GameAPI.ScrollTextListener;
import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import vscroller.Buggy;
import vscroller.Config;
import vscroller.ConfigGeneric;
import vscroller.ConfigSound;
import vscroller.Enemy;
import vscroller.Language;
import vscroller.MyCanvas;
import vscroller.NameDisplayable;
import vscroller.Number;
import vscroller.VScroller;
import vscroller.Weg;

public class Displayable
extends MyCanvas
implements ScrollListener,
MenuListener,
GlobalListListener,
ScrollTextListener {
    public static final int PLAY = 1;
    public static final int DISAPPEAR = 2;
    public static final int FINISHED = 3;
    public static final int GAME_OVER = 4;
    public static final int LOST_LIVE = 5;
    public static final int MAIN = 6;
    public static final int SCORES = 7;
    public static final int DISPLAY_LOCAL = 8;
    public static final int LOAD_GLOBAL = 9;
    public static final int DISPLAY_GLOBAL = 10;
    public static final int SUBMIT_FINISHED = 12;
    public static final int LOAD_ERROR = 13;
    public static final int SUBMIT_START = 14;
    public static final int SUBMIT_ERROR = 15;
    public static final int HELP = 16;
    public static final int WAIT = 17;
    public static final int GMENU = 18;
    public static int state;
    long paintDuration;
    static Random random;
    public static Image frameImage;
    public static Image titelImage;
    public static Image panelImage;
    public static Scroll wall;
    int movespeed = 237;
    Buggy buggy = new Buggy(20, 116);
    int speed = 0;
    int lastmove;
    static int repaintStart;
    static int repaintStop;
    public static Number score;
    private static Number lives;
    int level;
    Image bgImage;
    int wegWidth;
    int actualWegWidth;
    Weg weg;
    ScrollText st;
    public static Enemy enemy;
    Menu m;
    MenuItem start = new MenuItem("Start", 4672199, 0x666666, Config.MENU_FONT.getSize());
    MenuItem scores = new MenuItem("Scores", 4672199, 0x666666, Config.MENU_FONT.getSize());
    MenuItem help = new MenuItem("Help", 4672199, 0x666666, Config.MENU_FONT.getSize());
    MenuItem exit = new MenuItem("Exit", 4672199, 0x666666, Config.MENU_FONT.getSize());
    Menu mScore;
    MenuItem local = new MenuItem("Local Scores", 4672199, 0x666666, Config.MENU_FONT.getSize());
    MenuItem global = new MenuItem("Global Scores", 4672199, 0x666666, Config.MENU_FONT.getSize());
    MenuItem submit = new MenuItem("Submit Score", 4672199, 0x666666, Config.MENU_FONT.getSize());
    MenuItem back = new MenuItem("Back", 4672199, 0x666666, Config.MENU_FONT.getSize());
    Menu mGame;
    MenuItem cont = new MenuItem("Continue", 4672199, 0x666666, Config.MENU_FONT.getSize());
    MenuItem gexit = new MenuItem("Exit", 4672199, 0x666666, Config.MENU_FONT.getSize());
    int rank;
    String msg = "";
    int percent = 0;

    public Displayable() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        wall = new Scroll("/elements.png", 128, 32, ConfigGeneric.wegOrder[0], 1, true);
        wall.setListener(this);
        this.weg = new Weg(9, 110);
        this.initMenu();
    }

    public void initMenu() {
        state = 6;
        try {
            titelImage = Image.createImage((String)"/titel.png");
            frameImage = Image.createImage((String)"/frame.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void jbInit() throws Exception {
        Image i = Image.createImage((String)"/segment.png");
        score = new Number(i, 4, 0);
        lives = new Number(i, 0, 0);
        enemy = new Enemy();
        this.m = new Menu(38);
        this.m.add(this.start);
        this.m.add(this.scores);
        this.m.add(this.help);
        this.m.add(this.exit);
        this.m.setListener(this);
        this.m.setVisible(true);
        this.mScore = new Menu(38);
        this.mScore.add(this.local);
        this.mScore.add(this.global);
        this.mScore.add(this.submit);
        this.mScore.add(this.back);
        this.mScore.setListener(this);
        this.mScore.setVisible(false);
        this.mGame = new Menu(Config.MENU_FONT.getHeight() + 2, 80 - Config.MENU_FONT.getHeight());
        this.mGame.add(this.cont);
        this.mGame.add(this.gexit);
        this.mGame.setListener(this);
        this.mGame.setVisible(false);
        this.st = new ScrollText(Language.HELP_TXT, 128, 160, 1);
        this.st.setListener(this);
    }

    public void keyReleased(int keyCode) {
        int action = this.getGameAction(keyCode);
        this.speed = 0;
    }

    public void restart() {
        this.actualWegWidth = 0;
        this.buggy.reset();
        wall.reset(ConfigGeneric.wegOrder[this.level % ConfigGeneric.wegOrder.length]);
        this.wegWidth = ConfigGeneric.wegOrder[this.level % ConfigGeneric.wegOrder.length].length * Displayable.wall.width - 128;
        state = 1;
        enemy.reset();
        this.movespeed = 237;
    }

    public void initGame() {
        try {
            this.bgImage = Image.createImage((String)"/bg.png");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Displayable.score.value = 0;
        Displayable.lives.value = 3;
        this.level = 0;
        this.addPauseButton();
        this.restart();
    }

    public void nextLevel() {
        ++this.level;
        this.actualWegWidth = 0;
        this.buggy.reset();
        this.buggy.x = 20;
        this.buggy.y = 116;
        enemy.reset();
        this.movespeed = 237;
        int i = this.level % ConfigGeneric.wegOrder.length;
        wall.reset(ConfigGeneric.wegOrder[i]);
        this.wegWidth = ConfigGeneric.wegOrder[i].length * Displayable.wall.width - 128;
        state = 1;
    }

    public void keyPressed(int keyCode) {
        int action = this.getGameAction(keyCode);
        if (state == 1) {
            if (keyCode == Config.SOFTKEY1 || keyCode == Config.SOFTKEY2) {
                state = 18;
                this.mGame.setVisible(true);
                this.stopThread();
                this.repaint();
                this.serviceRepaints();
            } else if (this.buggy.state != 2) {
                switch (action) {
                    case 2: {
                        this.speed = -2;
                        break;
                    }
                    case 5: {
                        this.speed = 2;
                        break;
                    }
                    case 1: {
                        this.buggy.jump();
                        break;
                    }
                    case 8: {
                        this.buggy.fire();
                    }
                    default: {
                        break;
                    }
                }
            }
        } else if (state == 18) {
            switch (action) {
                case 1: {
                    this.mGame.up();
                    break;
                }
                case 6: {
                    this.mGame.down();
                    break;
                }
                case 8: {
                    this.mGame.select();
                }
            }
            this.repaint();
        } else if (state == 3) {
            if (action == 8) {
                this.nextLevel();
            }
        } else if (state == 4) {
            if (action == 8) {
                state = 17;
                this.stopThread();
                this.repaint();
                this.serviceRepaints();
                this.bgImage = null;
                Config.waitGC();
                this.endGame();
            }
        } else if (state == 5) {
            if (action == 8) {
                this.restart();
            }
        } else if (state == 6) {
            switch (action) {
                case 2: {
                    this.m.up();
                    break;
                }
                case 5: {
                    this.m.down();
                    break;
                }
                case 8: {
                    this.m.select();
                }
            }
            this.repaint();
        } else if (state == 7) {
            switch (action) {
                case 2: {
                    this.mScore.up();
                    break;
                }
                case 5: {
                    this.mScore.down();
                    break;
                }
                case 8: {
                    this.mScore.select();
                }
            }
            this.repaint();
        } else if (state == 8) {
            switch (action) {
                case 1: {
                    VScroller.localManager.up();
                    break;
                }
                case 6: {
                    VScroller.localManager.down();
                    break;
                }
                case 8: {
                    state = 7;
                }
            }
            this.repaint();
        } else if (state == 10) {
            switch (action) {
                case 1: {
                    VScroller.globalManager.up();
                    break;
                }
                case 6: {
                    VScroller.globalManager.down();
                    break;
                }
                case 8: {
                    state = 7;
                }
            }
            this.repaint();
        } else if (state == 12) {
            state = 7;
            this.repaint();
        } else if (state == 9 || state == 14) {
            VScroller.globalManager.stop();
            this.repaint();
            this.serviceRepaints();
            state = 13;
        } else if (state == 13 || state == 15) {
            state = 7;
            this.repaint();
        } else if (state == 16) {
            state = 6;
            this.stopThread();
            this.repaint();
        }
    }

    public void run() {
        Thread thisThread = Thread.currentThread();
        while (this.runner == thisThread) {
            this.repaint();
            if ((long)60 - this.paintDuration <= (long)0) continue;
            try {
                Thread.sleep((long)60 - this.paintDuration);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void paint(Graphics g) {
        g = this.paintBegin(g);
        this.paintDuration = System.currentTimeMillis();
        switch (state) {
            case 17: {
                g.setColor(5330069);
                if (frameImage != null) {
                    g.fillRect(0, 0, 128, frameImage.getHeight());
                } else {
                    g.fillRect(0, 0, 128, 160);
                }
                g.setColor(0xFFFFFF);
                g.setFont(Config.MENU_HEADLINE_FONT);
                g.drawString("Loading..", 64, 80, 17);
                if (frameImage == null) break;
                g.drawImage(frameImage, 0, 0, 20);
                break;
            }
            case 16: {
                g.setColor(5330069);
                if (frameImage != null) {
                    g.fillRect(0, 0, 128, frameImage.getHeight());
                } else {
                    g.fillRect(0, 0, 128, 160);
                }
                g.setColor(0xFFFFFF);
                g.setFont(Config.MENU_FONT);
                this.st.paint(g);
                g.drawImage(frameImage, 0, 0, 20);
                break;
            }
            case 9: 
            case 13: 
            case 14: 
            case 15: {
                g.setFont(Config.MENU_HEADLINE_FONT);
                g.setColor(5330069);
                if (frameImage != null) {
                    g.fillRect(0, 0, 128, frameImage.getHeight());
                } else {
                    g.fillRect(0, 0, 128, 160);
                }
                g.setColor(0xFFFFFF);
                g.drawString(this.msg, 64, 80, 17);
                if (this.percent > 0 && this.percent < 100) {
                    g.drawString(String.valueOf(String.valueOf(this.percent)).concat("%"), 64, 80 + g.getFont().getHeight(), 17);
                }
                g.drawImage(frameImage, 0, 0, 20);
                break;
            }
            case 12: {
                g.setFont(Config.MENU_HEADLINE_FONT);
                g.setColor(5330069);
                if (frameImage != null) {
                    g.fillRect(0, 0, 128, frameImage.getHeight());
                } else {
                    g.fillRect(0, 0, 128, 160);
                }
                g.setColor(0xFFFFFF);
                g.drawString("You take place", 64, 80 - g.getFont().getHeight(), 17);
                MenuItem.Text3D(g, Integer.toString(this.rank), 64, 80, 0xFFFFFF, 17);
                g.drawImage(frameImage, 0, 0, 20);
                break;
            }
            case 10: {
                g.setFont(Config.MENU_HEADLINE_FONT);
                g.setColor(5330069);
                if (frameImage != null) {
                    g.fillRect(0, 0, 128, frameImage.getHeight());
                } else {
                    g.fillRect(0, 0, 128, 160);
                }
                VScroller.globalManager.paint(g);
                g.drawImage(frameImage, 0, 0, 20);
                break;
            }
            case 8: {
                g.setFont(Config.MENU_HEADLINE_FONT);
                g.setColor(5330069);
                if (frameImage != null) {
                    g.fillRect(0, 0, 128, frameImage.getHeight());
                } else {
                    g.fillRect(0, 0, 128, 160);
                }
                VScroller.localManager.paint(g);
                g.drawImage(frameImage, 0, 0, 20);
                break;
            }
            case 6: {
                g.drawImage(titelImage, 0, 0, 20);
                g.drawImage(frameImage, 0, 0, 20);
                this.m.paint(g);
                break;
            }
            case 7: {
                g.drawImage(titelImage, 0, 0, 20);
                g.drawImage(frameImage, 0, 0, 20);
                this.mScore.paint(g);
                break;
            }
            case 1: 
            case 18: {
                g.drawImage(this.bgImage, 0, 0, 20);
                wall.paint(g, 118);
                if (state == 1 && !this.buggy.move(this.speed)) {
                    this.movespeed += 6 * this.speed;
                    if (this.movespeed > 400) {
                        this.movespeed = 400;
                    }
                    if (this.movespeed < 75) {
                        this.movespeed = 75;
                    }
                }
                if (state == 1 && this.buggy.state != 2) {
                    wall.move(this.movespeed);
                }
                this.buggy.paint(g);
                score.paint(g, 0, 0);
                lives.paint(g, 128 - Displayable.lives.image.getHeight(), 0);
                enemy.paint(g);
                enemy.move(-20);
                g.setClip(0, 0, 128, 160);
                this.weg.paint(g, 0, 160 - this.weg.panelImage.getHeight(), this.actualWegWidth * 100 / this.wegWidth);
                if (state != 18) break;
                this.mGame.paint(g);
                break;
            }
            case 2: {
                g.drawImage(this.bgImage, 0, 0, 20);
                wall.paint(g, 118);
                if (!this.buggy.move(this.lastmove)) {
                    state = 3;
                    try {
                        panelImage = Image.createImage((String)"/finish.png");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    ConfigSound.soundNextLevel();
                }
                this.buggy.paint(g);
                score.paint(g, 0, 0);
                lives.paint(g, 128 - Displayable.lives.image.getHeight(), 0);
                this.weg.paint(g, 0, 160 - this.weg.panelImage.getHeight(), this.actualWegWidth * 100 / this.wegWidth);
                enemy.paint(g);
                enemy.move(-25);
                break;
            }
            case 3: 
            case 4: {
                g.drawImage(this.bgImage, 0, 0, 20);
                wall.paint(g, 118);
                g.drawImage(panelImage, 64, 80, 3);
                this.buggy.paint(g);
                score.paint(g, 0, 0);
                lives.paint(g, 128 - Displayable.lives.image.getHeight(), 0);
                this.weg.paint(g, 0, 160 - this.weg.panelImage.getHeight(), this.actualWegWidth * 100 / this.wegWidth);
                enemy.paint(g);
                enemy.move(-25);
                break;
            }
            case 5: {
                g.drawImage(this.bgImage, 0, 0, 20);
                wall.paint(g, 118);
                g.setFont(Config.MENU_HEADLINE_FONT);
                MenuItem.Text3D(g, "Press Fire (5)", 64, 80, 0xFF0000, 17);
                this.buggy.paint(g);
                score.paint(g, 0, 0);
                lives.paint(g, 128 - Displayable.lives.image.getHeight(), 0);
                this.weg.paint(g, 0, 160 - this.weg.panelImage.getHeight(), this.actualWegWidth * 100 / this.wegWidth);
                enemy.paint(g);
                enemy.move(-25);
                break;
            }
        }
        repaintStart = Displayable.score.image.getHeight();
        repaintStop = 160 - repaintStart;
        this.paintDuration = System.currentTimeMillis() - this.paintDuration;
        this.paintEnde(g);
    }

    public void moved(int w) {
        int rx;
        this.buggy.tick(w);
        this.buggy.hitObstacle(wall);
        this.actualWegWidth += w;
        this.lastmove = w;
        if (enemy.isVisible()) {
            if (Displayable.enemy.x > 64 && Displayable.enemy.x < 128 - Displayable.enemy.width && this.buggy.state != 2) {
                enemy.throwBomb();
            }
        } else if (ConfigGeneric.ENEMY_POSSIBILITY[this.level % ConfigGeneric.wegOrder.length] != -1 && (rx = (random.nextInt() >>> 1) % ConfigGeneric.ENEMY_POSSIBILITY[this.level % ConfigGeneric.wegOrder.length]) == 42) {
            Displayable.enemy.x = 128;
            enemy.setVisible(true);
        }
        enemy.tick(w);
    }

    public void finished(Scroll w) {
        if (state == 1) {
            state = 2;
        }
    }

    public void addScore(int s) {
        Displayable.score.value += s;
        repaintStart = 0;
        repaintStop = 160;
    }

    public void decLives() {
        --Displayable.lives.value;
        repaintStart = 0;
        repaintStop = 160;
    }

    public int getLives() {
        return Displayable.lives.value;
    }

    public void select(MenuItem mi) {
        if (mi == this.scores) {
            state = 7;
            this.m.setVisible(false);
            this.mScore.setVisible(true);
        } else if (mi == this.back) {
            state = 6;
            this.m.setVisible(true);
            this.mScore.setVisible(false);
        } else if (mi == this.local) {
            state = 8;
            this.mScore.setVisible(false);
            ConfigSound.soundFoundElement();
        } else if (mi == this.global) {
            state = 9;
            this.mScore.setVisible(false);
            VScroller.globalManager.get("ChristmasRallye", 10);
        } else if (mi == this.submit) {
            state = 14;
            this.mScore.setVisible(false);
            VScroller.globalManager.submit("ChristmasRallye");
        } else if (mi == this.help) {
            state = 16;
            this.st.reset();
            this.startThread();
        } else if (mi == this.start) {
            ConfigSound.stopTitel();
            state = 17;
            this.repaint();
            this.serviceRepaints();
            titelImage = null;
            frameImage = null;
            Config.waitGC();
            this.initGame();
            state = 1;
            this.startThread();
        } else if (mi == this.cont) {
            state = 1;
            this.addPauseButton();
            this.startThread();
        } else if (mi == this.gexit) {
            state = 17;
            this.stopThread();
            this.repaint();
            this.serviceRepaints();
            this.bgImage = null;
            Config.waitGC();
            this.endGame();
        } else if (mi == this.exit) {
            VScroller.quitApp();
        }
        this.repaint();
    }

    public void endGame() {
        this.removePauseButton();
        this.rank = VScroller.localScoreList.inList(Displayable.score.value);
        ConfigSound.startTitel();
        if (this.rank != -1) {
            try {
                panelImage = Image.createImage((String)"/name.png");
                NameDisplayable nd = new NameDisplayable(panelImage, this.rank, Displayable.score.value);
                VScroller.display.setCurrent((javax.microedition.lcdui.Displayable)nd);
            }
            catch (IOException iox) {
                iox.printStackTrace();
            }
        } else {
            this.initMenu();
            state = 6;
            this.repaint();
            this.serviceRepaints();
        }
    }

    public void setPercent(int i) {
        this.percent = i;
        this.repaint();
        this.serviceRepaints();
    }

    public void globalList(ScoreList sl, int type) {
        if (sl != null) {
            VScroller.globalManager.setScoreListe(sl);
            state = 10;
        } else {
            state = 13;
        }
        this.repaint();
        this.serviceRepaints();
        ConfigSound.soundFoundElement();
    }

    public void submitFinished(int r) {
        if (r != -1) {
            state = 12;
            this.rank = r;
            this.repaint();
            this.serviceRepaints();
        } else {
            state = 15;
        }
        ConfigSound.soundFoundElement();
    }

    public void globalMessage(String s) {
        this.msg = s;
        this.repaint();
        this.serviceRepaints();
    }

    public void scrollFinished(ScrollText st) {
        state = 6;
        this.stopThread();
        this.repaint();
        this.serviceRepaints();
    }

    static {
        PLAY = 1;
        DISAPPEAR = 2;
        FINISHED = 3;
        GAME_OVER = 4;
        LOST_LIVE = 5;
        MAIN = 6;
        SCORES = 7;
        DISPLAY_LOCAL = 8;
        LOAD_GLOBAL = 9;
        DISPLAY_GLOBAL = 10;
        SUBMIT_FINISHED = 12;
        LOAD_ERROR = 13;
        SUBMIT_START = 14;
        SUBMIT_ERROR = 15;
        HELP = 16;
        WAIT = 17;
        GMENU = 18;
        random = new Random();
        repaintStart = 0;
        repaintStop = 160;
    }
}

