/*
 * Decompiled with CFR 0.152.
 */
package vscroller;

import de.tuttas.GameAPI.FragmentImage;
import de.tuttas.GameAPI.Winkel;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import vscroller.WheelListener;

public class Wheel {
    public static FragmentImage fi;
    static int width;
    static int height;
    WheelListener listener;
    int w;
    int index;
    int x;
    int y;
    boolean explode;
    int ex;
    int startX;
    int startY;
    int tickFactor;
    boolean visible;

    public Wheel(int xPos, int yPos) {
        if (fi == null) {
            try {
                fi = new FragmentImage(Image.createImage((String)"/wheel.png"));
                height = width = Wheel.fi.largeImage.getHeight();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.x = xPos;
        this.y = yPos;
        this.startX = xPos;
        this.startY = yPos;
        this.visible = true;
    }

    public void reset() {
        this.x = this.startX;
        this.y = this.startY;
        this.index = 0;
        this.explode = false;
        this.ex = 0;
        this.w = 30;
        this.tickFactor = 5;
        this.visible = true;
    }

    public void setListener(WheelListener l) {
        this.listener = l;
    }

    public void setVisible(boolean v) {
        this.visible = v;
    }

    public void paint(Graphics g) {
        if (!this.visible) {
            return;
        }
        fi.paint(g, this.x, this.y, this.index, 0, width, height);
        if (this.explode) {
            this.x += this.ex;
            this.y -= 3 * Winkel.sin(this.w) / 1000;
            if (this.w < 270) {
                this.w += 10;
            }
            if (this.x < -width || this.x > 128 || this.y > 160) {
                this.listener.explosionFinished(this);
            }
            ++this.index;
            if (this.index >= Wheel.fi.largeImage.getWidth() / width) {
                this.index = this.index % Wheel.fi.largeImage.getWidth() / width;
            }
        }
    }

    public void tick(int dt) {
        if (dt == 0) {
            return;
        }
        this.tickFactor -= Math.abs(dt);
        if (this.tickFactor <= 0) {
            this.tickFactor = 4;
            this.index = dt > 0 ? ++this.index : --this.index;
            if (this.index >= Wheel.fi.largeImage.getWidth() / width) {
                this.index = this.index % Wheel.fi.largeImage.getWidth() / width;
            } else if (this.index < 0) {
                this.index = Wheel.fi.largeImage.getWidth() / width - this.index % Wheel.fi.largeImage.getWidth() / width;
            }
        }
    }

    public void explode(int m) {
        this.explode = true;
        this.ex = m;
    }
}

