/*
 * Decompiled with CFR 0.152.
 */
package vscroller;

import de.tuttas.GameAPI.FragmentImage;
import de.tuttas.GameAPI.Scroll;
import de.tuttas.GameAPI.Winkel;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import vscroller.ConfigSound;
import vscroller.Displayable;
import vscroller.Explosion;
import vscroller.ExplosionListener;
import vscroller.Fire;
import vscroller.FireListener;
import vscroller.VScroller;
import vscroller.Wheel;
import vscroller.WheelListener;

public class Buggy
implements WheelListener,
FireListener,
ExplosionListener {
    public static final int MOVING = 1;
    public static final int DEMAGE = 2;
    public static final int JUMP = 3;
    int state = 1;
    static Random random;
    Wheel w1;
    Wheel w2;
    FragmentImage car;
    int x;
    int y;
    int width;
    int height;
    int ruckelOffset;
    int winkel;
    int aktY;
    int xStart;
    Vector fireVector;
    Fire tmpFire;
    Explosion explosion;

    public Buggy(int xPos, int yPos) {
        this.xStart = this.x = xPos;
        this.y = yPos;
        this.fireVector = new Vector();
        try {
            this.car = new FragmentImage(Image.createImage((String)"/buggy.png"));
            this.width = this.car.largeImage.getWidth() / 2;
            this.height = this.car.largeImage.getHeight();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.w1 = new Wheel(xPos, yPos + this.height);
        this.w2 = new Wheel(xPos + this.width, yPos + this.height);
        this.w1.setListener(this);
        this.w2.setListener(this);
        this.explosion = new Explosion(2, 2);
        this.explosion.setListener(this);
    }

    public void fire() {
        if (this.fireVector.size() <= 4 && this.state != 2) {
            this.tmpFire = new Fire(0);
            this.tmpFire.setPos(this.x + this.width, this.aktY + this.height / 2);
            this.tmpFire.setVisible(true);
            this.tmpFire.setListener(this);
            this.fireVector.addElement(this.tmpFire);
            this.tmpFire = new Fire(1);
            this.tmpFire.setPos(this.x + this.width / 2, this.aktY);
            this.tmpFire.setVisible(true);
            this.tmpFire.setListener(this);
            this.fireVector.addElement(this.tmpFire);
        }
    }

    public boolean move(int dx) {
        if (this.state == 2) {
            return true;
        }
        this.x += dx;
        if (this.x < 0) {
            this.x = 0;
            return false;
        }
        if (Displayable.state == 1) {
            if (this.x + this.width > 128 - this.width) {
                this.x = 128 - 2 * this.width;
                return false;
            }
            this.w1.tick(dx);
            this.w2.tick(dx);
            return true;
        }
        return this.x <= 128;
    }

    public void reset() {
        this.state = 1;
        this.w1.reset();
        this.w2.reset();
        this.fireVector = new Vector();
        this.x = this.xStart;
    }

    public void paint(Graphics g) {
        this.aktY = this.y + this.ruckelOffset;
        switch (this.state) {
            case 1: {
                this.car.paint(g, this.x, this.aktY, 0, 0, this.width, this.height);
                break;
            }
            case 2: {
                this.aktY = this.y + this.height / 3;
                this.car.paint(g, this.x + this.width / 2, this.aktY, 1, 0, this.width, this.height);
                this.explosion.paint(g);
                break;
            }
            case 3: {
                this.aktY = this.y - this.height * Winkel.sin(this.winkel) / 1000;
                this.car.paint(g, this.x, this.aktY, 0, 0, this.width, this.height);
                this.winkel += 10;
                if (this.winkel < 180) break;
                this.state = 1;
            }
        }
        if (!this.w1.explode) {
            this.w1.x = this.x - this.ruckelOffset + 3;
            this.w1.y = this.aktY - this.ruckelOffset + 9;
        }
        if (!this.w2.explode) {
            this.w2.x = this.x + this.ruckelOffset + 21;
            this.w2.y = this.aktY - this.ruckelOffset + 9;
        }
        this.w1.paint(g);
        this.w2.paint(g);
        for (int i = 0; i < this.fireVector.size(); ++i) {
            this.tmpFire = (Fire)this.fireVector.elementAt(i);
            this.tmpFire.paint(g);
            if (Displayable.enemy.isVisible() && this.tmpFire.hit(Displayable.enemy)) {
                Displayable.enemy.explode();
            }
            this.tmpFire.move(8);
        }
    }

    public boolean hitObstacle(Scroll sc) {
        for (int i = 0; i < this.fireVector.size(); ++i) {
            this.tmpFire = (Fire)this.fireVector.elementAt(i);
            if (this.tmpFire.index != 0 || !this.tmpFire.hitObstacle(sc)) continue;
            ConfigSound.soundExplode();
            return true;
        }
        if (this.state == 1) {
            switch (sc.getID(this.x + 21)) {
                case 4: {
                    sc.setID(0, this.x + 21);
                    VScroller.displayable.addScore(5);
                    ConfigSound.soundFoundElement();
                    break;
                }
                case 6: {
                    sc.setID(1, this.x + 21);
                    VScroller.displayable.addScore(3);
                    ConfigSound.soundFoundElement();
                    break;
                }
                case 5: {
                    sc.setID(2, this.x + 21);
                }
                case 2: 
                case 3: 
                case 7: {
                    this.crashed();
                    return true;
                }
            }
            switch (sc.getID(this.x + 3 + Wheel.width)) {
                case 5: {
                    sc.setID(2, this.x + 3 + Wheel.width);
                }
                case 2: 
                case 3: 
                case 7: {
                    this.crashed();
                    return true;
                }
            }
        }
        return false;
    }

    public void jump() {
        if (this.state == 1) {
            this.state = 3;
            this.winkel = 0;
        }
    }

    public void tick(int d) {
        for (int i = 0; i < this.fireVector.size(); ++i) {
            this.tmpFire = (Fire)this.fireVector.elementAt(i);
            this.tmpFire.tick(d);
        }
        this.w1.tick(d);
        this.w2.tick(d);
        int rx = (random.nextInt() >>> 1) % 100;
        this.ruckelOffset = rx < 10 ? 1 : (rx < 20 ? -1 : 0);
    }

    public void crashed() {
        this.state = 2;
        this.w1.explode(-1);
        this.w2.explode(1);
        this.w1.x = this.x + 3;
        this.w2.x = this.x + 21;
        this.w1.y = this.y + 9;
        this.w2.y = this.y + 9;
        this.explosion.start(2, this.x + this.width / 2, this.y + this.height / 2);
        VScroller.displayable.decLives();
        if (VScroller.displayable.getLives() == 0) {
            Displayable.state = 4;
            ConfigSound.soundGameOver();
            try {
                Displayable.panelImage = Image.createImage((String)"/gameover.png");
            }
            catch (IOException iOException) {}
        } else {
            ConfigSound.soundCrashed();
        }
    }

    public void explosionFinished(Wheel w) {
        w.setVisible(false);
        if (!this.w1.visible && !this.w2.visible && Displayable.state != 4) {
            Displayable.state = 5;
        }
    }

    public void explosionFinished(Explosion ex) {
        this.explosion.setVisible(false);
    }

    public void disappear(Fire f) {
        this.fireVector.removeElement(f);
    }

    static {
        MOVING = 1;
        DEMAGE = 2;
        JUMP = 3;
        random = new Random();
    }
}

